/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Normalize the grayscale values for a source image by matching the
shape of the source image histogram to a reference histogram.


HistogramMatchingImageFilter normalizes the grayscale values of a source image based on the
grayscale values of either a reference image or a reference histogram.
This filter uses a histogram matching technique where the histograms
of the are matched only at a specified number of quantile values.

This filter was originally designed to normalize MR images of the same
MR protocol and same body part. The algorithm works best if background
pixels are excluded from both the source and reference histograms. A
simple background exclusion method is to exclude all pixels whose
grayscale values are smaller than the mean grayscale value. ThresholdAtMeanIntensityOn() switches on this simple background exclusion method. With ThresholdAtMeanIntensityOn() , The reference histogram returned from this filter will expand the
first and last bin bounds to include the minimum and maximum intensity
values of the entire reference image, but only intensity values
greater than the mean will be used to populate the histogram.

The source image can be set via either SetInput() or SetSourceImage().
The reference object used is selected with can be set via
SetReferenceImage() or SetReferenceHistogram().

SetNumberOfHistogramLevels() sets the number of bins used when creating histograms of the source
and reference images. SetNumberOfMatchPoints() governs the number of quantile values to be matched.

This filter assumes that both the source and reference are of the same
type and that the input and output image type have the same number of
dimension and have scalar pixel types.

REFERENCE
Laszlo G. Nyul, Jayaram K. Udupa, and Xuan Zhang, "New Variants of a
Method of MRI Scale Standardization", IEEE Transactions on Medical
Imaging, 19(2):143-150, 2000.

See:
 itk::simple::HistogramMatching for the procedural interface

 itk::HistogramMatchingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkHistogramMatchingImageFilter.h
*/
public class HistogramMatchingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected HistogramMatchingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.HistogramMatchingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(HistogramMatchingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(HistogramMatchingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::HistogramMatchingImageFilter::~HistogramMatchingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_HistogramMatchingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::HistogramMatchingImageFilter::HistogramMatchingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  HistogramMatchingImageFilter() {
    this(SimpleITKJNI.new_HistogramMatchingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::HistogramMatchingImageFilter::SetNumberOfHistogramLevels(uint32_t NumberOfHistogramLevels)

Set/Get the number of histogram levels used.

*/
public  void setNumberOfHistogramLevels(long NumberOfHistogramLevels) {
    SimpleITKJNI.HistogramMatchingImageFilter_setNumberOfHistogramLevels(swigCPtr, this, NumberOfHistogramLevels);
  }

  /**
uint32_t itk::simple::HistogramMatchingImageFilter::GetNumberOfHistogramLevels() const

Set/Get the number of histogram levels used.

*/
public  long getNumberOfHistogramLevels() {
    return SimpleITKJNI.HistogramMatchingImageFilter_getNumberOfHistogramLevels(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HistogramMatchingImageFilter::SetNumberOfMatchPoints(uint32_t NumberOfMatchPoints)

Set/Get the number of match points used.

*/
public  void setNumberOfMatchPoints(long NumberOfMatchPoints) {
    SimpleITKJNI.HistogramMatchingImageFilter_setNumberOfMatchPoints(swigCPtr, this, NumberOfMatchPoints);
  }

  /**
uint32_t itk::simple::HistogramMatchingImageFilter::GetNumberOfMatchPoints() const

Set/Get the number of match points used.

*/
public  long getNumberOfMatchPoints() {
    return SimpleITKJNI.HistogramMatchingImageFilter_getNumberOfMatchPoints(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HistogramMatchingImageFilter::SetThresholdAtMeanIntensity(bool ThresholdAtMeanIntensity)

Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.

*/
public  void setThresholdAtMeanIntensity(boolean ThresholdAtMeanIntensity) {
    SimpleITKJNI.HistogramMatchingImageFilter_setThresholdAtMeanIntensity(swigCPtr, this, ThresholdAtMeanIntensity);
  }

  /**
Self&amp; itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOn()

Set the value of ThresholdAtMeanIntensity to true or false
respectfully.

*/
public  void thresholdAtMeanIntensityOn() {
    SimpleITKJNI.HistogramMatchingImageFilter_thresholdAtMeanIntensityOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::HistogramMatchingImageFilter::ThresholdAtMeanIntensityOff()
*/
public  void thresholdAtMeanIntensityOff() {
    SimpleITKJNI.HistogramMatchingImageFilter_thresholdAtMeanIntensityOff(swigCPtr, this);
  }

  /**
bool itk::simple::HistogramMatchingImageFilter::GetThresholdAtMeanIntensity() const

Set/Get the threshold at mean intensity flag. If true, only source
(reference) pixels which are greater than the mean source (reference)
intensity is used in the histogram matching. If false, all pixels are
used.

*/
public  boolean getThresholdAtMeanIntensity() {
    return SimpleITKJNI.HistogramMatchingImageFilter_getThresholdAtMeanIntensity(swigCPtr, this);
  }

  /**
std::string itk::simple::HistogramMatchingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.HistogramMatchingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::HistogramMatchingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.HistogramMatchingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::HistogramMatchingImageFilter::Execute(const Image &amp;image, const Image &amp;referenceImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image referenceImage) {
    return new Image(SimpleITKJNI.HistogramMatchingImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(referenceImage), referenceImage), true);
  }

}
