/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.component.ResolutionBackedVariant;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.DependencyCoordinateResolverFactory;
import org.gradle.api.publish.internal.mapping.ResolutionBackedPublicationDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.mapping.VersionMappingComponentDependencyResolver;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultDependencyCoordinateResolverFactory
implements DependencyCoordinateResolverFactory {
    private static final boolean USE_LEGACY_VERSION_MAPPING = true;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final AttributeDesugaring attributeDesugaring;

    @Inject
    public DefaultDependencyCoordinateResolverFactory(ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeDesugaring attributeDesugaring) {
        this.projectDependencyResolver = projectDependencyResolver;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributeDesugaring = attributeDesugaring;
    }

    @Override
    public Provider<DependencyCoordinateResolverFactory.DependencyResolvers> createCoordinateResolvers(SoftwareComponentVariant variant, VersionMappingStrategyInternal versionMappingStrategy) {
        Configuration configuration = null;
        if (variant instanceof ResolutionBackedVariant) {
            ResolutionBackedVariant resolutionBackedVariant = (ResolutionBackedVariant)variant;
            configuration = resolutionBackedVariant.getResolutionConfiguration();
            if (resolutionBackedVariant.getPublishResolvedCoordinates()) {
                if (configuration == null) {
                    throw new InvalidUserDataException("Cannot enable dependency mapping without configuring a resolution configuration.");
                }
                return this.getDependencyMappingResolver(configuration);
            }
        }
        ImmutableAttributes attributes = ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
        VariantVersionMappingStrategyInternal versionMapping = versionMappingStrategy.findStrategyForVariant(attributes);
        Provider<ComponentDependencyResolver> componentResolver = null;
        if (versionMapping.isEnabled()) {
            if (versionMapping.getUserResolutionConfiguration() != null) {
                configuration = versionMapping.getUserResolutionConfiguration();
            } else if (versionMapping.getDefaultResolutionConfiguration() != null && configuration == null) {
                configuration = versionMapping.getDefaultResolutionConfiguration();
            }
            if (configuration != null) {
                componentResolver = this.getLegacyResolver(configuration);
            }
        }
        if (componentResolver == null) {
            componentResolver = Providers.of((Object)new ProjectOnlyComponentDependencyResolver(this.projectDependencyResolver));
        }
        return componentResolver.map(cr -> new DependencyCoordinateResolverFactory.DependencyResolvers(new VariantResolverAdapter((ComponentDependencyResolver)cr), (ComponentDependencyResolver)cr));
    }

    private Provider<DependencyCoordinateResolverFactory.DependencyResolvers> getDependencyMappingResolver(Configuration configuration) {
        ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
        return resolutionResult.getRootComponent().zip(resolutionResult.getRootVariant(), this::getVariantMappingResolvers);
    }

    private DependencyCoordinateResolverFactory.DependencyResolvers getVariantMappingResolvers(ResolvedComponentResult rootComponent, ResolvedVariantResult rootVariant) {
        ResolutionBackedPublicationDependencyResolver resolver = new ResolutionBackedPublicationDependencyResolver(this.projectDependencyResolver, this.moduleIdentifierFactory, rootComponent, rootVariant, this.attributeDesugaring);
        return new DependencyCoordinateResolverFactory.DependencyResolvers(resolver, resolver);
    }

    private Provider<ComponentDependencyResolver> getLegacyResolver(Configuration configuration) {
        return configuration.getIncoming().getResolutionResult().getRootComponent().map(root -> new VersionMappingComponentDependencyResolver(this.projectDependencyResolver, (ResolvedComponentResult)root));
    }

    @VisibleForTesting
    static class ProjectOnlyComponentDependencyResolver
    implements ComponentDependencyResolver {
        private final ProjectDependencyPublicationResolver projectDependencyResolver;

        public ProjectOnlyComponentDependencyResolver(ProjectDependencyPublicationResolver projectDependencyResolver) {
            this.projectDependencyResolver = projectDependencyResolver;
        }

        @Override
        public @Nullable ResolvedCoordinates resolveComponentCoordinates(ExternalDependency dependency) {
            return null;
        }

        @Override
        public ResolvedCoordinates resolveComponentCoordinates(ProjectDependency dependency) {
            Path identityPath = ((ProjectDependencyInternal)dependency).getTargetProjectIdentity().getBuildTreePath();
            return ResolvedCoordinates.create((ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath));
        }

        @Override
        public @Nullable ResolvedCoordinates resolveComponentCoordinates(DependencyConstraint dependency) {
            return null;
        }

        @Override
        public ResolvedCoordinates resolveComponentCoordinates(DefaultProjectDependencyConstraint dependency) {
            return this.resolveComponentCoordinates(dependency.getProjectDependency());
        }
    }

    private static class VariantResolverAdapter
    implements VariantDependencyResolver {
        private final ComponentDependencyResolver delegate;

        public VariantResolverAdapter(ComponentDependencyResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public @Nullable ResolvedCoordinates resolveVariantCoordinates(ExternalDependency dependency, VariantWarningCollector warnings) {
            return this.delegate.resolveComponentCoordinates(dependency);
        }

        @Override
        public ResolvedCoordinates resolveVariantCoordinates(ProjectDependency dependency, VariantWarningCollector warnings) {
            return this.delegate.resolveComponentCoordinates(dependency);
        }
    }
}

