//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `FileParser.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICEGRID_API_EXPORTS
#   define ICEGRID_API_EXPORTS
#endif
#include <IceGrid/FileParser.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceGrid::ParseException> iceC_IceGrid_ParseException_init("::IceGrid::ParseException");

const ::std::string iceC_IceGrid_FileParser_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileParser"
};
const ::std::string iceC_IceGrid_FileParser_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "parse"
};
const ::std::string iceC_IceGrid_FileParser_parse_name = "parse";

}

IceGrid::ParseException::~ParseException()
{
}

const ::std::string&
IceGrid::ParseException::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ParseException";
    return typeId;
}

bool
IceGrid::FileParser::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileParser_ids, iceC_IceGrid_FileParser_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::FileParser::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_FileParser_ids[0], &iceC_IceGrid_FileParser_ids[2]);
}

::std::string
IceGrid::FileParser::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileParser::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::FileParser";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::FileParser::_iceD_parse(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_xmlFile;
    ::std::shared_ptr<AdminPrx> iceP_adminProxy;
    istr->readAll(iceP_xmlFile, iceP_adminProxy);
    inS.endReadParams();
    ApplicationDescriptor ret = this->parse(::std::move(iceP_xmlFile), ::std::move(iceP_adminProxy), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileParser::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileParser_ops, iceC_IceGrid_FileParser_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileParser_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_parse(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::FileParserPrx::_iceI_parse(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>& outAsync, const ::std::string& iceP_xmlFile, const ::std::shared_ptr<AdminPrx>& iceP_adminProxy, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_FileParser_parse_name);
    outAsync->invoke(iceC_IceGrid_FileParser_parse_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_xmlFile, iceP_adminProxy);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ParseException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            ApplicationDescriptor ret;
            istr->readAll(ret);
            istr->readPendingValues();
            return ret;
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::FileParserPrx::_newInstance() const
{
    return ::IceInternal::createProxy<FileParserPrx>();
}
/// \endcond

const ::std::string&
IceGrid::FileParserPrx::ice_staticId()
{
    return FileParser::ice_staticId();
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceGrid_FileParser_parse_name = "parse";

}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceGrid::ParseException> iceC_IceGrid_ParseException_init("::IceGrid::ParseException");

}

IceGrid::ParseException::ParseException(const ::std::string& reason) :
    ::Ice::UserException(),
    reason(reason)
{
}

#ifdef ICE_CPP11_COMPILER
IceGrid::ParseException::~ParseException()
{
}
#else
IceGrid::ParseException::~ParseException() throw()
{
}
#endif

::std::string
IceGrid::ParseException::ice_id() const
{
    return "::IceGrid::ParseException";
}

IceGrid::ParseException*
IceGrid::ParseException::ice_clone() const
{
    return new ParseException(*this);
}

void
IceGrid::ParseException::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceGrid::ParseException::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceGrid::ParseException", -1, true);
    ::Ice::StreamWriter< ParseException, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ParseException::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ParseException, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(FileParser* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< FileParser>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new FileParser;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::FileParser::_iceI_begin_parse(const ::std::string& iceP_xmlFile, const ::IceGrid::AdminPrx& iceP_adminProxy, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_FileParser_parse_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_FileParser_parse_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_FileParser_parse_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_xmlFile);
        ostr->write(iceP_adminProxy);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_FileParser_parse_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ApplicationDescriptor
IceProxy::IceGrid::FileParser::end_parse(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileParser_parse_name);
    ::IceGrid::ApplicationDescriptor ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ParseException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::FileParser::_newInstance() const
{
    return new FileParser;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::FileParser::ice_staticId()
{
    return ::IceGrid::FileParser::ice_staticId();
}

IceGrid::FileParser::~FileParser()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(FileParser* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileParser_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileParser"
};

}

bool
IceGrid::FileParser::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileParser_ids, iceC_IceGrid_FileParser_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::FileParser::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_FileParser_ids[0], &iceC_IceGrid_FileParser_ids[2]);
}

const ::std::string&
IceGrid::FileParser::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileParser::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::FileParser";
    return typeId;
#else
    return iceC_IceGrid_FileParser_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::FileParser::_iceD_parse(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_xmlFile;
    AdminPrx iceP_adminProxy;
    istr->read(iceP_xmlFile);
    istr->read(iceP_adminProxy);
    inS.endReadParams();
    ApplicationDescriptor ret = this->parse(iceP_xmlFile, iceP_adminProxy, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileParser_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "parse"
};

}

/// \cond INTERNAL
bool
IceGrid::FileParser::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileParser_all, iceC_IceGrid_FileParser_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileParser_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_parse(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::FileParser::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< FileParser, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::FileParser::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileParser, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(FileParserPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = FileParserPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(FileParser::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
