/* index.c generated by valac 0.56.17, the Vala compiler
 * generated from index.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2010-2012 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *  Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist.h"
#include <glib-object.h>
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_INDEX_0_PROPERTY,
	ZEITGEIST_INDEX_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_index_properties[ZEITGEIST_INDEX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ZeitgeistIndexSearchData ZeitgeistIndexSearchData;
typedef struct _ZeitgeistIndexSearchWithRelevanciesData ZeitgeistIndexSearchWithRelevanciesData;

struct _ZeitgeistIndexPrivate {
	ZeitgeistRemoteSimpleIndexer* proxy;
};

struct _ZeitgeistIndexSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistIndex* self;
	gchar* query;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	guint32 offset;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	ZeitgeistResultSet* result;
	GPtrArray* event_templates_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	GVariant* _result_;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GPtrArray* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	guint _tmp15_;
	GPtrArray* _tmp16_;
	GVariant* _tmp17_;
	GPtrArray* _tmp18_;
	ZeitgeistSimpleResultSet* _tmp19_;
	GError* _inner_error0_;
};

struct _ZeitgeistIndexSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistIndex* self;
	gchar* query;
	ZeitgeistTimeRange* time_range;
	GPtrArray* event_templates;
	ZeitgeistStorageState storage_state;
	guint32 offset;
	guint32 num_events;
	ZeitgeistResultType result_type;
	GCancellable* cancellable;
	gdouble* relevancies;
	gint relevancies_length1;
	ZeitgeistResultSet* result;
	GPtrArray* event_templates_cp;
	GPtrArray* _tmp0_;
	gint i;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ZeitgeistEvent* _tmp7_;
	GVariant* _result_;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GPtrArray* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	gdouble* _tmp15_;
	gint _tmp16_;
	guint _tmp17_;
	GPtrArray* _tmp18_;
	GVariant* _tmp19_;
	GPtrArray* _tmp20_;
	ZeitgeistSimpleResultSet* _tmp21_;
	GError* _inner_error0_;
};

static gint ZeitgeistIndex_private_offset;
static gpointer zeitgeist_index_parent_class = NULL;

static void __lambda8_ (ZeitgeistIndex* self,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void zeitgeist_index_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_index_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base);
static void zeitgeist_index_search_data_free (gpointer _data);
static gboolean zeitgeist_index_search_co (ZeitgeistIndexSearchData* _data_);
static void _g_object_unref0_ (gpointer var);
static void zeitgeist_index_search_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void zeitgeist_index_search_with_relevancies_data_free (gpointer _data);
static gboolean zeitgeist_index_search_with_relevancies_co (ZeitgeistIndexSearchWithRelevanciesData* _data_);
static void zeitgeist_index_search_with_relevancies_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void zeitgeist_index_finalize (GObject * obj);
static GType zeitgeist_index_get_type_once (void);

static inline gpointer
zeitgeist_index_get_instance_private (ZeitgeistIndex* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistIndex_private_offset);
}

/**
     * Create a new index that interfaces with the default event index of the
     * Zeitgeist daemon.
     *
     * Create a new {@link Index} instance. The index will start to connect
     * to Zeitgeist asynchronously. You can however start calling methods on
     * the returned instance immediately, any method calls issued before the
     * connection has been established will simply be queued and executed once
     * the connection is up.
     *
     * Returns: A reference to a newly allocated index. Free with g_object_unref().
     */
static void
__lambda8_ (ZeitgeistIndex* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ZeitgeistRemoteSimpleIndexer* _tmp0_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp1_;
		ZeitgeistRemoteSimpleIndexer* _tmp2_;
		ZeitgeistRemoteSimpleIndexer* _tmp3_;
		ZeitgeistRemoteSimpleIndexer* _tmp4_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (ZeitgeistRemoteSimpleIndexer*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (ZeitgeistRemoteSimpleIndexer*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp3_;
		_tmp4_ = self->priv->proxy;
		zeitgeist_queued_proxy_wrapper_proxy_acquired ((ZeitgeistQueuedProxyWrapper*) self, (GObject*) _tmp4_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_critical ("index.vala:61: Unable to connect to Zeitgeist FTS: %s", _tmp6_);
		_tmp7_ = err;
		zeitgeist_queued_proxy_wrapper_proxy_unavailable ((ZeitgeistQueuedProxyWrapper*) self, _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ ((ZeitgeistIndex*) self, source_object, res);
	g_object_unref (self);
}

ZeitgeistIndex*
zeitgeist_index_construct (GType object_type)
{
	ZeitgeistIndex * self = NULL;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistIndex*) zeitgeist_queued_proxy_wrapper_construct (object_type);
	g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY, 0, NULL, ___lambda8__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", ZEITGEIST_UTILS_ENGINE_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/zeitgeist/index/activity", "g-interface-name", "org.gnome.zeitgeist.Index", NULL);
	return self;
}

ZeitgeistIndex*
zeitgeist_index_new (void)
{
	return zeitgeist_index_construct (ZEITGEIST_TYPE_INDEX);
}

static void
zeitgeist_index_real_on_connection_established (ZeitgeistQueuedProxyWrapper* base)
{
	ZeitgeistIndex * self;
	self = (ZeitgeistIndex*) base;
}

static void
zeitgeist_index_real_on_connection_lost (ZeitgeistQueuedProxyWrapper* base)
{
	ZeitgeistIndex * self;
	self = (ZeitgeistIndex*) base;
}

static void
zeitgeist_index_search_data_free (gpointer _data)
{
	ZeitgeistIndexSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->time_range);
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistIndexSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
zeitgeist_index_search (ZeitgeistIndex* self,
                        const gchar* query,
                        ZeitgeistTimeRange* time_range,
                        GPtrArray* event_templates,
                        guint32 offset,
                        guint32 num_events,
                        ZeitgeistResultType result_type,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	ZeitgeistIndexSearchData* _data_;
	ZeitgeistIndex* _tmp0_;
	gchar* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	_data_ = g_slice_new0 (ZeitgeistIndexSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_index_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_tmp2_ = _g_object_ref0 (time_range);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_ptr_array_ref0 (event_templates);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp3_;
	_data_->offset = offset;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_index_search_co (_data_);
}

ZeitgeistResultSet*
zeitgeist_index_search_finish (ZeitgeistIndex* self,
                               GAsyncResult* _res_,
                               GError** error)
{
	ZeitgeistResultSet* result;
	ZeitgeistIndexSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Perform a full text search possibly restricted to a {@link TimeRange}
     * and/or set of event templates.
     *
     * The default boolean operator is %AND. Thus the query
     * //foo bar// will be interpreted as //foo AND bar//. To exclude a term
     * from the result set prepend it with a minus sign - eg. //foo -bar//.
     * Phrase queries can be done by double quoting the string
     * //"foo is a bar"//. You can truncate terms by appending a *.
     *
     * There are a few keys you can prefix to a term or phrase to search within
     * a specific set of metadata. They are used like //key:value//. The keys
     * //name// and //title// search strictly within the text field of the
     * event subjects. The key //app// searches within the application name or
     * description that is found in the actor attribute of the events. Lastly,
     * you can use the //site// key to search within the domain name of subject
     * URIs.
     *
     * You can also control the results with the boolean operators //AND// and
     * //OR// and you may use brackets, ( and ), to control the operator
     * precedence.
     *
     * FIXME: how do we put documentation into _finish?
     * The total hit count of the query will be available via the returned
     * result set by calling zeitgeist_result_set_estimated_matches(). This will
     * often be bigger than the actual number of events held in the result set,
     * which is limited by the @num_events parameter passed to
     * zeitgeist_index_search().
     *
     * @param query The search string to send to Zeitgeist
     * @param time_range Restrict matched events to ones within this time
     *     range. If you are not interested in restricting the timerange pass
     *     zeitgeist_time_range_new_anytime() as Zeitgeist will detect
     *     this and optimize the query accordingly
     * @param event_templates Restrict matches events to ones matching these
     *     templates
     * @param offset Offset into the result set to read events from
     * @param num_events Maximal number of events to retrieve
     * @param result_type The {@link ResultType} determining the sort order.
     *     You may pass {@link ResultType.RELEVANCY} to this
     *     method to have the results ordered by relevancy calculated
     *     in relation to @query
     * @param cancellable A {@link GLib.Cancellable} used to cancel the
     *     call or %NULL
     */
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
zeitgeist_index_search_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	ZeitgeistIndexSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_index_search_co (_data_);
}

static gboolean
zeitgeist_index_search_co (ZeitgeistIndexSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->event_templates);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->event_templates_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->event_templates, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_index_search_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->proxy;
	_data_->_tmp9_ = zeitgeist_time_range_to_variant (_data_->time_range);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->event_templates_cp;
	_data_->_tmp12_ = zeitgeist_events_to_variant (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp15_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search (_data_->_tmp8_, _data_->query, _data_->_tmp10_, _data_->_tmp13_, (guint) _data_->offset, (guint) _data_->num_events, (guint) _data_->result_type, _data_->cancellable, zeitgeist_index_search_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp14_, &_data_->_tmp15_, &_data_->_inner_error0_);
	_g_variant_unref0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp14_;
	_data_->matches = _data_->_tmp15_;
	_g_variant_unref0 (_data_->_tmp13_);
	_g_variant_unref0 (_data_->_tmp10_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->_result_;
	_data_->_tmp18_ = zeitgeist_events_from_variant (_data_->_tmp17_, &_data_->_inner_error0_);
	_data_->_tmp16_ = _data_->_tmp18_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = zeitgeist_simple_result_set_new_with_num_matches (_data_->_tmp16_, _data_->matches);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp19_;
	_g_ptr_array_unref0 (_data_->_tmp16_);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_index_search_with_relevancies_data_free (gpointer _data)
{
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query);
	_g_object_unref0 (_data_->time_range);
	_g_ptr_array_unref0 (_data_->event_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistIndexSearchWithRelevanciesData, _data_);
}

void
zeitgeist_index_search_with_relevancies (ZeitgeistIndex* self,
                                         const gchar* query,
                                         ZeitgeistTimeRange* time_range,
                                         GPtrArray* event_templates,
                                         ZeitgeistStorageState storage_state,
                                         guint32 offset,
                                         guint32 num_events,
                                         ZeitgeistResultType result_type,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	ZeitgeistIndex* _tmp0_;
	gchar* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (event_templates != NULL);
	_data_ = g_slice_new0 (ZeitgeistIndexSearchWithRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_index_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query);
	_g_free0 (_data_->query);
	_data_->query = _tmp1_;
	_tmp2_ = _g_object_ref0 (time_range);
	_g_object_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_ptr_array_ref0 (event_templates);
	_g_ptr_array_unref0 (_data_->event_templates);
	_data_->event_templates = _tmp3_;
	_data_->storage_state = storage_state;
	_data_->offset = offset;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_index_search_with_relevancies_co (_data_);
}

ZeitgeistResultSet*
zeitgeist_index_search_with_relevancies_finish (ZeitgeistIndex* self,
                                                GAsyncResult* _res_,
                                                gdouble** relevancies,
                                                gint* relevancies_length1,
                                                GError** error)
{
	ZeitgeistResultSet* result;
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Perform a full text search possibly restricted to a {@link TimeRange}
     * and/or set of event templates. As opposed to zeitgeist_index_search(),
     * this call will also return numeric relevancies of the events
     * in the {@link ResultSet}.
     *
     * See zeitgeist_index_search() for more details on how to create the
     * query.
     *
     * @param query The search string to send to Zeitgeist
     * @param time_range Restrict matched events to ones within this time
     *     range. If you are not interested in restricting the timerange pass
     *     zeitgeist_time_range_new_anytime() as Zeitgeist will detect
     *     this and optimize the query accordingly
     * @param event_templates Restrict matched events to ones matching these
     *     templates
     * @param storage_state Filter the events by availability of the storage
     *     medium.
     * @param offset Offset into the result set to read events from
     * @param num_events Maximal number of events to retrieve
     * @param result_type The {@link ResultType} determining the sort order
     *     You may pass {@link ResultType.RELEVANCY} to this method to
     *     have the results ordered by relevancy calculated in relation
     *     to "query"
     * @param cancellable a {@link GLib.Cancellable} to cancel the operation or %NULL
     *
     * @param relevancies numeric relevancies of the events returned by result_set
     * @return {@link ResultSet} result_set.
     */
static void
zeitgeist_index_search_with_relevancies_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ZeitgeistIndexSearchWithRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_index_search_with_relevancies_co (_data_);
}

static gboolean
zeitgeist_index_search_with_relevancies_co (ZeitgeistIndexSearchWithRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->event_templates_cp = _data_->_tmp0_;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp1_) {
					_data_->_tmp2_ = _data_->i;
					_data_->i = _data_->_tmp2_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->event_templates);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->event_templates_cp;
				_data_->_tmp6_ = g_ptr_array_index (_data_->event_templates, (guint) _data_->i);
				_data_->_tmp7_ = _g_object_ref0 ((ZeitgeistEvent*) _data_->_tmp6_);
				g_ptr_array_add (_data_->_tmp5_, _data_->_tmp7_);
			}
		}
	}
	_data_->_state_ = 1;
	zeitgeist_queued_proxy_wrapper_wait_for_proxy ((ZeitgeistQueuedProxyWrapper*) _data_->self, zeitgeist_index_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_1:
	zeitgeist_queued_proxy_wrapper_wait_for_proxy_finish ((ZeitgeistQueuedProxyWrapper*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->proxy;
	_data_->_tmp9_ = zeitgeist_time_range_to_variant (_data_->time_range);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->event_templates_cp;
	_data_->_tmp12_ = zeitgeist_events_to_variant (_data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp15_ = NULL;
	_data_->_tmp16_ = 0;
	_data_->_tmp17_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search_with_relevancies (_data_->_tmp8_, _data_->query, _data_->_tmp10_, _data_->_tmp13_, (guint) _data_->storage_state, (guint) _data_->offset, (guint) _data_->num_events, (guint) _data_->result_type, _data_->cancellable, zeitgeist_index_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_with_relevancies_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp14_, &_data_->_tmp15_, &_data_->_tmp16_, &_data_->_tmp17_, &_data_->_inner_error0_);
	_g_variant_unref0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp14_;
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp15_;
	_data_->relevancies_length1 = _data_->_tmp16_;
	_data_->matches = _data_->_tmp17_;
	_g_variant_unref0 (_data_->_tmp13_);
	_g_variant_unref0 (_data_->_tmp10_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->_result_;
	_data_->_tmp20_ = zeitgeist_events_from_variant (_data_->_tmp19_, &_data_->_inner_error0_);
	_data_->_tmp18_ = _data_->_tmp20_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->_result_);
		_g_ptr_array_unref0 (_data_->event_templates_cp);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = zeitgeist_simple_result_set_new_with_num_matches (_data_->_tmp18_, _data_->matches);
	_data_->result = (ZeitgeistResultSet*) _data_->_tmp21_;
	_g_ptr_array_unref0 (_data_->_tmp18_);
	_g_variant_unref0 (_data_->_result_);
	_g_ptr_array_unref0 (_data_->event_templates_cp);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_index_class_init (ZeitgeistIndexClass * klass,
                            gpointer klass_data)
{
	zeitgeist_index_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistIndex_private_offset);
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_established = (void (*) (ZeitgeistQueuedProxyWrapper*)) zeitgeist_index_real_on_connection_established;
	((ZeitgeistQueuedProxyWrapperClass *) klass)->on_connection_lost = (void (*) (ZeitgeistQueuedProxyWrapper*)) zeitgeist_index_real_on_connection_lost;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_index_finalize;
}

static void
zeitgeist_index_instance_init (ZeitgeistIndex * self,
                               gpointer klass)
{
	self->priv = zeitgeist_index_get_instance_private (self);
}

static void
zeitgeist_index_finalize (GObject * obj)
{
	ZeitgeistIndex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_INDEX, ZeitgeistIndex);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (zeitgeist_index_parent_class)->finalize (obj);
}

/**
 * Query the Zeitgeist Full Text Search Extension
 *
 * include: zeitgeist.h
 */
static GType
zeitgeist_index_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistIndex), 0, (GInstanceInitFunc) zeitgeist_index_instance_init, NULL };
	GType zeitgeist_index_type_id;
	zeitgeist_index_type_id = g_type_register_static (ZEITGEIST_TYPE_QUEUED_PROXY_WRAPPER, "ZeitgeistIndex", &g_define_type_info, 0);
	ZeitgeistIndex_private_offset = g_type_add_instance_private (zeitgeist_index_type_id, sizeof (ZeitgeistIndexPrivate));
	return zeitgeist_index_type_id;
}

GType
zeitgeist_index_get_type (void)
{
	static volatile gsize zeitgeist_index_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_index_type_id__once)) {
		GType zeitgeist_index_type_id;
		zeitgeist_index_type_id = zeitgeist_index_get_type_once ();
		g_once_init_leave (&zeitgeist_index_type_id__once, zeitgeist_index_type_id);
	}
	return zeitgeist_index_type_id__once;
}

