#include <wayland-server-protocol-extra.hpp>

using namespace wayland;
using namespace wayland::detail;
using namespace wayland::server;
using namespace wayland::server::detail;

const wl_interface* presentation_interface_destroy_request_server[0] = {
};

const wl_interface* presentation_interface_feedback_request_server[2] = {
  &surface_interface,
  &presentation_feedback_interface,
};

const wl_interface* presentation_interface_clock_id_event_server[1] = {
  nullptr,
};

const wl_message presentation_interface_requests_server[2] = {
  {
    "destroy",
    "",
    presentation_interface_destroy_request_server,
  },
  {
    "feedback",
    "on",
    presentation_interface_feedback_request_server,
  },
};

const wl_message presentation_interface_events_server[1] = {
  {
    "clock_id",
    "u",
    presentation_interface_clock_id_event_server,
  },
};

const wl_interface wayland::server::detail::presentation_interface =
  {
    "wp_presentation",
    1,
    2,
    presentation_interface_requests_server,
    1,
    presentation_interface_events_server,
  };

const wl_interface* presentation_feedback_interface_sync_output_event_server[1] = {
  &output_interface,
};

const wl_interface* presentation_feedback_interface_presented_event_server[7] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* presentation_feedback_interface_discarded_event_server[0] = {
};

const wl_message presentation_feedback_interface_requests_server[0] = {
};

const wl_message presentation_feedback_interface_events_server[3] = {
  {
    "sync_output",
    "o",
    presentation_feedback_interface_sync_output_event_server,
  },
  {
    "presented",
    "uuuuuuu",
    presentation_feedback_interface_presented_event_server,
  },
  {
    "discarded",
    "",
    presentation_feedback_interface_discarded_event_server,
  },
};

const wl_interface wayland::server::detail::presentation_feedback_interface =
  {
    "wp_presentation_feedback",
    1,
    0,
    presentation_feedback_interface_requests_server,
    3,
    presentation_feedback_interface_events_server,
  };

const wl_interface* viewporter_interface_destroy_request_server[0] = {
};

const wl_interface* viewporter_interface_get_viewport_request_server[2] = {
  &viewport_interface,
  &surface_interface,
};

const wl_message viewporter_interface_requests_server[2] = {
  {
    "destroy",
    "",
    viewporter_interface_destroy_request_server,
  },
  {
    "get_viewport",
    "no",
    viewporter_interface_get_viewport_request_server,
  },
};

const wl_message viewporter_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::viewporter_interface =
  {
    "wp_viewporter",
    1,
    2,
    viewporter_interface_requests_server,
    0,
    viewporter_interface_events_server,
  };

const wl_interface* viewport_interface_destroy_request_server[0] = {
};

const wl_interface* viewport_interface_set_source_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* viewport_interface_set_destination_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_message viewport_interface_requests_server[3] = {
  {
    "destroy",
    "",
    viewport_interface_destroy_request_server,
  },
  {
    "set_source",
    "ffff",
    viewport_interface_set_source_request_server,
  },
  {
    "set_destination",
    "ii",
    viewport_interface_set_destination_request_server,
  },
};

const wl_message viewport_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::viewport_interface =
  {
    "wp_viewport",
    1,
    3,
    viewport_interface_requests_server,
    0,
    viewport_interface_events_server,
  };

const wl_interface* xdg_wm_base_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_wm_base_interface_create_positioner_request_server[1] = {
  &xdg_positioner_interface,
};

const wl_interface* xdg_wm_base_interface_get_xdg_surface_request_server[2] = {
  &xdg_surface_interface,
  &surface_interface,
};

const wl_interface* xdg_wm_base_interface_pong_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_wm_base_interface_ping_event_server[1] = {
  nullptr,
};

const wl_message xdg_wm_base_interface_requests_server[4] = {
  {
    "destroy",
    "",
    xdg_wm_base_interface_destroy_request_server,
  },
  {
    "create_positioner",
    "n",
    xdg_wm_base_interface_create_positioner_request_server,
  },
  {
    "get_xdg_surface",
    "no",
    xdg_wm_base_interface_get_xdg_surface_request_server,
  },
  {
    "pong",
    "u",
    xdg_wm_base_interface_pong_request_server,
  },
};

const wl_message xdg_wm_base_interface_events_server[1] = {
  {
    "ping",
    "u",
    xdg_wm_base_interface_ping_event_server,
  },
};

const wl_interface wayland::server::detail::xdg_wm_base_interface =
  {
    "xdg_wm_base",
    4,
    4,
    xdg_wm_base_interface_requests_server,
    1,
    xdg_wm_base_interface_events_server,
  };

const wl_interface* xdg_positioner_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_positioner_interface_set_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_anchor_rect_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_anchor_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_gravity_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_constraint_adjustment_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_offset_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_reactive_request_server[0] = {
};

const wl_interface* xdg_positioner_interface_set_parent_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_positioner_interface_set_parent_configure_request_server[1] = {
  nullptr,
};

const wl_message xdg_positioner_interface_requests_server[10] = {
  {
    "destroy",
    "",
    xdg_positioner_interface_destroy_request_server,
  },
  {
    "set_size",
    "ii",
    xdg_positioner_interface_set_size_request_server,
  },
  {
    "set_anchor_rect",
    "iiii",
    xdg_positioner_interface_set_anchor_rect_request_server,
  },
  {
    "set_anchor",
    "u",
    xdg_positioner_interface_set_anchor_request_server,
  },
  {
    "set_gravity",
    "u",
    xdg_positioner_interface_set_gravity_request_server,
  },
  {
    "set_constraint_adjustment",
    "u",
    xdg_positioner_interface_set_constraint_adjustment_request_server,
  },
  {
    "set_offset",
    "ii",
    xdg_positioner_interface_set_offset_request_server,
  },
  {
    "set_reactive",
    "3",
    xdg_positioner_interface_set_reactive_request_server,
  },
  {
    "set_parent_size",
    "3ii",
    xdg_positioner_interface_set_parent_size_request_server,
  },
  {
    "set_parent_configure",
    "3u",
    xdg_positioner_interface_set_parent_configure_request_server,
  },
};

const wl_message xdg_positioner_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::xdg_positioner_interface =
  {
    "xdg_positioner",
    4,
    10,
    xdg_positioner_interface_requests_server,
    0,
    xdg_positioner_interface_events_server,
  };

const wl_interface* xdg_surface_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_surface_interface_get_toplevel_request_server[1] = {
  &xdg_toplevel_interface,
};

const wl_interface* xdg_surface_interface_get_popup_request_server[3] = {
  &xdg_popup_interface,
  &xdg_surface_interface,
  &xdg_positioner_interface,
};

const wl_interface* xdg_surface_interface_set_window_geometry_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_surface_interface_ack_configure_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_surface_interface_configure_event_server[1] = {
  nullptr,
};

const wl_message xdg_surface_interface_requests_server[5] = {
  {
    "destroy",
    "",
    xdg_surface_interface_destroy_request_server,
  },
  {
    "get_toplevel",
    "n",
    xdg_surface_interface_get_toplevel_request_server,
  },
  {
    "get_popup",
    "n?oo",
    xdg_surface_interface_get_popup_request_server,
  },
  {
    "set_window_geometry",
    "iiii",
    xdg_surface_interface_set_window_geometry_request_server,
  },
  {
    "ack_configure",
    "u",
    xdg_surface_interface_ack_configure_request_server,
  },
};

const wl_message xdg_surface_interface_events_server[1] = {
  {
    "configure",
    "u",
    xdg_surface_interface_configure_event_server,
  },
};

const wl_interface wayland::server::detail::xdg_surface_interface =
  {
    "xdg_surface",
    4,
    5,
    xdg_surface_interface_requests_server,
    1,
    xdg_surface_interface_events_server,
  };

const wl_interface* xdg_toplevel_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_toplevel_interface_set_parent_request_server[1] = {
  &xdg_toplevel_interface,
};

const wl_interface* xdg_toplevel_interface_set_title_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_app_id_request_server[1] = {
  nullptr,
};

const wl_interface* xdg_toplevel_interface_show_window_menu_request_server[4] = {
  &seat_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_move_request_server[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_resize_request_server[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_max_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_min_size_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_set_maximized_request_server[0] = {
};

const wl_interface* xdg_toplevel_interface_unset_maximized_request_server[0] = {
};

const wl_interface* xdg_toplevel_interface_set_fullscreen_request_server[1] = {
  &output_interface,
};

const wl_interface* xdg_toplevel_interface_unset_fullscreen_request_server[0] = {
};

const wl_interface* xdg_toplevel_interface_set_minimized_request_server[0] = {
};

const wl_interface* xdg_toplevel_interface_configure_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_toplevel_interface_close_event_server[0] = {
};

const wl_interface* xdg_toplevel_interface_configure_bounds_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_message xdg_toplevel_interface_requests_server[14] = {
  {
    "destroy",
    "",
    xdg_toplevel_interface_destroy_request_server,
  },
  {
    "set_parent",
    "?o",
    xdg_toplevel_interface_set_parent_request_server,
  },
  {
    "set_title",
    "s",
    xdg_toplevel_interface_set_title_request_server,
  },
  {
    "set_app_id",
    "s",
    xdg_toplevel_interface_set_app_id_request_server,
  },
  {
    "show_window_menu",
    "ouii",
    xdg_toplevel_interface_show_window_menu_request_server,
  },
  {
    "move",
    "ou",
    xdg_toplevel_interface_move_request_server,
  },
  {
    "resize",
    "ouu",
    xdg_toplevel_interface_resize_request_server,
  },
  {
    "set_max_size",
    "ii",
    xdg_toplevel_interface_set_max_size_request_server,
  },
  {
    "set_min_size",
    "ii",
    xdg_toplevel_interface_set_min_size_request_server,
  },
  {
    "set_maximized",
    "",
    xdg_toplevel_interface_set_maximized_request_server,
  },
  {
    "unset_maximized",
    "",
    xdg_toplevel_interface_unset_maximized_request_server,
  },
  {
    "set_fullscreen",
    "?o",
    xdg_toplevel_interface_set_fullscreen_request_server,
  },
  {
    "unset_fullscreen",
    "",
    xdg_toplevel_interface_unset_fullscreen_request_server,
  },
  {
    "set_minimized",
    "",
    xdg_toplevel_interface_set_minimized_request_server,
  },
};

const wl_message xdg_toplevel_interface_events_server[3] = {
  {
    "configure",
    "iia",
    xdg_toplevel_interface_configure_event_server,
  },
  {
    "close",
    "",
    xdg_toplevel_interface_close_event_server,
  },
  {
    "configure_bounds",
    "4ii",
    xdg_toplevel_interface_configure_bounds_event_server,
  },
};

const wl_interface wayland::server::detail::xdg_toplevel_interface =
  {
    "xdg_toplevel",
    4,
    14,
    xdg_toplevel_interface_requests_server,
    3,
    xdg_toplevel_interface_events_server,
  };

const wl_interface* xdg_popup_interface_destroy_request_server[0] = {
};

const wl_interface* xdg_popup_interface_grab_request_server[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* xdg_popup_interface_reposition_request_server[2] = {
  &xdg_positioner_interface,
  nullptr,
};

const wl_interface* xdg_popup_interface_configure_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* xdg_popup_interface_popup_done_event_server[0] = {
};

const wl_interface* xdg_popup_interface_repositioned_event_server[1] = {
  nullptr,
};

const wl_message xdg_popup_interface_requests_server[3] = {
  {
    "destroy",
    "",
    xdg_popup_interface_destroy_request_server,
  },
  {
    "grab",
    "ou",
    xdg_popup_interface_grab_request_server,
  },
  {
    "reposition",
    "3ou",
    xdg_popup_interface_reposition_request_server,
  },
};

const wl_message xdg_popup_interface_events_server[3] = {
  {
    "configure",
    "iiii",
    xdg_popup_interface_configure_event_server,
  },
  {
    "popup_done",
    "",
    xdg_popup_interface_popup_done_event_server,
  },
  {
    "repositioned",
    "3u",
    xdg_popup_interface_repositioned_event_server,
  },
};

const wl_interface wayland::server::detail::xdg_popup_interface =
  {
    "xdg_popup",
    4,
    3,
    xdg_popup_interface_requests_server,
    3,
    xdg_popup_interface_events_server,
  };

presentation_t::presentation_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::presentation_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

presentation_t::presentation_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string presentation_t::interface_name = "wp_presentation";

presentation_t::operator wp_presentation*() const
{
  return reinterpret_cast<wp_presentation*> (c_ptr());
}

std::function<void()> &presentation_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(surface_t, presentation_feedback_t)> &presentation_t::on_feedback()
{
  return std::static_pointer_cast<events_t>(get_events())->feedback;
}


void presentation_t::clock_id(uint32_t clk_id, bool post)
{
  send_event(post, 0, clk_id);
}

void presentation_t::post_invalid_timestamp(std::string const& msg)
{
  post_error(static_cast<uint32_t>(presentation_error::invalid_timestamp), msg);
}

void presentation_t::post_invalid_flag(std::string const& msg)
{
  post_error(static_cast<uint32_t>(presentation_error::invalid_flag), msg);
}

int presentation_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->feedback) events->feedback(surface_t(args[0].get<resource_t>()), presentation_feedback_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}


presentation_feedback_t::presentation_feedback_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::presentation_feedback_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

presentation_feedback_t::presentation_feedback_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string presentation_feedback_t::interface_name = "wp_presentation_feedback";

presentation_feedback_t::operator wp_presentation_feedback*() const
{
  return reinterpret_cast<wp_presentation_feedback*> (c_ptr());
}

void presentation_feedback_t::sync_output(output_t const& output, bool post)
{
  send_event(post, 0, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}

void presentation_feedback_t::presented(uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec, uint32_t refresh, uint32_t seq_hi, uint32_t seq_lo, presentation_feedback_kind const& flags, bool post)
{
  send_event(post, 1, tv_sec_hi, tv_sec_lo, tv_nsec, refresh, seq_hi, seq_lo, static_cast<uint32_t>(flags));
}

void presentation_feedback_t::discarded(bool post)
{
  send_event(post, 2);
}

int presentation_feedback_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  return 0;
}
const bitfield<4, 1> presentation_feedback_kind::vsync{0x1};
const bitfield<4, 1> presentation_feedback_kind::hw_clock{0x2};
const bitfield<4, 1> presentation_feedback_kind::hw_completion{0x4};
const bitfield<4, 1> presentation_feedback_kind::zero_copy{0x8};


viewporter_t::viewporter_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::viewporter_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

viewporter_t::viewporter_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string viewporter_t::interface_name = "wp_viewporter";

viewporter_t::operator wp_viewporter*() const
{
  return reinterpret_cast<wp_viewporter*> (c_ptr());
}

std::function<void()> &viewporter_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(viewport_t, surface_t)> &viewporter_t::on_get_viewport()
{
  return std::static_pointer_cast<events_t>(get_events())->get_viewport;
}


void viewporter_t::post_viewport_exists(std::string const& msg)
{
  post_error(static_cast<uint32_t>(viewporter_error::viewport_exists), msg);
}

int viewporter_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_viewport) events->get_viewport(viewport_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}


viewport_t::viewport_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::viewport_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

viewport_t::viewport_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string viewport_t::interface_name = "wp_viewport";

viewport_t::operator wp_viewport*() const
{
  return reinterpret_cast<wp_viewport*> (c_ptr());
}

std::function<void()> &viewport_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(double, double, double, double)> &viewport_t::on_set_source()
{
  return std::static_pointer_cast<events_t>(get_events())->set_source;
}


std::function<void(int32_t, int32_t)> &viewport_t::on_set_destination()
{
  return std::static_pointer_cast<events_t>(get_events())->set_destination;
}


void viewport_t::post_bad_value(std::string const& msg)
{
  post_error(static_cast<uint32_t>(viewport_error::bad_value), msg);
}

void viewport_t::post_bad_size(std::string const& msg)
{
  post_error(static_cast<uint32_t>(viewport_error::bad_size), msg);
}

void viewport_t::post_out_of_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(viewport_error::out_of_buffer), msg);
}

void viewport_t::post_no_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(viewport_error::no_surface), msg);
}

int viewport_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_source) events->set_source(args[0].get<double>(), args[1].get<double>(), args[2].get<double>(), args[3].get<double>());
      break;
    case 2:
      if(events->set_destination) events->set_destination(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    }
  return 0;
}


xdg_wm_base_t::xdg_wm_base_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_wm_base_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_wm_base_t::xdg_wm_base_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_wm_base_t::interface_name = "xdg_wm_base";

xdg_wm_base_t::operator xdg_wm_base*() const
{
  return reinterpret_cast<xdg_wm_base*> (c_ptr());
}

std::function<void()> &xdg_wm_base_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(xdg_positioner_t)> &xdg_wm_base_t::on_create_positioner()
{
  return std::static_pointer_cast<events_t>(get_events())->create_positioner;
}


std::function<void(xdg_surface_t, surface_t)> &xdg_wm_base_t::on_get_xdg_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->get_xdg_surface;
}


std::function<void(uint32_t)> &xdg_wm_base_t::on_pong()
{
  return std::static_pointer_cast<events_t>(get_events())->pong;
}


void xdg_wm_base_t::ping(uint32_t serial, bool post)
{
  send_event(post, 0, serial);
}

void xdg_wm_base_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::role), msg);
}

void xdg_wm_base_t::post_defunct_surfaces(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::defunct_surfaces), msg);
}

void xdg_wm_base_t::post_not_the_topmost_popup(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::not_the_topmost_popup), msg);
}

void xdg_wm_base_t::post_invalid_popup_parent(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::invalid_popup_parent), msg);
}

void xdg_wm_base_t::post_invalid_surface_state(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::invalid_surface_state), msg);
}

void xdg_wm_base_t::post_invalid_positioner(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_wm_base_error::invalid_positioner), msg);
}

int xdg_wm_base_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->create_positioner) events->create_positioner(xdg_positioner_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_xdg_surface) events->get_xdg_surface(xdg_surface_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    case 3:
      if(events->pong) events->pong(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


xdg_positioner_t::xdg_positioner_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_positioner_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_positioner_t::xdg_positioner_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_positioner_t::interface_name = "xdg_positioner";

xdg_positioner_t::operator xdg_positioner*() const
{
  return reinterpret_cast<xdg_positioner*> (c_ptr());
}

std::function<void()> &xdg_positioner_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int32_t, int32_t)> &xdg_positioner_t::on_set_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_size;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &xdg_positioner_t::on_set_anchor_rect()
{
  return std::static_pointer_cast<events_t>(get_events())->set_anchor_rect;
}


std::function<void(xdg_positioner_anchor)> &xdg_positioner_t::on_set_anchor()
{
  return std::static_pointer_cast<events_t>(get_events())->set_anchor;
}


std::function<void(xdg_positioner_gravity)> &xdg_positioner_t::on_set_gravity()
{
  return std::static_pointer_cast<events_t>(get_events())->set_gravity;
}


std::function<void(xdg_positioner_constraint_adjustment)> &xdg_positioner_t::on_set_constraint_adjustment()
{
  return std::static_pointer_cast<events_t>(get_events())->set_constraint_adjustment;
}


std::function<void(int32_t, int32_t)> &xdg_positioner_t::on_set_offset()
{
  return std::static_pointer_cast<events_t>(get_events())->set_offset;
}


std::function<void()> &xdg_positioner_t::on_set_reactive()
{
  return std::static_pointer_cast<events_t>(get_events())->set_reactive;
}


std::function<void(int32_t, int32_t)> &xdg_positioner_t::on_set_parent_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent_size;
}


std::function<void(uint32_t)> &xdg_positioner_t::on_set_parent_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent_configure;
}


void xdg_positioner_t::post_invalid_input(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_positioner_error::invalid_input), msg);
}

int xdg_positioner_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_size) events->set_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 2:
      if(events->set_anchor_rect) events->set_anchor_rect(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 3:
      if(events->set_anchor) events->set_anchor(xdg_positioner_anchor(args[0].get<uint32_t>()));
      break;
    case 4:
      if(events->set_gravity) events->set_gravity(xdg_positioner_gravity(args[0].get<uint32_t>()));
      break;
    case 5:
      if(events->set_constraint_adjustment) events->set_constraint_adjustment(xdg_positioner_constraint_adjustment(args[0].get<uint32_t>()));
      break;
    case 6:
      if(events->set_offset) events->set_offset(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 7:
      if(events->set_reactive) events->set_reactive();
      break;
    case 8:
      if(events->set_parent_size) events->set_parent_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 9:
      if(events->set_parent_configure) events->set_parent_configure(args[0].get<uint32_t>());
      break;
    }
  return 0;
}



const bitfield<6, 8> xdg_positioner_constraint_adjustment::none{0};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::slide_x{1};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::slide_y{2};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::flip_x{4};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::flip_y{8};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::resize_x{16};
const bitfield<6, 8> xdg_positioner_constraint_adjustment::resize_y{32};


xdg_surface_t::xdg_surface_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_surface_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_surface_t::xdg_surface_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_surface_t::interface_name = "xdg_surface";

xdg_surface_t::operator xdg_surface*() const
{
  return reinterpret_cast<xdg_surface*> (c_ptr());
}

std::function<void()> &xdg_surface_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(xdg_toplevel_t)> &xdg_surface_t::on_get_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->get_toplevel;
}


std::function<void(xdg_popup_t, xdg_surface_t, xdg_positioner_t)> &xdg_surface_t::on_get_popup()
{
  return std::static_pointer_cast<events_t>(get_events())->get_popup;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &xdg_surface_t::on_set_window_geometry()
{
  return std::static_pointer_cast<events_t>(get_events())->set_window_geometry;
}


std::function<void(uint32_t)> &xdg_surface_t::on_ack_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->ack_configure;
}


void xdg_surface_t::configure(uint32_t serial, bool post)
{
  send_event(post, 0, serial);
}

void xdg_surface_t::post_not_constructed(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_surface_error::not_constructed), msg);
}

void xdg_surface_t::post_already_constructed(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_surface_error::already_constructed), msg);
}

void xdg_surface_t::post_unconfigured_buffer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_surface_error::unconfigured_buffer), msg);
}

int xdg_surface_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_toplevel) events->get_toplevel(xdg_toplevel_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_popup) events->get_popup(xdg_popup_t(args[0].get<resource_t>()), xdg_surface_t(args[1].get<resource_t>()), xdg_positioner_t(args[2].get<resource_t>()));
      break;
    case 3:
      if(events->set_window_geometry) events->set_window_geometry(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 4:
      if(events->ack_configure) events->ack_configure(args[0].get<uint32_t>());
      break;
    }
  return 0;
}


xdg_toplevel_t::xdg_toplevel_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_toplevel_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_toplevel_t::xdg_toplevel_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_toplevel_t::interface_name = "xdg_toplevel";

xdg_toplevel_t::operator xdg_toplevel*() const
{
  return reinterpret_cast<xdg_toplevel*> (c_ptr());
}

std::function<void()> &xdg_toplevel_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(xdg_toplevel_t)> &xdg_toplevel_t::on_set_parent()
{
  return std::static_pointer_cast<events_t>(get_events())->set_parent;
}


std::function<void(std::string)> &xdg_toplevel_t::on_set_title()
{
  return std::static_pointer_cast<events_t>(get_events())->set_title;
}


std::function<void(std::string)> &xdg_toplevel_t::on_set_app_id()
{
  return std::static_pointer_cast<events_t>(get_events())->set_app_id;
}


std::function<void(seat_t, uint32_t, int32_t, int32_t)> &xdg_toplevel_t::on_show_window_menu()
{
  return std::static_pointer_cast<events_t>(get_events())->show_window_menu;
}


std::function<void(seat_t, uint32_t)> &xdg_toplevel_t::on_move()
{
  return std::static_pointer_cast<events_t>(get_events())->move;
}


std::function<void(seat_t, uint32_t, xdg_toplevel_resize_edge)> &xdg_toplevel_t::on_resize()
{
  return std::static_pointer_cast<events_t>(get_events())->resize;
}


std::function<void(int32_t, int32_t)> &xdg_toplevel_t::on_set_max_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_max_size;
}


std::function<void(int32_t, int32_t)> &xdg_toplevel_t::on_set_min_size()
{
  return std::static_pointer_cast<events_t>(get_events())->set_min_size;
}


std::function<void()> &xdg_toplevel_t::on_set_maximized()
{
  return std::static_pointer_cast<events_t>(get_events())->set_maximized;
}


std::function<void()> &xdg_toplevel_t::on_unset_maximized()
{
  return std::static_pointer_cast<events_t>(get_events())->unset_maximized;
}


std::function<void(output_t)> &xdg_toplevel_t::on_set_fullscreen()
{
  return std::static_pointer_cast<events_t>(get_events())->set_fullscreen;
}


std::function<void()> &xdg_toplevel_t::on_unset_fullscreen()
{
  return std::static_pointer_cast<events_t>(get_events())->unset_fullscreen;
}


std::function<void()> &xdg_toplevel_t::on_set_minimized()
{
  return std::static_pointer_cast<events_t>(get_events())->set_minimized;
}


void xdg_toplevel_t::configure(int32_t width, int32_t height, array_t const& states, bool post)
{
  send_event(post, 0, width, height, states);
}

void xdg_toplevel_t::close(bool post)
{
  send_event(post, 1);
}

void xdg_toplevel_t::configure_bounds(int32_t width, int32_t height, bool post)
{
  send_event(post, 2, width, height);
}

bool xdg_toplevel_t::can_configure_bounds() const
{
  return (get_version() >= configure_bounds_since_version);
}

void xdg_toplevel_t::post_invalid_resize_edge(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_toplevel_error::invalid_resize_edge), msg);
}

int xdg_toplevel_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_parent) events->set_parent(xdg_toplevel_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->set_title) events->set_title(args[0].get<std::string>());
      break;
    case 3:
      if(events->set_app_id) events->set_app_id(args[0].get<std::string>());
      break;
    case 4:
      if(events->show_window_menu) events->show_window_menu(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 5:
      if(events->move) events->move(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 6:
      if(events->resize) events->resize(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), xdg_toplevel_resize_edge(args[2].get<uint32_t>()));
      break;
    case 7:
      if(events->set_max_size) events->set_max_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 8:
      if(events->set_min_size) events->set_min_size(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 9:
      if(events->set_maximized) events->set_maximized();
      break;
    case 10:
      if(events->unset_maximized) events->unset_maximized();
      break;
    case 11:
      if(events->set_fullscreen) events->set_fullscreen(output_t(args[0].get<resource_t>()));
      break;
    case 12:
      if(events->unset_fullscreen) events->unset_fullscreen();
      break;
    case 13:
      if(events->set_minimized) events->set_minimized();
      break;
    }
  return 0;
}

const bitfield<4, 11> xdg_toplevel_resize_edge::none{0};
const bitfield<4, 11> xdg_toplevel_resize_edge::top{1};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom{2};
const bitfield<4, 11> xdg_toplevel_resize_edge::left{4};
const bitfield<4, 11> xdg_toplevel_resize_edge::top_left{5};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom_left{6};
const bitfield<4, 11> xdg_toplevel_resize_edge::right{8};
const bitfield<4, 11> xdg_toplevel_resize_edge::top_right{9};
const bitfield<4, 11> xdg_toplevel_resize_edge::bottom_right{10};



xdg_popup_t::xdg_popup_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::xdg_popup_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

xdg_popup_t::xdg_popup_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string xdg_popup_t::interface_name = "xdg_popup";

xdg_popup_t::operator xdg_popup*() const
{
  return reinterpret_cast<xdg_popup*> (c_ptr());
}

std::function<void()> &xdg_popup_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(seat_t, uint32_t)> &xdg_popup_t::on_grab()
{
  return std::static_pointer_cast<events_t>(get_events())->grab;
}


std::function<void(xdg_positioner_t, uint32_t)> &xdg_popup_t::on_reposition()
{
  return std::static_pointer_cast<events_t>(get_events())->reposition;
}


void xdg_popup_t::configure(int32_t x, int32_t y, int32_t width, int32_t height, bool post)
{
  send_event(post, 0, x, y, width, height);
}

void xdg_popup_t::popup_done(bool post)
{
  send_event(post, 1);
}

void xdg_popup_t::repositioned(uint32_t token, bool post)
{
  send_event(post, 2, token);
}

bool xdg_popup_t::can_repositioned() const
{
  return (get_version() >= repositioned_since_version);
}

void xdg_popup_t::post_invalid_grab(std::string const& msg)
{
  post_error(static_cast<uint32_t>(xdg_popup_error::invalid_grab), msg);
}

int xdg_popup_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->grab) events->grab(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->reposition) events->reposition(xdg_positioner_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    }
  return 0;
}



