// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BorderProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::BorderPropertyPrivate
{
public:
    std::unique_ptr<LineProperty> left;
    std::unique_ptr<LineProperty> right;
    std::unique_ptr<LineProperty> top;
    std::unique_ptr<LineProperty> bottom;
};

BorderProperty::BorderProperty()
    : d(std::make_unique<BorderPropertyPrivate>())
{
}

BorderProperty::BorderProperty(const BorderProperty &other)
    : d(std::make_unique<BorderPropertyPrivate>())
{
    d->left = std::make_unique<LineProperty>();
    *(d->left) = *(other.d->left);
    d->right = std::make_unique<LineProperty>();
    *(d->right) = *(other.d->right);
    d->top = std::make_unique<LineProperty>();
    *(d->top) = *(other.d->top);
    d->bottom = std::make_unique<LineProperty>();
    *(d->bottom) = *(other.d->bottom);
}

BorderProperty::BorderProperty(BorderProperty &&other)
    : d(std::move(other.d))
{
}

BorderProperty::~BorderProperty() = default;

BorderProperty &BorderProperty::operator=(const BorderProperty &other)
{
    if (this != &other) {
        *(d->left) = *(other.d->left);
        *(d->right) = *(other.d->right);
        *(d->top) = *(other.d->top);
        *(d->bottom) = *(other.d->bottom);
    }
    return *this;
}

BorderProperty &BorderProperty::operator=(BorderProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

LineProperty *BorderProperty::left() const
{
    return d->left.get();
}

void BorderProperty::setLeft(std::unique_ptr<LineProperty> &&newValue)
{
    d->left = std::move(newValue);
}

LineProperty *BorderProperty::right() const
{
    return d->right.get();
}

void BorderProperty::setRight(std::unique_ptr<LineProperty> &&newValue)
{
    d->right = std::move(newValue);
}

LineProperty *BorderProperty::top() const
{
    return d->top.get();
}

void BorderProperty::setTop(std::unique_ptr<LineProperty> &&newValue)
{
    d->top = std::move(newValue);
}

LineProperty *BorderProperty::bottom() const
{
    return d->bottom.get();
}

void BorderProperty::setBottom(std::unique_ptr<LineProperty> &&newValue)
{
    d->bottom = std::move(newValue);
}

bool BorderProperty::hasAnyValue() const
{
    if (d->left && d->left->hasAnyValue()) {
        return true;
    }
    if (d->right && d->right->hasAnyValue()) {
        return true;
    }
    if (d->top && d->top->hasAnyValue()) {
        return true;
    }
    if (d->bottom && d->bottom->hasAnyValue()) {
        return true;
    }
    return false;
}

bool BorderProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->left && !d->left->isEmpty()) {
        return false;
    }
    if (d->right && !d->right->isEmpty()) {
        return false;
    }
    if (d->top && !d->top->isEmpty()) {
        return false;
    }
    if (d->bottom && !d->bottom->isEmpty()) {
        return false;
    }

    return true;
}

QString BorderProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "BorderProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "left: ";
    if (d->left) {
        out << d->left->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "right: ";
    if (d->right) {
        out << d->right->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "top: ";
    if (d->top) {
        out << d->top->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "bottom: ";
    if (d->bottom) {
        out << d->bottom->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void BorderProperty::resolveProperties(const BorderProperty *source, BorderProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (source->d->left) {
        if (!destination->d->left) {
            destination->d->left = std::make_unique<LineProperty>();
        }
        LineProperty::resolveProperties(source->d->left.get(), destination->d->left.get());
    }
    if (source->d->right) {
        if (!destination->d->right) {
            destination->d->right = std::make_unique<LineProperty>();
        }
        LineProperty::resolveProperties(source->d->right.get(), destination->d->right.get());
    }
    if (source->d->top) {
        if (!destination->d->top) {
            destination->d->top = std::make_unique<LineProperty>();
        }
        LineProperty::resolveProperties(source->d->top.get(), destination->d->top.get());
    }
    if (source->d->bottom) {
        if (!destination->d->bottom) {
            destination->d->bottom = std::make_unique<LineProperty>();
        }
        LineProperty::resolveProperties(source->d->bottom.get(), destination->d->bottom.get());
    }
}

std::unique_ptr<BorderProperty> BorderProperty::empty()
{
    auto result = std::make_unique<BorderProperty>();
    result->d->left = LineProperty::empty();
    result->d->right = LineProperty::empty();
    result->d->top = LineProperty::empty();
    result->d->bottom = LineProperty::empty();
    return result;
}

QMarginsF BorderProperty::sizes() const
{
    QMarginsF result;

    if (d->left) {
        result.setLeft(d->left->size().value_or(0.0));
    }
    if (d->right) {
        result.setRight(d->right->size().value_or(0.0));
    }
    if (d->top) {
        result.setTop(d->top->size().value_or(0.0));
    }
    if (d->bottom) {
        result.setBottom(d->bottom->size().value_or(0.0));
    }

    return result;
}

bool Union::Properties::operator==(const BorderProperty &left, const BorderProperty &right)
{
    if (left.left() && right.left()) {
        if (*(left.left()) != *(right.left())) {
            return false;
        }
    } else if (left.left() != right.left()) {
        return false;
    }
    if (left.right() && right.right()) {
        if (*(left.right()) != *(right.right())) {
            return false;
        }
    } else if (left.right() != right.right()) {
        return false;
    }
    if (left.top() && right.top()) {
        if (*(left.top()) != *(right.top())) {
            return false;
        }
    } else if (left.top() != right.top()) {
        return false;
    }
    if (left.bottom() && right.bottom()) {
        if (*(left.bottom()) != *(right.bottom())) {
            return false;
        }
    } else if (left.bottom() != right.bottom()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::BorderProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}