// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BorderPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

BorderPropertyGroup::BorderPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_left = std::make_unique<LinePropertyGroup>(m_style);
    m_right = std::make_unique<LinePropertyGroup>(m_style);
    m_top = std::make_unique<LinePropertyGroup>(m_style);
    m_bottom = std::make_unique<LinePropertyGroup>(m_style);
}

void BorderPropertyGroup::update(BorderProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
        m_left->update(nullptr);
        m_right->update(nullptr);
        m_top->update(nullptr);
        m_bottom->update(nullptr);
    } else {
        m_left->update(newState->left());
        m_right->update(newState->right());
        m_top->update(newState->top());
        m_bottom->update(newState->bottom());
    }

    Q_EMIT updated();
}

void BorderPropertyGroup::refreshColors()
{
    m_left->refreshColors();
    m_right->refreshColors();
    m_top->refreshColors();
    m_bottom->refreshColors();
}

LinePropertyGroup *BorderPropertyGroup::left() const
{
    return m_left.get();
}

LinePropertyGroup *BorderPropertyGroup::right() const
{
    return m_right.get();
}

LinePropertyGroup *BorderPropertyGroup::top() const
{
    return m_top.get();
}

LinePropertyGroup *BorderPropertyGroup::bottom() const
{
    return m_bottom.get();
}

#include "moc_BorderPropertyGroup.cpp"