// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/models"
)

type ModifyMonitorRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 监控项设置信息  */
	UpdateMonitor *domainservice.UpdateMonitor `json:"updateMonitor"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param updateMonitor: 监控项设置信息 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyMonitorRequest(
	regionId string,
	domainId string,
	updateMonitor *domainservice.UpdateMonitor,
) *ModifyMonitorRequest {

	return &ModifyMonitorRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:      regionId,
		DomainId:      domainId,
		UpdateMonitor: updateMonitor,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param updateMonitor: 监控项设置信息 (Required)
 */
func NewModifyMonitorRequestWithAllParams(
	regionId string,
	domainId string,
	updateMonitor *domainservice.UpdateMonitor,
) *ModifyMonitorRequest {

	return &ModifyMonitorRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:      regionId,
		DomainId:      domainId,
		UpdateMonitor: updateMonitor,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyMonitorRequestWithoutParam() *ModifyMonitorRequest {

	return &ModifyMonitorRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *ModifyMonitorRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *ModifyMonitorRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param updateMonitor: 监控项设置信息(Required) */
func (r *ModifyMonitorRequest) SetUpdateMonitor(updateMonitor *domainservice.UpdateMonitor) {
	r.UpdateMonitor = updateMonitor
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyMonitorRequest) GetRegionId() string {
	return r.RegionId
}

type ModifyMonitorResponse struct {
	RequestID string              `json:"requestId"`
	Error     core.ErrorResponse  `json:"error"`
	Result    ModifyMonitorResult `json:"result"`
}

type ModifyMonitorResult struct {
}
