// python wrapper for ttkSignedDistanceField
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkSignedDistanceField.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkSignedDistanceField(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkSignedDistanceField_ClassNew(); }


static PyObject *
PyttkSignedDistanceField_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkSignedDistanceField::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkSignedDistanceField::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkSignedDistanceField *tempr = ttkSignedDistanceField::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkSignedDistanceField *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkSignedDistanceField::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkSignedDistanceField::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkSignedDistanceField::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_SetSamplingDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0, temp1, temp2);
    }
    else
    {
      op->ttkSignedDistanceField::SetSamplingDimensions(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkSignedDistanceField_SetSamplingDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0);
    }
    else
    {
      op->ttkSignedDistanceField::SetSamplingDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyttkSignedDistanceField_SetSamplingDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyttkSignedDistanceField_SetSamplingDimensions_s1(self, args);
    case 1:
      return PyttkSignedDistanceField_SetSamplingDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSamplingDimensions");
  return nullptr;
}


static PyObject *
PyttkSignedDistanceField_GetSamplingDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetSamplingDimensions() :
      op->ttkSignedDistanceField::GetSamplingDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_SetExpandBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpandBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpandBox(temp0);
    }
    else
    {
      op->ttkSignedDistanceField::SetExpandBox(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetExpandBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpandBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExpandBox() :
      op->ttkSignedDistanceField::GetExpandBox());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_SetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackend(temp0);
    }
    else
    {
      op->ttkSignedDistanceField::SetBackend(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetBackend(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackend");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackend() :
      op->ttkSignedDistanceField::GetBackend());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_SetFastMarchingOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFastMarchingOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFastMarchingOrder(temp0);
    }
    else
    {
      op->ttkSignedDistanceField::SetFastMarchingOrder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetFastMarchingOrder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFastMarchingOrder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFastMarchingOrder() :
      op->ttkSignedDistanceField::GetFastMarchingOrder());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkSignedDistanceField_GetOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkSignedDistanceField *op = static_cast<ttkSignedDistanceField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->GetOutput() :
      op->ttkSignedDistanceField::GetOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkSignedDistanceField_Methods[] = {
  {"IsTypeOf", PyttkSignedDistanceField_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkSignedDistanceField_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkSignedDistanceField_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkSignedDistanceField\nC++: static ttkSignedDistanceField *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkSignedDistanceField_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkSignedDistanceField\nC++: ttkSignedDistanceField *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkSignedDistanceField_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkSignedDistanceField_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSamplingDimensions", PyttkSignedDistanceField_SetSamplingDimensions, METH_VARARGS,
   "SetSamplingDimensions(self, _arg1:int, _arg2:int, _arg3:int)\n    -> None\nC++: virtual void SetSamplingDimensions(int _arg1, int _arg2,\n    int _arg3)\nSetSamplingDimensions(self, _arg:(int, int, int)) -> None\nC++: virtual void SetSamplingDimensions(const int _arg[3])\n\nSet/Get sampling dimension along each axis. Default will be\n[10,10,10]\n"},
  {"GetSamplingDimensions", PyttkSignedDistanceField_GetSamplingDimensions, METH_VARARGS,
   "GetSamplingDimensions(self) -> (int, int, int)\nC++: virtual int *GetSamplingDimensions()\n\n"},
  {"SetExpandBox", PyttkSignedDistanceField_SetExpandBox, METH_VARARGS,
   "SetExpandBox(self, _arg:bool) -> None\nC++: virtual void SetExpandBox(bool _arg)\n\n"},
  {"GetExpandBox", PyttkSignedDistanceField_GetExpandBox, METH_VARARGS,
   "GetExpandBox(self) -> bool\nC++: virtual bool GetExpandBox()\n\n"},
  {"SetBackend", PyttkSignedDistanceField_SetBackend, METH_VARARGS,
   "SetBackend(self, _arg:int) -> None\nC++: virtual void SetBackend(int _arg)\n\n"},
  {"GetBackend", PyttkSignedDistanceField_GetBackend, METH_VARARGS,
   "GetBackend(self) -> int\nC++: virtual int GetBackend()\n\n"},
  {"SetFastMarchingOrder", PyttkSignedDistanceField_SetFastMarchingOrder, METH_VARARGS,
   "SetFastMarchingOrder(self, _arg:int) -> None\nC++: virtual void SetFastMarchingOrder(int _arg)\n\n"},
  {"GetFastMarchingOrder", PyttkSignedDistanceField_GetFastMarchingOrder, METH_VARARGS,
   "GetFastMarchingOrder(self) -> int\nC++: virtual int GetFastMarchingOrder()\n\n"},
  {"GetOutput", PyttkSignedDistanceField_GetOutput, METH_VARARGS,
   "GetOutput(self) -> vtkImageData\nC++: vtkImageData *GetOutput()\n\nGet the output data for this algorithm.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkSignedDistanceField_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("sampling_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkSignedDistanceField_GetSamplingDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkSignedDistanceField_SetSamplingDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkSignedDistanceField_SetSamplingDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSamplingDimensions/SetSamplingDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("expand_box"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkSignedDistanceField_GetExpandBox(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkSignedDistanceField_SetExpandBox(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkSignedDistanceField_SetExpandBox(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpandBox/SetExpandBox\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("backend"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkSignedDistanceField_GetBackend(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkSignedDistanceField_SetBackend(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkSignedDistanceField_SetBackend(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackend/SetBackend\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fast_marching_order"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkSignedDistanceField_GetFastMarchingOrder(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkSignedDistanceField_SetFastMarchingOrder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkSignedDistanceField_SetFastMarchingOrder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFastMarchingOrder/SetFastMarchingOrder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkSignedDistanceField_GetOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutput\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkSignedDistanceField_Doc =
  "ttkSignedDistanceField - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\author Mohamed Amine\n"
  "Kissi <mohamed.kissi@lip6.fr>\\author Mathieu Pont\n"
  "<mathieu.pont@lip6.fr>\\date August 2023\n\n"
  "This filter computes a signed distance field given a surface in\n"
  "input.\n\n"
  "It implements three backends (accelerated with a BVH data structure):\n\n"
  "- The exact backend\n\n"
  "- The fast marching backend, this method simulates a \"wave\" that move\n"
  "  starting from the input surface and solve the eikonal equation\n"
  "  vertex by vertex to approximate the signed distance field. It\n"
  "  corresponds to the the following reference:\n\n"
  "J.A. Sethian. A Fast Marching Level Set Method for Monotonically\n"
  "Advancing Fronts, Proc. Natl. Acad. Sci., 93, 4, pp.1591--1595, 1996\n\n"
  "- The fast marching band backend, a variant of the fast marching for\n"
  "  which all the vertices being not yet updated and nearest the input\n"
  "  surface are updated (instead of just one in the fast marching\n"
  "  backend). It results in a faster method (due to parallelism) but is\n"
  "a rougher approximation.\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_torus/\"\n"
  "  >Topological Optimization for Torus Repair example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkSignedDistanceField_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkSignedDistanceField.ttkSignedDistanceField", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkSignedDistanceField_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkSignedDistanceField_StaticNew()
{
  return ttkSignedDistanceField::New();
}

PyObject *PyttkSignedDistanceField_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkSignedDistanceField_Type, PyttkSignedDistanceField_Methods,
    "ttkSignedDistanceField",
 &PyttkSignedDistanceField_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkSignedDistanceField_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkSignedDistanceField(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkSignedDistanceField_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkSignedDistanceField", o) != 0)
  {
    Py_DECREF(o);
  }

}

