/* WallpaperOperation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WallpaperOperation.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 */

#include "desktop.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN gchar** pantheon_shell_wallpaper_operation_get_system_bg_directories (gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GFile* pantheon_shell_wallpaper_operation_ensure_local_bg_exists (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
pantheon_shell_wallpaper_operation_get_local_bg_directory (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "backgrounds", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
pantheon_shell_wallpaper_operation_get_system_bg_directories (gint* result_length1)
{
	gchar** directories = NULL;
	gchar** _tmp0_;
	gint directories_length1;
	gint _directories_size_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	directories = _tmp0_;
	directories_length1 = 0;
	_directories_size_ = directories_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp2_;
		data_dir_collection_length1 = _vala_array_length (_tmp1_);
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar* system_background_dir = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp3_ = data_dir;
				_tmp4_ = g_build_filename (_tmp3_, "backgrounds", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (_tmp5_, "/", NULL);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				system_background_dir = _tmp7_;
				_tmp8_ = system_background_dir;
				if (g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) {
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = system_background_dir;
					g_debug ("WallpaperOperation.vala:16: Found system background directory: %s", _tmp9_);
					_tmp10_ = system_background_dir;
					_tmp11_ = g_strdup (_tmp10_);
					_vala_array_add1 (&directories, &directories_length1, &_directories_size_, _tmp11_);
				}
				_g_free0 (system_background_dir);
			}
		}
	}
	_tmp12_ = directories;
	_tmp12__length1 = directories_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
pantheon_shell_wallpaper_operation_get_bg_directories (gint* result_length1)
{
	gchar** background_directories = NULL;
	gchar** _tmp0_;
	gint background_directories_length1;
	gint _background_directories_size_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	background_directories = _tmp0_;
	background_directories_length1 = 0;
	_background_directories_size_ = background_directories_length1;
	_tmp1_ = pantheon_shell_wallpaper_operation_get_local_bg_directory ();
	_vala_array_add2 (&background_directories, &background_directories_length1, &_background_directories_size_, _tmp1_);
	_tmp3_ = pantheon_shell_wallpaper_operation_get_system_bg_directories (&_tmp2_);
	{
		gchar** bg_dir_collection = NULL;
		gint bg_dir_collection_length1 = 0;
		gint _bg_dir_collection_size_ = 0;
		gint bg_dir_it = 0;
		bg_dir_collection = _tmp3_;
		bg_dir_collection_length1 = _tmp2_;
		for (bg_dir_it = 0; bg_dir_it < bg_dir_collection_length1; bg_dir_it = bg_dir_it + 1) {
			gchar* _tmp4_;
			gchar* bg_dir = NULL;
			_tmp4_ = g_strdup (bg_dir_collection[bg_dir_it]);
			bg_dir = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = bg_dir;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add3 (&background_directories, &background_directories_length1, &_background_directories_size_, _tmp6_);
				_g_free0 (bg_dir);
			}
		}
		bg_dir_collection = (_vala_array_free (bg_dir_collection, bg_dir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = background_directories;
	_tmp7__length1 = background_directories_length1;
	if (_tmp7__length1 == 0) {
		g_warning ("WallpaperOperation.vala:35: No background directories found");
	}
	_tmp8_ = background_directories;
	_tmp8__length1 = background_directories_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

GFile*
pantheon_shell_wallpaper_operation_ensure_local_bg_exists (void)
{
	GFile* folder = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	_tmp0_ = pantheon_shell_wallpaper_operation_get_local_bg_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	folder = _tmp3_;
	_tmp4_ = folder;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		{
			GFile* _tmp5_;
			_tmp5_ = folder;
			g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("WallpaperOperation.vala:47: %s", _tmp7_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = folder;
	return result;
}

GFile*
pantheon_shell_wallpaper_operation_copy_for_library (GFile* source)
{
	GFile* dest = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (source != NULL, NULL);
	dest = NULL;
	{
		gchar* timestamp = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* filename = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp0_ = g_date_time_new_now_local ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_date_time_format (_tmp1_, "%Y-%m-%d-%H-%M-%S");
		_tmp3_ = _tmp2_;
		_g_date_time_unref0 (_tmp1_);
		timestamp = _tmp3_;
		_tmp4_ = g_file_get_basename (source);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s-%s", timestamp, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		filename = _tmp7_;
		_tmp8_ = pantheon_shell_wallpaper_operation_ensure_local_bg_exists ();
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_child (_tmp9_, filename);
		_g_object_unref0 (dest);
		dest = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_tmp11_ = dest;
		g_file_copy (source, _tmp11_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			_g_free0 (timestamp);
			goto __catch0_g_error;
		}
		_g_free0 (filename);
		_g_free0 (timestamp);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("WallpaperOperation.vala:63: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = dest;
	return result;
}

gboolean
pantheon_shell_wallpaper_operation_get_is_file_in_bg_dir (GFile* file)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_path (file);
	path = _tmp0_;
	_tmp2_ = pantheon_shell_wallpaper_operation_get_bg_directories (&_tmp1_);
	{
		gchar** directory_collection = NULL;
		gint directory_collection_length1 = 0;
		gint _directory_collection_size_ = 0;
		gint directory_it = 0;
		directory_collection = _tmp2_;
		directory_collection_length1 = _tmp1_;
		for (directory_it = 0; directory_it < directory_collection_length1; directory_it = directory_it + 1) {
			const gchar* directory = NULL;
			directory = directory_collection[directory_it];
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = path;
				_tmp4_ = directory;
				if (g_str_has_prefix (_tmp3_, _tmp4_)) {
					result = TRUE;
					directory_collection = (_vala_array_free (directory_collection, directory_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (path);
					return result;
				}
			}
		}
		directory_collection = (_vala_array_free (directory_collection, directory_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_free0 (path);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

