// MIT License
//
// Copyright (c) 2024-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

#include <memory>
#include <unordered_map>
#include <vector>
#include "att_lib_wrapper.hpp"

namespace rocprofiler
{
namespace att_wrapper
{
void
PerfcounterFile(class WaveConfig& config, const perfevent_t* events, size_t event_count);

class RealtimeTS
{
public:
    using realtime_vec_t = std::vector<realtime_t>;
    using shader_map_t   = std::unordered_map<int, realtime_vec_t>;

    RealtimeTS(const Fspath& dir)
    : path(dir / "realtime.json"){};
    ~RealtimeTS();

    void     add(int shader, const realtime_t* events, size_t event_count);
    uint64_t frequency{0};

private:
    const Fspath path;
    shader_map_t aggregated{};  ///< Stores all RT values so far.
};

}  // namespace att_wrapper
}  // namespace rocprofiler
