// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from webkit-gir-files
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAuthenticationScheme")]
pub enum AuthenticationScheme {
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_DEFAULT")]
    Default,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC")]
    HttpBasic,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST")]
    HttpDigest,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM")]
    HtmlForm,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_NTLM")]
    Ntlm,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE")]
    Negotiate,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED")]
    ClientCertificateRequested,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED")]
    ServerTrustEvaluationRequested,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED")]
    ClientCertificatePinRequested,
    #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for AuthenticationScheme {
    type GlibType = ffi::WebKitAuthenticationScheme;

    #[inline]
    fn into_glib(self) -> ffi::WebKitAuthenticationScheme {
        match self {
            Self::Default => ffi::WEBKIT_AUTHENTICATION_SCHEME_DEFAULT,
            Self::HttpBasic => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC,
            Self::HttpDigest => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST,
            Self::HtmlForm => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM,
            Self::Ntlm => ffi::WEBKIT_AUTHENTICATION_SCHEME_NTLM,
            Self::Negotiate => ffi::WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE,
            Self::ClientCertificateRequested => {
                ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED
            }
            Self::ServerTrustEvaluationRequested => {
                ffi::WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED
            }
            Self::ClientCertificatePinRequested => {
                ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED
            }
            Self::Unknown => ffi::WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitAuthenticationScheme> for AuthenticationScheme {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitAuthenticationScheme) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_AUTHENTICATION_SCHEME_DEFAULT => Self::Default,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC => Self::HttpBasic,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST => Self::HttpDigest,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM => Self::HtmlForm,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_NTLM => Self::Ntlm,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE => Self::Negotiate,
            ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED => {
                Self::ClientCertificateRequested
            }
            ffi::WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED => {
                Self::ServerTrustEvaluationRequested
            }
            ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED => {
                Self::ClientCertificatePinRequested
            }
            ffi::WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AuthenticationScheme {
    #[inline]
    #[doc(alias = "webkit_authentication_scheme_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_authentication_scheme_get_type()) }
    }
}

impl glib::HasParamSpec for AuthenticationScheme {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for AuthenticationScheme {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for AuthenticationScheme {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AuthenticationScheme {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<AuthenticationScheme> for glib::Value {
    #[inline]
    fn from(v: AuthenticationScheme) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAutomationBrowsingContextPresentation")]
pub enum AutomationBrowsingContextPresentation {
    #[doc(alias = "WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW")]
    Window,
    #[doc(alias = "WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB")]
    Tab,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for AutomationBrowsingContextPresentation {
    type GlibType = ffi::WebKitAutomationBrowsingContextPresentation;

    #[inline]
    fn into_glib(self) -> ffi::WebKitAutomationBrowsingContextPresentation {
        match self {
            Self::Window => ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW,
            Self::Tab => ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitAutomationBrowsingContextPresentation>
    for AutomationBrowsingContextPresentation
{
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitAutomationBrowsingContextPresentation) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW => Self::Window,
            ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB => Self::Tab,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AutomationBrowsingContextPresentation {
    #[inline]
    #[doc(alias = "webkit_automation_browsing_context_presentation_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_automation_browsing_context_presentation_get_type()) }
    }
}

impl glib::HasParamSpec for AutomationBrowsingContextPresentation {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for AutomationBrowsingContextPresentation {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for AutomationBrowsingContextPresentation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AutomationBrowsingContextPresentation {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<AutomationBrowsingContextPresentation> for glib::Value {
    #[inline]
    fn from(v: AutomationBrowsingContextPresentation) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAutoplayPolicy")]
pub enum AutoplayPolicy {
    #[doc(alias = "WEBKIT_AUTOPLAY_ALLOW")]
    Allow,
    #[doc(alias = "WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND")]
    AllowWithoutSound,
    #[doc(alias = "WEBKIT_AUTOPLAY_DENY")]
    Deny,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for AutoplayPolicy {
    type GlibType = ffi::WebKitAutoplayPolicy;

    #[inline]
    fn into_glib(self) -> ffi::WebKitAutoplayPolicy {
        match self {
            Self::Allow => ffi::WEBKIT_AUTOPLAY_ALLOW,
            Self::AllowWithoutSound => ffi::WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND,
            Self::Deny => ffi::WEBKIT_AUTOPLAY_DENY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitAutoplayPolicy> for AutoplayPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitAutoplayPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_AUTOPLAY_ALLOW => Self::Allow,
            ffi::WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND => Self::AllowWithoutSound,
            ffi::WEBKIT_AUTOPLAY_DENY => Self::Deny,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AutoplayPolicy {
    #[inline]
    #[doc(alias = "webkit_autoplay_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_autoplay_policy_get_type()) }
    }
}

impl glib::HasParamSpec for AutoplayPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for AutoplayPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for AutoplayPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AutoplayPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<AutoplayPolicy> for glib::Value {
    #[inline]
    fn from(v: AutoplayPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCacheModel")]
pub enum CacheModel {
    #[doc(alias = "WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER")]
    DocumentViewer,
    #[doc(alias = "WEBKIT_CACHE_MODEL_WEB_BROWSER")]
    WebBrowser,
    #[doc(alias = "WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER")]
    DocumentBrowser,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CacheModel {
    type GlibType = ffi::WebKitCacheModel;

    #[inline]
    fn into_glib(self) -> ffi::WebKitCacheModel {
        match self {
            Self::DocumentViewer => ffi::WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER,
            Self::WebBrowser => ffi::WEBKIT_CACHE_MODEL_WEB_BROWSER,
            Self::DocumentBrowser => ffi::WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCacheModel> for CacheModel {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitCacheModel) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER => Self::DocumentViewer,
            ffi::WEBKIT_CACHE_MODEL_WEB_BROWSER => Self::WebBrowser,
            ffi::WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER => Self::DocumentBrowser,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CacheModel {
    #[inline]
    #[doc(alias = "webkit_cache_model_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_cache_model_get_type()) }
    }
}

impl glib::HasParamSpec for CacheModel {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CacheModel {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CacheModel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CacheModel {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CacheModel> for glib::Value {
    #[inline]
    fn from(v: CacheModel) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitContextMenuAction")]
pub enum ContextMenuAction {
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION")]
    NoAction,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK")]
    OpenLink,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW")]
    OpenLinkInNewWindow,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK")]
    DownloadLinkToDisk,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD")]
    CopyLinkToClipboard,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW")]
    OpenImageInNewWindow,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK")]
    DownloadImageToDisk,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD")]
    CopyImageToClipboard,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD")]
    CopyImageUrlToClipboard,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW")]
    OpenFrameInNewWindow,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_GO_BACK")]
    GoBack,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD")]
    GoForward,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_STOP")]
    Stop,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_RELOAD")]
    Reload,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY")]
    Copy,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_CUT")]
    Cut,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_PASTE")]
    Paste,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DELETE")]
    Delete,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL")]
    SelectAll,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS")]
    InputMethods,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_UNICODE")]
    Unicode,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS")]
    SpellingGuess,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND")]
    NoGuessesFound,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING")]
    IgnoreSpelling,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING")]
    LearnSpelling,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR")]
    IgnoreGrammar,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU")]
    FontMenu,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_BOLD")]
    Bold,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_ITALIC")]
    Italic,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE")]
    Underline,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OUTLINE")]
    Outline,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT")]
    InspectElement,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW")]
    OpenVideoInNewWindow,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW")]
    OpenAudioInNewWindow,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD")]
    CopyVideoLinkToClipboard,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD")]
    CopyAudioLinkToClipboard,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS")]
    ToggleMediaControls,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP")]
    ToggleMediaLoop,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN")]
    EnterVideoFullscreen,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY")]
    MediaPlay,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE")]
    MediaPause,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE")]
    MediaMute,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK")]
    DownloadVideoToDisk,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK")]
    DownloadAudioToDisk,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI")]
    InsertEmoji,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT")]
    PasteAsPlainText,
    #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_CUSTOM")]
    Custom,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ContextMenuAction {
    type GlibType = ffi::WebKitContextMenuAction;

    fn into_glib(self) -> ffi::WebKitContextMenuAction {
        match self {
            Self::NoAction => ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION,
            Self::OpenLink => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK,
            Self::OpenLinkInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW,
            Self::DownloadLinkToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK,
            Self::CopyLinkToClipboard => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD,
            Self::OpenImageInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW,
            Self::DownloadImageToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK,
            Self::CopyImageToClipboard => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD,
            Self::CopyImageUrlToClipboard => {
                ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD
            }
            Self::OpenFrameInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW,
            Self::GoBack => ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_BACK,
            Self::GoForward => ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD,
            Self::Stop => ffi::WEBKIT_CONTEXT_MENU_ACTION_STOP,
            Self::Reload => ffi::WEBKIT_CONTEXT_MENU_ACTION_RELOAD,
            Self::Copy => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY,
            Self::Cut => ffi::WEBKIT_CONTEXT_MENU_ACTION_CUT,
            Self::Paste => ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE,
            Self::Delete => ffi::WEBKIT_CONTEXT_MENU_ACTION_DELETE,
            Self::SelectAll => ffi::WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL,
            Self::InputMethods => ffi::WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS,
            Self::Unicode => ffi::WEBKIT_CONTEXT_MENU_ACTION_UNICODE,
            Self::SpellingGuess => ffi::WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS,
            Self::NoGuessesFound => ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND,
            Self::IgnoreSpelling => ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING,
            Self::LearnSpelling => ffi::WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING,
            Self::IgnoreGrammar => ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR,
            Self::FontMenu => ffi::WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU,
            Self::Bold => ffi::WEBKIT_CONTEXT_MENU_ACTION_BOLD,
            Self::Italic => ffi::WEBKIT_CONTEXT_MENU_ACTION_ITALIC,
            Self::Underline => ffi::WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE,
            Self::Outline => ffi::WEBKIT_CONTEXT_MENU_ACTION_OUTLINE,
            Self::InspectElement => ffi::WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT,
            Self::OpenVideoInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW,
            Self::OpenAudioInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW,
            Self::CopyVideoLinkToClipboard => {
                ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD
            }
            Self::CopyAudioLinkToClipboard => {
                ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD
            }
            Self::ToggleMediaControls => ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS,
            Self::ToggleMediaLoop => ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP,
            Self::EnterVideoFullscreen => ffi::WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN,
            Self::MediaPlay => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY,
            Self::MediaPause => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE,
            Self::MediaMute => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE,
            Self::DownloadVideoToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK,
            Self::DownloadAudioToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK,
            Self::InsertEmoji => ffi::WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI,
            Self::PasteAsPlainText => ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT,
            Self::Custom => ffi::WEBKIT_CONTEXT_MENU_ACTION_CUSTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitContextMenuAction> for ContextMenuAction {
    unsafe fn from_glib(value: ffi::WebKitContextMenuAction) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION => Self::NoAction,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK => Self::OpenLink,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW => Self::OpenLinkInNewWindow,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK => Self::DownloadLinkToDisk,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD => Self::CopyLinkToClipboard,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW => Self::OpenImageInNewWindow,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK => Self::DownloadImageToDisk,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD => Self::CopyImageToClipboard,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD => {
                Self::CopyImageUrlToClipboard
            }
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW => Self::OpenFrameInNewWindow,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_BACK => Self::GoBack,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD => Self::GoForward,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_STOP => Self::Stop,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_RELOAD => Self::Reload,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY => Self::Copy,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_CUT => Self::Cut,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE => Self::Paste,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_DELETE => Self::Delete,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL => Self::SelectAll,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS => Self::InputMethods,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_UNICODE => Self::Unicode,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS => Self::SpellingGuess,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND => Self::NoGuessesFound,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING => Self::IgnoreSpelling,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING => Self::LearnSpelling,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR => Self::IgnoreGrammar,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU => Self::FontMenu,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_BOLD => Self::Bold,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_ITALIC => Self::Italic,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE => Self::Underline,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OUTLINE => Self::Outline,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT => Self::InspectElement,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW => Self::OpenVideoInNewWindow,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW => Self::OpenAudioInNewWindow,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD => {
                Self::CopyVideoLinkToClipboard
            }
            ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD => {
                Self::CopyAudioLinkToClipboard
            }
            ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS => Self::ToggleMediaControls,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP => Self::ToggleMediaLoop,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN => Self::EnterVideoFullscreen,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY => Self::MediaPlay,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE => Self::MediaPause,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE => Self::MediaMute,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK => Self::DownloadVideoToDisk,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK => Self::DownloadAudioToDisk,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI => Self::InsertEmoji,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT => Self::PasteAsPlainText,
            ffi::WEBKIT_CONTEXT_MENU_ACTION_CUSTOM => Self::Custom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ContextMenuAction {
    #[inline]
    #[doc(alias = "webkit_context_menu_action_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_context_menu_action_get_type()) }
    }
}

impl glib::HasParamSpec for ContextMenuAction {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ContextMenuAction {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ContextMenuAction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ContextMenuAction {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ContextMenuAction> for glib::Value {
    #[inline]
    fn from(v: ContextMenuAction) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCookieAcceptPolicy")]
pub enum CookieAcceptPolicy {
    #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS")]
    Always,
    #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_NEVER")]
    Never,
    #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY")]
    NoThirdParty,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CookieAcceptPolicy {
    type GlibType = ffi::WebKitCookieAcceptPolicy;

    #[inline]
    fn into_glib(self) -> ffi::WebKitCookieAcceptPolicy {
        match self {
            Self::Always => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS,
            Self::Never => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NEVER,
            Self::NoThirdParty => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCookieAcceptPolicy> for CookieAcceptPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitCookieAcceptPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS => Self::Always,
            ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NEVER => Self::Never,
            ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY => Self::NoThirdParty,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CookieAcceptPolicy {
    #[inline]
    #[doc(alias = "webkit_cookie_accept_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_cookie_accept_policy_get_type()) }
    }
}

impl glib::HasParamSpec for CookieAcceptPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CookieAcceptPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CookieAcceptPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CookieAcceptPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CookieAcceptPolicy> for glib::Value {
    #[inline]
    fn from(v: CookieAcceptPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCookiePersistentStorage")]
pub enum CookiePersistentStorage {
    #[doc(alias = "WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT")]
    Text,
    #[doc(alias = "WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE")]
    Sqlite,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CookiePersistentStorage {
    type GlibType = ffi::WebKitCookiePersistentStorage;

    #[inline]
    fn into_glib(self) -> ffi::WebKitCookiePersistentStorage {
        match self {
            Self::Text => ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT,
            Self::Sqlite => ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCookiePersistentStorage> for CookiePersistentStorage {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitCookiePersistentStorage) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT => Self::Text,
            ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE => Self::Sqlite,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CookiePersistentStorage {
    #[inline]
    #[doc(alias = "webkit_cookie_persistent_storage_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_cookie_persistent_storage_get_type()) }
    }
}

impl glib::HasParamSpec for CookiePersistentStorage {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CookiePersistentStorage {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CookiePersistentStorage {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CookiePersistentStorage {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CookiePersistentStorage> for glib::Value {
    #[inline]
    fn from(v: CookiePersistentStorage) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCredentialPersistence")]
pub enum CredentialPersistence {
    #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_NONE")]
    None,
    #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION")]
    ForSession,
    #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT")]
    Permanent,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for CredentialPersistence {
    type GlibType = ffi::WebKitCredentialPersistence;

    #[inline]
    fn into_glib(self) -> ffi::WebKitCredentialPersistence {
        match self {
            Self::None => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_NONE,
            Self::ForSession => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION,
            Self::Permanent => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCredentialPersistence> for CredentialPersistence {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitCredentialPersistence) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_CREDENTIAL_PERSISTENCE_NONE => Self::None,
            ffi::WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION => Self::ForSession,
            ffi::WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT => Self::Permanent,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for CredentialPersistence {
    #[inline]
    #[doc(alias = "webkit_credential_persistence_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_credential_persistence_get_type()) }
    }
}

impl glib::HasParamSpec for CredentialPersistence {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for CredentialPersistence {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for CredentialPersistence {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for CredentialPersistence {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<CredentialPersistence> for glib::Value {
    #[inline]
    fn from(v: CredentialPersistence) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitDownloadError")]
pub enum DownloadError {
    #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_NETWORK")]
    Network,
    #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER")]
    CancelledByUser,
    #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_DESTINATION")]
    Destination,
    #[doc(hidden)]
    __Unknown(i32),
}

impl DownloadError {
    #[doc(alias = "webkit_download_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_download_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for DownloadError {
    type GlibType = ffi::WebKitDownloadError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitDownloadError {
        match self {
            Self::Network => ffi::WEBKIT_DOWNLOAD_ERROR_NETWORK,
            Self::CancelledByUser => ffi::WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER,
            Self::Destination => ffi::WEBKIT_DOWNLOAD_ERROR_DESTINATION,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitDownloadError> for DownloadError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitDownloadError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_DOWNLOAD_ERROR_NETWORK => Self::Network,
            ffi::WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER => Self::CancelledByUser,
            ffi::WEBKIT_DOWNLOAD_ERROR_DESTINATION => Self::Destination,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for DownloadError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitDownloadError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for DownloadError {
    #[inline]
    #[doc(alias = "webkit_download_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_download_error_get_type()) }
    }
}

impl glib::HasParamSpec for DownloadError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for DownloadError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for DownloadError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DownloadError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<DownloadError> for glib::Value {
    #[inline]
    fn from(v: DownloadError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitFaviconDatabaseError")]
pub enum FaviconDatabaseError {
    #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED")]
    NotInitialized,
    #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND")]
    FaviconNotFound,
    #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN")]
    FaviconUnknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl FaviconDatabaseError {
    #[doc(alias = "webkit_favicon_database_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_favicon_database_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for FaviconDatabaseError {
    type GlibType = ffi::WebKitFaviconDatabaseError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitFaviconDatabaseError {
        match self {
            Self::NotInitialized => ffi::WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED,
            Self::FaviconNotFound => ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND,
            Self::FaviconUnknown => ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitFaviconDatabaseError> for FaviconDatabaseError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitFaviconDatabaseError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED => Self::NotInitialized,
            ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND => Self::FaviconNotFound,
            ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN => Self::FaviconUnknown,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for FaviconDatabaseError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(
                b"WebKitFaviconDatabaseError\0".as_ptr() as *const _
            )
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for FaviconDatabaseError {
    #[inline]
    #[doc(alias = "webkit_favicon_database_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_favicon_database_error_get_type()) }
    }
}

impl glib::HasParamSpec for FaviconDatabaseError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for FaviconDatabaseError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for FaviconDatabaseError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FaviconDatabaseError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<FaviconDatabaseError> for glib::Value {
    #[inline]
    fn from(v: FaviconDatabaseError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitFeatureStatus")]
pub enum FeatureStatus {
    #[doc(alias = "WEBKIT_FEATURE_STATUS_EMBEDDER")]
    Embedder,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_UNSTABLE")]
    Unstable,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_INTERNAL")]
    Internal,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_DEVELOPER")]
    Developer,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_TESTABLE")]
    Testable,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_PREVIEW")]
    Preview,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_STABLE")]
    Stable,
    #[doc(alias = "WEBKIT_FEATURE_STATUS_MATURE")]
    Mature,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
#[doc(hidden)]
impl IntoGlib for FeatureStatus {
    type GlibType = ffi::WebKitFeatureStatus;

    #[inline]
    fn into_glib(self) -> ffi::WebKitFeatureStatus {
        match self {
            Self::Embedder => ffi::WEBKIT_FEATURE_STATUS_EMBEDDER,
            Self::Unstable => ffi::WEBKIT_FEATURE_STATUS_UNSTABLE,
            Self::Internal => ffi::WEBKIT_FEATURE_STATUS_INTERNAL,
            Self::Developer => ffi::WEBKIT_FEATURE_STATUS_DEVELOPER,
            Self::Testable => ffi::WEBKIT_FEATURE_STATUS_TESTABLE,
            Self::Preview => ffi::WEBKIT_FEATURE_STATUS_PREVIEW,
            Self::Stable => ffi::WEBKIT_FEATURE_STATUS_STABLE,
            Self::Mature => ffi::WEBKIT_FEATURE_STATUS_MATURE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitFeatureStatus> for FeatureStatus {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitFeatureStatus) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_FEATURE_STATUS_EMBEDDER => Self::Embedder,
            ffi::WEBKIT_FEATURE_STATUS_UNSTABLE => Self::Unstable,
            ffi::WEBKIT_FEATURE_STATUS_INTERNAL => Self::Internal,
            ffi::WEBKIT_FEATURE_STATUS_DEVELOPER => Self::Developer,
            ffi::WEBKIT_FEATURE_STATUS_TESTABLE => Self::Testable,
            ffi::WEBKIT_FEATURE_STATUS_PREVIEW => Self::Preview,
            ffi::WEBKIT_FEATURE_STATUS_STABLE => Self::Stable,
            ffi::WEBKIT_FEATURE_STATUS_MATURE => Self::Mature,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
impl StaticType for FeatureStatus {
    #[inline]
    #[doc(alias = "webkit_feature_status_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_feature_status_get_type()) }
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
impl glib::HasParamSpec for FeatureStatus {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
impl glib::value::ValueType for FeatureStatus {
    type Type = Self;
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
unsafe impl<'a> glib::value::FromValue<'a> for FeatureStatus {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
impl ToValue for FeatureStatus {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(feature = "v2_42")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_42")))]
impl From<FeatureStatus> for glib::Value {
    #[inline]
    fn from(v: FeatureStatus) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitHardwareAccelerationPolicy")]
pub enum HardwareAccelerationPolicy {
    #[doc(alias = "WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS")]
    Always,
    #[doc(alias = "WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER")]
    Never,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for HardwareAccelerationPolicy {
    type GlibType = ffi::WebKitHardwareAccelerationPolicy;

    #[inline]
    fn into_glib(self) -> ffi::WebKitHardwareAccelerationPolicy {
        match self {
            Self::Always => ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS,
            Self::Never => ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitHardwareAccelerationPolicy> for HardwareAccelerationPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitHardwareAccelerationPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS => Self::Always,
            ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER => Self::Never,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for HardwareAccelerationPolicy {
    #[inline]
    #[doc(alias = "webkit_hardware_acceleration_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_hardware_acceleration_policy_get_type()) }
    }
}

impl glib::HasParamSpec for HardwareAccelerationPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for HardwareAccelerationPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for HardwareAccelerationPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for HardwareAccelerationPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<HardwareAccelerationPolicy> for glib::Value {
    #[inline]
    fn from(v: HardwareAccelerationPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitInputPurpose")]
pub enum InputPurpose {
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_FREE_FORM")]
    FreeForm,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_DIGITS")]
    Digits,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_NUMBER")]
    Number,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_PHONE")]
    Phone,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_URL")]
    Url,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_EMAIL")]
    Email,
    #[doc(alias = "WEBKIT_INPUT_PURPOSE_PASSWORD")]
    Password,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for InputPurpose {
    type GlibType = ffi::WebKitInputPurpose;

    #[inline]
    fn into_glib(self) -> ffi::WebKitInputPurpose {
        match self {
            Self::FreeForm => ffi::WEBKIT_INPUT_PURPOSE_FREE_FORM,
            Self::Digits => ffi::WEBKIT_INPUT_PURPOSE_DIGITS,
            Self::Number => ffi::WEBKIT_INPUT_PURPOSE_NUMBER,
            Self::Phone => ffi::WEBKIT_INPUT_PURPOSE_PHONE,
            Self::Url => ffi::WEBKIT_INPUT_PURPOSE_URL,
            Self::Email => ffi::WEBKIT_INPUT_PURPOSE_EMAIL,
            Self::Password => ffi::WEBKIT_INPUT_PURPOSE_PASSWORD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitInputPurpose> for InputPurpose {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitInputPurpose) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_INPUT_PURPOSE_FREE_FORM => Self::FreeForm,
            ffi::WEBKIT_INPUT_PURPOSE_DIGITS => Self::Digits,
            ffi::WEBKIT_INPUT_PURPOSE_NUMBER => Self::Number,
            ffi::WEBKIT_INPUT_PURPOSE_PHONE => Self::Phone,
            ffi::WEBKIT_INPUT_PURPOSE_URL => Self::Url,
            ffi::WEBKIT_INPUT_PURPOSE_EMAIL => Self::Email,
            ffi::WEBKIT_INPUT_PURPOSE_PASSWORD => Self::Password,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for InputPurpose {
    #[inline]
    #[doc(alias = "webkit_input_purpose_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_input_purpose_get_type()) }
    }
}

impl glib::HasParamSpec for InputPurpose {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for InputPurpose {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for InputPurpose {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for InputPurpose {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<InputPurpose> for glib::Value {
    #[inline]
    fn from(v: InputPurpose) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[cfg_attr(feature = "v2_46", deprecated = "Since 2.46")]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitInsecureContentEvent")]
pub enum InsecureContentEvent {
    #[doc(alias = "WEBKIT_INSECURE_CONTENT_RUN")]
    Run,
    #[doc(alias = "WEBKIT_INSECURE_CONTENT_DISPLAYED")]
    Displayed,
    #[doc(hidden)]
    __Unknown(i32),
}

#[allow(deprecated)]
#[doc(hidden)]
impl IntoGlib for InsecureContentEvent {
    type GlibType = ffi::WebKitInsecureContentEvent;

    #[inline]
    fn into_glib(self) -> ffi::WebKitInsecureContentEvent {
        match self {
            Self::Run => ffi::WEBKIT_INSECURE_CONTENT_RUN,
            Self::Displayed => ffi::WEBKIT_INSECURE_CONTENT_DISPLAYED,
            Self::__Unknown(value) => value,
        }
    }
}

#[allow(deprecated)]
#[doc(hidden)]
impl FromGlib<ffi::WebKitInsecureContentEvent> for InsecureContentEvent {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitInsecureContentEvent) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_INSECURE_CONTENT_RUN => Self::Run,
            ffi::WEBKIT_INSECURE_CONTENT_DISPLAYED => Self::Displayed,
            value => Self::__Unknown(value),
        }
    }
}

#[allow(deprecated)]
impl StaticType for InsecureContentEvent {
    #[inline]
    #[doc(alias = "webkit_insecure_content_event_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_insecure_content_event_get_type()) }
    }
}

#[allow(deprecated)]
impl glib::HasParamSpec for InsecureContentEvent {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

#[allow(deprecated)]
impl glib::value::ValueType for InsecureContentEvent {
    type Type = Self;
}

#[allow(deprecated)]
unsafe impl<'a> glib::value::FromValue<'a> for InsecureContentEvent {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[allow(deprecated)]
impl ToValue for InsecureContentEvent {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[allow(deprecated)]
impl From<InsecureContentEvent> for glib::Value {
    #[inline]
    fn from(v: InsecureContentEvent) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitJavascriptError")]
pub enum JavascriptError {
    #[doc(alias = "WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED")]
    ScriptFailed,
    #[doc(alias = "WEBKIT_JAVASCRIPT_ERROR_INVALID_PARAMETER")]
    InvalidParameter,
    #[doc(alias = "WEBKIT_JAVASCRIPT_ERROR_INVALID_RESULT")]
    InvalidResult,
    #[doc(hidden)]
    __Unknown(i32),
}

impl JavascriptError {
    #[doc(alias = "webkit_javascript_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_javascript_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for JavascriptError {
    type GlibType = ffi::WebKitJavascriptError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitJavascriptError {
        match self {
            Self::ScriptFailed => ffi::WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED,
            Self::InvalidParameter => ffi::WEBKIT_JAVASCRIPT_ERROR_INVALID_PARAMETER,
            Self::InvalidResult => ffi::WEBKIT_JAVASCRIPT_ERROR_INVALID_RESULT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitJavascriptError> for JavascriptError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitJavascriptError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED => Self::ScriptFailed,
            ffi::WEBKIT_JAVASCRIPT_ERROR_INVALID_PARAMETER => Self::InvalidParameter,
            ffi::WEBKIT_JAVASCRIPT_ERROR_INVALID_RESULT => Self::InvalidResult,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for JavascriptError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitJavascriptError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for JavascriptError {
    #[inline]
    #[doc(alias = "webkit_javascript_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_javascript_error_get_type()) }
    }
}

impl glib::HasParamSpec for JavascriptError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for JavascriptError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for JavascriptError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for JavascriptError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<JavascriptError> for glib::Value {
    #[inline]
    fn from(v: JavascriptError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitLoadEvent")]
pub enum LoadEvent {
    #[doc(alias = "WEBKIT_LOAD_STARTED")]
    Started,
    #[doc(alias = "WEBKIT_LOAD_REDIRECTED")]
    Redirected,
    #[doc(alias = "WEBKIT_LOAD_COMMITTED")]
    Committed,
    #[doc(alias = "WEBKIT_LOAD_FINISHED")]
    Finished,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for LoadEvent {
    type GlibType = ffi::WebKitLoadEvent;

    #[inline]
    fn into_glib(self) -> ffi::WebKitLoadEvent {
        match self {
            Self::Started => ffi::WEBKIT_LOAD_STARTED,
            Self::Redirected => ffi::WEBKIT_LOAD_REDIRECTED,
            Self::Committed => ffi::WEBKIT_LOAD_COMMITTED,
            Self::Finished => ffi::WEBKIT_LOAD_FINISHED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitLoadEvent> for LoadEvent {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitLoadEvent) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_LOAD_STARTED => Self::Started,
            ffi::WEBKIT_LOAD_REDIRECTED => Self::Redirected,
            ffi::WEBKIT_LOAD_COMMITTED => Self::Committed,
            ffi::WEBKIT_LOAD_FINISHED => Self::Finished,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for LoadEvent {
    #[inline]
    #[doc(alias = "webkit_load_event_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_load_event_get_type()) }
    }
}

impl glib::HasParamSpec for LoadEvent {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for LoadEvent {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for LoadEvent {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for LoadEvent {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<LoadEvent> for glib::Value {
    #[inline]
    fn from(v: LoadEvent) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitMediaCaptureState")]
pub enum MediaCaptureState {
    #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_NONE")]
    None,
    #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE")]
    Active,
    #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_MUTED")]
    Muted,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for MediaCaptureState {
    type GlibType = ffi::WebKitMediaCaptureState;

    #[inline]
    fn into_glib(self) -> ffi::WebKitMediaCaptureState {
        match self {
            Self::None => ffi::WEBKIT_MEDIA_CAPTURE_STATE_NONE,
            Self::Active => ffi::WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE,
            Self::Muted => ffi::WEBKIT_MEDIA_CAPTURE_STATE_MUTED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitMediaCaptureState> for MediaCaptureState {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitMediaCaptureState) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_MEDIA_CAPTURE_STATE_NONE => Self::None,
            ffi::WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE => Self::Active,
            ffi::WEBKIT_MEDIA_CAPTURE_STATE_MUTED => Self::Muted,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MediaCaptureState {
    #[inline]
    #[doc(alias = "webkit_media_capture_state_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_media_capture_state_get_type()) }
    }
}

impl glib::HasParamSpec for MediaCaptureState {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for MediaCaptureState {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for MediaCaptureState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MediaCaptureState {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<MediaCaptureState> for glib::Value {
    #[inline]
    fn from(v: MediaCaptureState) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitMediaError")]
pub enum MediaError {
    #[doc(alias = "WEBKIT_MEDIA_ERROR_WILL_HANDLE_LOAD")]
    Load,
    #[doc(hidden)]
    __Unknown(i32),
}

impl MediaError {
    #[doc(alias = "webkit_media_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_media_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for MediaError {
    type GlibType = ffi::WebKitMediaError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitMediaError {
        match self {
            Self::Load => ffi::WEBKIT_MEDIA_ERROR_WILL_HANDLE_LOAD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitMediaError> for MediaError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitMediaError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_MEDIA_ERROR_WILL_HANDLE_LOAD => Self::Load,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for MediaError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitMediaError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for MediaError {
    #[inline]
    #[doc(alias = "webkit_media_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_media_error_get_type()) }
    }
}

impl glib::HasParamSpec for MediaError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for MediaError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for MediaError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MediaError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<MediaError> for glib::Value {
    #[inline]
    fn from(v: MediaError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNavigationType")]
pub enum NavigationType {
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_LINK_CLICKED")]
    LinkClicked,
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED")]
    FormSubmitted,
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_BACK_FORWARD")]
    BackForward,
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_RELOAD")]
    Reload,
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED")]
    FormResubmitted,
    #[doc(alias = "WEBKIT_NAVIGATION_TYPE_OTHER")]
    Other,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NavigationType {
    type GlibType = ffi::WebKitNavigationType;

    #[inline]
    fn into_glib(self) -> ffi::WebKitNavigationType {
        match self {
            Self::LinkClicked => ffi::WEBKIT_NAVIGATION_TYPE_LINK_CLICKED,
            Self::FormSubmitted => ffi::WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED,
            Self::BackForward => ffi::WEBKIT_NAVIGATION_TYPE_BACK_FORWARD,
            Self::Reload => ffi::WEBKIT_NAVIGATION_TYPE_RELOAD,
            Self::FormResubmitted => ffi::WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED,
            Self::Other => ffi::WEBKIT_NAVIGATION_TYPE_OTHER,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitNavigationType> for NavigationType {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitNavigationType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_NAVIGATION_TYPE_LINK_CLICKED => Self::LinkClicked,
            ffi::WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED => Self::FormSubmitted,
            ffi::WEBKIT_NAVIGATION_TYPE_BACK_FORWARD => Self::BackForward,
            ffi::WEBKIT_NAVIGATION_TYPE_RELOAD => Self::Reload,
            ffi::WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED => Self::FormResubmitted,
            ffi::WEBKIT_NAVIGATION_TYPE_OTHER => Self::Other,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NavigationType {
    #[inline]
    #[doc(alias = "webkit_navigation_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_navigation_type_get_type()) }
    }
}

impl glib::HasParamSpec for NavigationType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NavigationType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NavigationType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NavigationType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NavigationType> for glib::Value {
    #[inline]
    fn from(v: NavigationType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNetworkError")]
pub enum NetworkError {
    #[doc(alias = "WEBKIT_NETWORK_ERROR_FAILED")]
    Failed,
    #[doc(alias = "WEBKIT_NETWORK_ERROR_TRANSPORT")]
    Transport,
    #[doc(alias = "WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL")]
    UnknownProtocol,
    #[doc(alias = "WEBKIT_NETWORK_ERROR_CANCELLED")]
    Cancelled,
    #[doc(alias = "WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST")]
    FileDoesNotExist,
    #[doc(hidden)]
    __Unknown(i32),
}

impl NetworkError {
    #[doc(alias = "webkit_network_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_network_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for NetworkError {
    type GlibType = ffi::WebKitNetworkError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitNetworkError {
        match self {
            Self::Failed => ffi::WEBKIT_NETWORK_ERROR_FAILED,
            Self::Transport => ffi::WEBKIT_NETWORK_ERROR_TRANSPORT,
            Self::UnknownProtocol => ffi::WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL,
            Self::Cancelled => ffi::WEBKIT_NETWORK_ERROR_CANCELLED,
            Self::FileDoesNotExist => ffi::WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitNetworkError> for NetworkError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitNetworkError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_NETWORK_ERROR_FAILED => Self::Failed,
            ffi::WEBKIT_NETWORK_ERROR_TRANSPORT => Self::Transport,
            ffi::WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL => Self::UnknownProtocol,
            ffi::WEBKIT_NETWORK_ERROR_CANCELLED => Self::Cancelled,
            ffi::WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST => Self::FileDoesNotExist,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for NetworkError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitNetworkError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

impl StaticType for NetworkError {
    #[inline]
    #[doc(alias = "webkit_network_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_network_error_get_type()) }
    }
}

impl glib::HasParamSpec for NetworkError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NetworkError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NetworkError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NetworkError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NetworkError> for glib::Value {
    #[inline]
    fn from(v: NetworkError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNetworkProxyMode")]
pub enum NetworkProxyMode {
    #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_DEFAULT")]
    Default,
    #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_NO_PROXY")]
    NoProxy,
    #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_CUSTOM")]
    Custom,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for NetworkProxyMode {
    type GlibType = ffi::WebKitNetworkProxyMode;

    #[inline]
    fn into_glib(self) -> ffi::WebKitNetworkProxyMode {
        match self {
            Self::Default => ffi::WEBKIT_NETWORK_PROXY_MODE_DEFAULT,
            Self::NoProxy => ffi::WEBKIT_NETWORK_PROXY_MODE_NO_PROXY,
            Self::Custom => ffi::WEBKIT_NETWORK_PROXY_MODE_CUSTOM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitNetworkProxyMode> for NetworkProxyMode {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitNetworkProxyMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_NETWORK_PROXY_MODE_DEFAULT => Self::Default,
            ffi::WEBKIT_NETWORK_PROXY_MODE_NO_PROXY => Self::NoProxy,
            ffi::WEBKIT_NETWORK_PROXY_MODE_CUSTOM => Self::Custom,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for NetworkProxyMode {
    #[inline]
    #[doc(alias = "webkit_network_proxy_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_network_proxy_mode_get_type()) }
    }
}

impl glib::HasParamSpec for NetworkProxyMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for NetworkProxyMode {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for NetworkProxyMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for NetworkProxyMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<NetworkProxyMode> for glib::Value {
    #[inline]
    fn from(v: NetworkProxyMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPermissionState")]
pub enum PermissionState {
    #[doc(alias = "WEBKIT_PERMISSION_STATE_GRANTED")]
    Granted,
    #[doc(alias = "WEBKIT_PERMISSION_STATE_DENIED")]
    Denied,
    #[doc(alias = "WEBKIT_PERMISSION_STATE_PROMPT")]
    Prompt,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PermissionState {
    type GlibType = ffi::WebKitPermissionState;

    #[inline]
    fn into_glib(self) -> ffi::WebKitPermissionState {
        match self {
            Self::Granted => ffi::WEBKIT_PERMISSION_STATE_GRANTED,
            Self::Denied => ffi::WEBKIT_PERMISSION_STATE_DENIED,
            Self::Prompt => ffi::WEBKIT_PERMISSION_STATE_PROMPT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPermissionState> for PermissionState {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitPermissionState) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_PERMISSION_STATE_GRANTED => Self::Granted,
            ffi::WEBKIT_PERMISSION_STATE_DENIED => Self::Denied,
            ffi::WEBKIT_PERMISSION_STATE_PROMPT => Self::Prompt,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PermissionState {
    #[inline]
    #[doc(alias = "webkit_permission_state_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_permission_state_get_type()) }
    }
}

impl glib::HasParamSpec for PermissionState {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PermissionState {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PermissionState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PermissionState {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PermissionState> for glib::Value {
    #[inline]
    fn from(v: PermissionState) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPolicyDecisionType")]
pub enum PolicyDecisionType {
    #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION")]
    NavigationAction,
    #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION")]
    NewWindowAction,
    #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_RESPONSE")]
    Response,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PolicyDecisionType {
    type GlibType = ffi::WebKitPolicyDecisionType;

    #[inline]
    fn into_glib(self) -> ffi::WebKitPolicyDecisionType {
        match self {
            Self::NavigationAction => ffi::WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION,
            Self::NewWindowAction => ffi::WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION,
            Self::Response => ffi::WEBKIT_POLICY_DECISION_TYPE_RESPONSE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPolicyDecisionType> for PolicyDecisionType {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitPolicyDecisionType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION => Self::NavigationAction,
            ffi::WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION => Self::NewWindowAction,
            ffi::WEBKIT_POLICY_DECISION_TYPE_RESPONSE => Self::Response,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PolicyDecisionType {
    #[inline]
    #[doc(alias = "webkit_policy_decision_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_policy_decision_type_get_type()) }
    }
}

impl glib::HasParamSpec for PolicyDecisionType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PolicyDecisionType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PolicyDecisionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PolicyDecisionType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PolicyDecisionType> for glib::Value {
    #[inline]
    fn from(v: PolicyDecisionType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPolicyError")]
pub enum PolicyError {
    #[doc(alias = "WEBKIT_POLICY_ERROR_FAILED")]
    Failed,
    #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE")]
    CannotShowMimeType,
    #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI")]
    CannotShowUri,
    #[doc(alias = "WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE")]
    FrameLoadInterruptedByPolicyChange,
    #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT")]
    CannotUseRestrictedPort,
    #[doc(hidden)]
    __Unknown(i32),
}

impl PolicyError {
    #[doc(alias = "webkit_policy_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_policy_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for PolicyError {
    type GlibType = ffi::WebKitPolicyError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitPolicyError {
        match self {
            Self::Failed => ffi::WEBKIT_POLICY_ERROR_FAILED,
            Self::CannotShowMimeType => ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE,
            Self::CannotShowUri => ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI,
            Self::FrameLoadInterruptedByPolicyChange => {
                ffi::WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE
            }
            Self::CannotUseRestrictedPort => ffi::WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPolicyError> for PolicyError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitPolicyError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_POLICY_ERROR_FAILED => Self::Failed,
            ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE => Self::CannotShowMimeType,
            ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI => Self::CannotShowUri,
            ffi::WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE => {
                Self::FrameLoadInterruptedByPolicyChange
            }
            ffi::WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT => Self::CannotUseRestrictedPort,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for PolicyError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitPolicyError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            Self::__Unknown(_) => Some(Self::Failed),
            value => Some(value),
        }
    }
}

impl StaticType for PolicyError {
    #[inline]
    #[doc(alias = "webkit_policy_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_policy_error_get_type()) }
    }
}

impl glib::HasParamSpec for PolicyError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PolicyError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PolicyError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PolicyError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PolicyError> for glib::Value {
    #[inline]
    fn from(v: PolicyError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPrintError")]
pub enum PrintError {
    #[doc(alias = "WEBKIT_PRINT_ERROR_GENERAL")]
    General,
    #[doc(alias = "WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND")]
    PrinterNotFound,
    #[doc(alias = "WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE")]
    InvalidPageRange,
    #[doc(hidden)]
    __Unknown(i32),
}

impl PrintError {
    #[doc(alias = "webkit_print_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_print_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for PrintError {
    type GlibType = ffi::WebKitPrintError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitPrintError {
        match self {
            Self::General => ffi::WEBKIT_PRINT_ERROR_GENERAL,
            Self::PrinterNotFound => ffi::WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND,
            Self::InvalidPageRange => ffi::WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPrintError> for PrintError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitPrintError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_PRINT_ERROR_GENERAL => Self::General,
            ffi::WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND => Self::PrinterNotFound,
            ffi::WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE => Self::InvalidPageRange,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for PrintError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitPrintError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for PrintError {
    #[inline]
    #[doc(alias = "webkit_print_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_print_error_get_type()) }
    }
}

impl glib::HasParamSpec for PrintError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PrintError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PrintError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PrintError> for glib::Value {
    #[inline]
    fn from(v: PrintError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPrintOperationResponse")]
pub enum PrintOperationResponse {
    #[doc(alias = "WEBKIT_PRINT_OPERATION_RESPONSE_PRINT")]
    Print,
    #[doc(alias = "WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL")]
    Cancel,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for PrintOperationResponse {
    type GlibType = ffi::WebKitPrintOperationResponse;

    #[inline]
    fn into_glib(self) -> ffi::WebKitPrintOperationResponse {
        match self {
            Self::Print => ffi::WEBKIT_PRINT_OPERATION_RESPONSE_PRINT,
            Self::Cancel => ffi::WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPrintOperationResponse> for PrintOperationResponse {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitPrintOperationResponse) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_PRINT_OPERATION_RESPONSE_PRINT => Self::Print,
            ffi::WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL => Self::Cancel,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PrintOperationResponse {
    #[inline]
    #[doc(alias = "webkit_print_operation_response_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_print_operation_response_get_type()) }
    }
}

impl glib::HasParamSpec for PrintOperationResponse {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for PrintOperationResponse {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for PrintOperationResponse {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PrintOperationResponse {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<PrintOperationResponse> for glib::Value {
    #[inline]
    fn from(v: PrintOperationResponse) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSaveMode")]
pub enum SaveMode {
    #[doc(alias = "WEBKIT_SAVE_MODE_MHTML")]
    Mhtml,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SaveMode {
    type GlibType = ffi::WebKitSaveMode;

    #[inline]
    fn into_glib(self) -> ffi::WebKitSaveMode {
        match self {
            Self::Mhtml => ffi::WEBKIT_SAVE_MODE_MHTML,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSaveMode> for SaveMode {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitSaveMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_SAVE_MODE_MHTML => Self::Mhtml,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SaveMode {
    #[inline]
    #[doc(alias = "webkit_save_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_save_mode_get_type()) }
    }
}

impl glib::HasParamSpec for SaveMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SaveMode {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SaveMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SaveMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SaveMode> for glib::Value {
    #[inline]
    fn from(v: SaveMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitScriptDialogType")]
pub enum ScriptDialogType {
    #[doc(alias = "WEBKIT_SCRIPT_DIALOG_ALERT")]
    Alert,
    #[doc(alias = "WEBKIT_SCRIPT_DIALOG_CONFIRM")]
    Confirm,
    #[doc(alias = "WEBKIT_SCRIPT_DIALOG_PROMPT")]
    Prompt,
    #[doc(alias = "WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM")]
    BeforeUnloadConfirm,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for ScriptDialogType {
    type GlibType = ffi::WebKitScriptDialogType;

    #[inline]
    fn into_glib(self) -> ffi::WebKitScriptDialogType {
        match self {
            Self::Alert => ffi::WEBKIT_SCRIPT_DIALOG_ALERT,
            Self::Confirm => ffi::WEBKIT_SCRIPT_DIALOG_CONFIRM,
            Self::Prompt => ffi::WEBKIT_SCRIPT_DIALOG_PROMPT,
            Self::BeforeUnloadConfirm => ffi::WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitScriptDialogType> for ScriptDialogType {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitScriptDialogType) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_SCRIPT_DIALOG_ALERT => Self::Alert,
            ffi::WEBKIT_SCRIPT_DIALOG_CONFIRM => Self::Confirm,
            ffi::WEBKIT_SCRIPT_DIALOG_PROMPT => Self::Prompt,
            ffi::WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM => Self::BeforeUnloadConfirm,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ScriptDialogType {
    #[inline]
    #[doc(alias = "webkit_script_dialog_type_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_script_dialog_type_get_type()) }
    }
}

impl glib::HasParamSpec for ScriptDialogType {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for ScriptDialogType {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for ScriptDialogType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ScriptDialogType {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<ScriptDialogType> for glib::Value {
    #[inline]
    fn from(v: ScriptDialogType) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSnapshotError")]
pub enum SnapshotError {
    #[doc(alias = "WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE")]
    Create,
    #[doc(hidden)]
    __Unknown(i32),
}

impl SnapshotError {
    #[doc(alias = "webkit_snapshot_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_snapshot_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for SnapshotError {
    type GlibType = ffi::WebKitSnapshotError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitSnapshotError {
        match self {
            Self::Create => ffi::WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSnapshotError> for SnapshotError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitSnapshotError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE => Self::Create,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for SnapshotError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitSnapshotError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for SnapshotError {
    #[inline]
    #[doc(alias = "webkit_snapshot_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_snapshot_error_get_type()) }
    }
}

impl glib::HasParamSpec for SnapshotError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SnapshotError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SnapshotError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SnapshotError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SnapshotError> for glib::Value {
    #[inline]
    fn from(v: SnapshotError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSnapshotRegion")]
pub enum SnapshotRegion {
    #[doc(alias = "WEBKIT_SNAPSHOT_REGION_VISIBLE")]
    Visible,
    #[doc(alias = "WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT")]
    FullDocument,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for SnapshotRegion {
    type GlibType = ffi::WebKitSnapshotRegion;

    #[inline]
    fn into_glib(self) -> ffi::WebKitSnapshotRegion {
        match self {
            Self::Visible => ffi::WEBKIT_SNAPSHOT_REGION_VISIBLE,
            Self::FullDocument => ffi::WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSnapshotRegion> for SnapshotRegion {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitSnapshotRegion) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_SNAPSHOT_REGION_VISIBLE => Self::Visible,
            ffi::WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT => Self::FullDocument,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SnapshotRegion {
    #[inline]
    #[doc(alias = "webkit_snapshot_region_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_snapshot_region_get_type()) }
    }
}

impl glib::HasParamSpec for SnapshotRegion {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for SnapshotRegion {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for SnapshotRegion {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SnapshotRegion {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<SnapshotRegion> for glib::Value {
    #[inline]
    fn from(v: SnapshotRegion) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitTLSErrorsPolicy")]
pub enum TLSErrorsPolicy {
    #[doc(alias = "WEBKIT_TLS_ERRORS_POLICY_IGNORE")]
    Ignore,
    #[doc(alias = "WEBKIT_TLS_ERRORS_POLICY_FAIL")]
    Fail,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for TLSErrorsPolicy {
    type GlibType = ffi::WebKitTLSErrorsPolicy;

    #[inline]
    fn into_glib(self) -> ffi::WebKitTLSErrorsPolicy {
        match self {
            Self::Ignore => ffi::WEBKIT_TLS_ERRORS_POLICY_IGNORE,
            Self::Fail => ffi::WEBKIT_TLS_ERRORS_POLICY_FAIL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitTLSErrorsPolicy> for TLSErrorsPolicy {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitTLSErrorsPolicy) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_TLS_ERRORS_POLICY_IGNORE => Self::Ignore,
            ffi::WEBKIT_TLS_ERRORS_POLICY_FAIL => Self::Fail,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TLSErrorsPolicy {
    #[inline]
    #[doc(alias = "webkit_tls_errors_policy_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_tls_errors_policy_get_type()) }
    }
}

impl glib::HasParamSpec for TLSErrorsPolicy {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for TLSErrorsPolicy {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for TLSErrorsPolicy {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TLSErrorsPolicy {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<TLSErrorsPolicy> for glib::Value {
    #[inline]
    fn from(v: TLSErrorsPolicy) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserContentFilterError")]
pub enum UserContentFilterError {
    #[doc(alias = "WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE")]
    InvalidSource,
    #[doc(alias = "WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(hidden)]
    __Unknown(i32),
}

impl UserContentFilterError {
    #[doc(alias = "webkit_user_content_filter_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_user_content_filter_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for UserContentFilterError {
    type GlibType = ffi::WebKitUserContentFilterError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitUserContentFilterError {
        match self {
            Self::InvalidSource => ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE,
            Self::NotFound => ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitUserContentFilterError> for UserContentFilterError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitUserContentFilterError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE => Self::InvalidSource,
            ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND => Self::NotFound,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for UserContentFilterError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(
                b"WebKitUserContentFilterError\0".as_ptr() as *const _
            )
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for UserContentFilterError {
    #[inline]
    #[doc(alias = "webkit_user_content_filter_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_user_content_filter_error_get_type()) }
    }
}

impl glib::HasParamSpec for UserContentFilterError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for UserContentFilterError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for UserContentFilterError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UserContentFilterError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<UserContentFilterError> for glib::Value {
    #[inline]
    fn from(v: UserContentFilterError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserContentInjectedFrames")]
pub enum UserContentInjectedFrames {
    #[doc(alias = "WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES")]
    AllFrames,
    #[doc(alias = "WEBKIT_USER_CONTENT_INJECT_TOP_FRAME")]
    TopFrame,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for UserContentInjectedFrames {
    type GlibType = ffi::WebKitUserContentInjectedFrames;

    #[inline]
    fn into_glib(self) -> ffi::WebKitUserContentInjectedFrames {
        match self {
            Self::AllFrames => ffi::WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES,
            Self::TopFrame => ffi::WEBKIT_USER_CONTENT_INJECT_TOP_FRAME,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitUserContentInjectedFrames> for UserContentInjectedFrames {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitUserContentInjectedFrames) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES => Self::AllFrames,
            ffi::WEBKIT_USER_CONTENT_INJECT_TOP_FRAME => Self::TopFrame,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UserContentInjectedFrames {
    #[inline]
    #[doc(alias = "webkit_user_content_injected_frames_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_user_content_injected_frames_get_type()) }
    }
}

impl glib::HasParamSpec for UserContentInjectedFrames {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for UserContentInjectedFrames {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for UserContentInjectedFrames {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UserContentInjectedFrames {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<UserContentInjectedFrames> for glib::Value {
    #[inline]
    fn from(v: UserContentInjectedFrames) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserMessageError")]
pub enum UserMessageError {
    #[doc(alias = "WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE")]
    Message,
    #[doc(hidden)]
    __Unknown(i32),
}

impl UserMessageError {
    #[doc(alias = "webkit_user_message_error_quark")]
    pub fn quark() -> glib::Quark {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::webkit_user_message_error_quark()) }
    }
}

#[doc(hidden)]
impl IntoGlib for UserMessageError {
    type GlibType = ffi::WebKitUserMessageError;

    #[inline]
    fn into_glib(self) -> ffi::WebKitUserMessageError {
        match self {
            Self::Message => ffi::WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitUserMessageError> for UserMessageError {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitUserMessageError) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE => Self::Message,
            value => Self::__Unknown(value),
        }
    }
}

impl glib::error::ErrorDomain for UserMessageError {
    #[inline]
    fn domain() -> glib::Quark {
        skip_assert_initialized!();

        static QUARK: ::std::sync::OnceLock<glib::ffi::GQuark> = ::std::sync::OnceLock::new();
        let quark = *QUARK.get_or_init(|| unsafe {
            glib::ffi::g_quark_from_static_string(b"WebKitUserMessageError\0".as_ptr() as *const _)
        });
        unsafe { from_glib(quark) }
    }

    #[inline]
    fn code(self) -> i32 {
        self.into_glib()
    }

    #[inline]
    #[allow(clippy::match_single_binding)]
    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match unsafe { from_glib(code) } {
            value => Some(value),
        }
    }
}

impl StaticType for UserMessageError {
    #[inline]
    #[doc(alias = "webkit_user_message_error_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_user_message_error_get_type()) }
    }
}

impl glib::HasParamSpec for UserMessageError {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for UserMessageError {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for UserMessageError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UserMessageError {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<UserMessageError> for glib::Value {
    #[inline]
    fn from(v: UserMessageError) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserScriptInjectionTime")]
pub enum UserScriptInjectionTime {
    #[doc(alias = "WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START")]
    Start,
    #[doc(alias = "WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for UserScriptInjectionTime {
    type GlibType = ffi::WebKitUserScriptInjectionTime;

    #[inline]
    fn into_glib(self) -> ffi::WebKitUserScriptInjectionTime {
        match self {
            Self::Start => ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START,
            Self::End => ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitUserScriptInjectionTime> for UserScriptInjectionTime {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitUserScriptInjectionTime) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START => Self::Start,
            ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UserScriptInjectionTime {
    #[inline]
    #[doc(alias = "webkit_user_script_injection_time_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_user_script_injection_time_get_type()) }
    }
}

impl glib::HasParamSpec for UserScriptInjectionTime {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for UserScriptInjectionTime {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for UserScriptInjectionTime {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UserScriptInjectionTime {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<UserScriptInjectionTime> for glib::Value {
    #[inline]
    fn from(v: UserScriptInjectionTime) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserStyleLevel")]
pub enum UserStyleLevel {
    #[doc(alias = "WEBKIT_USER_STYLE_LEVEL_USER")]
    User,
    #[doc(alias = "WEBKIT_USER_STYLE_LEVEL_AUTHOR")]
    Author,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for UserStyleLevel {
    type GlibType = ffi::WebKitUserStyleLevel;

    #[inline]
    fn into_glib(self) -> ffi::WebKitUserStyleLevel {
        match self {
            Self::User => ffi::WEBKIT_USER_STYLE_LEVEL_USER,
            Self::Author => ffi::WEBKIT_USER_STYLE_LEVEL_AUTHOR,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitUserStyleLevel> for UserStyleLevel {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitUserStyleLevel) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_USER_STYLE_LEVEL_USER => Self::User,
            ffi::WEBKIT_USER_STYLE_LEVEL_AUTHOR => Self::Author,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for UserStyleLevel {
    #[inline]
    #[doc(alias = "webkit_user_style_level_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_user_style_level_get_type()) }
    }
}

impl glib::HasParamSpec for UserStyleLevel {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for UserStyleLevel {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for UserStyleLevel {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for UserStyleLevel {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<UserStyleLevel> for glib::Value {
    #[inline]
    fn from(v: UserStyleLevel) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitWebExtensionMode")]
pub enum WebExtensionMode {
    #[doc(alias = "WEBKIT_WEB_EXTENSION_MODE_NONE")]
    None,
    #[doc(alias = "WEBKIT_WEB_EXTENSION_MODE_MANIFESTV2")]
    Manifestv2,
    #[doc(alias = "WEBKIT_WEB_EXTENSION_MODE_MANIFESTV3")]
    Manifestv3,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for WebExtensionMode {
    type GlibType = ffi::WebKitWebExtensionMode;

    #[inline]
    fn into_glib(self) -> ffi::WebKitWebExtensionMode {
        match self {
            Self::None => ffi::WEBKIT_WEB_EXTENSION_MODE_NONE,
            Self::Manifestv2 => ffi::WEBKIT_WEB_EXTENSION_MODE_MANIFESTV2,
            Self::Manifestv3 => ffi::WEBKIT_WEB_EXTENSION_MODE_MANIFESTV3,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitWebExtensionMode> for WebExtensionMode {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitWebExtensionMode) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_WEB_EXTENSION_MODE_NONE => Self::None,
            ffi::WEBKIT_WEB_EXTENSION_MODE_MANIFESTV2 => Self::Manifestv2,
            ffi::WEBKIT_WEB_EXTENSION_MODE_MANIFESTV3 => Self::Manifestv3,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebExtensionMode {
    #[inline]
    #[doc(alias = "webkit_web_extension_mode_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_web_extension_mode_get_type()) }
    }
}

impl glib::HasParamSpec for WebExtensionMode {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for WebExtensionMode {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for WebExtensionMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebExtensionMode {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<WebExtensionMode> for glib::Value {
    #[inline]
    fn from(v: WebExtensionMode) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitWebProcessTerminationReason")]
pub enum WebProcessTerminationReason {
    #[doc(alias = "WEBKIT_WEB_PROCESS_CRASHED")]
    Crashed,
    #[doc(alias = "WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT")]
    ExceededMemoryLimit,
    #[doc(alias = "WEBKIT_WEB_PROCESS_TERMINATED_BY_API")]
    TerminatedByApi,
    #[doc(hidden)]
    __Unknown(i32),
}

#[doc(hidden)]
impl IntoGlib for WebProcessTerminationReason {
    type GlibType = ffi::WebKitWebProcessTerminationReason;

    #[inline]
    fn into_glib(self) -> ffi::WebKitWebProcessTerminationReason {
        match self {
            Self::Crashed => ffi::WEBKIT_WEB_PROCESS_CRASHED,
            Self::ExceededMemoryLimit => ffi::WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT,
            Self::TerminatedByApi => ffi::WEBKIT_WEB_PROCESS_TERMINATED_BY_API,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitWebProcessTerminationReason> for WebProcessTerminationReason {
    #[inline]
    unsafe fn from_glib(value: ffi::WebKitWebProcessTerminationReason) -> Self {
        skip_assert_initialized!();

        match value {
            ffi::WEBKIT_WEB_PROCESS_CRASHED => Self::Crashed,
            ffi::WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT => Self::ExceededMemoryLimit,
            ffi::WEBKIT_WEB_PROCESS_TERMINATED_BY_API => Self::TerminatedByApi,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for WebProcessTerminationReason {
    #[inline]
    #[doc(alias = "webkit_web_process_termination_reason_get_type")]
    fn static_type() -> glib::Type {
        unsafe { from_glib(ffi::webkit_web_process_termination_reason_get_type()) }
    }
}

impl glib::HasParamSpec for WebProcessTerminationReason {
    type ParamSpec = glib::ParamSpecEnum;
    type SetValue = Self;
    type BuilderFn = fn(&str, Self) -> glib::ParamSpecEnumBuilder<Self>;

    fn param_spec_builder() -> Self::BuilderFn {
        Self::ParamSpec::builder_with_default
    }
}

impl glib::value::ValueType for WebProcessTerminationReason {
    type Type = Self;
}

unsafe impl<'a> glib::value::FromValue<'a> for WebProcessTerminationReason {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    #[inline]
    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for WebProcessTerminationReason {
    #[inline]
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    #[inline]
    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

impl From<WebProcessTerminationReason> for glib::Value {
    #[inline]
    fn from(v: WebProcessTerminationReason) -> Self {
        skip_assert_initialized!();
        ToValue::to_value(&v)
    }
}
