// services/video_effects/public/mojom/video_effects_processor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_SHARED_H_
#define SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_effects/public/mojom/video_effects_processor.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace video_effects::mojom {
class PostProcessSuccessDataView;

class PostProcessResultDataView;


}  // video_effects::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::video_effects::mojom::PostProcessSuccessDataView> {
  using Data = ::video_effects::mojom::internal::PostProcessSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::video_effects::mojom::PostProcessResultDataView> {
  using Data = ::video_effects::mojom::internal::PostProcessResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace video_effects::mojom {


enum class PostProcessError : int32_t {
  
  kUnknown = 1,
  
  kUnusable = 2,
  
  kNotReady = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PostProcessError value);
inline bool IsKnownEnumValue(PostProcessError value) {
  return internal::PostProcessError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoEffectsProcessorInterfaceBase {};

using VideoEffectsProcessorPtrDataView =
    mojo::InterfacePtrDataView<VideoEffectsProcessorInterfaceBase>;
using VideoEffectsProcessorRequestDataView =
    mojo::InterfaceRequestDataView<VideoEffectsProcessorInterfaceBase>;
using VideoEffectsProcessorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEffectsProcessorInterfaceBase>;
using VideoEffectsProcessorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEffectsProcessorInterfaceBase>;


class PostProcessSuccessDataView {
 public:
  PostProcessSuccessDataView() = default;

  PostProcessSuccessDataView(
      internal::PostProcessSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameInfoDataView(
      ::media::mojom::VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInfo(UserType* output) {
    
    auto* pointer = data_->frame_info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::PostProcessSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PostProcessResultDataView {
 public:
  using Tag = internal::PostProcessResult_Data::PostProcessResult_Tag;

  PostProcessResultDataView() = default;

  PostProcessResultDataView(
      internal::PostProcessResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::video_effects::mojom::PostProcessError>(
        data_->data.f_error, output);
  }
  PostProcessError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::video_effects::mojom::PostProcessError>(data_->data.f_error));
  }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      PostProcessSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::video_effects::mojom::PostProcessSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }

 private:
  internal::PostProcessResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // video_effects::mojom

namespace std {

template <>
struct hash<::video_effects::mojom::PostProcessError>
    : public mojo::internal::EnumHashImpl<::video_effects::mojom::PostProcessError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::video_effects::mojom::PostProcessError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::video_effects::mojom::PostProcessError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::video_effects::mojom::PostProcessError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::video_effects::mojom::PostProcessSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::video_effects::mojom::PostProcessSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::video_effects::mojom::internal::PostProcessSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_info(input)) in_frame_info = Traits::frame_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_info)::BaseType> frame_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
        in_frame_info, frame_info_fragment);
    fragment->frame_info.Set(
        frame_info_fragment.is_null() ? nullptr : frame_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_info in PostProcessSuccess struct");
  }

  static bool Deserialize(::video_effects::mojom::internal::PostProcessSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::video_effects::mojom::PostProcessSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::video_effects::mojom::PostProcessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::video_effects::mojom::PostProcessResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::video_effects::mojom::internal::PostProcessResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::video_effects::mojom::PostProcessResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::video_effects::mojom::PostProcessError>(
            in_error, &fragment->data.f_error);
        break;
      }
      case ::video_effects::mojom::PostProcessResultDataView::Tag::kSuccess: {
        decltype(Traits::success(input))
            in_success = Traits::success(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_success)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::video_effects::mojom::PostProcessSuccessDataView>(
            in_success, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null success in PostProcessResult union");
        fragment->data.f_success.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::video_effects::mojom::internal::PostProcessResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::video_effects::mojom::PostProcessResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace video_effects::mojom {

inline void PostProcessSuccessDataView::GetFrameInfoDataView(
    ::media::mojom::VideoFrameInfoDataView* output) {
  auto pointer = data_->frame_info.Get();
  *output = ::media::mojom::VideoFrameInfoDataView(pointer, message_);
}


inline void PostProcessResultDataView::GetSuccessDataView(
    PostProcessSuccessDataView* output) const {
  CHECK(is_success());
  *output = PostProcessSuccessDataView(data_->data.f_success.Get(), message_);
}


}  // video_effects::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::video_effects::mojom::PostProcessError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::video_effects::mojom::PostProcessError value);
};

} // namespace perfetto

#endif  // SERVICES_VIDEO_EFFECTS_PUBLIC_MOJOM_VIDEO_EFFECTS_PROCESSOR_MOJOM_SHARED_H_