// extensions/common/mojom/injection_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/injection_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/injection_type.mojom-params-data.h"
namespace extensions {
namespace mojom {

NOINLINE static const char* InjectionTypeToStringHelper(InjectionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InjectionType::kContentScript:
      return "kContentScript";
    case InjectionType::kProgrammaticScript:
      return "kProgrammaticScript";
    default:
      return nullptr;
  }
}

std::string InjectionTypeToString(InjectionType value) {
  const char *str = InjectionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InjectionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InjectionType value) {
  return os << InjectionTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::InjectionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::InjectionType value) {
  return std::move(context).WriteString(::extensions::mojom::InjectionTypeToString(value));
}

} // namespace perfetto