// components/autofill/core/common/mojom/autofill_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_H_
#define COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-features.h"  // IWYU pragma: export
#include "components/autofill/core/common/mojom/autofill_types.mojom-shared.h"  // IWYU pragma: export
#include "components/autofill/core/common/mojom/autofill_types.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "components/autofill/core/common/mojom/autofill_types_mojom_traits.h"




namespace autofill::mojom {







class  FormRendererId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormRendererId, T>::value>;
  using DataView = FormRendererIdDataView;
  using Data_ = internal::FormRendererId_Data;

  template <typename... Args>
  static FormRendererIdPtr New(Args&&... args) {
    return FormRendererIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormRendererIdPtr From(const U& u) {
    return mojo::TypeConverter<FormRendererIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormRendererId>::Convert(*this);
  }


  FormRendererId();

  explicit FormRendererId(
      uint64_t id);


  ~FormRendererId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormRendererIdPtr>
  FormRendererIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormRendererId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormRendererId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormRendererId_UnserializedMessageContext<
            UserType, FormRendererId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormRendererId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormRendererId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormRendererId_UnserializedMessageContext<
            UserType, FormRendererId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormRendererId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FieldRendererId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FieldRendererId, T>::value>;
  using DataView = FieldRendererIdDataView;
  using Data_ = internal::FieldRendererId_Data;

  template <typename... Args>
  static FieldRendererIdPtr New(Args&&... args) {
    return FieldRendererIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FieldRendererIdPtr From(const U& u) {
    return mojo::TypeConverter<FieldRendererIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FieldRendererId>::Convert(*this);
  }


  FieldRendererId();

  explicit FieldRendererId(
      uint64_t id);


  ~FieldRendererId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FieldRendererIdPtr>
  FieldRendererIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FieldRendererId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FieldRendererId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FieldRendererId_UnserializedMessageContext<
            UserType, FieldRendererId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FieldRendererId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FieldRendererId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FieldRendererId_UnserializedMessageContext<
            UserType, FieldRendererId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FieldRendererId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SectionAutocomplete {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SectionAutocomplete, T>::value>;
  using DataView = SectionAutocompleteDataView;
  using Data_ = internal::SectionAutocomplete_Data;

  template <typename... Args>
  static SectionAutocompletePtr New(Args&&... args) {
    return SectionAutocompletePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SectionAutocompletePtr From(const U& u) {
    return mojo::TypeConverter<SectionAutocompletePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SectionAutocomplete>::Convert(*this);
  }


  SectionAutocomplete();

  SectionAutocomplete(
      const std::string& section,
      HtmlFieldMode html_field_mode);


  ~SectionAutocomplete();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SectionAutocompletePtr>
  SectionAutocompletePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SectionAutocomplete::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SectionAutocomplete::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SectionAutocomplete_UnserializedMessageContext<
            UserType, SectionAutocomplete::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SectionAutocomplete::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SectionAutocomplete::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SectionAutocomplete_UnserializedMessageContext<
            UserType, SectionAutocomplete::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SectionAutocomplete::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string section;
  
  HtmlFieldMode html_field_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SectionAutocomplete::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  AutocompleteParsingResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AutocompleteParsingResult, T>::value>;
  using DataView = AutocompleteParsingResultDataView;
  using Data_ = internal::AutocompleteParsingResult_Data;

  template <typename... Args>
  static AutocompleteParsingResultPtr New(Args&&... args) {
    return AutocompleteParsingResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AutocompleteParsingResultPtr From(const U& u) {
    return mojo::TypeConverter<AutocompleteParsingResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AutocompleteParsingResult>::Convert(*this);
  }


  AutocompleteParsingResult();

  AutocompleteParsingResult(
      const std::string& section,
      HtmlFieldMode mode,
      HtmlFieldType field_type,
      bool webauthn);


  ~AutocompleteParsingResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AutocompleteParsingResultPtr>
  AutocompleteParsingResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AutocompleteParsingResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AutocompleteParsingResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AutocompleteParsingResult_UnserializedMessageContext<
            UserType, AutocompleteParsingResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AutocompleteParsingResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AutocompleteParsingResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AutocompleteParsingResult_UnserializedMessageContext<
            UserType, AutocompleteParsingResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AutocompleteParsingResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string section;
  
  HtmlFieldMode mode;
  
  HtmlFieldType field_type;
  
  bool webauthn;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AutocompleteParsingResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

















class  SectionValue {
 public:
  using DataView = SectionValueDataView;
  using Data_ = internal::SectionValue_Data;
  using Tag = Data_::SectionValue_Tag;

  template <typename... Args>
  static SectionValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |default_section|.
  static SectionValuePtr
  NewDefaultSection(
      bool value) {
    auto result = SectionValuePtr(std::in_place);
    result->set_default_section(std::move(value));
    return result;
  }
  // Construct an instance holding |autocomplete|.
  static SectionValuePtr
  NewAutocomplete(
      SectionAutocompletePtr value) {
    auto result = SectionValuePtr(std::in_place);
    result->set_autocomplete(std::move(value));
    return result;
  }
  // Construct an instance holding |field_identifier|.
  static SectionValuePtr
  NewFieldIdentifier(
      SectionFieldIdentifierPtr value) {
    auto result = SectionValuePtr(std::in_place);
    result->set_field_identifier(std::move(value));
    return result;
  }

  template <typename U>
  static SectionValuePtr From(const U& u) {
    return mojo::TypeConverter<SectionValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SectionValue>::Convert(*this);
  }

  SectionValue();
  ~SectionValue();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SectionValue(const SectionValue& other) = delete;
  SectionValue& operator=(const SectionValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SectionValuePtr>
  SectionValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SectionValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SectionValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_default_section() const { return tag_ == Tag::kDefaultSection; }

  
  bool get_default_section() const {
    CHECK(tag_ == Tag::kDefaultSection);
    return data_.default_section;
  }

  
  void set_default_section(
      bool default_section);
  
  bool is_autocomplete() const { return tag_ == Tag::kAutocomplete; }

  
  SectionAutocompletePtr& get_autocomplete() const {
    CHECK(tag_ == Tag::kAutocomplete);
    return *(data_.autocomplete);
  }

  
  void set_autocomplete(
      SectionAutocompletePtr autocomplete);
  
  bool is_field_identifier() const { return tag_ == Tag::kFieldIdentifier; }

  
  SectionFieldIdentifierPtr& get_field_identifier() const {
    CHECK(tag_ == Tag::kFieldIdentifier);
    return *(data_.field_identifier);
  }

  
  void set_field_identifier(
      SectionFieldIdentifierPtr field_identifier);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SectionValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SectionValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    bool default_section;
    SectionAutocompletePtr* autocomplete;
    SectionFieldIdentifierPtr* field_identifier;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  FrameToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameToken, T>::value>;
  using DataView = FrameTokenDataView;
  using Data_ = internal::FrameToken_Data;

  template <typename... Args>
  static FrameTokenPtr New(Args&&... args) {
    return FrameTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameTokenPtr From(const U& u) {
    return mojo::TypeConverter<FrameTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameToken>::Convert(*this);
  }


  FrameToken();

  FrameToken(
      const ::base::UnguessableToken& token,
      bool is_local);


  ~FrameToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameTokenPtr>
  FrameTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameToken_UnserializedMessageContext<
            UserType, FrameToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameToken_UnserializedMessageContext<
            UserType, FrameToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken token;
  
  bool is_local;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameTokenWithPredecessor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameTokenWithPredecessor, T>::value>;
  using DataView = FrameTokenWithPredecessorDataView;
  using Data_ = internal::FrameTokenWithPredecessor_Data;

  template <typename... Args>
  static FrameTokenWithPredecessorPtr New(Args&&... args) {
    return FrameTokenWithPredecessorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameTokenWithPredecessorPtr From(const U& u) {
    return mojo::TypeConverter<FrameTokenWithPredecessorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameTokenWithPredecessor>::Convert(*this);
  }


  FrameTokenWithPredecessor();

  FrameTokenWithPredecessor(
      FrameTokenPtr token,
      int32_t predecessor);

FrameTokenWithPredecessor(const FrameTokenWithPredecessor&) = delete;
FrameTokenWithPredecessor& operator=(const FrameTokenWithPredecessor&) = delete;

  ~FrameTokenWithPredecessor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameTokenWithPredecessorPtr>
  FrameTokenWithPredecessorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameTokenWithPredecessor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameTokenWithPredecessor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameTokenWithPredecessor_UnserializedMessageContext<
            UserType, FrameTokenWithPredecessor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameTokenWithPredecessor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameTokenWithPredecessor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameTokenWithPredecessor_UnserializedMessageContext<
            UserType, FrameTokenWithPredecessor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameTokenWithPredecessor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FrameTokenPtr token;
  
  int32_t predecessor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SelectOption {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectOption, T>::value>;
  using DataView = SelectOptionDataView;
  using Data_ = internal::SelectOption_Data;

  template <typename... Args>
  static SelectOptionPtr New(Args&&... args) {
    return SelectOptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectOptionPtr From(const U& u) {
    return mojo::TypeConverter<SelectOptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectOption>::Convert(*this);
  }


  SelectOption();

  SelectOption(
      const ::std::u16string& value,
      const ::std::u16string& text);


  ~SelectOption();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectOptionPtr>
  SelectOptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectOption::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectOption::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectOption_UnserializedMessageContext<
            UserType, SelectOption::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectOption::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectOption::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectOption_UnserializedMessageContext<
            UserType, SelectOption::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectOption::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string value;
  
  ::std::u16string text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectOption::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SectionFieldIdentifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SectionFieldIdentifier, T>::value>;
  using DataView = SectionFieldIdentifierDataView;
  using Data_ = internal::SectionFieldIdentifier_Data;

  template <typename... Args>
  static SectionFieldIdentifierPtr New(Args&&... args) {
    return SectionFieldIdentifierPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SectionFieldIdentifierPtr From(const U& u) {
    return mojo::TypeConverter<SectionFieldIdentifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SectionFieldIdentifier>::Convert(*this);
  }


  SectionFieldIdentifier();

  SectionFieldIdentifier(
      const std::string& field_name,
      uint64_t local_frame_id,
      ::autofill::FieldRendererId field_renderer_id);


  ~SectionFieldIdentifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SectionFieldIdentifierPtr>
  SectionFieldIdentifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SectionFieldIdentifier::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SectionFieldIdentifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SectionFieldIdentifier_UnserializedMessageContext<
            UserType, SectionFieldIdentifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SectionFieldIdentifier::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SectionFieldIdentifier::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SectionFieldIdentifier_UnserializedMessageContext<
            UserType, SectionFieldIdentifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SectionFieldIdentifier::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string field_name;
  
  uint64_t local_frame_id;
  
  ::autofill::FieldRendererId field_renderer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SectionFieldIdentifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Section {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Section, T>::value>;
  using DataView = SectionDataView;
  using Data_ = internal::Section_Data;

  template <typename... Args>
  static SectionPtr New(Args&&... args) {
    return SectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SectionPtr From(const U& u) {
    return mojo::TypeConverter<SectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Section>::Convert(*this);
  }


  Section();

  explicit Section(
      SectionValuePtr value);

Section(const Section&) = delete;
Section& operator=(const Section&) = delete;

  ~Section();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SectionPtr>
  SectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Section::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Section::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Section::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Section::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Section::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Section_UnserializedMessageContext<
            UserType, Section::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Section::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Section::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Section_UnserializedMessageContext<
            UserType, Section::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Section::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SectionValuePtr value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Section::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Section::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Section::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Section::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  FormFieldData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormFieldData, T>::value>;
  using DataView = FormFieldDataDataView;
  using Data_ = internal::FormFieldData_Data;
  using CheckStatus = FormFieldData_CheckStatus;
  using RoleAttribute = FormFieldData_RoleAttribute;
  using LabelSource = FormFieldData_LabelSource;

  template <typename... Args>
  static FormFieldDataPtr New(Args&&... args) {
    return FormFieldDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormFieldDataPtr From(const U& u) {
    return mojo::TypeConverter<FormFieldDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormFieldData>::Convert(*this);
  }


  FormFieldData();

  FormFieldData(
      const ::std::u16string& label,
      const ::std::u16string& name,
      const ::std::u16string& id_attribute,
      const ::std::u16string& name_attribute,
      const ::std::u16string& value,
      const ::std::u16string& selected_text,
      FormControlType form_control_type,
      const std::string& autocomplete_attribute,
      AutocompleteParsingResultPtr parsed_autocomplete,
      const ::std::u16string& placeholder,
      const ::std::u16string& css_classes,
      const ::std::u16string& aria_label,
      const ::std::u16string& aria_description,
      ::autofill::FieldRendererId renderer_id,
      ::autofill::FormRendererId host_form_id,
      uint32_t properties_mask,
      int32_t form_control_ax_id,
      uint64_t max_length,
      bool is_user_edited,
      bool is_autofilled,
      const ::autofill::Section& section,
      FormFieldData::CheckStatus check_status,
      bool is_focusable,
      bool is_visible,
      bool should_autocomplete,
      FormFieldData::RoleAttribute role,
      ::base::i18n::TextDirection text_direction,
      bool is_enabled,
      bool is_readonly,
      const ::std::u16string& user_input,
      bool allows_writing_suggestions,
      std::vector<SelectOptionPtr> options,
      FormFieldData::LabelSource label_source,
      const ::gfx::RectF& bounds,
      std::vector<SelectOptionPtr> datalist_options,
      bool force_override);

FormFieldData(const FormFieldData&) = delete;
FormFieldData& operator=(const FormFieldData&) = delete;

  ~FormFieldData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormFieldDataPtr>
  FormFieldDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormFieldData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormFieldData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormFieldData_UnserializedMessageContext<
            UserType, FormFieldData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormFieldData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormFieldData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormFieldData_UnserializedMessageContext<
            UserType, FormFieldData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormFieldData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string label;
  
  ::std::u16string name;
  
  ::std::u16string id_attribute;
  
  ::std::u16string name_attribute;
  
  ::std::u16string value;
  
  ::std::u16string selected_text;
  
  FormControlType form_control_type;
  
  std::string autocomplete_attribute;
  
  AutocompleteParsingResultPtr parsed_autocomplete;
  
  ::std::u16string placeholder;
  
  ::std::u16string css_classes;
  
  ::std::u16string aria_label;
  
  ::std::u16string aria_description;
  
  ::autofill::FieldRendererId renderer_id;
  
  ::autofill::FormRendererId host_form_id;
  
  uint32_t properties_mask;
  
  int32_t form_control_ax_id;
  
  uint64_t max_length;
  
  bool is_user_edited;
  
  bool is_autofilled;
  
  ::autofill::Section section;
  
  FormFieldData::CheckStatus check_status;
  
  bool is_focusable;
  
  bool is_visible;
  
  bool should_autocomplete;
  
  FormFieldData::RoleAttribute role;
  
  ::base::i18n::TextDirection text_direction;
  
  bool is_enabled;
  
  bool is_readonly;
  
  ::std::u16string user_input;
  
  bool allows_writing_suggestions;
  
  std::vector<SelectOptionPtr> options;
  
  FormFieldData::LabelSource label_source;
  
  ::gfx::RectF bounds;
  
  std::vector<SelectOptionPtr> datalist_options;
  
  bool force_override;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormFieldData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FormFieldData_FillData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormFieldData_FillData, T>::value>;
  using DataView = FormFieldData_FillDataDataView;
  using Data_ = internal::FormFieldData_FillData_Data;

  template <typename... Args>
  static FormFieldData_FillDataPtr New(Args&&... args) {
    return FormFieldData_FillDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormFieldData_FillDataPtr From(const U& u) {
    return mojo::TypeConverter<FormFieldData_FillDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormFieldData_FillData>::Convert(*this);
  }


  FormFieldData_FillData();

  FormFieldData_FillData(
      const ::std::u16string& value,
      ::autofill::FieldRendererId renderer_id,
      ::autofill::FormRendererId host_form_id,
      bool is_autofilled,
      bool force_override);


  ~FormFieldData_FillData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormFieldData_FillDataPtr>
  FormFieldData_FillDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormFieldData_FillData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormFieldData_FillData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormFieldData_FillData_UnserializedMessageContext<
            UserType, FormFieldData_FillData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormFieldData_FillData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormFieldData_FillData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormFieldData_FillData_UnserializedMessageContext<
            UserType, FormFieldData_FillData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormFieldData_FillData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string value;
  
  ::autofill::FieldRendererId renderer_id;
  
  ::autofill::FormRendererId host_form_id;
  
  bool is_autofilled;
  
  bool force_override;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormFieldData_FillData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ButtonTitleInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ButtonTitleInfo, T>::value>;
  using DataView = ButtonTitleInfoDataView;
  using Data_ = internal::ButtonTitleInfo_Data;

  template <typename... Args>
  static ButtonTitleInfoPtr New(Args&&... args) {
    return ButtonTitleInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ButtonTitleInfoPtr From(const U& u) {
    return mojo::TypeConverter<ButtonTitleInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ButtonTitleInfo>::Convert(*this);
  }


  ButtonTitleInfo();

  ButtonTitleInfo(
      const ::std::u16string& title,
      ButtonTitleType type);


  ~ButtonTitleInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ButtonTitleInfoPtr>
  ButtonTitleInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ButtonTitleInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ButtonTitleInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ButtonTitleInfo_UnserializedMessageContext<
            UserType, ButtonTitleInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ButtonTitleInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ButtonTitleInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ButtonTitleInfo_UnserializedMessageContext<
            UserType, ButtonTitleInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ButtonTitleInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  ButtonTitleType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ButtonTitleInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FormData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormData, T>::value>;
  using DataView = FormDataDataView;
  using Data_ = internal::FormData_Data;

  template <typename... Args>
  static FormDataPtr New(Args&&... args) {
    return FormDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormDataPtr From(const U& u) {
    return mojo::TypeConverter<FormDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormData>::Convert(*this);
  }


  FormData();

  FormData(
      const ::std::u16string& id_attribute,
      const ::std::u16string& name_attribute,
      const ::std::u16string& name,
      std::vector<ButtonTitleInfoPtr> button_titles,
      const ::GURL& action,
      bool is_action_empty,
      ::autofill::FormRendererId renderer_id,
      std::vector<FrameTokenWithPredecessorPtr> child_frames,
      SubmissionIndicatorEvent submission_event,
      std::vector<::autofill::FormFieldData> fields,
      std::vector<::autofill::FieldRendererId> username_predictions,
      bool is_gaia_with_skip_save_password_form,
      bool likely_contains_captcha);

FormData(const FormData&) = delete;
FormData& operator=(const FormData&) = delete;

  ~FormData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormDataPtr>
  FormDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormData_UnserializedMessageContext<
            UserType, FormData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormData_UnserializedMessageContext<
            UserType, FormData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string id_attribute;
  
  ::std::u16string name_attribute;
  
  ::std::u16string name;
  
  std::vector<ButtonTitleInfoPtr> button_titles;
  
  ::GURL action;
  
  bool is_action_empty;
  
  ::autofill::FormRendererId renderer_id;
  
  std::vector<FrameTokenWithPredecessorPtr> child_frames;
  
  SubmissionIndicatorEvent submission_event;
  
  std::vector<::autofill::FormFieldData> fields;
  
  std::vector<::autofill::FieldRendererId> username_predictions;
  
  bool is_gaia_with_skip_save_password_form;
  
  bool likely_contains_captcha;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FormFieldDataPredictions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormFieldDataPredictions, T>::value>;
  using DataView = FormFieldDataPredictionsDataView;
  using Data_ = internal::FormFieldDataPredictions_Data;

  template <typename... Args>
  static FormFieldDataPredictionsPtr New(Args&&... args) {
    return FormFieldDataPredictionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormFieldDataPredictionsPtr From(const U& u) {
    return mojo::TypeConverter<FormFieldDataPredictionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormFieldDataPredictions>::Convert(*this);
  }


  FormFieldDataPredictions();

  FormFieldDataPredictions(
      const std::string& host_form_signature,
      const std::string& signature,
      const std::string& heuristic_type,
      const std::optional<std::string>& server_type,
      const std::string& html_type,
      const std::string& overall_type,
      const std::string& parseable_name,
      const std::string& parseable_label,
      const std::string& section,
      uint32_t rank,
      uint32_t rank_in_signature_group,
      uint32_t rank_in_host_form,
      uint32_t rank_in_host_form_signature_group);


  ~FormFieldDataPredictions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormFieldDataPredictionsPtr>
  FormFieldDataPredictionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormFieldDataPredictions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormFieldDataPredictions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormFieldDataPredictions_UnserializedMessageContext<
            UserType, FormFieldDataPredictions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormFieldDataPredictions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormFieldDataPredictions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormFieldDataPredictions_UnserializedMessageContext<
            UserType, FormFieldDataPredictions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormFieldDataPredictions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string host_form_signature;
  
  std::string signature;
  
  std::string heuristic_type;
  
  std::optional<std::string> server_type;
  
  std::string html_type;
  
  std::string overall_type;
  
  std::string parseable_name;
  
  std::string parseable_label;
  
  std::string section;
  
  uint32_t rank;
  
  uint32_t rank_in_signature_group;
  
  uint32_t rank_in_host_form;
  
  uint32_t rank_in_host_form_signature_group;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormFieldDataPredictions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FormDataPredictions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormDataPredictions, T>::value>;
  using DataView = FormDataPredictionsDataView;
  using Data_ = internal::FormDataPredictions_Data;

  template <typename... Args>
  static FormDataPredictionsPtr New(Args&&... args) {
    return FormDataPredictionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormDataPredictionsPtr From(const U& u) {
    return mojo::TypeConverter<FormDataPredictionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormDataPredictions>::Convert(*this);
  }


  FormDataPredictions();

  FormDataPredictions(
      const ::autofill::FormData& data,
      const std::string& signature,
      const std::string& alternative_signature,
      std::vector<::autofill::FormFieldDataPredictions> fields);


  ~FormDataPredictions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormDataPredictionsPtr>
  FormDataPredictionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormDataPredictions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormDataPredictions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormDataPredictions_UnserializedMessageContext<
            UserType, FormDataPredictions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormDataPredictions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormDataPredictions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormDataPredictions_UnserializedMessageContext<
            UserType, FormDataPredictions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormDataPredictions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::autofill::FormData data;
  
  std::string signature;
  
  std::string alternative_signature;
  
  std::vector<::autofill::FormFieldDataPredictions> fields;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormDataPredictions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PasswordAndMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PasswordAndMetadata, T>::value>;
  using DataView = PasswordAndMetadataDataView;
  using Data_ = internal::PasswordAndMetadata_Data;

  template <typename... Args>
  static PasswordAndMetadataPtr New(Args&&... args) {
    return PasswordAndMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PasswordAndMetadataPtr From(const U& u) {
    return mojo::TypeConverter<PasswordAndMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordAndMetadata>::Convert(*this);
  }


  PasswordAndMetadata();

  PasswordAndMetadata(
      const ::std::u16string& username_value,
      const ::std::u16string& password_value,
      const std::string& realm,
      bool uses_account_store,
      bool is_grouped_affiliation);


  ~PasswordAndMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PasswordAndMetadataPtr>
  PasswordAndMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PasswordAndMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordAndMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PasswordAndMetadata_UnserializedMessageContext<
            UserType, PasswordAndMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PasswordAndMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PasswordAndMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PasswordAndMetadata_UnserializedMessageContext<
            UserType, PasswordAndMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PasswordAndMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string username_value;
  
  ::std::u16string password_value;
  
  std::string realm;
  
  bool uses_account_store;
  
  bool is_grouped_affiliation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PasswordAndMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PasswordFormFillData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PasswordFormFillData, T>::value>;
  using DataView = PasswordFormFillDataDataView;
  using Data_ = internal::PasswordFormFillData_Data;

  template <typename... Args>
  static PasswordFormFillDataPtr New(Args&&... args) {
    return PasswordFormFillDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PasswordFormFillDataPtr From(const U& u) {
    return mojo::TypeConverter<PasswordFormFillDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordFormFillData>::Convert(*this);
  }


  PasswordFormFillData();

  PasswordFormFillData(
      ::autofill::FormRendererId form_renderer_id,
      const ::GURL& url,
      ::autofill::FieldRendererId username_element_renderer_id,
      ::autofill::FieldRendererId password_element_renderer_id,
      bool username_may_use_prefilled_placeholder,
      const ::autofill::PasswordAndMetadata& preferred_login,
      std::vector<::autofill::PasswordAndMetadata> additional_logins,
      bool wait_for_username,
      std::vector<::autofill::FieldRendererId> suggestion_banned_fields,
      bool notify_browser_of_successful_filling);


  ~PasswordFormFillData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PasswordFormFillDataPtr>
  PasswordFormFillDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PasswordFormFillData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordFormFillData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PasswordFormFillData_UnserializedMessageContext<
            UserType, PasswordFormFillData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PasswordFormFillData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PasswordFormFillData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PasswordFormFillData_UnserializedMessageContext<
            UserType, PasswordFormFillData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PasswordFormFillData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::autofill::FormRendererId form_renderer_id;
  
  ::GURL url;
  
  ::autofill::FieldRendererId username_element_renderer_id;
  
  ::autofill::FieldRendererId password_element_renderer_id;
  
  bool username_may_use_prefilled_placeholder;
  
  ::autofill::PasswordAndMetadata preferred_login;
  
  std::vector<::autofill::PasswordAndMetadata> additional_logins;
  
  bool wait_for_username;
  
  std::vector<::autofill::FieldRendererId> suggestion_banned_fields;
  
  bool notify_browser_of_successful_filling;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PasswordFormFillData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PasswordFormGenerationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PasswordFormGenerationData, T>::value>;
  using DataView = PasswordFormGenerationDataDataView;
  using Data_ = internal::PasswordFormGenerationData_Data;

  template <typename... Args>
  static PasswordFormGenerationDataPtr New(Args&&... args) {
    return PasswordFormGenerationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PasswordFormGenerationDataPtr From(const U& u) {
    return mojo::TypeConverter<PasswordFormGenerationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordFormGenerationData>::Convert(*this);
  }


  PasswordFormGenerationData();

  PasswordFormGenerationData(
      ::autofill::FieldRendererId new_password_renderer_id,
      ::autofill::FieldRendererId confirmation_password_renderer_id);


  ~PasswordFormGenerationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PasswordFormGenerationDataPtr>
  PasswordFormGenerationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PasswordFormGenerationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordFormGenerationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PasswordFormGenerationData_UnserializedMessageContext<
            UserType, PasswordFormGenerationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PasswordFormGenerationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PasswordFormGenerationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PasswordFormGenerationData_UnserializedMessageContext<
            UserType, PasswordFormGenerationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PasswordFormGenerationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::autofill::FieldRendererId new_password_renderer_id;
  
  ::autofill::FieldRendererId confirmation_password_renderer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PasswordFormGenerationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PasswordGenerationUIData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PasswordGenerationUIData, T>::value>;
  using DataView = PasswordGenerationUIDataDataView;
  using Data_ = internal::PasswordGenerationUIData_Data;

  template <typename... Args>
  static PasswordGenerationUIDataPtr New(Args&&... args) {
    return PasswordGenerationUIDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PasswordGenerationUIDataPtr From(const U& u) {
    return mojo::TypeConverter<PasswordGenerationUIDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordGenerationUIData>::Convert(*this);
  }


  PasswordGenerationUIData();

  PasswordGenerationUIData(
      const ::gfx::RectF& bounds,
      int32_t max_length,
      const ::std::u16string& generation_element,
      ::autofill::FieldRendererId generation_element_id,
      bool is_generation_element_password_type,
      ::base::i18n::TextDirection text_direction,
      const ::autofill::FormData& form_data,
      bool generation_rejected);


  ~PasswordGenerationUIData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PasswordGenerationUIDataPtr>
  PasswordGenerationUIDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PasswordGenerationUIData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordGenerationUIData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PasswordGenerationUIData_UnserializedMessageContext<
            UserType, PasswordGenerationUIData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PasswordGenerationUIData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PasswordGenerationUIData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PasswordGenerationUIData_UnserializedMessageContext<
            UserType, PasswordGenerationUIData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PasswordGenerationUIData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::RectF bounds;
  
  int32_t max_length;
  
  ::std::u16string generation_element;
  
  ::autofill::FieldRendererId generation_element_id;
  
  bool is_generation_element_password_type;
  
  ::base::i18n::TextDirection text_direction;
  
  ::autofill::FormData form_data;
  
  bool generation_rejected;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PasswordGenerationUIData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PasswordSuggestionRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PasswordSuggestionRequest, T>::value>;
  using DataView = PasswordSuggestionRequestDataView;
  using Data_ = internal::PasswordSuggestionRequest_Data;

  template <typename... Args>
  static PasswordSuggestionRequestPtr New(Args&&... args) {
    return PasswordSuggestionRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PasswordSuggestionRequestPtr From(const U& u) {
    return mojo::TypeConverter<PasswordSuggestionRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PasswordSuggestionRequest>::Convert(*this);
  }


  PasswordSuggestionRequest();

  PasswordSuggestionRequest(
      ::autofill::FieldRendererId element_id,
      const ::autofill::FormData& form_data,
      AutofillSuggestionTriggerSource trigger_source,
      uint64_t username_field_index,
      uint64_t password_field_index,
      ::base::i18n::TextDirection text_direction,
      const ::std::u16string& typed_username,
      bool show_webauthn_credentials,
      const ::gfx::RectF& bounds);


  ~PasswordSuggestionRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PasswordSuggestionRequestPtr>
  PasswordSuggestionRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PasswordSuggestionRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PasswordSuggestionRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PasswordSuggestionRequest_UnserializedMessageContext<
            UserType, PasswordSuggestionRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PasswordSuggestionRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PasswordSuggestionRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PasswordSuggestionRequest_UnserializedMessageContext<
            UserType, PasswordSuggestionRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PasswordSuggestionRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::autofill::FieldRendererId element_id;
  
  ::autofill::FormData form_data;
  
  AutofillSuggestionTriggerSource trigger_source;
  
  uint64_t username_field_index;
  
  uint64_t password_field_index;
  
  ::base::i18n::TextDirection text_direction;
  
  ::std::u16string typed_username;
  
  bool show_webauthn_credentials;
  
  ::gfx::RectF bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PasswordSuggestionRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ParsingResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsingResult, T>::value>;
  using DataView = ParsingResultDataView;
  using Data_ = internal::ParsingResult_Data;

  template <typename... Args>
  static ParsingResultPtr New(Args&&... args) {
    return ParsingResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsingResultPtr From(const U& u) {
    return mojo::TypeConverter<ParsingResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsingResult>::Convert(*this);
  }


  ParsingResult();

  ParsingResult(
      ::autofill::FieldRendererId username_renderer_id,
      ::autofill::FieldRendererId password_renderer_id,
      ::autofill::FieldRendererId new_password_renderer_id,
      ::autofill::FieldRendererId confirm_password_renderer_id);


  ~ParsingResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsingResultPtr>
  ParsingResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsingResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsingResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsingResult_UnserializedMessageContext<
            UserType, ParsingResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParsingResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParsingResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsingResult_UnserializedMessageContext<
            UserType, ParsingResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsingResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::autofill::FieldRendererId username_renderer_id;
  
  ::autofill::FieldRendererId password_renderer_id;
  
  ::autofill::FieldRendererId new_password_renderer_id;
  
  ::autofill::FieldRendererId confirm_password_renderer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsingResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SectionValuePtr SectionValue::Clone() const {
  switch (tag_) {
    case Tag::kDefaultSection:
      return NewDefaultSection(
          mojo::Clone(data_.default_section));
    case Tag::kAutocomplete:
      return NewAutocomplete(
          mojo::Clone(*data_.autocomplete));
    case Tag::kFieldIdentifier:
      return NewFieldIdentifier(
          mojo::Clone(*data_.field_identifier));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SectionValue>::value>::type*>
bool SectionValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDefaultSection:
      return mojo::Equals(data_.default_section, other.data_.default_section);
    case Tag::kAutocomplete:
      return mojo::Equals(*(data_.autocomplete), *(other.data_.autocomplete));
    case Tag::kFieldIdentifier:
      return mojo::Equals(*(data_.field_identifier), *(other.data_.field_identifier));
  }

  return false;
}
template <typename StructPtrType>
FrameTokenPtr FrameToken::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(is_local)
  );
}

template <typename T, FrameToken::EnableIfSame<T>*>
bool FrameToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->is_local, other_struct.is_local))
    return false;
  return true;
}

template <typename T, FrameToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.is_local < rhs.is_local)
    return true;
  if (rhs.is_local < lhs.is_local)
    return false;
  return false;
}
template <typename StructPtrType>
FrameTokenWithPredecessorPtr FrameTokenWithPredecessor::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(predecessor)
  );
}

template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>*>
bool FrameTokenWithPredecessor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->predecessor, other_struct.predecessor))
    return false;
  return true;
}

template <typename T, FrameTokenWithPredecessor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.predecessor < rhs.predecessor)
    return true;
  if (rhs.predecessor < lhs.predecessor)
    return false;
  return false;
}
template <typename StructPtrType>
FormRendererIdPtr FormRendererId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, FormRendererId::EnableIfSame<T>*>
bool FormRendererId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, FormRendererId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
FieldRendererIdPtr FieldRendererId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, FieldRendererId::EnableIfSame<T>*>
bool FieldRendererId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, FieldRendererId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
SelectOptionPtr SelectOption::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(text)
  );
}

template <typename T, SelectOption::EnableIfSame<T>*>
bool SelectOption::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  return true;
}

template <typename T, SelectOption::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  return false;
}
template <typename StructPtrType>
SectionAutocompletePtr SectionAutocomplete::Clone() const {
  return New(
      mojo::Clone(section),
      mojo::Clone(html_field_mode)
  );
}

template <typename T, SectionAutocomplete::EnableIfSame<T>*>
bool SectionAutocomplete::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->section, other_struct.section))
    return false;
  if (!mojo::Equals(this->html_field_mode, other_struct.html_field_mode))
    return false;
  return true;
}

template <typename T, SectionAutocomplete::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.section < rhs.section)
    return true;
  if (rhs.section < lhs.section)
    return false;
  if (lhs.html_field_mode < rhs.html_field_mode)
    return true;
  if (rhs.html_field_mode < lhs.html_field_mode)
    return false;
  return false;
}
template <typename StructPtrType>
SectionFieldIdentifierPtr SectionFieldIdentifier::Clone() const {
  return New(
      mojo::Clone(field_name),
      mojo::Clone(local_frame_id),
      mojo::Clone(field_renderer_id)
  );
}

template <typename T, SectionFieldIdentifier::EnableIfSame<T>*>
bool SectionFieldIdentifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->field_name, other_struct.field_name))
    return false;
  if (!mojo::Equals(this->local_frame_id, other_struct.local_frame_id))
    return false;
  if (!mojo::Equals(this->field_renderer_id, other_struct.field_renderer_id))
    return false;
  return true;
}

template <typename T, SectionFieldIdentifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.field_name < rhs.field_name)
    return true;
  if (rhs.field_name < lhs.field_name)
    return false;
  if (lhs.local_frame_id < rhs.local_frame_id)
    return true;
  if (rhs.local_frame_id < lhs.local_frame_id)
    return false;
  if (lhs.field_renderer_id < rhs.field_renderer_id)
    return true;
  if (rhs.field_renderer_id < lhs.field_renderer_id)
    return false;
  return false;
}
template <typename StructPtrType>
SectionPtr Section::Clone() const {
  return New(
      mojo::Clone(value)
  );
}

template <typename T, Section::EnableIfSame<T>*>
bool Section::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, Section::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
AutocompleteParsingResultPtr AutocompleteParsingResult::Clone() const {
  return New(
      mojo::Clone(section),
      mojo::Clone(mode),
      mojo::Clone(field_type),
      mojo::Clone(webauthn)
  );
}

template <typename T, AutocompleteParsingResult::EnableIfSame<T>*>
bool AutocompleteParsingResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->section, other_struct.section))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->field_type, other_struct.field_type))
    return false;
  if (!mojo::Equals(this->webauthn, other_struct.webauthn))
    return false;
  return true;
}

template <typename T, AutocompleteParsingResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.section < rhs.section)
    return true;
  if (rhs.section < lhs.section)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.field_type < rhs.field_type)
    return true;
  if (rhs.field_type < lhs.field_type)
    return false;
  if (lhs.webauthn < rhs.webauthn)
    return true;
  if (rhs.webauthn < lhs.webauthn)
    return false;
  return false;
}
template <typename StructPtrType>
FormFieldDataPtr FormFieldData::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(name),
      mojo::Clone(id_attribute),
      mojo::Clone(name_attribute),
      mojo::Clone(value),
      mojo::Clone(selected_text),
      mojo::Clone(form_control_type),
      mojo::Clone(autocomplete_attribute),
      mojo::Clone(parsed_autocomplete),
      mojo::Clone(placeholder),
      mojo::Clone(css_classes),
      mojo::Clone(aria_label),
      mojo::Clone(aria_description),
      mojo::Clone(renderer_id),
      mojo::Clone(host_form_id),
      mojo::Clone(properties_mask),
      mojo::Clone(form_control_ax_id),
      mojo::Clone(max_length),
      mojo::Clone(is_user_edited),
      mojo::Clone(is_autofilled),
      mojo::Clone(section),
      mojo::Clone(check_status),
      mojo::Clone(is_focusable),
      mojo::Clone(is_visible),
      mojo::Clone(should_autocomplete),
      mojo::Clone(role),
      mojo::Clone(text_direction),
      mojo::Clone(is_enabled),
      mojo::Clone(is_readonly),
      mojo::Clone(user_input),
      mojo::Clone(allows_writing_suggestions),
      mojo::Clone(options),
      mojo::Clone(label_source),
      mojo::Clone(bounds),
      mojo::Clone(datalist_options),
      mojo::Clone(force_override)
  );
}

template <typename T, FormFieldData::EnableIfSame<T>*>
bool FormFieldData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->id_attribute, other_struct.id_attribute))
    return false;
  if (!mojo::Equals(this->name_attribute, other_struct.name_attribute))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->selected_text, other_struct.selected_text))
    return false;
  if (!mojo::Equals(this->form_control_type, other_struct.form_control_type))
    return false;
  if (!mojo::Equals(this->autocomplete_attribute, other_struct.autocomplete_attribute))
    return false;
  if (!mojo::Equals(this->parsed_autocomplete, other_struct.parsed_autocomplete))
    return false;
  if (!mojo::Equals(this->placeholder, other_struct.placeholder))
    return false;
  if (!mojo::Equals(this->css_classes, other_struct.css_classes))
    return false;
  if (!mojo::Equals(this->aria_label, other_struct.aria_label))
    return false;
  if (!mojo::Equals(this->aria_description, other_struct.aria_description))
    return false;
  if (!mojo::Equals(this->renderer_id, other_struct.renderer_id))
    return false;
  if (!mojo::Equals(this->host_form_id, other_struct.host_form_id))
    return false;
  if (!mojo::Equals(this->properties_mask, other_struct.properties_mask))
    return false;
  if (!mojo::Equals(this->form_control_ax_id, other_struct.form_control_ax_id))
    return false;
  if (!mojo::Equals(this->max_length, other_struct.max_length))
    return false;
  if (!mojo::Equals(this->is_user_edited, other_struct.is_user_edited))
    return false;
  if (!mojo::Equals(this->is_autofilled, other_struct.is_autofilled))
    return false;
  if (!mojo::Equals(this->section, other_struct.section))
    return false;
  if (!mojo::Equals(this->check_status, other_struct.check_status))
    return false;
  if (!mojo::Equals(this->is_focusable, other_struct.is_focusable))
    return false;
  if (!mojo::Equals(this->is_visible, other_struct.is_visible))
    return false;
  if (!mojo::Equals(this->should_autocomplete, other_struct.should_autocomplete))
    return false;
  if (!mojo::Equals(this->role, other_struct.role))
    return false;
  if (!mojo::Equals(this->text_direction, other_struct.text_direction))
    return false;
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->is_readonly, other_struct.is_readonly))
    return false;
  if (!mojo::Equals(this->user_input, other_struct.user_input))
    return false;
  if (!mojo::Equals(this->allows_writing_suggestions, other_struct.allows_writing_suggestions))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->label_source, other_struct.label_source))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->datalist_options, other_struct.datalist_options))
    return false;
  if (!mojo::Equals(this->force_override, other_struct.force_override))
    return false;
  return true;
}

template <typename T, FormFieldData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.id_attribute < rhs.id_attribute)
    return true;
  if (rhs.id_attribute < lhs.id_attribute)
    return false;
  if (lhs.name_attribute < rhs.name_attribute)
    return true;
  if (rhs.name_attribute < lhs.name_attribute)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.selected_text < rhs.selected_text)
    return true;
  if (rhs.selected_text < lhs.selected_text)
    return false;
  if (lhs.form_control_type < rhs.form_control_type)
    return true;
  if (rhs.form_control_type < lhs.form_control_type)
    return false;
  if (lhs.autocomplete_attribute < rhs.autocomplete_attribute)
    return true;
  if (rhs.autocomplete_attribute < lhs.autocomplete_attribute)
    return false;
  if (lhs.parsed_autocomplete < rhs.parsed_autocomplete)
    return true;
  if (rhs.parsed_autocomplete < lhs.parsed_autocomplete)
    return false;
  if (lhs.placeholder < rhs.placeholder)
    return true;
  if (rhs.placeholder < lhs.placeholder)
    return false;
  if (lhs.css_classes < rhs.css_classes)
    return true;
  if (rhs.css_classes < lhs.css_classes)
    return false;
  if (lhs.aria_label < rhs.aria_label)
    return true;
  if (rhs.aria_label < lhs.aria_label)
    return false;
  if (lhs.aria_description < rhs.aria_description)
    return true;
  if (rhs.aria_description < lhs.aria_description)
    return false;
  if (lhs.renderer_id < rhs.renderer_id)
    return true;
  if (rhs.renderer_id < lhs.renderer_id)
    return false;
  if (lhs.host_form_id < rhs.host_form_id)
    return true;
  if (rhs.host_form_id < lhs.host_form_id)
    return false;
  if (lhs.properties_mask < rhs.properties_mask)
    return true;
  if (rhs.properties_mask < lhs.properties_mask)
    return false;
  if (lhs.form_control_ax_id < rhs.form_control_ax_id)
    return true;
  if (rhs.form_control_ax_id < lhs.form_control_ax_id)
    return false;
  if (lhs.max_length < rhs.max_length)
    return true;
  if (rhs.max_length < lhs.max_length)
    return false;
  if (lhs.is_user_edited < rhs.is_user_edited)
    return true;
  if (rhs.is_user_edited < lhs.is_user_edited)
    return false;
  if (lhs.is_autofilled < rhs.is_autofilled)
    return true;
  if (rhs.is_autofilled < lhs.is_autofilled)
    return false;
  if (lhs.section < rhs.section)
    return true;
  if (rhs.section < lhs.section)
    return false;
  if (lhs.check_status < rhs.check_status)
    return true;
  if (rhs.check_status < lhs.check_status)
    return false;
  if (lhs.is_focusable < rhs.is_focusable)
    return true;
  if (rhs.is_focusable < lhs.is_focusable)
    return false;
  if (lhs.is_visible < rhs.is_visible)
    return true;
  if (rhs.is_visible < lhs.is_visible)
    return false;
  if (lhs.should_autocomplete < rhs.should_autocomplete)
    return true;
  if (rhs.should_autocomplete < lhs.should_autocomplete)
    return false;
  if (lhs.role < rhs.role)
    return true;
  if (rhs.role < lhs.role)
    return false;
  if (lhs.text_direction < rhs.text_direction)
    return true;
  if (rhs.text_direction < lhs.text_direction)
    return false;
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.is_readonly < rhs.is_readonly)
    return true;
  if (rhs.is_readonly < lhs.is_readonly)
    return false;
  if (lhs.user_input < rhs.user_input)
    return true;
  if (rhs.user_input < lhs.user_input)
    return false;
  if (lhs.allows_writing_suggestions < rhs.allows_writing_suggestions)
    return true;
  if (rhs.allows_writing_suggestions < lhs.allows_writing_suggestions)
    return false;
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  if (lhs.label_source < rhs.label_source)
    return true;
  if (rhs.label_source < lhs.label_source)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.datalist_options < rhs.datalist_options)
    return true;
  if (rhs.datalist_options < lhs.datalist_options)
    return false;
  if (lhs.force_override < rhs.force_override)
    return true;
  if (rhs.force_override < lhs.force_override)
    return false;
  return false;
}
template <typename StructPtrType>
FormFieldData_FillDataPtr FormFieldData_FillData::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(renderer_id),
      mojo::Clone(host_form_id),
      mojo::Clone(is_autofilled),
      mojo::Clone(force_override)
  );
}

template <typename T, FormFieldData_FillData::EnableIfSame<T>*>
bool FormFieldData_FillData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->renderer_id, other_struct.renderer_id))
    return false;
  if (!mojo::Equals(this->host_form_id, other_struct.host_form_id))
    return false;
  if (!mojo::Equals(this->is_autofilled, other_struct.is_autofilled))
    return false;
  if (!mojo::Equals(this->force_override, other_struct.force_override))
    return false;
  return true;
}

template <typename T, FormFieldData_FillData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.renderer_id < rhs.renderer_id)
    return true;
  if (rhs.renderer_id < lhs.renderer_id)
    return false;
  if (lhs.host_form_id < rhs.host_form_id)
    return true;
  if (rhs.host_form_id < lhs.host_form_id)
    return false;
  if (lhs.is_autofilled < rhs.is_autofilled)
    return true;
  if (rhs.is_autofilled < lhs.is_autofilled)
    return false;
  if (lhs.force_override < rhs.force_override)
    return true;
  if (rhs.force_override < lhs.force_override)
    return false;
  return false;
}
template <typename StructPtrType>
ButtonTitleInfoPtr ButtonTitleInfo::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(type)
  );
}

template <typename T, ButtonTitleInfo::EnableIfSame<T>*>
bool ButtonTitleInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, ButtonTitleInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
FormDataPtr FormData::Clone() const {
  return New(
      mojo::Clone(id_attribute),
      mojo::Clone(name_attribute),
      mojo::Clone(name),
      mojo::Clone(button_titles),
      mojo::Clone(action),
      mojo::Clone(is_action_empty),
      mojo::Clone(renderer_id),
      mojo::Clone(child_frames),
      mojo::Clone(submission_event),
      mojo::Clone(fields),
      mojo::Clone(username_predictions),
      mojo::Clone(is_gaia_with_skip_save_password_form),
      mojo::Clone(likely_contains_captcha)
  );
}

template <typename T, FormData::EnableIfSame<T>*>
bool FormData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id_attribute, other_struct.id_attribute))
    return false;
  if (!mojo::Equals(this->name_attribute, other_struct.name_attribute))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->button_titles, other_struct.button_titles))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->is_action_empty, other_struct.is_action_empty))
    return false;
  if (!mojo::Equals(this->renderer_id, other_struct.renderer_id))
    return false;
  if (!mojo::Equals(this->child_frames, other_struct.child_frames))
    return false;
  if (!mojo::Equals(this->submission_event, other_struct.submission_event))
    return false;
  if (!mojo::Equals(this->fields, other_struct.fields))
    return false;
  if (!mojo::Equals(this->username_predictions, other_struct.username_predictions))
    return false;
  if (!mojo::Equals(this->is_gaia_with_skip_save_password_form, other_struct.is_gaia_with_skip_save_password_form))
    return false;
  if (!mojo::Equals(this->likely_contains_captcha, other_struct.likely_contains_captcha))
    return false;
  return true;
}

template <typename T, FormData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id_attribute < rhs.id_attribute)
    return true;
  if (rhs.id_attribute < lhs.id_attribute)
    return false;
  if (lhs.name_attribute < rhs.name_attribute)
    return true;
  if (rhs.name_attribute < lhs.name_attribute)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.button_titles < rhs.button_titles)
    return true;
  if (rhs.button_titles < lhs.button_titles)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.is_action_empty < rhs.is_action_empty)
    return true;
  if (rhs.is_action_empty < lhs.is_action_empty)
    return false;
  if (lhs.renderer_id < rhs.renderer_id)
    return true;
  if (rhs.renderer_id < lhs.renderer_id)
    return false;
  if (lhs.child_frames < rhs.child_frames)
    return true;
  if (rhs.child_frames < lhs.child_frames)
    return false;
  if (lhs.submission_event < rhs.submission_event)
    return true;
  if (rhs.submission_event < lhs.submission_event)
    return false;
  if (lhs.fields < rhs.fields)
    return true;
  if (rhs.fields < lhs.fields)
    return false;
  if (lhs.username_predictions < rhs.username_predictions)
    return true;
  if (rhs.username_predictions < lhs.username_predictions)
    return false;
  if (lhs.is_gaia_with_skip_save_password_form < rhs.is_gaia_with_skip_save_password_form)
    return true;
  if (rhs.is_gaia_with_skip_save_password_form < lhs.is_gaia_with_skip_save_password_form)
    return false;
  if (lhs.likely_contains_captcha < rhs.likely_contains_captcha)
    return true;
  if (rhs.likely_contains_captcha < lhs.likely_contains_captcha)
    return false;
  return false;
}
template <typename StructPtrType>
FormFieldDataPredictionsPtr FormFieldDataPredictions::Clone() const {
  return New(
      mojo::Clone(host_form_signature),
      mojo::Clone(signature),
      mojo::Clone(heuristic_type),
      mojo::Clone(server_type),
      mojo::Clone(html_type),
      mojo::Clone(overall_type),
      mojo::Clone(parseable_name),
      mojo::Clone(parseable_label),
      mojo::Clone(section),
      mojo::Clone(rank),
      mojo::Clone(rank_in_signature_group),
      mojo::Clone(rank_in_host_form),
      mojo::Clone(rank_in_host_form_signature_group)
  );
}

template <typename T, FormFieldDataPredictions::EnableIfSame<T>*>
bool FormFieldDataPredictions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->host_form_signature, other_struct.host_form_signature))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->heuristic_type, other_struct.heuristic_type))
    return false;
  if (!mojo::Equals(this->server_type, other_struct.server_type))
    return false;
  if (!mojo::Equals(this->html_type, other_struct.html_type))
    return false;
  if (!mojo::Equals(this->overall_type, other_struct.overall_type))
    return false;
  if (!mojo::Equals(this->parseable_name, other_struct.parseable_name))
    return false;
  if (!mojo::Equals(this->parseable_label, other_struct.parseable_label))
    return false;
  if (!mojo::Equals(this->section, other_struct.section))
    return false;
  if (!mojo::Equals(this->rank, other_struct.rank))
    return false;
  if (!mojo::Equals(this->rank_in_signature_group, other_struct.rank_in_signature_group))
    return false;
  if (!mojo::Equals(this->rank_in_host_form, other_struct.rank_in_host_form))
    return false;
  if (!mojo::Equals(this->rank_in_host_form_signature_group, other_struct.rank_in_host_form_signature_group))
    return false;
  return true;
}

template <typename T, FormFieldDataPredictions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.host_form_signature < rhs.host_form_signature)
    return true;
  if (rhs.host_form_signature < lhs.host_form_signature)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.heuristic_type < rhs.heuristic_type)
    return true;
  if (rhs.heuristic_type < lhs.heuristic_type)
    return false;
  if (lhs.server_type < rhs.server_type)
    return true;
  if (rhs.server_type < lhs.server_type)
    return false;
  if (lhs.html_type < rhs.html_type)
    return true;
  if (rhs.html_type < lhs.html_type)
    return false;
  if (lhs.overall_type < rhs.overall_type)
    return true;
  if (rhs.overall_type < lhs.overall_type)
    return false;
  if (lhs.parseable_name < rhs.parseable_name)
    return true;
  if (rhs.parseable_name < lhs.parseable_name)
    return false;
  if (lhs.parseable_label < rhs.parseable_label)
    return true;
  if (rhs.parseable_label < lhs.parseable_label)
    return false;
  if (lhs.section < rhs.section)
    return true;
  if (rhs.section < lhs.section)
    return false;
  if (lhs.rank < rhs.rank)
    return true;
  if (rhs.rank < lhs.rank)
    return false;
  if (lhs.rank_in_signature_group < rhs.rank_in_signature_group)
    return true;
  if (rhs.rank_in_signature_group < lhs.rank_in_signature_group)
    return false;
  if (lhs.rank_in_host_form < rhs.rank_in_host_form)
    return true;
  if (rhs.rank_in_host_form < lhs.rank_in_host_form)
    return false;
  if (lhs.rank_in_host_form_signature_group < rhs.rank_in_host_form_signature_group)
    return true;
  if (rhs.rank_in_host_form_signature_group < lhs.rank_in_host_form_signature_group)
    return false;
  return false;
}
template <typename StructPtrType>
FormDataPredictionsPtr FormDataPredictions::Clone() const {
  return New(
      mojo::Clone(data),
      mojo::Clone(signature),
      mojo::Clone(alternative_signature),
      mojo::Clone(fields)
  );
}

template <typename T, FormDataPredictions::EnableIfSame<T>*>
bool FormDataPredictions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->signature, other_struct.signature))
    return false;
  if (!mojo::Equals(this->alternative_signature, other_struct.alternative_signature))
    return false;
  if (!mojo::Equals(this->fields, other_struct.fields))
    return false;
  return true;
}

template <typename T, FormDataPredictions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.signature < rhs.signature)
    return true;
  if (rhs.signature < lhs.signature)
    return false;
  if (lhs.alternative_signature < rhs.alternative_signature)
    return true;
  if (rhs.alternative_signature < lhs.alternative_signature)
    return false;
  if (lhs.fields < rhs.fields)
    return true;
  if (rhs.fields < lhs.fields)
    return false;
  return false;
}
template <typename StructPtrType>
PasswordAndMetadataPtr PasswordAndMetadata::Clone() const {
  return New(
      mojo::Clone(username_value),
      mojo::Clone(password_value),
      mojo::Clone(realm),
      mojo::Clone(uses_account_store),
      mojo::Clone(is_grouped_affiliation)
  );
}

template <typename T, PasswordAndMetadata::EnableIfSame<T>*>
bool PasswordAndMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->username_value, other_struct.username_value))
    return false;
  if (!mojo::Equals(this->password_value, other_struct.password_value))
    return false;
  if (!mojo::Equals(this->realm, other_struct.realm))
    return false;
  if (!mojo::Equals(this->uses_account_store, other_struct.uses_account_store))
    return false;
  if (!mojo::Equals(this->is_grouped_affiliation, other_struct.is_grouped_affiliation))
    return false;
  return true;
}

template <typename T, PasswordAndMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.username_value < rhs.username_value)
    return true;
  if (rhs.username_value < lhs.username_value)
    return false;
  if (lhs.password_value < rhs.password_value)
    return true;
  if (rhs.password_value < lhs.password_value)
    return false;
  if (lhs.realm < rhs.realm)
    return true;
  if (rhs.realm < lhs.realm)
    return false;
  if (lhs.uses_account_store < rhs.uses_account_store)
    return true;
  if (rhs.uses_account_store < lhs.uses_account_store)
    return false;
  if (lhs.is_grouped_affiliation < rhs.is_grouped_affiliation)
    return true;
  if (rhs.is_grouped_affiliation < lhs.is_grouped_affiliation)
    return false;
  return false;
}
template <typename StructPtrType>
PasswordFormFillDataPtr PasswordFormFillData::Clone() const {
  return New(
      mojo::Clone(form_renderer_id),
      mojo::Clone(url),
      mojo::Clone(username_element_renderer_id),
      mojo::Clone(password_element_renderer_id),
      mojo::Clone(username_may_use_prefilled_placeholder),
      mojo::Clone(preferred_login),
      mojo::Clone(additional_logins),
      mojo::Clone(wait_for_username),
      mojo::Clone(suggestion_banned_fields),
      mojo::Clone(notify_browser_of_successful_filling)
  );
}

template <typename T, PasswordFormFillData::EnableIfSame<T>*>
bool PasswordFormFillData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->form_renderer_id, other_struct.form_renderer_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->username_element_renderer_id, other_struct.username_element_renderer_id))
    return false;
  if (!mojo::Equals(this->password_element_renderer_id, other_struct.password_element_renderer_id))
    return false;
  if (!mojo::Equals(this->username_may_use_prefilled_placeholder, other_struct.username_may_use_prefilled_placeholder))
    return false;
  if (!mojo::Equals(this->preferred_login, other_struct.preferred_login))
    return false;
  if (!mojo::Equals(this->additional_logins, other_struct.additional_logins))
    return false;
  if (!mojo::Equals(this->wait_for_username, other_struct.wait_for_username))
    return false;
  if (!mojo::Equals(this->suggestion_banned_fields, other_struct.suggestion_banned_fields))
    return false;
  if (!mojo::Equals(this->notify_browser_of_successful_filling, other_struct.notify_browser_of_successful_filling))
    return false;
  return true;
}

template <typename T, PasswordFormFillData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.form_renderer_id < rhs.form_renderer_id)
    return true;
  if (rhs.form_renderer_id < lhs.form_renderer_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.username_element_renderer_id < rhs.username_element_renderer_id)
    return true;
  if (rhs.username_element_renderer_id < lhs.username_element_renderer_id)
    return false;
  if (lhs.password_element_renderer_id < rhs.password_element_renderer_id)
    return true;
  if (rhs.password_element_renderer_id < lhs.password_element_renderer_id)
    return false;
  if (lhs.username_may_use_prefilled_placeholder < rhs.username_may_use_prefilled_placeholder)
    return true;
  if (rhs.username_may_use_prefilled_placeholder < lhs.username_may_use_prefilled_placeholder)
    return false;
  if (lhs.preferred_login < rhs.preferred_login)
    return true;
  if (rhs.preferred_login < lhs.preferred_login)
    return false;
  if (lhs.additional_logins < rhs.additional_logins)
    return true;
  if (rhs.additional_logins < lhs.additional_logins)
    return false;
  if (lhs.wait_for_username < rhs.wait_for_username)
    return true;
  if (rhs.wait_for_username < lhs.wait_for_username)
    return false;
  if (lhs.suggestion_banned_fields < rhs.suggestion_banned_fields)
    return true;
  if (rhs.suggestion_banned_fields < lhs.suggestion_banned_fields)
    return false;
  if (lhs.notify_browser_of_successful_filling < rhs.notify_browser_of_successful_filling)
    return true;
  if (rhs.notify_browser_of_successful_filling < lhs.notify_browser_of_successful_filling)
    return false;
  return false;
}
template <typename StructPtrType>
PasswordFormGenerationDataPtr PasswordFormGenerationData::Clone() const {
  return New(
      mojo::Clone(new_password_renderer_id),
      mojo::Clone(confirmation_password_renderer_id)
  );
}

template <typename T, PasswordFormGenerationData::EnableIfSame<T>*>
bool PasswordFormGenerationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->new_password_renderer_id, other_struct.new_password_renderer_id))
    return false;
  if (!mojo::Equals(this->confirmation_password_renderer_id, other_struct.confirmation_password_renderer_id))
    return false;
  return true;
}

template <typename T, PasswordFormGenerationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.new_password_renderer_id < rhs.new_password_renderer_id)
    return true;
  if (rhs.new_password_renderer_id < lhs.new_password_renderer_id)
    return false;
  if (lhs.confirmation_password_renderer_id < rhs.confirmation_password_renderer_id)
    return true;
  if (rhs.confirmation_password_renderer_id < lhs.confirmation_password_renderer_id)
    return false;
  return false;
}
template <typename StructPtrType>
PasswordGenerationUIDataPtr PasswordGenerationUIData::Clone() const {
  return New(
      mojo::Clone(bounds),
      mojo::Clone(max_length),
      mojo::Clone(generation_element),
      mojo::Clone(generation_element_id),
      mojo::Clone(is_generation_element_password_type),
      mojo::Clone(text_direction),
      mojo::Clone(form_data),
      mojo::Clone(generation_rejected)
  );
}

template <typename T, PasswordGenerationUIData::EnableIfSame<T>*>
bool PasswordGenerationUIData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->max_length, other_struct.max_length))
    return false;
  if (!mojo::Equals(this->generation_element, other_struct.generation_element))
    return false;
  if (!mojo::Equals(this->generation_element_id, other_struct.generation_element_id))
    return false;
  if (!mojo::Equals(this->is_generation_element_password_type, other_struct.is_generation_element_password_type))
    return false;
  if (!mojo::Equals(this->text_direction, other_struct.text_direction))
    return false;
  if (!mojo::Equals(this->form_data, other_struct.form_data))
    return false;
  if (!mojo::Equals(this->generation_rejected, other_struct.generation_rejected))
    return false;
  return true;
}

template <typename T, PasswordGenerationUIData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  if (lhs.max_length < rhs.max_length)
    return true;
  if (rhs.max_length < lhs.max_length)
    return false;
  if (lhs.generation_element < rhs.generation_element)
    return true;
  if (rhs.generation_element < lhs.generation_element)
    return false;
  if (lhs.generation_element_id < rhs.generation_element_id)
    return true;
  if (rhs.generation_element_id < lhs.generation_element_id)
    return false;
  if (lhs.is_generation_element_password_type < rhs.is_generation_element_password_type)
    return true;
  if (rhs.is_generation_element_password_type < lhs.is_generation_element_password_type)
    return false;
  if (lhs.text_direction < rhs.text_direction)
    return true;
  if (rhs.text_direction < lhs.text_direction)
    return false;
  if (lhs.form_data < rhs.form_data)
    return true;
  if (rhs.form_data < lhs.form_data)
    return false;
  if (lhs.generation_rejected < rhs.generation_rejected)
    return true;
  if (rhs.generation_rejected < lhs.generation_rejected)
    return false;
  return false;
}
template <typename StructPtrType>
PasswordSuggestionRequestPtr PasswordSuggestionRequest::Clone() const {
  return New(
      mojo::Clone(element_id),
      mojo::Clone(form_data),
      mojo::Clone(trigger_source),
      mojo::Clone(username_field_index),
      mojo::Clone(password_field_index),
      mojo::Clone(text_direction),
      mojo::Clone(typed_username),
      mojo::Clone(show_webauthn_credentials),
      mojo::Clone(bounds)
  );
}

template <typename T, PasswordSuggestionRequest::EnableIfSame<T>*>
bool PasswordSuggestionRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->element_id, other_struct.element_id))
    return false;
  if (!mojo::Equals(this->form_data, other_struct.form_data))
    return false;
  if (!mojo::Equals(this->trigger_source, other_struct.trigger_source))
    return false;
  if (!mojo::Equals(this->username_field_index, other_struct.username_field_index))
    return false;
  if (!mojo::Equals(this->password_field_index, other_struct.password_field_index))
    return false;
  if (!mojo::Equals(this->text_direction, other_struct.text_direction))
    return false;
  if (!mojo::Equals(this->typed_username, other_struct.typed_username))
    return false;
  if (!mojo::Equals(this->show_webauthn_credentials, other_struct.show_webauthn_credentials))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, PasswordSuggestionRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.element_id < rhs.element_id)
    return true;
  if (rhs.element_id < lhs.element_id)
    return false;
  if (lhs.form_data < rhs.form_data)
    return true;
  if (rhs.form_data < lhs.form_data)
    return false;
  if (lhs.trigger_source < rhs.trigger_source)
    return true;
  if (rhs.trigger_source < lhs.trigger_source)
    return false;
  if (lhs.username_field_index < rhs.username_field_index)
    return true;
  if (rhs.username_field_index < lhs.username_field_index)
    return false;
  if (lhs.password_field_index < rhs.password_field_index)
    return true;
  if (rhs.password_field_index < lhs.password_field_index)
    return false;
  if (lhs.text_direction < rhs.text_direction)
    return true;
  if (rhs.text_direction < lhs.text_direction)
    return false;
  if (lhs.typed_username < rhs.typed_username)
    return true;
  if (rhs.typed_username < lhs.typed_username)
    return false;
  if (lhs.show_webauthn_credentials < rhs.show_webauthn_credentials)
    return true;
  if (rhs.show_webauthn_credentials < lhs.show_webauthn_credentials)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  return false;
}
template <typename StructPtrType>
ParsingResultPtr ParsingResult::Clone() const {
  return New(
      mojo::Clone(username_renderer_id),
      mojo::Clone(password_renderer_id),
      mojo::Clone(new_password_renderer_id),
      mojo::Clone(confirm_password_renderer_id)
  );
}

template <typename T, ParsingResult::EnableIfSame<T>*>
bool ParsingResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->username_renderer_id, other_struct.username_renderer_id))
    return false;
  if (!mojo::Equals(this->password_renderer_id, other_struct.password_renderer_id))
    return false;
  if (!mojo::Equals(this->new_password_renderer_id, other_struct.new_password_renderer_id))
    return false;
  if (!mojo::Equals(this->confirm_password_renderer_id, other_struct.confirm_password_renderer_id))
    return false;
  return true;
}

template <typename T, ParsingResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.username_renderer_id < rhs.username_renderer_id)
    return true;
  if (rhs.username_renderer_id < lhs.username_renderer_id)
    return false;
  if (lhs.password_renderer_id < rhs.password_renderer_id)
    return true;
  if (rhs.password_renderer_id < lhs.password_renderer_id)
    return false;
  if (lhs.new_password_renderer_id < rhs.new_password_renderer_id)
    return true;
  if (rhs.new_password_renderer_id < lhs.new_password_renderer_id)
    return false;
  if (lhs.confirm_password_renderer_id < rhs.confirm_password_renderer_id)
    return true;
  if (rhs.confirm_password_renderer_id < lhs.confirm_password_renderer_id)
    return false;
  return false;
}


}  // autofill::mojom

namespace mojo {


template <>
struct  StructTraits<::autofill::mojom::FrameToken::DataView,
                                         ::autofill::mojom::FrameTokenPtr> {
  static bool IsNull(const ::autofill::mojom::FrameTokenPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FrameTokenPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FrameToken::token)& token(
      const ::autofill::mojom::FrameTokenPtr& input) {
    return input->token;
  }

  static decltype(::autofill::mojom::FrameToken::is_local) is_local(
      const ::autofill::mojom::FrameTokenPtr& input) {
    return input->is_local;
  }

  static bool Read(::autofill::mojom::FrameToken::DataView input, ::autofill::mojom::FrameTokenPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FrameTokenWithPredecessor::DataView,
                                         ::autofill::mojom::FrameTokenWithPredecessorPtr> {
  static bool IsNull(const ::autofill::mojom::FrameTokenWithPredecessorPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FrameTokenWithPredecessorPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FrameTokenWithPredecessor::token)& token(
      const ::autofill::mojom::FrameTokenWithPredecessorPtr& input) {
    return input->token;
  }

  static decltype(::autofill::mojom::FrameTokenWithPredecessor::predecessor) predecessor(
      const ::autofill::mojom::FrameTokenWithPredecessorPtr& input) {
    return input->predecessor;
  }

  static bool Read(::autofill::mojom::FrameTokenWithPredecessor::DataView input, ::autofill::mojom::FrameTokenWithPredecessorPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormRendererId::DataView,
                                         ::autofill::mojom::FormRendererIdPtr> {
  static bool IsNull(const ::autofill::mojom::FormRendererIdPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormRendererIdPtr* output) { output->reset(); }

  static decltype(::autofill::mojom::FormRendererId::id) id(
      const ::autofill::mojom::FormRendererIdPtr& input) {
    return input->id;
  }

  static bool Read(::autofill::mojom::FormRendererId::DataView input, ::autofill::mojom::FormRendererIdPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FieldRendererId::DataView,
                                         ::autofill::mojom::FieldRendererIdPtr> {
  static bool IsNull(const ::autofill::mojom::FieldRendererIdPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FieldRendererIdPtr* output) { output->reset(); }

  static decltype(::autofill::mojom::FieldRendererId::id) id(
      const ::autofill::mojom::FieldRendererIdPtr& input) {
    return input->id;
  }

  static bool Read(::autofill::mojom::FieldRendererId::DataView input, ::autofill::mojom::FieldRendererIdPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::SelectOption::DataView,
                                         ::autofill::mojom::SelectOptionPtr> {
  static bool IsNull(const ::autofill::mojom::SelectOptionPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::SelectOptionPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::SelectOption::value)& value(
      const ::autofill::mojom::SelectOptionPtr& input) {
    return input->value;
  }

  static const decltype(::autofill::mojom::SelectOption::text)& text(
      const ::autofill::mojom::SelectOptionPtr& input) {
    return input->text;
  }

  static bool Read(::autofill::mojom::SelectOption::DataView input, ::autofill::mojom::SelectOptionPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::SectionAutocomplete::DataView,
                                         ::autofill::mojom::SectionAutocompletePtr> {
  static bool IsNull(const ::autofill::mojom::SectionAutocompletePtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::SectionAutocompletePtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::SectionAutocomplete::section)& section(
      const ::autofill::mojom::SectionAutocompletePtr& input) {
    return input->section;
  }

  static decltype(::autofill::mojom::SectionAutocomplete::html_field_mode) html_field_mode(
      const ::autofill::mojom::SectionAutocompletePtr& input) {
    return input->html_field_mode;
  }

  static bool Read(::autofill::mojom::SectionAutocomplete::DataView input, ::autofill::mojom::SectionAutocompletePtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::SectionFieldIdentifier::DataView,
                                         ::autofill::mojom::SectionFieldIdentifierPtr> {
  static bool IsNull(const ::autofill::mojom::SectionFieldIdentifierPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::SectionFieldIdentifierPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::SectionFieldIdentifier::field_name)& field_name(
      const ::autofill::mojom::SectionFieldIdentifierPtr& input) {
    return input->field_name;
  }

  static decltype(::autofill::mojom::SectionFieldIdentifier::local_frame_id) local_frame_id(
      const ::autofill::mojom::SectionFieldIdentifierPtr& input) {
    return input->local_frame_id;
  }

  static const decltype(::autofill::mojom::SectionFieldIdentifier::field_renderer_id)& field_renderer_id(
      const ::autofill::mojom::SectionFieldIdentifierPtr& input) {
    return input->field_renderer_id;
  }

  static bool Read(::autofill::mojom::SectionFieldIdentifier::DataView input, ::autofill::mojom::SectionFieldIdentifierPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::Section::DataView,
                                         ::autofill::mojom::SectionPtr> {
  static bool IsNull(const ::autofill::mojom::SectionPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::SectionPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::Section::value)& value(
      const ::autofill::mojom::SectionPtr& input) {
    return input->value;
  }

  static bool Read(::autofill::mojom::Section::DataView input, ::autofill::mojom::SectionPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::AutocompleteParsingResult::DataView,
                                         ::autofill::mojom::AutocompleteParsingResultPtr> {
  static bool IsNull(const ::autofill::mojom::AutocompleteParsingResultPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::AutocompleteParsingResultPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::AutocompleteParsingResult::section)& section(
      const ::autofill::mojom::AutocompleteParsingResultPtr& input) {
    return input->section;
  }

  static decltype(::autofill::mojom::AutocompleteParsingResult::mode) mode(
      const ::autofill::mojom::AutocompleteParsingResultPtr& input) {
    return input->mode;
  }

  static decltype(::autofill::mojom::AutocompleteParsingResult::field_type) field_type(
      const ::autofill::mojom::AutocompleteParsingResultPtr& input) {
    return input->field_type;
  }

  static decltype(::autofill::mojom::AutocompleteParsingResult::webauthn) webauthn(
      const ::autofill::mojom::AutocompleteParsingResultPtr& input) {
    return input->webauthn;
  }

  static bool Read(::autofill::mojom::AutocompleteParsingResult::DataView input, ::autofill::mojom::AutocompleteParsingResultPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormFieldData::DataView,
                                         ::autofill::mojom::FormFieldDataPtr> {
  static bool IsNull(const ::autofill::mojom::FormFieldDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormFieldDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FormFieldData::label)& label(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->label;
  }

  static const decltype(::autofill::mojom::FormFieldData::name)& name(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->name;
  }

  static const decltype(::autofill::mojom::FormFieldData::id_attribute)& id_attribute(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->id_attribute;
  }

  static const decltype(::autofill::mojom::FormFieldData::name_attribute)& name_attribute(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->name_attribute;
  }

  static const decltype(::autofill::mojom::FormFieldData::value)& value(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->value;
  }

  static const decltype(::autofill::mojom::FormFieldData::selected_text)& selected_text(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->selected_text;
  }

  static decltype(::autofill::mojom::FormFieldData::form_control_type) form_control_type(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->form_control_type;
  }

  static const decltype(::autofill::mojom::FormFieldData::autocomplete_attribute)& autocomplete_attribute(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->autocomplete_attribute;
  }

  static const decltype(::autofill::mojom::FormFieldData::parsed_autocomplete)& parsed_autocomplete(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->parsed_autocomplete;
  }

  static const decltype(::autofill::mojom::FormFieldData::placeholder)& placeholder(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->placeholder;
  }

  static const decltype(::autofill::mojom::FormFieldData::css_classes)& css_classes(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->css_classes;
  }

  static const decltype(::autofill::mojom::FormFieldData::aria_label)& aria_label(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->aria_label;
  }

  static const decltype(::autofill::mojom::FormFieldData::aria_description)& aria_description(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->aria_description;
  }

  static const decltype(::autofill::mojom::FormFieldData::renderer_id)& renderer_id(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->renderer_id;
  }

  static const decltype(::autofill::mojom::FormFieldData::host_form_id)& host_form_id(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->host_form_id;
  }

  static decltype(::autofill::mojom::FormFieldData::properties_mask) properties_mask(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->properties_mask;
  }

  static decltype(::autofill::mojom::FormFieldData::form_control_ax_id) form_control_ax_id(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->form_control_ax_id;
  }

  static decltype(::autofill::mojom::FormFieldData::max_length) max_length(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->max_length;
  }

  static decltype(::autofill::mojom::FormFieldData::is_user_edited) is_user_edited(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_user_edited;
  }

  static decltype(::autofill::mojom::FormFieldData::is_autofilled) is_autofilled(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_autofilled;
  }

  static const decltype(::autofill::mojom::FormFieldData::section)& section(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->section;
  }

  static decltype(::autofill::mojom::FormFieldData::check_status) check_status(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->check_status;
  }

  static decltype(::autofill::mojom::FormFieldData::is_focusable) is_focusable(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_focusable;
  }

  static decltype(::autofill::mojom::FormFieldData::is_visible) is_visible(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_visible;
  }

  static decltype(::autofill::mojom::FormFieldData::should_autocomplete) should_autocomplete(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->should_autocomplete;
  }

  static decltype(::autofill::mojom::FormFieldData::role) role(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->role;
  }

  static decltype(::autofill::mojom::FormFieldData::text_direction) text_direction(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->text_direction;
  }

  static decltype(::autofill::mojom::FormFieldData::is_enabled) is_enabled(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_enabled;
  }

  static decltype(::autofill::mojom::FormFieldData::is_readonly) is_readonly(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->is_readonly;
  }

  static const decltype(::autofill::mojom::FormFieldData::user_input)& user_input(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->user_input;
  }

  static decltype(::autofill::mojom::FormFieldData::allows_writing_suggestions) allows_writing_suggestions(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->allows_writing_suggestions;
  }

  static const decltype(::autofill::mojom::FormFieldData::options)& options(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->options;
  }

  static decltype(::autofill::mojom::FormFieldData::label_source) label_source(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->label_source;
  }

  static const decltype(::autofill::mojom::FormFieldData::bounds)& bounds(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->bounds;
  }

  static const decltype(::autofill::mojom::FormFieldData::datalist_options)& datalist_options(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->datalist_options;
  }

  static decltype(::autofill::mojom::FormFieldData::force_override) force_override(
      const ::autofill::mojom::FormFieldDataPtr& input) {
    return input->force_override;
  }

  static bool Read(::autofill::mojom::FormFieldData::DataView input, ::autofill::mojom::FormFieldDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormFieldData_FillData::DataView,
                                         ::autofill::mojom::FormFieldData_FillDataPtr> {
  static bool IsNull(const ::autofill::mojom::FormFieldData_FillDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormFieldData_FillDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FormFieldData_FillData::value)& value(
      const ::autofill::mojom::FormFieldData_FillDataPtr& input) {
    return input->value;
  }

  static const decltype(::autofill::mojom::FormFieldData_FillData::renderer_id)& renderer_id(
      const ::autofill::mojom::FormFieldData_FillDataPtr& input) {
    return input->renderer_id;
  }

  static const decltype(::autofill::mojom::FormFieldData_FillData::host_form_id)& host_form_id(
      const ::autofill::mojom::FormFieldData_FillDataPtr& input) {
    return input->host_form_id;
  }

  static decltype(::autofill::mojom::FormFieldData_FillData::is_autofilled) is_autofilled(
      const ::autofill::mojom::FormFieldData_FillDataPtr& input) {
    return input->is_autofilled;
  }

  static decltype(::autofill::mojom::FormFieldData_FillData::force_override) force_override(
      const ::autofill::mojom::FormFieldData_FillDataPtr& input) {
    return input->force_override;
  }

  static bool Read(::autofill::mojom::FormFieldData_FillData::DataView input, ::autofill::mojom::FormFieldData_FillDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::ButtonTitleInfo::DataView,
                                         ::autofill::mojom::ButtonTitleInfoPtr> {
  static bool IsNull(const ::autofill::mojom::ButtonTitleInfoPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::ButtonTitleInfoPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::ButtonTitleInfo::title)& title(
      const ::autofill::mojom::ButtonTitleInfoPtr& input) {
    return input->title;
  }

  static decltype(::autofill::mojom::ButtonTitleInfo::type) type(
      const ::autofill::mojom::ButtonTitleInfoPtr& input) {
    return input->type;
  }

  static bool Read(::autofill::mojom::ButtonTitleInfo::DataView input, ::autofill::mojom::ButtonTitleInfoPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormData::DataView,
                                         ::autofill::mojom::FormDataPtr> {
  static bool IsNull(const ::autofill::mojom::FormDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FormData::id_attribute)& id_attribute(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->id_attribute;
  }

  static const decltype(::autofill::mojom::FormData::name_attribute)& name_attribute(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->name_attribute;
  }

  static const decltype(::autofill::mojom::FormData::name)& name(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->name;
  }

  static const decltype(::autofill::mojom::FormData::button_titles)& button_titles(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->button_titles;
  }

  static const decltype(::autofill::mojom::FormData::action)& action(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->action;
  }

  static decltype(::autofill::mojom::FormData::is_action_empty) is_action_empty(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->is_action_empty;
  }

  static const decltype(::autofill::mojom::FormData::renderer_id)& renderer_id(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->renderer_id;
  }

  static const decltype(::autofill::mojom::FormData::child_frames)& child_frames(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->child_frames;
  }

  static decltype(::autofill::mojom::FormData::submission_event) submission_event(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->submission_event;
  }

  static const decltype(::autofill::mojom::FormData::fields)& fields(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->fields;
  }

  static const decltype(::autofill::mojom::FormData::username_predictions)& username_predictions(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->username_predictions;
  }

  static decltype(::autofill::mojom::FormData::is_gaia_with_skip_save_password_form) is_gaia_with_skip_save_password_form(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->is_gaia_with_skip_save_password_form;
  }

  static decltype(::autofill::mojom::FormData::likely_contains_captcha) likely_contains_captcha(
      const ::autofill::mojom::FormDataPtr& input) {
    return input->likely_contains_captcha;
  }

  static bool Read(::autofill::mojom::FormData::DataView input, ::autofill::mojom::FormDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormFieldDataPredictions::DataView,
                                         ::autofill::mojom::FormFieldDataPredictionsPtr> {
  static bool IsNull(const ::autofill::mojom::FormFieldDataPredictionsPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormFieldDataPredictionsPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::host_form_signature)& host_form_signature(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->host_form_signature;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::signature)& signature(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->signature;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::heuristic_type)& heuristic_type(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->heuristic_type;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::server_type)& server_type(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->server_type;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::html_type)& html_type(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->html_type;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::overall_type)& overall_type(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->overall_type;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::parseable_name)& parseable_name(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->parseable_name;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::parseable_label)& parseable_label(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->parseable_label;
  }

  static const decltype(::autofill::mojom::FormFieldDataPredictions::section)& section(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->section;
  }

  static decltype(::autofill::mojom::FormFieldDataPredictions::rank) rank(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->rank;
  }

  static decltype(::autofill::mojom::FormFieldDataPredictions::rank_in_signature_group) rank_in_signature_group(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->rank_in_signature_group;
  }

  static decltype(::autofill::mojom::FormFieldDataPredictions::rank_in_host_form) rank_in_host_form(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->rank_in_host_form;
  }

  static decltype(::autofill::mojom::FormFieldDataPredictions::rank_in_host_form_signature_group) rank_in_host_form_signature_group(
      const ::autofill::mojom::FormFieldDataPredictionsPtr& input) {
    return input->rank_in_host_form_signature_group;
  }

  static bool Read(::autofill::mojom::FormFieldDataPredictions::DataView input, ::autofill::mojom::FormFieldDataPredictionsPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::FormDataPredictions::DataView,
                                         ::autofill::mojom::FormDataPredictionsPtr> {
  static bool IsNull(const ::autofill::mojom::FormDataPredictionsPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::FormDataPredictionsPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::FormDataPredictions::data)& data(
      const ::autofill::mojom::FormDataPredictionsPtr& input) {
    return input->data;
  }

  static const decltype(::autofill::mojom::FormDataPredictions::signature)& signature(
      const ::autofill::mojom::FormDataPredictionsPtr& input) {
    return input->signature;
  }

  static const decltype(::autofill::mojom::FormDataPredictions::alternative_signature)& alternative_signature(
      const ::autofill::mojom::FormDataPredictionsPtr& input) {
    return input->alternative_signature;
  }

  static const decltype(::autofill::mojom::FormDataPredictions::fields)& fields(
      const ::autofill::mojom::FormDataPredictionsPtr& input) {
    return input->fields;
  }

  static bool Read(::autofill::mojom::FormDataPredictions::DataView input, ::autofill::mojom::FormDataPredictionsPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::PasswordAndMetadata::DataView,
                                         ::autofill::mojom::PasswordAndMetadataPtr> {
  static bool IsNull(const ::autofill::mojom::PasswordAndMetadataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::PasswordAndMetadataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::PasswordAndMetadata::username_value)& username_value(
      const ::autofill::mojom::PasswordAndMetadataPtr& input) {
    return input->username_value;
  }

  static const decltype(::autofill::mojom::PasswordAndMetadata::password_value)& password_value(
      const ::autofill::mojom::PasswordAndMetadataPtr& input) {
    return input->password_value;
  }

  static const decltype(::autofill::mojom::PasswordAndMetadata::realm)& realm(
      const ::autofill::mojom::PasswordAndMetadataPtr& input) {
    return input->realm;
  }

  static decltype(::autofill::mojom::PasswordAndMetadata::uses_account_store) uses_account_store(
      const ::autofill::mojom::PasswordAndMetadataPtr& input) {
    return input->uses_account_store;
  }

  static decltype(::autofill::mojom::PasswordAndMetadata::is_grouped_affiliation) is_grouped_affiliation(
      const ::autofill::mojom::PasswordAndMetadataPtr& input) {
    return input->is_grouped_affiliation;
  }

  static bool Read(::autofill::mojom::PasswordAndMetadata::DataView input, ::autofill::mojom::PasswordAndMetadataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::PasswordFormFillData::DataView,
                                         ::autofill::mojom::PasswordFormFillDataPtr> {
  static bool IsNull(const ::autofill::mojom::PasswordFormFillDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::PasswordFormFillDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::PasswordFormFillData::form_renderer_id)& form_renderer_id(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->form_renderer_id;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::url)& url(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->url;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::username_element_renderer_id)& username_element_renderer_id(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->username_element_renderer_id;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::password_element_renderer_id)& password_element_renderer_id(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->password_element_renderer_id;
  }

  static decltype(::autofill::mojom::PasswordFormFillData::username_may_use_prefilled_placeholder) username_may_use_prefilled_placeholder(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->username_may_use_prefilled_placeholder;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::preferred_login)& preferred_login(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->preferred_login;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::additional_logins)& additional_logins(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->additional_logins;
  }

  static decltype(::autofill::mojom::PasswordFormFillData::wait_for_username) wait_for_username(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->wait_for_username;
  }

  static const decltype(::autofill::mojom::PasswordFormFillData::suggestion_banned_fields)& suggestion_banned_fields(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->suggestion_banned_fields;
  }

  static decltype(::autofill::mojom::PasswordFormFillData::notify_browser_of_successful_filling) notify_browser_of_successful_filling(
      const ::autofill::mojom::PasswordFormFillDataPtr& input) {
    return input->notify_browser_of_successful_filling;
  }

  static bool Read(::autofill::mojom::PasswordFormFillData::DataView input, ::autofill::mojom::PasswordFormFillDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::PasswordFormGenerationData::DataView,
                                         ::autofill::mojom::PasswordFormGenerationDataPtr> {
  static bool IsNull(const ::autofill::mojom::PasswordFormGenerationDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::PasswordFormGenerationDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::PasswordFormGenerationData::new_password_renderer_id)& new_password_renderer_id(
      const ::autofill::mojom::PasswordFormGenerationDataPtr& input) {
    return input->new_password_renderer_id;
  }

  static const decltype(::autofill::mojom::PasswordFormGenerationData::confirmation_password_renderer_id)& confirmation_password_renderer_id(
      const ::autofill::mojom::PasswordFormGenerationDataPtr& input) {
    return input->confirmation_password_renderer_id;
  }

  static bool Read(::autofill::mojom::PasswordFormGenerationData::DataView input, ::autofill::mojom::PasswordFormGenerationDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::PasswordGenerationUIData::DataView,
                                         ::autofill::mojom::PasswordGenerationUIDataPtr> {
  static bool IsNull(const ::autofill::mojom::PasswordGenerationUIDataPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::PasswordGenerationUIDataPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::PasswordGenerationUIData::bounds)& bounds(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->bounds;
  }

  static decltype(::autofill::mojom::PasswordGenerationUIData::max_length) max_length(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->max_length;
  }

  static const decltype(::autofill::mojom::PasswordGenerationUIData::generation_element)& generation_element(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->generation_element;
  }

  static const decltype(::autofill::mojom::PasswordGenerationUIData::generation_element_id)& generation_element_id(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->generation_element_id;
  }

  static decltype(::autofill::mojom::PasswordGenerationUIData::is_generation_element_password_type) is_generation_element_password_type(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->is_generation_element_password_type;
  }

  static decltype(::autofill::mojom::PasswordGenerationUIData::text_direction) text_direction(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->text_direction;
  }

  static const decltype(::autofill::mojom::PasswordGenerationUIData::form_data)& form_data(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->form_data;
  }

  static decltype(::autofill::mojom::PasswordGenerationUIData::generation_rejected) generation_rejected(
      const ::autofill::mojom::PasswordGenerationUIDataPtr& input) {
    return input->generation_rejected;
  }

  static bool Read(::autofill::mojom::PasswordGenerationUIData::DataView input, ::autofill::mojom::PasswordGenerationUIDataPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::PasswordSuggestionRequest::DataView,
                                         ::autofill::mojom::PasswordSuggestionRequestPtr> {
  static bool IsNull(const ::autofill::mojom::PasswordSuggestionRequestPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::PasswordSuggestionRequestPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::PasswordSuggestionRequest::element_id)& element_id(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->element_id;
  }

  static const decltype(::autofill::mojom::PasswordSuggestionRequest::form_data)& form_data(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->form_data;
  }

  static decltype(::autofill::mojom::PasswordSuggestionRequest::trigger_source) trigger_source(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->trigger_source;
  }

  static decltype(::autofill::mojom::PasswordSuggestionRequest::username_field_index) username_field_index(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->username_field_index;
  }

  static decltype(::autofill::mojom::PasswordSuggestionRequest::password_field_index) password_field_index(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->password_field_index;
  }

  static decltype(::autofill::mojom::PasswordSuggestionRequest::text_direction) text_direction(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->text_direction;
  }

  static const decltype(::autofill::mojom::PasswordSuggestionRequest::typed_username)& typed_username(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->typed_username;
  }

  static decltype(::autofill::mojom::PasswordSuggestionRequest::show_webauthn_credentials) show_webauthn_credentials(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->show_webauthn_credentials;
  }

  static const decltype(::autofill::mojom::PasswordSuggestionRequest::bounds)& bounds(
      const ::autofill::mojom::PasswordSuggestionRequestPtr& input) {
    return input->bounds;
  }

  static bool Read(::autofill::mojom::PasswordSuggestionRequest::DataView input, ::autofill::mojom::PasswordSuggestionRequestPtr* output);
};


template <>
struct  StructTraits<::autofill::mojom::ParsingResult::DataView,
                                         ::autofill::mojom::ParsingResultPtr> {
  static bool IsNull(const ::autofill::mojom::ParsingResultPtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::ParsingResultPtr* output) { output->reset(); }

  static const decltype(::autofill::mojom::ParsingResult::username_renderer_id)& username_renderer_id(
      const ::autofill::mojom::ParsingResultPtr& input) {
    return input->username_renderer_id;
  }

  static const decltype(::autofill::mojom::ParsingResult::password_renderer_id)& password_renderer_id(
      const ::autofill::mojom::ParsingResultPtr& input) {
    return input->password_renderer_id;
  }

  static const decltype(::autofill::mojom::ParsingResult::new_password_renderer_id)& new_password_renderer_id(
      const ::autofill::mojom::ParsingResultPtr& input) {
    return input->new_password_renderer_id;
  }

  static const decltype(::autofill::mojom::ParsingResult::confirm_password_renderer_id)& confirm_password_renderer_id(
      const ::autofill::mojom::ParsingResultPtr& input) {
    return input->confirm_password_renderer_id;
  }

  static bool Read(::autofill::mojom::ParsingResult::DataView input, ::autofill::mojom::ParsingResultPtr* output);
};


template <>
struct  UnionTraits<::autofill::mojom::SectionValue::DataView,
                                        ::autofill::mojom::SectionValuePtr> {
  static bool IsNull(const ::autofill::mojom::SectionValuePtr& input) { return !input; }
  static void SetToNull(::autofill::mojom::SectionValuePtr* output) { output->reset(); }

  static ::autofill::mojom::SectionValue::Tag GetTag(const ::autofill::mojom::SectionValuePtr& input) {
    return input->which();
  }

  static  bool default_section(const ::autofill::mojom::SectionValuePtr& input) {
    return input->get_default_section();
  }

  static const ::autofill::mojom::SectionAutocompletePtr& autocomplete(const ::autofill::mojom::SectionValuePtr& input) {
    return input->get_autocomplete();
  }

  static const ::autofill::mojom::SectionFieldIdentifierPtr& field_identifier(const ::autofill::mojom::SectionValuePtr& input) {
    return input->get_field_identifier();
  }

  static bool Read(::autofill::mojom::SectionValue::DataView input, ::autofill::mojom::SectionValuePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_H_