#ifndef HEX_EMITTER_H
#define HEX_EMITTER_H

#include "insn.h"

void emit_J4_hintjumpr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV)
/* {fHINTJR(RsV);} */
;
void emit_J2_loop0r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 0); } */
;
void emit_J2_loop1r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA1 = fREAD_PC()+riV; (LC1 = RsV); } */
;
void emit_J2_loop0i(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 0); } */
;
void emit_J2_loop1i(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA1 = fREAD_PC()+riV; (LC1 = UiV); } */
;
void emit_J2_ploop1sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 1); P3 = 0;; } */
;
void emit_J2_ploop1si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 1); P3 = 0;; } */
;
void emit_J2_ploop2sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 2); P3 = 0;; } */
;
void emit_J2_ploop2si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 2); P3 = 0;; } */
;
void emit_J2_ploop3sr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int riV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = RsV); (USR.LPCFG = 3); P3 = 0;; } */
;
void emit_J2_ploop3si(DisasContext *ctx, Insn *insn, Packet *pkt, int riV, int UiV)
/* { fIMMEXT(riV); (riV = riV & ~3); SA0 = fREAD_PC()+riV; (LC0 = UiV); (USR.LPCFG = 3); P3 = 0;; } */
;
void emit_L2_loadrub_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,1,u,EA,RdV); } */
;
void emit_L4_loadrub_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L4_loadrub_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,1,u,EA,RdV); ReV=UiV; } */
;
void emit_L2_loadrub_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_loadrub_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_loadrub_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_loadrub_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_loadrub_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_loadrb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,1,s,EA,RdV); } */
;
void emit_L4_loadrb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L4_loadrb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,1,s,EA,RdV); ReV=UiV; } */
;
void emit_L2_loadrb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_loadrb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_loadrb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_loadrb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_loadrb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_loadruh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,2,u,EA,RdV); } */
;
void emit_L4_loadruh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L4_loadruh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,2,u,EA,RdV); ReV=UiV; } */
;
void emit_L2_loadruh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_loadruh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_loadruh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_loadruh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_loadruh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_loadrh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,2,s,EA,RdV); } */
;
void emit_L4_loadrh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L4_loadrh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,2,s,EA,RdV); ReV=UiV; } */
;
void emit_L2_loadrh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_loadrh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_loadrh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_loadrh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_loadrh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_loadri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,4,u,EA,RdV); } */
;
void emit_L4_loadri_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L4_loadri_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,4,u,EA,RdV); ReV=UiV; } */
;
void emit_L2_loadri_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_loadri_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_loadri_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_loadri_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_loadri_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_loadrd_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fLOAD(1,8,u,EA,RddV); } */
;
void emit_L4_loadrd_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L4_loadrd_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fLOAD(1,8,u,EA,RddV); ReV=UiV; } */
;
void emit_L2_loadrd_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_loadrd_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_loadrd_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_loadrd_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_loadrd_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_loadbzw2_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; } */
;
void emit_L4_loadbzw2_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L4_loadbzw2_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; } */
;
void emit_L2_loadbzw2_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw2_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw2_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw2_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw2_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw4_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; } */
;
void emit_L4_loadbzw4_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L4_loadbzw4_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } }; ReV=UiV; } */
;
void emit_L2_loadbzw4_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw4_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw4_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw4_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbzw4_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw2_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; } */
;
void emit_L4_loadbsw2_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L4_loadbsw2_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } }; ReV=UiV; } */
;
void emit_L2_loadbsw2_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw2_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw2_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw2_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw2_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); {size2u_t tmpV; int i; fLOAD(1,2,u,EA,tmpV); for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw4_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; } */
;
void emit_L4_loadbsw4_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L4_loadbsw4_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } }; ReV=UiV; } */
;
void emit_L2_loadbsw4_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw4_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw4_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw4_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadbsw4_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); {size4u_t tmpV; int i; fLOAD(1,4,u,EA,tmpV); for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,tmpV)); } };} */
;
void emit_L2_loadalignh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; } */
;
void emit_L4_loadalignh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L4_loadalignh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); }; ReV=UiV; } */
;
void emit_L2_loadalignh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L2_loadalignh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L2_loadalignh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L2_loadalignh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L2_loadalignh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); { size8u_t tmpV; fLOAD(1,2,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>16)|(tmpV<<48); };} */
;
void emit_L2_loadalignb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RsV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; } */
;
void emit_L4_loadalignb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RtV << uiV)); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_L4_loadalignb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 ReV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); }; ReV=UiV; } */
;
void emit_L2_loadalignb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_L2_loadalignb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_L2_loadalignb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_L2_loadalignb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_L2_loadalignb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RyyV, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); { size8u_t tmpV; fLOAD(1,1,u,EA,tmpV); RyyV = (((size8u_t)RyyV)>>8)|(tmpV<<56); };} */
;
void emit_S2_storerb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
;
void emit_S2_storerb_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
;
void emit_S4_storerb_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); ReV=UiV; } */
;
void emit_S2_storerb_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
;
void emit_S4_storerb_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
;
void emit_S2_storerb_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
;
void emit_S2_storerb_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
;
void emit_S2_storerb_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
;
void emit_S2_storerh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
;
void emit_S2_storerh_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
;
void emit_S4_storerh_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(0,RtV)); ReV=UiV; } */
;
void emit_S2_storerh_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
;
void emit_S4_storerh_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
;
void emit_S2_storerh_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
;
void emit_S2_storerh_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
;
void emit_S2_storerh_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
;
void emit_S2_storerf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
;
void emit_S2_storerf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
;
void emit_S4_storerf_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(1,RtV)); ReV=UiV; } */
;
void emit_S2_storerf_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
;
void emit_S4_storerf_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
;
void emit_S2_storerf_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
;
void emit_S2_storerf_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
;
void emit_S2_storerf_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
;
void emit_S2_storeri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,4,EA,RtV); } */
;
void emit_S2_storeri_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,4,EA,RtV); } */
;
void emit_S4_storeri_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i32 RtV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,4,EA,RtV); ReV=UiV; } */
;
void emit_S2_storeri_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,4,EA,RtV); } */
;
void emit_S4_storeri_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i32 RtV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,4,EA,RtV);} */
;
void emit_S2_storeri_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,4,EA,RtV); } */
;
void emit_S2_storeri_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,RtV);} */
;
void emit_S2_storeri_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i32 RtV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,RtV);} */
;
void emit_S2_storerd_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,8,EA,RttV); } */
;
void emit_S2_storerd_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,8,EA,RttV); } */
;
void emit_S4_storerd_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv_i64 RttV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,8,EA,RttV); ReV=UiV; } */
;
void emit_S2_storerd_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,8,EA,RttV); } */
;
void emit_S4_storerd_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv_i64 RttV, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,8,EA,RttV);} */
;
void emit_S2_storerd_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,8,EA,RttV); } */
;
void emit_S2_storerd_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,8,EA,RttV);} */
;
void emit_S2_storerd_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv_i64 RttV)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<3,MuV); fSTORE(1,8,EA,RttV);} */
;
void emit_S2_storerinew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
;
void emit_S2_storerinew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
;
void emit_S4_storerinew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); ReV=UiV; } */
;
void emit_S2_storerinew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
;
void emit_S4_storerinew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
;
void emit_S2_storerinew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
;
void emit_S2_storerinew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
;
void emit_S2_storerinew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<2,MuV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
;
void emit_S2_storerbnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
;
void emit_S2_storerbnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
;
void emit_S4_storerbnew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); ReV=UiV; } */
;
void emit_S2_storerbnew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
;
void emit_S4_storerbnew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_storerbnew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
;
void emit_S2_storerbnew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_storerbnew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<0,MuV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_storerhnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv NtN, int siV)
/* size4u_t EA; {fIMMEXT(siV); (EA = RsV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
;
void emit_S2_storerhnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
;
void emit_S4_storerhnew_ap(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 ReV, TCGv NtN, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); ReV=UiV; } */
;
void emit_S2_storerhnew_pr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
;
void emit_S4_storerhnew_ur(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RuV, TCGv NtN, int uiV, int UiV)
/* size4u_t EA; {fMUST_IMMEXT(UiV); (EA = UiV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_storerhnew_pbr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = fbrev(RxV)); (RxV = RxV + MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
;
void emit_S2_storerhnew_pci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); fPM_CIRI(RxV,siV,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_storerhnew_pcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 MuV, TCGv CS, TCGv NtN)
/* size4u_t EA; {(EA = RxV); fPM_CIRR(RxV,fREAD_IREG(MuV)<<1,MuV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_allocframe(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV)
/* size4u_t EA; { (EA = RxV + -8); fSTORE(1,8,EA,fFRAME_SCRAMBLE((fCAST8_8u(fREAD_LR()) << 32) | fCAST4_4u(fREAD_FP()))); (FP = EA); fFRAMECHECK(EA-uiV,EA); RxV = EA-uiV; } */
;
void emit_L2_loadw_aq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* size4u_t EA; { (EA = RsV); fLOAD(1,4,u,EA,RdV); } */
;
void emit_L4_loadd_aq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* size4u_t EA; { (EA = RsV); fLOAD(1,8,u,EA,RddV); } */
;
void emit_S2_storew_rl_at_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,4,EA,RtV); } */
;
void emit_S4_stored_rl_at_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,8,EA,RttV); } */
;
void emit_S2_storew_rl_st_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,4,EA,RtV); } */
;
void emit_S4_stored_rl_st_vi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i64 RttV)
/* size4u_t EA; { (EA = RsV); fSTORE(1,8,EA,RttV); } */
;
void emit_L2_deallocframe(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* size4u_t EA; { size8u_t tmp; (EA = RsV); fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); (SP = EA+8); } */
;
void emit_L4_loadrub_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,1,u,EA,RdV);} */
;
void emit_L2_ploadrubt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrubfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,1,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrubfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,1,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_loadrb_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,1,s,EA,RdV);} */
;
void emit_L2_ploadrbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrbfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,1,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrbfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,1,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_loadruh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,2,u,EA,RdV);} */
;
void emit_L2_ploadruht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadruhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,2,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadruhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,2,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_loadrh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,2,s,EA,RdV);} */
;
void emit_L2_ploadrht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,2,s,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,2,s,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_loadri_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,4,u,EA,RdV);} */
;
void emit_L2_ploadrit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrit_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrif_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrit_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrif_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadritnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrifnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadritnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrifnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrit_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,4,u,EA,RdV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrif_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadritnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrifnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,4,u,EA,RdV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_loadrd_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); fLOAD(1,8,u,EA,RddV);} */
;
void emit_L2_ploadrdt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if((fGETBIT(0, PtV))){fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fGETBIT(0, PtV))){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fGETBIT(0, ~PtV)){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fLSBNEW(PtN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PtN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if((fGETBIT(0, PvV))){ fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if(fGETBIT(0, ~PvV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if (fLSBNEW(PvN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RtV << uiV)); if ((fLSBNEW(~PvN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if(fLSBNEW(PtN)){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L2_ploadrdfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, TCGv_i32 RxV, int siV)
/* size4u_t EA; {(EA = RxV); if((fLSBNEW(~PtN))){ (RxV = RxV + siV); fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if((fGETBIT(0, PtV))){ fLOAD(1,8,u,EA,RddV);} else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtV, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if(fGETBIT(0, ~PtV)){ fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if (fLSBNEW(PtN)) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_L4_ploadrdfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PtN, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV);if ((fLSBNEW(~PtN))) { fLOAD(1,8,u,EA,RddV); } else {LOAD_CANCEL(EA);}} */
;
void emit_S4_storerb_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
;
void emit_S2_pstorerbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerh_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
;
void emit_S2_pstorerht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerht_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerht_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerht_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(1,RtV));} */
;
void emit_S2_pstorerft_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerft_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerff_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerff_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerft_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerff_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerftnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerffnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerftnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerffnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerftnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerffnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(1,RtV));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerft_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerff_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerftnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerffnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(1,RtV)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeri_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,4,EA,RtV);} */
;
void emit_S2_pstorerit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerit_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerif_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerit_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerif_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstoreritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstoreritnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerifnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstoreritnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerifnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i32 RtV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,4,EA,RtV);} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerit_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerif_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstoreritnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerifnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,RtV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerd_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,8,EA,RttV);} */
;
void emit_S2_pstorerdt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerdt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerdf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerdf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerdtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerdfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,8,EA,RttV);} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerdfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,8,EA,RttV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerinew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,4,EA,fNEWREG_ST(NtN));} */
;
void emit_S2_pstorerinewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerinewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerinewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerinewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerinewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerinewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,4,EA,fNEWREG_ST(NtN));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerinewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,4,EA,fNEWREG_ST(NtN)); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerbnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_pstorerbnewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbnewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbnewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbnewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbnewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerbnewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerbnewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storerhnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} */
;
void emit_S2_pstorerhnewt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhnewt_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fGETBIT(0, PvV))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhnewf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhnewf_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fGETBIT(0, ~PvV)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewt_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewf_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewtnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewfnew_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, TCGv_i32 RuV, TCGv NtN, int uiV)
/* size4u_t EA; {(EA = RsV + (RuV << uiV)); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhnewtnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if (fLSBNEW(PvN)){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S2_pstorerhnewfnew_pi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RxV, TCGv NtN, int siV)
/* size4u_t EA; {(EA = RxV); if ((fLSBNEW(~PvN))){ (RxV = RxV + siV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN)));} else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewt_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV); (EA = uiV); if ((fGETBIT(0, PvV))){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewf_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if (fGETBIT(0, ~PvV)){ fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewtnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ( fLSBNEW(PvN)) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_pstorerhnewfnew_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv NtN, int uiV)
/* size4u_t EA; {fMUST_IMMEXT(uiV);(EA = uiV); if ((fLSBNEW(~PvN))) { fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } else {STORE_CANCEL(EA);}} */
;
void emit_L4_add_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp += RtV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_add_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp += RtV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_add_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp += RtV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_sub_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp -= RtV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_sub_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp -= RtV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_sub_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp -= RtV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_and_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp &= RtV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_and_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp &= RtV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_and_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp &= RtV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_or_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp |= RtV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_or_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp |= RtV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_or_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp |= RtV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_iadd_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp += UiV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_iadd_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp += UiV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_iadd_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp += UiV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_isub_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp -= UiV; fSTORE(1,4,EA,tmp); } */
;
void emit_L4_isub_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp -= UiV; fSTORE(1,1,EA,tmp); } */
;
void emit_L4_isub_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp -= UiV; fSTORE(1,2,EA,tmp); } */
;
void emit_L4_iand_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,4,EA,tmp); } */
;
void emit_L4_iand_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,1,EA,tmp); } */
;
void emit_L4_iand_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp &= (~(1<<UiV)); fSTORE(1,2,EA,tmp); } */
;
void emit_L4_ior_memopw_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,4,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,4,EA,tmp); } */
;
void emit_L4_ior_memopb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,1,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,1,EA,tmp); } */
;
void emit_L4_ior_memoph_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int UiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = RsV + uiV); size4s_t tmp; fLOAD(1,2,s,EA,tmp); tmp |= (1<<UiV); fSTORE(1,2,EA,tmp); } */
;
void emit_S4_storeirbt_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirbf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirbtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirbfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirht_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirhf_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirhtnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirhfnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirit_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fGETBIT(0, PvV))){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirif_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvV, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fGETBIT(0, ~PvV)){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeiritnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if (fLSBNEW(PvN)){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirifnew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PvN, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); if ((fLSBNEW(~PvN))){ fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } else {STORE_CANCEL(EA);}} */
;
void emit_S4_storeirb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,1,EA,SiV); } */
;
void emit_S4_storeirh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,2,EA,SiV); } */
;
void emit_S4_storeiri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV, int SiV)
/* size4u_t EA; {(EA = RsV + uiV); fIMMEXT(SiV); fSTORE(1,4,EA,SiV); } */
;
void emit_L2_loadrubgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,1,u,EA,RdV); } */
;
void emit_L2_loadrbgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,1,s,EA,RdV); } */
;
void emit_L2_loadruhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,2,u,EA,RdV); } */
;
void emit_L2_loadrhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,2,s,EA,RdV); } */
;
void emit_L2_loadrigp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,4,u,EA,RdV); } */
;
void emit_L2_loadrdgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fLOAD(1,8,u,EA,RddV); } */
;
void emit_S2_storerbgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,1,EA,fGETBYTE(0,RtV)); } */
;
void emit_S2_storerhgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(0,RtV)); } */
;
void emit_S2_storerfgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(1,RtV)); } */
;
void emit_S2_storerigp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,4,EA,RtV); } */
;
void emit_S2_storerdgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RttV, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,8,EA,RttV); } */
;
void emit_S2_storerinewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,4,EA,fNEWREG_ST(NtN)); } */
;
void emit_S2_storerbnewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,1,EA,fGETBYTE(0,fNEWREG_ST(NtN))); } */
;
void emit_S2_storerhnewgp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv NtN, int uiV)
/* size4u_t EA; {fIMMEXT(uiV); (EA = (Constant_extended ? (0) : GP) + uiV); fSTORE(1,2,EA,fGETHALF(0,fNEWREG_ST(NtN))); } */
;
void emit_C2_cmpeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV==RtV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV>RtV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((fCAST4u(RsV)>fCAST4u(RtV)) ? 0xff : 0x00);} */
;
void emit_C2_cmpeqp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((RssV==RttV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgtp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((RssV>RttV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgtup(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* {PdV=((fCAST8u(RssV)>fCAST8u(RttV)) ? 0xff : 0x00);} */
;
void emit_A4_rcmpeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); RdV=(RsV==siV); } */
;
void emit_A4_rcmpneqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); RdV=(RsV!=siV); } */
;
void emit_A4_rcmpeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(RsV==RtV); } */
;
void emit_A4_rcmpneq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(RsV!=RtV); } */
;
void emit_C2_bitsset(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)==RtV) ? 0xff : 0x00);} */
;
void emit_C2_bitsclr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)==0) ? 0xff : 0x00);} */
;
void emit_C4_nbitsset(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)!=RtV) ? 0xff : 0x00);} */
;
void emit_C4_nbitsclr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=(((RsV&RtV)!=0) ? 0xff : 0x00);} */
;
void emit_C2_cmpeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV==siV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV>siV) ? 0xff : 0x00);} */
;
void emit_C2_cmpgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {fIMMEXT(uiV); PdV=((fCAST4u(RsV)>fCAST4u(uiV)) ? 0xff : 0x00);} */
;
void emit_C2_bitsclri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {PdV=(((RsV&uiV)==0) ? 0xff : 0x00);} */
;
void emit_C4_nbitsclri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {PdV=(((RsV&uiV)!=0) ? 0xff : 0x00);} */
;
void emit_C4_cmpneqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV!=siV) ? 0xff : 0x00);} */
;
void emit_C4_cmpltei(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* {fIMMEXT(siV); PdV=((RsV<=siV) ? 0xff : 0x00);} */
;
void emit_C4_cmplteui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* {fIMMEXT(uiV); PdV=((fCAST4u(RsV)<=fCAST4u(uiV)) ? 0xff : 0x00);} */
;
void emit_C4_cmpneq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV!=RtV) ? 0xff : 0x00);} */
;
void emit_C4_cmplte(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((RsV<=RtV) ? 0xff : 0x00);} */
;
void emit_C4_cmplteu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {PdV=((fCAST4u(RsV)<=fCAST4u(RtV)) ? 0xff : 0x00);} */
;
void emit_C2_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PsV & PtV;} */
;
void emit_C2_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PsV | PtV;} */
;
void emit_C2_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* {PdV=PsV ^ PtV;} */
;
void emit_C2_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PtV & (~PsV);} */
;
void emit_C2_not(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* {PdV=~PsV;} */
;
void emit_C2_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PtV, TCGv PsV)
/* {PdV=PtV | (~PsV);} */
;
void emit_C4_and_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & PtV & PuV; } */
;
void emit_C4_and_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & (PtV | PuV); } */
;
void emit_C4_or_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | (PtV & PuV); } */
;
void emit_C4_or_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | PtV | PuV; } */
;
void emit_C4_and_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & PtV & (~PuV); } */
;
void emit_C4_and_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV & (PtV | (~PuV)); } */
;
void emit_C4_or_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | (PtV & (~PuV)); } */
;
void emit_C4_or_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV, TCGv PuV)
/* { PdV = PsV | PtV | (~PuV); } */
;
void emit_C2_any8(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* { PdV = (PsV ? 0xff : 0x00); } */
;
void emit_C2_all8(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV)
/* { PdV = (PsV == 0xff ? 0xff : 0x00); } */
;
void emit_C2_vitpack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PsV, TCGv PtV)
/* { RdV = (PsV&0x55) | (PtV&0xAA); } */
;
void emit_C2_mux(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = ((fGETBIT(0, PuV)) ? RsV : RtV); } */
;
void emit_C2_cmovenewit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if (fLSBNEW(PuN)) RdV=siV; else CANCEL;} */
;
void emit_C2_cmovenewif(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if ((fLSBNEW(~PuN))) RdV=siV; else CANCEL;} */
;
void emit_C2_cmoveit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if ((fGETBIT(0, PuV))) RdV=siV; else CANCEL;} */
;
void emit_C2_cmoveif(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); if (fGETBIT(0, ~PuV)) RdV=siV; else CANCEL;} */
;
void emit_C2_ccombinewnewt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if (fLSBNEW(PuN)) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
;
void emit_C2_ccombinewnewf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if ((fLSBNEW(~PuN))) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
;
void emit_C2_ccombinewt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if ((fGETBIT(0, PuV))) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
;
void emit_C2_ccombinewf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if (fGETBIT(0, ~PuV)) { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } else {CANCEL;} } */
;
void emit_C2_muxii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, int siV, int SiV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? siV : SiV); } */
;
void emit_C2_muxir(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? RsV : siV); } */
;
void emit_C2_muxri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PuV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV = ((fGETBIT(0, PuV)) ? siV : RsV); } */
;
void emit_C2_vmux(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv PuV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETBIT(i,PuV)?(fGETBYTE(i,RssV)):(fGETBYTE(i,RttV)))); } } */
;
void emit_C2_mask(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv PtV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETBIT(i,PtV)?(0xff):(0x00))); } } */
;
void emit_A2_vcmpbeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) == fGETBYTE(i,RttV))); } } */
;
void emit_A4_vcmpbeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) == uiV)); } } */
;
void emit_A4_vcmpbeq_any(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; PdV = 0; for (i = 0; i < 8; i++) { if (fGETBYTE(i,RssV) == fGETBYTE(i,RttV)) PdV = 0xff; } } */
;
void emit_A6_vcmpbeq_notany(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; PdV = 0; for (i = 0; i < 8; i++) { if (fGETBYTE(i,RssV) == fGETBYTE(i,RttV)) PdV = 0xff; } PdV = ~PdV; } */
;
void emit_A2_vcmpbgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) > fGETUBYTE(i,RttV))); } } */
;
void emit_A4_vcmpbgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETUBYTE(i,RssV) > uiV)); } } */
;
void emit_A4_vcmpbgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) > fGETBYTE(i,RttV))); } } */
;
void emit_A4_vcmpbgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i,PdV,(fGETBYTE(i,RssV) > siV)); } } */
;
void emit_A4_cmpbeq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETBYTE(0,RsV) == fGETBYTE(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmpbeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { PdV=((fGETUBYTE(0,RsV) == uiV) ? 0xff : 0x00); } */
;
void emit_A4_cmpbgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETUBYTE(0,RsV) > fGETUBYTE(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmpbgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); PdV=((fGETUBYTE(0,RsV) > fCAST4u(uiV)) ? 0xff : 0x00); } */
;
void emit_A4_cmpbgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETBYTE(0,RsV) > fGETBYTE(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmpbgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { PdV=((fGETBYTE(0,RsV) > siV) ? 0xff : 0x00); } */
;
void emit_A2_vcmpheq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2,PdV, (fGETHALF(i,RssV) == fGETHALF(i,RttV))); fSETBIT(i*2+1,PdV,(fGETHALF(i,RssV) == fGETHALF(i,RttV))); } } */
;
void emit_A2_vcmphgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETHALF(i,RssV) > fGETHALF(i,RttV))); fSETBIT(i*2+1,PdV, (fGETHALF(i,RssV) > fGETHALF(i,RttV))); } } */
;
void emit_A2_vcmphgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETUHALF(i,RssV) > fGETUHALF(i,RttV))); fSETBIT(i*2+1,PdV, (fGETUHALF(i,RssV) > fGETUHALF(i,RttV))); } } */
;
void emit_A4_vcmpheqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2,PdV, (fGETHALF(i,RssV) == siV)); fSETBIT(i*2+1,PdV,(fGETHALF(i,RssV) == siV)); } } */
;
void emit_A4_vcmphgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETHALF(i,RssV) > siV)); fSETBIT(i*2+1,PdV, (fGETHALF(i,RssV) > siV)); } } */
;
void emit_A4_vcmphgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i = 0; i < 4; i++) { fSETBIT(i*2, PdV, (fGETUHALF(i,RssV) > uiV)); fSETBIT(i*2+1,PdV, (fGETUHALF(i,RssV) > uiV)); } } */
;
void emit_A4_cmpheq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETHALF(0,RsV) == fGETHALF(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmphgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETHALF(0,RsV) > fGETHALF(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmphgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV=((fGETUHALF(0,RsV) > fGETUHALF(0,RtV)) ? 0xff : 0x00); } */
;
void emit_A4_cmpheqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); PdV=((fGETHALF(0,RsV) == siV) ? 0xff : 0x00); } */
;
void emit_A4_cmphgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); PdV=((fGETHALF(0,RsV) > siV) ? 0xff : 0x00); } */
;
void emit_A4_cmphgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); PdV=((fGETUHALF(0,RsV) > fCAST4u(uiV)) ? 0xff : 0x00); } */
;
void emit_A2_vcmpweq(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)==fGETWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)==fGETWORD(1,RttV))); } */
;
void emit_A2_vcmpwgt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)>fGETWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)>fGETWORD(1,RttV))); } */
;
void emit_A2_vcmpwgtu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETBITS(3,0,PdV,(fGETUWORD(0,RssV)>fGETUWORD(0,RttV))); fSETBITS(7,4,PdV,(fGETUWORD(1,RssV)>fGETUWORD(1,RttV))); } */
;
void emit_A4_vcmpweqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)==siV)); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)==siV)); } */
;
void emit_A4_vcmpwgti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int siV)
/* { fSETBITS(3,0,PdV,(fGETWORD(0,RssV)>siV)); fSETBITS(7,4,PdV,(fGETWORD(1,RssV)>siV)); } */
;
void emit_A4_vcmpwgtui(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, int uiV)
/* { fSETBITS(3,0,PdV,(fGETUWORD(0,RssV)>fCAST4u(uiV))); fSETBITS(7,4,PdV,(fGETUWORD(1,RssV)>fCAST4u(uiV))); } */
;
void emit_A4_boundscheck_hi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { size4u_t src; src = fGETUWORD(1,RssV); PdV = (((fCAST4u(src) >= fGETUWORD(0,RttV)) && (fCAST4u(src) < fGETUWORD(1,RttV))) ? 0xff : 0x00); } */
;
void emit_A4_boundscheck_lo(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { size4u_t src; src = fGETUWORD(0,RssV); PdV = (((fCAST4u(src) >= fGETUWORD(0,RttV)) && (fCAST4u(src) < fGETUWORD(1,RttV))) ? 0xff : 0x00); } */
;
void emit_C2_tfrpr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv PsV)
/* { RdV = fZXTN(8,32,PsV); } */
;
void emit_C2_tfrrp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV)
/* { PdV = fGETUBYTE(0,RsV); } */
;
void emit_C4_fastcorner9(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* { size4u_t tmp = 0; size4u_t i; fSETHALF(0,tmp,(PsV<<8)|PtV); fSETHALF(1,tmp,(PsV<<8)|PtV); for (i = 1; i < 9; i++) { tmp &= tmp >> 1; } PdV = ((tmp != 0) ? 0xff : 0x00); } */
;
void emit_C4_fastcorner9_not(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv PsV, TCGv PtV)
/* { size4u_t tmp = 0; size4u_t i; fSETHALF(0,tmp,(PsV<<8)|PtV); fSETHALF(1,tmp,(PsV<<8)|PtV); for (i = 1; i < 9; i++) { tmp &= tmp >> 1; } PdV = ((tmp == 0) ? 0xff : 0x00); } */
;
void emit_M2_mpy_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_acc_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_acc_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_acc_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_acc_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_acc_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_nac_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_nac_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_nac_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_nac_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_nac_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, fPASS(RxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_sat_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_sat_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_sat_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_sat_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_sat_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpy_sat_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpy_sat_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpy_sat_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpy_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpy_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpy_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpy_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpy_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, (fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpy_sat_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpyd_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV))));} */
;
void emit_M2_mpyd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV))));} */
;
void emit_M2_mpyd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyd_rnd_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpyd_rnd_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpyd_rnd_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(1,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpyd_rnd_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpyd_rnd_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(1,RtV)) + 0x8000));} */
;
void emit_M2_mpyd_rnd_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpyd_rnd_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS((fMPY16SS( fGETHALF(0,RsV),fGETHALF(0,RtV)) + 0x8000));} */
;
void emit_M2_mpyd_rnd_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000));} */
;
void emit_M2_mpyu_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyu_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyu_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyu_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fPASS(fPASS(RxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyu_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyu_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyu_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyu_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyu_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_acc_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_acc_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_acc_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_acc_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_acc_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_acc_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_acc_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_acc_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV+ (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_nac_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_nac_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_nac_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_nac_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_nac_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_nac_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_nac_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_nac_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV=fPASS(fPASS(RxxV- (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_hh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_hh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_hl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(1,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_hl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(1,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpyud_lh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(1,RtV))));} */
;
void emit_M2_mpyud_lh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_mpyud_ll_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( fMPY16UU( fGETUHALF(0,RsV),fGETUHALF(0,RtV))));} */
;
void emit_M2_mpyud_ll_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fPASS(fPASS( (fMPY16UU(fGETUHALF(0,RsV),fGETUHALF(0,RtV)) << 1)));} */
;
void emit_M2_mpysip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RdV=RsV*uiV; } */
;
void emit_M2_mpysin(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV=RsV*-uiV; } */
;
void emit_M2_macsip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RxV=RxV + (RsV*uiV);} */
;
void emit_M2_macsin(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RxV=RxV - (RsV*uiV);} */
;
void emit_M2_dpmpyss_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fMPY32SS(RsV,RtV);} */
;
void emit_M2_dpmpyss_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV + fMPY32SS(RsV,RtV);} */
;
void emit_M2_dpmpyss_nac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV - fMPY32SS(RsV,RtV);} */
;
void emit_M2_dpmpyuu_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RddV=fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
;
void emit_M2_dpmpyuu_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV + fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
;
void emit_M2_dpmpyuu_nac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxxV= RxxV - fMPY32UU(fCAST4u(RsV),fCAST4u(RtV));} */
;
void emit_M2_mpy_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SS(RsV,RtV)>>32;} */
;
void emit_M2_mpy_up_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SS(RsV,RtV)>>31;} */
;
void emit_M2_mpy_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fSATN(32, fMPY32SS(RsV,RtV)>>31);} */
;
void emit_M2_mpyu_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32UU(fCAST4u(RsV),fCAST4u(RtV))>>32;} */
;
void emit_M2_mpysu_up(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=fMPY32SU(RsV,fCAST4u(RtV))>>32;} */
;
void emit_M2_dpmpyss_rnd_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV=(fMPY32SS(RsV,RtV)+fCONSTLL(0x80000000))>>32;} */
;
void emit_M4_mac_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, (fSE32_64(RxV)) + (fMPY32SS(RsV,RtV)>>31));} */
;
void emit_M4_nac_up_s1_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RxV=fSATN(32, (fSE32_64(RxV)) - (fMPY32SS(RsV,RtV)>>31));} */
;
void emit_M2_mpyi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV*RtV;} */
;
void emit_M2_maci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV + RsV*RtV;} */
;
void emit_M2_mnaci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV - RsV*RtV;} */
;
void emit_M2_acci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV + RsV + RtV;} */
;
void emit_M2_accii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RxV=RxV + RsV + siV;} */
;
void emit_M2_nacci(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV=RxV - (RsV + RtV);} */
;
void emit_M2_naccii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RxV=RxV - (RsV + siV);} */
;
void emit_M2_subacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RxV=RxV + RtV - RsV;} */
;
void emit_M4_mpyrr_addr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RyV, TCGv_i32 RuV, TCGv_i32 RsV)
/* { RyV = RuV + RsV*RyV;} */
;
void emit_M4_mpyri_addr_u2(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RuV, TCGv_i32 RsV, int uiV)
/* { RdV = RuV + RsV*uiV;} */
;
void emit_M4_mpyri_addr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RuV, TCGv_i32 RsV, int uiV)
/* { fIMMEXT(uiV); RdV = RuV + RsV*uiV;} */
;
void emit_M4_mpyri_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV, int UiV)
/* { fIMMEXT(uiV); RdV = uiV + RsV*UiV;} */
;
void emit_M4_mpyrr_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* { fIMMEXT(uiV); RdV = uiV + RsV*RtV;} */
;
void emit_M2_vmpy2s_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_vmpy2s_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_vmac2s_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_vmac2s_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_vmpy2su_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 0)));} */
;
void emit_M2_vmpy2su_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_vmac2su_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 0)));} */
;
void emit_M2_vmac2su_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SU(fGETHALF(0,RsV),fGETUHALF(0,RtV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SU(fGETHALF(1,RsV),fGETUHALF(1,RtV)) << 1)));} */
;
void emit_M2_vmpy2s_s0pack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + 0x8000))));} */
;
void emit_M2_vmpy2s_s1pack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + 0x8000))));} */
;
void emit_M2_vmac2(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RxxV,fGETWORD(0,RxxV) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV))); fSETWORD(1,RxxV,fGETWORD(1,RxxV) + fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)));} */
;
void emit_M2_vmpy2es_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0)));} */
;
void emit_M2_vmpy2es_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1)));} */
;
void emit_M2_vmac2es_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0)));} */
;
void emit_M2_vmac2es_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1)));} */
;
void emit_M2_vmac2es(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fGETWORD(0,RxxV) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV))); fSETWORD(1,RxxV,fGETWORD(1,RxxV) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)));} */
;
void emit_M2_vrmac_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrmpy_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vdmpyrs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0) + 0x8000)))); fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0) + 0x8000))));} */
;
void emit_M2_vdmpyrs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1) + 0x8000)))); fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1) + 0x8000))));} */
;
void emit_M5_vrmpybuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,(fMPY16SS(fGETUBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETUBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETUBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETUBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RddV,(fMPY16SS(fGETUBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETUBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETUBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETUBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
;
void emit_M5_vrmacbuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + fMPY16SS(fGETUBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETUBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETUBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETUBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + fMPY16SS(fGETUBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETUBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETUBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETUBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
;
void emit_M5_vrmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,(fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RddV,(fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
;
void emit_M5_vrmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV)) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV)))); fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV)) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV)))); } */
;
void emit_M5_vmpybuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RddV,(fMPY16SS(fGETUBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RddV,(fMPY16SS(fGETUBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RddV,(fMPY16SS(fGETUBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RddV,(fMPY16SS(fGETUBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
;
void emit_M5_vmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RddV,(fMPY16SS(fGETBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RddV,(fMPY16SS(fGETBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RddV,(fMPY16SS(fGETBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RddV,(fMPY16SS(fGETBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
;
void emit_M5_vmacbuu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RxxV,(fGETHALF(0,RxxV)+fMPY16SS(fGETUBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RxxV,(fGETHALF(1,RxxV)+fMPY16SS(fGETUBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RxxV,(fGETHALF(2,RxxV)+fMPY16SS(fGETUBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RxxV,(fGETHALF(3,RxxV)+fMPY16SS(fGETUBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
;
void emit_M5_vmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RxxV,(fGETHALF(0,RxxV)+fMPY16SS(fGETBYTE(0,RsV),fGETUBYTE(0,RtV)))); fSETHALF(1,RxxV,(fGETHALF(1,RxxV)+fMPY16SS(fGETBYTE(1,RsV),fGETUBYTE(1,RtV)))); fSETHALF(2,RxxV,(fGETHALF(2,RxxV)+fMPY16SS(fGETBYTE(2,RsV),fGETUBYTE(2,RtV)))); fSETHALF(3,RxxV,(fGETHALF(3,RxxV)+fMPY16SS(fGETBYTE(3,RsV),fGETUBYTE(3,RtV)))); } */
;
void emit_M5_vdmpybsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16,(fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV))))); fSETHALF(1,RddV,fSATN(16,(fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV))))); fSETHALF(2,RddV,fSATN(16,(fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV))))); fSETHALF(3,RddV,fSATN(16,(fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV))))); } */
;
void emit_M5_vdmacbsu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RxxV,fSATN(16,(fGETHALF(0,RxxV) + fMPY16SS(fGETBYTE(0,RssV),fGETUBYTE(0,RttV)) + fMPY16SS(fGETBYTE(1,RssV),fGETUBYTE(1,RttV))))); fSETHALF(1,RxxV,fSATN(16,(fGETHALF(1,RxxV) + fMPY16SS(fGETBYTE(2,RssV),fGETUBYTE(2,RttV)) + fMPY16SS(fGETBYTE(3,RssV),fGETUBYTE(3,RttV))))); fSETHALF(2,RxxV,fSATN(16,(fGETHALF(2,RxxV) + fMPY16SS(fGETBYTE(4,RssV),fGETUBYTE(4,RttV)) + fMPY16SS(fGETBYTE(5,RssV),fGETUBYTE(5,RttV))))); fSETHALF(3,RxxV,fSATN(16,(fGETHALF(3,RxxV) + fMPY16SS(fGETBYTE(6,RssV),fGETUBYTE(6,RttV)) + fMPY16SS(fGETBYTE(7,RssV),fGETUBYTE(7,RttV))))); } */
;
void emit_M2_vdmacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));} */
;
void emit_M2_vdmacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));} */
;
void emit_M2_vdmpys_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 0) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 0) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));} */
;
void emit_M2_vdmpys_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) << 1) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));} */
;
void emit_M2_cmpyrs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000))));} */
;
void emit_M2_cmpyrs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000))));} */
;
void emit_M2_cmpyrsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0) + 0x8000))));} */
;
void emit_M2_cmpyrsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(1,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1) + 0x8000)))); fSETHALF(0,RdV,fGETHALF(1,(fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1) + 0x8000))));} */
;
void emit_M2_cmacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_cmacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_cmacsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_cmacsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_cmpys_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_cmpys_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_cmpysc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0)));} */
;
void emit_M2_cmpysc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1)));} */
;
void emit_M2_cnacs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0))));} */
;
void emit_M2_cnacs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1))));} */
;
void emit_M2_cnacsc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 0) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 0)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 0) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 0))));} */
;
void emit_M2_cnacsc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) - ((fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) << 1) - (fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)) << 1)))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) - ((fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) << 1) + (fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)) << 1))));} */
;
void emit_M2_vrcmpys_s1_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1)));} */
;
void emit_M2_vrcmpys_s1_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1))); fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1)));} */
;
void emit_M2_vrcmpys_acc_s1_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1)));} */
;
void emit_M2_vrcmpys_acc_s1_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1)));} */
;
void emit_M2_vrcmpys_s1rp_h(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(1,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1) + 0x8000))); fSETHALF(0,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(1,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(1,RttV))) << 1) + 0x8000)));} */
;
void emit_M2_vrcmpys_s1rp_l(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(1,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1) + 0x8000))); fSETHALF(0,RdV,fGETHALF(1,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,fGETWORD(0,RttV))) << 1) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(1,fGETWORD(0,RttV))) << 1) + 0x8000)));} */
;
void emit_M2_mmacls_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0))>>16)) ); } */
;
void emit_M2_mmacls_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1))>>16)) ); } */
;
void emit_M2_mmachs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0))>>16 ))); } */
;
void emit_M2_mmachs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1))>>16 ))); } */
;
void emit_M2_mmpyl_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0))>>16)); } */
;
void emit_M2_mmpyl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1))>>16)); } */
;
void emit_M2_mmpyh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0))>>16)); } */
;
void emit_M2_mmpyh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1))>>16)); } */
;
void emit_M2_mmacls_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0)+0x8000)>>16)) ); } */
;
void emit_M2_mmacls_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1)+0x8000)>>16)) ); } */
;
void emit_M2_mmachs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0)+0x8000)>>16 ))); } */
;
void emit_M2_mmachs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1)+0x8000)>>16 ))); } */
;
void emit_M2_mmpyl_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0)+0x8000)>>16)); } */
;
void emit_M2_mmpyl_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1)+0x8000)>>16)); } */
;
void emit_M2_mmpyh_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0)+0x8000)>>16)); } */
;
void emit_M2_mmpyh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1)+0x8000)>>16)); } */
;
void emit_M4_vrmpyeh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0);} */
;
void emit_M4_vrmpyeh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1);} */
;
void emit_M4_vrmpyeh_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 0);} */
;
void emit_M4_vrmpyeh_acc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(2,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RttV)) << 1);} */
;
void emit_M4_vrmpyoh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0);} */
;
void emit_M4_vrmpyoh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1);} */
;
void emit_M4_vrmpyoh_acc_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 0) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 0);} */
;
void emit_M4_vrmpyoh_acc_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY3216SS(fGETWORD(1,RssV),fGETHALF(3,RttV)) << 1) + (fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RttV)) << 1);} */
;
void emit_M2_hmmpyl_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(0,RtV)) << 1)+0x8000)>>16); } */
;
void emit_M2_hmmpyh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(1,RtV)) << 1)+0x8000)>>16); } */
;
void emit_M2_hmmpyl_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(0,RtV)) << 1))>>16); } */
;
void emit_M2_hmmpyh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ((fMPY3216SS(RsV,fGETHALF(1,RtV)) << 1))>>16); } */
;
void emit_M2_mmaculs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0))>>16)) ); } */
;
void emit_M2_mmaculs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1))>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1))>>16)) ); } */
;
void emit_M2_mmacuhs_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0))>>16 ))); } */
;
void emit_M2_mmacuhs_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1))>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1))>>16 ))); } */
;
void emit_M2_mmpyul_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0))>>16)); } */
;
void emit_M2_mmpyul_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1))>>16)); } */
;
void emit_M2_mmpyuh_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0))>>16)); } */
;
void emit_M2_mmpyuh_s1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1))>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1))>>16)); } */
;
void emit_M2_mmaculs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0)+0x8000)>>16)) ); } */
;
void emit_M2_mmaculs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1)+0x8000)>>16)) ); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1)+0x8000)>>16)) ); } */
;
void emit_M2_mmacuhs_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0)+0x8000)>>16 ))); } */
;
void emit_M2_mmacuhs_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1)+0x8000)>>16))); fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1)+0x8000)>>16 ))); } */
;
void emit_M2_mmpyul_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 0)+0x8000)>>16)); } */
;
void emit_M2_mmpyul_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(2,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(0,RttV)) << 1)+0x8000)>>16)); } */
;
void emit_M2_mmpyuh_rs0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 0)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 0)+0x8000)>>16)); } */
;
void emit_M2_mmpyuh_rs1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(1,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(1,RssV),fGETUHALF(3,RttV)) << 1)+0x8000)>>16)); fSETWORD(0,RddV,fSATN(32, ((fMPY3216SU(fGETWORD(0,RssV),fGETUHALF(1,RttV)) << 1)+0x8000)>>16)); } */
;
void emit_M2_vrcmaci_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmacr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmaci_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmacr_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_cmaci_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)); } */
;
void emit_M2_cmacr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxxV = RxxV + fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) - fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)); } */
;
void emit_M2_vrcmpyi_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmpyr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmpyi_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_vrcmpyr_s0c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV));} */
;
void emit_M2_cmpyi_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RddV = fMPY16SS(fGETHALF(1,RsV),fGETHALF(0,RtV)) + fMPY16SS(fGETHALF(0,RsV),fGETHALF(1,RtV)); } */
;
void emit_M2_cmpyr_s0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RddV = fMPY16SS(fGETHALF(0,RsV),fGETHALF(0,RtV)) - fMPY16SS(fGETHALF(1,RsV),fGETHALF(1,RtV)); } */
;
void emit_M4_cmpyi_wh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RtV)) + fMPY3216SS(fGETWORD(1,RssV),fGETHALF(0,RtV)) + 0x4000)>>15); } */
;
void emit_M4_cmpyr_wh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RtV)) - fMPY3216SS(fGETWORD(1,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
;
void emit_M4_cmpyi_whc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(1,RssV),fGETHALF(0,RtV)) - fMPY3216SS(fGETWORD(0,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
;
void emit_M4_cmpyr_whc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { RdV = fSATN(32, ( fMPY3216SS(fGETWORD(0,RssV),fGETHALF(0,RtV)) + fMPY3216SS(fGETWORD(1,RssV),fGETHALF(1,RtV)) + 0x4000)>>15); } */
;
void emit_M2_vcmpy_s0_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 0)));; } */
;
void emit_M2_vcmpy_s0_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));; } */
;
void emit_M2_vcmpy_s1_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 1)));; } */
;
void emit_M2_vcmpy_s1_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 1))); fSETWORD(1,RddV,fSATN(32, (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 1)));; } */
;
void emit_M2_vcmac_s0_sat_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(1,RssV),fGETHALF(0,RttV)) + fMPY16SS(fGETHALF(0,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(3,RssV),fGETHALF(2,RttV)) + fMPY16SS(fGETHALF(2,RssV),fGETHALF(3,RttV)) << 0)));; } */
;
void emit_M2_vcmac_s0_sat_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RxxV,fSATN(32, fGETWORD(0,RxxV) + (fMPY16SS(fGETHALF(0,RssV),fGETHALF(0,RttV)) - fMPY16SS(fGETHALF(1,RssV),fGETHALF(1,RttV)) << 0))); fSETWORD(1,RxxV,fSATN(32, fGETWORD(1,RxxV) + (fMPY16SS(fGETHALF(2,RssV),fGETHALF(2,RttV)) - fMPY16SS(fGETHALF(3,RssV),fGETHALF(3,RttV)) << 0)));; } */
;
void emit_S2_vcrotate(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size1u_t tmp; tmp = fEXTRACTU_RANGE(RtV,1,0); if (tmp == 0) { fSETHALF(0,RddV,fGETHALF(0,RssV)); fSETHALF(1,RddV,fGETHALF(1,RssV)); } else if (tmp == 1) { fSETHALF(0,RddV,fGETHALF(1,RssV)); fSETHALF(1,RddV,fSATN(16, -fGETHALF(0,RssV))); } else if (tmp == 2) { fSETHALF(0,RddV,fSATN(16, -fGETHALF(1,RssV))); fSETHALF(1,RddV,fGETHALF(0,RssV)); } else { if (tmp != 3) fatal("C is broken"); fSETHALF(0,RddV,fSATN(16, -fGETHALF(0,RssV))); fSETHALF(1,RddV,fSATN(16, -fGETHALF(1,RssV))); } tmp = fEXTRACTU_RANGE(RtV,3,2); if (tmp == 0) { fSETHALF(2,RddV,fGETHALF(2,RssV)); fSETHALF(3,RddV,fGETHALF(3,RssV)); } else if (tmp == 1) { fSETHALF(2,RddV,fGETHALF(3,RssV)); fSETHALF(3,RddV,fSATN(16, -fGETHALF(2,RssV))); } else if (tmp == 2) { fSETHALF(2,RddV,fSATN(16, -fGETHALF(3,RssV))); fSETHALF(3,RddV,fGETHALF(2,RssV)); } else { if (tmp != 3) fatal("C is broken"); fSETHALF(2,RddV,fSATN(16, -fGETHALF(2,RssV))); fSETHALF(3,RddV,fSATN(16, -fGETHALF(3,RssV))); } } */
;
void emit_S2_vcnegh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i = 0; i < 4; i++) { if (fGETBIT(i,RtV)) { fSETHALF(i,RddV,fSATN(16, -fGETHALF(i,RssV))); } else { fSETHALF(i,RddV,fGETHALF(i,RssV)); } } } */
;
void emit_S2_vrcnegh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i = 0; i < 4; i++) { if (fGETBIT(i,RtV)) { RxxV += -fGETHALF(i,RssV); } else { RxxV += fGETHALF(i,RssV); } } } */
;
void emit_M4_pmpyw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; unsigned int y; unsigned long long x; unsigned long long prod; x = fGETUWORD(0, RsV); y = fGETUWORD(0, RtV); prod = 0; for(i=0; i < 32; i++) { if((y >> i) & 1) prod ^= (x << i); } RddV = prod; } */
;
void emit_M4_vpmpyh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; unsigned int x0; unsigned int x1; unsigned int y0; unsigned int y1; unsigned int prod0; unsigned int prod1; x0 = fGETUHALF(0, RsV); x1 = fGETUHALF(1, RsV); y0 = fGETUHALF(0, RtV); y1 = fGETUHALF(1, RtV); prod0 = prod1 = 0; for(i=0; i < 16; i++) { if((y0 >> i) & 1) prod0 ^= (x0 << i); if((y1 >> i) & 1) prod1 ^= (x1 << i); } fSETHALF(0,RddV,fGETUHALF(0,prod0)); fSETHALF(1,RddV,fGETUHALF(0,prod1)); fSETHALF(2,RddV,fGETUHALF(1,prod0)); fSETHALF(3,RddV,fGETUHALF(1,prod1)); } */
;
void emit_M4_pmpyw_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; unsigned int y; unsigned long long x; unsigned long long prod; x = fGETUWORD(0, RsV); y = fGETUWORD(0, RtV); prod = 0; for(i=0; i < 32; i++) { if((y >> i) & 1) prod ^= (x << i); } RxxV ^= prod; } */
;
void emit_M4_vpmpyh_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; unsigned int x0; unsigned int x1; unsigned int y0; unsigned int y1; unsigned int prod0; unsigned int prod1; x0 = fGETUHALF(0, RsV); x1 = fGETUHALF(1, RsV); y0 = fGETUHALF(0, RtV); y1 = fGETUHALF(1, RtV); prod0 = prod1 = 0; for(i=0; i < 16; i++) { if((y0 >> i) & 1) prod0 ^= (x0 << i); if((y1 >> i) & 1) prod1 ^= (x1 << i); } fSETHALF(0,RxxV,fGETUHALF(0,RxxV) ^ fGETUHALF(0,prod0)); fSETHALF(1,RxxV,fGETUHALF(1,RxxV) ^ fGETUHALF(0,prod1)); fSETHALF(2,RxxV,fGETUHALF(2,RxxV) ^ fGETUHALF(1,prod0)); fSETHALF(3,RxxV,fGETUHALF(3,RxxV) ^ fGETUHALF(1,prod1)); } */
;
void emit_M7_dcmpyrw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY32SS(fGETWORD(0, RssV), fGETWORD(0, RttV)) - fMPY32SS(fGETWORD(1, RssV), fGETWORD(1, RttV)));} */
;
void emit_M7_dcmpyrw_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY32SS(fGETWORD(0, RssV), fGETWORD(0, RttV)) - fMPY32SS(fGETWORD(1, RssV), fGETWORD(1, RttV)));} */
;
void emit_M7_dcmpyrwc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY32SS(fGETWORD(0, RssV), fGETWORD(0, RttV)) + fMPY32SS(fGETWORD(1, RssV), fGETWORD(1, RttV)));} */
;
void emit_M7_dcmpyrwc_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY32SS(fGETWORD(0, RssV), fGETWORD(0, RttV)) + fMPY32SS(fGETWORD(1, RssV), fGETWORD(1, RttV)));} */
;
void emit_M7_dcmpyiw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY32SS(fGETWORD(0, RssV), fGETWORD(1, RttV)) + fMPY32SS(fGETWORD(1, RssV), fGETWORD(0, RttV)));} */
;
void emit_M7_dcmpyiw_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY32SS(fGETWORD(0, RssV), fGETWORD(1, RttV)) + fMPY32SS(fGETWORD(1, RssV), fGETWORD(0, RttV)));} */
;
void emit_M7_dcmpyiwc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fMPY32SS(fGETWORD(1, RssV), fGETWORD(0, RttV)) - fMPY32SS(fGETWORD(0, RssV), fGETWORD(1, RttV)));} */
;
void emit_M7_dcmpyiwc_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fMPY32SS(fGETWORD(1, RssV), fGETWORD(0, RttV)) - fMPY32SS(fGETWORD(0, RssV), fGETWORD(1, RttV)));} */
;
void emit_A2_add(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV+RtV;} */
;
void emit_A2_sub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV=RtV-RsV;} */
;
void emit_A2_paddt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fGETBIT(0, PuV))){RdV=RsV+RtV;} else {CANCEL;}} */
;
void emit_A2_paddf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV+RtV;} else {CANCEL;}} */
;
void emit_A2_paddtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fLSBNEW(PuN)){RdV=RsV+RtV;} else {CANCEL;}} */
;
void emit_A2_paddfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fLSBNEW(~PuN))){RdV=RsV+RtV;} else {CANCEL;}} */
;
void emit_A2_psubt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=RtV-RsV;} else {CANCEL;}} */
;
void emit_A2_psubf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=RtV-RsV;} else {CANCEL;}} */
;
void emit_A2_psubtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=RtV-RsV;} else {CANCEL;}} */
;
void emit_A2_psubfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=RtV-RsV;} else {CANCEL;}} */
;
void emit_A2_paddit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {if((fGETBIT(0, PuV))){fIMMEXT(siV); RdV=RsV+siV;} else {CANCEL;}} */
;
void emit_A2_paddif(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {if(fGETBIT(0, ~PuV)){fIMMEXT(siV); RdV=RsV+siV;} else {CANCEL;}} */
;
void emit_A2_padditnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {if(fLSBNEW(PuN)){fIMMEXT(siV); RdV=RsV+siV;} else {CANCEL;}} */
;
void emit_A2_paddifnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* {if((fLSBNEW(~PuN))){fIMMEXT(siV); RdV=RsV+siV;} else {CANCEL;}} */
;
void emit_A2_pxort(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fGETBIT(0, PuV))){RdV=RsV^RtV;} else {CANCEL;}} */
;
void emit_A2_pxorf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV^RtV;} else {CANCEL;}} */
;
void emit_A2_pxortnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fLSBNEW(PuN)){RdV=RsV^RtV;} else {CANCEL;}} */
;
void emit_A2_pxorfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fLSBNEW(~PuN))){RdV=RsV^RtV;} else {CANCEL;}} */
;
void emit_A2_pandt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fGETBIT(0, PuV))){RdV=RsV&RtV;} else {CANCEL;}} */
;
void emit_A2_pandf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV&RtV;} else {CANCEL;}} */
;
void emit_A2_pandtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fLSBNEW(PuN)){RdV=RsV&RtV;} else {CANCEL;}} */
;
void emit_A2_pandfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fLSBNEW(~PuN))){RdV=RsV&RtV;} else {CANCEL;}} */
;
void emit_A2_port(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fGETBIT(0, PuV))){RdV=RsV|RtV;} else {CANCEL;}} */
;
void emit_A2_porf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV|RtV;} else {CANCEL;}} */
;
void emit_A2_portnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if(fLSBNEW(PuN)){RdV=RsV|RtV;} else {CANCEL;}} */
;
void emit_A2_porfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {if((fLSBNEW(~PuN))){RdV=RsV|RtV;} else {CANCEL;}} */
;
void emit_A4_psxtbt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=fSXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxtbf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=fSXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxtbtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=fSXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxtbfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=fSXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxtbt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=fZXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxtbf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=fZXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxtbtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=fZXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxtbfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=fZXTN(8,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxtht(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=fSXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxthf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=fSXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxthtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=fSXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_psxthfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=fSXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxtht(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=fZXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxthf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=fZXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxthtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=fZXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_pzxthfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=fZXTN(16,32,RsV);} else {CANCEL;}} */
;
void emit_A4_paslht(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=RsV<<16;} else {CANCEL;}} */
;
void emit_A4_paslhf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV<<16;} else {CANCEL;}} */
;
void emit_A4_paslhtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=RsV<<16;} else {CANCEL;}} */
;
void emit_A4_paslhfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=RsV<<16;} else {CANCEL;}} */
;
void emit_A4_pasrht(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fGETBIT(0, PuV))){RdV=RsV>>16;} else {CANCEL;}} */
;
void emit_A4_pasrhf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuV, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fGETBIT(0, ~PuV)){RdV=RsV>>16;} else {CANCEL;}} */
;
void emit_A4_pasrhtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if(fLSBNEW(PuN)){RdV=RsV>>16;} else {CANCEL;}} */
;
void emit_A4_pasrhfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PuN, TCGv_i32 RdV, TCGv_i32 RsV)
/* {if((fLSBNEW(~PuN))){RdV=RsV>>16;} else {CANCEL;}} */
;
void emit_A2_addsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=fSATN(32, fSE32_64(RsV)+fSE32_64(RtV)); } */
;
void emit_A2_subsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV=fSATN(32, fSE32_64(RtV) - fSE32_64(RsV)); } */
;
void emit_A2_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV=RsV+siV;} */
;
void emit_C4_addipc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* { RdV=fREAD_PC()+fIMMEXT(uiV);} */
;
void emit_A2_addh_l16_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSXTN(16,32,(fGETHALF(0,RtV)+fGETHALF(0,RsV)));} */
;
void emit_A2_addh_l16_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSXTN(16,32,(fGETHALF(0,RtV)+fGETHALF(1,RsV)));} */
;
void emit_A2_addh_l16_sat_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSATN(16, fGETHALF(0,RtV)+fGETHALF(0,RsV));} */
;
void emit_A2_addh_l16_sat_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSATN(16, fGETHALF(0,RtV)+fGETHALF(1,RsV));} */
;
void emit_A2_subh_l16_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSXTN(16,32,(fGETHALF(0,RtV)-fGETHALF(0,RsV)));} */
;
void emit_A2_subh_l16_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSXTN(16,32,(fGETHALF(0,RtV)-fGETHALF(1,RsV)));} */
;
void emit_A2_subh_l16_sat_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSATN(16, fGETHALF(0,RtV)-fGETHALF(0,RsV));} */
;
void emit_A2_subh_l16_sat_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=fSATN(16, fGETHALF(0,RtV)-fGETHALF(1,RsV));} */
;
void emit_A2_addh_h16_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(0,RtV)+fGETHALF(0,RsV))<<16;} */
;
void emit_A2_addh_h16_lh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(0,RtV)+fGETHALF(1,RsV))<<16;} */
;
void emit_A2_addh_h16_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(1,RtV)+fGETHALF(0,RsV))<<16;} */
;
void emit_A2_addh_h16_hh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(1,RtV)+fGETHALF(1,RsV))<<16;} */
;
void emit_A2_addh_h16_sat_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(0,RtV)+fGETHALF(0,RsV)))<<16;} */
;
void emit_A2_addh_h16_sat_lh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(0,RtV)+fGETHALF(1,RsV)))<<16;} */
;
void emit_A2_addh_h16_sat_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(1,RtV)+fGETHALF(0,RsV)))<<16;} */
;
void emit_A2_addh_h16_sat_hh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(1,RtV)+fGETHALF(1,RsV)))<<16;} */
;
void emit_A2_subh_h16_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(0,RtV)-fGETHALF(0,RsV))<<16;} */
;
void emit_A2_subh_h16_lh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(0,RtV)-fGETHALF(1,RsV))<<16;} */
;
void emit_A2_subh_h16_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(1,RtV)-fGETHALF(0,RsV))<<16;} */
;
void emit_A2_subh_h16_hh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fGETHALF(1,RtV)-fGETHALF(1,RsV))<<16;} */
;
void emit_A2_subh_h16_sat_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(0,RtV)-fGETHALF(0,RsV)))<<16;} */
;
void emit_A2_subh_h16_sat_lh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(0,RtV)-fGETHALF(1,RsV)))<<16;} */
;
void emit_A2_subh_h16_sat_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(1,RtV)-fGETHALF(0,RsV)))<<16;} */
;
void emit_A2_subh_h16_sat_hh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV=(fSATN(16, fGETHALF(1,RtV)-fGETHALF(1,RsV)))<<16;} */
;
void emit_A2_aslh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV<<16; } */
;
void emit_A2_asrh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV>>16; } */
;
void emit_A2_addp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RssV+RttV;} */
;
void emit_A2_addpsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fADDSAT64(RddV,RssV,RttV);} */
;
void emit_A2_addspl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RttV+fSXTN(32,64,fGETWORD(0,RssV));} */
;
void emit_A2_addsph(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RttV+fSXTN(32,64,fGETWORD(1,RssV));} */
;
void emit_A2_subp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { RddV=RttV-RssV;} */
;
void emit_A4_addp_c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV, TCGv PxV)
/* { RddV = RssV + RttV + (fGETBIT(0, PxV)); PxV = ((fCARRY_FROM_ADD(RssV,RttV,(fGETBIT(0, PxV)))) ? 0xff : 0x00); } */
;
void emit_A4_subp_c(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV, TCGv PxV)
/* { RddV = RssV + ~RttV + (fGETBIT(0, PxV)); PxV = ((fCARRY_FROM_ADD(RssV,~RttV,(fGETBIT(0, PxV)))) ? 0xff : 0x00); } */
;
void emit_A2_negsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATN(32, -fCAST8s(RsV)); } */
;
void emit_A2_abs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fABS(RsV); } */
;
void emit_A2_abssat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATN(32, fABS(fCAST4_8s(RsV))); } */
;
void emit_A2_vconj(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { fSETHALF(1,RddV,fSATN(16,-fGETHALF(1,RssV))); fSETHALF(0,RddV,fGETHALF(0,RssV)); fSETHALF(3,RddV,fSATN(16,-fGETHALF(3,RssV))); fSETHALF(2,RddV,fGETHALF(2,RssV)); } */
;
void emit_A2_negp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { RddV = -RssV; } */
;
void emit_A2_absp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { RddV = fABS(RssV); } */
;
void emit_A2_max(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fMAX(RsV,RtV); } */
;
void emit_A2_maxu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = fMAX(fCAST4u(RsV),fCAST4u(RtV)); } */
;
void emit_A2_min(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV = fMIN(RtV,RsV); } */
;
void emit_A2_minu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV = fMIN(fCAST4u(RtV),fCAST4u(RsV)); } */
;
void emit_A2_maxp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMAX(RssV,RttV); } */
;
void emit_A2_maxup(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = fMAX(fCAST8u(RssV),fCAST8u(RttV)); } */
;
void emit_A2_minp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { RddV = fMIN(RttV,RssV); } */
;
void emit_A2_minup(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { RddV = fMIN(fCAST8u(RttV),fCAST8u(RssV)); } */
;
void emit_A2_nop(DisasContext *ctx, Insn *insn, Packet *pkt)
/* { } */
;
void emit_A4_ext(DisasContext *ctx, Insn *insn, Packet *pkt, int uiV)
/* { ; } */
;
void emit_A2_tfr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV;} */
;
void emit_A2_tfrsi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int siV)
/* { fIMMEXT(siV); RdV=siV;} */
;
void emit_A2_sxtb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fSXTN(8,32,RsV);} */
;
void emit_A2_zxth(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fZXTN(16,32,RsV);} */
;
void emit_A2_sxth(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fSXTN(16,32,RsV);} */
;
void emit_A2_combinew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETWORD(0,RddV,RtV); fSETWORD(1,RddV,RsV); } */
;
void emit_A4_combineri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); fSETWORD(0,RddV,siV); fSETWORD(1,RddV,RsV); } */
;
void emit_A4_combineir(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); fSETWORD(0,RddV,RsV); fSETWORD(1,RddV,siV); } */
;
void emit_A2_combineii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int siV, int SiV)
/* { fIMMEXT(siV); fSETWORD(0,RddV,SiV); fSETWORD(1,RddV,siV); } */
;
void emit_A4_combineii(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int siV, int UiV)
/* { fIMMEXT(UiV); fSETWORD(0,RddV,UiV); fSETWORD(1,RddV,siV); } */
;
void emit_A2_combine_hh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV = (fGETUHALF(1,RtV)<<16) | fGETUHALF(1,RsV);} */
;
void emit_A2_combine_hl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV = (fGETUHALF(1,RtV)<<16) | fGETUHALF(0,RsV);} */
;
void emit_A2_combine_lh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV = (fGETUHALF(0,RtV)<<16) | fGETUHALF(1,RsV);} */
;
void emit_A2_combine_ll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* {RdV = (fGETUHALF(0,RtV)<<16) | fGETUHALF(0,RsV);} */
;
void emit_A2_tfril(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV)
/* { fSETHALF(0,RxV,uiV);} */
;
void emit_A2_tfrih(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV)
/* { fSETHALF(1,RxV,uiV);} */
;
void emit_A2_tfrcrr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 CsV)
/* { RdV=CsV;} */
;
void emit_A2_tfrrcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 CdV, TCGv_i32 RsV)
/* { CdV=RsV;} */
;
void emit_A4_tfrcpp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 CssV)
/* { RddV=CssV;} */
;
void emit_A4_tfrpcp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 CddV, TCGv_i64 RssV)
/* { CddV=RssV;} */
;
void emit_A2_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV&RtV;} */
;
void emit_A2_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV|RtV;} */
;
void emit_A2_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV=RsV^RtV;} */
;
void emit_M2_xor_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV^=RsV^RtV;} */
;
void emit_M4_xor_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV^=RssV^RttV;} */
;
void emit_A4_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV = (RtV & ~RsV); } */
;
void emit_A4_orn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { RdV = (RtV | ~RsV); } */
;
void emit_A4_andnp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { RddV = (RttV & ~RssV); } */
;
void emit_A4_ornp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { RddV = (RttV | ~RssV); } */
;
void emit_S4_addaddi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RuV, int siV)
/* { RdV = RsV + RuV + fIMMEXT(siV); } */
;
void emit_S4_subaddi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RuV, int siV)
/* { RdV = RsV - RuV + fIMMEXT(siV); } */
;
void emit_M4_and_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV &= (RsV & RtV); } */
;
void emit_M4_and_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV &= (RsV & ~RtV); } */
;
void emit_M4_and_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV &= (RsV | RtV); } */
;
void emit_M4_and_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV &= (RsV ^ RtV); } */
;
void emit_M4_or_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV |= (RsV & RtV); } */
;
void emit_M4_or_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV |= (RsV & ~RtV); } */
;
void emit_M4_or_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV |= (RsV | RtV); } */
;
void emit_M4_or_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV |= (RsV ^ RtV); } */
;
void emit_S4_or_andix(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RuV, int siV)
/* { RxV = RuV | (RxV & fIMMEXT(siV)); } */
;
void emit_S4_or_andi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { RxV = RxV | (RsV & fIMMEXT(siV)); } */
;
void emit_S4_or_ori(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int siV)
/* { RxV = RxV | (RsV | fIMMEXT(siV)); } */
;
void emit_M4_xor_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV ^= (RsV & RtV); } */
;
void emit_M4_xor_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV ^= (RsV | RtV); } */
;
void emit_M4_xor_andn(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RxV ^= (RsV & ~RtV); } */
;
void emit_A2_subri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV=siV-RsV;} */
;
void emit_A2_andir(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV=RsV&siV;} */
;
void emit_A2_orir(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* { fIMMEXT(siV); RdV=RsV|siV;} */
;
void emit_A2_andp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RssV&RttV;} */
;
void emit_A2_orp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RssV|RttV;} */
;
void emit_A2_xorp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV=RssV^RttV;} */
;
void emit_A2_notp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { RddV=~RssV;} */
;
void emit_A2_sxtw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { RddV = fCAST4_8s(RsV); } */
;
void emit_A2_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { RdV = fSATN(32, RssV); } */
;
void emit_A2_roundsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { size8s_t tmp; fADDSAT64(tmp,RssV,0x080000000ULL); RdV = fGETWORD(1,tmp); } */
;
void emit_A2_sath(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATN(16, RsV); } */
;
void emit_A2_satuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATUN(16, RsV); } */
;
void emit_A2_satub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATUN(8, RsV); } */
;
void emit_A2_satb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV = fSATN(8, RsV); } */
;
void emit_A2_vaddub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV))); } } */
;
void emit_A2_vaddubs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fSATUN(8,fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV))); } } */
;
void emit_A2_vaddh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETHALF(i,RssV)+fGETHALF(i,RttV)); } } */
;
void emit_A2_vaddhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(16,fGETHALF(i,RssV)+fGETHALF(i,RttV))); } } */
;
void emit_A2_vadduhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATUN(16,fGETUHALF(i,RssV)+fGETUHALF(i,RttV))); } } */
;
void emit_A5_vaddhubs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV,fSATUN(8, fGETHALF(i,RssV)+fGETHALF(i,RttV))); } } */
;
void emit_A2_vaddw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fGETWORD(i,RssV)+fGETWORD(i,RttV)); } } */
;
void emit_A2_vaddws(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(32,fGETWORD(i,RssV)+fGETWORD(i,RttV))); } } */
;
void emit_S4_vxaddsubw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, fGETWORD(0,RssV)+fGETWORD(1,RttV))); fSETWORD(1,RddV,fSATN(32, fGETWORD(1,RssV)-fGETWORD(0,RttV))); } */
;
void emit_S4_vxsubaddw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETWORD(0,RddV,fSATN(32, fGETWORD(0,RssV)-fGETWORD(1,RttV))); fSETWORD(1,RddV,fSATN(32, fGETWORD(1,RssV)+fGETWORD(0,RttV))); } */
;
void emit_S4_vxaddsubh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16, fGETHALF(0,RssV)+fGETHALF(1,RttV))); fSETHALF(1,RddV,fSATN(16, fGETHALF(1,RssV)-fGETHALF(0,RttV))); fSETHALF(2,RddV,fSATN(16, fGETHALF(2,RssV)+fGETHALF(3,RttV))); fSETHALF(3,RddV,fSATN(16, fGETHALF(3,RssV)-fGETHALF(2,RttV))); } */
;
void emit_S4_vxsubaddh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16, fGETHALF(0,RssV)-fGETHALF(1,RttV))); fSETHALF(1,RddV,fSATN(16, fGETHALF(1,RssV)+fGETHALF(0,RttV))); fSETHALF(2,RddV,fSATN(16, fGETHALF(2,RssV)-fGETHALF(3,RttV))); fSETHALF(3,RddV,fSATN(16, fGETHALF(3,RssV)+fGETHALF(2,RttV))); } */
;
void emit_S4_vxaddsubhr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16, (fGETHALF(0,RssV)+fGETHALF(1,RttV)+1)>>1)); fSETHALF(1,RddV,fSATN(16, (fGETHALF(1,RssV)-fGETHALF(0,RttV)+1)>>1)); fSETHALF(2,RddV,fSATN(16, (fGETHALF(2,RssV)+fGETHALF(3,RttV)+1)>>1)); fSETHALF(3,RddV,fSATN(16, (fGETHALF(3,RssV)-fGETHALF(2,RttV)+1)>>1)); } */
;
void emit_S4_vxsubaddhr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fSATN(16, (fGETHALF(0,RssV)-fGETHALF(1,RttV)+1)>>1)); fSETHALF(1,RddV,fSATN(16, (fGETHALF(1,RssV)+fGETHALF(0,RttV)+1)>>1)); fSETHALF(2,RddV,fSATN(16, (fGETHALF(2,RssV)-fGETHALF(3,RttV)+1)>>1)); fSETHALF(3,RddV,fSATN(16, (fGETHALF(3,RssV)+fGETHALF(2,RttV)+1)>>1)); } */
;
void emit_A2_svavgh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,((fGETHALF(i,RsV)+fGETHALF(i,RtV))>>1)); } } */
;
void emit_A2_svavghs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,((fGETHALF(i,RsV)+fGETHALF(i,RtV)+1)>>1)); } } */
;
void emit_A2_svnavgh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,((fGETHALF(i,RtV)-fGETHALF(i,RsV))>>1)); } } */
;
void emit_A2_svaddh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(i,RsV)+fGETHALF(i,RtV)); } } */
;
void emit_A2_svaddhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATN(16,fGETHALF(i,RsV)+fGETHALF(i,RtV))); } } */
;
void emit_A2_svadduhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATUN(16,fGETUHALF(i,RsV)+fGETUHALF(i,RtV))); } } */
;
void emit_A2_svsubh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(i,RtV)-fGETHALF(i,RsV)); } } */
;
void emit_A2_svsubhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATN(16,fGETHALF(i,RtV)-fGETHALF(i,RsV))); } } */
;
void emit_A2_svsubuhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATUN(16,fGETUHALF(i,RtV)-fGETUHALF(i,RsV))); } } */
;
void emit_A2_vraddub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; RddV = 0; for (i=0;i<4;i++) { fSETWORD(0,RddV,(fGETWORD(0,RddV) + (fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV)))); } for (i=4;i<8;i++) { fSETWORD(1,RddV,(fGETWORD(1,RddV) + (fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV)))); } } */
;
void emit_A2_vraddub_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + (fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV)))); } for (i = 4; i < 8; i++) { fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + (fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV)))); } } */
;
void emit_M2_vraddh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; RdV = 0; for (i=0;i<4;i++) { RdV += (fGETHALF(i,RssV)+fGETHALF(i,RttV)); } } */
;
void emit_M2_vradduh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; RdV = 0; for (i=0;i<4;i++) { RdV += (fGETUHALF(i,RssV)+fGETUHALF(i,RttV)); } } */
;
void emit_A2_vsubub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,(fGETUBYTE(i,RttV)-fGETUBYTE(i,RssV))); } } */
;
void emit_A2_vsububs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fSATUN(8,fGETUBYTE(i,RttV)-fGETUBYTE(i,RssV))); } } */
;
void emit_A2_vsubh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETHALF(i,RttV)-fGETHALF(i,RssV)); } } */
;
void emit_A2_vsubhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(16,fGETHALF(i,RttV)-fGETHALF(i,RssV))); } } */
;
void emit_A2_vsubuhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATUN(16,fGETUHALF(i,RttV)-fGETUHALF(i,RssV))); } } */
;
void emit_A2_vsubw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fGETWORD(i,RttV)-fGETWORD(i,RssV)); } } */
;
void emit_A2_vsubws(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(32,fGETWORD(i,RttV)-fGETWORD(i,RssV))); } } */
;
void emit_A2_vabsh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fABS(fGETHALF(i,RssV))); } } */
;
void emit_A2_vabshsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(16, fABS(fGETHALF(i,RssV)))); } } */
;
void emit_A2_vabsw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fABS(fGETWORD(i,RssV))); } } */
;
void emit_A2_vabswsat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(32, fABS(fGETWORD(i,RssV)))); } } */
;
void emit_M2_vabsdiffw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fABS(fGETWORD(i,RttV) - fGETWORD(i,RssV))); } } */
;
void emit_M2_vabsdiffh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fABS(fGETHALF(i,RttV) - fGETHALF(i,RssV))); } } */
;
void emit_M6_vabsdiffb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<8;i++) { fSETBYTE(i,RddV,fABS(fGETBYTE(i,RttV) - fGETBYTE(i,RssV))); } } */
;
void emit_M6_vabsdiffub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<8;i++) { fSETBYTE(i,RddV,fABS(fGETUBYTE(i,RttV) - fGETUBYTE(i,RssV))); } } */
;
void emit_A2_vrsadub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; RddV = 0; for (i = 0; i < 4; i++) { fSETWORD(0,RddV,(fGETWORD(0,RddV) + fABS((fGETUBYTE(i,RssV) - fGETUBYTE(i,RttV))))); } for (i = 4; i < 8; i++) { fSETWORD(1,RddV,(fGETWORD(1,RddV) + fABS((fGETUBYTE(i,RssV) - fGETUBYTE(i,RttV))))); } } */
;
void emit_A2_vrsadub_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 4; i++) { fSETWORD(0,RxxV,(fGETWORD(0,RxxV) + fABS((fGETUBYTE(i,RssV) - fGETUBYTE(i,RttV))))); } for (i = 4; i < 8; i++) { fSETWORD(1,RxxV,(fGETWORD(1,RxxV) + fABS((fGETUBYTE(i,RssV) - fGETUBYTE(i,RttV))))); } } */
;
void emit_A2_vavgub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,((fGETUBYTE(i,RssV) + fGETUBYTE(i,RttV))>>1)); } } */
;
void emit_A2_vavguh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,(fGETUHALF(i,RssV)+fGETUHALF(i,RttV))>>1); } } */
;
void emit_A2_vavgh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,(fGETHALF(i,RssV)+fGETHALF(i,RttV))>>1); } } */
;
void emit_A2_vnavgh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,(fGETHALF(i,RttV)-fGETHALF(i,RssV))>>1); } } */
;
void emit_A2_vavgw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fSXTN(32,33,fGETWORD(i,RssV))+fSXTN(32,33,fGETWORD(i,RttV)))>>1); } } */
;
void emit_A2_vnavgw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fSXTN(32,33,fGETWORD(i,RttV))-fSXTN(32,33,fGETWORD(i,RssV)))>>1); } } */
;
void emit_A2_vavgwr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fSXTN(32,33,fGETWORD(i,RssV))+fSXTN(32,33,fGETWORD(i,RttV))+1)>>1); } } */
;
void emit_A2_vnavgwr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(32, (fSXTN(32,33,fGETWORD(i,RttV))-fSXTN(32,33,fGETWORD(i,RssV))+1)>>1)); } } */
;
void emit_A2_vavgwcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fCRND(fSXTN(32,33,fGETWORD(i,RssV))+fSXTN(32,33,fGETWORD(i,RttV)))>>1)); } } */
;
void emit_A2_vnavgwcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(32, fCRND(fSXTN(32,33,fGETWORD(i,RttV))-fSXTN(32,33,fGETWORD(i,RssV)))>>1)); } } */
;
void emit_A2_vavghcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fCRND(fGETHALF(i,RssV)+fGETHALF(i,RttV))>>1); } } */
;
void emit_A2_vnavghcr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(16, fCRND(fGETHALF(i,RttV)-fGETHALF(i,RssV))>>1)); } } */
;
void emit_A2_vavguw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fZXTN(32,33,fGETUWORD(i,RssV))+fZXTN(32,33,fGETUWORD(i,RttV)))>>1); } } */
;
void emit_A2_vavguwr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fZXTN(32,33,fGETUWORD(i,RssV))+fZXTN(32,33,fGETUWORD(i,RttV))+1)>>1); } } */
;
void emit_A2_vavgubr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,((fGETUBYTE(i,RssV)+fGETUBYTE(i,RttV)+1)>>1)); } } */
;
void emit_A2_vavguhr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,(fGETUHALF(i,RssV)+fGETUHALF(i,RttV)+1)>>1); } } */
;
void emit_A2_vavghr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,(fGETHALF(i,RssV)+fGETHALF(i,RttV)+1)>>1); } } */
;
void emit_A2_vnavghr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(16, (fGETHALF(i,RttV)-fGETHALF(i,RssV)+1)>>1)); } } */
;
void emit_A4_round_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* {RdV = fRNDN(RsV,uiV)>>uiV; } */
;
void emit_A4_round_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV = fRNDN(RsV,fZXTN(5,32,RtV))>>fZXTN(5,32,RtV); } */
;
void emit_A4_round_ri_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* {RdV = (fSATN(32, fRNDN(RsV,uiV)))>>uiV; } */
;
void emit_A4_round_rr_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV = (fSATN(32, fRNDN(RsV,fZXTN(5,32,RtV))))>>fZXTN(5,32,RtV); } */
;
void emit_A4_cround_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* {RdV = fCRNDN(RsV,uiV); } */
;
void emit_A4_cround_rr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* {RdV = fCRNDN(RsV,fZXTN(5,32,RtV)); } */
;
void emit_A7_clip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { (RdV = fMIN((1 << uiV) - 1, fMAX(RsV, -(1 << uiV))));} */
;
void emit_A7_vclip(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { size4s_t tmp; (tmp = fMIN((1 << uiV) - 1, fMAX(fGETWORD(0, RssV), -(1 << uiV)))); fSETWORD(0, RddV, tmp); (tmp = fMIN((1 << uiV) - 1, fMAX(fGETWORD(1, RssV), -(1 << uiV)))); fSETWORD(1, RddV, tmp); } */
;
void emit_A4_vrminh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t min; size4s_t addr; min = fGETHALF(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 4; i++) { if (min > fGETHALF(i,RssV)) { min = fGETHALF(i,RssV); addr = RuV | i<<1; } } fSETWORD(0,RxxV,min); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrmaxh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t max; size4s_t addr; max = fGETHALF(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 4; i++) { if (max < fGETHALF(i,RssV)) { max = fGETHALF(i,RssV); addr = RuV | i<<1; } } fSETWORD(0,RxxV,max); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrminuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t min; size4s_t addr; min = fGETUHALF(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 4; i++) { if (min > fGETUHALF(i,RssV)) { min = fGETUHALF(i,RssV); addr = RuV | i<<1; } } fSETWORD(0,RxxV,min); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrmaxuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t max; size4s_t addr; max = fGETUHALF(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 4; i++) { if (max < fGETUHALF(i,RssV)) { max = fGETUHALF(i,RssV); addr = RuV | i<<1; } } fSETWORD(0,RxxV,max); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrminw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t min; size4s_t addr; min = fGETWORD(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 2; i++) { if (min > fGETWORD(i,RssV)) { min = fGETWORD(i,RssV); addr = RuV | i<<2; } } fSETWORD(0,RxxV,min); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrmaxw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t max; size4s_t addr; max = fGETWORD(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 2; i++) { if (max < fGETWORD(i,RssV)) { max = fGETWORD(i,RssV); addr = RuV | i<<2; } } fSETWORD(0,RxxV,max); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrminuw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t min; size4s_t addr; min = fGETUWORD(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 2; i++) { if (min > fGETUWORD(i,RssV)) { min = fGETUWORD(i,RssV); addr = RuV | i<<2; } } fSETWORD(0,RxxV,min); fSETWORD(1,RxxV,addr); } */
;
void emit_A4_vrmaxuw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RuV)
/* { int i; size8s_t max; size4s_t addr; max = fGETUWORD(0,RxxV); addr = fGETWORD(1,RxxV); for (i = 0; i < 2; i++) { if (max < fGETUWORD(i,RssV)) { max = fGETUWORD(i,RssV); addr = RuV | i<<2; } } fSETWORD(0,RxxV,max); fSETWORD(1,RxxV,addr); } */
;
void emit_A2_vminb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fMIN(fGETBYTE(i,RttV),fGETBYTE(i,RssV))); } } */
;
void emit_A2_vmaxb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fMAX(fGETBYTE(i,RttV),fGETBYTE(i,RssV))); } } */
;
void emit_A2_vminub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fMIN(fGETUBYTE(i,RttV),fGETUBYTE(i,RssV))); } } */
;
void emit_A2_vmaxub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBYTE(i,RddV,fMAX(fGETUBYTE(i,RttV),fGETUBYTE(i,RssV))); } } */
;
void emit_A2_vminh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 4; i++) { fSETHALF(i,RddV,fMIN(fGETHALF(i,RttV),fGETHALF(i,RssV))); } } */
;
void emit_A2_vmaxh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 4; i++) { fSETHALF(i,RddV,fMAX(fGETHALF(i,RttV),fGETHALF(i,RssV))); } } */
;
void emit_A2_vminuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 4; i++) { fSETHALF(i,RddV,fMIN(fGETUHALF(i,RttV),fGETUHALF(i,RssV))); } } */
;
void emit_A2_vmaxuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 4; i++) { fSETHALF(i,RddV,fMAX(fGETUHALF(i,RttV),fGETUHALF(i,RssV))); } } */
;
void emit_A2_vminw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 2; i++) { fSETWORD(i,RddV,fMIN(fGETWORD(i,RttV),fGETWORD(i,RssV))); } } */
;
void emit_A2_vmaxw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 2; i++) { fSETWORD(i,RddV,fMAX(fGETWORD(i,RttV),fGETWORD(i,RssV))); } } */
;
void emit_A2_vminuw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 2; i++) { fSETWORD(i,RddV,fMIN(fGETUWORD(i,RttV),fGETUWORD(i,RssV))); } } */
;
void emit_A2_vmaxuw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 2; i++) { fSETWORD(i,RddV,fMAX(fGETUWORD(i,RttV),fGETUWORD(i,RssV))); } } */
;
void emit_A6_vminub_RdP(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv PeV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i = 0; i < 8; i++) { fSETBIT(i, PeV, (fGETUBYTE(i,RttV) > fGETUBYTE(i,RssV))); fSETBYTE(i,RddV,fMIN(fGETUBYTE(i,RttV),fGETUBYTE(i,RssV))); } } */
;
void emit_A4_modwrapu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { if (RsV < 0) { RdV = RsV + fCAST4u(RtV); } else if (fCAST4u(RsV) >= fCAST4u(RtV)) { RdV = RsV - fCAST4u(RtV); } else { RdV = RsV; } } */
;
void emit_F2_sfimm_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* { RdV = (127 - 6) << 23; RdV += uiV << 17; } */
;
void emit_F2_sfimm_n(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* { RdV = (127 - 6) << 23; RdV += (uiV << 17); RdV |= (1 << 31); } */
;
void emit_F2_dfmpyll(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { size8u_t prod; prod = fMPY32UU(fGETUWORD(0,RssV),fGETUWORD(0,RttV)); RddV = (prod >> 32) << 1; if (fGETUWORD(0,prod) != 0) fSETBIT(0,RddV,1); } */
;
void emit_F2_dfmpylh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RxxV += (fGETUWORD(0,RssV) * (0x00100000 | fZXTN(20,64,fGETUWORD(1,RttV)))) << 1; } */
;
void emit_F2_dfimm_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { RddV = (1023ULL - 6) << 52; RddV += ((size8u_t)uiV) << 46; } */
;
void emit_F2_dfimm_n(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { RddV = (1023ULL - 6) << 52; RddV += ((size8u_t)uiV) << 46; RddV |= ((1ULL) << 63); } */
;
void emit_S2_asr_r_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RdV = fECHO( ((shamt > 0) ? (fCAST4_8s(RsV) >> shamt) : (fCAST4_8s(RsV) << -shamt))); } */
;
void emit_S2_asl_r_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RdV = fECHO( ((shamt > 0) ? (fCAST4_8s(RsV) << shamt) : (fCAST4_8s(RsV) >> -shamt))); } */
;
void emit_S2_lsr_r_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RdV = fECHO( (((shamt) < 0) ? ((fCAST4_8u(RsV) << ((-(shamt)) - 1)) << 1) : (fCAST4_8u(RsV) >> (shamt)))); } */
;
void emit_S2_lsl_r_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RdV = fECHO( ((shamt > 0) ? (fCAST4_8u(RsV) << shamt) : (fCAST4_8u(RsV) >>> -shamt))); } */
;
void emit_S2_asr_r_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RddV = fECHO( ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RddV = fECHO( ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RddV = fECHO( (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RddV = fECHO( ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_r_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV + ((shamt > 0) ? (fCAST4_8s(RsV) >> shamt) : (fCAST4_8s(RsV) << -shamt))); } */
;
void emit_S2_asl_r_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV + ((shamt > 0) ? (fCAST4_8s(RsV) << shamt) : (fCAST4_8s(RsV) >> -shamt))); } */
;
void emit_S2_lsr_r_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV + (((shamt) < 0) ? ((fCAST4_8u(RsV) << ((-(shamt)) - 1)) << 1) : (fCAST4_8u(RsV) >> (shamt)))); } */
;
void emit_S2_lsl_r_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV + ((shamt > 0) ? (fCAST4_8u(RsV) << shamt) : (fCAST4_8u(RsV) >>> -shamt))); } */
;
void emit_S2_asr_r_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV + ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV + ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV + (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV + ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_r_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV - ((shamt > 0) ? (fCAST4_8s(RsV) >> shamt) : (fCAST4_8s(RsV) << -shamt))); } */
;
void emit_S2_asl_r_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV - ((shamt > 0) ? (fCAST4_8s(RsV) << shamt) : (fCAST4_8s(RsV) >> -shamt))); } */
;
void emit_S2_lsr_r_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV - (((shamt) < 0) ? ((fCAST4_8u(RsV) << ((-(shamt)) - 1)) << 1) : (fCAST4_8u(RsV) >> (shamt)))); } */
;
void emit_S2_lsl_r_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV - ((shamt > 0) ? (fCAST4_8u(RsV) << shamt) : (fCAST4_8u(RsV) >>> -shamt))); } */
;
void emit_S2_asr_r_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV - ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV - ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV - (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV - ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_r_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV & ((shamt > 0) ? (fCAST4_8s(RsV) >> shamt) : (fCAST4_8s(RsV) << -shamt))); } */
;
void emit_S2_asl_r_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV & ((shamt > 0) ? (fCAST4_8s(RsV) << shamt) : (fCAST4_8s(RsV) >> -shamt))); } */
;
void emit_S2_lsr_r_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV & (((shamt) < 0) ? ((fCAST4_8u(RsV) << ((-(shamt)) - 1)) << 1) : (fCAST4_8u(RsV) >> (shamt)))); } */
;
void emit_S2_lsl_r_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV & ((shamt > 0) ? (fCAST4_8u(RsV) << shamt) : (fCAST4_8u(RsV) >>> -shamt))); } */
;
void emit_S2_asr_r_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV | ((shamt > 0) ? (fCAST4_8s(RsV) >> shamt) : (fCAST4_8s(RsV) << -shamt))); } */
;
void emit_S2_asl_r_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV | ((shamt > 0) ? (fCAST4_8s(RsV) << shamt) : (fCAST4_8s(RsV) >> -shamt))); } */
;
void emit_S2_lsr_r_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV | (((shamt) < 0) ? ((fCAST4_8u(RsV) << ((-(shamt)) - 1)) << 1) : (fCAST4_8u(RsV) >> (shamt)))); } */
;
void emit_S2_lsl_r_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxV = fECHO(RxV | ((shamt > 0) ? (fCAST4_8u(RsV) << shamt) : (fCAST4_8u(RsV) >>> -shamt))); } */
;
void emit_S2_asr_r_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV & ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV & ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV & (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV & ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_r_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV | ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV | ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV | (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV | ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_r_p_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV ^ ((shamt > 0) ? (fCAST8_8s(RssV) >> shamt) : (fCAST8_8s(RssV) << -shamt))); } */
;
void emit_S2_asl_r_p_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV ^ ((shamt > 0) ? (fCAST8_8s(RssV) << shamt) : (fCAST8_8s(RssV) >> -shamt))); } */
;
void emit_S2_lsr_r_p_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV ^ (((shamt) < 0) ? ((fCAST8_8u(RssV) << ((-(shamt)) - 1)) << 1) : (fCAST8_8u(RssV) >> (shamt)))); } */
;
void emit_S2_lsl_r_p_xor(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { size4s_t shamt=fSXTN(7,32,RtV); RxxV = fECHO(RxxV ^ ((shamt > 0) ? (fCAST8_8u(RssV) << shamt) : (fCAST8_8u(RssV) >>> -shamt))); } */
;
void emit_S2_asr_i_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = fECHO( (fCAST4_4s(RsV) >> uiV)); } */
;
void emit_S2_lsr_i_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = fECHO( (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = fECHO( (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = fECHO( fROTL(RsV, uiV)); } */
;
void emit_S2_asr_i_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { RddV = fECHO( (fCAST8_8s(RssV) >> uiV)); } */
;
void emit_S2_lsr_i_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { RddV = fECHO( (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { RddV = fECHO( (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { RddV = fECHO( fROTL(RssV, uiV)); } */
;
void emit_S2_asr_i_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV + (fCAST4_4s(RsV) >> uiV)); } */
;
void emit_S2_lsr_i_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV + (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV + (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV + fROTL(RsV, uiV)); } */
;
void emit_S2_asr_i_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV + (fCAST8_8s(RssV) >> uiV)); } */
;
void emit_S2_lsr_i_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV + (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV + (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p_acc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV + fROTL(RssV, uiV)); } */
;
void emit_S2_asr_i_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV - (fCAST4_4s(RsV) >> uiV)); } */
;
void emit_S2_lsr_i_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV - (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV - (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV - fROTL(RsV, uiV)); } */
;
void emit_S2_asr_i_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV - (fCAST8_8s(RssV) >> uiV)); } */
;
void emit_S2_lsr_i_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV - (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV - (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p_nac(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV - fROTL(RssV, uiV)); } */
;
void emit_S2_lsr_i_r_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV ^ (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV ^ (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV ^ fROTL(RsV, uiV)); } */
;
void emit_S2_lsr_i_p_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV ^ (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV ^ (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p_xacc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV ^ fROTL(RssV, uiV)); } */
;
void emit_S2_asr_i_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV & (fCAST4_4s(RsV) >> uiV)); } */
;
void emit_S2_lsr_i_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV & (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV & (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV & fROTL(RsV, uiV)); } */
;
void emit_S2_asr_i_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV | (fCAST4_4s(RsV) >> uiV)); } */
;
void emit_S2_lsr_i_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV | (RsV >>> uiV)); } */
;
void emit_S2_asl_i_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV | (fCAST4_4s(RsV) << uiV)); } */
;
void emit_S6_rol_i_r_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV)
/* { RxV = fECHO(RxV | fROTL(RsV, uiV)); } */
;
void emit_S2_asr_i_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV & (fCAST8_8s(RssV) >> uiV)); } */
;
void emit_S2_lsr_i_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV & (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV & (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p_and(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV & fROTL(RssV, uiV)); } */
;
void emit_S2_asr_i_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV | (fCAST8_8s(RssV) >> uiV)); } */
;
void emit_S2_lsr_i_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV | (RssV >>> uiV)); } */
;
void emit_S2_asl_i_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV | (fCAST8_8s(RssV) << uiV)); } */
;
void emit_S6_rol_i_p_or(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV)
/* { RxxV = fECHO(RxxV | fROTL(RssV, uiV)); } */
;
void emit_S2_asl_i_r_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = fSATN(32, (fCAST4_8s(RsV) << uiV)); } */
;
void emit_S2_asr_i_r_rnd(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = (fCAST8_8s((((fCAST4_8s(RsV) >> uiV))+1)) >> 1); } */
;
void emit_S2_asr_i_p_rnd(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { size8u_t tmp; size8u_t rnd; tmp = (fCAST8_8s(RssV) >> uiV); rnd = tmp & 1; RddV = (fCAST8_8s(tmp) >> 1) + rnd; } */
;
void emit_S4_lsli(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, int siV)
/* { size4s_t shamt = fSXTN(7,32,RtV); RdV = ((shamt > 0) ? (fCAST4_8u(siV) << shamt) : (fCAST4_8u(siV) >>> -shamt)); } */
;
void emit_S2_addasl_rrri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RtV, TCGv_i32 RsV, int uiV)
/* { RdV = RtV + (fCAST4_4s(RsV) << uiV); } */
;
void emit_S4_andi_asl_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)&(RxV<<UiV);} */
;
void emit_S4_ori_asl_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)|(RxV<<UiV);} */
;
void emit_S4_addi_asl_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)+(RxV<<UiV);} */
;
void emit_S4_subi_asl_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)-(RxV<<UiV);} */
;
void emit_S4_andi_lsr_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)&(((unsigned int)RxV)>>UiV);} */
;
void emit_S4_ori_lsr_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)|(((unsigned int)RxV)>>UiV);} */
;
void emit_S4_addi_lsr_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)+(((unsigned int)RxV)>>UiV);} */
;
void emit_S4_subi_lsr_ri(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int uiV, int UiV)
/* {RxV=fIMMEXT(uiV)-(((unsigned int)RxV)>>UiV);} */
;
void emit_S2_valignib(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV, int uiV)
/* { RddV = ((RssV >>> uiV*8))|((fCAST8_8s(RttV) << ((8-uiV)*8))); } */
;
void emit_S2_valignrb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV, TCGv PuV)
/* { RddV = (RssV >>> (PuV&0x7)*8)|((fCAST8_8s(RttV) << (8-(PuV&0x7))*8));} */
;
void emit_S2_vspliceib(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV, int uiV)
/* { RddV = (fCAST8_8s(RttV) << uiV*8) | fZXTN(uiV*8,64,RssV); } */
;
void emit_S2_vsplicerb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV, TCGv PuV)
/* { RddV = (fCAST8_8s(RttV) << (PuV&7)*8) | fZXTN((PuV&7)*8,64,RssV); } */
;
void emit_S2_vsplatrh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, fGETHALF(0,RsV)); } } */
;
void emit_S2_vsplatrb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV, fGETBYTE(0,RsV)); } } */
;
void emit_S6_vsplatrbp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<8;i++) { fSETBYTE(i,RddV, fGETBYTE(0,RsV)); } } */
;
void emit_S2_tableidxb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV, int SiV)
/* { int width=uiV; int offset=SiV; int field = (fZXTN(width, 32, ((((offset)) < 0) ? ((fCAST4_8u((RsV)) << ((-((offset))) - 1)) << 1) : (fCAST4_8u((RsV)) >> ((offset)))))); fINSERT_BITS(RxV,width,0,field); } */
;
void emit_S2_tableidxh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV, int SiV)
/* { int width=uiV; int offset=SiV+1; int field = (fZXTN(width, 32, ((((offset)) < 0) ? ((fCAST4_8u((RsV)) << ((-((offset))) - 1)) << 1) : (fCAST4_8u((RsV)) >> ((offset)))))); fINSERT_BITS(RxV,width,1,field); } */
;
void emit_S2_tableidxw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV, int SiV)
/* { int width=uiV; int offset=SiV+2; int field = (fZXTN(width, 32, ((((offset)) < 0) ? ((fCAST4_8u((RsV)) << ((-((offset))) - 1)) << 1) : (fCAST4_8u((RsV)) >> ((offset)))))); fINSERT_BITS(RxV,width,2,field); } */
;
void emit_S2_tableidxd(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV, int uiV, int SiV)
/* { int width=uiV; int offset=SiV+3; int field = (fZXTN(width, 32, ((((offset)) < 0) ? ((fCAST4_8u((RsV)) << ((-((offset))) - 1)) << 1) : (fCAST4_8u((RsV)) >> ((offset)))))); fINSERT_BITS(RxV,width,3,field); } */
;
void emit_A4_bitspliti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, int uiV)
/* { fSETWORD(1,RddV,(fCAST4_4u(RsV)>>uiV)); fSETWORD(0,RddV,fZXTN(uiV,32,RsV)); } */
;
void emit_A4_bitsplit(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { size4u_t shamt = fZXTN(5,32,RtV); fSETWORD(1,RddV,(fCAST4_4u(RsV)>>shamt)); fSETWORD(0,RddV,fZXTN(shamt,32,RsV)); } */
;
void emit_S4_extract(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV, int UiV)
/* { int width=uiV; int offset=UiV; RdV = fSXTN(width,32,(fCAST4_4u(RsV) >> offset)); } */
;
void emit_S2_extractu(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV, int UiV)
/* { int width=uiV; int offset=UiV; RdV = fZXTN(width,32,(fCAST4_4u(RsV) >> offset)); } */
;
void emit_S2_insertp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, int uiV, int UiV)
/* { int width=uiV; int offset=UiV; RxxV &= ~(((fCONSTLL(1)<<width)-1)<<offset); RxxV |= ((RssV & ((fCONSTLL(1)<<width)-1)) << offset); } */
;
void emit_S4_extractp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV, int UiV)
/* { int width=uiV; int offset=UiV; RddV = fSXTN(width,64,(fCAST8_8u(RssV) >> offset)); } */
;
void emit_S2_extractup(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV, int UiV)
/* { int width=uiV; int offset=UiV; RddV = fZXTN(width,64,(fCAST8_8u(RssV) >> offset)); } */
;
void emit_S2_mask(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV, int UiV)
/* { RdV = ((1<<uiV)-1) << UiV; } */
;
void emit_S4_extract_rp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i64 RttV)
/* { int width=fZXTN(6,32,(fGETWORD(1,RttV))); int offset=fSXTN(7,32,(fGETWORD(0,RttV))); RdV = fSXTN(width,64,(((offset) < 0) ? ((fCAST4_8u(fCAST4_8u(RsV)) << ((-(offset)) - 1)) << 1) : (fCAST4_8u(fCAST4_8u(RsV)) >> (offset)))); } */
;
void emit_S2_extractu_rp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i64 RttV)
/* { int width=fZXTN(6,32,(fGETWORD(1,RttV))); int offset=fSXTN(7,32,(fGETWORD(0,RttV))); RdV = fZXTN(width,64,(((offset) < 0) ? ((fCAST4_8u(fCAST4_8u(RsV)) << ((-(offset)) - 1)) << 1) : (fCAST4_8u(fCAST4_8u(RsV)) >> (offset)))); } */
;
void emit_S2_insertp_rp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RxxV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int width=fZXTN(6,32,(fGETWORD(1,RttV))); int offset=fSXTN(7,32,(fGETWORD(0,RttV))); size8u_t mask = ((fCONSTLL(1)<<width)-1); if (offset < 0) { RxxV = 0; } else { RxxV &= ~(mask<<offset); RxxV |= ((RssV & mask) << offset); } } */
;
void emit_S4_extractp_rp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int width=fZXTN(6,32,(fGETWORD(1,RttV))); int offset=fSXTN(7,32,(fGETWORD(0,RttV))); RddV = fSXTN(width,64,(((offset) < 0) ? ((fCAST8_8u(fCAST8_8u(RssV)) << ((-(offset)) - 1)) << 1) : (fCAST8_8u(fCAST8_8u(RssV)) >> (offset)))); } */
;
void emit_S2_extractup_rp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int width=fZXTN(6,32,(fGETWORD(1,RttV))); int offset=fSXTN(7,32,(fGETWORD(0,RttV))); RddV = fZXTN(width,64,(((offset) < 0) ? ((fCAST8_8u(fCAST8_8u(RssV)) << ((-(offset)) - 1)) << 1) : (fCAST8_8u(fCAST8_8u(RssV)) >> (offset)))); } */
;
void emit_S2_tstbit_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { PdV = (((RsV & (1<<uiV)) != 0) ? 0xff : 0x00); } */
;
void emit_S4_ntstbit_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, int uiV)
/* { PdV = (((RsV & (1<<uiV)) == 0) ? 0xff : 0x00); } */
;
void emit_S2_setbit_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = (RsV | (1<<uiV)); } */
;
void emit_S2_togglebit_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = (RsV ^ (1<<uiV)); } */
;
void emit_S2_clrbit_i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* { RdV = (RsV & (~(1<<uiV))); } */
;
void emit_S2_tstbit_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV = (((fCAST4_8u(RsV) & ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(1) << fSXTN(7,32,RtV)) : (fCAST4_8u(1) >>> -fSXTN(7,32,RtV)))) != 0) ? 0xff : 0x00); } */
;
void emit_S4_ntstbit_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv PdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { PdV = (((fCAST4_8u(RsV) & ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(1) << fSXTN(7,32,RtV)) : (fCAST4_8u(1) >>> -fSXTN(7,32,RtV)))) == 0) ? 0xff : 0x00); } */
;
void emit_S2_setbit_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = (RsV | ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(1) << fSXTN(7,32,RtV)) : (fCAST4_8u(1) >>> -fSXTN(7,32,RtV)))); } */
;
void emit_S2_togglebit_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = (RsV ^ ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(1) << fSXTN(7,32,RtV)) : (fCAST4_8u(1) >>> -fSXTN(7,32,RtV)))); } */
;
void emit_S2_clrbit_r(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = (RsV & (~(((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(1) << fSXTN(7,32,RtV)) : (fCAST4_8u(1) >>> -fSXTN(7,32,RtV)))))); } */
;
void emit_S2_asr_i_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, (fGETHALF(i,RssV)>>uiV)); } } */
;
void emit_S2_lsr_i_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, (fGETUHALF(i,RssV)>>uiV)); } } */
;
void emit_S2_asl_i_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, (fGETHALF(i,RssV)<<uiV)); } } */
;
void emit_S2_asr_r_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fSXTN(16, 64, fGETHALF(i,RssV)) >> fSXTN(7,32,RtV)) : (fSXTN(16, 64, fGETHALF(i,RssV)) << -fSXTN(7,32,RtV)))); } } */
;
void emit_S5_asrhub_rnd_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV, fSATUN(8, ((fGETHALF(i,RssV) >> uiV )+1)>>1)); } } */
;
void emit_S5_asrhub_sat(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV, fSATUN(8, fGETHALF(i,RssV) >> uiV)); } } */
;
void emit_S5_vasrhrnd(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, ( ((fGETHALF(i,RssV) >> uiV)+1)>>1 )); } } */
;
void emit_S2_asl_r_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fSXTN(16, 64, fGETHALF(i,RssV)) << fSXTN(7,32,RtV)) : (fSXTN(16, 64, fGETHALF(i,RssV)) >> -fSXTN(7,32,RtV)))); } } */
;
void emit_S2_lsr_r_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, (((fSXTN(7,32,RtV)) < 0) ? ((fZXTN(16, 64, fGETUHALF(i,RssV)) << ((-(fSXTN(7,32,RtV))) - 1)) << 1) : (fZXTN(16, 64, fGETUHALF(i,RssV)) >> (fSXTN(7,32,RtV))))); } } */
;
void emit_S2_lsl_r_vh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fZXTN(16, 64, fGETUHALF(i,RssV)) << fSXTN(7,32,RtV)) : (fZXTN(16, 64, fGETUHALF(i,RssV)) >>> -fSXTN(7,32,RtV)))); } } */
;
void emit_S2_asr_i_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fGETWORD(i,RssV)>>uiV)); } } */
;
void emit_S2_asr_i_svw_trun(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(0,(fGETWORD(i,RssV)>>uiV))); } } */
;
void emit_S2_lsr_i_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fGETUWORD(i,RssV)>>uiV)); } } */
;
void emit_S2_asl_i_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, int uiV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,(fGETWORD(i,RssV)<<uiV)); } } */
;
void emit_S2_asr_r_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8s(fGETWORD(i,RssV)) >> fSXTN(7,32,RtV)) : (fCAST4_8s(fGETWORD(i,RssV)) << -fSXTN(7,32,RtV)))); } } */
;
void emit_S2_asl_r_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8s(fGETWORD(i,RssV)) << fSXTN(7,32,RtV)) : (fCAST4_8s(fGETWORD(i,RssV)) >> -fSXTN(7,32,RtV)))); } } */
;
void emit_S2_lsr_r_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV, (((fSXTN(7,32,RtV)) < 0) ? ((fCAST4_8u(fGETUWORD(i,RssV)) << ((-(fSXTN(7,32,RtV))) - 1)) << 1) : (fCAST4_8u(fGETUWORD(i,RssV)) >> (fSXTN(7,32,RtV))))); } } */
;
void emit_S2_lsl_r_vw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i32 RtV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV, ((fSXTN(7,32,RtV) > 0) ? (fCAST4_8u(fGETUWORD(i,RssV)) << fSXTN(7,32,RtV)) : (fCAST4_8u(fGETUWORD(i,RssV)) >>> -fSXTN(7,32,RtV)))); } } */
;
void emit_S2_vrndpackwh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(1,(fGETWORD(i,RssV)+0x08000))); } } */
;
void emit_S2_vrndpackwhs(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(1,fSATN(32, fGETWORD(i,RssV)+0x08000))); } } */
;
void emit_S2_vsxtbh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETBYTE(i,RsV)); } } */
;
void emit_S2_vzxtbh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fGETUBYTE(i,RsV)); } } */
;
void emit_S2_vsathub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV,fSATUN(8,fGETHALF(i,RssV))); } } */
;
void emit_S2_svsathub(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { fSETBYTE(0,RdV,fSATUN(8,fGETHALF(0,RsV))); fSETBYTE(1,RdV,fSATUN(8,fGETHALF(1,RsV))); fSETBYTE(2,RdV,0); fSETBYTE(3,RdV,0); } */
;
void emit_S2_svsathb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { fSETBYTE(0,RdV,fSATN(8,fGETHALF(0,RsV))); fSETBYTE(1,RdV,fSATN(8,fGETHALF(1,RsV))); fSETBYTE(2,RdV,0); fSETBYTE(3,RdV,0); } */
;
void emit_S2_vsathb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV,fSATN(8,fGETHALF(i,RssV))); } } */
;
void emit_S2_vtrunohb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV,fGETBYTE(i*2+1,RssV)); } } */
;
void emit_S2_vtrunewh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fGETHALF(0,RttV)); fSETHALF(1,RddV,fGETHALF(2,RttV)); fSETHALF(2,RddV,fGETHALF(0,RssV)); fSETHALF(3,RddV,fGETHALF(2,RssV)); } */
;
void emit_S2_vtrunowh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { fSETHALF(0,RddV,fGETHALF(1,RttV)); fSETHALF(1,RddV,fGETHALF(3,RttV)); fSETHALF(2,RddV,fGETHALF(1,RssV)); fSETHALF(3,RddV,fGETHALF(3,RssV)); } */
;
void emit_S2_vtrunehb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RdV,fGETBYTE(i*2,RssV)); } } */
;
void emit_S6_vtrunehb_ppp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RddV,fGETBYTE(i*2,RttV)); fSETBYTE(i+4,RddV,fGETBYTE(i*2,RssV)); } } */
;
void emit_S6_vtrunohb_ppp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i,RddV,fGETBYTE(i*2+1,RttV)); fSETBYTE(i+4,RddV,fGETBYTE(i*2+1,RssV)); } } */
;
void emit_S2_vsxthw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fGETHALF(i,RsV)); } } */
;
void emit_S2_vzxthw(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fGETUHALF(i,RsV)); } } */
;
void emit_S2_vsatwh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATN(16,fGETWORD(i,RssV))); } } */
;
void emit_S2_vsatwuh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i,RdV,fSATUN(16,fGETWORD(i,RssV))); } } */
;
void emit_S2_packhl(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { fSETHALF(0,RddV,fGETHALF(0,RtV)); fSETHALF(1,RddV,fGETHALF(0,RsV)); fSETHALF(2,RddV,fGETHALF(1,RtV)); fSETHALF(3,RddV,fGETHALF(1,RsV)); } */
;
void emit_S2_vsathub_nopack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATUN(8,fGETHALF(i,RssV))); } } */
;
void emit_S2_vsathb_nopack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETHALF(i,RddV,fSATN(8,fGETHALF(i,RssV))); } } */
;
void emit_S2_vsatwh_nopack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATN(16,fGETWORD(i,RssV))); } } */
;
void emit_S2_vsatwuh_nopack(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETWORD(i,RddV,fSATUN(16,fGETWORD(i,RssV))); } } */
;
void emit_S2_shuffob(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i*2 ,RddV,fGETBYTE(i*2+1,RssV)); fSETBYTE(i*2+1,RddV,fGETBYTE(i*2+1,RttV)); } } */
;
void emit_S2_shuffeb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<4;i++) { fSETBYTE(i*2 ,RddV,fGETBYTE(i*2,RttV)); fSETBYTE(i*2+1,RddV,fGETBYTE(i*2,RssV)); } } */
;
void emit_S2_shuffoh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RttV, TCGv_i64 RssV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i*2 ,RddV,fGETHALF(i*2+1,RssV)); fSETHALF(i*2+1,RddV,fGETHALF(i*2+1,RttV)); } } */
;
void emit_S2_shuffeh(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { int i; for (i=0;i<2;i++) { fSETHALF(i*2 ,RddV,fGETHALF(i*2,RttV)); fSETHALF(i*2+1,RddV,fGETHALF(i*2,RssV)); } } */
;
void emit_S5_popcountp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { RdV = fCOUNTONES_8(RssV); } */
;
void emit_S4_parity(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, TCGv_i32 RtV)
/* { RdV = 1&fCOUNTONES_4(RsV & RtV); } */
;
void emit_S2_parityp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RdV = 1&fCOUNTONES_8(RssV & RttV); } */
;
void emit_S2_lfsp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i64 RssV, TCGv_i64 RttV)
/* { RddV = (fCAST8u(RssV) >> 1) | (fCAST8u((1&fCOUNTONES_8(RssV & RttV)))<<63) ; } */
;
void emit_S2_clbnorm(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { if (RsV == 0) { RdV = 0; } else { RdV = (fMAX(fCL1_4(RsV),fCL1_4(~RsV)))-1;} } */
;
void emit_S4_clbaddi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int siV)
/* { RdV = (fMAX(fCL1_4(RsV),fCL1_4(~RsV)))+siV;} */
;
void emit_S4_clbpnorm(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* { if (RssV == 0) { RdV = 0; } else { RdV = (fMAX(fCL1_8(RssV),fCL1_8(~RssV)))-1;}} */
;
void emit_S4_clbpaddi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV, int siV)
/* { RdV = (fMAX(fCL1_8(RssV),fCL1_8(~RssV)))+siV;} */
;
void emit_S2_clb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fMAX(fCL1_4(RsV),fCL1_4(~RsV));} */
;
void emit_S2_cl0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fCL1_4(~RsV);} */
;
void emit_S2_cl1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* {RdV = fCL1_4(RsV);} */
;
void emit_S2_clbp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* {RdV = fMAX(fCL1_8(RssV),fCL1_8(~RssV));} */
;
void emit_S2_cl0p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* {RdV = fCL1_8(~RssV);} */
;
void emit_S2_cl1p(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i64 RssV)
/* {RdV = fCL1_8(RssV);} */
;
void emit_SA1_addi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, int siV)
/* { fIMMEXT(siV); RxV=RxV+siV;} */
;
void emit_SA1_tfr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV;} */
;
void emit_SA1_seti(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* { fIMMEXT(uiV); RdV=uiV;} */
;
void emit_SA1_setin1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV)
/* { RdV=-1;} */
;
void emit_SA1_clrtnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV)
/* { if (fLSBNEW(P0N)) {RdV=0;} else {CANCEL;} } */
;
void emit_SA1_clrfnew(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV)
/* { if (fLSBNEW(~P0N)) {RdV=0;} else {CANCEL;} } */
;
void emit_SA1_clrt(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV)
/* { if ((fGETBIT(0, fREAD_P0()))) {RdV=0;} else {CANCEL;} } */
;
void emit_SA1_clrf(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV)
/* { if (fGETBIT(0, ~fREAD_P0())) {RdV=0;} else {CANCEL;} } */
;
void emit_SA1_addsp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* { RdV=fREAD_SP()+uiV; } */
;
void emit_SA1_inc(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV+1;} */
;
void emit_SA1_dec(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV=RsV-1;} */
;
void emit_SA1_addrx(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RxV, TCGv_i32 RsV)
/* { RxV=RxV+RsV; } */
;
void emit_SA1_zxtb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV= fZXTN(8,32,RsV);} */
;
void emit_SA1_and1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV= RsV&1;} */
;
void emit_SA1_sxtb(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV= fSXTN(8,32,RsV);} */
;
void emit_SA1_zxth(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV= fZXTN(16,32,RsV);} */
;
void emit_SA1_sxth(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV)
/* { RdV= fSXTN(16,32,RsV);} */
;
void emit_SA1_combinezr(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { fSETWORD(0,RddV,RsV); fSETWORD(1,RddV,0); } */
;
void emit_SA1_combinerz(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, TCGv_i32 RsV)
/* { fSETWORD(0,RddV,0); fSETWORD(1,RddV,RsV); } */
;
void emit_SA1_combine0i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { fSETWORD(0,RddV,uiV); fSETWORD(1,RddV,0); } */
;
void emit_SA1_combine1i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { fSETWORD(0,RddV,uiV); fSETWORD(1,RddV,1); } */
;
void emit_SA1_combine2i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { fSETWORD(0,RddV,uiV); fSETWORD(1,RddV,2); } */
;
void emit_SA1_combine3i(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* { fSETWORD(0,RddV,uiV); fSETWORD(1,RddV,3); } */
;
void emit_SA1_cmpeqi(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV)
/* {P0 = ((RsV==uiV) ? 0xff : 0x00);;} */
;
void emit_SL1_loadri_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_SL1_loadrub_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fLOAD(1,1,u,EA,RdV);} */
;
void emit_SL2_loadrh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fLOAD(1,2,s,EA,RdV);} */
;
void emit_SL2_loadruh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fLOAD(1,2,u,EA,RdV);} */
;
void emit_SL2_loadrb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fLOAD(1,1,s,EA,RdV);} */
;
void emit_SL2_loadri_sp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RdV, int uiV)
/* size4u_t EA; {(EA = fREAD_SP() + uiV); fLOAD(1,4,u,EA,RdV);} */
;
void emit_SL2_loadrd_sp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RddV, int uiV)
/* size4u_t EA; {(EA = fREAD_SP() + uiV); fLOAD(1,8,u,EA,RddV);} */
;
void emit_SL2_deallocframe(DisasContext *ctx, Insn *insn, Packet *pkt)
/* size4u_t EA; { size8u_t tmp; (EA = fREAD_FP()); fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); (LR = fGETWORD(1,tmp)); (FP = fGETWORD(0,tmp)); (SP = EA+8); } */
;
void emit_SS1_storew_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,4,EA,RtV);} */
;
void emit_SS1_storeb_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,1,EA,fGETBYTE(0,RtV));} */
;
void emit_SS2_storeh_io(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,2,EA,fGETHALF(0,RtV));} */
;
void emit_SS2_stored_sp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i64 RttV, int siV)
/* size4u_t EA; {(EA = fREAD_SP() + siV); fSTORE(1,8,EA,RttV);} */
;
void emit_SS2_storew_sp(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RtV, int uiV)
/* size4u_t EA; {(EA = fREAD_SP() + uiV); fSTORE(1,4,EA,RtV);} */
;
void emit_SS2_storewi0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,4,EA,0);} */
;
void emit_SS2_storebi0(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,1,EA,0);} */
;
void emit_SS2_storewi1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,4,EA,1);} */
;
void emit_SS2_storebi1(DisasContext *ctx, Insn *insn, Packet *pkt, TCGv_i32 RsV, int uiV)
/* size4u_t EA; {(EA = RsV + uiV); fSTORE(1,1,EA,1);} */
;
void emit_SS2_allocframe(DisasContext *ctx, Insn *insn, Packet *pkt, int uiV)
/* size4u_t EA; { (EA = fREAD_SP() + -8); fSTORE(1,8,EA,fFRAME_SCRAMBLE((fCAST8_8u(fREAD_LR()) << 32) | fCAST4_4u(fREAD_FP()))); (FP = EA); fFRAMECHECK(EA-uiV,EA); (SP = EA-uiV); } */
;
#endif /* HEX_EMITTER_h */
