/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 81;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  void runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s32,
  GILLT_p0s64,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 32),
  LLT::pointer(0, 64),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbopBit = 61,
  Feature_HasStdExtZicondBit = 62,
  Feature_HasStdExtMBit = 17,
  Feature_HasStdExtMOrZmmulBit = 16,
  Feature_HasStdExtABit = 19,
  Feature_HasStdExtZtsoBit = 21,
  Feature_NotHasStdExtZtsoBit = 20,
  Feature_HasStdExtZacasBit = 23,
  Feature_NoStdExtZacasBit = 22,
  Feature_HasStdExtFBit = 6,
  Feature_HasStdExtDBit = 8,
  Feature_HasStdExtZfhminBit = 24,
  Feature_HasStdExtZfhBit = 10,
  Feature_NoStdExtZfhBit = 26,
  Feature_HasStdExtZfbfminBit = 28,
  Feature_HasStdExtZfaBit = 29,
  Feature_HasStdExtZfinxBit = 7,
  Feature_HasStdExtZdinxBit = 9,
  Feature_HasStdExtZhinxminBit = 25,
  Feature_HasStdExtZhinxBit = 11,
  Feature_NoStdExtZhinxBit = 27,
  Feature_HasStdExtCBit = 13,
  Feature_HasStdExtZbaBit = 34,
  Feature_NotHasStdExtZbaBit = 15,
  Feature_HasStdExtZbbBit = 32,
  Feature_HasStdExtZbcBit = 36,
  Feature_HasStdExtZbsBit = 31,
  Feature_HasStdExtZbkbBit = 33,
  Feature_HasStdExtZbkxBit = 37,
  Feature_HasStdExtZbbOrZbkbBit = 30,
  Feature_HasStdExtZbcOrZbkcBit = 35,
  Feature_HasStdExtZkndBit = 38,
  Feature_HasStdExtZkneBit = 40,
  Feature_HasStdExtZkndOrZkneBit = 39,
  Feature_HasStdExtZknhBit = 41,
  Feature_HasStdExtZksedBit = 42,
  Feature_HasStdExtZkshBit = 43,
  Feature_HasStdExtZvfbfwmaBit = 49,
  Feature_HasStdExtZvkbBit = 53,
  Feature_HasStdExtZvbbBit = 52,
  Feature_HasStdExtZvbcBit = 57,
  Feature_HasStdExtZvkgBit = 54,
  Feature_HasStdExtZvknedBit = 55,
  Feature_HasStdExtZvknhaBit = 58,
  Feature_HasStdExtZvknhbBit = 59,
  Feature_HasStdExtZvksedBit = 60,
  Feature_HasStdExtZvkshBit = 56,
  Feature_HasVInstructionsBit = 12,
  Feature_HasVInstructionsI64Bit = 46,
  Feature_HasVInstructionsAnyFBit = 45,
  Feature_HasVInstructionsF16MinimalBit = 50,
  Feature_HasVInstructionsBF16Bit = 51,
  Feature_HasVInstructionsF16Bit = 44,
  Feature_HasVInstructionsF64Bit = 48,
  Feature_HasVInstructionsFullMultiplyBit = 47,
  Feature_HasVendorXVentanaCondOpsBit = 63,
  Feature_HasVendorXTHeadBaBit = 64,
  Feature_HasVendorXTHeadBbBit = 65,
  Feature_HasVendorXTHeadBsBit = 66,
  Feature_HasVendorXTHeadCondMovBit = 67,
  Feature_HasVendorXTHeadFMemIdxBit = 72,
  Feature_HasVendorXTHeadMacBit = 68,
  Feature_HasVendorXTHeadMemIdxBit = 71,
  Feature_HasVendorXTHeadMemPairBit = 70,
  Feature_HasVendorXTHeadVdotBit = 69,
  Feature_HasVendorXSfvcpBit = 73,
  Feature_HasVendorXSfvqmaccdodBit = 74,
  Feature_HasVendorXSfvqmaccqoqBit = 75,
  Feature_HasVendorXSfvfwmaccqqqBit = 76,
  Feature_HasVendorXSfvfnrclipxfqfBit = 77,
  Feature_HasVendorXCVbitmanipBit = 78,
  Feature_IsRV64Bit = 5,
  Feature_IsRV32Bit = 4,
  Feature_HasShortForwardBranchOptBit = 0,
  Feature_NoShortForwardBranchOptBit = 2,
  Feature_HasConditionalMoveFusionBit = 1,
  Feature_NoConditionalMoveFusionBit = 3,
  Feature_HasAtomicLdStBit = 18,
  Feature_OptForMinSizeBit = 14,
  Feature_HwMode1Bit = 80,
  Feature_HwMode0Bit = 79,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features;
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtM() || Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtMOrZmmulBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtZtso())
    Features.set(Feature_HasStdExtZtsoBit);
  if (!Subtarget->hasStdExtZtso())
    Features.set(Feature_NotHasStdExtZtsoBit);
  if (Subtarget->hasStdExtZacas())
    Features.set(Feature_HasStdExtZacasBit);
  if (!Subtarget->hasStdExtZacas())
    Features.set(Feature_NoStdExtZacasBit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (!Subtarget->hasStdExtZfh())
    Features.set(Feature_NoStdExtZfhBit);
  if (Subtarget->hasStdExtZfbfmin())
    Features.set(Feature_HasStdExtZfbfminBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (!Subtarget->hasStdExtZhinx())
    Features.set(Feature_NoStdExtZhinxBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasStdExtZvfbfwma())
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (Subtarget->hasStdExtZvkb())
    Features.set(Feature_HasStdExtZvkbBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZvbc())
    Features.set(Feature_HasStdExtZvbcBit);
  if (Subtarget->hasStdExtZvkg())
    Features.set(Feature_HasStdExtZvkgBit);
  if (Subtarget->hasStdExtZvkned())
    Features.set(Feature_HasStdExtZvknedBit);
  if (Subtarget->hasStdExtZvknha())
    Features.set(Feature_HasStdExtZvknhaBit);
  if (Subtarget->hasStdExtZvknhb())
    Features.set(Feature_HasStdExtZvknhbBit);
  if (Subtarget->hasStdExtZvksed())
    Features.set(Feature_HasStdExtZvksedBit);
  if (Subtarget->hasStdExtZvksh())
    Features.set(Feature_HasStdExtZvkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF16Minimal())
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (Subtarget->hasVInstructionsBF16())
    Features.set(Feature_HasVInstructionsBF16Bit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->hasVendorXSfvqmaccdod())
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (Subtarget->hasVendorXSfvqmaccqoq())
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (Subtarget->hasVendorXSfvfwmaccqqq())
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (Subtarget->hasVendorXSfvfnrclipxfqf())
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (Subtarget->hasVendorXCVbitmanip())
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_HasConditionalMoveFusionBit);
  if (!Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_NoConditionalMoveFusionBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  if (!((Subtarget->is64Bit())))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features;
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HwMode0,
  GIFBS_HwMode1,
  GIFBS_HasAtomicLdSt_HwMode0,
  GIFBS_HasAtomicLdSt_HwMode1,
  GIFBS_HasShortForwardBranchOpt_HwMode0,
  GIFBS_HasShortForwardBranchOpt_HwMode1,
  GIFBS_HasStdExtA_HwMode1,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtD_HwMode0,
  GIFBS_HasStdExtD_HwMode1,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtF_HwMode0,
  GIFBS_HasStdExtF_HwMode1,
  GIFBS_HasStdExtM_HwMode0,
  GIFBS_HasStdExtM_HwMode1,
  GIFBS_HasStdExtMOrZmmul_HwMode0,
  GIFBS_HasStdExtMOrZmmul_HwMode1,
  GIFBS_HasStdExtZba_HwMode0,
  GIFBS_HasStdExtZba_HwMode1,
  GIFBS_HasStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_HwMode1,
  GIFBS_HasStdExtZbkx_HwMode0,
  GIFBS_HasStdExtZbkx_HwMode1,
  GIFBS_HasStdExtZbs_HwMode0,
  GIFBS_HasStdExtZbs_HwMode1,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtZfbfmin_HwMode0,
  GIFBS_HasStdExtZfbfmin_HwMode1,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZfinx_HwMode0,
  GIFBS_HasStdExtZfinx_HwMode1,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZhinxmin_HwMode0,
  GIFBS_HasStdExtZhinxmin_HwMode1,
  GIFBS_HasVInstructions_HwMode0,
  GIFBS_HasVInstructions_HwMode1,
  GIFBS_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructionsBF16_HwMode1,
  GIFBS_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsFullMultiply_HwMode0,
  GIFBS_HasVInstructionsFullMultiply_HwMode1,
  GIFBS_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXTHeadBa_HwMode0,
  GIFBS_HasVendorXTHeadBa_HwMode1,
  GIFBS_HasVendorXTHeadBb_HwMode0,
  GIFBS_HasVendorXTHeadBb_HwMode1,
  GIFBS_HasVendorXTHeadBs_HwMode0,
  GIFBS_HasVendorXTHeadBs_HwMode1,
  GIFBS_HasVendorXTHeadCondMov_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_HwMode1,
  GIFBS_HasVendorXTHeadMac_HwMode0,
  GIFBS_HasVendorXTHeadMac_HwMode1,
  GIFBS_IsRV32_HwMode0,
  GIFBS_IsRV32_HwMode1,
  GIFBS_IsRV64_HwMode0,
  GIFBS_IsRV64_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_IsRV64_HwMode1,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode1,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtD_IsRV64_HwMode0,
  GIFBS_HasStdExtF_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode1,
  GIFBS_HasStdExtMOrZmmul_IsRV64_HwMode0,
  GIFBS_HasStdExtMOrZmmul_IsRV64_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZba_IsRV64_HwMode0,
  GIFBS_HasStdExtZba_IsRV64_HwMode1,
  GIFBS_HasStdExtZbb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbs_IsRV64_HwMode0,
  GIFBS_HasStdExtZbs_IsRV64_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfbfmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfh_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfhmin_NoStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinxmin_NoStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZknd_IsRV32_HwMode1,
  GIFBS_HasStdExtZknd_IsRV64_HwMode0,
  GIFBS_HasStdExtZkndOrZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZkne_IsRV32_HwMode1,
  GIFBS_HasStdExtZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZknh_IsRV32_HwMode1,
  GIFBS_HasStdExtZknh_IsRV64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode0,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode1,
  GIFBS_HasVendorXTHeadBb_IsRV64_HwMode0,
  GIFBS_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZfhmin_IsRV64_NoStdExtZfh_HwMode0,
  GIFBS_HasStdExtZhinxmin_IsRV64_NoStdExtZhinx_HwMode0,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HwMode0Bit, },
  {Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode1Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode0Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfbfminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_NoStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_NoStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMOrZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_IsRV64Bit, Feature_NoStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_NoStdExtZhinxBit, Feature_HwMode0Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_GIAddrRegImm,
  GICP_GIShiftMask32,
  GICP_GIShiftMaskXLen,
  GICP_gi_sh1add_op,
  GICP_gi_sh1add_uw_op,
  GICP_gi_sh2add_op,
  GICP_gi_sh2add_uw_op,
  GICP_gi_sh3add_op,
  GICP_gi_sh3add_uw_op,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &RISCVInstructionSelector::selectAddrRegImm, // GIAddrRegImm
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMask32
  &RISCVInstructionSelector::selectShiftMask, // GIShiftMaskXLen
  &RISCVInstructionSelector::selectSHXADDOp<1>, // gi_sh1add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<1>, // gi_sh1add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<2>, // gi_sh2add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<2>, // gi_sh2add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<3>, // gi_sh3add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<3>, // gi_sh3add_uw_op
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_non_imm12 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_or_is_add_non_imm12,
};
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_or_is_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
        const MachineFunction &MF = *MI.getParent()->getParent();
        const MachineRegisterInfo &MRI = MF.getRegInfo();
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("or_is_add_non_imm12 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_BCLRMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BCLRMaski32,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_SingleBitSetMaski32,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_cv_tuimm2,
  GICXXPred_I64_Predicate_cv_tuimm5,
  GICXXPred_I64_Predicate_cv_uimm10,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_shfl_uimm,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm9_lsb0,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12Minus1Nonzero,
  GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1,
  GICXXPred_I64_Predicate_simm12Plus1,
  GICXXPred_I64_Predicate_simm12Plus1i32,
  GICXXPred_I64_Predicate_simm12_lsb0,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_simm12i32,
  GICXXPred_I64_Predicate_tsimm5,
  GICXXPred_I64_Predicate_tuimm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_BCLRMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_BCLRMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMaski32: {
    
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                     (isUInt<5>(Imm) ||
                                      (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_cv_tuimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_shfl_uimm: {
    
      if (Subtarget->is64Bit())
        return isUInt<5>(Imm);
      return isUInt<4>(Imm);
    
    llvm_unreachable("shfl_uimm should have returned");
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12Minus1Nonzero: {
    
      return (Imm >= -2049 && Imm < 0) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1: {
    
      return (Imm >= -2049 && Imm < -1) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Plus1: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12Plus1i32: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
      return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_simm12i32: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_tsimm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
      return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));
    
  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
      return isShiftedUInt<2, 3>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
      return isShiftedUInt<2, 4>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6: {
    return isUInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
      return isUInt<6>(Imm) && Imm > 32;
    
  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm);
      return isUInt<5>(Imm);
    
    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm) && (Imm != 0);
      return isUInt<5>(Imm) && (Imm != 0);
    
    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_Shifted32OnesMask = GICXXPred_Invalid + 1,
};
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_Shifted32OnesMask: {
    
      if (!Imm.isShiftedMask())
        return false;
    
      unsigned TrailingZeros = Imm.countr_zero();
      return TrailingZeros > 0 && TrailingZeros < 32 &&
             Imm == UINT64_C(0xFFFFFFFF) << TrailingZeros;
    
    llvm_unreachable("Shifted32OnesMask should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderImm,
  GICR_renderImmPlus1,
  GICR_renderImmSubFrom32,
  GICR_renderImmSubFromXLen,
  GICR_renderNegImm,
  GICR_renderTrailingZeros,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &RISCVInstructionSelector::renderImm,
  &RISCVInstructionSelector::renderImmPlus1,
  &RISCVInstructionSelector::renderImmSubFrom32,
  &RISCVInstructionSelector::renderImmSubFromXLen,
  &RISCVInstructionSelector::renderNegImm,
  &RISCVInstructionSelector::renderTrailingZeros,
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

void RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(47), GIMT_Encode2(276), /*)*//*default:*//*Label 94*/ GIMT_Encode4(328208),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(926),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(11556),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(15160),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(18637),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(21971),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(25305),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(28639), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(31973),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(38893),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(44096), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 10*/ GIMT_Encode4(49883), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 11*/ GIMT_Encode4(50226),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 12*/ GIMT_Encode4(50481),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 13*/ GIMT_Encode4(50736),
    /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 14*/ GIMT_Encode4(51886),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 15*/ GIMT_Encode4(52064),
    /*TargetOpcode::G_LOAD*//*Label 16*/ GIMT_Encode4(52111),
    /*TargetOpcode::G_SEXTLOAD*//*Label 17*/ GIMT_Encode4(57063),
    /*TargetOpcode::G_ZEXTLOAD*//*Label 18*/ GIMT_Encode4(57634), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STORE*//*Label 19*/ GIMT_Encode4(58205), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 20*/ GIMT_Encode4(62640),
    /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 21*/ GIMT_Encode4(65507),
    /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 22*/ GIMT_Encode4(67596), GIMT_Encode4(0),
    /*TargetOpcode::G_ATOMICRMW_AND*//*Label 23*/ GIMT_Encode4(69685),
    /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 24*/ GIMT_Encode4(71774),
    /*TargetOpcode::G_ATOMICRMW_OR*//*Label 25*/ GIMT_Encode4(72126),
    /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 26*/ GIMT_Encode4(74215),
    /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 27*/ GIMT_Encode4(76304),
    /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 28*/ GIMT_Encode4(78393),
    /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 29*/ GIMT_Encode4(80482),
    /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 30*/ GIMT_Encode4(82571), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 31*/ GIMT_Encode4(84660), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 32*/ GIMT_Encode4(84910),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 33*/ GIMT_Encode4(86957), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 34*/ GIMT_Encode4(87884), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 35*/ GIMT_Encode4(91603), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 36*/ GIMT_Encode4(95377),
    /*TargetOpcode::G_SHL*//*Label 37*/ GIMT_Encode4(99208),
    /*TargetOpcode::G_LSHR*//*Label 38*/ GIMT_Encode4(103396),
    /*TargetOpcode::G_ASHR*//*Label 39*/ GIMT_Encode4(107148), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 40*/ GIMT_Encode4(110867),
    /*TargetOpcode::G_ROTL*//*Label 41*/ GIMT_Encode4(114622),
    /*TargetOpcode::G_ICMP*//*Label 42*/ GIMT_Encode4(118333),
    /*TargetOpcode::G_FCMP*//*Label 43*/ GIMT_Encode4(152427),
    /*TargetOpcode::G_SELECT*//*Label 44*/ GIMT_Encode4(162253), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 45*/ GIMT_Encode4(162593),
    /*TargetOpcode::G_SMULH*//*Label 46*/ GIMT_Encode4(165889),
    /*TargetOpcode::G_UADDSAT*//*Label 47*/ GIMT_Encode4(169185),
    /*TargetOpcode::G_SADDSAT*//*Label 48*/ GIMT_Encode4(172521),
    /*TargetOpcode::G_USUBSAT*//*Label 49*/ GIMT_Encode4(175857),
    /*TargetOpcode::G_SSUBSAT*//*Label 50*/ GIMT_Encode4(179193), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 51*/ GIMT_Encode4(182529),
    /*TargetOpcode::G_FSUB*//*Label 52*/ GIMT_Encode4(185507),
    /*TargetOpcode::G_FMUL*//*Label 53*/ GIMT_Encode4(188485),
    /*TargetOpcode::G_FMA*//*Label 54*/ GIMT_Encode4(191463), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 55*/ GIMT_Encode4(211394), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 56*/ GIMT_Encode4(214372),
    /*TargetOpcode::G_FPEXT*//*Label 57*/ GIMT_Encode4(216775),
    /*TargetOpcode::G_FPTRUNC*//*Label 58*/ GIMT_Encode4(217379),
    /*TargetOpcode::G_FPTOSI*//*Label 59*/ GIMT_Encode4(219236),
    /*TargetOpcode::G_FPTOUI*//*Label 60*/ GIMT_Encode4(225715),
    /*TargetOpcode::G_SITOFP*//*Label 61*/ GIMT_Encode4(232194),
    /*TargetOpcode::G_UITOFP*//*Label 62*/ GIMT_Encode4(238872),
    /*TargetOpcode::G_FABS*//*Label 63*/ GIMT_Encode4(245550),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 64*/ GIMT_Encode4(247953), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 65*/ GIMT_Encode4(254594),
    /*TargetOpcode::G_FMAXNUM*//*Label 66*/ GIMT_Encode4(257088), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 67*/ GIMT_Encode4(259582),
    /*TargetOpcode::G_FMAXIMUM*//*Label 68*/ GIMT_Encode4(259726), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 69*/ GIMT_Encode4(259870),
    /*TargetOpcode::G_SMAX*//*Label 70*/ GIMT_Encode4(263166),
    /*TargetOpcode::G_UMIN*//*Label 71*/ GIMT_Encode4(266462),
    /*TargetOpcode::G_UMAX*//*Label 72*/ GIMT_Encode4(269758),
    /*TargetOpcode::G_ABS*//*Label 73*/ GIMT_Encode4(273054),
    /*TargetOpcode::G_LROUND*//*Label 74*/ GIMT_Encode4(273200),
    /*TargetOpcode::G_LLROUND*//*Label 75*/ GIMT_Encode4(274350),
    /*TargetOpcode::G_BR*//*Label 76*/ GIMT_Encode4(274724), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 77*/ GIMT_Encode4(274741), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 78*/ GIMT_Encode4(277721), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 79*/ GIMT_Encode4(280867),
    /*TargetOpcode::G_BSWAP*//*Label 80*/ GIMT_Encode4(283847),
    /*TargetOpcode::G_BITREVERSE*//*Label 81*/ GIMT_Encode4(286811),
    /*TargetOpcode::G_FCEIL*//*Label 82*/ GIMT_Encode4(289745), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 83*/ GIMT_Encode4(290000),
    /*TargetOpcode::G_FFLOOR*//*Label 84*/ GIMT_Encode4(292594),
    /*TargetOpcode::G_FRINT*//*Label 85*/ GIMT_Encode4(292849),
    /*TargetOpcode::G_FNEARBYINT*//*Label 86*/ GIMT_Encode4(293104), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 87*/ GIMT_Encode4(293359),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 88*/ GIMT_Encode4(296337),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 89*/ GIMT_Encode4(299315),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 90*/ GIMT_Encode4(302293), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 91*/ GIMT_Encode4(305271),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 92*/ GIMT_Encode4(325202), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*RISCV::G_FCLASS*//*Label 93*/ GIMT_Encode4(327796),
    // Label 0: @926
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 119*/ GIMT_Encode4(11555),
    /*GILLT_s32*//*Label 95*/ GIMT_Encode4(1061),
    /*GILLT_s64*//*Label 96*/ GIMT_Encode4(3693), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 97*/ GIMT_Encode4(8475),
    /*GILLT_nxv1s16*//*Label 98*/ GIMT_Encode4(8615),
    /*GILLT_nxv1s32*//*Label 99*/ GIMT_Encode4(8755),
    /*GILLT_nxv1s64*//*Label 100*/ GIMT_Encode4(8895), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 101*/ GIMT_Encode4(9035),
    /*GILLT_nxv2s16*//*Label 102*/ GIMT_Encode4(9175),
    /*GILLT_nxv2s32*//*Label 103*/ GIMT_Encode4(9315),
    /*GILLT_nxv2s64*//*Label 104*/ GIMT_Encode4(9455), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 105*/ GIMT_Encode4(9595),
    /*GILLT_nxv4s16*//*Label 106*/ GIMT_Encode4(9735),
    /*GILLT_nxv4s32*//*Label 107*/ GIMT_Encode4(9875),
    /*GILLT_nxv4s64*//*Label 108*/ GIMT_Encode4(10015), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 109*/ GIMT_Encode4(10155),
    /*GILLT_nxv8s16*//*Label 110*/ GIMT_Encode4(10295),
    /*GILLT_nxv8s32*//*Label 111*/ GIMT_Encode4(10435),
    /*GILLT_nxv8s64*//*Label 112*/ GIMT_Encode4(10575), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 113*/ GIMT_Encode4(10715),
    /*GILLT_nxv16s16*//*Label 114*/ GIMT_Encode4(10855),
    /*GILLT_nxv16s32*//*Label 115*/ GIMT_Encode4(10995), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 116*/ GIMT_Encode4(11135),
    /*GILLT_nxv32s16*//*Label 117*/ GIMT_Encode4(11275), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 118*/ GIMT_Encode4(11415),
    // Label 95: @1061
    GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(3692),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1132), // Rule ID 2293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:2:x, GPR:{ *:[i32] }:$rs2:$pred:2:y)<<P:2:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2293,
        GIR_Done,
      // Label 121: @1132
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1190), // Rule ID 2297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:4:x, GPR:{ *:[i32] }:$rs2:$pred:4:y)<<P:4:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2297,
        GIR_Done,
      // Label 122: @1190
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1248), // Rule ID 2301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:6:x, GPR:{ *:[i32] }:$rs2:$pred:6:y)<<P:6:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2301,
        GIR_Done,
      // Label 123: @1248
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1309), // Rule ID 61926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:29:x, GPR:{ *:[i32] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61926,
        GIR_Done,
      // Label 124: @1309
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1370), // Rule ID 61928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:30:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:30:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:30:x, GPR:{ *:[i32] }:$rs2:$pred:30:y)<<P:30:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61928,
        GIR_Done,
      // Label 125: @1370
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1431), // Rule ID 61930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:31:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:31:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:31:x, GPR:{ *:[i32] }:$rs2:$pred:31:y)<<P:31:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61930,
        GIR_Done,
      // Label 126: @1431
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1489), // Rule ID 64157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:2:y, sh1add_op:{ *:[i32] }:$rs1:$pred:2:x)<<P:2:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64157,
        GIR_Done,
      // Label 127: @1489
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1547), // Rule ID 64161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:4:y, sh2add_op:{ *:[i32] }:$rs1:$pred:4:x)<<P:4:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64161,
        GIR_Done,
      // Label 128: @1547
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1605), // Rule ID 64165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:6:y, sh3add_op:{ *:[i32] }:$rs1:$pred:6:x)<<P:6:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64165,
        GIR_Done,
      // Label 129: @1605
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1666), // Rule ID 72679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:29:y, sh1add_op:{ *:[i32] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh1add_op:{ *:[i32] }:$rs1, 1:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72679,
        GIR_Done,
      // Label 130: @1666
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1727), // Rule ID 72681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:30:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:30:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:30:y, sh2add_op:{ *:[i32] }:$rs1:$pred:30:x)<<P:30:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh2add_op:{ *:[i32] }:$rs1, 2:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72681,
        GIR_Done,
      // Label 131: @1727
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1788), // Rule ID 72683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:31:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:31:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:31:y, sh3add_op:{ *:[i32] }:$rs1:$pred:31:x)<<P:31:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs2, sh3add_op:{ *:[i32] }:$rs1, 3:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72683,
        GIR_Done,
      // Label 132: @1788
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1866), // Rule ID 2291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x, GPR:{ *:[i32] }:$rs2:$pred:1:y)<<P:1:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2291,
        GIR_Done,
      // Label 133: @1866
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1944), // Rule ID 2295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x, GPR:{ *:[i32] }:$rs2:$pred:3:y)<<P:3:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2295,
        GIR_Done,
      // Label 134: @1944
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2022), // Rule ID 2299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x, GPR:{ *:[i32] }:$rs2:$pred:5:y)<<P:5:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2299,
        GIR_Done,
      // Label 135: @2022
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2100), // Rule ID 2418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2418,
        GIR_Done,
      // Label 136: @2100
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2178), // Rule ID 2419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:26:x, GPR:{ *:[i32] }:$rs2:$pred:26:y)<<P:26:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2419,
        GIR_Done,
      // Label 137: @2178
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2256), // Rule ID 2420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:27:x, GPR:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2420,
        GIR_Done,
      // Label 138: @2256
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2334), // Rule ID 2421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:27:x, GPR:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2421,
        GIR_Done,
      // Label 139: @2334
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2412), // Rule ID 2422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:28:x, GPR:{ *:[i32] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2422,
        GIR_Done,
      // Label 140: @2412
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2490), // Rule ID 2423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:28:x, GPR:{ *:[i32] }:$rs2:$pred:28:y)<<P:28:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2423,
        GIR_Done,
      // Label 141: @2490
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2568), // Rule ID 64155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:1:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x)<<P:1:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64155,
        GIR_Done,
      // Label 142: @2568
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2646), // Rule ID 64159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:3:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x)<<P:3:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64159,
        GIR_Done,
      // Label 143: @2646
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2724), // Rule ID 64163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:5:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x)<<P:5:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64163,
        GIR_Done,
      // Label 144: @2724
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2802), // Rule ID 64218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64218,
        GIR_Done,
      // Label 145: @2802
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2880), // Rule ID 64219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:26:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i64] }):$pred:26:x)<<P:26:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64219,
        GIR_Done,
      // Label 146: @2880
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2958), // Rule ID 64220 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:27:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64220,
        GIR_Done,
      // Label 147: @2958
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3036), // Rule ID 64221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:27:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i64] }):$pred:27:x)<<P:27:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64221,
        GIR_Done,
      // Label 148: @3036
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3114), // Rule ID 64222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:28:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64222,
        GIR_Done,
      // Label 149: @3114
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(3192), // Rule ID 64223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:28:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i64] }):$pred:28:x)<<P:28:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64223,
        GIR_Done,
      // Label 150: @3192
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3271), // Rule ID 72677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i32] }:$rs1)  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72677,
        GIR_Done,
      // Label 151: @3271
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(3350), // Rule ID 61924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61924,
        GIR_Done,
      // Label 152: @3350
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3402), // Rule ID 70 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 70,
        GIR_Done,
      // Label 153: @3402
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3456), // Rule ID 296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 296,
        GIR_Done,
      // Label 154: @3456
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3527), // Rule ID 72703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72703,
        GIR_Done,
      // Label 155: @3527
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3598), // Rule ID 62028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62028,
        GIR_Done,
      // Label 156: @3598
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3629), // Rule ID 68 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 68,
        GIR_Done,
      // Label 157: @3629
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3660), // Rule ID 283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 283,
        GIR_Done,
      // Label 158: @3660
      GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3691), // Rule ID 284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADDW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 284,
        GIR_Done,
      // Label 159: @3691
      GIM_Reject,
    // Label 120: @3692
    GIM_Reject,
    // Label 96: @3693
    GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(8474),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3813), // Rule ID 2360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:12:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:12:x, GPR:{ *:[i64] }:$rs2:$pred:12:y)<<P:12:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2360,
        GIR_Done,
      // Label 161: @3813
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3920), // Rule ID 2361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:13:x, GPR:{ *:[i64] }:$rs2:$pred:13:y)<<P:13:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2361,
        GIR_Done,
      // Label 162: @3920
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(4027), // Rule ID 2362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:14:x, GPR:{ *:[i64] }:$rs2:$pred:14:y)<<P:14:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2362,
        GIR_Done,
      // Label 163: @4027
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(4134), // Rule ID 2357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:9:x, GPR:{ *:[i64] }:$rs2:$pred:9:y)<<P:9:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2357,
        GIR_Done,
      // Label 164: @4134
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(4241), // Rule ID 2358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:10:x, GPR:{ *:[i64] }:$rs2:$pred:10:y)<<P:10:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2358,
        GIR_Done,
      // Label 165: @4241
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(4348), // Rule ID 2359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:11:x, GPR:{ *:[i64] }:$rs2:$pred:11:y)<<P:11:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2359,
        GIR_Done,
      // Label 166: @4348
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(4455), // Rule ID 64189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:12:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:12:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:12:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:12:x)<<P:12:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64189,
        GIR_Done,
      // Label 167: @4455
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(4562), // Rule ID 64190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:13:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:13:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:13:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:13:x)<<P:13:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64190,
        GIR_Done,
      // Label 168: @4562
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(4669), // Rule ID 64191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:14:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:14:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 3,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738367),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:14:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), 34359738367:{ *:[i64] }):$pred:14:x)<<P:14:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64191,
        GIR_Done,
      // Label 169: @4669
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(4776), // Rule ID 64186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:9:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:9:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:9:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:9:x)<<P:9:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64186,
        GIR_Done,
      // Label 170: @4776
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(4883), // Rule ID 64187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:10:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:10:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:10:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:10:x)<<P:10:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64187,
        GIR_Done,
      // Label 171: @4883
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(4990), // Rule ID 64188 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:11:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:11:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:11:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:11:x)<<P:11:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64188,
        GIR_Done,
      // Label 172: @4990
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(5048), // Rule ID 2292 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:2:x, GPR:{ *:[i64] }:$rs2:$pred:2:y)<<P:2:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2292,
        GIR_Done,
      // Label 173: @5048
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(5106), // Rule ID 2296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:4:x, GPR:{ *:[i64] }:$rs2:$pred:4:y)<<P:4:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2296,
        GIR_Done,
      // Label 174: @5106
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(5164), // Rule ID 2300 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:6:x, GPR:{ *:[i64] }:$rs2:$pred:6:y)<<P:6:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2300,
        GIR_Done,
      // Label 175: @5164
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(5222), // Rule ID 2363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:15:x, GPR:{ *:[i64] }:$rs2:$pred:15:y)<<P:15:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2363,
        GIR_Done,
      // Label 176: @5222
      GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(5280), // Rule ID 2364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:16:x, GPR:{ *:[i64] }:$rs2:$pred:16:y)<<P:16:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2364,
        GIR_Done,
      // Label 177: @5280
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(5338), // Rule ID 2365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:17:x, GPR:{ *:[i64] }:$rs2:$pred:17:y)<<P:17:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2365,
        GIR_Done,
      // Label 178: @5338
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(5399), // Rule ID 61925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:29:x, GPR:{ *:[i64] }:$rs2:$pred:29:y)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61925,
        GIR_Done,
      // Label 179: @5399
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(5460), // Rule ID 61927 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:30:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:30:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:30:x, GPR:{ *:[i64] }:$rs2:$pred:30:y)<<P:30:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61927,
        GIR_Done,
      // Label 180: @5460
      GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(5521), // Rule ID 61929 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:31:x
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:31:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:31:x, GPR:{ *:[i64] }:$rs2:$pred:31:y)<<P:31:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61929,
        GIR_Done,
      // Label 181: @5521
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(5579), // Rule ID 64156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:2:y, sh1add_op:{ *:[i64] }:$rs1:$pred:2:x)<<P:2:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64156,
        GIR_Done,
      // Label 182: @5579
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(5637), // Rule ID 64160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:4:y, sh2add_op:{ *:[i64] }:$rs1:$pred:4:x)<<P:4:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64160,
        GIR_Done,
      // Label 183: @5637
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(5695), // Rule ID 64164 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:6:y, sh3add_op:{ *:[i64] }:$rs1:$pred:6:x)<<P:6:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64164,
        GIR_Done,
      // Label 184: @5695
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(5753), // Rule ID 64192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:15:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:15:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:15:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:15:x)<<P:15:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64192,
        GIR_Done,
      // Label 185: @5753
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5811), // Rule ID 64193 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:16:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:16:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:16:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:16:x)<<P:16:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64193,
        GIR_Done,
      // Label 186: @5811
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5869), // Rule ID 64194 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:17:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:17:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:17:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:17:x)<<P:17:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64194,
        GIR_Done,
      // Label 187: @5869
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(5930), // Rule ID 72678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:29:y, sh1add_op:{ *:[i64] }:$rs1:$pred:29:x)<<P:29:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh1add_op:{ *:[i64] }:$rs1, 1:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72678,
        GIR_Done,
      // Label 188: @5930
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(5991), // Rule ID 72680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:30:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:30:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:30:y, sh2add_op:{ *:[i64] }:$rs1:$pred:30:x)<<P:30:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh2add_op:{ *:[i64] }:$rs1, 2:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72680,
        GIR_Done,
      // Label 189: @5991
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(6052), // Rule ID 72682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:31:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:31:x
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:31:y, sh3add_op:{ *:[i64] }:$rs1:$pred:31:x)<<P:31:Predicate_add_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs2, sh3add_op:{ *:[i64] }:$rs1, 3:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72682,
        GIR_Done,
      // Label 190: @6052
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(6137), // Rule ID 2354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x, GPR:{ *:[i64] }:$rs2:$pred:7:y)<<P:7:Predicate_add_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2354,
        GIR_Done,
      // Label 191: @6137
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(6242), // Rule ID 2366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:18:x, GPR:{ *:[i64] }:$rs2:$pred:18:y)<<P:18:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2366,
        GIR_Done,
      // Label 192: @6242
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(6347), // Rule ID 2367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:19:x, GPR:{ *:[i64] }:$rs2:$pred:19:y)<<P:19:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2367,
        GIR_Done,
      // Label 193: @6347
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(6452), // Rule ID 2368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:20:x, GPR:{ *:[i64] }:$rs2:$pred:20:y)<<P:20:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2368,
        GIR_Done,
      // Label 194: @6452
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(6557), // Rule ID 2369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:21:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:21:x, GPR:{ *:[i64] }:$rs2:$pred:21:y)<<P:21:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2369,
        GIR_Done,
      // Label 195: @6557
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(6662), // Rule ID 2370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:22:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:22:x, GPR:{ *:[i64] }:$rs2:$pred:22:y)<<P:22:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2370,
        GIR_Done,
      // Label 196: @6662
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(6767), // Rule ID 2371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:23:x, GPR:{ *:[i64] }:$rs2:$pred:23:y)<<P:23:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2371,
        GIR_Done,
      // Label 197: @6767
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(6845), // Rule ID 2290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x, GPR:{ *:[i64] }:$rs2:$pred:1:y)<<P:1:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2290,
        GIR_Done,
      // Label 198: @6845
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(6923), // Rule ID 2294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x, GPR:{ *:[i64] }:$rs2:$pred:3:y)<<P:3:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2294,
        GIR_Done,
      // Label 199: @6923
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(7001), // Rule ID 2298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x, GPR:{ *:[i64] }:$rs2:$pred:5:y)<<P:5:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2298,
        GIR_Done,
      // Label 200: @7001
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(7086), // Rule ID 64184 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:7:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:7:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:7:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x)<<P:7:Predicate_add_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64184,
        GIR_Done,
      // Label 201: @7086
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(7191), // Rule ID 64195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:18:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:18:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:18:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:18:x)<<P:18:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64195,
        GIR_Done,
      // Label 202: @7191
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(7296), // Rule ID 64196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:19:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:19:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:19:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:19:x)<<P:19:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64196,
        GIR_Done,
      // Label 203: @7296
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(7401), // Rule ID 64197 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:20:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:20:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:20:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:20:x)<<P:20:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64197,
        GIR_Done,
      // Label 204: @7401
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(7506), // Rule ID 64198 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:21:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:21:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:21:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:21:x)<<P:21:Predicate_add_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64198,
        GIR_Done,
      // Label 205: @7506
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(7611), // Rule ID 64199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:22:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:22:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:22:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:22:x)<<P:22:Predicate_add_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64199,
        GIR_Done,
      // Label 206: @7611
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(7716), // Rule ID 64200 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:23:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:23:x)<<P:23:Predicate_add_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64200,
        GIR_Done,
      // Label 207: @7716
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(7794), // Rule ID 64154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:1:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x)<<P:1:Predicate_add_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64154,
        GIR_Done,
      // Label 208: @7794
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(7872), // Rule ID 64158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:3:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x)<<P:3:Predicate_add_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64158,
        GIR_Done,
      // Label 209: @7872
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(7950), // Rule ID 64162 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:5:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x)<<P:5:Predicate_add_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64162,
        GIR_Done,
      // Label 210: @7950
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(8029), // Rule ID 72676 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2), GPR:{ *:[i64] }:$rs1)  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72676,
        GIR_Done,
      // Label 211: @8029
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(8108), // Rule ID 61923 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2))  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 61923,
        GIR_Done,
      // Label 212: @8108
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(8178), // Rule ID 2415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:24:x, GPR:{ *:[i64] }:$rs2:$pred:24:y)<<P:24:Predicate_add_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2415,
        GIR_Done,
      // Label 213: @8178
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(8248), // Rule ID 64216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_non_imm12),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:24:y, (zext:{ *:[i64] } GPR:{ *:[i32] }:$rs1):$pred:24:x)<<P:24:Predicate_add_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64216,
        GIR_Done,
      // Label 214: @8248
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(8300), // Rule ID 69 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 69,
        GIR_Done,
      // Label 215: @8300
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(8371), // Rule ID 72702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 72702,
        GIR_Done,
      // Label 216: @8371
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(8442), // Rule ID 62027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62027,
        GIR_Done,
      // Label 217: @8442
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(8473), // Rule ID 67 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 67,
        GIR_Done,
      // Label 218: @8473
      GIM_Reject,
    // Label 160: @8474
    GIM_Reject,
    // Label 97: @8475
    GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(8614),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(8558), // Rule ID 46067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46067,
        GIR_Done,
      // Label 220: @8558
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(8613), // Rule ID 46068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46068,
        GIR_Done,
      // Label 221: @8613
      GIM_Reject,
    // Label 219: @8614
    GIM_Reject,
    // Label 98: @8615
    GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(8754),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(8698), // Rule ID 46447 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46447,
        GIR_Done,
      // Label 223: @8698
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(8753), // Rule ID 46448 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46448,
        GIR_Done,
      // Label 224: @8753
      GIM_Reject,
    // Label 222: @8754
    GIM_Reject,
    // Label 99: @8755
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(8894),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(8838), // Rule ID 46455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46455,
        GIR_Done,
      // Label 226: @8838
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(8893), // Rule ID 46456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46456,
        GIR_Done,
      // Label 227: @8893
      GIM_Reject,
    // Label 225: @8894
    GIM_Reject,
    // Label 100: @8895
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(9034),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(8978), // Rule ID 46471 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46471,
        GIR_Done,
      // Label 229: @8978
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(9033), // Rule ID 46472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46472,
        GIR_Done,
      // Label 230: @9033
      GIM_Reject,
    // Label 228: @9034
    GIM_Reject,
    // Label 101: @9035
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(9174),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(9118), // Rule ID 46439 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46439,
        GIR_Done,
      // Label 232: @9118
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(9173), // Rule ID 46440 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46440,
        GIR_Done,
      // Label 233: @9173
      GIM_Reject,
    // Label 231: @9174
    GIM_Reject,
    // Label 102: @9175
    GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(9314),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(9258), // Rule ID 46451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46451,
        GIR_Done,
      // Label 235: @9258
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(9313), // Rule ID 46452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46452,
        GIR_Done,
      // Label 236: @9313
      GIM_Reject,
    // Label 234: @9314
    GIM_Reject,
    // Label 103: @9315
    GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(9454),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(9398), // Rule ID 46467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46467,
        GIR_Done,
      // Label 238: @9398
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(9453), // Rule ID 46468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46468,
        GIR_Done,
      // Label 239: @9453
      GIM_Reject,
    // Label 237: @9454
    GIM_Reject,
    // Label 104: @9455
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(9594),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(9538), // Rule ID 46511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46511,
        GIR_Done,
      // Label 241: @9538
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(9593), // Rule ID 46512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46512,
        GIR_Done,
      // Label 242: @9593
      GIM_Reject,
    // Label 240: @9594
    GIM_Reject,
    // Label 105: @9595
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(9734),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(9678), // Rule ID 46443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46443,
        GIR_Done,
      // Label 244: @9678
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(9733), // Rule ID 46444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46444,
        GIR_Done,
      // Label 245: @9733
      GIM_Reject,
    // Label 243: @9734
    GIM_Reject,
    // Label 106: @9735
    GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(9874),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(9818), // Rule ID 46463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46463,
        GIR_Done,
      // Label 247: @9818
      GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(9873), // Rule ID 46464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46464,
        GIR_Done,
      // Label 248: @9873
      GIM_Reject,
    // Label 246: @9874
    GIM_Reject,
    // Label 107: @9875
    GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(10014),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(9958), // Rule ID 46499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46499,
        GIR_Done,
      // Label 250: @9958
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(10013), // Rule ID 46500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46500,
        GIR_Done,
      // Label 251: @10013
      GIM_Reject,
    // Label 249: @10014
    GIM_Reject,
    // Label 108: @10015
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(10154),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(10098), // Rule ID 46515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46515,
        GIR_Done,
      // Label 253: @10098
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(10153), // Rule ID 46516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46516,
        GIR_Done,
      // Label 254: @10153
      GIM_Reject,
    // Label 252: @10154
    GIM_Reject,
    // Label 109: @10155
    GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(10294),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(10238), // Rule ID 46459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46459,
        GIR_Done,
      // Label 256: @10238
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(10293), // Rule ID 46460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46460,
        GIR_Done,
      // Label 257: @10293
      GIM_Reject,
    // Label 255: @10294
    GIM_Reject,
    // Label 110: @10295
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(10434),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(10378), // Rule ID 46487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46487,
        GIR_Done,
      // Label 259: @10378
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(10433), // Rule ID 46488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46488,
        GIR_Done,
      // Label 260: @10433
      GIM_Reject,
    // Label 258: @10434
    GIM_Reject,
    // Label 111: @10435
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(10574),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(10518), // Rule ID 46503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46503,
        GIR_Done,
      // Label 262: @10518
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(10573), // Rule ID 46504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46504,
        GIR_Done,
      // Label 263: @10573
      GIM_Reject,
    // Label 261: @10574
    GIM_Reject,
    // Label 112: @10575
    GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(10714),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(10658), // Rule ID 46519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46519,
        GIR_Done,
      // Label 265: @10658
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(10713), // Rule ID 46520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (add:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46520,
        GIR_Done,
      // Label 266: @10713
      GIM_Reject,
    // Label 264: @10714
    GIM_Reject,
    // Label 113: @10715
    GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(10854),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(10798), // Rule ID 46475 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46475,
        GIR_Done,
      // Label 268: @10798
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(10853), // Rule ID 46476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46476,
        GIR_Done,
      // Label 269: @10853
      GIM_Reject,
    // Label 267: @10854
    GIM_Reject,
    // Label 114: @10855
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(10994),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(10938), // Rule ID 46491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46491,
        GIR_Done,
      // Label 271: @10938
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(10993), // Rule ID 46492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46492,
        GIR_Done,
      // Label 272: @10993
      GIM_Reject,
    // Label 270: @10994
    GIM_Reject,
    // Label 115: @10995
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(11134),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(11078), // Rule ID 46507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46507,
        GIR_Done,
      // Label 274: @11078
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(11133), // Rule ID 46508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46508,
        GIR_Done,
      // Label 275: @11133
      GIM_Reject,
    // Label 273: @11134
    GIM_Reject,
    // Label 116: @11135
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(11274),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(11218), // Rule ID 46479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46479,
        GIR_Done,
      // Label 277: @11218
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(11273), // Rule ID 46480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVADD_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46480,
        GIR_Done,
      // Label 278: @11273
      GIM_Reject,
    // Label 276: @11274
    GIM_Reject,
    // Label 117: @11275
    GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(11414),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(11358), // Rule ID 46495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46495,
        GIR_Done,
      // Label 280: @11358
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(11413), // Rule ID 46496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46496,
        GIR_Done,
      // Label 281: @11413
      GIM_Reject,
    // Label 279: @11414
    GIM_Reject,
    // Label 118: @11415
    GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(11554),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(11498), // Rule ID 46483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46483,
        GIR_Done,
      // Label 283: @11498
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(11553), // Rule ID 46484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (add:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVADD_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46484,
        GIR_Done,
      // Label 284: @11553
      GIM_Reject,
    // Label 282: @11554
    GIM_Reject,
    // Label 119: @11555
    GIM_Reject,
    // Label 1: @11556
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 309*/ GIMT_Encode4(15159),
    /*GILLT_s32*//*Label 285*/ GIMT_Encode4(11691),
    /*GILLT_s64*//*Label 286*/ GIMT_Encode4(11928), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 287*/ GIMT_Encode4(12079),
    /*GILLT_nxv1s16*//*Label 288*/ GIMT_Encode4(12219),
    /*GILLT_nxv1s32*//*Label 289*/ GIMT_Encode4(12359),
    /*GILLT_nxv1s64*//*Label 290*/ GIMT_Encode4(12499), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 291*/ GIMT_Encode4(12639),
    /*GILLT_nxv2s16*//*Label 292*/ GIMT_Encode4(12779),
    /*GILLT_nxv2s32*//*Label 293*/ GIMT_Encode4(12919),
    /*GILLT_nxv2s64*//*Label 294*/ GIMT_Encode4(13059), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 295*/ GIMT_Encode4(13199),
    /*GILLT_nxv4s16*//*Label 296*/ GIMT_Encode4(13339),
    /*GILLT_nxv4s32*//*Label 297*/ GIMT_Encode4(13479),
    /*GILLT_nxv4s64*//*Label 298*/ GIMT_Encode4(13619), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 299*/ GIMT_Encode4(13759),
    /*GILLT_nxv8s16*//*Label 300*/ GIMT_Encode4(13899),
    /*GILLT_nxv8s32*//*Label 301*/ GIMT_Encode4(14039),
    /*GILLT_nxv8s64*//*Label 302*/ GIMT_Encode4(14179), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 303*/ GIMT_Encode4(14319),
    /*GILLT_nxv16s16*//*Label 304*/ GIMT_Encode4(14459),
    /*GILLT_nxv16s32*//*Label 305*/ GIMT_Encode4(14599), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 306*/ GIMT_Encode4(14739),
    /*GILLT_nxv32s16*//*Label 307*/ GIMT_Encode4(14879), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 308*/ GIMT_Encode4(15019),
    // Label 285: @11691
    GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(11927),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(11758), // Rule ID 63978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 63978,
        GIR_Done,
      // Label 311: @11758
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(11802), // Rule ID 63979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12Plus1i32>>:$imm)  =>  (ADDIW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (NegImm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 63979,
        GIR_Done,
      // Label 312: @11802
      GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(11863), // Rule ID 62030 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULS:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62030,
        GIR_Done,
      // Label 313: @11863
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(11884), // Rule ID 72 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUB:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 72,
        GIR_Done,
      // Label 314: @11884
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(11905), // Rule ID 285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 285,
        GIR_Done,
      // Label 315: @11905
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(11926), // Rule ID 286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (SUBW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUBW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 286,
        GIR_Done,
      // Label 316: @11926
      GIM_Reject,
    // Label 310: @11927
    GIM_Reject,
    // Label 286: @11928
    GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(12078),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(11995), // Rule ID 63977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12Plus1),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (NegImm:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_simm12Plus1>>:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 63977,
        GIR_Done,
      // Label 318: @11995
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(12056), // Rule ID 62029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULS:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_MULS),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd_wb]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rd
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62029,
        GIR_Done,
      // Label 319: @12056
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(12077), // Rule ID 71 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (sub:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (SUB:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SUB),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 71,
        GIR_Done,
      // Label 320: @12077
      GIM_Reject,
    // Label 317: @12078
    GIM_Reject,
    // Label 287: @12079
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(12218),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(12162), // Rule ID 46565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46565,
        GIR_Done,
      // Label 322: @12162
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(12217), // Rule ID 46566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVSUB_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46566,
        GIR_Done,
      // Label 323: @12217
      GIM_Reject,
    // Label 321: @12218
    GIM_Reject,
    // Label 288: @12219
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(12358),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(12302), // Rule ID 46577 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46577,
        GIR_Done,
      // Label 325: @12302
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(12357), // Rule ID 46578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46578,
        GIR_Done,
      // Label 326: @12357
      GIM_Reject,
    // Label 324: @12358
    GIM_Reject,
    // Label 289: @12359
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(12498),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(12442), // Rule ID 46585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46585,
        GIR_Done,
      // Label 328: @12442
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(12497), // Rule ID 46586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46586,
        GIR_Done,
      // Label 329: @12497
      GIM_Reject,
    // Label 327: @12498
    GIM_Reject,
    // Label 290: @12499
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(12638),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(12582), // Rule ID 46601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46601,
        GIR_Done,
      // Label 331: @12582
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(12637), // Rule ID 46602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46602,
        GIR_Done,
      // Label 332: @12637
      GIM_Reject,
    // Label 330: @12638
    GIM_Reject,
    // Label 291: @12639
    GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(12778),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(12722), // Rule ID 46569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46569,
        GIR_Done,
      // Label 334: @12722
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(12777), // Rule ID 46570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVSUB_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46570,
        GIR_Done,
      // Label 335: @12777
      GIM_Reject,
    // Label 333: @12778
    GIM_Reject,
    // Label 292: @12779
    GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(12918),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(12862), // Rule ID 46581 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46581,
        GIR_Done,
      // Label 337: @12862
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(12917), // Rule ID 46582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46582,
        GIR_Done,
      // Label 338: @12917
      GIM_Reject,
    // Label 336: @12918
    GIM_Reject,
    // Label 293: @12919
    GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(13058),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(13002), // Rule ID 46597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46597,
        GIR_Done,
      // Label 340: @13002
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(13057), // Rule ID 46598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46598,
        GIR_Done,
      // Label 341: @13057
      GIM_Reject,
    // Label 339: @13058
    GIM_Reject,
    // Label 294: @13059
    GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(13198),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(13142), // Rule ID 46641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46641,
        GIR_Done,
      // Label 343: @13142
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(13197), // Rule ID 46642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46642,
        GIR_Done,
      // Label 344: @13197
      GIM_Reject,
    // Label 342: @13198
    GIM_Reject,
    // Label 295: @13199
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(13338),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(13282), // Rule ID 46573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46573,
        GIR_Done,
      // Label 346: @13282
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(13337), // Rule ID 46574 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVSUB_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46574,
        GIR_Done,
      // Label 347: @13337
      GIM_Reject,
    // Label 345: @13338
    GIM_Reject,
    // Label 296: @13339
    GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(13478),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(13422), // Rule ID 46593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46593,
        GIR_Done,
      // Label 349: @13422
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(13477), // Rule ID 46594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46594,
        GIR_Done,
      // Label 350: @13477
      GIM_Reject,
    // Label 348: @13478
    GIM_Reject,
    // Label 297: @13479
    GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(13618),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(13562), // Rule ID 46629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46629,
        GIR_Done,
      // Label 352: @13562
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(13617), // Rule ID 46630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46630,
        GIR_Done,
      // Label 353: @13617
      GIM_Reject,
    // Label 351: @13618
    GIM_Reject,
    // Label 298: @13619
    GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(13758),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(13702), // Rule ID 46645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46645,
        GIR_Done,
      // Label 355: @13702
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(13757), // Rule ID 46646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46646,
        GIR_Done,
      // Label 356: @13757
      GIM_Reject,
    // Label 354: @13758
    GIM_Reject,
    // Label 299: @13759
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(13898),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(13842), // Rule ID 46589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46589,
        GIR_Done,
      // Label 358: @13842
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(13897), // Rule ID 46590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVSUB_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46590,
        GIR_Done,
      // Label 359: @13897
      GIM_Reject,
    // Label 357: @13898
    GIM_Reject,
    // Label 300: @13899
    GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(14038),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(13982), // Rule ID 46617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46617,
        GIR_Done,
      // Label 361: @13982
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(14037), // Rule ID 46618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46618,
        GIR_Done,
      // Label 362: @14037
      GIM_Reject,
    // Label 360: @14038
    GIM_Reject,
    // Label 301: @14039
    GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(14178),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(14122), // Rule ID 46633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46633,
        GIR_Done,
      // Label 364: @14122
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(14177), // Rule ID 46634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46634,
        GIR_Done,
      // Label 365: @14177
      GIM_Reject,
    // Label 363: @14178
    GIM_Reject,
    // Label 302: @14179
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(14318),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(14262), // Rule ID 46649 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46649,
        GIR_Done,
      // Label 367: @14262
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(14317), // Rule ID 46650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sub:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46650,
        GIR_Done,
      // Label 368: @14317
      GIM_Reject,
    // Label 366: @14318
    GIM_Reject,
    // Label 303: @14319
    GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(14458),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(14402), // Rule ID 46605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46605,
        GIR_Done,
      // Label 370: @14402
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(14457), // Rule ID 46606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVSUB_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46606,
        GIR_Done,
      // Label 371: @14457
      GIM_Reject,
    // Label 369: @14458
    GIM_Reject,
    // Label 304: @14459
    GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(14598),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(14542), // Rule ID 46621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46621,
        GIR_Done,
      // Label 373: @14542
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(14597), // Rule ID 46622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46622,
        GIR_Done,
      // Label 374: @14597
      GIM_Reject,
    // Label 372: @14598
    GIM_Reject,
    // Label 305: @14599
    GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(14738),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(14682), // Rule ID 46637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46637,
        GIR_Done,
      // Label 376: @14682
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(14737), // Rule ID 46638 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46638,
        GIR_Done,
      // Label 377: @14737
      GIM_Reject,
    // Label 375: @14738
    GIM_Reject,
    // Label 306: @14739
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(14878),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(14822), // Rule ID 46609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46609,
        GIR_Done,
      // Label 379: @14822
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(14877), // Rule ID 46610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVSUB_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46610,
        GIR_Done,
      // Label 380: @14877
      GIM_Reject,
    // Label 378: @14878
    GIM_Reject,
    // Label 307: @14879
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(15018),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(14962), // Rule ID 46625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46625,
        GIR_Done,
      // Label 382: @14962
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(15017), // Rule ID 46626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46626,
        GIR_Done,
      // Label 383: @15017
      GIM_Reject,
    // Label 381: @15018
    GIM_Reject,
    // Label 308: @15019
    GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(15158),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(15102), // Rule ID 46613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46613,
        GIR_Done,
      // Label 385: @15102
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(15157), // Rule ID 46614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sub:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVSUB_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVSUB_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 46614,
        GIR_Done,
      // Label 386: @15157
      GIM_Reject,
    // Label 384: @15158
    GIM_Reject,
    // Label 309: @15159
    GIM_Reject,
    // Label 2: @15160
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 411*/ GIMT_Encode4(18636),
    /*GILLT_s32*//*Label 387*/ GIMT_Encode4(15295),
    /*GILLT_s64*//*Label 388*/ GIMT_Encode4(15373), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 389*/ GIMT_Encode4(15556),
    /*GILLT_nxv1s16*//*Label 390*/ GIMT_Encode4(15696),
    /*GILLT_nxv1s32*//*Label 391*/ GIMT_Encode4(15836),
    /*GILLT_nxv1s64*//*Label 392*/ GIMT_Encode4(15976), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 393*/ GIMT_Encode4(16116),
    /*GILLT_nxv2s16*//*Label 394*/ GIMT_Encode4(16256),
    /*GILLT_nxv2s32*//*Label 395*/ GIMT_Encode4(16396),
    /*GILLT_nxv2s64*//*Label 396*/ GIMT_Encode4(16536), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 397*/ GIMT_Encode4(16676),
    /*GILLT_nxv4s16*//*Label 398*/ GIMT_Encode4(16816),
    /*GILLT_nxv4s32*//*Label 399*/ GIMT_Encode4(16956),
    /*GILLT_nxv4s64*//*Label 400*/ GIMT_Encode4(17096), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 401*/ GIMT_Encode4(17236),
    /*GILLT_nxv8s16*//*Label 402*/ GIMT_Encode4(17376),
    /*GILLT_nxv8s32*//*Label 403*/ GIMT_Encode4(17516),
    /*GILLT_nxv8s64*//*Label 404*/ GIMT_Encode4(17656), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 405*/ GIMT_Encode4(17796),
    /*GILLT_nxv16s16*//*Label 406*/ GIMT_Encode4(17936),
    /*GILLT_nxv16s32*//*Label 407*/ GIMT_Encode4(18076), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 408*/ GIMT_Encode4(18216),
    /*GILLT_nxv32s16*//*Label 409*/ GIMT_Encode4(18356), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 410*/ GIMT_Encode4(18496),
    // Label 387: @15295
    GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(15372),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(15339), // Rule ID 311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtMOrZmmul_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MUL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 413: @15339
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(15355), // Rule ID 334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtMOrZmmul_IsRV64_HwMode0),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 334,
        GIR_Done,
      // Label 414: @15355
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(15371), // Rule ID 335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtMOrZmmul_IsRV64_HwMode1),
        // (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (MULW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 335,
        GIR_Done,
      // Label 415: @15371
      GIM_Reject,
    // Label 412: @15372
    GIM_Reject,
    // Label 388: @15373
    GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(15555),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(15528), // Rule ID 333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtMOrZmmul_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (mul:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), (and:{ *:[i64] } GPR:{ *:[i64] }:$rs2, 4294967295:{ *:[i64] }))  =>  (MULHU:{ *:[i64] } (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs2, 32:{ *:[i64] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // rs2
        GIR_AddImm8, /*InsnID*/2, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MULHU),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 333,
        GIR_Done,
      // Label 417: @15528
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(15554), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtMOrZmmul_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (MUL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::MUL),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 310,
        GIR_Done,
      // Label 418: @15554
      GIM_Reject,
    // Label 416: @15555
    GIM_Reject,
    // Label 389: @15556
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(15695),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(15639), // Rule ID 50821 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50821,
        GIR_Done,
      // Label 420: @15639
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(15694), // Rule ID 50822 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMUL_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50822,
        GIR_Done,
      // Label 421: @15694
      GIM_Reject,
    // Label 419: @15695
    GIM_Reject,
    // Label 390: @15696
    GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(15835),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(15779), // Rule ID 50833 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50833,
        GIR_Done,
      // Label 423: @15779
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(15834), // Rule ID 50834 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50834,
        GIR_Done,
      // Label 424: @15834
      GIM_Reject,
    // Label 422: @15835
    GIM_Reject,
    // Label 391: @15836
    GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(15975),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(15919), // Rule ID 50841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50841,
        GIR_Done,
      // Label 426: @15919
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(15974), // Rule ID 50842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50842,
        GIR_Done,
      // Label 427: @15974
      GIM_Reject,
    // Label 425: @15975
    GIM_Reject,
    // Label 392: @15976
    GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(16115),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(16059), // Rule ID 50857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50857,
        GIR_Done,
      // Label 429: @16059
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(16114), // Rule ID 50858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50858,
        GIR_Done,
      // Label 430: @16114
      GIM_Reject,
    // Label 428: @16115
    GIM_Reject,
    // Label 393: @16116
    GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(16255),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(16199), // Rule ID 50825 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50825,
        GIR_Done,
      // Label 432: @16199
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(16254), // Rule ID 50826 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMUL_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50826,
        GIR_Done,
      // Label 433: @16254
      GIM_Reject,
    // Label 431: @16255
    GIM_Reject,
    // Label 394: @16256
    GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(16395),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(16339), // Rule ID 50837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50837,
        GIR_Done,
      // Label 435: @16339
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(16394), // Rule ID 50838 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50838,
        GIR_Done,
      // Label 436: @16394
      GIM_Reject,
    // Label 434: @16395
    GIM_Reject,
    // Label 395: @16396
    GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(16535),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(16479), // Rule ID 50853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50853,
        GIR_Done,
      // Label 438: @16479
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(16534), // Rule ID 50854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50854,
        GIR_Done,
      // Label 439: @16534
      GIM_Reject,
    // Label 437: @16535
    GIM_Reject,
    // Label 396: @16536
    GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(16675),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(16619), // Rule ID 50897 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50897,
        GIR_Done,
      // Label 441: @16619
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(16674), // Rule ID 50898 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50898,
        GIR_Done,
      // Label 442: @16674
      GIM_Reject,
    // Label 440: @16675
    GIM_Reject,
    // Label 397: @16676
    GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(16815),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(16759), // Rule ID 50829 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50829,
        GIR_Done,
      // Label 444: @16759
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(16814), // Rule ID 50830 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMUL_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50830,
        GIR_Done,
      // Label 445: @16814
      GIM_Reject,
    // Label 443: @16815
    GIM_Reject,
    // Label 398: @16816
    GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(16955),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(16899), // Rule ID 50849 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50849,
        GIR_Done,
      // Label 447: @16899
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(16954), // Rule ID 50850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50850,
        GIR_Done,
      // Label 448: @16954
      GIM_Reject,
    // Label 446: @16955
    GIM_Reject,
    // Label 399: @16956
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(17095),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(17039), // Rule ID 50885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50885,
        GIR_Done,
      // Label 450: @17039
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(17094), // Rule ID 50886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50886,
        GIR_Done,
      // Label 451: @17094
      GIM_Reject,
    // Label 449: @17095
    GIM_Reject,
    // Label 400: @17096
    GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(17235),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(17179), // Rule ID 50901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50901,
        GIR_Done,
      // Label 453: @17179
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(17234), // Rule ID 50902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50902,
        GIR_Done,
      // Label 454: @17234
      GIM_Reject,
    // Label 452: @17235
    GIM_Reject,
    // Label 401: @17236
    GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(17375),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(17319), // Rule ID 50845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50845,
        GIR_Done,
      // Label 456: @17319
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(17374), // Rule ID 50846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVMUL_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50846,
        GIR_Done,
      // Label 457: @17374
      GIM_Reject,
    // Label 455: @17375
    GIM_Reject,
    // Label 402: @17376
    GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(17515),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(17459), // Rule ID 50873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50873,
        GIR_Done,
      // Label 459: @17459
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(17514), // Rule ID 50874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50874,
        GIR_Done,
      // Label 460: @17514
      GIM_Reject,
    // Label 458: @17515
    GIM_Reject,
    // Label 403: @17516
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(17655),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(17599), // Rule ID 50889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50889,
        GIR_Done,
      // Label 462: @17599
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(17654), // Rule ID 50890 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50890,
        GIR_Done,
      // Label 463: @17654
      GIM_Reject,
    // Label 461: @17655
    GIM_Reject,
    // Label 404: @17656
    GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(17795),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(17739), // Rule ID 50905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50905,
        GIR_Done,
      // Label 465: @17739
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(17794), // Rule ID 50906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (mul:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50906,
        GIR_Done,
      // Label 466: @17794
      GIM_Reject,
    // Label 464: @17795
    GIM_Reject,
    // Label 405: @17796
    GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(17935),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(17879), // Rule ID 50861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50861,
        GIR_Done,
      // Label 468: @17879
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(17934), // Rule ID 50862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVMUL_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50862,
        GIR_Done,
      // Label 469: @17934
      GIM_Reject,
    // Label 467: @17935
    GIM_Reject,
    // Label 406: @17936
    GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(18075),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(18019), // Rule ID 50877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50877,
        GIR_Done,
      // Label 471: @18019
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(18074), // Rule ID 50878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50878,
        GIR_Done,
      // Label 472: @18074
      GIM_Reject,
    // Label 470: @18075
    GIM_Reject,
    // Label 407: @18076
    GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(18215),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(18159), // Rule ID 50893 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50893,
        GIR_Done,
      // Label 474: @18159
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(18214), // Rule ID 50894 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50894,
        GIR_Done,
      // Label 475: @18214
      GIM_Reject,
    // Label 473: @18215
    GIM_Reject,
    // Label 408: @18216
    GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(18355),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(18299), // Rule ID 50865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50865,
        GIR_Done,
      // Label 477: @18299
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(18354), // Rule ID 50866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVMUL_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50866,
        GIR_Done,
      // Label 478: @18354
      GIM_Reject,
    // Label 476: @18355
    GIM_Reject,
    // Label 409: @18356
    GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(18495),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(18439), // Rule ID 50881 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50881,
        GIR_Done,
      // Label 480: @18439
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(18494), // Rule ID 50882 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50882,
        GIR_Done,
      // Label 481: @18494
      GIM_Reject,
    // Label 479: @18495
    GIM_Reject,
    // Label 410: @18496
    GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(18635),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(18579), // Rule ID 50869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50869,
        GIR_Done,
      // Label 483: @18579
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(18634), // Rule ID 50870 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (mul:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVMUL_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMUL_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 50870,
        GIR_Done,
      // Label 484: @18634
      GIM_Reject,
    // Label 482: @18635
    GIM_Reject,
    // Label 411: @18636
    GIM_Reject,
    // Label 3: @18637
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 509*/ GIMT_Encode4(21970),
    /*GILLT_s32*//*Label 485*/ GIMT_Encode4(18772),
    /*GILLT_s64*//*Label 486*/ GIMT_Encode4(18850), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 487*/ GIMT_Encode4(18890),
    /*GILLT_nxv1s16*//*Label 488*/ GIMT_Encode4(19030),
    /*GILLT_nxv1s32*//*Label 489*/ GIMT_Encode4(19170),
    /*GILLT_nxv1s64*//*Label 490*/ GIMT_Encode4(19310), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 491*/ GIMT_Encode4(19450),
    /*GILLT_nxv2s16*//*Label 492*/ GIMT_Encode4(19590),
    /*GILLT_nxv2s32*//*Label 493*/ GIMT_Encode4(19730),
    /*GILLT_nxv2s64*//*Label 494*/ GIMT_Encode4(19870), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 495*/ GIMT_Encode4(20010),
    /*GILLT_nxv4s16*//*Label 496*/ GIMT_Encode4(20150),
    /*GILLT_nxv4s32*//*Label 497*/ GIMT_Encode4(20290),
    /*GILLT_nxv4s64*//*Label 498*/ GIMT_Encode4(20430), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 499*/ GIMT_Encode4(20570),
    /*GILLT_nxv8s16*//*Label 500*/ GIMT_Encode4(20710),
    /*GILLT_nxv8s32*//*Label 501*/ GIMT_Encode4(20850),
    /*GILLT_nxv8s64*//*Label 502*/ GIMT_Encode4(20990), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 503*/ GIMT_Encode4(21130),
    /*GILLT_nxv16s16*//*Label 504*/ GIMT_Encode4(21270),
    /*GILLT_nxv16s32*//*Label 505*/ GIMT_Encode4(21410), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 506*/ GIMT_Encode4(21550),
    /*GILLT_nxv32s16*//*Label 507*/ GIMT_Encode4(21690), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 508*/ GIMT_Encode4(21830),
    // Label 485: @18772
    GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(18849),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(18816), // Rule ID 319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIV:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 319,
        GIR_Done,
      // Label 511: @18816
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(18832), // Rule ID 336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 336,
        GIR_Done,
      // Label 512: @18832
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(18848), // Rule ID 337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 337,
        GIR_Done,
      // Label 513: @18848
      GIM_Reject,
    // Label 510: @18849
    GIM_Reject,
    // Label 486: @18850
    GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(18889), // Rule ID 318 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (sdiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIV:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIV),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 318,
      GIR_Done,
    // Label 514: @18889
    GIM_Reject,
    // Label 487: @18890
    GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(19029),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(18973), // Rule ID 51173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51173,
        GIR_Done,
      // Label 516: @18973
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(19028), // Rule ID 51174 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIV_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51174,
        GIR_Done,
      // Label 517: @19028
      GIM_Reject,
    // Label 515: @19029
    GIM_Reject,
    // Label 488: @19030
    GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(19169),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(19113), // Rule ID 51185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51185,
        GIR_Done,
      // Label 519: @19113
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(19168), // Rule ID 51186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51186,
        GIR_Done,
      // Label 520: @19168
      GIM_Reject,
    // Label 518: @19169
    GIM_Reject,
    // Label 489: @19170
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(19309),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(19253), // Rule ID 51193 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51193,
        GIR_Done,
      // Label 522: @19253
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(19308), // Rule ID 51194 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51194,
        GIR_Done,
      // Label 523: @19308
      GIM_Reject,
    // Label 521: @19309
    GIM_Reject,
    // Label 490: @19310
    GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(19449),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(19393), // Rule ID 51209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51209,
        GIR_Done,
      // Label 525: @19393
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(19448), // Rule ID 51210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIV_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51210,
        GIR_Done,
      // Label 526: @19448
      GIM_Reject,
    // Label 524: @19449
    GIM_Reject,
    // Label 491: @19450
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(19589),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(19533), // Rule ID 51177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51177,
        GIR_Done,
      // Label 528: @19533
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(19588), // Rule ID 51178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIV_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51178,
        GIR_Done,
      // Label 529: @19588
      GIM_Reject,
    // Label 527: @19589
    GIM_Reject,
    // Label 492: @19590
    GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(19729),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(19673), // Rule ID 51189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51189,
        GIR_Done,
      // Label 531: @19673
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(19728), // Rule ID 51190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51190,
        GIR_Done,
      // Label 532: @19728
      GIM_Reject,
    // Label 530: @19729
    GIM_Reject,
    // Label 493: @19730
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(19869),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(19813), // Rule ID 51205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51205,
        GIR_Done,
      // Label 534: @19813
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(19868), // Rule ID 51206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIV_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51206,
        GIR_Done,
      // Label 535: @19868
      GIM_Reject,
    // Label 533: @19869
    GIM_Reject,
    // Label 494: @19870
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(20009),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(19953), // Rule ID 51249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51249,
        GIR_Done,
      // Label 537: @19953
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(20008), // Rule ID 51250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIV_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51250,
        GIR_Done,
      // Label 538: @20008
      GIM_Reject,
    // Label 536: @20009
    GIM_Reject,
    // Label 495: @20010
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(20149),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(20093), // Rule ID 51181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51181,
        GIR_Done,
      // Label 540: @20093
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(20148), // Rule ID 51182 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIV_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51182,
        GIR_Done,
      // Label 541: @20148
      GIM_Reject,
    // Label 539: @20149
    GIM_Reject,
    // Label 496: @20150
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(20289),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(20233), // Rule ID 51201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51201,
        GIR_Done,
      // Label 543: @20233
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(20288), // Rule ID 51202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIV_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51202,
        GIR_Done,
      // Label 544: @20288
      GIM_Reject,
    // Label 542: @20289
    GIM_Reject,
    // Label 497: @20290
    GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(20429),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(20373), // Rule ID 51237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51237,
        GIR_Done,
      // Label 546: @20373
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(20428), // Rule ID 51238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIV_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51238,
        GIR_Done,
      // Label 547: @20428
      GIM_Reject,
    // Label 545: @20429
    GIM_Reject,
    // Label 498: @20430
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(20569),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(20513), // Rule ID 51253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51253,
        GIR_Done,
      // Label 549: @20513
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(20568), // Rule ID 51254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIV_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51254,
        GIR_Done,
      // Label 550: @20568
      GIM_Reject,
    // Label 548: @20569
    GIM_Reject,
    // Label 499: @20570
    GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(20709),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(20653), // Rule ID 51197 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51197,
        GIR_Done,
      // Label 552: @20653
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(20708), // Rule ID 51198 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIV_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51198,
        GIR_Done,
      // Label 553: @20708
      GIM_Reject,
    // Label 551: @20709
    GIM_Reject,
    // Label 500: @20710
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(20849),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(20793), // Rule ID 51225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51225,
        GIR_Done,
      // Label 555: @20793
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(20848), // Rule ID 51226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIV_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51226,
        GIR_Done,
      // Label 556: @20848
      GIM_Reject,
    // Label 554: @20849
    GIM_Reject,
    // Label 501: @20850
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(20989),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(20933), // Rule ID 51241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51241,
        GIR_Done,
      // Label 558: @20933
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(20988), // Rule ID 51242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIV_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51242,
        GIR_Done,
      // Label 559: @20988
      GIM_Reject,
    // Label 557: @20989
    GIM_Reject,
    // Label 502: @20990
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(21129),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(21073), // Rule ID 51257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51257,
        GIR_Done,
      // Label 561: @21073
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(21128), // Rule ID 51258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (sdiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIV_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51258,
        GIR_Done,
      // Label 562: @21128
      GIM_Reject,
    // Label 560: @21129
    GIM_Reject,
    // Label 503: @21130
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(21269),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(21213), // Rule ID 51213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51213,
        GIR_Done,
      // Label 564: @21213
      GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(21268), // Rule ID 51214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIV_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51214,
        GIR_Done,
      // Label 565: @21268
      GIM_Reject,
    // Label 563: @21269
    GIM_Reject,
    // Label 504: @21270
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(21409),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(21353), // Rule ID 51229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51229,
        GIR_Done,
      // Label 567: @21353
      GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(21408), // Rule ID 51230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIV_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51230,
        GIR_Done,
      // Label 568: @21408
      GIM_Reject,
    // Label 566: @21409
    GIM_Reject,
    // Label 505: @21410
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(21549),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(21493), // Rule ID 51245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51245,
        GIR_Done,
      // Label 570: @21493
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(21548), // Rule ID 51246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIV_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51246,
        GIR_Done,
      // Label 571: @21548
      GIM_Reject,
    // Label 569: @21549
    GIM_Reject,
    // Label 506: @21550
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(21689),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(21633), // Rule ID 51217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51217,
        GIR_Done,
      // Label 573: @21633
      GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(21688), // Rule ID 51218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIV_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51218,
        GIR_Done,
      // Label 574: @21688
      GIM_Reject,
    // Label 572: @21689
    GIM_Reject,
    // Label 507: @21690
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(21829),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(21773), // Rule ID 51233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51233,
        GIR_Done,
      // Label 576: @21773
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(21828), // Rule ID 51234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIV_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51234,
        GIR_Done,
      // Label 577: @21828
      GIM_Reject,
    // Label 575: @21829
    GIM_Reject,
    // Label 508: @21830
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(21969),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(21913), // Rule ID 51221 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51221,
        GIR_Done,
      // Label 579: @21913
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(21968), // Rule ID 51222 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (sdiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIV_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIV_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51222,
        GIR_Done,
      // Label 580: @21968
      GIM_Reject,
    // Label 578: @21969
    GIM_Reject,
    // Label 509: @21970
    GIM_Reject,
    // Label 4: @21971
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 605*/ GIMT_Encode4(25304),
    /*GILLT_s32*//*Label 581*/ GIMT_Encode4(22106),
    /*GILLT_s64*//*Label 582*/ GIMT_Encode4(22184), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 583*/ GIMT_Encode4(22224),
    /*GILLT_nxv1s16*//*Label 584*/ GIMT_Encode4(22364),
    /*GILLT_nxv1s32*//*Label 585*/ GIMT_Encode4(22504),
    /*GILLT_nxv1s64*//*Label 586*/ GIMT_Encode4(22644), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 587*/ GIMT_Encode4(22784),
    /*GILLT_nxv2s16*//*Label 588*/ GIMT_Encode4(22924),
    /*GILLT_nxv2s32*//*Label 589*/ GIMT_Encode4(23064),
    /*GILLT_nxv2s64*//*Label 590*/ GIMT_Encode4(23204), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 591*/ GIMT_Encode4(23344),
    /*GILLT_nxv4s16*//*Label 592*/ GIMT_Encode4(23484),
    /*GILLT_nxv4s32*//*Label 593*/ GIMT_Encode4(23624),
    /*GILLT_nxv4s64*//*Label 594*/ GIMT_Encode4(23764), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 595*/ GIMT_Encode4(23904),
    /*GILLT_nxv8s16*//*Label 596*/ GIMT_Encode4(24044),
    /*GILLT_nxv8s32*//*Label 597*/ GIMT_Encode4(24184),
    /*GILLT_nxv8s64*//*Label 598*/ GIMT_Encode4(24324), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 599*/ GIMT_Encode4(24464),
    /*GILLT_nxv16s16*//*Label 600*/ GIMT_Encode4(24604),
    /*GILLT_nxv16s32*//*Label 601*/ GIMT_Encode4(24744), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 602*/ GIMT_Encode4(24884),
    /*GILLT_nxv32s16*//*Label 603*/ GIMT_Encode4(25024), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 604*/ GIMT_Encode4(25164),
    // Label 581: @22106
    GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(22183),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(22150), // Rule ID 321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 321,
        GIR_Done,
      // Label 607: @22150
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(22166), // Rule ID 338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 338,
        GIR_Done,
      // Label 608: @22166
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(22182), // Rule ID 339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (DIVUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVUW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 339,
        GIR_Done,
      // Label 609: @22182
      GIM_Reject,
    // Label 606: @22183
    GIM_Reject,
    // Label 582: @22184
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(22223), // Rule ID 320 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (udiv:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (DIVU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::DIVU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 320,
      GIR_Done,
    // Label 610: @22223
    GIM_Reject,
    // Label 583: @22224
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(22363),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(22307), // Rule ID 51085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51085,
        GIR_Done,
      // Label 612: @22307
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(22362), // Rule ID 51086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51086,
        GIR_Done,
      // Label 613: @22362
      GIM_Reject,
    // Label 611: @22363
    GIM_Reject,
    // Label 584: @22364
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(22503),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(22447), // Rule ID 51097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51097,
        GIR_Done,
      // Label 615: @22447
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(22502), // Rule ID 51098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51098,
        GIR_Done,
      // Label 616: @22502
      GIM_Reject,
    // Label 614: @22503
    GIM_Reject,
    // Label 585: @22504
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(22643),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(22587), // Rule ID 51105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51105,
        GIR_Done,
      // Label 618: @22587
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(22642), // Rule ID 51106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51106,
        GIR_Done,
      // Label 619: @22642
      GIM_Reject,
    // Label 617: @22643
    GIM_Reject,
    // Label 586: @22644
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(22783),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(22727), // Rule ID 51121 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51121,
        GIR_Done,
      // Label 621: @22727
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(22782), // Rule ID 51122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51122,
        GIR_Done,
      // Label 622: @22782
      GIM_Reject,
    // Label 620: @22783
    GIM_Reject,
    // Label 587: @22784
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(22923),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(22867), // Rule ID 51089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51089,
        GIR_Done,
      // Label 624: @22867
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(22922), // Rule ID 51090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51090,
        GIR_Done,
      // Label 625: @22922
      GIM_Reject,
    // Label 623: @22923
    GIM_Reject,
    // Label 588: @22924
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(23063),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(23007), // Rule ID 51101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51101,
        GIR_Done,
      // Label 627: @23007
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(23062), // Rule ID 51102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51102,
        GIR_Done,
      // Label 628: @23062
      GIM_Reject,
    // Label 626: @23063
    GIM_Reject,
    // Label 589: @23064
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(23203),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(23147), // Rule ID 51117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51117,
        GIR_Done,
      // Label 630: @23147
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(23202), // Rule ID 51118 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51118,
        GIR_Done,
      // Label 631: @23202
      GIM_Reject,
    // Label 629: @23203
    GIM_Reject,
    // Label 590: @23204
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(23343),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(23287), // Rule ID 51161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51161,
        GIR_Done,
      // Label 633: @23287
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(23342), // Rule ID 51162 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51162,
        GIR_Done,
      // Label 634: @23342
      GIM_Reject,
    // Label 632: @23343
    GIM_Reject,
    // Label 591: @23344
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(23483),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(23427), // Rule ID 51093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51093,
        GIR_Done,
      // Label 636: @23427
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(23482), // Rule ID 51094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVDIVU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51094,
        GIR_Done,
      // Label 637: @23482
      GIM_Reject,
    // Label 635: @23483
    GIM_Reject,
    // Label 592: @23484
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(23623),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(23567), // Rule ID 51113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51113,
        GIR_Done,
      // Label 639: @23567
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(23622), // Rule ID 51114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51114,
        GIR_Done,
      // Label 640: @23622
      GIM_Reject,
    // Label 638: @23623
    GIM_Reject,
    // Label 593: @23624
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(23763),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(23707), // Rule ID 51149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51149,
        GIR_Done,
      // Label 642: @23707
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(23762), // Rule ID 51150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51150,
        GIR_Done,
      // Label 643: @23762
      GIM_Reject,
    // Label 641: @23763
    GIM_Reject,
    // Label 594: @23764
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(23903),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(23847), // Rule ID 51165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51165,
        GIR_Done,
      // Label 645: @23847
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(23902), // Rule ID 51166 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51166,
        GIR_Done,
      // Label 646: @23902
      GIM_Reject,
    // Label 644: @23903
    GIM_Reject,
    // Label 595: @23904
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(24043),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(23987), // Rule ID 51109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51109,
        GIR_Done,
      // Label 648: @23987
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(24042), // Rule ID 51110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVDIVU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51110,
        GIR_Done,
      // Label 649: @24042
      GIM_Reject,
    // Label 647: @24043
    GIM_Reject,
    // Label 596: @24044
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(24183),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(24127), // Rule ID 51137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51137,
        GIR_Done,
      // Label 651: @24127
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(24182), // Rule ID 51138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51138,
        GIR_Done,
      // Label 652: @24182
      GIM_Reject,
    // Label 650: @24183
    GIM_Reject,
    // Label 597: @24184
    GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(24323),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(24267), // Rule ID 51153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51153,
        GIR_Done,
      // Label 654: @24267
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(24322), // Rule ID 51154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51154,
        GIR_Done,
      // Label 655: @24322
      GIM_Reject,
    // Label 653: @24323
    GIM_Reject,
    // Label 598: @24324
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(24463),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(24407), // Rule ID 51169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51169,
        GIR_Done,
      // Label 657: @24407
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(24462), // Rule ID 51170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (udiv:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51170,
        GIR_Done,
      // Label 658: @24462
      GIM_Reject,
    // Label 656: @24463
    GIM_Reject,
    // Label 599: @24464
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(24603),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(24547), // Rule ID 51125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51125,
        GIR_Done,
      // Label 660: @24547
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(24602), // Rule ID 51126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVDIVU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51126,
        GIR_Done,
      // Label 661: @24602
      GIM_Reject,
    // Label 659: @24603
    GIM_Reject,
    // Label 600: @24604
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(24743),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(24687), // Rule ID 51141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51141,
        GIR_Done,
      // Label 663: @24687
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(24742), // Rule ID 51142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51142,
        GIR_Done,
      // Label 664: @24742
      GIM_Reject,
    // Label 662: @24743
    GIM_Reject,
    // Label 601: @24744
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(24883),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(24827), // Rule ID 51157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51157,
        GIR_Done,
      // Label 666: @24827
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(24882), // Rule ID 51158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51158,
        GIR_Done,
      // Label 667: @24882
      GIM_Reject,
    // Label 665: @24883
    GIM_Reject,
    // Label 602: @24884
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(25023),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(24967), // Rule ID 51129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51129,
        GIR_Done,
      // Label 669: @24967
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(25022), // Rule ID 51130 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVDIVU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51130,
        GIR_Done,
      // Label 670: @25022
      GIM_Reject,
    // Label 668: @25023
    GIM_Reject,
    // Label 603: @25024
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(25163),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(25107), // Rule ID 51145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51145,
        GIR_Done,
      // Label 672: @25107
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(25162), // Rule ID 51146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51146,
        GIR_Done,
      // Label 673: @25162
      GIM_Reject,
    // Label 671: @25163
    GIM_Reject,
    // Label 604: @25164
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(25303),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(25247), // Rule ID 51133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51133,
        GIR_Done,
      // Label 675: @25247
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(25302), // Rule ID 51134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (udiv:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVDIVU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVDIVU_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51134,
        GIR_Done,
      // Label 676: @25302
      GIM_Reject,
    // Label 674: @25303
    GIM_Reject,
    // Label 605: @25304
    GIM_Reject,
    // Label 5: @25305
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 701*/ GIMT_Encode4(28638),
    /*GILLT_s32*//*Label 677*/ GIMT_Encode4(25440),
    /*GILLT_s64*//*Label 678*/ GIMT_Encode4(25518), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 679*/ GIMT_Encode4(25558),
    /*GILLT_nxv1s16*//*Label 680*/ GIMT_Encode4(25698),
    /*GILLT_nxv1s32*//*Label 681*/ GIMT_Encode4(25838),
    /*GILLT_nxv1s64*//*Label 682*/ GIMT_Encode4(25978), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 683*/ GIMT_Encode4(26118),
    /*GILLT_nxv2s16*//*Label 684*/ GIMT_Encode4(26258),
    /*GILLT_nxv2s32*//*Label 685*/ GIMT_Encode4(26398),
    /*GILLT_nxv2s64*//*Label 686*/ GIMT_Encode4(26538), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 687*/ GIMT_Encode4(26678),
    /*GILLT_nxv4s16*//*Label 688*/ GIMT_Encode4(26818),
    /*GILLT_nxv4s32*//*Label 689*/ GIMT_Encode4(26958),
    /*GILLT_nxv4s64*//*Label 690*/ GIMT_Encode4(27098), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 691*/ GIMT_Encode4(27238),
    /*GILLT_nxv8s16*//*Label 692*/ GIMT_Encode4(27378),
    /*GILLT_nxv8s32*//*Label 693*/ GIMT_Encode4(27518),
    /*GILLT_nxv8s64*//*Label 694*/ GIMT_Encode4(27658), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 695*/ GIMT_Encode4(27798),
    /*GILLT_nxv16s16*//*Label 696*/ GIMT_Encode4(27938),
    /*GILLT_nxv16s32*//*Label 697*/ GIMT_Encode4(28078), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 698*/ GIMT_Encode4(28218),
    /*GILLT_nxv32s16*//*Label 699*/ GIMT_Encode4(28358), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 700*/ GIMT_Encode4(28498),
    // Label 677: @25440
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(25517),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(25484), // Rule ID 323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REM:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 323,
        GIR_Done,
      // Label 703: @25484
      GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(25500), // Rule ID 340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 340,
        GIR_Done,
      // Label 704: @25500
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(25516), // Rule ID 341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (srem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 341,
        GIR_Done,
      // Label 705: @25516
      GIM_Reject,
    // Label 702: @25517
    GIM_Reject,
    // Label 678: @25518
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(25557), // Rule ID 322 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (srem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REM:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REM),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 322,
      GIR_Done,
    // Label 706: @25557
    GIM_Reject,
    // Label 679: @25558
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(25697),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(25641), // Rule ID 51349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51349,
        GIR_Done,
      // Label 708: @25641
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(25696), // Rule ID 51350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREM_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51350,
        GIR_Done,
      // Label 709: @25696
      GIM_Reject,
    // Label 707: @25697
    GIM_Reject,
    // Label 680: @25698
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(25837),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(25781), // Rule ID 51361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51361,
        GIR_Done,
      // Label 711: @25781
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(25836), // Rule ID 51362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREM_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51362,
        GIR_Done,
      // Label 712: @25836
      GIM_Reject,
    // Label 710: @25837
    GIM_Reject,
    // Label 681: @25838
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(25977),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(25921), // Rule ID 51369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51369,
        GIR_Done,
      // Label 714: @25921
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(25976), // Rule ID 51370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREM_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51370,
        GIR_Done,
      // Label 715: @25976
      GIM_Reject,
    // Label 713: @25977
    GIM_Reject,
    // Label 682: @25978
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(26117),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(26061), // Rule ID 51385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51385,
        GIR_Done,
      // Label 717: @26061
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(26116), // Rule ID 51386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREM_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51386,
        GIR_Done,
      // Label 718: @26116
      GIM_Reject,
    // Label 716: @26117
    GIM_Reject,
    // Label 683: @26118
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(26257),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(26201), // Rule ID 51353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51353,
        GIR_Done,
      // Label 720: @26201
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(26256), // Rule ID 51354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREM_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51354,
        GIR_Done,
      // Label 721: @26256
      GIM_Reject,
    // Label 719: @26257
    GIM_Reject,
    // Label 684: @26258
    GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(26397),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(26341), // Rule ID 51365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51365,
        GIR_Done,
      // Label 723: @26341
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(26396), // Rule ID 51366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREM_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51366,
        GIR_Done,
      // Label 724: @26396
      GIM_Reject,
    // Label 722: @26397
    GIM_Reject,
    // Label 685: @26398
    GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(26537),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(26481), // Rule ID 51381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51381,
        GIR_Done,
      // Label 726: @26481
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(26536), // Rule ID 51382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREM_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51382,
        GIR_Done,
      // Label 727: @26536
      GIM_Reject,
    // Label 725: @26537
    GIM_Reject,
    // Label 686: @26538
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(26677),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(26621), // Rule ID 51425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51425,
        GIR_Done,
      // Label 729: @26621
      GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(26676), // Rule ID 51426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREM_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51426,
        GIR_Done,
      // Label 730: @26676
      GIM_Reject,
    // Label 728: @26677
    GIM_Reject,
    // Label 687: @26678
    GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(26817),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(26761), // Rule ID 51357 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51357,
        GIR_Done,
      // Label 732: @26761
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(26816), // Rule ID 51358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREM_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51358,
        GIR_Done,
      // Label 733: @26816
      GIM_Reject,
    // Label 731: @26817
    GIM_Reject,
    // Label 688: @26818
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(26957),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(26901), // Rule ID 51377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51377,
        GIR_Done,
      // Label 735: @26901
      GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(26956), // Rule ID 51378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREM_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51378,
        GIR_Done,
      // Label 736: @26956
      GIM_Reject,
    // Label 734: @26957
    GIM_Reject,
    // Label 689: @26958
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(27097),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(27041), // Rule ID 51413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51413,
        GIR_Done,
      // Label 738: @27041
      GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(27096), // Rule ID 51414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREM_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51414,
        GIR_Done,
      // Label 739: @27096
      GIM_Reject,
    // Label 737: @27097
    GIM_Reject,
    // Label 690: @27098
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(27237),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(27181), // Rule ID 51429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51429,
        GIR_Done,
      // Label 741: @27181
      GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(27236), // Rule ID 51430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREM_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51430,
        GIR_Done,
      // Label 742: @27236
      GIM_Reject,
    // Label 740: @27237
    GIM_Reject,
    // Label 691: @27238
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(27377),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(27321), // Rule ID 51373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51373,
        GIR_Done,
      // Label 744: @27321
      GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(27376), // Rule ID 51374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREM_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51374,
        GIR_Done,
      // Label 745: @27376
      GIM_Reject,
    // Label 743: @27377
    GIM_Reject,
    // Label 692: @27378
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(27517),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(27461), // Rule ID 51401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51401,
        GIR_Done,
      // Label 747: @27461
      GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(27516), // Rule ID 51402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREM_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51402,
        GIR_Done,
      // Label 748: @27516
      GIM_Reject,
    // Label 746: @27517
    GIM_Reject,
    // Label 693: @27518
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(27657),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(27601), // Rule ID 51417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51417,
        GIR_Done,
      // Label 750: @27601
      GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(27656), // Rule ID 51418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREM_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51418,
        GIR_Done,
      // Label 751: @27656
      GIM_Reject,
    // Label 749: @27657
    GIM_Reject,
    // Label 694: @27658
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(27797),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(27741), // Rule ID 51433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51433,
        GIR_Done,
      // Label 753: @27741
      GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(27796), // Rule ID 51434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (srem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREM_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51434,
        GIR_Done,
      // Label 754: @27796
      GIM_Reject,
    // Label 752: @27797
    GIM_Reject,
    // Label 695: @27798
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(27937),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(27881), // Rule ID 51389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51389,
        GIR_Done,
      // Label 756: @27881
      GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(27936), // Rule ID 51390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREM_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51390,
        GIR_Done,
      // Label 757: @27936
      GIM_Reject,
    // Label 755: @27937
    GIM_Reject,
    // Label 696: @27938
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(28077),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(28021), // Rule ID 51405 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51405,
        GIR_Done,
      // Label 759: @28021
      GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(28076), // Rule ID 51406 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREM_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51406,
        GIR_Done,
      // Label 760: @28076
      GIM_Reject,
    // Label 758: @28077
    GIM_Reject,
    // Label 697: @28078
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(28217),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(28161), // Rule ID 51421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51421,
        GIR_Done,
      // Label 762: @28161
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(28216), // Rule ID 51422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREM_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51422,
        GIR_Done,
      // Label 763: @28216
      GIM_Reject,
    // Label 761: @28217
    GIM_Reject,
    // Label 698: @28218
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(28357),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(28301), // Rule ID 51393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51393,
        GIR_Done,
      // Label 765: @28301
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(28356), // Rule ID 51394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREM_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51394,
        GIR_Done,
      // Label 766: @28356
      GIM_Reject,
    // Label 764: @28357
    GIM_Reject,
    // Label 699: @28358
    GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(28497),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(28441), // Rule ID 51409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51409,
        GIR_Done,
      // Label 768: @28441
      GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(28496), // Rule ID 51410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREM_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51410,
        GIR_Done,
      // Label 769: @28496
      GIM_Reject,
    // Label 767: @28497
    GIM_Reject,
    // Label 700: @28498
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(28637),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(28581), // Rule ID 51397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51397,
        GIR_Done,
      // Label 771: @28581
      GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(28636), // Rule ID 51398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (srem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREM_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREM_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51398,
        GIR_Done,
      // Label 772: @28636
      GIM_Reject,
    // Label 770: @28637
    GIM_Reject,
    // Label 701: @28638
    GIM_Reject,
    // Label 6: @28639
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 797*/ GIMT_Encode4(31972),
    /*GILLT_s32*//*Label 773*/ GIMT_Encode4(28774),
    /*GILLT_s64*//*Label 774*/ GIMT_Encode4(28852), GIMT_Encode4(0),
    /*GILLT_nxv1s8*//*Label 775*/ GIMT_Encode4(28892),
    /*GILLT_nxv1s16*//*Label 776*/ GIMT_Encode4(29032),
    /*GILLT_nxv1s32*//*Label 777*/ GIMT_Encode4(29172),
    /*GILLT_nxv1s64*//*Label 778*/ GIMT_Encode4(29312), GIMT_Encode4(0),
    /*GILLT_nxv2s8*//*Label 779*/ GIMT_Encode4(29452),
    /*GILLT_nxv2s16*//*Label 780*/ GIMT_Encode4(29592),
    /*GILLT_nxv2s32*//*Label 781*/ GIMT_Encode4(29732),
    /*GILLT_nxv2s64*//*Label 782*/ GIMT_Encode4(29872), GIMT_Encode4(0),
    /*GILLT_nxv4s8*//*Label 783*/ GIMT_Encode4(30012),
    /*GILLT_nxv4s16*//*Label 784*/ GIMT_Encode4(30152),
    /*GILLT_nxv4s32*//*Label 785*/ GIMT_Encode4(30292),
    /*GILLT_nxv4s64*//*Label 786*/ GIMT_Encode4(30432), GIMT_Encode4(0),
    /*GILLT_nxv8s8*//*Label 787*/ GIMT_Encode4(30572),
    /*GILLT_nxv8s16*//*Label 788*/ GIMT_Encode4(30712),
    /*GILLT_nxv8s32*//*Label 789*/ GIMT_Encode4(30852),
    /*GILLT_nxv8s64*//*Label 790*/ GIMT_Encode4(30992), GIMT_Encode4(0),
    /*GILLT_nxv16s8*//*Label 791*/ GIMT_Encode4(31132),
    /*GILLT_nxv16s16*//*Label 792*/ GIMT_Encode4(31272),
    /*GILLT_nxv16s32*//*Label 793*/ GIMT_Encode4(31412), GIMT_Encode4(0),
    /*GILLT_nxv32s8*//*Label 794*/ GIMT_Encode4(31552),
    /*GILLT_nxv32s16*//*Label 795*/ GIMT_Encode4(31692), GIMT_Encode4(0),
    /*GILLT_nxv64s8*//*Label 796*/ GIMT_Encode4(31832),
    // Label 773: @28774
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(28851),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(28818), // Rule ID 325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMU:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 325,
        GIR_Done,
      // Label 799: @28818
      GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(28834), // Rule ID 342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode0),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 342,
        GIR_Done,
      // Label 800: @28834
      GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(28850), // Rule ID 343 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_IsRV64_HwMode1),
        // (urem:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (REMUW:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMUW),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 343,
        GIR_Done,
      // Label 801: @28850
      GIM_Reject,
    // Label 798: @28851
    GIM_Reject,
    // Label 774: @28852
    GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(28891), // Rule ID 324 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtM_HwMode0),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      // (urem:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (REMU:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::REMU),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
      // GIR_Coverage, 324,
      GIR_Done,
    // Label 802: @28891
    GIM_Reject,
    // Label 775: @28892
    GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(29031),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(28975), // Rule ID 51261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51261,
        GIR_Done,
      // Label 804: @28975
      GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(29030), // Rule ID 51262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVREMU_VV_MF8_E8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51262,
        GIR_Done,
      // Label 805: @29030
      GIM_Reject,
    // Label 803: @29031
    GIM_Reject,
    // Label 776: @29032
    GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(29171),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(29115), // Rule ID 51273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51273,
        GIR_Done,
      // Label 807: @29115
      GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(29170), // Rule ID 51274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E16:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51274,
        GIR_Done,
      // Label 808: @29170
      GIM_Reject,
    // Label 806: @29171
    GIM_Reject,
    // Label 777: @29172
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(29311),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(29255), // Rule ID 51281 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51281,
        GIR_Done,
      // Label 810: @29255
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(29310), // Rule ID 51282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E32:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51282,
        GIR_Done,
      // Label 811: @29310
      GIM_Reject,
    // Label 809: @29311
    GIM_Reject,
    // Label 778: @29312
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(29451),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(29395), // Rule ID 51297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51297,
        GIR_Done,
      // Label 813: @29395
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(29450), // Rule ID 51298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVREMU_VV_M1_E64:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51298,
        GIR_Done,
      // Label 814: @29450
      GIM_Reject,
    // Label 812: @29451
    GIM_Reject,
    // Label 779: @29452
    GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(29591),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(29535), // Rule ID 51265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51265,
        GIR_Done,
      // Label 816: @29535
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(29590), // Rule ID 51266 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVREMU_VV_MF4_E8:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51266,
        GIR_Done,
      // Label 817: @29590
      GIM_Reject,
    // Label 815: @29591
    GIM_Reject,
    // Label 780: @29592
    GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(29731),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(29675), // Rule ID 51277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51277,
        GIR_Done,
      // Label 819: @29675
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(29730), // Rule ID 51278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E16:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51278,
        GIR_Done,
      // Label 820: @29730
      GIM_Reject,
    // Label 818: @29731
    GIM_Reject,
    // Label 781: @29732
    GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(29871),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(29815), // Rule ID 51293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51293,
        GIR_Done,
      // Label 822: @29815
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(29870), // Rule ID 51294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVREMU_VV_M1_E32:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51294,
        GIR_Done,
      // Label 823: @29870
      GIM_Reject,
    // Label 821: @29871
    GIM_Reject,
    // Label 782: @29872
    GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(30011),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(29955), // Rule ID 51337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51337,
        GIR_Done,
      // Label 825: @29955
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(30010), // Rule ID 51338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVREMU_VV_M2_E64:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51338,
        GIR_Done,
      // Label 826: @30010
      GIM_Reject,
    // Label 824: @30011
    GIM_Reject,
    // Label 783: @30012
    GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(30151),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(30095), // Rule ID 51269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51269,
        GIR_Done,
      // Label 828: @30095
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(30150), // Rule ID 51270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVREMU_VV_MF2_E8:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_MF2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51270,
        GIR_Done,
      // Label 829: @30150
      GIM_Reject,
    // Label 827: @30151
    GIM_Reject,
    // Label 784: @30152
    GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(30291),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(30235), // Rule ID 51289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51289,
        GIR_Done,
      // Label 831: @30235
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(30290), // Rule ID 51290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVREMU_VV_M1_E16:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51290,
        GIR_Done,
      // Label 832: @30290
      GIM_Reject,
    // Label 830: @30291
    GIM_Reject,
    // Label 785: @30292
    GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(30431),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(30375), // Rule ID 51325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51325,
        GIR_Done,
      // Label 834: @30375
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(30430), // Rule ID 51326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVREMU_VV_M2_E32:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51326,
        GIR_Done,
      // Label 835: @30430
      GIM_Reject,
    // Label 833: @30431
    GIM_Reject,
    // Label 786: @30432
    GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(30571),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(30515), // Rule ID 51341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51341,
        GIR_Done,
      // Label 837: @30515
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(30570), // Rule ID 51342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVREMU_VV_M4_E64:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51342,
        GIR_Done,
      // Label 838: @30570
      GIM_Reject,
    // Label 836: @30571
    GIM_Reject,
    // Label 787: @30572
    GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(30711),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(30655), // Rule ID 51285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51285,
        GIR_Done,
      // Label 840: @30655
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(30710), // Rule ID 51286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVREMU_VV_M1_E8:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M1_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51286,
        GIR_Done,
      // Label 841: @30710
      GIM_Reject,
    // Label 839: @30711
    GIM_Reject,
    // Label 788: @30712
    GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(30851),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(30795), // Rule ID 51313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51313,
        GIR_Done,
      // Label 843: @30795
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(30850), // Rule ID 51314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVREMU_VV_M2_E16:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51314,
        GIR_Done,
      // Label 844: @30850
      GIM_Reject,
    // Label 842: @30851
    GIM_Reject,
    // Label 789: @30852
    GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(30991),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(30935), // Rule ID 51329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51329,
        GIR_Done,
      // Label 846: @30935
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(30990), // Rule ID 51330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVREMU_VV_M4_E32:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51330,
        GIR_Done,
      // Label 847: @30990
      GIM_Reject,
    // Label 845: @30991
    GIM_Reject,
    // Label 790: @30992
    GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(31131),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(31075), // Rule ID 51345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51345,
        GIR_Done,
      // Label 849: @31075
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(31130), // Rule ID 51346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (urem:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVREMU_VV_M8_E64:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51346,
        GIR_Done,
      // Label 850: @31130
      GIM_Reject,
    // Label 848: @31131
    GIM_Reject,
    // Label 791: @31132
    GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(31271),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(31215), // Rule ID 51301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51301,
        GIR_Done,
      // Label 852: @31215
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(31270), // Rule ID 51302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVREMU_VV_M2_E8:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M2_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51302,
        GIR_Done,
      // Label 853: @31270
      GIM_Reject,
    // Label 851: @31271
    GIM_Reject,
    // Label 792: @31272
    GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(31411),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(31355), // Rule ID 51317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51317,
        GIR_Done,
      // Label 855: @31355
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(31410), // Rule ID 51318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVREMU_VV_M4_E16:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51318,
        GIR_Done,
      // Label 856: @31410
      GIM_Reject,
    // Label 854: @31411
    GIM_Reject,
    // Label 793: @31412
    GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(31551),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(31495), // Rule ID 51333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51333,
        GIR_Done,
      // Label 858: @31495
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(31550), // Rule ID 51334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVREMU_VV_M8_E32:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51334,
        GIR_Done,
      // Label 859: @31550
      GIM_Reject,
    // Label 857: @31551
    GIM_Reject,
    // Label 794: @31552
    GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(31691),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(31635), // Rule ID 51305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51305,
        GIR_Done,
      // Label 861: @31635
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(31690), // Rule ID 51306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVREMU_VV_M4_E8:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M4_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51306,
        GIR_Done,
      // Label 862: @31690
      GIM_Reject,
    // Label 860: @31691
    GIM_Reject,
    // Label 795: @31692
    GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(31831),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(31775), // Rule ID 51321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51321,
        GIR_Done,
      // Label 864: @31775
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(31830), // Rule ID 51322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVREMU_VV_M8_E16:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E16),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51322,
        GIR_Done,
      // Label 865: @31830
      GIM_Reject,
    // Label 863: @31831
    GIM_Reject,
    // Label 796: @31832
    GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(31971),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(31915), // Rule ID 51309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51309,
        GIR_Done,
      // Label 867: @31915
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(31970), // Rule ID 51310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (urem:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVREMU_VV_M8_E8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVREMU_VV_M8_E8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 51310,
        GIR_Done,
      // Label 868: @31970
      GIM_Reject,
    // Label 866: @31971
    GIM_Reject,
    // Label 797: @31972
    GIM_Reject,
    // Label 7: @31973
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 900*/ GIMT_Encode4(38892),
    /*GILLT_s32*//*Label 869*/ GIMT_Encode4(32108),
    /*GILLT_s64*//*Label 870*/ GIMT_Encode4(34100),
    /*GILLT_nxv1s1*//*Label 871*/ GIMT_Encode4(35112),
    /*GILLT_nxv1s8*//*Label 872*/ GIMT_Encode4(35212),
    /*GILLT_nxv1s16*//*Label 873*/ GIMT_Encode4(35352),
    /*GILLT_nxv1s32*//*Label 874*/ GIMT_Encode4(35492),
    /*GILLT_nxv1s64*//*Label 875*/ GIMT_Encode4(35632),
    /*GILLT_nxv2s1*//*Label 876*/ GIMT_Encode4(35772),
    /*GILLT_nxv2s8*//*Label 877*/ GIMT_Encode4(35872),
    /*GILLT_nxv2s16*//*Label 878*/ GIMT_Encode4(36012),
    /*GILLT_nxv2s32*//*Label 879*/ GIMT_Encode4(36152),
    /*GILLT_nxv2s64*//*Label 880*/ GIMT_Encode4(36292),
    /*GILLT_nxv4s1*//*Label 881*/ GIMT_Encode4(36432),
    /*GILLT_nxv4s8*//*Label 882*/ GIMT_Encode4(36532),
    /*GILLT_nxv4s16*//*Label 883*/ GIMT_Encode4(36672),
    /*GILLT_nxv4s32*//*Label 884*/ GIMT_Encode4(36812),
    /*GILLT_nxv4s64*//*Label 885*/ GIMT_Encode4(36952),
    /*GILLT_nxv8s1*//*Label 886*/ GIMT_Encode4(37092),
    /*GILLT_nxv8s8*//*Label 887*/ GIMT_Encode4(37192),
    /*GILLT_nxv8s16*//*Label 888*/ GIMT_Encode4(37332),
    /*GILLT_nxv8s32*//*Label 889*/ GIMT_Encode4(37472),
    /*GILLT_nxv8s64*//*Label 890*/ GIMT_Encode4(37612),
    /*GILLT_nxv16s1*//*Label 891*/ GIMT_Encode4(37752),
    /*GILLT_nxv16s8*//*Label 892*/ GIMT_Encode4(37852),
    /*GILLT_nxv16s16*//*Label 893*/ GIMT_Encode4(37992),
    /*GILLT_nxv16s32*//*Label 894*/ GIMT_Encode4(38132),
    /*GILLT_nxv32s1*//*Label 895*/ GIMT_Encode4(38272),
    /*GILLT_nxv32s8*//*Label 896*/ GIMT_Encode4(38372),
    /*GILLT_nxv32s16*//*Label 897*/ GIMT_Encode4(38512),
    /*GILLT_nxv64s1*//*Label 898*/ GIMT_Encode4(38652),
    /*GILLT_nxv64s8*//*Label 899*/ GIMT_Encode4(38752),
    // Label 869: @32108
    GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(34099),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(32212), // Rule ID 2207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2207,
        GIR_Done,
      // Label 902: @32212
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(32298), // Rule ID 2424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2424,
        GIR_Done,
      // Label 903: @32298
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(32384), // Rule ID 2425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2425,
        GIR_Done,
      // Label 904: @32384
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(32470), // Rule ID 64135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64135,
        GIR_Done,
      // Label 905: @32470
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(32556), // Rule ID 64224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64224,
        GIR_Done,
      // Label 906: @32556
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(32642), // Rule ID 64225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), -1:{ *:[i32] }))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64225,
        GIR_Done,
      // Label 907: @32642
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(32711), // Rule ID 2227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2227,
        GIR_Done,
      // Label 908: @32711
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(32780), // Rule ID 2439 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2439,
        GIR_Done,
      // Label 909: @32780
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(32849), // Rule ID 2440 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt), 1:{ *:[i32] })  =>  (BEXTI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2440,
        GIR_Done,
      // Label 910: @32849
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(32918), // Rule ID 62006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i32] })  =>  (TH_TST:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62006,
        GIR_Done,
      // Label 911: @32918
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(32982), // Rule ID 2215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2215,
        GIR_Done,
      // Label 912: @32982
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(33046), // Rule ID 2432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2432,
        GIR_Done,
      // Label 913: @33046
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(33110), // Rule ID 2433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), 1:{ *:[i32] })  =>  (BEXT:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2433,
        GIR_Done,
      // Label 914: @33110
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(33171), // Rule ID 2209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2209,
        GIR_Done,
      // Label 915: @33171
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(33232), // Rule ID 2426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2426,
        GIR_Done,
      // Label 916: @33232
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(33293), // Rule ID 2427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rs1)  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2427,
        GIR_Done,
      // Label 917: @33293
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(33354), // Rule ID 64127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64127,
        GIR_Done,
      // Label 918: @33354
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(33415), // Rule ID 64201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64201,
        GIR_Done,
      // Label 919: @33415
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(33476), // Rule ID 64202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64202,
        GIR_Done,
      // Label 920: @33476
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(33537), // Rule ID 64137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64137,
        GIR_Done,
      // Label 921: @33537
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(33598), // Rule ID 64226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64226,
        GIR_Done,
      // Label 922: @33598
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(33659), // Rule ID 64227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GPR:{ *:[i32] }:$rs2))  =>  (BCLR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64227,
        GIR_Done,
      // Label 923: @33659
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(33720), // Rule ID 2189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2189,
        GIR_Done,
      // Label 924: @33720
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(33781), // Rule ID 2395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2395,
        GIR_Done,
      // Label 925: @33781
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(33842), // Rule ID 2396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ANDN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2396,
        GIR_Done,
      // Label 926: @33842
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(33883), // Rule ID 2287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2287,
        GIR_Done,
      // Label 927: @33883
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(33924), // Rule ID 2288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV32_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs, 65535:{ *:[i32] })  =>  (ZEXT_H_RV32:{ *:[i32] } GPR:{ *:[i32] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV32),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2288,
        GIR_Done,
      // Label 928: @33924
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(33971), // Rule ID 80 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 80,
        GIR_Done,
      // Label 929: @33971
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(34020), // Rule ID 297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ANDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 297,
        GIR_Done,
      // Label 930: @34020
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(34046), // Rule ID 78 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 78,
        GIR_Done,
      // Label 931: @34046
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(34072), // Rule ID 287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 287,
        GIR_Done,
      // Label 932: @34072
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(34098), // Rule ID 288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (AND:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 288,
        GIR_Done,
      // Label 933: @34098
      GIM_Reject,
    // Label 901: @34099
    GIM_Reject,
    // Label 870: @34100
    GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(35111),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(34204), // Rule ID 2206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2206,
        GIR_Done,
      // Label 935: @34204
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(34290), // Rule ID 64134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), -1:{ *:[i64] }))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64134,
        GIR_Done,
      // Label 936: @34290
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(34368), // Rule ID 2434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (anyext:{ *:[i64] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2))), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2434,
        GIR_Done,
      // Label 937: @34368
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(34437), // Rule ID 2226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (BEXTI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXTI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2226,
        GIR_Done,
      // Label 938: @34437
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(34506), // Rule ID 62005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimmlog2xlen),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckIsSafeToFold, /*InsnID*/2,
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt), 1:{ *:[i64] })  =>  (TH_TST:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimmlog2xlen>>:$shamt)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::TH_TST),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shamt
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 62005,
        GIR_Done,
      // Label 939: @34506
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(34570), // Rule ID 2214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (and:{ *:[i64] } (srl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), 1:{ *:[i64] })  =>  (BEXT:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BEXT),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2214,
        GIR_Done,
      // Label 940: @34570
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(34631), // Rule ID 2208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rs1)  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2208,
        GIR_Done,
      // Label 941: @34631
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(34692), // Rule ID 64126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64126,
        GIR_Done,
      // Label 942: @34692
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(34753), // Rule ID 64136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GPR:{ *:[i64] }:$rs2))  =>  (BCLR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BCLR),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64136,
        GIR_Done,
      // Label 943: @34753
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(34814), // Rule ID 2188 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ANDN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2188,
        GIR_Done,
      // Label 944: @34814
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(34878), // Rule ID 228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_NotHasStdExtZba_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] })  =>  (SRLI:{ *:[i64] } (SLLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SLLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 228,
        GIR_Done,
      // Label 945: @34878
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(34919), // Rule ID 2289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbb_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 65535:{ *:[i64] })  =>  (ZEXT_H_RV64:{ *:[i64] } GPR:{ *:[i64] }:$rs)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ZEXT_H_RV64),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2289,
        GIR_Done,
      // Label 946: @34919
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(34966), // Rule ID 2355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs, 4294967295:{ *:[i64] })  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs, X0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(RISCV::X0), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2355,
        GIR_Done,
      // Label 947: @34966
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(35013), // Rule ID 79 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ANDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ANDI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 79,
        GIR_Done,
      // Label 948: @35013
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(35084), // Rule ID 2353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_Shifted32OnesMask),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>><<X:TrailingZeros>>:$mask)  =>  (SLLI_UW:{ *:[i64] } (SRLI:{ *:[i32] } GPR:{ *:[i64] }:$rs1, (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask)), (TrailingZeros:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_Shifted32OnesMask>>:$mask))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::SLLI_UW),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderTrailingZeros), // mask
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2353,
        GIR_Done,
      // Label 949: @35084
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(35110), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (AND:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::AND),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 77,
        GIR_Done,
      // Label 950: @35110
      GIM_Reject,
    // Label 934: @35111
    GIM_Reject,
    // Label 871: @35112
    GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(35211),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(35175), // Rule ID 52949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52949,
        GIR_Done,
      // Label 952: @35175
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(35210), // Rule ID 52950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMAND_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52950,
        GIR_Done,
      // Label 953: @35210
      GIM_Reject,
    // Label 951: @35211
    GIM_Reject,
    // Label 872: @35212
    GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(35351),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(35295), // Rule ID 47709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47709,
        GIR_Done,
      // Label 955: @35295
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(35350), // Rule ID 47710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVAND_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47710,
        GIR_Done,
      // Label 956: @35350
      GIM_Reject,
    // Label 954: @35351
    GIM_Reject,
    // Label 873: @35352
    GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(35491),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(35435), // Rule ID 47721 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47721,
        GIR_Done,
      // Label 958: @35435
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(35490), // Rule ID 47722 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47722,
        GIR_Done,
      // Label 959: @35490
      GIM_Reject,
    // Label 957: @35491
    GIM_Reject,
    // Label 874: @35492
    GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(35631),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(35575), // Rule ID 47729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47729,
        GIR_Done,
      // Label 961: @35575
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(35630), // Rule ID 47730 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47730,
        GIR_Done,
      // Label 962: @35630
      GIM_Reject,
    // Label 960: @35631
    GIM_Reject,
    // Label 875: @35632
    GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(35771),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(35715), // Rule ID 47745 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47745,
        GIR_Done,
      // Label 964: @35715
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(35770), // Rule ID 47746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47746,
        GIR_Done,
      // Label 965: @35770
      GIM_Reject,
    // Label 963: @35771
    GIM_Reject,
    // Label 876: @35772
    GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(35871),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(35835), // Rule ID 52967 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52967,
        GIR_Done,
      // Label 967: @35835
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(35870), // Rule ID 52968 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMAND_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52968,
        GIR_Done,
      // Label 968: @35870
      GIM_Reject,
    // Label 966: @35871
    GIM_Reject,
    // Label 877: @35872
    GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(36011),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(35955), // Rule ID 47713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47713,
        GIR_Done,
      // Label 970: @35955
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(36010), // Rule ID 47714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVAND_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47714,
        GIR_Done,
      // Label 971: @36010
      GIM_Reject,
    // Label 969: @36011
    GIM_Reject,
    // Label 878: @36012
    GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(36151),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(36095), // Rule ID 47725 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47725,
        GIR_Done,
      // Label 973: @36095
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(36150), // Rule ID 47726 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47726,
        GIR_Done,
      // Label 974: @36150
      GIM_Reject,
    // Label 972: @36151
    GIM_Reject,
    // Label 879: @36152
    GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(36291),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(36235), // Rule ID 47741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47741,
        GIR_Done,
      // Label 976: @36235
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(36290), // Rule ID 47742 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47742,
        GIR_Done,
      // Label 977: @36290
      GIM_Reject,
    // Label 975: @36291
    GIM_Reject,
    // Label 880: @36292
    GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(36431),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(36375), // Rule ID 47785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47785,
        GIR_Done,
      // Label 979: @36375
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(36430), // Rule ID 47786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47786,
        GIR_Done,
      // Label 980: @36430
      GIM_Reject,
    // Label 978: @36431
    GIM_Reject,
    // Label 881: @36432
    GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(36531),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(36495), // Rule ID 52985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52985,
        GIR_Done,
      // Label 982: @36495
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(36530), // Rule ID 52986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2)  =>  (PseudoVMAND_MM_MF2:{ *:[nxv4i1] } VR:{ *:[nxv4i1] }:$rs1, VR:{ *:[nxv4i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52986,
        GIR_Done,
      // Label 983: @36530
      GIM_Reject,
    // Label 981: @36531
    GIM_Reject,
    // Label 882: @36532
    GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(36671),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(36615), // Rule ID 47717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47717,
        GIR_Done,
      // Label 985: @36615
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(36670), // Rule ID 47718 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVAND_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47718,
        GIR_Done,
      // Label 986: @36670
      GIM_Reject,
    // Label 984: @36671
    GIM_Reject,
    // Label 883: @36672
    GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(36811),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(36755), // Rule ID 47737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47737,
        GIR_Done,
      // Label 988: @36755
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(36810), // Rule ID 47738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv4i16] } (IMPLICIT_DEF:{ *:[nxv4i16] }), VR:{ *:[nxv4i16] }:$rs1, VR:{ *:[nxv4i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47738,
        GIR_Done,
      // Label 989: @36810
      GIM_Reject,
    // Label 987: @36811
    GIM_Reject,
    // Label 884: @36812
    GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(36951),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(36895), // Rule ID 47773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47773,
        GIR_Done,
      // Label 991: @36895
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(36950), // Rule ID 47774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv4i32] } VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv4i32] } (IMPLICIT_DEF:{ *:[nxv4i32] }), VRM2:{ *:[nxv4i32] }:$rs1, VRM2:{ *:[nxv4i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47774,
        GIR_Done,
      // Label 992: @36950
      GIM_Reject,
    // Label 990: @36951
    GIM_Reject,
    // Label 885: @36952
    GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(37091),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv4s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv4s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(37035), // Rule ID 47789 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47789,
        GIR_Done,
      // Label 994: @37035
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(37090), // Rule ID 47790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv4i64] } VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv4i64] } (IMPLICIT_DEF:{ *:[nxv4i64] }), VRM4:{ *:[nxv4i64] }:$rs1, VRM4:{ *:[nxv4i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47790,
        GIR_Done,
      // Label 995: @37090
      GIM_Reject,
    // Label 993: @37091
    GIM_Reject,
    // Label 886: @37092
    GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(37191),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(37155), // Rule ID 53003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53003,
        GIR_Done,
      // Label 997: @37155
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(37190), // Rule ID 53004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2)  =>  (PseudoVMAND_MM_M1:{ *:[nxv8i1] } VR:{ *:[nxv8i1] }:$rs1, VR:{ *:[nxv8i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53004,
        GIR_Done,
      // Label 998: @37190
      GIM_Reject,
    // Label 996: @37191
    GIM_Reject,
    // Label 887: @37192
    GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(37331),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(37275), // Rule ID 47733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47733,
        GIR_Done,
      // Label 1000: @37275
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(37330), // Rule ID 47734 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i8] } VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2)  =>  (PseudoVAND_VV_M1:{ *:[nxv8i8] } (IMPLICIT_DEF:{ *:[nxv8i8] }), VR:{ *:[nxv8i8] }:$rs1, VR:{ *:[nxv8i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47734,
        GIR_Done,
      // Label 1001: @37330
      GIM_Reject,
    // Label 999: @37331
    GIM_Reject,
    // Label 888: @37332
    GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(37471),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(37415), // Rule ID 47761 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47761,
        GIR_Done,
      // Label 1003: @37415
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(37470), // Rule ID 47762 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i16] } VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv8i16] } (IMPLICIT_DEF:{ *:[nxv8i16] }), VRM2:{ *:[nxv8i16] }:$rs1, VRM2:{ *:[nxv8i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47762,
        GIR_Done,
      // Label 1004: @37470
      GIM_Reject,
    // Label 1002: @37471
    GIM_Reject,
    // Label 889: @37472
    GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(37611),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(37555), // Rule ID 47777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47777,
        GIR_Done,
      // Label 1006: @37555
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(37610), // Rule ID 47778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv8i32] } VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv8i32] } (IMPLICIT_DEF:{ *:[nxv8i32] }), VRM4:{ *:[nxv8i32] }:$rs1, VRM4:{ *:[nxv8i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47778,
        GIR_Done,
      // Label 1007: @37610
      GIM_Reject,
    // Label 1005: @37611
    GIM_Reject,
    // Label 890: @37612
    GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(37751),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv8s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv8s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(37695), // Rule ID 47793 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47793,
        GIR_Done,
      // Label 1009: @37695
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(37750), // Rule ID 47794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (and:{ *:[nxv8i64] } VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv8i64] } (IMPLICIT_DEF:{ *:[nxv8i64] }), VRM8:{ *:[nxv8i64] }:$rs1, VRM8:{ *:[nxv8i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv8s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47794,
        GIR_Done,
      // Label 1010: @37750
      GIM_Reject,
    // Label 1008: @37751
    GIM_Reject,
    // Label 891: @37752
    GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(37851),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(37815), // Rule ID 53021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53021,
        GIR_Done,
      // Label 1012: @37815
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(37850), // Rule ID 53022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2)  =>  (PseudoVMAND_MM_M2:{ *:[nxv16i1] } VR:{ *:[nxv16i1] }:$rs1, VR:{ *:[nxv16i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53022,
        GIR_Done,
      // Label 1013: @37850
      GIM_Reject,
    // Label 1011: @37851
    GIM_Reject,
    // Label 892: @37852
    GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(37991),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(37935), // Rule ID 47749 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47749,
        GIR_Done,
      // Label 1015: @37935
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(37990), // Rule ID 47750 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i8] } VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2)  =>  (PseudoVAND_VV_M2:{ *:[nxv16i8] } (IMPLICIT_DEF:{ *:[nxv16i8] }), VRM2:{ *:[nxv16i8] }:$rs1, VRM2:{ *:[nxv16i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47750,
        GIR_Done,
      // Label 1016: @37990
      GIM_Reject,
    // Label 1014: @37991
    GIM_Reject,
    // Label 893: @37992
    GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(38131),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(38075), // Rule ID 47765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47765,
        GIR_Done,
      // Label 1018: @38075
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(38130), // Rule ID 47766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i16] } VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv16i16] } (IMPLICIT_DEF:{ *:[nxv16i16] }), VRM4:{ *:[nxv16i16] }:$rs1, VRM4:{ *:[nxv16i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47766,
        GIR_Done,
      // Label 1019: @38130
      GIM_Reject,
    // Label 1017: @38131
    GIM_Reject,
    // Label 894: @38132
    GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(38271),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv16s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv16s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(38215), // Rule ID 47781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47781,
        GIR_Done,
      // Label 1021: @38215
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(38270), // Rule ID 47782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv16i32] } VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv16i32] } (IMPLICIT_DEF:{ *:[nxv16i32] }), VRM8:{ *:[nxv16i32] }:$rs1, VRM8:{ *:[nxv16i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv16s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47782,
        GIR_Done,
      // Label 1022: @38270
      GIM_Reject,
    // Label 1020: @38271
    GIM_Reject,
    // Label 895: @38272
    GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(38371),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(38335), // Rule ID 53039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53039,
        GIR_Done,
      // Label 1024: @38335
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(38370), // Rule ID 53040 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2)  =>  (PseudoVMAND_MM_M4:{ *:[nxv32i1] } VR:{ *:[nxv32i1] }:$rs1, VR:{ *:[nxv32i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53040,
        GIR_Done,
      // Label 1025: @38370
      GIM_Reject,
    // Label 1023: @38371
    GIM_Reject,
    // Label 896: @38372
    GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(38511),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM4RegClassID),
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(38455), // Rule ID 47753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47753,
        GIR_Done,
      // Label 1027: @38455
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(38510), // Rule ID 47754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i8] } VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2)  =>  (PseudoVAND_VV_M4:{ *:[nxv32i8] } (IMPLICIT_DEF:{ *:[nxv32i8] }), VRM4:{ *:[nxv32i8] }:$rs1, VRM4:{ *:[nxv32i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47754,
        GIR_Done,
      // Label 1028: @38510
      GIM_Reject,
    // Label 1026: @38511
    GIM_Reject,
    // Label 897: @38512
    GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(38651),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv32s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv32s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(38595), // Rule ID 47769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47769,
        GIR_Done,
      // Label 1030: @38595
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(38650), // Rule ID 47770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv32i16] } VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv32i16] } (IMPLICIT_DEF:{ *:[nxv32i16] }), VRM8:{ *:[nxv32i16] }:$rs1, VRM8:{ *:[nxv32i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv32s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47770,
        GIR_Done,
      // Label 1031: @38650
      GIM_Reject,
    // Label 1029: @38651
    GIM_Reject,
    // Label 898: @38652
    GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(38751),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(38715), // Rule ID 53057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53057,
        GIR_Done,
      // Label 1033: @38715
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(38750), // Rule ID 53058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2)  =>  (PseudoVMAND_MM_M8:{ *:[nxv64i1] } VR:{ *:[nxv64i1] }:$rs1, VR:{ *:[nxv64i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMAND_MM_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 53058,
        GIR_Done,
      // Label 1034: @38750
      GIM_Reject,
    // Label 1032: @38751
    GIM_Reject,
    // Label 899: @38752
    GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(38891),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv64s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv64s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM8RegClassID),
      GIM_Try, /*On fail goto*//*Label 1036*/ GIMT_Encode4(38835), // Rule ID 47757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47757,
        GIR_Done,
      // Label 1036: @38835
      GIM_Try, /*On fail goto*//*Label 1037*/ GIMT_Encode4(38890), // Rule ID 47758 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (and:{ *:[nxv64i8] } VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2)  =>  (PseudoVAND_VV_M8:{ *:[nxv64i8] } (IMPLICIT_DEF:{ *:[nxv64i8] }), VRM8:{ *:[nxv64i8] }:$rs1, VRM8:{ *:[nxv64i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVAND_VV_M8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47758,
        GIR_Done,
      // Label 1037: @38890
      GIM_Reject,
    // Label 1035: @38891
    GIM_Reject,
    // Label 900: @38892
    GIM_Reject,
    // Label 8: @38893
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 1069*/ GIMT_Encode4(44095),
    /*GILLT_s32*//*Label 1038*/ GIMT_Encode4(39028),
    /*GILLT_s64*//*Label 1039*/ GIMT_Encode4(39972),
    /*GILLT_nxv1s1*//*Label 1040*/ GIMT_Encode4(40315),
    /*GILLT_nxv1s8*//*Label 1041*/ GIMT_Encode4(40415),
    /*GILLT_nxv1s16*//*Label 1042*/ GIMT_Encode4(40555),
    /*GILLT_nxv1s32*//*Label 1043*/ GIMT_Encode4(40695),
    /*GILLT_nxv1s64*//*Label 1044*/ GIMT_Encode4(40835),
    /*GILLT_nxv2s1*//*Label 1045*/ GIMT_Encode4(40975),
    /*GILLT_nxv2s8*//*Label 1046*/ GIMT_Encode4(41075),
    /*GILLT_nxv2s16*//*Label 1047*/ GIMT_Encode4(41215),
    /*GILLT_nxv2s32*//*Label 1048*/ GIMT_Encode4(41355),
    /*GILLT_nxv2s64*//*Label 1049*/ GIMT_Encode4(41495),
    /*GILLT_nxv4s1*//*Label 1050*/ GIMT_Encode4(41635),
    /*GILLT_nxv4s8*//*Label 1051*/ GIMT_Encode4(41735),
    /*GILLT_nxv4s16*//*Label 1052*/ GIMT_Encode4(41875),
    /*GILLT_nxv4s32*//*Label 1053*/ GIMT_Encode4(42015),
    /*GILLT_nxv4s64*//*Label 1054*/ GIMT_Encode4(42155),
    /*GILLT_nxv8s1*//*Label 1055*/ GIMT_Encode4(42295),
    /*GILLT_nxv8s8*//*Label 1056*/ GIMT_Encode4(42395),
    /*GILLT_nxv8s16*//*Label 1057*/ GIMT_Encode4(42535),
    /*GILLT_nxv8s32*//*Label 1058*/ GIMT_Encode4(42675),
    /*GILLT_nxv8s64*//*Label 1059*/ GIMT_Encode4(42815),
    /*GILLT_nxv16s1*//*Label 1060*/ GIMT_Encode4(42955),
    /*GILLT_nxv16s8*//*Label 1061*/ GIMT_Encode4(43055),
    /*GILLT_nxv16s16*//*Label 1062*/ GIMT_Encode4(43195),
    /*GILLT_nxv16s32*//*Label 1063*/ GIMT_Encode4(43335),
    /*GILLT_nxv32s1*//*Label 1064*/ GIMT_Encode4(43475),
    /*GILLT_nxv32s8*//*Label 1065*/ GIMT_Encode4(43575),
    /*GILLT_nxv32s16*//*Label 1066*/ GIMT_Encode4(43715),
    /*GILLT_nxv64s1*//*Label 1067*/ GIMT_Encode4(43855),
    /*GILLT_nxv64s8*//*Label 1068*/ GIMT_Encode4(43955),
    // Label 1038: @39028
    GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(39971),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(39110), // Rule ID 2211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2211,
        GIR_Done,
      // Label 1071: @39110
      GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(39174), // Rule ID 2428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2428,
        GIR_Done,
      // Label 1072: @39174
      GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(39238), // Rule ID 2429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)), GPR:{ *:[i32] }:$rs1)  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2429,
        GIR_Done,
      // Label 1073: @39238
      GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(39302), // Rule ID 64139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)))  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64139,
        GIR_Done,
      // Label 1074: @39302
      GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(39366), // Rule ID 64228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)))  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64228,
        GIR_Done,
      // Label 1075: @39366
      GIM_Try, /*On fail goto*//*Label 1076*/ GIMT_Encode4(39430), // Rule ID 64229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (shl:{ *:[i32] } 1:{ *:[i32] }, (shiftMaskXLen:{ *:[i32] } GPR:{ *:[i32] }:$rs2)))  =>  (BSET:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64229,
        GIR_Done,
      // Label 1076: @39430
      GIM_Try, /*On fail goto*//*Label 1077*/ GIMT_Encode4(39491), // Rule ID 64129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64129,
        GIR_Done,
      // Label 1077: @39491
      GIM_Try, /*On fail goto*//*Label 1078*/ GIMT_Encode4(39552), // Rule ID 64203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64203,
        GIR_Done,
      // Label 1078: @39552
      GIM_Try, /*On fail goto*//*Label 1079*/ GIMT_Encode4(39613), // Rule ID 64204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }), GPR:{ *:[i32] }:$rs1)  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64204,
        GIR_Done,
      // Label 1079: @39613
      GIM_Try, /*On fail goto*//*Label 1080*/ GIMT_Encode4(39674), // Rule ID 2191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2191,
        GIR_Done,
      // Label 1080: @39674
      GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(39735), // Rule ID 2397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2397,
        GIR_Done,
      // Label 1081: @39735
      GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(39796), // Rule ID 2398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (xor:{ *:[i32] } GPR:{ *:[i32] }:$rs2, -1:{ *:[i32] }))  =>  (ORN:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2398,
        GIR_Done,
      // Label 1082: @39796
      GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(39843), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 76,
        GIR_Done,
      // Label 1083: @39843
      GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(39892), // Rule ID 298 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12i32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12i32>>:$imm)  =>  (ORI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (as_i64imm:{ *:[i64] } ?:{ *:[i32] }:$imm))
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderImm), // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 298,
        GIR_Done,
      // Label 1084: @39892
      GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(39918), // Rule ID 74 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 74,
        GIR_Done,
      // Label 1085: @39918
      GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(39944), // Rule ID 289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 289,
        GIR_Done,
      // Label 1086: @39944
      GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(39970), // Rule ID 290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (OR:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 290,
        GIR_Done,
      // Label 1087: @39970
      GIM_Reject,
    // Label 1070: @39971
    GIM_Reject,
    // Label 1039: @39972
    GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(40314),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(40054), // Rule ID 2210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)), GPR:{ *:[i64] }:$rs1)  =>  (BSET:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2210,
        GIR_Done,
      // Label 1089: @40054
      GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(40118), // Rule ID 64138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbs_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_GIShiftMaskXLen),
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (shl:{ *:[i64] } 1:{ *:[i64] }, (shiftMaskXLen:{ *:[i64] } GPR:{ *:[i64] }:$rs2)))  =>  (BSET:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::BSET),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64138,
        GIR_Done,
      // Label 1090: @40118
      GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(40179), // Rule ID 64128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }), GPR:{ *:[i64] }:$rs1)  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 64128,
        GIR_Done,
      // Label 1091: @40179
      GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(40240), // Rule ID 2190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZbbOrZbkb_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (xor:{ *:[i64] } GPR:{ *:[i64] }:$rs2, -1:{ *:[i64] }))  =>  (ORN:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORN),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 2190,
        GIR_Done,
      // Label 1092: @40240
      GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(40287), // Rule ID 75 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*InsnID*/1,
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ORI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ORI),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 75,
        GIR_Done,
      // Label 1093: @40287
      GIM_Try, /*On fail goto*//*Label 1094*/ GIMT_Encode4(40313), // Rule ID 73 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
        // (or:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (OR:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::OR),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        // GIR_Coverage, 73,
        GIR_Done,
      // Label 1094: @40313
      GIM_Reject,
    // Label 1088: @40314
    GIM_Reject,
    // Label 1040: @40315
    GIM_Try, /*On fail goto*//*Label 1095*/ GIMT_Encode4(40414),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1096*/ GIMT_Encode4(40378), // Rule ID 52951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMOR_MM_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52951,
        GIR_Done,
      // Label 1096: @40378
      GIM_Try, /*On fail goto*//*Label 1097*/ GIMT_Encode4(40413), // Rule ID 52952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2)  =>  (PseudoVMOR_MM_MF8:{ *:[nxv1i1] } VR:{ *:[nxv1i1] }:$rs1, VR:{ *:[nxv1i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMOR_MM_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52952,
        GIR_Done,
      // Label 1097: @40413
      GIM_Reject,
    // Label 1095: @40414
    GIM_Reject,
    // Label 1041: @40415
    GIM_Try, /*On fail goto*//*Label 1098*/ GIMT_Encode4(40554),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1099*/ GIMT_Encode4(40498), // Rule ID 47841 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47841,
        GIR_Done,
      // Label 1099: @40498
      GIM_Try, /*On fail goto*//*Label 1100*/ GIMT_Encode4(40553), // Rule ID 47842 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVOR_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF8),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47842,
        GIR_Done,
      // Label 1100: @40553
      GIM_Reject,
    // Label 1098: @40554
    GIM_Reject,
    // Label 1042: @40555
    GIM_Try, /*On fail goto*//*Label 1101*/ GIMT_Encode4(40694),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1102*/ GIMT_Encode4(40638), // Rule ID 47853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47853,
        GIR_Done,
      // Label 1102: @40638
      GIM_Try, /*On fail goto*//*Label 1103*/ GIMT_Encode4(40693), // Rule ID 47854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47854,
        GIR_Done,
      // Label 1103: @40693
      GIM_Reject,
    // Label 1101: @40694
    GIM_Reject,
    // Label 1043: @40695
    GIM_Try, /*On fail goto*//*Label 1104*/ GIMT_Encode4(40834),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1105*/ GIMT_Encode4(40778), // Rule ID 47861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47861,
        GIR_Done,
      // Label 1105: @40778
      GIM_Try, /*On fail goto*//*Label 1106*/ GIMT_Encode4(40833), // Rule ID 47862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47862,
        GIR_Done,
      // Label 1106: @40833
      GIM_Reject,
    // Label 1104: @40834
    GIM_Reject,
    // Label 1044: @40835
    GIM_Try, /*On fail goto*//*Label 1107*/ GIMT_Encode4(40974),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv1s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv1s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1108*/ GIMT_Encode4(40918), // Rule ID 47877 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47877,
        GIR_Done,
      // Label 1108: @40918
      GIM_Try, /*On fail goto*//*Label 1109*/ GIMT_Encode4(40973), // Rule ID 47878 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (or:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47878,
        GIR_Done,
      // Label 1109: @40973
      GIM_Reject,
    // Label 1107: @40974
    GIM_Reject,
    // Label 1045: @40975
    GIM_Try, /*On fail goto*//*Label 1110*/ GIMT_Encode4(41074),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s1,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s1,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1111*/ GIMT_Encode4(41038), // Rule ID 52969 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i64] }, 0:{ *:[i64] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMOR_MM_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52969,
        GIR_Done,
      // Label 1111: @41038
      GIM_Try, /*On fail goto*//*Label 1112*/ GIMT_Encode4(41073), // Rule ID 52970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2)  =>  (PseudoVMOR_MM_MF4:{ *:[nxv2i1] } VR:{ *:[nxv2i1] }:$rs1, VR:{ *:[nxv2i1] }:$rs2, -1:{ *:[i32] }, 0:{ *:[i32] })
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMOR_MM_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 52970,
        GIR_Done,
      // Label 1112: @41073
      GIM_Reject,
    // Label 1110: @41074
    GIM_Reject,
    // Label 1046: @41075
    GIM_Try, /*On fail goto*//*Label 1113*/ GIMT_Encode4(41214),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s8,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s8,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1114*/ GIMT_Encode4(41158), // Rule ID 47845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47845,
        GIR_Done,
      // Label 1114: @41158
      GIM_Try, /*On fail goto*//*Label 1115*/ GIMT_Encode4(41213), // Rule ID 47846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVOR_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF4),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47846,
        GIR_Done,
      // Label 1115: @41213
      GIM_Reject,
    // Label 1113: @41214
    GIM_Reject,
    // Label 1047: @41215
    GIM_Try, /*On fail goto*//*Label 1116*/ GIMT_Encode4(41354),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s16,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s16,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1117*/ GIMT_Encode4(41298), // Rule ID 47857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47857,
        GIR_Done,
      // Label 1117: @41298
      GIM_Try, /*On fail goto*//*Label 1118*/ GIMT_Encode4(41353), // Rule ID 47858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVOR_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_MF2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47858,
        GIR_Done,
      // Label 1118: @41353
      GIM_Reject,
    // Label 1116: @41354
    GIM_Reject,
    // Label 1048: @41355
    GIM_Try, /*On fail goto*//*Label 1119*/ GIMT_Encode4(41494),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s32,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s32,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
      GIM_Try, /*On fail goto*//*Label 1120*/ GIMT_Encode4(41438), // Rule ID 47873 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47873,
        GIR_Done,
      // Label 1120: @41438
      GIM_Try, /*On fail goto*//*Label 1121*/ GIMT_Encode4(41493), // Rule ID 47874 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
        // (or:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVOR_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_M1),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47874,
        GIR_Done,
      // Label 1121: @41493
      GIM_Reject,
    // Label 1119: @41494
    GIM_Reject,
    // Label 1049: @41495
    GIM_Try, /*On fail goto*//*Label 1122*/ GIMT_Encode4(41634),
      GIM_CheckType, /*MI*/0, /*Op*/1, /*Type*/GILLT_nxv2s64,
      GIM_CheckType, /*MI*/0, /*Op*/2, /*Type*/GILLT_nxv2s64,
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_CheckRegBankForClass, /*MI*/0, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
      GIM_Try, /*On fail goto*//*Label 1123*/ GIMT_Encode4(41578), // Rule ID 47917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVOR_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildMI, /*InsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::PseudoVOR_VV_M2),
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/0, // DstI[rd]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, // rs1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/2, // rs2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/0,
        GIR_EraseFromParent, /*InsnID*/0,
        // GIR_Coverage, 47917,
        GIR_Done,
      // Label 1123: @41578
      GIM_Try, /*On fail goto*//*Label 1124*/ GIMT_Encode4(41633), // Rule ID 47918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
        // (or:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[