/**
 *
 * @file core_dgetmo.c
 *
 * PaStiX kernel routines
 *
 * @copyright 2010-2015 Univ. of Tennessee, Univ. of California Berkeley and
 *                      Univ. of Colorado Denver. All rights reserved.
 * @copyright 2015-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Gregoire Pichon
 * @date 2024-07-05
 * @generated from /build/pastix/src/pastix-6.4.0/kernels/core_zgetmo.c, normal z -> d, Sun Feb 15 18:01:31 2026
 *
 **/
#include "common.h"

/**
 ******************************************************************************
 *
 * @brief Transposes a m-by-n matrix out of place using an extra workspace of size
 * m-by-n.
 *
 *******************************************************************************
 *
 * @param[in] m
 *         Number of rows of A.
 *
 * @param[in] n
 *         Number of columns of A.
 *
 * @param[in] A
 *         Matrix to be transposed.
 *
 * @param[in] lda
 *         Leading dimension of matrix A.
 *
 * @param[inout] B
 *         On exit B = trans(A).
 *
 * @param[in] ldb
 *         Leading dimension of matrix B.
 *
 ******************************************************************************/
void
core_dgetmo( int                       m,
             int                       n,
             const double *A,
             int                       lda,
             double       *B,
             int                       ldb )
{
    int i, j;

    /* rectangular transposition (use workspace) */
    for (i=0; i<m; i++) {
        for (j=0; j<n; j++) {
            B[j+i*ldb] = A[i+j*lda];
        }
    }
}
