/* Properties.c generated by valac 0.56.18, the Vala compiler
 * generated from Properties.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2016 elementary LLC. (https://github.com/elementary/photos)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PROPERTIES_0_PROPERTY,
	PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* properties_properties[PROPERTIES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
enum  {
	PROPERTIES_HEADER_0_PROPERTY,
	PROPERTIES_HEADER_NUM_PROPERTIES
};
static GParamSpec* properties_header_properties[PROPERTIES_HEADER_NUM_PROPERTIES];
enum  {
	PROPERTIES_LABEL_0_PROPERTY,
	PROPERTIES_LABEL_NUM_PROPERTIES
};
static GParamSpec* properties_label_properties[PROPERTIES_LABEL_NUM_PROPERTIES];

static gpointer properties_parent_class = NULL;
static gpointer properties_header_parent_class = NULL;
static gpointer properties_label_parent_class = NULL;

static void properties_real_get_single_properties (Properties* self,
                                            DataView* view);
static void properties_real_get_multiple_properties (Properties* self,
                                              GeeIterable* iter);
static void properties_real_get_properties (Properties* self,
                                     Page* current_page);
static void properties_real_clear_properties (Properties* self);
static void properties_real_update_properties (Properties* self,
                                        Page* page);
static void properties_real_internal_update_properties (Properties* self,
                                                 Page* page);
static void properties_real_save_changes_to_source (Properties* self);
static GType properties_header_get_type_once (void);
static GType properties_label_get_type_once (void);
static void properties_finalize (GObject * obj);
static GType properties_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

Properties*
properties_construct (GType object_type)
{
	Properties * self = NULL;
	self = (Properties*) g_object_new (object_type, NULL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 0);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	return self;
}

void
properties_add_line (Properties* self,
                     const gchar* label_text,
                     const gchar* info_text)
{
	gboolean _tmp0_ = FALSE;
	PropertiesHeader* label = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PropertiesHeader* _tmp3_;
	PropertiesHeader* _tmp4_;
	const gchar* _tmp5_ = NULL;
	PropertiesLabel* info_label = NULL;
	PropertiesLabel* _tmp6_;
	PropertiesHeader* _tmp7_;
	PropertiesLabel* _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label_text != NULL);
	g_return_if_fail (info_text != NULL);
	if (info_text == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (info_text, "") == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_markup_printf_escaped ("%s", label_text);
	_tmp2_ = _tmp1_;
	_tmp3_ = properties_header_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	label = _tmp4_;
	if (is_string_empty (info_text)) {
		_tmp5_ = "";
	} else {
		_tmp5_ = info_text;
	}
	_tmp6_ = properties_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	info_label = _tmp6_;
	_tmp7_ = label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, (gint) self->line_count, 1, 1);
	_tmp8_ = info_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp8_, 1, (gint) self->line_count, 1, 1);
	_tmp9_ = self->line_count;
	self->line_count = _tmp9_ + 1;
	_g_object_unref0 (info_label);
	_g_object_unref0 (label);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
properties_get_prettyprint_time (Properties* self,
                                 GDateTime* time)
{
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = resources_get_hh_mm_format_string ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (time, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	timestring = _tmp3_;
	_tmp4_ = timestring;
	if (string_get (_tmp4_, (glong) 0) == '0') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = timestring;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
		_g_free0 (timestring);
		timestring = _tmp6_;
	}
	result = timestring;
	return result;
}

gchar*
properties_get_prettyprint_time_with_seconds (Properties* self,
                                              GDateTime* time)
{
	gchar* timestring = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time != NULL, NULL);
	_tmp0_ = resources_get_hh_mm_ss_format_string ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (time, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	timestring = _tmp3_;
	_tmp4_ = timestring;
	if (string_get (_tmp4_, (glong) 0) == '0') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = timestring;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
		_g_free0 (timestring);
		timestring = _tmp6_;
	}
	result = timestring;
	return result;
}

gchar*
properties_get_prettyprint_date (Properties* self,
                                 GDateTime* date)
{
	gchar* date_string = NULL;
	GDateTime* today = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GDateTime* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	date_string = NULL;
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_time_zone_unref0 (_tmp1_);
	today = _tmp3_;
	_tmp5_ = today;
	if (g_date_time_get_day_of_year (date) == g_date_time_get_day_of_year (_tmp5_)) {
		GDateTime* _tmp6_;
		_tmp6_ = today;
		_tmp4_ = g_date_time_get_year (date) == g_date_time_get_year (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Today"));
		_g_free0 (date_string);
		date_string = _tmp7_;
	} else {
		gboolean _tmp8_ = FALSE;
		GDateTime* _tmp9_;
		_tmp9_ = today;
		if (g_date_time_get_day_of_year (date) == (g_date_time_get_day_of_year (_tmp9_) - 1)) {
			GDateTime* _tmp10_;
			_tmp10_ = today;
			_tmp8_ = g_date_time_get_year (date) == g_date_time_get_year (_tmp10_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Yesterday"));
			_g_free0 (date_string);
			date_string = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = format_local_date (date);
			_g_free0 (date_string);
			date_string = _tmp12_;
		}
	}
	result = date_string;
	_g_date_time_unref0 (today);
	return result;
}

static void
properties_real_get_single_properties (Properties* self,
                                       DataView* view)
{
	g_return_if_fail (view != NULL);
}

void
properties_get_single_properties (Properties* self,
                                  DataView* view)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_single_properties) {
		_klass_->get_single_properties (self, view);
	}
}

static void
properties_real_get_multiple_properties (Properties* self,
                                         GeeIterable* iter)
{
}

void
properties_get_multiple_properties (Properties* self,
                                    GeeIterable* iter)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_multiple_properties) {
		_klass_->get_multiple_properties (self, iter);
	}
}

static void
properties_real_get_properties (Properties* self,
                                Page* current_page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gint count = 0;
	ViewCollection* _tmp2_;
	GeeIterable* iter = NULL;
	gboolean _tmp8_ = FALSE;
	GeeIterable* _tmp9_;
	g_return_if_fail (current_page != NULL);
	_tmp0_ = page_get_view (current_page);
	view = _tmp0_;
	_tmp1_ = view;
	if (_tmp1_ == NULL) {
		_data_collection_unref0 (view);
		return;
	}
	_tmp2_ = view;
	count = view_collection_get_selected_count (_tmp2_);
	iter = NULL;
	if (count != 0) {
		ViewCollection* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = view;
		_tmp4_ = view_collection_get_selected (_tmp3_);
		_g_object_unref0 (iter);
		iter = (GeeIterable*) _tmp4_;
	} else {
		ViewCollection* _tmp5_;
		ViewCollection* _tmp6_;
		GeeCollection* _tmp7_;
		_tmp5_ = view;
		count = data_collection_get_count ((DataCollection*) _tmp5_);
		_tmp6_ = view;
		_tmp7_ = data_collection_get_all ((DataCollection*) _tmp6_);
		_g_object_unref0 (iter);
		iter = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable);
	}
	_tmp9_ = iter;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = count == 0;
	}
	if (_tmp8_) {
		_g_object_unref0 (iter);
		_data_collection_unref0 (view);
		return;
	}
	if (count == 1) {
		{
			GeeIterator* _item_it = NULL;
			GeeIterable* _tmp10_;
			GeeIterator* _tmp11_;
			_tmp10_ = iter;
			_tmp11_ = gee_iterable_iterator (_tmp10_);
			_item_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				DataView* item = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				DataView* _tmp15_;
				_tmp12_ = _item_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _item_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				item = (DataView*) _tmp14_;
				_tmp15_ = item;
				properties_get_single_properties (self, _tmp15_);
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (_item_it);
		}
	} else {
		GeeIterable* _tmp16_;
		_tmp16_ = iter;
		properties_get_multiple_properties (self, _tmp16_);
	}
	_g_object_unref0 (iter);
	_data_collection_unref0 (view);
}

void
properties_get_properties (Properties* self,
                           Page* current_page)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->get_properties) {
		_klass_->get_properties (self, current_page);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
properties_real_clear_properties (Properties* self)
{
	GList* _tmp0_;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_container_remove ((GtkContainer*) self, _tmp2_);
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	self->line_count = (guint) 0;
}

void
properties_clear_properties (Properties* self)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->clear_properties) {
		_klass_->clear_properties (self);
	}
}

static void
properties_real_update_properties (Properties* self,
                                   Page* page)
{
	g_return_if_fail (page != NULL);
	properties_clear_properties (self);
	properties_internal_update_properties (self, page);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
properties_update_properties (Properties* self,
                              Page* page)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->update_properties) {
		_klass_->update_properties (self, page);
	}
}

static void
properties_real_internal_update_properties (Properties* self,
                                            Page* page)
{
	g_return_if_fail (page != NULL);
	properties_get_properties (self, page);
}

void
properties_internal_update_properties (Properties* self,
                                       Page* page)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->internal_update_properties) {
		_klass_->internal_update_properties (self, page);
	}
}

void
properties_unselect_text (Properties* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* _tmp1_;
			GtkWidget* child = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) child_it->data);
			child = _tmp1_;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_label_get_type ())) {
					GtkWidget* _tmp3_;
					_tmp3_ = child;
					gtk_label_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel), 0, 0);
				}
				_g_object_unref0 (child);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
properties_real_save_changes_to_source (Properties* self)
{
}

void
properties_save_changes_to_source (Properties* self)
{
	PropertiesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PROPERTIES_GET_CLASS (self);
	if (_klass_->save_changes_to_source) {
		_klass_->save_changes_to_source (self);
	}
}

PropertiesHeader*
properties_header_construct (GType object_type,
                             const gchar* text)
{
	PropertiesHeader * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (PropertiesHeader*) g_object_new (object_type, NULL);
	gtk_label_set_label ((GtkLabel*) self, text);
	gtk_label_set_lines ((GtkLabel*) self, 8);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	g_object_set ((GtkLabel*) self, "wrap", TRUE, NULL);
	g_object_set ((GtkLabel*) self, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_xalign ((GtkLabel*) self, (gfloat) 1);
	return self;
}

PropertiesHeader*
properties_header_new (const gchar* text)
{
	return properties_header_construct (PROPERTIES_TYPE_HEADER, text);
}

static void
properties_header_class_init (PropertiesHeaderClass * klass,
                              gpointer klass_data)
{
	properties_header_parent_class = g_type_class_peek_parent (klass);
}

static void
properties_header_instance_init (PropertiesHeader * self,
                                 gpointer klass)
{
}

static GType
properties_header_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertiesHeader), 0, (GInstanceInitFunc) properties_header_instance_init, NULL };
	GType properties_header_type_id;
	properties_header_type_id = g_type_register_static (gtk_label_get_type (), "PropertiesHeader", &g_define_type_info, 0);
	return properties_header_type_id;
}

GType
properties_header_get_type (void)
{
	static volatile gsize properties_header_type_id__once = 0;
	if (g_once_init_enter (&properties_header_type_id__once)) {
		GType properties_header_type_id;
		properties_header_type_id = properties_header_get_type_once ();
		g_once_init_leave (&properties_header_type_id__once, properties_header_type_id);
	}
	return properties_header_type_id__once;
}

PropertiesLabel*
properties_label_construct (GType object_type,
                            const gchar* text)
{
	PropertiesLabel * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (PropertiesLabel*) g_object_new (object_type, NULL);
	gtk_label_set_ellipsize ((GtkLabel*) self, PANGO_ELLIPSIZE_END);
	gtk_label_set_label ((GtkLabel*) self, text);
	gtk_label_set_lines ((GtkLabel*) self, 8);
	gtk_label_set_selectable ((GtkLabel*) self, TRUE);
	gtk_label_set_use_markup ((GtkLabel*) self, TRUE);
	g_object_set ((GtkLabel*) self, "wrap", TRUE, NULL);
	g_object_set ((GtkLabel*) self, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_xalign ((GtkLabel*) self, (gfloat) 0);
	return self;
}

PropertiesLabel*
properties_label_new (const gchar* text)
{
	return properties_label_construct (PROPERTIES_TYPE_LABEL, text);
}

static void
properties_label_class_init (PropertiesLabelClass * klass,
                             gpointer klass_data)
{
	properties_label_parent_class = g_type_class_peek_parent (klass);
}

static void
properties_label_instance_init (PropertiesLabel * self,
                                gpointer klass)
{
}

static GType
properties_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertiesLabel), 0, (GInstanceInitFunc) properties_label_instance_init, NULL };
	GType properties_label_type_id;
	properties_label_type_id = g_type_register_static (gtk_label_get_type (), "PropertiesLabel", &g_define_type_info, 0);
	return properties_label_type_id;
}

GType
properties_label_get_type (void)
{
	static volatile gsize properties_label_type_id__once = 0;
	if (g_once_init_enter (&properties_label_type_id__once)) {
		GType properties_label_type_id;
		properties_label_type_id = properties_label_get_type_once ();
		g_once_init_leave (&properties_label_type_id__once, properties_label_type_id);
	}
	return properties_label_type_id__once;
}

static void
properties_class_init (PropertiesClass * klass,
                       gpointer klass_data)
{
	properties_parent_class = g_type_class_peek_parent (klass);
	((PropertiesClass *) klass)->get_single_properties = (void (*) (Properties*, DataView*)) properties_real_get_single_properties;
	((PropertiesClass *) klass)->get_multiple_properties = (void (*) (Properties*, GeeIterable*)) properties_real_get_multiple_properties;
	((PropertiesClass *) klass)->get_properties = (void (*) (Properties*, Page*)) properties_real_get_properties;
	((PropertiesClass *) klass)->clear_properties = (void (*) (Properties*)) properties_real_clear_properties;
	((PropertiesClass *) klass)->update_properties = (void (*) (Properties*, Page*)) properties_real_update_properties;
	((PropertiesClass *) klass)->internal_update_properties = (void (*) (Properties*, Page*)) properties_real_internal_update_properties;
	((PropertiesClass *) klass)->save_changes_to_source = (void (*) (Properties*)) properties_real_save_changes_to_source;
	G_OBJECT_CLASS (klass)->finalize = properties_finalize;
}

static void
properties_instance_init (Properties * self,
                          gpointer klass)
{
	self->line_count = (guint) 0;
}

static void
properties_finalize (GObject * obj)
{
	Properties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTIES, Properties);
	G_OBJECT_CLASS (properties_parent_class)->finalize (obj);
}

static GType
properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Properties), 0, (GInstanceInitFunc) properties_instance_init, NULL };
	GType properties_type_id;
	properties_type_id = g_type_register_static (gtk_grid_get_type (), "Properties", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return properties_type_id;
}

GType
properties_get_type (void)
{
	static volatile gsize properties_type_id__once = 0;
	if (g_once_init_enter (&properties_type_id__once)) {
		GType properties_type_id;
		properties_type_id = properties_get_type_once ();
		g_once_init_leave (&properties_type_id__once, properties_type_id);
	}
	return properties_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

