/* BmpSupport.c generated by valac 0.56.18, the Vala compiler
 * generated from BmpSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gphoto2/gphoto2-file.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES (photos_bmp_file_format_properties_get_type ())
#define PHOTOS_BMP_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES, PhotosBmpFileFormatProperties))
#define PHOTOS_BMP_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES, PhotosBmpFileFormatPropertiesClass))
#define PHOTOS_IS_BMP_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES))
#define PHOTOS_IS_BMP_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES))
#define PHOTOS_BMP_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES, PhotosBmpFileFormatPropertiesClass))

typedef struct _PhotosBmpFileFormatProperties PhotosBmpFileFormatProperties;
typedef struct _PhotosBmpFileFormatPropertiesClass PhotosBmpFileFormatPropertiesClass;
typedef struct _PhotosBmpFileFormatPropertiesPrivate PhotosBmpFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

struct _PhotosBmpFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	PhotosBmpFileFormatPropertiesPrivate * priv;
};

struct _PhotosBmpFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

static gpointer photos_bmp_file_format_properties_parent_class = NULL;
static gchar** photos_bmp_file_format_properties_known_extensions;
static gint photos_bmp_file_format_properties_known_extensions_length1;
static gchar** photos_bmp_file_format_properties_known_extensions = NULL;
static gint photos_bmp_file_format_properties_known_extensions_length1 = 0;
static gint _photos_bmp_file_format_properties_known_extensions_size_ = 0;
static gchar** photos_bmp_file_format_properties_known_mime_types;
static gint photos_bmp_file_format_properties_known_mime_types_length1;
static gchar** photos_bmp_file_format_properties_known_mime_types = NULL;
static gint photos_bmp_file_format_properties_known_mime_types_length1 = 0;
static gint _photos_bmp_file_format_properties_known_mime_types_size_ = 0;
static PhotosBmpFileFormatProperties* photos_bmp_file_format_properties_instance;
static PhotosBmpFileFormatProperties* photos_bmp_file_format_properties_instance = NULL;
static gpointer photos_bmp_sniffer_parent_class = NULL;
static gpointer photos_bmp_reader_parent_class = NULL;
static gpointer photos_bmp_writer_parent_class = NULL;
static gpointer photos_bmp_metadata_writer_parent_class = NULL;
static gpointer photos_bmp_file_format_driver_parent_class = NULL;
static PhotosBmpFileFormatDriver* photos_bmp_file_format_driver_instance;
static PhotosBmpFileFormatDriver* photos_bmp_file_format_driver_instance = NULL;

VALA_EXTERN GType photos_bmp_file_format_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photos_bmp_file_format_properties_init (void);
VALA_EXTERN PhotosBmpFileFormatProperties* photos_bmp_file_format_properties_new (void);
VALA_EXTERN PhotosBmpFileFormatProperties* photos_bmp_file_format_properties_construct (GType object_type);
VALA_EXTERN PhotosBmpFileFormatProperties* photos_bmp_file_format_properties_get_instance (void);
static PhotoFileFormat photos_bmp_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags photos_bmp_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* photos_bmp_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* photos_bmp_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** photos_bmp_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                                     gint* result_length1);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static gchar* photos_bmp_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** photos_bmp_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                               gint* result_length1);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static void photos_bmp_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType photos_bmp_file_format_properties_get_type_once (void);
static gboolean photos_bmp_sniffer_is_bmp_file (GFile* file,
                                         GError** error);
static DetectedPhotoInformation* photos_bmp_sniffer_real_sniff (PhotoFileSniffer* base,
                                                         GError** error);
static GType photos_bmp_sniffer_get_type_once (void);
static GdkPixbuf* photos_bmp_reader_real_scaled_read (PhotoFileReader* base,
                                               Dimensions* full,
                                               Dimensions* scaled,
                                               GError** error);
static GType photos_bmp_reader_get_type_once (void);
static void photos_bmp_writer_real_write (PhotoFileWriter* base,
                                   GdkPixbuf* pixbuf,
                                   JpegQuality quality,
                                   GError** error);
static GType photos_bmp_writer_get_type_once (void);
static void photos_bmp_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                                     PhotoMetadata* metadata,
                                                     GError** error);
static GType photos_bmp_metadata_writer_get_type_once (void);
static PhotoFileFormatProperties* photos_bmp_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* photos_bmp_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                                   const gchar* filepath);
static gboolean photos_bmp_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean photos_bmp_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* photos_bmp_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                                   const gchar* filepath);
static PhotoFileMetadataWriter* photos_bmp_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                                    const gchar* filepath);
static PhotoFileSniffer* photos_bmp_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                                     GFile* file,
                                                                     PhotoFileSnifferOptions options);
static PhotoMetadata* photos_bmp_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static void photos_bmp_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType photos_bmp_file_format_driver_get_type_once (void);

static const guint8 PHOTOS_BMP_SNIFFER_MAGIC_SEQUENCE[2] = {(guint8) 0x42, (guint8) 0x4D};

void
photos_bmp_file_format_properties_init (void)
{
	PhotosBmpFileFormatProperties* _tmp0_;
	_tmp0_ = photos_bmp_file_format_properties_new ();
	_photo_file_format_properties_unref0 (photos_bmp_file_format_properties_instance);
	photos_bmp_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

PhotosBmpFileFormatProperties*
photos_bmp_file_format_properties_get_instance (void)
{
	PhotosBmpFileFormatProperties* _tmp0_;
	PhotosBmpFileFormatProperties* _tmp1_;
	PhotosBmpFileFormatProperties* result;
	_tmp0_ = photos_bmp_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
photos_bmp_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	PhotosBmpFileFormatProperties * self;
	PhotoFileFormat result;
	self = (PhotosBmpFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_BMP;
	return result;
}

static PhotoFileFormatFlags
photos_bmp_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	PhotosBmpFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (PhotosBmpFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
photos_bmp_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	PhotosBmpFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (PhotosBmpFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("BMP"));
	result = _tmp0_;
	return result;
}

static gchar*
photos_bmp_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	PhotosBmpFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PhotosBmpFileFormatProperties*) base;
	_tmp0_ = photos_bmp_file_format_properties_known_extensions;
	_tmp0__length1 = photos_bmp_file_format_properties_known_extensions_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
photos_bmp_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                             gint* result_length1)
{
	PhotosBmpFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PhotosBmpFileFormatProperties*) base;
	_tmp0_ = photos_bmp_file_format_properties_known_extensions;
	_tmp0__length1 = photos_bmp_file_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup6 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
photos_bmp_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	PhotosBmpFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PhotosBmpFileFormatProperties*) base;
	_tmp0_ = photos_bmp_file_format_properties_known_mime_types;
	_tmp0__length1 = photos_bmp_file_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
photos_bmp_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                       gint* result_length1)
{
	PhotosBmpFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PhotosBmpFileFormatProperties*) base;
	_tmp0_ = photos_bmp_file_format_properties_known_mime_types;
	_tmp0__length1 = photos_bmp_file_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PhotosBmpFileFormatProperties*
photos_bmp_file_format_properties_construct (GType object_type)
{
	PhotosBmpFileFormatProperties* self = NULL;
	self = (PhotosBmpFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

PhotosBmpFileFormatProperties*
photos_bmp_file_format_properties_new (void)
{
	return photos_bmp_file_format_properties_construct (PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES);
}

static void
photos_bmp_file_format_properties_class_init (PhotosBmpFileFormatPropertiesClass * klass,
                                              gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	photos_bmp_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = photos_bmp_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) photos_bmp_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) photos_bmp_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) photos_bmp_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) photos_bmp_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photos_bmp_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) photos_bmp_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photos_bmp_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("bmp");
	_tmp1_ = g_strdup ("dib");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	photos_bmp_file_format_properties_known_extensions = _tmp2_;
	photos_bmp_file_format_properties_known_extensions_length1 = 2;
	_photos_bmp_file_format_properties_known_extensions_size_ = photos_bmp_file_format_properties_known_extensions_length1;
	_tmp3_ = g_strdup (GP_MIME_BMP);
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	photos_bmp_file_format_properties_known_mime_types = _tmp4_;
	photos_bmp_file_format_properties_known_mime_types_length1 = 1;
	_photos_bmp_file_format_properties_known_mime_types_size_ = photos_bmp_file_format_properties_known_mime_types_length1;
}

static void
photos_bmp_file_format_properties_instance_init (PhotosBmpFileFormatProperties * self,
                                                 gpointer klass)
{
}

static void
photos_bmp_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	PhotosBmpFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_BMP_FILE_FORMAT_PROPERTIES, PhotosBmpFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (photos_bmp_file_format_properties_parent_class)->finalize (obj);
}

static GType
photos_bmp_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpFileFormatProperties), 0, (GInstanceInitFunc) photos_bmp_file_format_properties_instance_init, NULL };
	GType photos_bmp_file_format_properties_type_id;
	photos_bmp_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "PhotosBmpFileFormatProperties", &g_define_type_info, 0);
	return photos_bmp_file_format_properties_type_id;
}

GType
photos_bmp_file_format_properties_get_type (void)
{
	static volatile gsize photos_bmp_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_file_format_properties_type_id__once)) {
		GType photos_bmp_file_format_properties_type_id;
		photos_bmp_file_format_properties_type_id = photos_bmp_file_format_properties_get_type_once ();
		g_once_init_leave (&photos_bmp_file_format_properties_type_id__once, photos_bmp_file_format_properties_type_id);
	}
	return photos_bmp_file_format_properties_type_id__once;
}

PhotosBmpSniffer*
photos_bmp_sniffer_construct (GType object_type,
                              GFile* file,
                              PhotoFileSnifferOptions options)
{
	PhotosBmpSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PhotosBmpSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

PhotosBmpSniffer*
photos_bmp_sniffer_new (GFile* file,
                        PhotoFileSnifferOptions options)
{
	return photos_bmp_sniffer_construct (PHOTOS_TYPE_BMP_SNIFFER, file, options);
}

static gboolean
photos_bmp_sniffer_is_bmp_file (GFile* file,
                                GError** error)
{
	GFileInputStream* instream = NULL;
	GFileInputStream* _tmp0_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp2_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	GFileInputStream* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	instream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = g_new0 (guint8, G_N_ELEMENTS (PHOTOS_BMP_SNIFFER_MAGIC_SEQUENCE));
	file_lead_sequence = _tmp2_;
	file_lead_sequence_length1 = G_N_ELEMENTS (PHOTOS_BMP_SNIFFER_MAGIC_SEQUENCE);
	_file_lead_sequence_size_ = file_lead_sequence_length1;
	_tmp3_ = instream;
	_tmp4_ = file_lead_sequence;
	_tmp4__length1 = file_lead_sequence_length1;
	g_input_stream_read ((GInputStream*) _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
		_g_object_unref0 (instream);
		return _tmp5_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8 _tmp9_;
				guint8 _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < G_N_ELEMENTS (PHOTOS_BMP_SNIFFER_MAGIC_SEQUENCE))) {
					break;
				}
				_tmp8_ = file_lead_sequence;
				_tmp8__length1 = file_lead_sequence_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = PHOTOS_BMP_SNIFFER_MAGIC_SEQUENCE[i];
				if (_tmp9_ != _tmp10_) {
					result = FALSE;
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
					_g_object_unref0 (instream);
					return result;
				}
			}
		}
	}
	result = TRUE;
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
	_g_object_unref0 (instream);
	return result;
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
photos_bmp_sniffer_real_sniff (PhotoFileSniffer* base,
                               GError** error)
{
	PhotosBmpSniffer * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_;
	DetectedPhotoInformation* _tmp7_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (PhotosBmpSniffer*) base;
	_tmp1_ = ((PhotoFileSniffer*) self)->file;
	_tmp0_ = photos_bmp_sniffer_is_bmp_file (_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = PHOTO_FILE_SNIFFER_CLASS (photos_bmp_sniffer_parent_class)->sniff ((PhotoFileSniffer*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), &_inner_error0_);
	detected = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = detected;
	if (_tmp3_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		return result;
	}
	_tmp5_ = detected;
	if (_tmp5_->file_format == PHOTO_FILE_FORMAT_BMP) {
		DetectedPhotoInformation* _tmp6_;
		_tmp6_ = detected;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = _detected_photo_information_ref0 (_tmp4_);
	result = _tmp7_;
	_detected_photo_information_unref0 (detected);
	return result;
}

static void
photos_bmp_sniffer_class_init (PhotosBmpSnifferClass * klass,
                               gpointer klass_data)
{
	photos_bmp_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) photos_bmp_sniffer_real_sniff;
}

static void
photos_bmp_sniffer_instance_init (PhotosBmpSniffer * self,
                                  gpointer klass)
{
}

static GType
photos_bmp_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpSniffer), 0, (GInstanceInitFunc) photos_bmp_sniffer_instance_init, NULL };
	GType photos_bmp_sniffer_type_id;
	photos_bmp_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "PhotosBmpSniffer", &g_define_type_info, 0);
	return photos_bmp_sniffer_type_id;
}

GType
photos_bmp_sniffer_get_type (void)
{
	static volatile gsize photos_bmp_sniffer_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_sniffer_type_id__once)) {
		GType photos_bmp_sniffer_type_id;
		photos_bmp_sniffer_type_id = photos_bmp_sniffer_get_type_once ();
		g_once_init_leave (&photos_bmp_sniffer_type_id__once, photos_bmp_sniffer_type_id);
	}
	return photos_bmp_sniffer_type_id__once;
}

PhotosBmpReader*
photos_bmp_reader_construct (GType object_type,
                             const gchar* filepath)
{
	PhotosBmpReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosBmpReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_BMP);
	return self;
}

PhotosBmpReader*
photos_bmp_reader_new (const gchar* filepath)
{
	return photos_bmp_reader_construct (PHOTOS_TYPE_BMP_READER, filepath);
}

static GdkPixbuf*
photos_bmp_reader_real_scaled_read (PhotoFileReader* base,
                                    Dimensions* full,
                                    Dimensions* scaled,
                                    GError** error)
{
	PhotosBmpReader * self;
	GdkPixbuf* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (PhotosBmpReader*) base;
	g_return_val_if_fail (full != NULL, NULL);
	g_return_val_if_fail (scaled != NULL, NULL);
	_result_ = NULL;
	_tmp2_ = *full;
	if (_tmp2_.width > 9999) {
		_tmp1_ = TRUE;
	} else {
		Dimensions _tmp3_;
		_tmp3_ = *full;
		_tmp1_ = _tmp3_.height > 9999;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		Dimensions _tmp5_;
		_tmp5_ = *scaled;
		if (_tmp5_.width < 100) {
			_tmp4_ = TRUE;
		} else {
			Dimensions _tmp6_;
			_tmp6_ = *scaled;
			_tmp4_ = _tmp6_.height < 100;
		}
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Dimensions prefetch_dimensions = {0};
		Dimensions _tmp7_ = {0};
		GdkPixbuf* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		Dimensions _tmp11_;
		Dimensions _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkPixbuf* _tmp16_;
		Dimensions _tmp17_;
		Dimensions _tmp18_;
		GdkPixbuf* _tmp19_;
		dimensions_get_scaled_by_constraint (full, 1000, SCALE_CONSTRAINT_DIMENSIONS, &_tmp7_);
		prefetch_dimensions = _tmp7_;
		_tmp9_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = prefetch_dimensions;
		_tmp12_ = prefetch_dimensions;
		_tmp13_ = gdk_pixbuf_new_from_file_at_scale (_tmp10_, _tmp11_.width, _tmp12_.height, FALSE, &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp10_);
		_tmp8_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp15_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp15_;
		_tmp16_ = _result_;
		_tmp17_ = *scaled;
		_tmp18_ = *scaled;
		_tmp19_ = gdk_pixbuf_scale_simple (_tmp16_, _tmp17_.width, _tmp18_.height, GDK_INTERP_HYPER);
		_g_object_unref0 (_result_);
		_result_ = _tmp19_;
		_g_object_unref0 (_tmp8_);
	} else {
		GdkPixbuf* _tmp20_ = NULL;
		gchar* _tmp21_;
		gchar* _tmp22_;
		Dimensions _tmp23_;
		Dimensions _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		GdkPixbuf* _tmp27_;
		_tmp21_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = *scaled;
		_tmp24_ = *scaled;
		_tmp25_ = gdk_pixbuf_new_from_file_at_scale (_tmp22_, _tmp23_.width, _tmp24_.height, FALSE, &_inner_error0_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp22_);
		_tmp20_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_result_);
			return NULL;
		}
		_tmp27_ = _tmp20_;
		_tmp20_ = NULL;
		_g_object_unref0 (_result_);
		_result_ = _tmp27_;
		_g_object_unref0 (_tmp20_);
	}
	result = _result_;
	return result;
}

static void
photos_bmp_reader_class_init (PhotosBmpReaderClass * klass,
                              gpointer klass_data)
{
	photos_bmp_reader_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader*, Dimensions*, Dimensions*, GError**)) photos_bmp_reader_real_scaled_read;
}

static void
photos_bmp_reader_instance_init (PhotosBmpReader * self,
                                 gpointer klass)
{
}

static GType
photos_bmp_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpReader), 0, (GInstanceInitFunc) photos_bmp_reader_instance_init, NULL };
	GType photos_bmp_reader_type_id;
	photos_bmp_reader_type_id = g_type_register_static (TYPE_GDK_READER, "PhotosBmpReader", &g_define_type_info, 0);
	return photos_bmp_reader_type_id;
}

GType
photos_bmp_reader_get_type (void)
{
	static volatile gsize photos_bmp_reader_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_reader_type_id__once)) {
		GType photos_bmp_reader_type_id;
		photos_bmp_reader_type_id = photos_bmp_reader_get_type_once ();
		g_once_init_leave (&photos_bmp_reader_type_id__once, photos_bmp_reader_type_id);
	}
	return photos_bmp_reader_type_id__once;
}

PhotosBmpWriter*
photos_bmp_writer_construct (GType object_type,
                             const gchar* filepath)
{
	PhotosBmpWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosBmpWriter*) photo_file_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_BMP);
	return self;
}

PhotosBmpWriter*
photos_bmp_writer_new (const gchar* filepath)
{
	return photos_bmp_writer_construct (PHOTOS_TYPE_BMP_WRITER, filepath);
}

static void
photos_bmp_writer_real_write (PhotoFileWriter* base,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error)
{
	PhotosBmpWriter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (PhotosBmpWriter*) base;
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	gdk_pixbuf_save (pixbuf, _tmp1_, "bmp", &_inner_error0_, NULL, NULL);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
photos_bmp_writer_class_init (PhotosBmpWriterClass * klass,
                              gpointer klass_data)
{
	photos_bmp_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) photos_bmp_writer_real_write;
}

static void
photos_bmp_writer_instance_init (PhotosBmpWriter * self,
                                 gpointer klass)
{
}

static GType
photos_bmp_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpWriter), 0, (GInstanceInitFunc) photos_bmp_writer_instance_init, NULL };
	GType photos_bmp_writer_type_id;
	photos_bmp_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "PhotosBmpWriter", &g_define_type_info, 0);
	return photos_bmp_writer_type_id;
}

GType
photos_bmp_writer_get_type (void)
{
	static volatile gsize photos_bmp_writer_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_writer_type_id__once)) {
		GType photos_bmp_writer_type_id;
		photos_bmp_writer_type_id = photos_bmp_writer_get_type_once ();
		g_once_init_leave (&photos_bmp_writer_type_id__once, photos_bmp_writer_type_id);
	}
	return photos_bmp_writer_type_id__once;
}

PhotosBmpMetadataWriter*
photos_bmp_metadata_writer_construct (GType object_type,
                                      const gchar* filepath)
{
	PhotosBmpMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosBmpMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_BMP);
	return self;
}

PhotosBmpMetadataWriter*
photos_bmp_metadata_writer_new (const gchar* filepath)
{
	return photos_bmp_metadata_writer_construct (PHOTOS_TYPE_BMP_METADATA_WRITER, filepath);
}

static void
photos_bmp_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                                PhotoMetadata* metadata,
                                                GError** error)
{
	PhotosBmpMetadataWriter * self;
	self = (PhotosBmpMetadataWriter*) base;
	g_return_if_fail (metadata != NULL);
}

static void
photos_bmp_metadata_writer_class_init (PhotosBmpMetadataWriterClass * klass,
                                       gpointer klass_data)
{
	photos_bmp_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) photos_bmp_metadata_writer_real_write_metadata;
}

static void
photos_bmp_metadata_writer_instance_init (PhotosBmpMetadataWriter * self,
                                          gpointer klass)
{
}

static GType
photos_bmp_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpMetadataWriter), 0, (GInstanceInitFunc) photos_bmp_metadata_writer_instance_init, NULL };
	GType photos_bmp_metadata_writer_type_id;
	photos_bmp_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "PhotosBmpMetadataWriter", &g_define_type_info, 0);
	return photos_bmp_metadata_writer_type_id;
}

GType
photos_bmp_metadata_writer_get_type (void)
{
	static volatile gsize photos_bmp_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_metadata_writer_type_id__once)) {
		GType photos_bmp_metadata_writer_type_id;
		photos_bmp_metadata_writer_type_id = photos_bmp_metadata_writer_get_type_once ();
		g_once_init_leave (&photos_bmp_metadata_writer_type_id__once, photos_bmp_metadata_writer_type_id);
	}
	return photos_bmp_metadata_writer_type_id__once;
}

void
photos_bmp_file_format_driver_init (void)
{
	PhotosBmpFileFormatDriver* _tmp0_;
	_tmp0_ = photos_bmp_file_format_driver_new ();
	_photo_file_format_driver_unref0 (photos_bmp_file_format_driver_instance);
	photos_bmp_file_format_driver_instance = _tmp0_;
	photos_bmp_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

PhotosBmpFileFormatDriver*
photos_bmp_file_format_driver_get_instance (void)
{
	PhotosBmpFileFormatDriver* _tmp0_;
	PhotosBmpFileFormatDriver* _tmp1_;
	PhotosBmpFileFormatDriver* result;
	_tmp0_ = photos_bmp_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
photos_bmp_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	PhotosBmpFileFormatDriver * self;
	PhotosBmpFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (PhotosBmpFileFormatDriver*) base;
	_tmp0_ = photos_bmp_file_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
photos_bmp_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                  const gchar* filepath)
{
	PhotosBmpFileFormatDriver * self;
	PhotosBmpReader* _tmp0_;
	PhotoFileReader* result;
	self = (PhotosBmpFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_bmp_reader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static gboolean
photos_bmp_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	PhotosBmpFileFormatDriver * self;
	gboolean result;
	self = (PhotosBmpFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static gboolean
photos_bmp_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	PhotosBmpFileFormatDriver * self;
	gboolean result;
	self = (PhotosBmpFileFormatDriver*) base;
	result = FALSE;
	return result;
}

static PhotoFileWriter*
photos_bmp_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                  const gchar* filepath)
{
	PhotosBmpFileFormatDriver * self;
	PhotosBmpWriter* _tmp0_;
	PhotoFileWriter* result;
	self = (PhotosBmpFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_bmp_writer_new (filepath);
	result = (PhotoFileWriter*) _tmp0_;
	return result;
}

static PhotoFileMetadataWriter*
photos_bmp_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                           const gchar* filepath)
{
	PhotosBmpFileFormatDriver * self;
	PhotosBmpMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = (PhotosBmpFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_bmp_metadata_writer_new (filepath);
	result = (PhotoFileMetadataWriter*) _tmp0_;
	return result;
}

static PhotoFileSniffer*
photos_bmp_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                   GFile* file,
                                                   PhotoFileSnifferOptions options)
{
	PhotosBmpFileFormatDriver * self;
	PhotosBmpSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (PhotosBmpFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = photos_bmp_sniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

static PhotoMetadata*
photos_bmp_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	PhotosBmpFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (PhotosBmpFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

PhotosBmpFileFormatDriver*
photos_bmp_file_format_driver_construct (GType object_type)
{
	PhotosBmpFileFormatDriver* self = NULL;
	self = (PhotosBmpFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

PhotosBmpFileFormatDriver*
photos_bmp_file_format_driver_new (void)
{
	return photos_bmp_file_format_driver_construct (PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER);
}

static void
photos_bmp_file_format_driver_class_init (PhotosBmpFileFormatDriverClass * klass,
                                          gpointer klass_data)
{
	photos_bmp_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = photos_bmp_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) photos_bmp_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) photos_bmp_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) photos_bmp_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) photos_bmp_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photos_bmp_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photos_bmp_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) photos_bmp_file_format_driver_real_create_sniffer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) photos_bmp_file_format_driver_real_create_metadata;
}

static void
photos_bmp_file_format_driver_instance_init (PhotosBmpFileFormatDriver * self,
                                             gpointer klass)
{
}

static void
photos_bmp_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	PhotosBmpFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_BMP_FILE_FORMAT_DRIVER, PhotosBmpFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (photos_bmp_file_format_driver_parent_class)->finalize (obj);
}

static GType
photos_bmp_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosBmpFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_bmp_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosBmpFileFormatDriver), 0, (GInstanceInitFunc) photos_bmp_file_format_driver_instance_init, NULL };
	GType photos_bmp_file_format_driver_type_id;
	photos_bmp_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "PhotosBmpFileFormatDriver", &g_define_type_info, 0);
	return photos_bmp_file_format_driver_type_id;
}

GType
photos_bmp_file_format_driver_get_type (void)
{
	static volatile gsize photos_bmp_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&photos_bmp_file_format_driver_type_id__once)) {
		GType photos_bmp_file_format_driver_type_id;
		photos_bmp_file_format_driver_type_id = photos_bmp_file_format_driver_get_type_once ();
		g_once_init_leave (&photos_bmp_file_format_driver_type_id__once, photos_bmp_file_format_driver_type_id);
	}
	return photos_bmp_file_format_driver_type_id__once;
}

