/* DirectPhoto.c generated by valac 0.56.18, the Vala compiler
 * generated from DirectPhoto.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define DIRECT_PHOTO_PREVIEW_BEST_FIT 360
#define DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD 500
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DIRECT_PHOTO_0_PROPERTY,
	DIRECT_PHOTO_NUM_PROPERTIES
};
static GParamSpec* direct_photo_properties[DIRECT_PHOTO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _photo_import_params_unref0(var) ((var == NULL) ? NULL : (var = (photo_import_params_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
enum  {
	DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL,
	DIRECT_PHOTO_NUM_SIGNALS
};
static guint direct_photo_signals[DIRECT_PHOTO_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DirectPhotoPrivate {
	GdkPixbuf* preview;
	gboolean loaded;
};

struct _DirectPhotoSourceCollectionPrivate {
	GeeCollection* prepared_photos;
	GeeHashMap* file_map;
	DirectoryMonitor* monitor;
};

static gint DirectPhoto_private_offset;
static gpointer direct_photo_parent_class = NULL;
DirectPhotoSourceCollection* direct_photo_global = NULL;
static gint DirectPhotoSourceCollection_private_offset;
static gpointer direct_photo_source_collection_parent_class = NULL;

static DirectPhoto* direct_photo_new (PhotoRow* row);
static DirectPhoto* direct_photo_construct (GType object_type,
                                     PhotoRow* row);
static void direct_photo_save_dims (DirectPhoto* self);
static GdkPixbuf* direct_photo_real_get_preview_pixbuf (MediaSource* base,
                                                 Scaling* scaling,
                                                 GError** error);
static void direct_photo_real_rotate (Photo* base,
                               Rotation rotation);
static GdkPixbuf* direct_photo_real_get_pixbuf (PhotoSource* base,
                                         Scaling* scaling,
                                         GError** error);
static GdkPixbuf* direct_photo_real_get_thumbnail (ThumbnailSource* base,
                                            gint scale,
                                            GError** error);
static void direct_photo_real_notify_altered (DataObject* base,
                                       Alteration* alteration);
static gboolean direct_photo_real_has_user_generated_metadata (Photo* base);
static void direct_photo_real_set_user_metadata_for_export (Photo* base,
                                                     PhotoMetadata* metadata);
static void direct_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                         PhotoMetadata* metadata);
static gboolean direct_photo_real_is_trashed (MediaSource* base);
static gboolean direct_photo_real_is_offline (MediaSource* base);
static void direct_photo_real_trash (MediaSource* base);
static void direct_photo_real_untrash (MediaSource* base);
static void direct_photo_real_mark_offline (MediaSource* base);
static void direct_photo_real_mark_online (MediaSource* base);
static void direct_photo_finalize (GObject * obj);
static GType direct_photo_get_type_once (void);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gint64 direct_photo_source_collection_get_direct_key (DataSource* source);
static gint64 _direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source,
                                                                               gpointer self);
static void direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self,
                                                        GFile* file,
                                                        GFileInfo* info);
static void _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender,
                                                                                           GFile* file,
                                                                                           GFileInfo* info,
                                                                                           gpointer self);
static void direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self);
static void _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                                   gpointer self);
static gboolean direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                   DataSource* source);
static void direct_photo_source_collection_real_notify_items_added (DataCollection* base,
                                                             GeeIterable* added);
static void direct_photo_source_collection_real_notify_items_removed (DataCollection* base,
                                                               GeeIterable* removed);
static void direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self);
static void direct_photo_source_collection_finalize (DataCollection * obj);
static GType direct_photo_source_collection_get_type_once (void);

static inline gpointer
direct_photo_get_instance_private (DirectPhoto* self)
{
	return G_STRUCT_MEMBER_P (self, DirectPhoto_private_offset);
}

static DirectPhoto*
direct_photo_construct (GType object_type,
                        PhotoRow* row)
{
	DirectPhoto * self = NULL;
	g_return_val_if_fail (row != NULL, NULL);
	self = (DirectPhoto*) photo_construct (object_type, row);
	return self;
}

static DirectPhoto*
direct_photo_new (PhotoRow* row)
{
	return direct_photo_construct (TYPE_DIRECT_PHOTO, row);
}

/**
     * Because all transformations are discarded on reimport by design, including
     * Orientation, a JFIF file that is only rotated or flipped, then saved, has the orientation
     * change the user made before saving removed (recall that fetch () remembers which images it
     * has seen before and will only add a file to the file map once; every time it sees it
     * again after this is considered a reimport). This will set the orientation to the
     * specified value, fixing up both the row and the backing row.
     *
     * Warning: Only reimported JFIF files should need this; non-lossy image types have their
     * actual pixels physically rotated in the file when they're exported.
     *
     * @param dest The orientation to set the photo to; usually, this should be a value
     * obtained by calling get_orientation () prior to export ()ing a DirectPhoto.
     */
void
direct_photo_fixup_orientation_after_reimport (DirectPhoto* self,
                                               Orientation dest)
{
	PhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((Photo*) self)->row;
	_tmp0_->orientation = dest;
	_tmp1_ = ((Photo*) self)->backing_photo_row;
	_tmp1_->original_orientation = dest;
}

void
direct_photo_init (GFile* initial_file)
{
	DirectPhotoSourceCollection* _tmp0_;
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	DirectPhotoSourceCollection* _tmp1_;
	DirectPhoto* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	DirectPhotoSourceCollection* _tmp6_;
	DirectPhoto* _tmp7_;
	g_return_if_fail (initial_file != NULL);
	_tmp0_ = direct_photo_source_collection_new (initial_file);
	_data_collection_unref0 (direct_photo_global);
	direct_photo_global = _tmp0_;
	_tmp1_ = direct_photo_global;
	_tmp3_ = direct_photo_source_collection_fetch (_tmp1_, initial_file, &_tmp2_, FALSE);
	_g_object_unref0 (photo);
	photo = _tmp2_;
	reason = _tmp3_;
	_tmp4_ = reason;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = reason;
		g_warning ("DirectPhoto.vala:58: fetch error: %s", _tmp5_);
	}
	_tmp6_ = direct_photo_global;
	_tmp7_ = photo;
	data_collection_add ((DataCollection*) _tmp6_, (DataObject*) _tmp7_);
	_g_free0 (reason);
	_g_object_unref0 (photo);
}

void
direct_photo_terminate (void)
{
}

static void
direct_photo_save_dims (DirectPhoto* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_ = {0};
		GdkPixbuf* _tmp2_;
		BackingPhotoRow* _tmp3_;
		Dimensions _tmp4_ = {0};
		scaling_for_original (&_tmp1_);
		_tmp2_ = photo_get_pixbuf_with_options ((Photo*) self, &_tmp1_, (PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_STRAIGHTEN) | PHOTO_EXCEPTION_ORIENTATION, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = ((Photo*) self)->backing_photo_row;
		dimensions_for_pixbuf (_tmp0_, &_tmp4_);
		_tmp3_->dim = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = data_object_to_string ((DataObject*) self);
		_tmp6_ = _tmp5_;
		g_warning ("DirectPhoto.vala:72: Dimensions for image %s could not be gotten.", _tmp6_);
		_g_free0 (_tmp6_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

ImportResult
direct_photo_demand_load (DirectPhoto* self)
{
	PhotoReimportMasterState* reimport_state = NULL;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->loaded) {
		direct_photo_save_dims (self);
		result = IMPORT_RESULT_SUCCESS;
		return result;
	}
	{
		PhotoReimportMasterState* _tmp0_ = NULL;
		PhotoReimportMasterState* _tmp1_;
		photo_prepare_for_reimport_master ((Photo*) self, &_tmp0_, &_inner_error0_);
		_photo_reimport_master_state_unref0 (reimport_state);
		reimport_state = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = reimport_state;
		photo_finish_reimport_master ((Photo*) self, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("DirectPhoto.vala:88: Database error on re-importing image: %s", _tmp3_);
		result = IMPORT_RESULT_DATABASE_ERROR;
		_g_error_free0 (err);
		_photo_reimport_master_state_unref0 (reimport_state);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_reimport_master_state_unref0 (reimport_state);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	self->priv->loaded = TRUE;
	direct_photo_save_dims (self);
	result = IMPORT_RESULT_SUCCESS;
	_photo_reimport_master_state_unref0 (reimport_state);
	return result;
}

ImportResult
direct_photo_internal_import (GFile* file,
                              DirectPhoto** photo)
{
	DirectPhoto* _vala_photo = NULL;
	PhotoImportParams* params = NULL;
	ImportID _tmp0_ = {0};
	PhotoImportParams* _tmp1_;
	PhotoTable* _tmp2_;
	PhotoTable* _tmp3_;
	PhotoRow* _tmp4_;
	PhotoID _tmp5_ = {0};
	PhotoRow* _tmp6_;
	DirectPhoto* _tmp7_;
	ImportResult result;
	g_return_val_if_fail (file != NULL, 0);
	import_id_generate (&_tmp0_);
	_tmp1_ = photo_import_params_new_create_placeholder (file, &_tmp0_);
	params = _tmp1_;
	photo_create_pre_import (params);
	_tmp2_ = photo_table_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = params->row;
	photo_table_add (_tmp3_, _tmp4_, &_tmp5_);
	_database_table_unref0 (_tmp3_);
	_tmp6_ = params->row;
	_tmp7_ = direct_photo_new (_tmp6_);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp7_;
	result = IMPORT_RESULT_SUCCESS;
	_photo_import_params_unref0 (params);
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

static GdkPixbuf*
direct_photo_real_get_preview_pixbuf (MediaSource* base,
                                      Scaling* scaling,
                                      GError** error)
{
	DirectPhoto * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (DirectPhoto*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = self->priv->preview;
	if (_tmp0_ == NULL) {
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) self, DIRECT_PHOTO_PREVIEW_BEST_FIT, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->preview);
		self->priv->preview = _tmp3_;
		_tmp4_ = self->priv->preview;
		if (_tmp4_ == NULL) {
			GdkPixbuf* _tmp5_ = NULL;
			Scaling _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp6_ = *scaling;
			_tmp7_ = photo_source_get_pixbuf ((PhotoSource*) self, &_tmp6_, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (_tmp1_);
				return NULL;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (self->priv->preview);
			self->priv->preview = _tmp8_;
			_g_object_unref0 (_tmp5_);
		}
		_g_object_unref0 (_tmp1_);
	}
	_tmp9_ = self->priv->preview;
	_tmp10_ = scaling_perform_on_pixbuf (scaling, _tmp9_, GDK_INTERP_BILINEAR, TRUE);
	result = _tmp10_;
	return result;
}

static void
direct_photo_real_rotate (Photo* base,
                          Rotation rotation)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
	((Photo*) self)->can_rotate_now = FALSE;
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, FALSE);
	PHOTO_CLASS (direct_photo_parent_class)->rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), rotation);
}

static GdkPixbuf*
direct_photo_real_get_pixbuf (PhotoSource* base,
                              Scaling* scaling,
                              GError** error)
{
	DirectPhoto * self;
	GdkPixbuf* ret = NULL;
	Scaling _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (DirectPhoto*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = *scaling;
	_tmp1_ = PHOTO_SOURCE_CLASS (direct_photo_parent_class)->get_pixbuf ((PhotoSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp0_, &_inner_error0_);
	ret = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, TRUE);
	((Photo*) self)->can_rotate_now = TRUE;
	result = ret;
	return result;
}

static GdkPixbuf*
direct_photo_real_get_thumbnail (ThumbnailSource* base,
                                 gint scale,
                                 GError** error)
{
	DirectPhoto * self;
	GdkPixbuf* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_;
	PhotoMetadata* _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (DirectPhoto*) base;
	_tmp1_ = photo_source_get_metadata ((PhotoSource*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_metadata_get_preview_count (_tmp2_) == ((guint) 0);
	_media_metadata_unref0 (_tmp2_);
	if (_tmp3_) {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		GdkPixbuf* _tmp4_ = NULL;
		PhotoMetadata* _tmp5_;
		PhotoMetadata* _tmp6_;
		PhotoPreview* _tmp7_;
		PhotoPreview* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp5_ = photo_source_get_metadata ((PhotoSource*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = photo_metadata_get_preview (_tmp6_, (guint) 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = photo_preview_get_pixbuf (_tmp8_, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_photo_preview_unref0 (_tmp8_);
		_media_metadata_unref0 (_tmp6_);
		_tmp4_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		}
		_tmp11_ = orientation_rotate_pixbuf (photo_get_orientation ((Photo*) self), _tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp11_;
		_g_object_unref0 (_tmp4_);
	}
	result = _tmp0_;
	return result;
}

static void
direct_photo_real_notify_altered (DataObject* base,
                                  Alteration* alteration)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
	g_return_if_fail (alteration != NULL);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = NULL;
	DATA_OBJECT_CLASS (direct_photo_parent_class)->notify_altered ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), alteration);
}

static gboolean
direct_photo_real_has_user_generated_metadata (Photo* base)
{
	DirectPhoto * self;
	gboolean result;
	self = (DirectPhoto*) base;
	result = FALSE;
	return result;
}

static void
direct_photo_real_set_user_metadata_for_export (Photo* base,
                                                PhotoMetadata* metadata)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
	g_return_if_fail (metadata != NULL);
}

static void
direct_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                    PhotoMetadata* metadata)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
	g_return_if_fail (metadata != NULL);
}

static gboolean
direct_photo_real_is_trashed (MediaSource* base)
{
	DirectPhoto * self;
	gboolean result;
	self = (DirectPhoto*) base;
	result = FALSE;
	return result;
}

static gboolean
direct_photo_real_is_offline (MediaSource* base)
{
	DirectPhoto * self;
	gboolean result;
	self = (DirectPhoto*) base;
	result = FALSE;
	return result;
}

static void
direct_photo_real_trash (MediaSource* base)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
}

static void
direct_photo_real_untrash (MediaSource* base)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
}

static void
direct_photo_real_mark_offline (MediaSource* base)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
}

static void
direct_photo_real_mark_online (MediaSource* base)
{
	DirectPhoto * self;
	self = (DirectPhoto*) base;
}

static void
direct_photo_class_init (DirectPhotoClass * klass,
                         gpointer klass_data)
{
	direct_photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DirectPhoto_private_offset);
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) direct_photo_real_get_preview_pixbuf;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) direct_photo_real_rotate;
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource*, Scaling*, GError**)) direct_photo_real_get_pixbuf;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) direct_photo_real_get_thumbnail;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) direct_photo_real_notify_altered;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) direct_photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) direct_photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) direct_photo_real_apply_user_metadata_for_reimport;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) direct_photo_real_is_trashed;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) direct_photo_real_is_offline;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) direct_photo_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) direct_photo_real_untrash;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) direct_photo_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) direct_photo_real_mark_online;
	G_OBJECT_CLASS (klass)->finalize = direct_photo_finalize;
	direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL] = g_signal_new ("can-rotate-changed", TYPE_DIRECT_PHOTO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
direct_photo_instance_init (DirectPhoto * self,
                            gpointer klass)
{
	self->priv = direct_photo_get_instance_private (self);
	self->priv->preview = NULL;
	self->priv->loaded = FALSE;
}

static void
direct_photo_finalize (GObject * obj)
{
	DirectPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO, DirectPhoto);
	_g_object_unref0 (self->priv->preview);
	G_OBJECT_CLASS (direct_photo_parent_class)->finalize (obj);
}

static GType
direct_photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhoto), 0, (GInstanceInitFunc) direct_photo_instance_init, NULL };
	GType direct_photo_type_id;
	direct_photo_type_id = g_type_register_static (TYPE_PHOTO, "DirectPhoto", &g_define_type_info, 0);
	DirectPhoto_private_offset = g_type_add_instance_private (direct_photo_type_id, sizeof (DirectPhotoPrivate));
	return direct_photo_type_id;
}

GType
direct_photo_get_type (void)
{
	static volatile gsize direct_photo_type_id__once = 0;
	if (g_once_init_enter (&direct_photo_type_id__once)) {
		GType direct_photo_type_id;
		direct_photo_type_id = direct_photo_get_type_once ();
		g_once_init_leave (&direct_photo_type_id__once, direct_photo_type_id);
	}
	return direct_photo_type_id__once;
}

static inline gpointer
direct_photo_source_collection_get_instance_private (DirectPhotoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, DirectPhotoSourceCollection_private_offset);
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gint64
_direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source,
                                                                        gpointer self)
{
	gint64 result;
	result = direct_photo_source_collection_get_direct_key (source);
	return result;
}

static void
_direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender,
                                                                                      GFile* file,
                                                                                      GFileInfo* info,
                                                                                      gpointer self)
{
	direct_photo_source_collection_on_file_discovered ((DirectPhotoSourceCollection*) self, file, info);
}

static void
_direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                              gpointer self)
{
	direct_photo_source_collection_on_discovery_completed ((DirectPhotoSourceCollection*) self);
}

DirectPhotoSourceCollection*
direct_photo_source_collection_construct (GType object_type,
                                          GFile* initial_file)
{
	DirectPhotoSourceCollection* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DirectoryMonitor* _tmp2_;
	DirectoryMonitor* _tmp3_;
	DirectoryMonitor* _tmp4_;
	DirectoryMonitor* _tmp5_;
	g_return_val_if_fail (initial_file != NULL, NULL);
	self = (DirectPhotoSourceCollection*) database_source_collection_construct (object_type, "DirectPhotoSourceCollection", _direct_photo_source_collection_get_direct_key_get_source_database_key, NULL);
	_tmp0_ = g_file_get_parent (initial_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = directory_monitor_new (_tmp1_, FALSE, FALSE);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = self->priv->monitor;
	g_signal_connect (_tmp3_, "file-discovered", (GCallback) _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered, self);
	_tmp4_ = self->priv->monitor;
	g_signal_connect (_tmp4_, "discovery-completed", (GCallback) _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed, self);
	_tmp5_ = self->priv->monitor;
	directory_monitor_start_discovery (_tmp5_);
	return self;
}

DirectPhotoSourceCollection*
direct_photo_source_collection_new (GFile* initial_file)
{
	return direct_photo_source_collection_construct (TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, initial_file);
}

static gboolean
direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                          DataSource* source)
{
	DirectPhotoSourceCollection * self;
	gboolean result;
	self = (DirectPhotoSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_DIRECT_PHOTO (source);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint64
direct_photo_source_collection_get_direct_key (DataSource* source)
{
	DirectPhoto* photo = NULL;
	DirectPhoto* _tmp0_;
	PhotoID photo_id = {0};
	PhotoID _tmp1_ = {0};
	PhotoID _tmp2_;
	gint64 result;
	g_return_val_if_fail (source != NULL, 0LL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DIRECT_PHOTO, DirectPhoto));
	photo = _tmp0_;
	photo_get_photo_id ((Photo*) photo, &_tmp1_);
	photo_id = _tmp1_;
	_tmp2_ = photo_id;
	result = _tmp2_.id;
	_g_object_unref0 (photo);
	return result;
}

static void
direct_photo_source_collection_real_notify_items_added (DataCollection* base,
                                                        GeeIterable* added)
{
	DirectPhotoSourceCollection * self;
	self = (DirectPhotoSourceCollection*) base;
	g_return_if_fail (added != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp4_;
			DirectPhoto* _tmp5_;
			GFile* file = NULL;
			DirectPhoto* _tmp6_;
			GFile* _tmp7_;
			GeeHashMap* _tmp8_;
			GFile* _tmp9_;
			GeeHashMap* _tmp10_;
			GFile* _tmp11_;
			DirectPhoto* _tmp12_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DIRECT_PHOTO, DirectPhoto));
			photo = _tmp5_;
			_tmp6_ = photo;
			_tmp7_ = media_source_get_file ((MediaSource*) _tmp6_);
			file = _tmp7_;
			_tmp8_ = self->priv->file_map;
			_tmp9_ = file;
			_vala_assert (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, _tmp9_), "!file_map.has_key (file)");
			_tmp10_ = self->priv->file_map;
			_tmp11_ = file;
			_tmp12_ = photo;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp11_, _tmp12_);
			_g_object_unref0 (file);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_added ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), added);
}

static void
direct_photo_source_collection_real_notify_items_removed (DataCollection* base,
                                                          GeeIterable* removed)
{
	DirectPhotoSourceCollection * self;
	self = (DirectPhotoSourceCollection*) base;
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp4_;
			DirectPhoto* _tmp5_;
			GFile* file = NULL;
			DirectPhoto* _tmp6_;
			GFile* _tmp7_;
			gboolean is_removed = FALSE;
			GeeHashMap* _tmp8_;
			GFile* _tmp9_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DIRECT_PHOTO, DirectPhoto));
			photo = _tmp5_;
			_tmp6_ = photo;
			_tmp7_ = media_source_get_file ((MediaSource*) _tmp6_);
			file = _tmp7_;
			_tmp8_ = self->priv->file_map;
			_tmp9_ = file;
			is_removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
			_vala_assert (is_removed, "is_removed");
			_g_object_unref0 (file);
			_g_object_unref0 (photo);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_removed ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), removed);
}

gboolean
direct_photo_source_collection_has_source_for_file (DirectPhotoSourceCollection* self,
                                                    GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file);
	return result;
}

static void
direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self,
                                                   GFile* file,
                                                   GFileInfo* info)
{
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	DirectPhoto* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeCollection* _tmp4_;
	DirectPhoto* _tmp5_;
	GeeCollection* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (info != NULL);
	if (direct_photo_source_collection_has_source_for_file (self, file)) {
		return;
	}
	if (!photo_file_format_is_file_supported (file)) {
		return;
	}
	_tmp1_ = direct_photo_source_collection_fetch (self, file, &_tmp0_, FALSE);
	_g_object_unref0 (photo);
	photo = _tmp0_;
	reason = _tmp1_;
	_tmp2_ = reason;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = reason;
		g_warning ("DirectPhoto.vala:253: Error fetching file: %s", _tmp3_);
	}
	_tmp4_ = self->priv->prepared_photos;
	_tmp5_ = photo;
	gee_collection_add (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->prepared_photos;
	_tmp7_ = gee_collection_get_size (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ >= DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD) {
		direct_photo_source_collection_flush_prepared_photos (self);
	}
	_g_free0 (reason);
	_g_object_unref0 (photo);
}

static void
direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self)
{
	g_return_if_fail (self != NULL);
	direct_photo_source_collection_flush_prepared_photos (self);
}

static void
direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prepared_photos;
	_tmp1_ = data_collection_add_many ((DataCollection*) self, _tmp0_, NULL, NULL);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->prepared_photos;
	gee_collection_clear (_tmp3_);
}

gboolean
direct_photo_source_collection_has_file (DirectPhotoSourceCollection* self,
                                         GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file);
	return result;
}

void
direct_photo_source_collection_reimport_photo (DirectPhotoSourceCollection* self,
                                               DirectPhoto* photo)
{
	DirectPhoto* reimported_photo = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DirectPhoto* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	photo_discard_prefetched ((Photo*) photo, TRUE);
	_tmp0_ = media_source_get_file ((MediaSource*) photo);
	_tmp1_ = _tmp0_;
	_tmp3_ = direct_photo_source_collection_fetch (self, _tmp1_, &_tmp2_, TRUE);
	_g_object_unref0 (reimported_photo);
	reimported_photo = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (reimported_photo);
}

gchar*
direct_photo_source_collection_fetch (DirectPhotoSourceCollection* self,
                                      GFile* file,
                                      DirectPhoto** photo,
                                      gboolean reimport)
{
	DirectPhoto* _vala_photo = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DirectPhoto* _tmp2_;
	ImportResult _result_ = 0;
	DirectPhoto* _tmp18_ = NULL;
	ImportResult _tmp19_;
	gchar* _tmp20_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->file_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	_g_object_unref0 (_vala_photo);
	_vala_photo = (DirectPhoto*) _tmp1_;
	_tmp2_ = _vala_photo;
	if (_tmp2_ != NULL) {
		gchar* reason = NULL;
		reason = NULL;
		if (reimport) {
			{
				Orientation ori_tmp = 0;
				gboolean should_restore_ori = FALSE;
				gboolean _tmp3_ = FALSE;
				DirectPhoto* _tmp4_;
				PhotoReimportMasterState* reimport_state = NULL;
				gboolean _tmp7_ = FALSE;
				DirectPhoto* _tmp8_;
				PhotoReimportMasterState* _tmp9_ = NULL;
				gboolean _tmp10_;
				ori_tmp = ORIENTATION_TOP_LEFT;
				should_restore_ori = FALSE;
				_tmp4_ = _vala_photo;
				if (photo_only_metadata_changed ((Photo*) _tmp4_)) {
					_tmp3_ = TRUE;
				} else {
					DirectPhoto* _tmp5_;
					_tmp5_ = _vala_photo;
					_tmp3_ = photo_get_file_format ((Photo*) _tmp5_) == PHOTO_FILE_FORMAT_JFIF;
				}
				if (_tmp3_) {
					DirectPhoto* _tmp6_;
					_tmp6_ = _vala_photo;
					ori_tmp = photo_get_orientation ((Photo*) _tmp6_);
					should_restore_ori = TRUE;
				}
				_tmp8_ = _vala_photo;
				_tmp10_ = photo_prepare_for_reimport_master ((Photo*) _tmp8_, &_tmp9_, &_inner_error0_);
				_photo_reimport_master_state_unref0 (reimport_state);
				reimport_state = _tmp9_;
				_tmp7_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_reimport_master_state_unref0 (reimport_state);
					goto __catch0_g_error;
				}
				if (_tmp7_) {
					DirectPhoto* _tmp11_;
					PhotoReimportMasterState* _tmp12_;
					_tmp11_ = _vala_photo;
					_tmp12_ = reimport_state;
					photo_finish_reimport_master ((Photo*) _tmp11_, _tmp12_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_photo_reimport_master_state_unref0 (reimport_state);
						goto __catch0_g_error;
					}
					if (should_restore_ori) {
						DirectPhoto* _tmp13_;
						_tmp13_ = _vala_photo;
						direct_photo_fixup_orientation_after_reimport (_tmp13_, ori_tmp);
					}
				} else {
					gchar* _tmp14_;
					_tmp14_ = import_result_to_string (IMPORT_RESULT_FILE_ERROR);
					_g_free0 (reason);
					reason = _tmp14_;
				}
				_photo_reimport_master_state_unref0 (reimport_state);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = err;
				_tmp16_ = _tmp15_->message;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (reason);
				reason = _tmp17_;
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (reason);
				_g_object_unref0 (_vala_photo);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = reason;
		if (photo) {
			*photo = _vala_photo;
		} else {
			_g_object_unref0 (_vala_photo);
		}
		return result;
	}
	_tmp19_ = direct_photo_internal_import (file, &_tmp18_);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp18_;
	_result_ = _tmp19_;
	if (_result_ == IMPORT_RESULT_SUCCESS) {
		_g_free0 (_tmp20_);
		_tmp20_ = NULL;
	} else {
		gchar* _tmp21_;
		_tmp21_ = import_result_to_string (_result_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp21_;
	}
	result = _tmp20_;
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

gboolean
direct_photo_source_collection_has_file_source (DirectPhotoSourceCollection* self,
                                                GFile* file)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->file_map;
	result = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file);
	return result;
}

DirectPhoto*
direct_photo_source_collection_get_file_source (DirectPhotoSourceCollection* self,
                                                GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DirectPhoto* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->file_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, file);
	result = (DirectPhoto*) _tmp1_;
	return result;
}

static void
direct_photo_source_collection_class_init (DirectPhotoSourceCollectionClass * klass,
                                           gpointer klass_data)
{
	direct_photo_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = direct_photo_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &DirectPhotoSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) direct_photo_source_collection_real_holds_type_of_source;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) direct_photo_source_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) direct_photo_source_collection_real_notify_items_removed;
}

static void
direct_photo_source_collection_instance_init (DirectPhotoSourceCollection * self,
                                              gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = direct_photo_source_collection_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->prepared_photos = (GeeCollection*) _tmp0_;
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->file_map = _tmp1_;
}

static void
direct_photo_source_collection_finalize (DataCollection * obj)
{
	DirectPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
	_g_object_unref0 (self->priv->prepared_photos);
	_g_object_unref0 (self->priv->file_map);
	_g_object_unref0 (self->priv->monitor);
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->finalize (obj);
}

static GType
direct_photo_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhotoSourceCollection), 0, (GInstanceInitFunc) direct_photo_source_collection_instance_init, NULL };
	GType direct_photo_source_collection_type_id;
	direct_photo_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "DirectPhotoSourceCollection", &g_define_type_info, 0);
	DirectPhotoSourceCollection_private_offset = g_type_add_instance_private (direct_photo_source_collection_type_id, sizeof (DirectPhotoSourceCollectionPrivate));
	return direct_photo_source_collection_type_id;
}

GType
direct_photo_source_collection_get_type (void)
{
	static volatile gsize direct_photo_source_collection_type_id__once = 0;
	if (g_once_init_enter (&direct_photo_source_collection_type_id__once)) {
		GType direct_photo_source_collection_type_id;
		direct_photo_source_collection_type_id = direct_photo_source_collection_get_type_once ();
		g_once_init_leave (&direct_photo_source_collection_type_id__once, direct_photo_source_collection_type_id);
	}
	return direct_photo_source_collection_type_id__once;
}

