/* CameraTable.c generated by valac 0.56.18, the Vala compiler
 * generated from CameraTable.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <gudev/gudev.h>
#include <gphoto2/gphoto2-context.h>
#include <gphoto2/gphoto2-abilities-list.h>
#include <gee.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <stdio.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gphoto2/gphoto2-list.h>

#define CAMERA_TABLE_UPDATE_DELAY_MSEC 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _gp_camera_unref0(var) ((var == NULL) ? NULL : (var = (gp_camera_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecDiscoveredCamera ParamSpecDiscoveredCamera;
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
#define _gp_abilities_list_free0(var) ((var == NULL) ? NULL : (var = (gp_abilities_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _camera_table_unref0(var) ((var == NULL) ? NULL : (var = (camera_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _gp_port_info_list_free0(var) ((var == NULL) ? NULL : (var = (gp_port_info_list_free (var), NULL)))
#define _gp_list_unref0(var) ((var == NULL) ? NULL : (var = (gp_list_unref (var), NULL)))
#define _discovered_camera_unref0(var) ((var == NULL) ? NULL : (var = (discovered_camera_unref (var), NULL)))
typedef struct _ParamSpecCameraTable ParamSpecCameraTable;
enum  {
	CAMERA_TABLE_CAMERA_ADDED_SIGNAL,
	CAMERA_TABLE_CAMERA_REMOVED_SIGNAL,
	CAMERA_TABLE_NUM_SIGNALS
};
static guint camera_table_signals[CAMERA_TABLE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecDiscoveredCamera {
	GParamSpec parent_instance;
};

struct _CameraTablePrivate {
	GUdevClient* client;
	OneShotScheduler* camera_update_scheduler;
	GPContext* null_context;
	CameraAbilitiesList* abilities_list;
	GVolumeMonitor* volume_monitor;
	GeeHashMap* camera_map;
};

struct _ParamSpecCameraTable {
	GParamSpec parent_instance;
};

static gpointer discovered_camera_parent_class = NULL;
static gint CameraTable_private_offset;
static gpointer camera_table_parent_class = NULL;
static CameraTable* camera_table_instance;
static CameraTable* camera_table_instance = NULL;

static void discovered_camera_finalize (DiscoveredCamera * obj);
static GType discovered_camera_get_type_once (void);
static CameraTable* camera_table_new (void);
static CameraTable* camera_table_construct (GType object_type);
static void camera_table_on_update_cameras (CameraTable* self);
static void _camera_table_on_update_cameras_one_shot_callback (gpointer self);
static void camera_table_on_udev_event (CameraTable* self,
                                 const gchar* action,
                                 GUdevDevice* device);
static void _camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                       const gchar* action,
                                                       GUdevDevice* device,
                                                       gpointer self);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                      GVolume* volume,
                                                                      gpointer self);
static void _camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                    GVolume* volume,
                                                                    gpointer self);
static gboolean camera_table_delayed_init (CameraTable* self);
static gboolean _camera_table_delayed_init_gsource_func (gpointer self);
static void camera_table_init_camera_table (CameraTable* self,
                                     GError** error);
static void camera_table_update_camera_table (CameraTable* self,
                                       GError** error);
static void camera_table_do_op (CameraTable* self,
                         int res,
                         const gchar* op,
                         GError** error);
static gchar** camera_table_get_all_usb_cameras (CameraTable* self,
                                          gint* result_length1);
static void _vala_array_add46 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean camera_table_usb_esp (CameraTable* self,
                               gint current_camera_count,
                               gchar** usb_cameras,
                               gint usb_cameras_length1,
                               const gchar* port,
                               gchar** full_port);
static gchar* camera_table_get_name_for_uuid (CameraTable* self,
                                       const gchar* uuid);
static GIcon* camera_table_get_icon_for_uuid (CameraTable* self,
                                       const gchar* uuid);
static void _vala_array_add47 (DiscoveredCamera** * array,
                        gint* length,
                        gint* size,
                        DiscoveredCamera* value);
static void g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void camera_table_finalize (CameraTable * obj);
static GType camera_table_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* CAMERA_TABLE_SUBSYSTEMS[3] = {"usb", "block", NULL};

static gpointer
_GPHOTO_REF_CAMERA0 (gpointer self)
{
	return self ? GPHOTO_REF_CAMERA (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DiscoveredCamera*
discovered_camera_construct (GType object_type,
                             Camera* gcamera,
                             const gchar* uri,
                             const gchar* display_name,
                             GIcon* icon)
{
	DiscoveredCamera* self = NULL;
	Camera* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GIcon* _tmp3_;
	g_return_val_if_fail (gcamera != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (DiscoveredCamera*) g_type_create_instance (object_type);
	_tmp0_ = _GPHOTO_REF_CAMERA0 (gcamera);
	_gp_camera_unref0 (self->gcamera);
	self->gcamera = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (self->uri);
	self->uri = _tmp1_;
	_tmp2_ = g_strdup (display_name);
	_g_free0 (self->display_name);
	self->display_name = _tmp2_;
	_tmp3_ = _g_object_ref0 (icon);
	_g_object_unref0 (self->icon);
	self->icon = _tmp3_;
	return self;
}

DiscoveredCamera*
discovered_camera_new (Camera* gcamera,
                       const gchar* uri,
                       const gchar* display_name,
                       GIcon* icon)
{
	return discovered_camera_construct (TYPE_DISCOVERED_CAMERA, gcamera, uri, display_name, icon);
}

static void
value_discovered_camera_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_discovered_camera_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		discovered_camera_unref (value->data[0].v_pointer);
	}
}

static void
value_discovered_camera_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = discovered_camera_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_discovered_camera_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_discovered_camera_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DiscoveredCamera * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = discovered_camera_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_discovered_camera_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	DiscoveredCamera ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = discovered_camera_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_discovered_camera (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecDiscoveredCamera* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DISCOVERED_CAMERA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_discovered_camera (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA), NULL);
	return value->data[0].v_pointer;
}

void
value_set_discovered_camera (GValue* value,
                             gpointer v_object)
{
	DiscoveredCamera * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		discovered_camera_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		discovered_camera_unref (old);
	}
}

void
value_take_discovered_camera (GValue* value,
                              gpointer v_object)
{
	DiscoveredCamera * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DISCOVERED_CAMERA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DISCOVERED_CAMERA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		discovered_camera_unref (old);
	}
}

static void
discovered_camera_class_init (DiscoveredCameraClass * klass,
                              gpointer klass_data)
{
	discovered_camera_parent_class = g_type_class_peek_parent (klass);
	((DiscoveredCameraClass *) klass)->finalize = discovered_camera_finalize;
}

static void
discovered_camera_instance_init (DiscoveredCamera * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
discovered_camera_finalize (DiscoveredCamera * obj)
{
	DiscoveredCamera * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DISCOVERED_CAMERA, DiscoveredCamera);
	g_signal_handlers_destroy (self);
	_gp_camera_unref0 (self->gcamera);
	_g_free0 (self->uri);
	_g_free0 (self->display_name);
	_g_object_unref0 (self->icon);
}

static GType
discovered_camera_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_discovered_camera_init, value_discovered_camera_free_value, value_discovered_camera_copy_value, value_discovered_camera_peek_pointer, "p", value_discovered_camera_collect_value, "p", value_discovered_camera_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DiscoveredCameraClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) discovered_camera_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DiscoveredCamera), 0, (GInstanceInitFunc) discovered_camera_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType discovered_camera_type_id;
	discovered_camera_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DiscoveredCamera", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return discovered_camera_type_id;
}

GType
discovered_camera_get_type (void)
{
	static volatile gsize discovered_camera_type_id__once = 0;
	if (g_once_init_enter (&discovered_camera_type_id__once)) {
		GType discovered_camera_type_id;
		discovered_camera_type_id = discovered_camera_get_type_once ();
		g_once_init_leave (&discovered_camera_type_id__once, discovered_camera_type_id);
	}
	return discovered_camera_type_id__once;
}

gpointer
discovered_camera_ref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
discovered_camera_unref (gpointer instance)
{
	DiscoveredCamera * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DISCOVERED_CAMERA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
camera_table_get_instance_private (CameraTable* self)
{
	return G_STRUCT_MEMBER_P (self, CameraTable_private_offset);
}

static void
_camera_table_on_update_cameras_one_shot_callback (gpointer self)
{
	camera_table_on_update_cameras ((CameraTable*) self);
}

static void
_camera_table_on_udev_event_g_udev_client_uevent (GUdevClient* _sender,
                                                  const gchar* action,
                                                  GUdevDevice* device,
                                                  gpointer self)
{
	camera_table_on_udev_event ((CameraTable*) self, action, device);
}

static void
_camera_table_on_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                 GVolume* volume,
                                                                 gpointer self)
{
	camera_table_on_volume_changed ((CameraTable*) self, volume);
}

static void
_camera_table_on_volume_changed_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                               GVolume* volume,
                                                               gpointer self)
{
	camera_table_on_volume_changed ((CameraTable*) self, volume);
}

static gboolean
_camera_table_delayed_init_gsource_func (gpointer self)
{
	gboolean result;
	result = camera_table_delayed_init ((CameraTable*) self);
	return result;
}

static CameraTable*
camera_table_construct (GType object_type)
{
	CameraTable* self = NULL;
	OneShotScheduler* _tmp0_;
	GUdevClient* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	self = (CameraTable*) g_type_create_instance (object_type);
	_tmp0_ = one_shot_scheduler_new ("CameraTable update scheduler", _camera_table_on_update_cameras_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
	self->priv->camera_update_scheduler = _tmp0_;
	_tmp1_ = self->priv->client;
	g_signal_connect (_tmp1_, "uevent", (GCallback) _camera_table_on_udev_event_g_udev_client_uevent, self);
	_tmp2_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp2_;
	_tmp3_ = self->priv->volume_monitor;
	g_signal_connect (_tmp3_, "volume-changed", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_changed, self);
	_tmp4_ = self->priv->volume_monitor;
	g_signal_connect (_tmp4_, "volume-added", (GCallback) _camera_table_on_volume_changed_g_volume_monitor_volume_added, self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _camera_table_delayed_init_gsource_func, camera_table_ref (self), camera_table_unref);
	return self;
}

static CameraTable*
camera_table_new (void)
{
	return camera_table_construct (TYPE_CAMERA_TABLE);
}

static gboolean
camera_table_delayed_init (CameraTable* self)
{
	AppWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	AppWindow* _tmp10_;
	LibraryWindow* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_WINDOW, LibraryWindow);
	library_window_set_page_switching_enabled (_tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
	{
		camera_table_init_camera_table (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch0_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	goto __finally0;
	__catch0_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("CameraTable.vala:78: Unable to initialize camera table: %s", _tmp4_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	{
		camera_table_update_camera_table (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch1_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally1;
	__catch1_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		_tmp8_ = _tmp7_->message;
		g_warning ("CameraTable.vala:86: Unable to update camera table: %s", _tmp8_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = app_window_get_instance ();
	_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_WINDOW, LibraryWindow);
	library_window_set_page_switching_enabled (_tmp11_, TRUE);
	_g_object_unref0 (_tmp11_);
	result = FALSE;
	return result;
}

static gpointer
_camera_table_ref0 (gpointer self)
{
	return self ? camera_table_ref (self) : NULL;
}

CameraTable*
camera_table_get_instance (void)
{
	CameraTable* _tmp0_;
	CameraTable* _tmp2_;
	CameraTable* _tmp3_;
	CameraTable* result;
	_tmp0_ = camera_table_instance;
	if (_tmp0_ == NULL) {
		CameraTable* _tmp1_;
		_tmp1_ = camera_table_new ();
		_camera_table_unref0 (camera_table_instance);
		camera_table_instance = _tmp1_;
	}
	_tmp2_ = camera_table_instance;
	_tmp3_ = _camera_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GeeIterable*
camera_table_get_cameras (CameraTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeIterable*) _tmp2_;
	return result;
}

gint
camera_table_get_count (CameraTable* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

DiscoveredCamera*
camera_table_get_for_uri (CameraTable* self,
                          const gchar* uri)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DiscoveredCamera* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = self->priv->camera_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, uri);
	result = (DiscoveredCamera*) _tmp1_;
	return result;
}

static void
camera_table_do_op (CameraTable* self,
                    int res,
                    const gchar* op,
                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	if (res != GP_OK) {
		const gchar* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = gp_port_result_as_string (res);
		_tmp1_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Unable to %s: %s", (gint) res, op, _tmp0_);
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
camera_table_init_camera_table (CameraTable* self,
                                GError** error)
{
	CameraAbilitiesList* _tmp0_ = NULL;
	int _tmp1_;
	CameraAbilitiesList* _tmp2_;
	GPContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = gp_abilities_list_new (&_tmp0_);
	_gp_abilities_list_free0 (self->priv->abilities_list);
	self->priv->abilities_list = _tmp0_;
	camera_table_do_op (self, _tmp1_, "create camera abilities list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = self->priv->abilities_list;
	_tmp3_ = self->priv->null_context;
	camera_table_do_op (self, gp_abilities_list_load (_tmp2_, _tmp3_), "load camera abilities list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
_vala_array_add46 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gchar**
camera_table_get_all_usb_cameras (CameraTable* self,
                                  gint* result_length1)
{
	gchar** cameras = NULL;
	gchar** _tmp0_;
	gint cameras_length1;
	gint _cameras_size_;
	GList* device_list = NULL;
	GUdevClient* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	cameras = _tmp0_;
	cameras_length1 = 0;
	_cameras_size_ = cameras_length1;
	_tmp1_ = self->priv->client;
	_tmp2_ = g_udev_client_query_by_subsystem (_tmp1_, NULL);
	device_list = _tmp2_;
	_tmp3_ = device_list;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp3_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			GUdevDevice* _tmp4_;
			GUdevDevice* device = NULL;
			_tmp4_ = _g_object_ref0 ((GUdevDevice*) device_it->data);
			device = _tmp4_;
			{
				gchar* device_file = NULL;
				GUdevDevice* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				_tmp5_ = device;
				_tmp6_ = g_udev_device_get_device_file (_tmp5_);
				_tmp7_ = g_strdup (_tmp6_);
				device_file = _tmp7_;
				_tmp10_ = device_file;
				if (_tmp10_ != NULL) {
					GUdevDevice* _tmp11_;
					_tmp11_ = device;
					_tmp9_ = g_udev_device_has_property (_tmp11_, "ID_GPHOTO2");
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GUdevDevice* _tmp12_;
					_tmp12_ = device;
					_tmp8_ = g_udev_device_has_property (_tmp12_, "GPHOTO2_DRIVER");
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gint camera_bus = 0;
					gint camera_device = 0;
					const gchar* _tmp13_;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gint _tmp16_;
					gchar* camera = NULL;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp13_ = device_file;
					_tmp16_ = sscanf (_tmp13_, "/dev/bus/usb/%d/%d", &_tmp14_, &_tmp15_);
					camera_bus = _tmp14_;
					camera_device = _tmp15_;
					if (_tmp16_ < 2) {
						const gchar* _tmp17_;
						_tmp17_ = device_file;
						g_critical ("CameraTable.vala:142: get_all_usb_cameras: Failed to scanf device file" \
" %s", _tmp17_);
						_g_free0 (device_file);
						_g_object_unref0 (device);
						continue;
					}
					_tmp18_ = g_strdup_printf ("usb:%.3d,%.3d", camera_bus, camera_device);
					camera = _tmp18_;
					_tmp19_ = camera;
					g_debug ("CameraTable.vala:147: USB camera detected at %s", _tmp19_);
					_tmp20_ = camera;
					_tmp21_ = g_strdup (_tmp20_);
					_vala_array_add46 (&cameras, &cameras_length1, &_cameras_size_, _tmp21_);
					_g_free0 (camera);
				}
				_g_free0 (device_file);
				_g_object_unref0 (device);
			}
		}
	}
	_tmp22_ = cameras;
	_tmp22__length1 = cameras_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	(device_list == NULL) ? NULL : (device_list = (_g_list_free__g_object_unref0_ (device_list), NULL));
	return result;
}

static gboolean
camera_table_usb_esp (CameraTable* self,
                      gint current_camera_count,
                      gchar** usb_cameras,
                      gint usb_cameras_length1,
                      const gchar* port,
                      gchar** full_port)
{
	gchar* _vala_full_port = NULL;
	gboolean _tmp0_ = FALSE;
	gint bus = 0;
	gint device = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (port != NULL, FALSE);
	_vala_assert (current_camera_count > 0, "current_camera_count > 0");
	g_debug ("CameraTable.vala:168: USB ESP: current_camera_count=%d port=%s", current_camera_count, port);
	_g_free0 (_vala_full_port);
	_vala_full_port = NULL;
	if (current_camera_count == 1) {
		_tmp0_ = usb_cameras_length1 == 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = usb_cameras[0];
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_vala_full_port);
		_vala_full_port = _tmp2_;
		_tmp3_ = _vala_full_port;
		g_debug ("CameraTable.vala:176: USB ESP: port=%s full_port=%s", port, _tmp3_);
		result = TRUE;
		if (full_port) {
			*full_port = _vala_full_port;
		} else {
			_g_free0 (_vala_full_port);
		}
		return result;
	}
	if (g_strcmp0 (port, "usb:") == 0) {
		g_debug ("CameraTable.vala:183: USB ESP: Skipping %s", port);
		result = FALSE;
		if (full_port) {
			*full_port = _vala_full_port;
		} else {
			_g_free0 (_vala_full_port);
		}
		return result;
	}
	_tmp6_ = sscanf (port, "usb:%d,%d", &_tmp4_, &_tmp5_);
	bus = _tmp4_;
	device = _tmp5_;
	if (_tmp6_ < 2) {
		g_critical ("CameraTable.vala:191: USB ESP: Failed to scanf %s", port);
		result = FALSE;
		if (full_port) {
			*full_port = _vala_full_port;
		} else {
			_g_free0 (_vala_full_port);
		}
		return result;
	}
	{
		gchar** usb_camera_collection = NULL;
		gint usb_camera_collection_length1 = 0;
		gint _usb_camera_collection_size_ = 0;
		gint usb_camera_it = 0;
		usb_camera_collection = usb_cameras;
		usb_camera_collection_length1 = usb_cameras_length1;
		for (usb_camera_it = 0; usb_camera_it < usb_camera_collection_length1; usb_camera_it = usb_camera_it + 1) {
			gchar* _tmp7_;
			gchar* usb_camera = NULL;
			_tmp7_ = g_strdup (usb_camera_collection[usb_camera_it]);
			usb_camera = _tmp7_;
			{
				gint camera_bus = 0;
				gint camera_device = 0;
				const gchar* _tmp8_;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_;
				gboolean _tmp13_ = FALSE;
				_tmp8_ = usb_camera;
				_tmp11_ = sscanf (_tmp8_, "usb:%d,%d", &_tmp9_, &_tmp10_);
				camera_bus = _tmp9_;
				camera_device = _tmp10_;
				if (_tmp11_ < 2) {
					const gchar* _tmp12_;
					_tmp12_ = usb_camera;
					g_critical ("CameraTable.vala:199: USB ESP: Failed to scanf %s", _tmp12_);
					_g_free0 (usb_camera);
					continue;
				}
				if (bus == camera_bus) {
					_tmp13_ = device == camera_device;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = g_strdup (port);
					_g_free0 (_vala_full_port);
					_vala_full_port = _tmp14_;
					_tmp15_ = _vala_full_port;
					g_debug ("CameraTable.vala:207: USB ESP: port=%s full_port=%s", port, _tmp15_);
					result = TRUE;
					_g_free0 (usb_camera);
					if (full_port) {
						*full_port = _vala_full_port;
					} else {
						_g_free0 (_vala_full_port);
					}
					return result;
				}
				_g_free0 (usb_camera);
			}
		}
	}
	g_debug ("CameraTable.vala:213: USB ESP: No matching bus/device found for port=%" \
"s", port);
	result = FALSE;
	if (full_port) {
		*full_port = _vala_full_port;
	} else {
		_g_free0 (_vala_full_port);
	}
	return result;
}

gchar*
camera_table_get_port_uri (const gchar* port)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (port != NULL, NULL);
	_tmp0_ = g_strdup_printf ("gphoto2://[%s]/", port);
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
camera_table_get_port_path (const gchar* port)
{
	gchar* _tmp0_ = NULL;
	gchar* result;
	g_return_val_if_fail (port != NULL, NULL);
	if (g_str_has_prefix (port, "usb:")) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = string_substring (port, (glong) 4, (glong) -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_replace (_tmp2_, ",", "/");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("/dev/bus/usb/%s", _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static gchar*
camera_table_get_name_for_uuid (CameraTable* self,
                                const gchar* uuid)
{
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = self->priv->volume_monitor;
	_tmp1_ = g_volume_monitor_get_volumes (_tmp0_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp1_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp2_;
			GVolume* volume = NULL;
			_tmp2_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp2_;
			{
				GVolume* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp3_ = volume;
				_tmp4_ = g_volume_get_identifier (_tmp3_, G_VOLUME_IDENTIFIER_KIND_UUID);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, uuid) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					GVolume* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = volume;
					_tmp8_ = g_volume_get_name (_tmp7_);
					result = _tmp8_;
					_g_object_unref0 (volume);
					(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
					return result;
				}
				_g_object_unref0 (volume);
			}
		}
		(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
	}
	result = NULL;
	return result;
}

static GIcon*
camera_table_get_icon_for_uuid (CameraTable* self,
                                const gchar* uuid)
{
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = self->priv->volume_monitor;
	_tmp1_ = g_volume_monitor_get_volumes (_tmp0_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp1_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp2_;
			GVolume* volume = NULL;
			_tmp2_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp2_;
			{
				GVolume* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp3_ = volume;
				_tmp4_ = g_volume_get_identifier (_tmp3_, G_VOLUME_IDENTIFIER_KIND_UUID);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, uuid) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					GVolume* _tmp7_;
					GIcon* _tmp8_;
					_tmp7_ = volume;
					_tmp8_ = g_volume_get_icon (_tmp7_);
					result = _tmp8_;
					_g_object_unref0 (volume);
					(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
					return result;
				}
				_g_object_unref0 (volume);
			}
		}
		(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
	}
	result = NULL;
	return result;
}

static gpointer
_discovered_camera_ref0 (gpointer self)
{
	return self ? discovered_camera_ref (self) : NULL;
}

static void
_vala_array_add47 (DiscoveredCamera** * array,
                   gint* length,
                   gint* size,
                   DiscoveredCamera* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (DiscoveredCamera*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
camera_table_update_camera_table (CameraTable* self,
                                  GError** error)
{
	GPPortInfoList* port_info_list = NULL;
	GPPortInfoList* _tmp0_ = NULL;
	int _tmp1_;
	GPPortInfoList* _tmp2_;
	CameraList* camera_list = NULL;
	CameraList* _tmp3_ = NULL;
	int _tmp4_;
	CameraAbilitiesList* _tmp5_;
	GPPortInfoList* _tmp6_;
	CameraList* _tmp7_;
	GPContext* _tmp8_;
	GeeHashMap* detected_map = NULL;
	GeeHashMap* _tmp9_;
	gchar** usb_cameras = NULL;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gint usb_cameras_length1;
	gint _usb_cameras_size_;
	DiscoveredCamera** missing = NULL;
	DiscoveredCamera** _tmp37_;
	gint missing_length1;
	gint _missing_size_;
	DiscoveredCamera** _tmp65_;
	gint _tmp65__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = gp_port_info_list_new (&_tmp0_);
	_gp_port_info_list_free0 (port_info_list);
	port_info_list = _tmp0_;
	camera_table_do_op (self, _tmp1_, "create port list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = port_info_list;
	camera_table_do_op (self, gp_port_info_list_load (_tmp2_), "load port list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = gp_list_new (&_tmp3_);
	_gp_list_unref0 (camera_list);
	camera_list = _tmp3_;
	camera_table_do_op (self, _tmp4_, "create camera list", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = self->priv->abilities_list;
	_tmp6_ = port_info_list;
	_tmp7_ = camera_list;
	_tmp8_ = self->priv->null_context;
	camera_table_do_op (self, gp_abilities_list_detect (_tmp5_, _tmp6_, _tmp7_, _tmp8_), "detect cameras", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GPHOTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			return;
		} else {
			_gp_list_unref0 (camera_list);
			_gp_port_info_list_free0 (port_info_list);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	detected_map = _tmp9_;
	_tmp11_ = camera_table_get_all_usb_cameras (self, &_tmp10_);
	usb_cameras = _tmp11_;
	usb_cameras_length1 = _tmp10_;
	_usb_cameras_size_ = usb_cameras_length1;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				CameraList* _tmp14_;
				gchar* name = NULL;
				CameraList* _tmp15_;
				const gchar* _tmp16_ = NULL;
				int _tmp17_;
				gchar* _tmp18_;
				gchar* port = NULL;
				CameraList* _tmp19_;
				const gchar* _tmp20_ = NULL;
				int _tmp21_;
				gchar* _tmp22_;
				CameraList* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				GeeHashMap* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = ctr;
					ctr = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = camera_list;
				if (!(ctr < gp_list_count (_tmp14_))) {
					break;
				}
				_tmp15_ = camera_list;
				_tmp17_ = gp_list_get_name (_tmp15_, ctr, &_tmp16_);
				_g_free0 (name);
				_tmp18_ = g_strdup (_tmp16_);
				name = _tmp18_;
				camera_table_do_op (self, _tmp17_, "get detected camera name", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (name);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp19_ = camera_list;
				_tmp21_ = gp_list_get_value (_tmp19_, ctr, &_tmp20_);
				_g_free0 (port);
				_tmp22_ = g_strdup (_tmp20_);
				port = _tmp22_;
				camera_table_do_op (self, _tmp21_, "get detected camera port", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (port);
						_g_free0 (name);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (port);
						_g_free0 (name);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp23_ = camera_list;
				_tmp24_ = name;
				_tmp25_ = port;
				g_debug ("CameraTable.vala:269: Detected %d/%d %s @ %s", ctr + 1, gp_list_count (_tmp23_), _tmp24_, _tmp25_);
				_tmp26_ = port;
				if (g_str_has_prefix (_tmp26_, "usb:")) {
					gchar* full_port = NULL;
					CameraList* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					gboolean _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp27_ = camera_list;
					_tmp28_ = usb_cameras;
					_tmp28__length1 = usb_cameras_length1;
					_tmp29_ = port;
					_tmp31_ = camera_table_usb_esp (self, gp_list_count (_tmp27_), _tmp28_, (gint) _tmp28__length1, _tmp29_, &_tmp30_);
					_g_free0 (full_port);
					full_port = _tmp30_;
					if (!_tmp31_) {
						_g_free0 (full_port);
						_g_free0 (port);
						_g_free0 (name);
						continue;
					}
					_tmp32_ = full_port;
					_tmp33_ = g_strdup (_tmp32_);
					_g_free0 (port);
					port = _tmp33_;
					_g_free0 (full_port);
				}
				_tmp34_ = detected_map;
				_tmp35_ = port;
				_tmp36_ = name;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, _tmp35_, _tmp36_);
				_g_free0 (port);
				_g_free0 (name);
			}
		}
	}
	_tmp37_ = g_new0 (DiscoveredCamera*, 0 + 1);
	missing = _tmp37_;
	missing_length1 = 0;
	_missing_size_ = missing_length1;
	{
		GeeIterator* _camera_it = NULL;
		GeeHashMap* _tmp38_;
		GeeCollection* _tmp39_;
		GeeCollection* _tmp40_;
		GeeCollection* _tmp41_;
		GeeIterator* _tmp42_;
		GeeIterator* _tmp43_;
		_tmp38_ = self->priv->camera_map;
		_tmp39_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
		_tmp43_ = _tmp42_;
		_g_object_unref0 (_tmp41_);
		_camera_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_;
			DiscoveredCamera* camera = NULL;
			GeeIterator* _tmp45_;
			gpointer _tmp46_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			DiscoveredCamera* _tmp47_;
			Camera* _tmp48_;
			GPPortInfo _tmp49_ = {0};
			int _tmp50_;
			const gchar* _tmp51_ = NULL;
			gchar* _tmp52_;
			CameraAbilities abilities = {0};
			DiscoveredCamera* _tmp53_;
			Camera* _tmp54_;
			CameraAbilities _tmp55_ = {0};
			int _tmp56_;
			GeeHashMap* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp61_;
			const gchar* _tmp62_;
			DiscoveredCamera* _tmp63_;
			DiscoveredCamera* _tmp64_;
			_tmp44_ = _camera_it;
			if (!gee_iterator_next (_tmp44_)) {
				break;
			}
			_tmp45_ = _camera_it;
			_tmp46_ = gee_iterator_get (_tmp45_);
			camera = (DiscoveredCamera*) _tmp46_;
			_tmp47_ = camera;
			_tmp48_ = _tmp47_->gcamera;
			_tmp50_ = gp_camera_get_port_info (_tmp48_, &_tmp49_);
			 (port_info);
			port_info = _tmp49_;
			camera_table_do_op (self, _tmp50_, "retrieve missing camera port information", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			gp_port_info_get_path (port_info, &_tmp51_);
			_g_free0 (tmp_path);
			_tmp52_ = g_strdup (_tmp51_);
			tmp_path = _tmp52_;
			_tmp53_ = camera;
			_tmp54_ = _tmp53_->gcamera;
			_tmp56_ = gp_camera_get_abilities (_tmp54_, &_tmp55_);
			 (abilities);
			abilities = _tmp55_;
			camera_table_do_op (self, _tmp56_, "retrieve camera abilities", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					 (abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					 (abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_discovered_camera_unref0 (camera);
					_g_object_unref0 (_camera_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp57_ = detected_map;
			_tmp58_ = tmp_path;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp57_, _tmp58_)) {
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				_tmp59_ = abilities.model;
				_tmp60_ = tmp_path;
				g_debug ("CameraTable.vala:298: Found camera for %s @ %s in detected map", _tmp59_, _tmp60_);
				 (abilities);
				_g_free0 (tmp_path);
				 (port_info);
				_discovered_camera_unref0 (camera);
				continue;
			}
			_tmp61_ = abilities.model;
			_tmp62_ = tmp_path;
			g_debug ("CameraTable.vala:303: %s @ %s missing", _tmp61_, _tmp62_);
			_tmp63_ = camera;
			_tmp64_ = _discovered_camera_ref0 (_tmp63_);
			_vala_array_add47 (&missing, &missing_length1, &_missing_size_, _tmp64_);
			 (abilities);
			_g_free0 (tmp_path);
			 (port_info);
			_discovered_camera_unref0 (camera);
		}
		_g_object_unref0 (_camera_it);
	}
	_tmp65_ = missing;
	_tmp65__length1 = missing_length1;
	{
		DiscoveredCamera** camera_collection = NULL;
		gint camera_collection_length1 = 0;
		gint _camera_collection_size_ = 0;
		gint camera_it = 0;
		camera_collection = _tmp65_;
		camera_collection_length1 = _tmp65__length1;
		for (camera_it = 0; camera_it < camera_collection_length1; camera_it = camera_it + 1) {
			DiscoveredCamera* _tmp66_;
			DiscoveredCamera* camera = NULL;
			_tmp66_ = _discovered_camera_ref0 (camera_collection[camera_it]);
			camera = _tmp66_;
			{
				GPPortInfo port_info = {0};
				gchar* tmp_path = NULL;
				DiscoveredCamera* _tmp67_;
				Camera* _tmp68_;
				GPPortInfo _tmp69_ = {0};
				int _tmp70_;
				const gchar* _tmp71_ = NULL;
				gchar* _tmp72_;
				CameraAbilities abilities = {0};
				DiscoveredCamera* _tmp73_;
				Camera* _tmp74_;
				CameraAbilities _tmp75_ = {0};
				int _tmp76_;
				const gchar* _tmp77_;
				const gchar* _tmp78_;
				GeeHashMap* _tmp79_;
				const gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				DiscoveredCamera* _tmp83_;
				_tmp67_ = camera;
				_tmp68_ = _tmp67_->gcamera;
				_tmp70_ = gp_camera_get_port_info (_tmp68_, &_tmp69_);
				 (port_info);
				port_info = _tmp69_;
				camera_table_do_op (self, _tmp70_, "retrieve missing camera port information", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				gp_port_info_get_path (port_info, &_tmp71_);
				_g_free0 (tmp_path);
				_tmp72_ = g_strdup (_tmp71_);
				tmp_path = _tmp72_;
				_tmp73_ = camera;
				_tmp74_ = _tmp73_->gcamera;
				_tmp76_ = gp_camera_get_abilities (_tmp74_, &_tmp75_);
				 (abilities);
				abilities = _tmp75_;
				camera_table_do_op (self, _tmp76_, "retrieve missing camera abilities", &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						 (abilities);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						 (abilities);
						_g_free0 (tmp_path);
						 (port_info);
						_discovered_camera_unref0 (camera);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp77_ = abilities.model;
				_tmp78_ = tmp_path;
				g_debug ("CameraTable.vala:320: Removing from camera table: %s @ %s", _tmp77_, _tmp78_);
				_tmp79_ = self->priv->camera_map;
				_tmp80_ = tmp_path;
				_tmp81_ = camera_table_get_port_uri (_tmp80_);
				_tmp82_ = _tmp81_;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp79_, _tmp82_, NULL);
				_g_free0 (_tmp82_);
				_tmp83_ = camera;
				g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL], 0, _tmp83_);
				 (abilities);
				_g_free0 (tmp_path);
				 (port_info);
				_discovered_camera_unref0 (camera);
			}
		}
	}
	{
		GeeIterator* _port_it = NULL;
		GeeHashMap* _tmp84_;
		GeeSet* _tmp85_;
		GeeSet* _tmp86_;
		GeeSet* _tmp87_;
		GeeIterator* _tmp88_;
		GeeIterator* _tmp89_;
		_tmp84_ = detected_map;
		_tmp85_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = _tmp86_;
		_tmp88_ = gee_iterable_iterator ((GeeIterable*) _tmp87_);
		_tmp89_ = _tmp88_;
		_g_object_unref0 (_tmp87_);
		_port_it = _tmp89_;
		while (TRUE) {
			GeeIterator* _tmp90_;
			gchar* port = NULL;
			GeeIterator* _tmp91_;
			gpointer _tmp92_;
			gchar* name = NULL;
			GeeHashMap* _tmp93_;
			const gchar* _tmp94_;
			gpointer _tmp95_;
			gchar* display_name = NULL;
			GIcon* icon = NULL;
			gchar* uri = NULL;
			const gchar* _tmp96_;
			gchar* _tmp97_;
			GeeHashMap* _tmp98_;
			const gchar* _tmp99_;
			gchar* path = NULL;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			const gchar* _tmp104_;
			const gchar* _tmp124_;
			gint index = 0;
			GPPortInfoList* _tmp127_;
			const gchar* _tmp128_;
			GPPortInfo port_info = {0};
			gchar* tmp_path = NULL;
			GPPortInfoList* _tmp132_;
			GPPortInfo _tmp133_ = {0};
			int _tmp134_;
			const gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			const gchar* _tmp138_ = NULL;
			gchar* _tmp139_;
			const gchar* _tmp140_;
			const gchar* _tmp141_;
			CameraAbilitiesList* _tmp142_;
			const gchar* _tmp143_;
			CameraAbilities camera_abilities = {0};
			CameraAbilitiesList* _tmp147_;
			CameraAbilities _tmp148_ = {0};
			int _tmp149_;
			const gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			Camera* gcamera = NULL;
			Camera* _tmp153_ = NULL;
			int _tmp154_;
			const gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			Camera* _tmp158_;
			const gchar* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			Camera* _tmp162_;
			const gchar* _tmp163_;
			const gchar* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
			const gchar* _tmp167_;
			const gchar* _tmp168_;
			DiscoveredCamera* camera = NULL;
			Camera* _tmp169_;
			const gchar* _tmp170_;
			const gchar* _tmp171_;
			GIcon* _tmp172_;
			DiscoveredCamera* _tmp173_;
			GeeHashMap* _tmp174_;
			const gchar* _tmp175_;
			DiscoveredCamera* _tmp176_;
			DiscoveredCamera* _tmp177_;
			_tmp90_ = _port_it;
			if (!gee_iterator_next (_tmp90_)) {
				break;
			}
			_tmp91_ = _port_it;
			_tmp92_ = gee_iterator_get (_tmp91_);
			port = (gchar*) _tmp92_;
			_tmp93_ = detected_map;
			_tmp94_ = port;
			_tmp95_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp93_, _tmp94_);
			name = (gchar*) _tmp95_;
			display_name = NULL;
			icon = NULL;
			_tmp96_ = port;
			_tmp97_ = camera_table_get_port_uri (_tmp96_);
			uri = _tmp97_;
			_tmp98_ = self->priv->camera_map;
			_tmp99_ = uri;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp98_, _tmp99_)) {
				const gchar* _tmp100_;
				const gchar* _tmp101_;
				_tmp100_ = name;
				_tmp101_ = port;
				g_debug ("CameraTable.vala:336: %s @ %s already registered, skipping", _tmp100_, _tmp101_);
				_g_free0 (uri);
				_g_object_unref0 (icon);
				_g_free0 (display_name);
				_g_free0 (name);
				_g_free0 (port);
				continue;
			}
			_tmp102_ = port;
			_tmp103_ = camera_table_get_port_path (_tmp102_);
			path = _tmp103_;
			_tmp104_ = path;
			if (NULL != _tmp104_) {
				GUdevDevice* device = NULL;
				GUdevClient* _tmp105_;
				const gchar* _tmp106_;
				GUdevDevice* _tmp107_;
				gchar* serial = NULL;
				GUdevDevice* _tmp108_;
				const gchar* _tmp109_;
				gchar* _tmp110_;
				const gchar* _tmp111_;
				const gchar* _tmp116_;
				const gchar* _tmp120_;
				_tmp105_ = self->priv->client;
				_tmp106_ = path;
				_tmp107_ = g_udev_client_query_by_device_file (_tmp105_, _tmp106_);
				device = _tmp107_;
				_tmp108_ = device;
				_tmp109_ = g_udev_device_get_property (_tmp108_, "ID_SERIAL_SHORT");
				_tmp110_ = g_strdup (_tmp109_);
				serial = _tmp110_;
				_tmp111_ = serial;
				if (NULL != _tmp111_) {
					const gchar* _tmp112_;
					gchar* _tmp113_;
					const gchar* _tmp114_;
					GIcon* _tmp115_;
					_tmp112_ = serial;
					_tmp113_ = camera_table_get_name_for_uuid (self, _tmp112_);
					_g_free0 (display_name);
					display_name = _tmp113_;
					_tmp114_ = serial;
					_tmp115_ = camera_table_get_icon_for_uuid (self, _tmp114_);
					_g_object_unref0 (icon);
					icon = _tmp115_;
				}
				_tmp116_ = display_name;
				if (NULL == _tmp116_) {
					GUdevDevice* _tmp117_;
					const gchar* _tmp118_;
					gchar* _tmp119_;
					_tmp117_ = device;
					_tmp118_ = g_udev_device_get_sysfs_attr (_tmp117_, "product");
					_tmp119_ = g_strdup (_tmp118_);
					_g_free0 (display_name);
					display_name = _tmp119_;
				}
				_tmp120_ = display_name;
				if (NULL == _tmp120_) {
					GUdevDevice* _tmp121_;
					const gchar* _tmp122_;
					gchar* _tmp123_;
					_tmp121_ = device;
					_tmp122_ = g_udev_device_get_property (_tmp121_, "ID_MODEL");
					_tmp123_ = g_strdup (_tmp122_);
					_g_free0 (display_name);
					display_name = _tmp123_;
				}
				_g_free0 (serial);
				_g_object_unref0 (device);
			}
			_tmp124_ = display_name;
			if (NULL == _tmp124_) {
				const gchar* _tmp125_;
				gchar* _tmp126_;
				_tmp125_ = name;
				_tmp126_ = g_strdup (_tmp125_);
				_g_free0 (display_name);
				display_name = _tmp126_;
			}
			_tmp127_ = port_info_list;
			_tmp128_ = port;
			index = gp_port_info_list_lookup_path (_tmp127_, _tmp128_);
			if (index < 0) {
				const gchar* _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				_tmp129_ = port;
				_tmp130_ = g_strdup_printf ("lookup port %s", _tmp129_);
				_tmp131_ = _tmp130_;
				camera_table_do_op (self, (int) index, _tmp131_, &_inner_error0_);
				_g_free0 (_tmp131_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (path);
						_g_free0 (uri);
						_g_object_unref0 (icon);
						_g_free0 (display_name);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (path);
						_g_free0 (uri);
						_g_object_unref0 (icon);
						_g_free0 (display_name);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_tmp132_ = port_info_list;
			_tmp134_ = gp_port_info_list_get_info (_tmp132_, index, &_tmp133_);
			 (port_info);
			port_info = _tmp133_;
			_tmp135_ = port;
			_tmp136_ = g_strdup_printf ("get port info for %s", _tmp135_);
			_tmp137_ = _tmp136_;
			camera_table_do_op (self, _tmp134_, _tmp137_, &_inner_error0_);
			_g_free0 (_tmp137_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			gp_port_info_get_path (port_info, &_tmp138_);
			_g_free0 (tmp_path);
			_tmp139_ = g_strdup (_tmp138_);
			tmp_path = _tmp139_;
			_tmp140_ = port;
			_tmp141_ = tmp_path;
			_vala_assert (g_strcmp0 (_tmp140_, _tmp141_) == 0, "port == tmp_path");
			_tmp142_ = self->priv->abilities_list;
			_tmp143_ = name;
			index = gp_abilities_list_lookup_model (_tmp142_, _tmp143_);
			if (index < 0) {
				const gchar* _tmp144_;
				gchar* _tmp145_;
				gchar* _tmp146_;
				_tmp144_ = name;
				_tmp145_ = g_strdup_printf ("lookup camera model %s", _tmp144_);
				_tmp146_ = _tmp145_;
				camera_table_do_op (self, (int) index, _tmp146_, &_inner_error0_);
				_g_free0 (_tmp146_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GPHOTO_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (tmp_path);
						 (port_info);
						_g_free0 (path);
						_g_free0 (uri);
						_g_object_unref0 (icon);
						_g_free0 (display_name);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						return;
					} else {
						_g_free0 (tmp_path);
						 (port_info);
						_g_free0 (path);
						_g_free0 (uri);
						_g_object_unref0 (icon);
						_g_free0 (display_name);
						_g_free0 (name);
						_g_free0 (port);
						_g_object_unref0 (_port_it);
						missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
						usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (detected_map);
						_gp_list_unref0 (camera_list);
						_gp_port_info_list_free0 (port_info_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_tmp147_ = self->priv->abilities_list;
			_tmp149_ = gp_abilities_list_get_abilities (_tmp147_, index, &_tmp148_);
			 (camera_abilities);
			camera_abilities = _tmp148_;
			_tmp150_ = name;
			_tmp151_ = g_strdup_printf ("lookup camera abilities for %s", _tmp150_);
			_tmp152_ = _tmp151_;
			camera_table_do_op (self, _tmp149_, _tmp152_, &_inner_error0_);
			_g_free0 (_tmp152_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp154_ = gp_camera_new (&_tmp153_);
			_gp_camera_unref0 (gcamera);
			gcamera = _tmp153_;
			_tmp155_ = name;
			_tmp156_ = g_strdup_printf ("create camera object for %s", _tmp155_);
			_tmp157_ = _tmp156_;
			camera_table_do_op (self, _tmp154_, _tmp157_, &_inner_error0_);
			_g_free0 (_tmp157_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp158_ = gcamera;
			_tmp159_ = name;
			_tmp160_ = g_strdup_printf ("set camera abilities for %s", _tmp159_);
			_tmp161_ = _tmp160_;
			camera_table_do_op (self, gp_camera_set_abilities (_tmp158_, camera_abilities), _tmp161_, &_inner_error0_);
			_g_free0 (_tmp161_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp162_ = gcamera;
			_tmp163_ = name;
			_tmp164_ = port;
			_tmp165_ = g_strdup_printf ("set port info for %s on %s", _tmp163_, _tmp164_);
			_tmp166_ = _tmp165_;
			camera_table_do_op (self, gp_camera_set_port_info (_tmp162_, port_info), _tmp166_, &_inner_error0_);
			_g_free0 (_tmp166_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GPHOTO_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					return;
				} else {
					_gp_camera_unref0 (gcamera);
					 (camera_abilities);
					_g_free0 (tmp_path);
					 (port_info);
					_g_free0 (path);
					_g_free0 (uri);
					_g_object_unref0 (icon);
					_g_free0 (display_name);
					_g_free0 (name);
					_g_free0 (port);
					_g_object_unref0 (_port_it);
					missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
					usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (detected_map);
					_gp_list_unref0 (camera_list);
					_gp_port_info_list_free0 (port_info_list);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp167_ = name;
			_tmp168_ = port;
			g_debug ("CameraTable.vala:389: Adding to camera table: %s @ %s", _tmp167_, _tmp168_);
			_tmp169_ = gcamera;
			_tmp170_ = uri;
			_tmp171_ = display_name;
			_tmp172_ = icon;
			_tmp173_ = discovered_camera_new (_tmp169_, _tmp170_, _tmp171_, _tmp172_);
			camera = _tmp173_;
			_tmp174_ = self->priv->camera_map;
			_tmp175_ = uri;
			_tmp176_ = camera;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp174_, _tmp175_, _tmp176_);
			_tmp177_ = camera;
			g_signal_emit (self, camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL], 0, _tmp177_);
			_discovered_camera_unref0 (camera);
			_gp_camera_unref0 (gcamera);
			 (camera_abilities);
			_g_free0 (tmp_path);
			 (port_info);
			_g_free0 (path);
			_g_free0 (uri);
			_g_object_unref0 (icon);
			_g_free0 (display_name);
			_g_free0 (name);
			_g_free0 (port);
		}
		_g_object_unref0 (_port_it);
	}
	missing = (_vala_array_free (missing, missing_length1, (GDestroyNotify) discovered_camera_unref), NULL);
	usb_cameras = (_vala_array_free (usb_cameras, usb_cameras_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (detected_map);
	_gp_list_unref0 (camera_list);
	_gp_port_info_list_free0 (port_info_list);
}

static void
camera_table_on_udev_event (CameraTable* self,
                            const gchar* action,
                            GUdevDevice* device)
{
	const gchar* _tmp0_;
	OneShotScheduler* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = g_udev_device_get_name (device);
	g_debug ("CameraTable.vala:399: udev event: %s on %s", action, _tmp0_);
	_tmp1_ = self->priv->camera_update_scheduler;
	one_shot_scheduler_after_timeout (_tmp1_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
}

void
camera_table_on_volume_changed (CameraTable* self,
                                GVolume* volume)
{
	OneShotScheduler* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->camera_update_scheduler;
	one_shot_scheduler_after_timeout (_tmp0_, (guint) CAMERA_TABLE_UPDATE_DELAY_MSEC, TRUE);
}

static void
camera_table_on_update_cameras (CameraTable* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		CameraTable* _tmp0_;
		CameraTable* _tmp1_;
		_tmp0_ = camera_table_get_instance ();
		_tmp1_ = _tmp0_;
		camera_table_update_camera_table (_tmp1_, &_inner_error0_);
		_camera_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GPHOTO_ERROR) {
				goto __catch0_gphoto_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_gphoto_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("CameraTable.vala:414: Error updating camera table: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DISCOVERED_CAMERA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__DISCOVERED_CAMERA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DISCOVERED_CAMERA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_discovered_camera (param_values + 1), data2);
}

static void
value_camera_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_camera_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		camera_table_unref (value->data[0].v_pointer);
	}
}

static void
value_camera_table_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = camera_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_camera_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_camera_table_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CameraTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = camera_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_camera_table_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	CameraTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = camera_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_camera_table (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecCameraTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CAMERA_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_camera_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_camera_table (GValue* value,
                        gpointer v_object)
{
	CameraTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		camera_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		camera_table_unref (old);
	}
}

void
value_take_camera_table (GValue* value,
                         gpointer v_object)
{
	CameraTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CAMERA_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CAMERA_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		camera_table_unref (old);
	}
}

static void
camera_table_class_init (CameraTableClass * klass,
                         gpointer klass_data)
{
	camera_table_parent_class = g_type_class_peek_parent (klass);
	((CameraTableClass *) klass)->finalize = camera_table_finalize;
	g_type_class_adjust_private_offset (klass, &CameraTable_private_offset);
	camera_table_signals[CAMERA_TABLE_CAMERA_ADDED_SIGNAL] = g_signal_new ("camera-added", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
	camera_table_signals[CAMERA_TABLE_CAMERA_REMOVED_SIGNAL] = g_signal_new ("camera-removed", TYPE_CAMERA_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DISCOVERED_CAMERA, G_TYPE_NONE, 1, TYPE_DISCOVERED_CAMERA);
}

static void
camera_table_instance_init (CameraTable * self,
                            gpointer klass)
{
	GUdevClient* _tmp0_;
	GPContext* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = camera_table_get_instance_private (self);
	_tmp0_ = g_udev_client_new (CAMERA_TABLE_SUBSYSTEMS);
	self->priv->client = _tmp0_;
	self->priv->camera_update_scheduler = NULL;
	_tmp1_ = gp_context_new ();
	self->priv->null_context = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_DISCOVERED_CAMERA, (GBoxedCopyFunc) discovered_camera_ref, (GDestroyNotify) discovered_camera_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->camera_map = _tmp2_;
	self->ref_count = 1;
}

static void
camera_table_finalize (CameraTable * obj)
{
	CameraTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CAMERA_TABLE, CameraTable);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->client);
	_one_shot_scheduler_unref0 (self->priv->camera_update_scheduler);
	_gp_context_unref0 (self->priv->null_context);
	_gp_abilities_list_free0 (self->priv->abilities_list);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->camera_map);
}

static GType
camera_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_camera_table_init, value_camera_table_free_value, value_camera_table_copy_value, value_camera_table_peek_pointer, "p", value_camera_table_collect_value, "p", value_camera_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CameraTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraTable), 0, (GInstanceInitFunc) camera_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType camera_table_type_id;
	camera_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CameraTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CameraTable_private_offset = g_type_add_instance_private (camera_table_type_id, sizeof (CameraTablePrivate));
	return camera_table_type_id;
}

GType
camera_table_get_type (void)
{
	static volatile gsize camera_table_type_id__once = 0;
	if (g_once_init_enter (&camera_table_type_id__once)) {
		GType camera_table_type_id;
		camera_table_type_id = camera_table_get_type_once ();
		g_once_init_leave (&camera_table_type_id__once, camera_table_type_id);
	}
	return camera_table_type_id__once;
}

gpointer
camera_table_ref (gpointer instance)
{
	CameraTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
camera_table_unref (gpointer instance)
{
	CameraTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CAMERA_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

