/* CustomPrintTab.c generated by valac 0.56.18, the Vala compiler
 * generated from CustomPrintTab.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include "locale.h"
#include <glib/gi18n-lib.h>
#include <granite.h>

#define CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE 0
#define CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CUSTOM_PRINT_TAB_0_PROPERTY,
	CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY,
	CUSTOM_PRINT_TAB_NUM_PROPERTIES
};
static GParamSpec* custom_print_tab_properties[CUSTOM_PRINT_TAB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
#define _standard_print_size_unref0(var) ((var == NULL) ? NULL : (var = (standard_print_size_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CustomPrintTabPrivate {
	GtkRadioButton* standard_size_radio;
	GtkRadioButton* custom_size_radio;
	GtkRadioButton* image_per_page_radio;
	GtkComboBox* image_per_page_combo;
	GtkComboBox* standard_sizes_combo;
	GtkComboBoxText* units_combo;
	GtkEntry* custom_width_entry;
	GtkEntry* custom_height_entry;
	GtkCheckButton* aspect_ratio_check;
	GtkCheckButton* title_print_check;
	GtkFontButton* title_print_font;
	GtkSpinButton* ppi_entry;
	Measurement local_content_width;
	Measurement local_content_height;
	gboolean is_text_insertion_in_progress;
	PrintJob* _source_job;
};

static gint CustomPrintTab_private_offset;
static gpointer custom_print_tab_parent_class = NULL;

static void custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self);
static gchar* custom_print_tab_format_measurement (CustomPrintTab* self,
                                            Measurement* measurement);
static gboolean custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                                    GdkEventFocus* event);
static gchar* custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                               Measurement* measurement,
                                               MeasurementUnit to_unit);
static MeasurementUnit custom_print_tab_get_user_unit_choice (CustomPrintTab* self);
static void custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                             Measurement* result);
static gboolean custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self);
static void custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                                GtkEditable* editable,
                                                const gchar* text,
                                                gint length,
                                                gint* position);
static gboolean custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                                     GdkEventFocus* event);
static void custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                              Measurement* result);
static void custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                            MeasurementUnit unit);
static void custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                            GtkEditable* editable,
                                            const gchar* text,
                                            gint length,
                                            gint* position);
static void custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                           PrintJob* job);
static void custom_print_tab_set_content_width (CustomPrintTab* self,
                                         Measurement* content_width);
static void custom_print_tab_set_content_height (CustomPrintTab* self,
                                          Measurement* content_height);
static void custom_print_tab_set_content_layout (CustomPrintTab* self,
                                          ContentLayout content_layout);
static void custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                                    gint image_per_page);
static void custom_print_tab_set_size_selection (CustomPrintTab* self,
                                          gint size_selection);
static void custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                      gboolean enable_state);
static void custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                                gboolean print_titles);
static void custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                             const gchar* fontname);
static void custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                            GtkButton* b);
static void custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                        ContentLayout layout);
static void custom_print_tab_on_units_combo_changed (CustomPrintTab* self);
static gboolean custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                               GtkTreeIter* iter);
static ContentLayout custom_print_tab_get_content_layout (CustomPrintTab* self);
static void custom_print_tab_get_content_width (CustomPrintTab* self,
                                         Measurement* result);
static void custom_print_tab_get_content_height (CustomPrintTab* self,
                                          Measurement* result);
static gint custom_print_tab_get_image_per_page_selection (CustomPrintTab* self);
static gint custom_print_tab_get_size_selection (CustomPrintTab* self);
static gboolean custom_print_tab_is_print_titles_enabled (CustomPrintTab* self);
static gchar* custom_print_tab_get_print_titles_font (CustomPrintTab* self);
static GObject * custom_print_tab_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN GType print_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PrintLayout* print_layout_get_all (gint* result_length1);
VALA_EXTERN gchar* print_layout_to_string (PrintLayout self);
static gboolean _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                                 GtkTreeIter* iter,
                                                                                                 gpointer self);
static void _custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                      const gchar* new_text,
                                                                      gint new_text_length,
                                                                      gint* position,
                                                                      gpointer self);
static gboolean _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                GdkEventFocus* event,
                                                                                gpointer self);
static gboolean _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                 GdkEventFocus* event,
                                                                                 gpointer self);
static void _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                          const gchar* new_text,
                                                                          gint new_text_length,
                                                                          gint* position,
                                                                          gpointer self);
static void _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void custom_print_tab_finalize (GObject * obj);
static GType custom_print_tab_get_type_once (void);
static void _vala_custom_print_tab_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_custom_print_tab_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
custom_print_tab_get_instance_private (CustomPrintTab* self)
{
	return G_STRUCT_MEMBER_P (self, CustomPrintTab_private_offset);
}

CustomPrintTab*
custom_print_tab_construct (GType object_type,
                            PrintJob* source_job)
{
	CustomPrintTab * self = NULL;
	g_return_val_if_fail (source_job != NULL, NULL);
	self = (CustomPrintTab*) g_object_new (object_type, "source-job", source_job, NULL);
	return self;
}

CustomPrintTab*
custom_print_tab_new (PrintJob* source_job)
{
	return custom_print_tab_construct (TYPE_CUSTOM_PRINT_TAB, source_job);
}

static void
custom_print_tab_on_aspect_ratio_check_clicked (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->aspect_ratio_check;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		Measurement _tmp1_;
		PrintJob* _tmp2_;
		Measurement _tmp3_;
		GtkEntry* _tmp4_;
		Measurement _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = self->priv->local_content_height;
		_tmp2_ = self->priv->_source_job;
		_tmp3_ = self->priv->local_content_height;
		measurement_init (&self->priv->local_content_width, _tmp1_.value * print_job_get_source_aspect_ratio (_tmp2_), _tmp3_.unit);
		_tmp4_ = self->priv->custom_width_entry;
		_tmp5_ = self->priv->local_content_width;
		_tmp6_ = custom_print_tab_format_measurement (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_entry_set_text (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
}

static gboolean
custom_print_tab_on_width_entry_focus_out (CustomPrintTab* self,
                                           GdkEventFocus* event)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_width = {0};
	Measurement _tmp6_ = {0};
	Measurement min_width = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_width = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp32_;
	GtkEntry* _tmp33_;
	Measurement _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->custom_width_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = self->priv->local_content_width;
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	custom_print_tab_get_width_entry_value (self, &_tmp6_);
	new_width = _tmp6_;
	_tmp7_ = self->priv->_source_job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_print_settings_unref0 (_tmp9_);
	min_width = _tmp11_;
	_tmp12_ = self->priv->_source_job;
	_tmp13_ = print_job_get_local_settings (_tmp12_);
	_tmp14_ = _tmp13_;
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_print_settings_unref0 (_tmp14_);
	max_width = _tmp16_;
	_tmp18_ = min_width;
	if (measurement_is_less_than (&new_width, &_tmp18_)) {
		_tmp17_ = TRUE;
	} else {
		Measurement _tmp19_;
		_tmp19_ = max_width;
		_tmp17_ = measurement_is_greater_than (&new_width, &_tmp19_);
	}
	if (_tmp17_) {
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->priv->custom_width_entry;
		_tmp21_ = self->priv->local_content_width;
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_entry_set_text (_tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		result = FALSE;
		return result;
	}
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
		Measurement new_height = {0};
		Measurement _tmp24_;
		PrintJob* _tmp25_;
		Measurement _tmp26_;
		Measurement _tmp27_;
		GtkEntry* _tmp28_;
		Measurement _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = new_width;
		_tmp25_ = self->priv->_source_job;
		_tmp26_ = new_width;
		measurement_init (&new_height, _tmp24_.value / print_job_get_source_aspect_ratio (_tmp25_), _tmp26_.unit);
		_tmp27_ = new_height;
		self->priv->local_content_height = _tmp27_;
		_tmp28_ = self->priv->custom_height_entry;
		_tmp29_ = new_height;
		_tmp30_ = custom_print_tab_format_measurement (self, &_tmp29_);
		_tmp31_ = _tmp30_;
		gtk_entry_set_text (_tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = new_width;
	self->priv->local_content_width = _tmp32_;
	_tmp33_ = self->priv->custom_width_entry;
	_tmp34_ = new_width;
	_tmp35_ = custom_print_tab_format_measurement (self, &_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_entry_set_text (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	result = FALSE;
	return result;
}

static gchar*
custom_print_tab_format_measurement (CustomPrintTab* self,
                                     Measurement* measurement)
{
	Measurement _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (measurement != NULL, NULL);
	_tmp0_ = *measurement;
	_tmp1_ = g_strdup_printf ("%.2f", _tmp0_.value);
	result = _tmp1_;
	return result;
}

static gchar*
custom_print_tab_format_measurement_as (CustomPrintTab* self,
                                        Measurement* measurement,
                                        MeasurementUnit to_unit)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_measurement = {0};
	Measurement _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (measurement != NULL, NULL);
	_tmp1_ = *measurement;
	if (_tmp1_.unit == to_unit) {
		Measurement _tmp2_;
		_tmp2_ = *measurement;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (measurement, to_unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_measurement = _tmp0_;
	_tmp4_ = converted_measurement;
	_tmp5_ = custom_print_tab_format_measurement (self, &_tmp4_);
	result = _tmp5_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
custom_print_tab_on_ppi_entry_insert_text (CustomPrintTab* self,
                                           GtkEditable* editable,
                                           const gchar* text,
                                           gint length,
                                           gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	gchar* new_text = NULL;
	gchar* _tmp3_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GtkEntry* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
	sender = _tmp0_;
	if (self->priv->is_text_insertion_in_progress) {
		_g_object_unref0 (sender);
		return;
	}
	self->priv->is_text_insertion_in_progress = TRUE;
	if (length == -1) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (text);
		_tmp2_ = _tmp1_;
		length = (gint) _tmp2_;
	}
	_tmp3_ = g_strdup ("");
	new_text = _tmp3_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = ctr;
					ctr = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp6_ = new_text;
					_tmp7_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
					_g_free0 (new_text);
					new_text = _tmp9_;
					_g_free0 (_tmp8_);
				}
			}
		}
	}
	_tmp10_ = new_text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ > 0) {
		GtkEntry* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp13_ = sender;
		_tmp14_ = new_text;
		_tmp15_ = new_text;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name ((GtkEditable*) _tmp13_, "insert-text", _tmp14_, (gint) _tmp17_, position);
	}
	_tmp18_ = sender;
	g_signal_stop_emission_by_name (_tmp18_, "insert-text");
	self->priv->is_text_insertion_in_progress = FALSE;
	_g_free0 (new_text);
	_g_object_unref0 (sender);
}

static gboolean
custom_print_tab_on_height_entry_focus_out (CustomPrintTab* self,
                                            GdkEventFocus* event)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	Measurement new_height = {0};
	Measurement _tmp6_ = {0};
	Measurement min_height = {0};
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_;
	Measurement max_height = {0};
	PrintJob* _tmp12_;
	PrintSettings* _tmp13_;
	PrintSettings* _tmp14_;
	Measurement _tmp15_ = {0};
	Measurement _tmp16_;
	gboolean _tmp17_ = FALSE;
	Measurement _tmp18_;
	Measurement _tmp32_;
	GtkEntry* _tmp33_;
	Measurement _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = self->priv->local_content_height;
	_tmp3_ = custom_print_tab_format_measurement_as (self, &_tmp2_, custom_print_tab_get_user_unit_choice (self));
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp1_, _tmp4_) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	custom_print_tab_get_height_entry_value (self, &_tmp6_);
	new_height = _tmp6_;
	_tmp7_ = self->priv->_source_job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	print_settings_get_minimum_content_dimension (_tmp9_, &_tmp10_);
	_tmp11_ = _tmp10_;
	_print_settings_unref0 (_tmp9_);
	min_height = _tmp11_;
	_tmp12_ = self->priv->_source_job;
	_tmp13_ = print_job_get_local_settings (_tmp12_);
	_tmp14_ = _tmp13_;
	print_settings_get_maximum_content_dimension (_tmp14_, &_tmp15_);
	_tmp16_ = _tmp15_;
	_print_settings_unref0 (_tmp14_);
	max_height = _tmp16_;
	_tmp18_ = min_height;
	if (measurement_is_less_than (&new_height, &_tmp18_)) {
		_tmp17_ = TRUE;
	} else {
		Measurement _tmp19_;
		_tmp19_ = max_height;
		_tmp17_ = measurement_is_greater_than (&new_height, &_tmp19_);
	}
	if (_tmp17_) {
		GtkEntry* _tmp20_;
		Measurement _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = self->priv->custom_height_entry;
		_tmp21_ = self->priv->local_content_height;
		_tmp22_ = custom_print_tab_format_measurement (self, &_tmp21_);
		_tmp23_ = _tmp22_;
		gtk_entry_set_text (_tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		result = FALSE;
		return result;
	}
	if (custom_print_tab_is_match_aspect_ratio_enabled (self)) {
		Measurement new_width = {0};
		Measurement _tmp24_;
		PrintJob* _tmp25_;
		Measurement _tmp26_;
		Measurement _tmp27_;
		GtkEntry* _tmp28_;
		Measurement _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp24_ = new_height;
		_tmp25_ = self->priv->_source_job;
		_tmp26_ = new_height;
		measurement_init (&new_width, _tmp24_.value * print_job_get_source_aspect_ratio (_tmp25_), _tmp26_.unit);
		_tmp27_ = new_width;
		self->priv->local_content_width = _tmp27_;
		_tmp28_ = self->priv->custom_width_entry;
		_tmp29_ = new_width;
		_tmp30_ = custom_print_tab_format_measurement (self, &_tmp29_);
		_tmp31_ = _tmp30_;
		gtk_entry_set_text (_tmp28_, _tmp31_);
		_g_free0 (_tmp31_);
	}
	_tmp32_ = new_height;
	self->priv->local_content_height = _tmp32_;
	_tmp33_ = self->priv->custom_height_entry;
	_tmp34_ = new_height;
	_tmp35_ = custom_print_tab_format_measurement (self, &_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_entry_set_text (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	result = FALSE;
	return result;
}

static MeasurementUnit
custom_print_tab_get_user_unit_choice (CustomPrintTab* self)
{
	GtkComboBoxText* _tmp0_;
	MeasurementUnit result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->units_combo;
	if (gtk_combo_box_get_active ((GtkComboBox*) _tmp0_) == CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE) {
		result = MEASUREMENT_UNIT_INCHES;
		return result;
	} else {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = self->priv->units_combo;
		if (gtk_combo_box_get_active ((GtkComboBox*) _tmp1_) == CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE) {
			result = MEASUREMENT_UNIT_CENTIMETERS;
			return result;
		} else {
			g_error ("CustomPrintTab.vala:279: unknown unit combo box choice");
		}
	}
}

static void
custom_print_tab_set_user_unit_choice (CustomPrintTab* self,
                                       MeasurementUnit unit)
{
	g_return_if_fail (self != NULL);
	if (unit == MEASUREMENT_UNIT_INCHES) {
		GtkComboBoxText* _tmp0_;
		_tmp0_ = self->priv->units_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, CUSTOM_PRINT_TAB_INCHES_COMBO_CHOICE);
	} else {
		if (unit == MEASUREMENT_UNIT_CENTIMETERS) {
			GtkComboBoxText* _tmp1_;
			_tmp1_ = self->priv->units_combo;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, CUSTOM_PRINT_TAB_CENTIMETERS_COMBO_CHOICE);
		} else {
			g_error ("CustomPrintTab.vala:289: unknown MeasurementUnit enumeration");
		}
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
custom_print_tab_get_width_entry_value (CustomPrintTab* self,
                                        Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_width_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
	*result = _tmp2_;
	return;
}

static void
custom_print_tab_get_height_entry_value (CustomPrintTab* self,
                                         Measurement* result)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	Measurement _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	measurement_init (&_tmp2_, double_parse (_tmp1_), custom_print_tab_get_user_unit_choice (self));
	*result = _tmp2_;
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
custom_print_tab_on_entry_insert_text (CustomPrintTab* self,
                                       GtkEditable* editable,
                                       const gchar* text,
                                       gint length,
                                       gint* position)
{
	GtkEntry* sender = NULL;
	GtkEntry* _tmp0_;
	gchar* decimal_point = NULL;
	struct lconv* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean contains_decimal_point = FALSE;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* new_text = NULL;
	gchar* _tmp9_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GtkEntry* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (editable, gtk_entry_get_type (), GtkEntry));
	sender = _tmp0_;
	if (self->priv->is_text_insertion_in_progress) {
		_g_object_unref0 (sender);
		return;
	}
	self->priv->is_text_insertion_in_progress = TRUE;
	if (length == -1) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (text);
		_tmp2_ = _tmp1_;
		length = (gint) _tmp2_;
	}
	_tmp3_ = localeconv ();
	_tmp4_ = _tmp3_->decimal_point;
	_tmp5_ = g_strdup (_tmp4_);
	decimal_point = _tmp5_;
	_tmp6_ = sender;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp8_ = decimal_point;
	contains_decimal_point = string_contains (_tmp7_, _tmp8_);
	_tmp9_ = g_strdup ("");
	new_text = _tmp9_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = ctr;
					ctr = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp12_ = new_text;
					_tmp13_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
					_g_free0 (new_text);
					new_text = _tmp15_;
					_g_free0 (_tmp14_);
				} else {
					gboolean _tmp16_ = FALSE;
					if (!contains_decimal_point) {
						const gchar* _tmp17_;
						_tmp17_ = decimal_point;
						_tmp16_ = string_get (text, (glong) ctr) == string_get (_tmp17_, (glong) 0);
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						const gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp18_ = new_text;
						_tmp19_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
						_tmp20_ = _tmp19_;
						_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
						_g_free0 (new_text);
						new_text = _tmp21_;
						_g_free0 (_tmp20_);
					}
				}
			}
		}
	}
	_tmp22_ = new_text;
	_tmp23_ = strlen (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		GtkEntry* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp25_ = sender;
		_tmp26_ = new_text;
		_tmp27_ = new_text;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		g_signal_emit_by_name ((GtkEditable*) _tmp25_, "insert-text", _tmp26_, (gint) _tmp29_, position);
	}
	_tmp30_ = sender;
	g_signal_stop_emission_by_name (_tmp30_, "insert-text");
	self->priv->is_text_insertion_in_progress = FALSE;
	_g_free0 (new_text);
	_g_free0 (decimal_point);
	_g_object_unref0 (sender);
}

static void
custom_print_tab_sync_state_from_job (CustomPrintTab* self,
                                      PrintJob* job)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	Measurement _tmp2_ = {0};
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	Measurement _tmp5_ = {0};
	Measurement constrained_width = {0};
	PrintSettings* _tmp6_;
	PrintSettings* _tmp7_;
	Measurement _tmp8_ = {0};
	Measurement _tmp9_;
	PrintSettings* _tmp10_;
	PrintSettings* _tmp11_;
	gboolean _tmp12_;
	Measurement _tmp19_;
	PrintSettings* _tmp20_;
	PrintSettings* _tmp21_;
	Measurement _tmp22_ = {0};
	PrintSettings* _tmp23_;
	PrintSettings* _tmp24_;
	GtkSpinButton* _tmp25_;
	PrintSettings* _tmp26_;
	PrintSettings* _tmp27_;
	PrintSettings* _tmp28_;
	PrintSettings* _tmp29_;
	PrintSettings* _tmp30_;
	PrintSettings* _tmp31_;
	PrintSettings* _tmp32_;
	PrintSettings* _tmp33_;
	PrintSettings* _tmp34_;
	PrintSettings* _tmp35_;
	PrintSettings* _tmp36_;
	PrintSettings* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	_tmp0_ = print_job_get_local_settings (job);
	_tmp1_ = _tmp0_;
	print_settings_get_content_width (_tmp1_, &_tmp2_);
	_tmp3_ = print_job_get_local_settings (job);
	_tmp4_ = _tmp3_;
	print_settings_get_content_height (_tmp4_, &_tmp5_);
	_vala_assert (_tmp2_.unit == _tmp5_.unit, "job.get_local_settings ().get_content_width ().unit ==                 job.get_local_settings ().get_content_height ().unit");
	_print_settings_unref0 (_tmp4_);
	_print_settings_unref0 (_tmp1_);
	_tmp6_ = print_job_get_local_settings (job);
	_tmp7_ = _tmp6_;
	print_settings_get_content_width (_tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	_print_settings_unref0 (_tmp7_);
	constrained_width = _tmp9_;
	_tmp10_ = print_job_get_local_settings (job);
	_tmp11_ = _tmp10_;
	_tmp12_ = print_settings_is_match_aspect_ratio_enabled (_tmp11_);
	_print_settings_unref0 (_tmp11_);
	if (_tmp12_) {
		PrintSettings* _tmp13_;
		PrintSettings* _tmp14_;
		Measurement _tmp15_ = {0};
		PrintSettings* _tmp16_;
		PrintSettings* _tmp17_;
		Measurement _tmp18_ = {0};
		_tmp13_ = print_job_get_local_settings (job);
		_tmp14_ = _tmp13_;
		print_settings_get_content_height (_tmp14_, &_tmp15_);
		_tmp16_ = print_job_get_local_settings (job);
		_tmp17_ = _tmp16_;
		print_settings_get_content_height (_tmp17_, &_tmp18_);
		measurement_init (&constrained_width, _tmp15_.value * print_job_get_source_aspect_ratio (job), _tmp18_.unit);
		_print_settings_unref0 (_tmp17_);
		_print_settings_unref0 (_tmp14_);
	}
	_tmp19_ = constrained_width;
	custom_print_tab_set_content_width (self, &_tmp19_);
	_tmp20_ = print_job_get_local_settings (job);
	_tmp21_ = _tmp20_;
	print_settings_get_content_height (_tmp21_, &_tmp22_);
	custom_print_tab_set_content_height (self, &_tmp22_);
	_print_settings_unref0 (_tmp21_);
	_tmp23_ = print_job_get_local_settings (job);
	_tmp24_ = _tmp23_;
	custom_print_tab_set_content_layout (self, print_settings_get_content_layout (_tmp24_));
	_print_settings_unref0 (_tmp24_);
	_tmp25_ = self->priv->ppi_entry;
	_tmp26_ = print_job_get_local_settings (job);
	_tmp27_ = _tmp26_;
	gtk_spin_button_set_value (_tmp25_, (gdouble) print_settings_get_content_ppi (_tmp27_));
	_print_settings_unref0 (_tmp27_);
	_tmp28_ = print_job_get_local_settings (job);
	_tmp29_ = _tmp28_;
	custom_print_tab_set_image_per_page_selection (self, print_settings_get_image_per_page_selection (_tmp29_));
	_print_settings_unref0 (_tmp29_);
	_tmp30_ = print_job_get_local_settings (job);
	_tmp31_ = _tmp30_;
	custom_print_tab_set_size_selection (self, print_settings_get_size_selection (_tmp31_));
	_print_settings_unref0 (_tmp31_);
	_tmp32_ = print_job_get_local_settings (job);
	_tmp33_ = _tmp32_;
	custom_print_tab_set_match_aspect_ratio_enabled (self, print_settings_is_match_aspect_ratio_enabled (_tmp33_));
	_print_settings_unref0 (_tmp33_);
	_tmp34_ = print_job_get_local_settings (job);
	_tmp35_ = _tmp34_;
	custom_print_tab_set_print_titles_enabled (self, print_settings_is_print_titles_enabled (_tmp35_));
	_print_settings_unref0 (_tmp35_);
	_tmp36_ = print_job_get_local_settings (job);
	_tmp37_ = _tmp36_;
	_tmp38_ = print_settings_get_print_titles_font (_tmp37_);
	_tmp39_ = _tmp38_;
	custom_print_tab_set_print_titles_font (self, _tmp39_);
	_g_free0 (_tmp39_);
	_print_settings_unref0 (_tmp37_);
}

static void
custom_print_tab_on_radio_group_click (CustomPrintTab* self,
                                       GtkButton* b)
{
	GtkRadioButton* sender = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, gtk_radio_button_get_type (), GtkRadioButton));
	sender = _tmp0_;
	_tmp1_ = sender;
	_tmp2_ = self->priv->standard_size_radio;
	if (_tmp1_ == _tmp2_) {
		GtkComboBox* _tmp3_;
		custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_STANDARD_SIZE);
		_tmp3_ = self->priv->standard_sizes_combo;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	} else {
		GtkRadioButton* _tmp4_;
		GtkRadioButton* _tmp5_;
		_tmp4_ = sender;
		_tmp5_ = self->priv->custom_size_radio;
		if (_tmp4_ == _tmp5_) {
			GtkEntry* _tmp6_;
			custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_CUSTOM_SIZE);
			_tmp6_ = self->priv->custom_height_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
		} else {
			GtkRadioButton* _tmp7_;
			GtkRadioButton* _tmp8_;
			_tmp7_ = sender;
			_tmp8_ = self->priv->image_per_page_radio;
			if (_tmp7_ == _tmp8_) {
				custom_print_tab_set_content_layout_control_state (self, CONTENT_LAYOUT_IMAGE_PER_PAGE);
			}
		}
	}
	_g_object_unref0 (sender);
}

static void
custom_print_tab_on_units_combo_changed (CustomPrintTab* self)
{
	GtkEntry* _tmp0_;
	Measurement _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkEntry* _tmp4_;
	Measurement _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->custom_height_entry;
	_tmp1_ = self->priv->local_content_height;
	_tmp2_ = custom_print_tab_format_measurement_as (self, &_tmp1_, custom_print_tab_get_user_unit_choice (self));
	_tmp3_ = _tmp2_;
	gtk_entry_set_text (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->custom_width_entry;
	_tmp5_ = self->priv->local_content_width;
	_tmp6_ = custom_print_tab_format_measurement_as (self, &_tmp5_, custom_print_tab_get_user_unit_choice (self));
	_tmp7_ = _tmp6_;
	gtk_entry_set_text (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
}

static void
custom_print_tab_set_content_layout_control_state (CustomPrintTab* self,
                                                   ContentLayout layout)
{
	g_return_if_fail (self != NULL);
	switch (layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		{
			GtkComboBox* _tmp0_;
			GtkComboBoxText* _tmp1_;
			GtkEntry* _tmp2_;
			GtkEntry* _tmp3_;
			GtkCheckButton* _tmp4_;
			GtkComboBox* _tmp5_;
			_tmp0_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
			_tmp1_ = self->priv->units_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
			_tmp2_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
			_tmp3_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
			_tmp4_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
			_tmp5_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
			break;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			GtkComboBox* _tmp6_;
			GtkComboBoxText* _tmp7_;
			GtkEntry* _tmp8_;
			GtkEntry* _tmp9_;
			GtkCheckButton* _tmp10_;
			GtkComboBox* _tmp11_;
			_tmp6_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
			_tmp7_ = self->priv->units_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
			_tmp8_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
			_tmp9_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, TRUE);
			_tmp10_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
			_tmp11_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			GtkComboBox* _tmp12_;
			GtkComboBoxText* _tmp13_;
			GtkEntry* _tmp14_;
			GtkEntry* _tmp15_;
			GtkCheckButton* _tmp16_;
			GtkComboBox* _tmp17_;
			_tmp12_ = self->priv->standard_sizes_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, FALSE);
			_tmp13_ = self->priv->units_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
			_tmp14_ = self->priv->custom_width_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
			_tmp15_ = self->priv->custom_height_entry;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
			_tmp16_ = self->priv->aspect_ratio_check;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
			_tmp17_ = self->priv->image_per_page_combo;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, TRUE);
			break;
		}
		default:
		{
			g_error ("CustomPrintTab.vala:404: unknown ContentLayout enumeration value");
		}
	}
}

static gboolean
custom_print_tab_standard_sizes_combo_separator_func (GtkTreeModel* model,
                                                      GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, 0, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = g_value_dup_string (&val);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "-") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static void
custom_print_tab_set_content_layout (CustomPrintTab* self,
                                     ContentLayout content_layout)
{
	g_return_if_fail (self != NULL);
	custom_print_tab_set_content_layout_control_state (self, content_layout);
	switch (content_layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		{
			GtkRadioButton* _tmp0_;
			_tmp0_ = self->priv->standard_size_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
			break;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			GtkRadioButton* _tmp1_;
			_tmp1_ = self->priv->custom_size_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			GtkRadioButton* _tmp2_;
			_tmp2_ = self->priv->image_per_page_radio;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
			break;
		}
		default:
		{
			g_error ("CustomPrintTab.vala:432: unknown ContentLayout enumeration value");
		}
	}
}

static ContentLayout
custom_print_tab_get_content_layout (CustomPrintTab* self)
{
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	ContentLayout result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->standard_size_radio;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		result = CONTENT_LAYOUT_STANDARD_SIZE;
		return result;
	}
	_tmp1_ = self->priv->custom_size_radio;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_)) {
		result = CONTENT_LAYOUT_CUSTOM_SIZE;
		return result;
	}
	_tmp2_ = self->priv->image_per_page_radio;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_)) {
		result = CONTENT_LAYOUT_IMAGE_PER_PAGE;
		return result;
	}
	g_error ("CustomPrintTab.vala:444: inconsistent content layout radio button grou" \
"p state");
}

static void
custom_print_tab_set_content_width (CustomPrintTab* self,
                                    Measurement* content_width)
{
	Measurement _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp9_;
	GtkEntry* _tmp10_;
	Measurement _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_width != NULL);
	_tmp0_ = *content_width;
	_tmp1_ = self->priv->local_content_height;
	if (_tmp0_.unit != _tmp1_.unit) {
		Measurement _tmp2_;
		Measurement _tmp3_;
		Measurement _tmp4_ = {0};
		GtkEntry* _tmp5_;
		Measurement _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = *content_width;
		custom_print_tab_set_user_unit_choice (self, _tmp2_.unit);
		_tmp3_ = *content_width;
		measurement_convert_to (&self->priv->local_content_height, _tmp3_.unit, &_tmp4_);
		self->priv->local_content_height = _tmp4_;
		_tmp5_ = self->priv->custom_height_entry;
		_tmp6_ = self->priv->local_content_height;
		_tmp7_ = custom_print_tab_format_measurement (self, &_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_entry_set_text (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_tmp9_ = *content_width;
	self->priv->local_content_width = _tmp9_;
	_tmp10_ = self->priv->custom_width_entry;
	_tmp11_ = *content_width;
	_tmp12_ = custom_print_tab_format_measurement (self, &_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_entry_set_text (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}

static void
custom_print_tab_get_content_width (CustomPrintTab* self,
                                    Measurement* result)
{
	Measurement _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->local_content_width;
	*result = _tmp0_;
	return;
}

static void
custom_print_tab_set_content_height (CustomPrintTab* self,
                                     Measurement* content_height)
{
	Measurement _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp9_;
	GtkEntry* _tmp10_;
	Measurement _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_height != NULL);
	_tmp0_ = *content_height;
	_tmp1_ = self->priv->local_content_width;
	if (_tmp0_.unit != _tmp1_.unit) {
		Measurement _tmp2_;
		Measurement _tmp3_;
		Measurement _tmp4_ = {0};
		GtkEntry* _tmp5_;
		Measurement _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = *content_height;
		custom_print_tab_set_user_unit_choice (self, _tmp2_.unit);
		_tmp3_ = *content_height;
		measurement_convert_to (&self->priv->local_content_width, _tmp3_.unit, &_tmp4_);
		self->priv->local_content_width = _tmp4_;
		_tmp5_ = self->priv->custom_width_entry;
		_tmp6_ = self->priv->local_content_width;
		_tmp7_ = custom_print_tab_format_measurement (self, &_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_entry_set_text (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_tmp9_ = *content_height;
	self->priv->local_content_height = _tmp9_;
	_tmp10_ = self->priv->custom_height_entry;
	_tmp11_ = *content_height;
	_tmp12_ = custom_print_tab_format_measurement (self, &_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_entry_set_text (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
}

static void
custom_print_tab_get_content_height (CustomPrintTab* self,
                                     Measurement* result)
{
	Measurement _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->local_content_height;
	*result = _tmp0_;
	return;
}

static void
custom_print_tab_set_image_per_page_selection (CustomPrintTab* self,
                                               gint image_per_page)
{
	GtkComboBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image_per_page_combo;
	gtk_combo_box_set_active (_tmp0_, image_per_page);
}

static gint
custom_print_tab_get_image_per_page_selection (CustomPrintTab* self)
{
	GtkComboBox* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->image_per_page_combo;
	result = gtk_combo_box_get_active (_tmp0_);
	return result;
}

static void
custom_print_tab_set_size_selection (CustomPrintTab* self,
                                     gint size_selection)
{
	GtkComboBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->standard_sizes_combo;
	gtk_combo_box_set_active (_tmp0_, size_selection);
}

static gint
custom_print_tab_get_size_selection (CustomPrintTab* self)
{
	GtkComboBox* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->standard_sizes_combo;
	result = gtk_combo_box_get_active (_tmp0_);
	return result;
}

static void
custom_print_tab_set_match_aspect_ratio_enabled (CustomPrintTab* self,
                                                 gboolean enable_state)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->aspect_ratio_check;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, enable_state);
}

static void
custom_print_tab_set_print_titles_enabled (CustomPrintTab* self,
                                           gboolean print_titles)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_print_check;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, print_titles);
}

static void
custom_print_tab_set_print_titles_font (CustomPrintTab* self,
                                        const gchar* fontname)
{
	GtkFontButton* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fontname != NULL);
	_tmp0_ = self->priv->title_print_font;
	gtk_font_chooser_set_font ((GtkFontChooser*) _tmp0_, fontname);
}

static gboolean
custom_print_tab_is_match_aspect_ratio_enabled (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->aspect_ratio_check;
	result = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	return result;
}

static gboolean
custom_print_tab_is_print_titles_enabled (CustomPrintTab* self)
{
	GtkCheckButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->title_print_check;
	result = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	return result;
}

static gchar*
custom_print_tab_get_print_titles_font (CustomPrintTab* self)
{
	GtkFontButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_print_font;
	_tmp1_ = gtk_font_chooser_get_font ((GtkFontChooser*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

PrintSettings*
custom_print_tab_get_local_settings (CustomPrintTab* self)
{
	PrintSettings* _result_ = NULL;
	PrintSettings* _tmp0_;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	GtkSpinButton* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	PrintSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = print_settings_new ();
	_result_ = _tmp0_;
	custom_print_tab_get_content_width (self, &_tmp1_);
	print_settings_set_content_width (_result_, &_tmp1_);
	custom_print_tab_get_content_height (self, &_tmp2_);
	print_settings_set_content_height (_result_, &_tmp2_);
	print_settings_set_content_layout (_result_, custom_print_tab_get_content_layout (self));
	_tmp3_ = self->priv->ppi_entry;
	_tmp4_ = gtk_spin_button_get_value (_tmp3_);
	_tmp5_ = _tmp4_;
	print_settings_set_content_ppi (_result_, (gint) _tmp5_);
	print_settings_set_image_per_page_selection (_result_, custom_print_tab_get_image_per_page_selection (self));
	print_settings_set_size_selection (_result_, custom_print_tab_get_size_selection (self));
	print_settings_set_match_aspect_ratio_enabled (_result_, custom_print_tab_is_match_aspect_ratio_enabled (self));
	print_settings_set_print_titles_enabled (_result_, custom_print_tab_is_print_titles_enabled (self));
	_tmp6_ = custom_print_tab_get_print_titles_font (self);
	_tmp7_ = _tmp6_;
	print_settings_set_print_titles_font (_result_, _tmp7_);
	_g_free0 (_tmp7_);
	result = _result_;
	return result;
}

PrintJob*
custom_print_tab_get_source_job (CustomPrintTab* self)
{
	PrintJob* result;
	PrintJob* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_job;
	result = _tmp0_;
	return result;
}

static void
custom_print_tab_set_source_job (CustomPrintTab* self,
                                 PrintJob* value)
{
	PrintJob* old_value;
	g_return_if_fail (self != NULL);
	old_value = custom_print_tab_get_source_job (self);
	if (old_value != value) {
		PrintJob* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source_job);
		self->priv->_source_job = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, custom_print_tab_properties[CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY]);
	}
}

static gpointer
_standard_print_size_ref0 (gpointer self)
{
	return self ? standard_print_size_ref (self) : NULL;
}

static gboolean
_custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func (GtkTreeModel* model,
                                                                                        GtkTreeIter* iter,
                                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_standard_sizes_combo_separator_func (model, iter);
	return result;
}

static void
_custom_print_tab_on_radio_group_click_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	custom_print_tab_on_radio_group_click ((CustomPrintTab*) self, _sender);
}

static void
_custom_print_tab_on_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                 const gchar* new_text,
                                                                 gint new_text_length,
                                                                 gint* position,
                                                                 gpointer self)
{
	custom_print_tab_on_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
}

static gboolean
_custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_width_entry_focus_out ((CustomPrintTab*) self, event);
	return result;
}

static gboolean
_custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self)
{
	gboolean result;
	result = custom_print_tab_on_height_entry_focus_out ((CustomPrintTab*) self, event);
	return result;
}

static void
_custom_print_tab_on_units_combo_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
	custom_print_tab_on_units_combo_changed ((CustomPrintTab*) self);
}

static void
_custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gint* position,
                                                                     gpointer self)
{
	custom_print_tab_on_ppi_entry_insert_text ((CustomPrintTab*) self, _sender, new_text, new_text_length, position);
}

static void
_custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	custom_print_tab_on_aspect_ratio_check_clicked ((CustomPrintTab*) self);
}

static GObject *
custom_print_tab_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CustomPrintTab * self;
	GtkLabel* printed_size_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkRadioButton* _tmp5_;
	GtkRadioButton* _tmp6_;
	GtkRadioButton* _tmp7_;
	GtkRadioButton* _tmp8_;
	GtkRadioButton* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkListStore* image_per_page_combo_store = NULL;
	GtkListStore* _tmp12_;
	gint _tmp13_ = 0;
	PrintLayout* _tmp14_;
	GtkCellRendererText* image_per_page_combo_text_renderer = NULL;
	GtkCellRendererText* _tmp21_;
	GtkListStore* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkCellRendererText* _tmp27_;
	StandardPrintSize** standard_sizes = NULL;
	PrintManager* _tmp28_;
	PrintManager* _tmp29_;
	gint _tmp30_ = 0;
	StandardPrintSize** _tmp31_;
	StandardPrintSize** _tmp32_;
	gint _tmp32__length1;
	gint standard_sizes_length1;
	gint _standard_sizes_size_;
	GtkListStore* standard_sizes_combo_store = NULL;
	GtkListStore* _tmp33_;
	StandardPrintSize** _tmp34_;
	gint _tmp34__length1;
	GtkCellRendererText* standard_sizes_combo_text_renderer = NULL;
	GtkCellRendererText* _tmp43_;
	GtkListStore* _tmp44_;
	GtkComboBox* _tmp45_;
	GtkComboBox* _tmp46_;
	GtkCellRendererText* _tmp47_;
	GtkComboBox* _tmp48_;
	GtkCellRendererText* _tmp49_;
	GtkComboBox* _tmp50_;
	GtkEntry* _tmp51_;
	GtkLabel* mult_label = NULL;
	GtkLabel* _tmp52_;
	GtkEntry* _tmp53_;
	GtkComboBoxText* _tmp54_;
	GtkComboBoxText* _tmp55_;
	GtkComboBoxText* _tmp56_;
	GtkComboBoxText* _tmp57_;
	GtkGrid* custom_grid = NULL;
	GtkGrid* _tmp58_;
	GtkGrid* _tmp59_;
	GtkGrid* _tmp60_;
	GtkEntry* _tmp61_;
	GtkGrid* _tmp62_;
	GtkLabel* _tmp63_;
	GtkGrid* _tmp64_;
	GtkEntry* _tmp65_;
	GtkGrid* _tmp66_;
	GtkComboBoxText* _tmp67_;
	GtkCheckButton* _tmp68_;
	GtkLabel* titles_label = NULL;
	GtkLabel* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkStyleContext* _tmp72_;
	GtkCheckButton* _tmp73_;
	GtkCheckButton* _tmp74_;
	GtkFontButton* _tmp75_;
	GtkFontButton* _tmp76_;
	GtkLabel* resolution_label = NULL;
	GtkLabel* _tmp77_;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkStyleContext* _tmp80_;
	GtkSpinButton* _tmp81_;
	GtkSpinButton* _tmp82_;
	GtkLabel* ppi_label = NULL;
	GtkLabel* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkSpinButton* _tmp86_;
	GtkLabel* _tmp87_;
	GtkLabel* _tmp88_;
	GtkLabel* unit_label = NULL;
	GtkLabel* _tmp89_;
	GtkLabel* _tmp90_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp91_;
	GtkGrid* _tmp92_;
	GtkGrid* _tmp93_;
	GtkGrid* _tmp94_;
	GtkGrid* _tmp95_;
	GtkLabel* _tmp96_;
	GtkGrid* _tmp97_;
	GtkRadioButton* _tmp98_;
	GtkGrid* _tmp99_;
	GtkComboBox* _tmp100_;
	GtkGrid* _tmp101_;
	GtkRadioButton* _tmp102_;
	GtkGrid* _tmp103_;
	GtkGrid* _tmp104_;
	GtkGrid* _tmp105_;
	GtkCheckButton* _tmp106_;
	GtkGrid* _tmp107_;
	GtkRadioButton* _tmp108_;
	GtkGrid* _tmp109_;
	GtkComboBox* _tmp110_;
	GtkGrid* _tmp111_;
	GtkLabel* _tmp112_;
	GtkGrid* _tmp113_;
	GtkCheckButton* _tmp114_;
	GtkGrid* _tmp115_;
	GtkFontButton* _tmp116_;
	GtkGrid* _tmp117_;
	GtkLabel* _tmp118_;
	GtkGrid* _tmp119_;
	GtkLabel* _tmp120_;
	GtkGrid* _tmp121_;
	GtkSpinButton* _tmp122_;
	GtkGrid* _tmp123_;
	GtkLabel* _tmp124_;
	GtkGrid* _tmp125_;
	GtkRadioButton* _tmp126_;
	GtkRadioButton* _tmp127_;
	GtkRadioButton* _tmp128_;
	GtkEntry* _tmp129_;
	GtkEntry* _tmp130_;
	GtkEntry* _tmp131_;
	GtkEntry* _tmp132_;
	GtkComboBoxText* _tmp133_;
	GtkSpinButton* _tmp134_;
	PrintJob* _tmp135_;
	GtkCheckButton* _tmp136_;
	parent_class = G_OBJECT_CLASS (custom_print_tab_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Printed Image Size"));
	g_object_ref_sink (_tmp0_);
	printed_size_label = _tmp0_;
	_tmp1_ = printed_size_label;
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	_tmp2_ = printed_size_label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp4_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _ ("Use a _standard size:"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->standard_size_radio);
	self->priv->standard_size_radio = _tmp4_;
	_tmp5_ = self->priv->standard_size_radio;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = self->priv->standard_size_radio;
	_tmp7_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (_tmp6_, _ ("Use a c_ustom size:"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->custom_size_radio);
	self->priv->custom_size_radio = _tmp7_;
	_tmp8_ = self->priv->custom_size_radio;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp8_, 12);
	_tmp9_ = self->priv->standard_size_radio;
	_tmp10_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (_tmp9_, _ ("_Autosize:"));
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->image_per_page_radio);
	self->priv->image_per_page_radio = _tmp10_;
	_tmp11_ = self->priv->image_per_page_radio;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp11_, 12);
	_tmp12_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	image_per_page_combo_store = _tmp12_;
	_tmp14_ = print_layout_get_all (&_tmp13_);
	{
		PrintLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
		layout_collection = _tmp14_;
		layout_collection_length1 = _tmp13_;
		for (layout_it = 0; layout_it < layout_collection_length1; layout_it = layout_it + 1) {
			PrintLayout layout = 0;
			layout = layout_collection[layout_it];
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp15_;
				GtkTreeIter _tmp16_ = {0};
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_;
				gchar* _tmp19_;
				GValue _tmp20_ = {0};
				_tmp15_ = image_per_page_combo_store;
				gtk_list_store_append (_tmp15_, &_tmp16_);
				iter = _tmp16_;
				_tmp17_ = image_per_page_combo_store;
				_tmp18_ = iter;
				_tmp19_ = print_layout_to_string (layout);
				g_value_init (&_tmp20_, G_TYPE_STRING);
				g_value_take_string (&_tmp20_, _tmp19_);
				gtk_list_store_set_value (_tmp17_, &_tmp18_, 0, &_tmp20_);
				G_IS_VALUE (&_tmp20_) ? (g_value_unset (&_tmp20_), NULL) : NULL;
			}
		}
		layout_collection = (g_free (layout_collection), NULL);
	}
	_tmp21_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp21_);
	image_per_page_combo_text_renderer = _tmp21_;
	_tmp22_ = image_per_page_combo_store;
	_tmp23_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp22_);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->image_per_page_combo);
	self->priv->image_per_page_combo = _tmp23_;
	_tmp24_ = self->priv->image_per_page_combo;
	_tmp25_ = image_per_page_combo_text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, TRUE);
	_tmp26_ = self->priv->image_per_page_combo;
	_tmp27_ = image_per_page_combo_text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp26_, (GtkCellRenderer*) _tmp27_, "text", 0);
	_tmp28_ = print_manager_get_instance ();
	_tmp29_ = _tmp28_;
	_tmp31_ = print_manager_get_standard_sizes (_tmp29_, &_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp30_;
	_print_manager_unref0 (_tmp29_);
	standard_sizes = _tmp32_;
	standard_sizes_length1 = _tmp32__length1;
	_standard_sizes_size_ = standard_sizes_length1;
	_tmp33_ = gtk_list_store_new (1, G_TYPE_STRING, G_TYPE_STRING, -1);
	standard_sizes_combo_store = _tmp33_;
	_tmp34_ = standard_sizes;
	_tmp34__length1 = standard_sizes_length1;
	{
		StandardPrintSize** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp34_;
		size_collection_length1 = _tmp34__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			StandardPrintSize* _tmp35_;
			StandardPrintSize* size = NULL;
			_tmp35_ = _standard_print_size_ref0 (size_collection[size_it]);
			size = _tmp35_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp36_;
				GtkTreeIter _tmp37_ = {0};
				GtkListStore* _tmp38_;
				GtkTreeIter _tmp39_;
				StandardPrintSize* _tmp40_;
				const gchar* _tmp41_;
				GValue _tmp42_ = {0};
				_tmp36_ = standard_sizes_combo_store;
				gtk_list_store_append (_tmp36_, &_tmp37_);
				iter = _tmp37_;
				_tmp38_ = standard_sizes_combo_store;
				_tmp39_ = iter;
				_tmp40_ = size;
				_tmp41_ = _tmp40_->name;
				g_value_init (&_tmp42_, G_TYPE_STRING);
				g_value_set_string (&_tmp42_, _tmp41_);
				gtk_list_store_set_value (_tmp38_, &_tmp39_, 0, &_tmp42_);
				G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
				_standard_print_size_unref0 (size);
			}
		}
	}
	_tmp43_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp43_);
	standard_sizes_combo_text_renderer = _tmp43_;
	_tmp44_ = standard_sizes_combo_store;
	_tmp45_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->standard_sizes_combo);
	self->priv->standard_sizes_combo = _tmp45_;
	_tmp46_ = self->priv->standard_sizes_combo;
	_tmp47_ = standard_sizes_combo_text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp46_, (GtkCellRenderer*) _tmp47_, TRUE);
	_tmp48_ = self->priv->standard_sizes_combo;
	_tmp49_ = standard_sizes_combo_text_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp48_, (GtkCellRenderer*) _tmp49_, "text", 0);
	_tmp50_ = self->priv->standard_sizes_combo;
	gtk_combo_box_set_row_separator_func (_tmp50_, _custom_print_tab_standard_sizes_combo_separator_func_gtk_tree_view_row_separator_func, NULL, NULL);
	_tmp51_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->custom_width_entry);
	self->priv->custom_width_entry = _tmp51_;
	_tmp52_ = (GtkLabel*) gtk_label_new ("×");
	g_object_ref_sink (_tmp52_);
	mult_label = _tmp52_;
	_tmp53_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->custom_height_entry);
	self->priv->custom_height_entry = _tmp53_;
	_tmp54_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->units_combo);
	self->priv->units_combo = _tmp54_;
	_tmp55_ = self->priv->units_combo;
	gtk_combo_box_text_append_text (_tmp55_, _ ("in."));
	_tmp56_ = self->priv->units_combo;
	gtk_combo_box_text_append_text (_tmp56_, _ ("cm"));
	_tmp57_ = self->priv->units_combo;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp57_, 0);
	_tmp58_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp58_);
	custom_grid = _tmp58_;
	_tmp59_ = custom_grid;
	gtk_grid_set_column_spacing (_tmp59_, 3);
	_tmp60_ = custom_grid;
	_tmp61_ = self->priv->custom_width_entry;
	gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
	_tmp62_ = custom_grid;
	_tmp63_ = mult_label;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = custom_grid;
	_tmp65_ = self->priv->custom_height_entry;
	gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = custom_grid;
	_tmp67_ = self->priv->units_combo;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("_Match photo aspect ratio"));
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->aspect_ratio_check);
	self->priv->aspect_ratio_check = _tmp68_;
	_tmp69_ = (GtkLabel*) gtk_label_new (_ ("Titles"));
	g_object_ref_sink (_tmp69_);
	titles_label = _tmp69_;
	_tmp70_ = titles_label;
	gtk_label_set_xalign (_tmp70_, (gfloat) 0);
	_tmp71_ = titles_label;
	_tmp72_ = gtk_widget_get_style_context ((GtkWidget*) _tmp71_);
	gtk_style_context_add_class (_tmp72_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp73_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("Print image _title"));
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->title_print_check);
	self->priv->title_print_check = _tmp73_;
	_tmp74_ = self->priv->title_print_check;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp74_, 12);
	_tmp75_ = (GtkFontButton*) gtk_font_button_new ();
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->title_print_font);
	self->priv->title_print_font = _tmp75_;
	_tmp76_ = self->priv->title_print_font;
	gtk_font_button_set_use_font (_tmp76_, TRUE);
	_tmp77_ = (GtkLabel*) gtk_label_new (_ ("Pixel Resolution"));
	g_object_ref_sink (_tmp77_);
	resolution_label = _tmp77_;
	_tmp78_ = resolution_label;
	gtk_label_set_xalign (_tmp78_, (gfloat) 0);
	_tmp79_ = resolution_label;
	_tmp80_ = gtk_widget_get_style_context ((GtkWidget*) _tmp79_);
	gtk_style_context_add_class (_tmp80_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp81_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) PRINT_SETTINGS_MIN_CONTENT_PPI, (gdouble) PRINT_SETTINGS_MAX_CONTENT_PPI, (gdouble) 100);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->ppi_entry);
	self->priv->ppi_entry = _tmp81_;
	_tmp82_ = self->priv->ppi_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp82_, TRUE);
	_tmp83_ = (GtkLabel*) gtk_label_new (_ ("_Output photo at:"));
	g_object_ref_sink (_tmp83_);
	ppi_label = _tmp83_;
	_tmp84_ = ppi_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp84_, 12);
	_tmp85_ = ppi_label;
	_tmp86_ = self->priv->ppi_entry;
	gtk_label_set_mnemonic_widget (_tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = ppi_label;
	gtk_label_set_use_underline (_tmp87_, TRUE);
	_tmp88_ = ppi_label;
	gtk_label_set_xalign (_tmp88_, (gfloat) 1);
	_tmp89_ = (GtkLabel*) gtk_label_new (_ ("pixels per inch"));
	g_object_ref_sink (_tmp89_);
	unit_label = _tmp89_;
	_tmp90_ = unit_label;
	gtk_label_set_xalign (_tmp90_, (gfloat) 0);
	_tmp91_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp91_);
	grid = _tmp91_;
	_tmp92_ = grid;
	gtk_grid_set_column_spacing (_tmp92_, 12);
	_tmp93_ = grid;
	gtk_grid_set_row_spacing (_tmp93_, 12);
	_tmp94_ = grid;
	g_object_set ((GtkWidget*) _tmp94_, "margin", 12, NULL);
	_tmp95_ = grid;
	_tmp96_ = printed_size_label;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 0, 0, 3, 1);
	_tmp97_ = grid;
	_tmp98_ = self->priv->standard_size_radio;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 0, 1, 1, 1);
	_tmp99_ = grid;
	_tmp100_ = self->priv->standard_sizes_combo;
	gtk_grid_attach (_tmp99_, (GtkWidget*) _tmp100_, 1, 1, 2, 1);
	_tmp101_ = grid;
	_tmp102_ = self->priv->custom_size_radio;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 0, 2, 1, 1);
	_tmp103_ = grid;
	_tmp104_ = custom_grid;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 1, 2, 2, 1);
	_tmp105_ = grid;
	_tmp106_ = self->priv->aspect_ratio_check;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 3, 2, 1);
	_tmp107_ = grid;
	_tmp108_ = self->priv->image_per_page_radio;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 0, 4, 1, 1);
	_tmp109_ = grid;
	_tmp110_ = self->priv->image_per_page_combo;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 1, 4, 2, 1);
	_tmp111_ = grid;
	_tmp112_ = titles_label;
	gtk_grid_attach (_tmp111_, (GtkWidget*) _tmp112_, 0, 5, 3, 1);
	_tmp113_ = grid;
	_tmp114_ = self->priv->title_print_check;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 0, 6, 1, 1);
	_tmp115_ = grid;
	_tmp116_ = self->priv->title_print_font;
	gtk_grid_attach (_tmp115_, (GtkWidget*) _tmp116_, 1, 6, 2, 1);
	_tmp117_ = grid;
	_tmp118_ = resolution_label;
	gtk_grid_attach (_tmp117_, (GtkWidget*) _tmp118_, 0, 7, 3, 1);
	_tmp119_ = grid;
	_tmp120_ = ppi_label;
	gtk_grid_attach (_tmp119_, (GtkWidget*) _tmp120_, 0, 8, 1, 1);
	_tmp121_ = grid;
	_tmp122_ = self->priv->ppi_entry;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 1, 8, 1, 1);
	_tmp123_ = grid;
	_tmp124_ = unit_label;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 2, 8, 1, 1);
	_tmp125_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp125_);
	_tmp126_ = self->priv->standard_size_radio;
	g_signal_connect_object ((GtkButton*) _tmp126_, "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp127_ = self->priv->custom_size_radio;
	g_signal_connect_object ((GtkButton*) _tmp127_, "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp128_ = self->priv->image_per_page_radio;
	g_signal_connect_object ((GtkButton*) _tmp128_, "clicked", (GCallback) _custom_print_tab_on_radio_group_click_gtk_button_clicked, self, 0);
	_tmp129_ = self->priv->custom_width_entry;
	g_signal_connect_object ((GtkEditable*) _tmp129_, "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp130_ = self->priv->custom_width_entry;
	g_signal_connect_object ((GtkWidget*) _tmp130_, "focus-out-event", (GCallback) _custom_print_tab_on_width_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp131_ = self->priv->custom_height_entry;
	g_signal_connect_object ((GtkEditable*) _tmp131_, "insert-text", (GCallback) _custom_print_tab_on_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp132_ = self->priv->custom_height_entry;
	g_signal_connect_object ((GtkWidget*) _tmp132_, "focus-out-event", (GCallback) _custom_print_tab_on_height_entry_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp133_ = self->priv->units_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp133_, "changed", (GCallback) _custom_print_tab_on_units_combo_changed_gtk_combo_box_changed, self, 0);
	_tmp134_ = self->priv->ppi_entry;
	g_signal_connect_object ((GtkEditable*) _tmp134_, "insert-text", (GCallback) _custom_print_tab_on_ppi_entry_insert_text_gtk_editable_insert_text, self, 0);
	_tmp135_ = self->priv->_source_job;
	custom_print_tab_sync_state_from_job (self, _tmp135_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp136_ = self->priv->aspect_ratio_check;
	g_signal_connect_object ((GtkButton*) _tmp136_, "clicked", (GCallback) _custom_print_tab_on_aspect_ratio_check_clicked_gtk_button_clicked, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (unit_label);
	_g_object_unref0 (ppi_label);
	_g_object_unref0 (resolution_label);
	_g_object_unref0 (titles_label);
	_g_object_unref0 (custom_grid);
	_g_object_unref0 (mult_label);
	_g_object_unref0 (standard_sizes_combo_text_renderer);
	_g_object_unref0 (standard_sizes_combo_store);
	standard_sizes = (_vala_array_free (standard_sizes, standard_sizes_length1, (GDestroyNotify) standard_print_size_unref), NULL);
	_g_object_unref0 (image_per_page_combo_text_renderer);
	_g_object_unref0 (image_per_page_combo_store);
	_g_object_unref0 (printed_size_label);
	return obj;
}

static void
custom_print_tab_class_init (CustomPrintTabClass * klass,
                             gpointer klass_data)
{
	custom_print_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CustomPrintTab_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_custom_print_tab_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_custom_print_tab_set_property;
	G_OBJECT_CLASS (klass)->constructor = custom_print_tab_constructor;
	G_OBJECT_CLASS (klass)->finalize = custom_print_tab_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY, custom_print_tab_properties[CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY] = g_param_spec_object ("source-job", "source-job", "source-job", TYPE_PRINT_JOB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
custom_print_tab_instance_init (CustomPrintTab * self,
                                gpointer klass)
{
	self->priv = custom_print_tab_get_instance_private (self);
	self->priv->standard_size_radio = NULL;
	self->priv->custom_size_radio = NULL;
	self->priv->image_per_page_radio = NULL;
	self->priv->image_per_page_combo = NULL;
	self->priv->standard_sizes_combo = NULL;
	self->priv->units_combo = NULL;
	self->priv->custom_width_entry = NULL;
	self->priv->custom_height_entry = NULL;
	self->priv->aspect_ratio_check = NULL;
	self->priv->title_print_check = NULL;
	self->priv->title_print_font = NULL;
	measurement_init (&self->priv->local_content_width, 5.0, MEASUREMENT_UNIT_INCHES);
	measurement_init (&self->priv->local_content_height, 5.0, MEASUREMENT_UNIT_INCHES);
	self->priv->is_text_insertion_in_progress = FALSE;
}

static void
custom_print_tab_finalize (GObject * obj)
{
	CustomPrintTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
	_g_object_unref0 (self->priv->standard_size_radio);
	_g_object_unref0 (self->priv->custom_size_radio);
	_g_object_unref0 (self->priv->image_per_page_radio);
	_g_object_unref0 (self->priv->image_per_page_combo);
	_g_object_unref0 (self->priv->standard_sizes_combo);
	_g_object_unref0 (self->priv->units_combo);
	_g_object_unref0 (self->priv->custom_width_entry);
	_g_object_unref0 (self->priv->custom_height_entry);
	_g_object_unref0 (self->priv->aspect_ratio_check);
	_g_object_unref0 (self->priv->title_print_check);
	_g_object_unref0 (self->priv->title_print_font);
	_g_object_unref0 (self->priv->ppi_entry);
	_g_object_unref0 (self->priv->_source_job);
	G_OBJECT_CLASS (custom_print_tab_parent_class)->finalize (obj);
}

static GType
custom_print_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CustomPrintTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) custom_print_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CustomPrintTab), 0, (GInstanceInitFunc) custom_print_tab_instance_init, NULL };
	GType custom_print_tab_type_id;
	custom_print_tab_type_id = g_type_register_static (gtk_fixed_get_type (), "CustomPrintTab", &g_define_type_info, 0);
	CustomPrintTab_private_offset = g_type_add_instance_private (custom_print_tab_type_id, sizeof (CustomPrintTabPrivate));
	return custom_print_tab_type_id;
}

GType
custom_print_tab_get_type (void)
{
	static volatile gsize custom_print_tab_type_id__once = 0;
	if (g_once_init_enter (&custom_print_tab_type_id__once)) {
		GType custom_print_tab_type_id;
		custom_print_tab_type_id = custom_print_tab_get_type_once ();
		g_once_init_leave (&custom_print_tab_type_id__once, custom_print_tab_type_id);
	}
	return custom_print_tab_type_id__once;
}

static void
_vala_custom_print_tab_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	CustomPrintTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
	switch (property_id) {
		case CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY:
		g_value_set_object (value, custom_print_tab_get_source_job (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_custom_print_tab_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	CustomPrintTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab);
	switch (property_id) {
		case CUSTOM_PRINT_TAB_SOURCE_JOB_PROPERTY:
		custom_print_tab_set_source_job (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

