/* VideoMetadata.c generated by valac 0.56.18, the Vala compiler
 * generated from VideoMetadata.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <stdio.h>
#include <float.h>
#include <math.h>

#define QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT ((gint64) 2082844800)
#define AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH 19
#define AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER ((guint16) 0x13)
#define AVI_METADATA_LOADER_MAX_STRD_LENGTH 100
#define AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH 1024
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_QUICK_TIME_METADATA_LOADER (quick_time_metadata_loader_get_type ())
#define QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader))
#define QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))
#define IS_QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_METADATA_LOADER))
#define IS_QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_METADATA_LOADER))
#define QUICK_TIME_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))

typedef struct _QuickTimeMetadataLoader QuickTimeMetadataLoader;
typedef struct _QuickTimeMetadataLoaderClass QuickTimeMetadataLoaderClass;
#define _quick_time_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_metadata_loader_unref (var), NULL)))

#define TYPE_AVI_METADATA_LOADER (avi_metadata_loader_get_type ())
#define AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoader))
#define AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))
#define IS_AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_METADATA_LOADER))
#define IS_AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_METADATA_LOADER))
#define AVI_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))

typedef struct _AVIMetadataLoader AVIMetadataLoader;
typedef struct _AVIMetadataLoaderClass AVIMetadataLoaderClass;
#define _avi_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (avi_metadata_loader_unref (var), NULL)))
typedef struct _QuickTimeMetadataLoaderPrivate QuickTimeMetadataLoaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_QUICK_TIME_ATOM (quick_time_atom_get_type ())
#define QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtom))
#define QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))
#define IS_QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_ATOM))
#define IS_QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_ATOM))
#define QUICK_TIME_ATOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))

typedef struct _QuickTimeAtom QuickTimeAtom;
typedef struct _QuickTimeAtomClass QuickTimeAtomClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _quick_time_atom_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_atom_unref (var), NULL)))
typedef struct _ParamSpecQuickTimeMetadataLoader ParamSpecQuickTimeMetadataLoader;
typedef struct _QuickTimeAtomPrivate QuickTimeAtomPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecQuickTimeAtom ParamSpecQuickTimeAtom;
typedef struct _AVIMetadataLoaderPrivate AVIMetadataLoaderPrivate;

#define TYPE_AVI_CHUNK (avi_chunk_get_type ())
#define AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_CHUNK, AVIChunk))
#define AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_CHUNK, AVIChunkClass))
#define IS_AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_CHUNK))
#define IS_AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_CHUNK))
#define AVI_CHUNK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_CHUNK, AVIChunkClass))

typedef struct _AVIChunk AVIChunk;
typedef struct _AVIChunkClass AVIChunkClass;
#define _avi_chunk_unref0(var) ((var == NULL) ? NULL : (var = (avi_chunk_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _ParamSpecAVIMetadataLoader ParamSpecAVIMetadataLoader;
typedef struct _AVIChunkPrivate AVIChunkPrivate;
typedef struct _ParamSpecAVIChunk ParamSpecAVIChunk;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VideoMetadataPrivate {
	MetadataDateTime* timestamp;
	gchar* title;
	gchar* comment;
};

struct _QuickTimeMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeMetadataLoaderPrivate * priv;
};

struct _QuickTimeMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeMetadataLoader *self);
};

struct _QuickTimeMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecQuickTimeMetadataLoader {
	GParamSpec parent_instance;
};

struct _QuickTimeAtom {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeAtomPrivate * priv;
};

struct _QuickTimeAtomClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeAtom *self);
};

struct _QuickTimeAtomPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	QuickTimeAtom* parent;
};

struct _ParamSpecQuickTimeAtom {
	GParamSpec parent_instance;
};

struct _AVIMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIMetadataLoaderPrivate * priv;
};

struct _AVIMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (AVIMetadataLoader *self);
};

struct _AVIMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecAVIMetadataLoader {
	GParamSpec parent_instance;
};

struct _AVIChunk {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIChunkPrivate * priv;
};

struct _AVIChunkClass {
	GTypeClass parent_class;
	void (*finalize) (AVIChunk *self);
};

struct _AVIChunkPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	AVIChunk* parent;
};

struct _ParamSpecAVIChunk {
	GParamSpec parent_instance;
};

static gint VideoMetadata_private_offset;
static gpointer video_metadata_parent_class = NULL;
static gint QuickTimeMetadataLoader_private_offset;
static gpointer quick_time_metadata_loader_parent_class = NULL;
static gint QuickTimeAtom_private_offset;
static gpointer quick_time_atom_parent_class = NULL;
static gint AVIMetadataLoader_private_offset;
static gpointer avi_metadata_loader_parent_class = NULL;
static gint AVIChunk_private_offset;
static gpointer avi_chunk_parent_class = NULL;

static void video_metadata_real_read_from_file (MediaMetadata* base,
                                         GFile* file,
                                         GError** error);
VALA_EXTERN gpointer quick_time_metadata_loader_ref (gpointer instance);
VALA_EXTERN void quick_time_metadata_loader_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_quick_time_metadata_loader (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_quick_time_metadata_loader (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_quick_time_metadata_loader (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_quick_time_metadata_loader (const GValue* value);
VALA_EXTERN GType quick_time_metadata_loader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN QuickTimeMetadataLoader* quick_time_metadata_loader_new (GFile* file);
VALA_EXTERN QuickTimeMetadataLoader* quick_time_metadata_loader_construct (GType object_type,
                                                               GFile* file);
VALA_EXTERN gboolean quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self);
VALA_EXTERN MetadataDateTime* quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self);
VALA_EXTERN gchar* quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self);
VALA_EXTERN gpointer avi_metadata_loader_ref (gpointer instance);
VALA_EXTERN void avi_metadata_loader_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_avi_metadata_loader (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_avi_metadata_loader (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_avi_metadata_loader (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_avi_metadata_loader (const GValue* value);
VALA_EXTERN GType avi_metadata_loader_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AVIMetadataLoader* avi_metadata_loader_new (GFile* file);
VALA_EXTERN AVIMetadataLoader* avi_metadata_loader_construct (GType object_type,
                                                  GFile* file);
VALA_EXTERN gboolean avi_metadata_loader_is_supported (AVIMetadataLoader* self);
VALA_EXTERN MetadataDateTime* avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self);
VALA_EXTERN gchar* avi_metadata_loader_get_title (AVIMetadataLoader* self);
static MetadataDateTime* video_metadata_real_get_creation_date_time (MediaMetadata* base);
static gchar* video_metadata_real_get_title (MediaMetadata* base);
static gchar* video_metadata_real_get_comment (MediaMetadata* base);
static void video_metadata_finalize (MediaMetadata * obj);
static GType video_metadata_get_type_once (void);
static gint64 quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self);
VALA_EXTERN gpointer quick_time_atom_ref (gpointer instance);
VALA_EXTERN void quick_time_atom_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_quick_time_atom (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_quick_time_atom (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_quick_time_atom (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_quick_time_atom (const GValue* value);
VALA_EXTERN GType quick_time_atom_get_type (void) G_GNUC_CONST ;
VALA_EXTERN QuickTimeAtom* quick_time_atom_new (GFile* file);
VALA_EXTERN QuickTimeAtom* quick_time_atom_construct (GType object_type,
                                          GFile* file);
VALA_EXTERN void quick_time_atom_open_file (QuickTimeAtom* self,
                                GError** error);
VALA_EXTERN void quick_time_atom_read_atom (QuickTimeAtom* self,
                                GError** error);
VALA_EXTERN gchar* quick_time_atom_get_current_atom_name (QuickTimeAtom* self);
VALA_EXTERN void quick_time_atom_next_atom (QuickTimeAtom* self,
                                GError** error);
VALA_EXTERN gboolean quick_time_atom_is_last_atom (QuickTimeAtom* self);
VALA_EXTERN void quick_time_atom_close_file (QuickTimeAtom* self,
                                 GError** error);
VALA_EXTERN QuickTimeAtom* quick_time_atom_get_first_child_atom (QuickTimeAtom* self);
VALA_EXTERN guint64 quick_time_atom_section_size_remaining (QuickTimeAtom* self);
VALA_EXTERN guint32 quick_time_atom_read_uint32 (QuickTimeAtom* self,
                                     GError** error);
static void quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj);
static GType quick_time_metadata_loader_get_type_once (void);
static QuickTimeAtom* quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                                      QuickTimeAtom* parent);
static QuickTimeAtom* quick_time_atom_construct_with_input_stream (GType object_type,
                                                            GDataInputStream* input,
                                                            QuickTimeAtom* parent);
static void quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                             guint64 amount);
VALA_EXTERN guchar quick_time_atom_read_byte (QuickTimeAtom* self,
                                  GError** error);
VALA_EXTERN guint64 quick_time_atom_read_uint64 (QuickTimeAtom* self,
                                     GError** error);
static void quick_time_atom_skip (QuickTimeAtom* self,
                           guint64 skip_amount,
                           GError** error);
static void quick_time_atom_finalize (QuickTimeAtom * obj);
static GType quick_time_atom_get_type_once (void);
static gint64 avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self);
VALA_EXTERN gpointer avi_chunk_ref (gpointer instance);
VALA_EXTERN void avi_chunk_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_avi_chunk (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_avi_chunk (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_avi_chunk (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_avi_chunk (const GValue* value);
VALA_EXTERN GType avi_chunk_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AVIChunk* avi_chunk_new (GFile* file);
VALA_EXTERN AVIChunk* avi_chunk_construct (GType object_type,
                               GFile* file);
VALA_EXTERN void avi_chunk_open_file (AVIChunk* self,
                          GError** error);
VALA_EXTERN void avi_chunk_read_chunk (AVIChunk* self,
                           GError** error);
VALA_EXTERN gchar* avi_chunk_get_current_chunk_name (AVIChunk* self);
VALA_EXTERN gchar* avi_chunk_read_name (AVIChunk* self,
                            GError** error);
VALA_EXTERN void avi_chunk_close_file (AVIChunk* self,
                           GError** error);
static gchar* avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                                AVIChunk* chunk,
                                                GError** error);
VALA_EXTERN guint64 avi_chunk_section_size_remaining (AVIChunk* self);
VALA_EXTERN guint16 avi_chunk_read_uint16 (AVIChunk* self,
                               GError** error);
VALA_EXTERN void avi_chunk_skip (AVIChunk* self,
                     guint64 skip_amount,
                     GError** error);
VALA_EXTERN guchar avi_chunk_read_byte (AVIChunk* self,
                            GError** error);
static gchar* avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                               AVIChunk* chunk,
                                               GError** error);
static gchar* avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error);
VALA_EXTERN gchar* avi_chunk_section_to_string (AVIChunk* self,
                                    GError** error);
VALA_EXTERN AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self);
VALA_EXTERN gboolean avi_chunk_is_last_chunk (AVIChunk* self);
VALA_EXTERN void avi_chunk_next_chunk (AVIChunk* self,
                           GError** error);
static gint64 avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                       const gchar* sdate);
static GDateMonth avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                                  const gchar* s);
VALA_EXTERN void avi_chunk_nonsection_skip (AVIChunk* self,
                                guint64 skip_amount,
                                GError** error);
static void avi_metadata_loader_finalize (AVIMetadataLoader * obj);
static GType avi_metadata_loader_get_type_once (void);
static AVIChunk* avi_chunk_new_with_input_stream (GDataInputStream* input,
                                           AVIChunk* parent);
static AVIChunk* avi_chunk_construct_with_input_stream (GType object_type,
                                                 GDataInputStream* input,
                                                 AVIChunk* parent);
static void avi_chunk_advance_section_offset (AVIChunk* self,
                                       guint64 amount);
static void avi_chunk_finalize (AVIChunk * obj);
static GType avi_chunk_get_type_once (void);

static inline gpointer
video_metadata_get_instance_private (VideoMetadata* self)
{
	return G_STRUCT_MEMBER_P (self, VideoMetadata_private_offset);
}

VideoMetadata*
video_metadata_construct (GType object_type)
{
	VideoMetadata* self = NULL;
	self = (VideoMetadata*) media_metadata_construct (object_type);
	return self;
}

VideoMetadata*
video_metadata_new (void)
{
	return video_metadata_construct (TYPE_VIDEO_METADATA);
}

static void
video_metadata_real_read_from_file (MediaMetadata* base,
                                    GFile* file,
                                    GError** error)
{
	VideoMetadata * self;
	QuickTimeMetadataLoader* quicktime = NULL;
	QuickTimeMetadataLoader* _tmp0_;
	QuickTimeMetadataLoader* _tmp1_;
	AVIMetadataLoader* avi = NULL;
	AVIMetadataLoader* _tmp6_;
	AVIMetadataLoader* _tmp7_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = (VideoMetadata*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = quick_time_metadata_loader_new (file);
	quicktime = _tmp0_;
	_tmp1_ = quicktime;
	if (quick_time_metadata_loader_is_supported (_tmp1_)) {
		QuickTimeMetadataLoader* _tmp2_;
		MetadataDateTime* _tmp3_;
		QuickTimeMetadataLoader* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = quicktime;
		_tmp3_ = quick_time_metadata_loader_get_creation_date_time (_tmp2_);
		_metadata_date_time_unref0 (self->priv->timestamp);
		self->priv->timestamp = _tmp3_;
		_tmp4_ = quicktime;
		_tmp5_ = quick_time_metadata_loader_get_title (_tmp4_);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp5_;
		_g_free0 (self->priv->comment);
		self->priv->comment = NULL;
		_quick_time_metadata_loader_unref0 (quicktime);
		return;
	}
	_tmp6_ = avi_metadata_loader_new (file);
	avi = _tmp6_;
	_tmp7_ = avi;
	if (avi_metadata_loader_is_supported (_tmp7_)) {
		AVIMetadataLoader* _tmp8_;
		MetadataDateTime* _tmp9_;
		AVIMetadataLoader* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = avi;
		_tmp9_ = avi_metadata_loader_get_creation_date_time (_tmp8_);
		_metadata_date_time_unref0 (self->priv->timestamp);
		self->priv->timestamp = _tmp9_;
		_tmp10_ = avi;
		_tmp11_ = avi_metadata_loader_get_title (_tmp10_);
		_g_free0 (self->priv->title);
		self->priv->title = _tmp11_;
		_g_free0 (self->priv->comment);
		self->priv->comment = NULL;
		_avi_metadata_loader_unref0 (avi);
		_quick_time_metadata_loader_unref0 (quicktime);
		return;
	}
	_tmp12_ = g_file_get_path (file);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "File %s is not a supported video format", _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_inner_error0_ = _tmp15_;
	g_propagate_error (error, _inner_error0_);
	_avi_metadata_loader_unref0 (avi);
	_quick_time_metadata_loader_unref0 (quicktime);
	return;
}

static gpointer
_metadata_date_time_ref0 (gpointer self)
{
	return self ? metadata_date_time_ref (self) : NULL;
}

static MetadataDateTime*
video_metadata_real_get_creation_date_time (MediaMetadata* base)
{
	VideoMetadata * self;
	MetadataDateTime* _tmp0_;
	MetadataDateTime* _tmp1_;
	MetadataDateTime* result;
	self = (VideoMetadata*) base;
	_tmp0_ = self->priv->timestamp;
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
video_metadata_real_get_title (MediaMetadata* base)
{
	VideoMetadata * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (VideoMetadata*) base;
	_tmp0_ = self->priv->title;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
video_metadata_real_get_comment (MediaMetadata* base)
{
	VideoMetadata * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (VideoMetadata*) base;
	_tmp0_ = self->priv->comment;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
video_metadata_class_init (VideoMetadataClass * klass,
                           gpointer klass_data)
{
	video_metadata_parent_class = g_type_class_peek_parent (klass);
	((MediaMetadataClass *) klass)->finalize = video_metadata_finalize;
	g_type_class_adjust_private_offset (klass, &VideoMetadata_private_offset);
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata*, GFile*, GError**)) video_metadata_real_read_from_file;
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata*)) video_metadata_real_get_creation_date_time;
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata*)) video_metadata_real_get_title;
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata*)) video_metadata_real_get_comment;
}

static void
video_metadata_instance_init (VideoMetadata * self,
                              gpointer klass)
{
	self->priv = video_metadata_get_instance_private (self);
	self->priv->timestamp = NULL;
	self->priv->title = NULL;
	self->priv->comment = NULL;
}

static void
video_metadata_finalize (MediaMetadata * obj)
{
	VideoMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_METADATA, VideoMetadata);
	_metadata_date_time_unref0 (self->priv->timestamp);
	_g_free0 (self->priv->title);
	_g_free0 (self->priv->comment);
	MEDIA_METADATA_CLASS (video_metadata_parent_class)->finalize (obj);
}

static GType
video_metadata_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMetadata), 0, (GInstanceInitFunc) video_metadata_instance_init, NULL };
	GType video_metadata_type_id;
	video_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "VideoMetadata", &g_define_type_info, 0);
	VideoMetadata_private_offset = g_type_add_instance_private (video_metadata_type_id, sizeof (VideoMetadataPrivate));
	return video_metadata_type_id;
}

GType
video_metadata_get_type (void)
{
	static volatile gsize video_metadata_type_id__once = 0;
	if (g_once_init_enter (&video_metadata_type_id__once)) {
		GType video_metadata_type_id;
		video_metadata_type_id = video_metadata_get_type_once ();
		g_once_init_leave (&video_metadata_type_id__once, video_metadata_type_id);
	}
	return video_metadata_type_id__once;
}

static inline gpointer
quick_time_metadata_loader_get_instance_private (QuickTimeMetadataLoader* self)
{
	return G_STRUCT_MEMBER_P (self, QuickTimeMetadataLoader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

QuickTimeMetadataLoader*
quick_time_metadata_loader_construct (GType object_type,
                                      GFile* file)
{
	QuickTimeMetadataLoader* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (QuickTimeMetadataLoader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

QuickTimeMetadataLoader*
quick_time_metadata_loader_new (GFile* file)
{
	return quick_time_metadata_loader_construct (TYPE_QUICK_TIME_METADATA_LOADER, file);
}

MetadataDateTime*
quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self)
{
	MetadataDateTime* _tmp0_;
	MetadataDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = metadata_date_time_new (quick_time_metadata_loader_get_creation_date_time_for_quicktime (self));
	result = _tmp0_;
	return result;
}

gchar*
quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}

gboolean
quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self)
{
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = quick_time_atom_new (_tmp0_);
	test = _tmp1_;
	ret = FALSE;
	{
		QuickTimeAtom* _tmp2_;
		QuickTimeAtom* _tmp3_;
		QuickTimeAtom* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = test;
		quick_time_atom_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = test;
		quick_time_atom_read_atom (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = test;
		_tmp5_ = quick_time_atom_get_current_atom_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 ("ftyp", _tmp6_) == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			ret = TRUE;
		} else {
			while (TRUE) {
				QuickTimeAtom* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				QuickTimeAtom* _tmp12_;
				QuickTimeAtom* _tmp13_;
				QuickTimeAtom* _tmp14_;
				_tmp8_ = test;
				_tmp9_ = quick_time_atom_get_current_atom_name (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 ("moov", _tmp10_) == 0;
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					ret = TRUE;
					break;
				}
				_tmp12_ = test;
				quick_time_atom_next_atom (_tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp13_ = test;
				quick_time_atom_read_atom (_tmp13_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp14_ = test;
				if (quick_time_atom_is_last_atom (_tmp14_)) {
					break;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = self->priv->file;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_debug ("VideoMetadata.vala:116: Error while testing for QuickTime file for %s:" \
" %s", _tmp17_, _tmp19_);
		_g_free0 (_tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp20_ = FALSE;
		_quick_time_atom_unref0 (test);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp20_;
	}
	{
		QuickTimeAtom* _tmp21_;
		_tmp21_ = test;
		quick_time_atom_close_file (_tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_debug ("VideoMetadata.vala:122: Error while closing Quicktime file: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp24_ = FALSE;
		_quick_time_atom_unref0 (test);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp24_;
	}
	result = ret;
	_quick_time_atom_unref0 (test);
	return result;
}

static gint64
quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self)
{
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	gint64 timestamp = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->file;
	_tmp1_ = quick_time_atom_new (_tmp0_);
	test = _tmp1_;
	timestamp = (gint64) 0;
	{
		QuickTimeAtom* _tmp2_;
		gboolean done = FALSE;
		_tmp2_ = test;
		quick_time_atom_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		done = FALSE;
		while (TRUE) {
			QuickTimeAtom* _tmp3_;
			QuickTimeAtom* _tmp4_;
			QuickTimeAtom* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			QuickTimeAtom* _tmp23_;
			if (!(!done)) {
				break;
			}
			_tmp3_ = test;
			quick_time_atom_read_atom (_tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = test;
			if (quick_time_atom_is_last_atom (_tmp4_)) {
				break;
			}
			_tmp5_ = test;
			_tmp6_ = quick_time_atom_get_current_atom_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 ("moov", _tmp7_) == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				QuickTimeAtom* child = NULL;
				QuickTimeAtom* _tmp9_;
				QuickTimeAtom* _tmp10_;
				_tmp9_ = test;
				_tmp10_ = quick_time_atom_get_first_child_atom (_tmp9_);
				child = _tmp10_;
				while (TRUE) {
					QuickTimeAtom* _tmp11_;
					gboolean _tmp12_ = FALSE;
					QuickTimeAtom* _tmp13_;
					QuickTimeAtom* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_;
					QuickTimeAtom* _tmp22_;
					if (!(!done)) {
						break;
					}
					_tmp11_ = child;
					quick_time_atom_read_atom (_tmp11_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_quick_time_atom_unref0 (child);
						goto __catch0_g_error;
					}
					_tmp13_ = child;
					if (quick_time_atom_is_last_atom (_tmp13_)) {
						_tmp12_ = TRUE;
					} else {
						QuickTimeAtom* _tmp14_;
						_tmp14_ = child;
						_tmp12_ = ((guint64) 0) == quick_time_atom_section_size_remaining (_tmp14_);
					}
					if (_tmp12_) {
						done = TRUE;
						break;
					}
					_tmp15_ = child;
					_tmp16_ = quick_time_atom_get_current_atom_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strcmp0 ("mvhd", _tmp17_) == 0;
					_g_free0 (_tmp17_);
					if (_tmp18_) {
						QuickTimeAtom* _tmp19_;
						guint32 _tmp20_ = 0U;
						QuickTimeAtom* _tmp21_;
						_tmp19_ = child;
						quick_time_atom_read_uint32 (_tmp19_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_quick_time_atom_unref0 (child);
							goto __catch0_g_error;
						}
						_tmp21_ = child;
						_tmp20_ = quick_time_atom_read_uint32 (_tmp21_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_quick_time_atom_unref0 (child);
							goto __catch0_g_error;
						}
						timestamp = _tmp20_ - QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
						done = TRUE;
						break;
					}
					_tmp22_ = child;
					quick_time_atom_next_atom (_tmp22_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_quick_time_atom_unref0 (child);
						goto __catch0_g_error;
					}
				}
				_quick_time_atom_unref0 (child);
			}
			_tmp23_ = test;
			quick_time_atom_next_atom (_tmp23_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_debug ("VideoMetadata.vala:162: Error while testing for QuickTime file: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp26_ = -1LL;
		_quick_time_atom_unref0 (test);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp26_;
	}
	{
		QuickTimeAtom* _tmp27_;
		_tmp27_ = test;
		quick_time_atom_close_file (_tmp27_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_debug ("VideoMetadata.vala:168: Error while closing Quicktime file: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp30_ = -1LL;
		_quick_time_atom_unref0 (test);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp30_;
	}
	if (timestamp < ((gint64) 0)) {
		timestamp += QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
	}
	result = timestamp;
	_quick_time_atom_unref0 (test);
	return result;
}

static void
value_quick_time_metadata_loader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_quick_time_metadata_loader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		quick_time_metadata_loader_unref (value->data[0].v_pointer);
	}
}

static void
value_quick_time_metadata_loader_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = quick_time_metadata_loader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_quick_time_metadata_loader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_quick_time_metadata_loader_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QuickTimeMetadataLoader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = quick_time_metadata_loader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_quick_time_metadata_loader_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	QuickTimeMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = quick_time_metadata_loader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_quick_time_metadata_loader (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecQuickTimeMetadataLoader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_quick_time_metadata_loader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_quick_time_metadata_loader (GValue* value,
                                      gpointer v_object)
{
	QuickTimeMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		quick_time_metadata_loader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_metadata_loader_unref (old);
	}
}

void
value_take_quick_time_metadata_loader (GValue* value,
                                       gpointer v_object)
{
	QuickTimeMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_metadata_loader_unref (old);
	}
}

static void
quick_time_metadata_loader_class_init (QuickTimeMetadataLoaderClass * klass,
                                       gpointer klass_data)
{
	quick_time_metadata_loader_parent_class = g_type_class_peek_parent (klass);
	((QuickTimeMetadataLoaderClass *) klass)->finalize = quick_time_metadata_loader_finalize;
	g_type_class_adjust_private_offset (klass, &QuickTimeMetadataLoader_private_offset);
}

static void
quick_time_metadata_loader_instance_init (QuickTimeMetadataLoader * self,
                                          gpointer klass)
{
	self->priv = quick_time_metadata_loader_get_instance_private (self);
	self->priv->file = NULL;
	self->ref_count = 1;
}

static void
quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj)
{
	QuickTimeMetadataLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
}

static GType
quick_time_metadata_loader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_quick_time_metadata_loader_init, value_quick_time_metadata_loader_free_value, value_quick_time_metadata_loader_copy_value, value_quick_time_metadata_loader_peek_pointer, "p", value_quick_time_metadata_loader_collect_value, "p", value_quick_time_metadata_loader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QuickTimeMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeMetadataLoader), 0, (GInstanceInitFunc) quick_time_metadata_loader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType quick_time_metadata_loader_type_id;
	quick_time_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	QuickTimeMetadataLoader_private_offset = g_type_add_instance_private (quick_time_metadata_loader_type_id, sizeof (QuickTimeMetadataLoaderPrivate));
	return quick_time_metadata_loader_type_id;
}

GType
quick_time_metadata_loader_get_type (void)
{
	static volatile gsize quick_time_metadata_loader_type_id__once = 0;
	if (g_once_init_enter (&quick_time_metadata_loader_type_id__once)) {
		GType quick_time_metadata_loader_type_id;
		quick_time_metadata_loader_type_id = quick_time_metadata_loader_get_type_once ();
		g_once_init_leave (&quick_time_metadata_loader_type_id__once, quick_time_metadata_loader_type_id);
	}
	return quick_time_metadata_loader_type_id__once;
}

gpointer
quick_time_metadata_loader_ref (gpointer instance)
{
	QuickTimeMetadataLoader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
quick_time_metadata_loader_unref (gpointer instance)
{
	QuickTimeMetadataLoader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QUICK_TIME_METADATA_LOADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
quick_time_atom_get_instance_private (QuickTimeAtom* self)
{
	return G_STRUCT_MEMBER_P (self, QuickTimeAtom_private_offset);
}

QuickTimeAtom*
quick_time_atom_construct (GType object_type,
                           GFile* file)
{
	QuickTimeAtom* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

QuickTimeAtom*
quick_time_atom_new (GFile* file)
{
	return quick_time_atom_construct (TYPE_QUICK_TIME_ATOM, file);
}

static gpointer
_quick_time_atom_ref0 (gpointer self)
{
	return self ? quick_time_atom_ref (self) : NULL;
}

static QuickTimeAtom*
quick_time_atom_construct_with_input_stream (GType object_type,
                                             GDataInputStream* input,
                                             QuickTimeAtom* parent)
{
	QuickTimeAtom* self = NULL;
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (input);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = _quick_time_atom_ref0 (parent);
	_quick_time_atom_unref0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}

static QuickTimeAtom*
quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                       QuickTimeAtom* parent)
{
	return quick_time_atom_construct_with_input_stream (TYPE_QUICK_TIME_ATOM, input, parent);
}

void
quick_time_atom_open_file (QuickTimeAtom* self,
                           GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	quick_time_atom_close_file (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp3_;
	_tmp4_ = self->priv->input;
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp5_;
	_g_object_unref0 (_tmp0_);
}

void
quick_time_atom_close_file (QuickTimeAtom* self,
                            GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input;
	if (NULL != _tmp0_) {
		GDataInputStream* _tmp1_;
		_tmp1_ = self->priv->input;
		g_input_stream_close ((GInputStream*) _tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->input);
		self->priv->input = NULL;
	}
}

static void
quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                        guint64 amount)
{
	QuickTimeAtom* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->section_offset = self->priv->section_offset + amount;
	_tmp0_ = self->priv->parent;
	if (NULL != _tmp0_) {
		QuickTimeAtom* _tmp1_;
		_tmp1_ = self->priv->parent;
		quick_time_atom_advance_section_offset (_tmp1_, amount);
	}
}

QuickTimeAtom*
quick_time_atom_get_first_child_atom (QuickTimeAtom* self)
{
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
	QuickTimeAtom* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->input;
	_tmp1_ = quick_time_atom_new_with_input_stream (_tmp0_, self);
	result = _tmp1_;
	return result;
}

guchar
quick_time_atom_read_byte (QuickTimeAtom* self,
                           GError** error)
{
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guchar result;
	g_return_val_if_fail (self != NULL, '\0');
	quick_time_atom_advance_section_offset (self, (guint64) 1);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guchar _tmp2_ = '\0';
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = (guchar) _tmp0_;
	return result;
}

guint32
quick_time_atom_read_uint32 (QuickTimeAtom* self,
                             GError** error)
{
	guint32 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	quick_time_atom_advance_section_offset (self, (guint64) 4);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint32 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp2_ = 0U;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

guint64
quick_time_atom_read_uint64 (QuickTimeAtom* self,
                             GError** error)
{
	guint64 _tmp0_ = 0ULL;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	quick_time_atom_advance_section_offset (self, (guint64) 8);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint64 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp2_ = 0ULL;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

void
quick_time_atom_read_atom (QuickTimeAtom* self,
                           GError** error)
{
	guint32 _tmp0_ = 0U;
	GString* sb = NULL;
	GString* _tmp1_;
	guchar _tmp2_ = '\0';
	GString* _tmp3_;
	guchar _tmp4_ = '\0';
	GString* _tmp5_;
	guchar _tmp6_ = '\0';
	GString* _tmp7_;
	guchar _tmp8_ = '\0';
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = quick_time_atom_read_uint32 (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) _tmp0_;
	_tmp1_ = g_string_new ("");
	sb = _tmp1_;
	_tmp2_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp3_ = sb;
	g_string_append_c (_tmp3_, (gchar) _tmp2_);
	_tmp4_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp5_ = sb;
	g_string_append_c (_tmp5_, (gchar) _tmp4_);
	_tmp6_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp7_ = sb;
	g_string_append_c (_tmp7_, (gchar) _tmp6_);
	_tmp8_ = quick_time_atom_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp9_ = sb;
	g_string_append_c (_tmp9_, (gchar) _tmp8_);
	_tmp10_ = sb;
	_tmp11_ = _tmp10_->str;
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp12_;
	_tmp13_ = self->priv->section_name;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 4) {
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		GError* _tmp20_;
		_tmp16_ = self->priv->file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "QuickTime atom name length is invalid for %s", _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_inner_error0_ = _tmp20_;
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				const gchar* _tmp26_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = self->priv->section_name;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				if (!(i < _tmp25_)) {
					break;
				}
				_tmp26_ = self->priv->section_name;
				if (!g_ascii_isprint (string_get (_tmp26_, (glong) i))) {
					GFile* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					GError* _tmp30_;
					GError* _tmp31_;
					_tmp27_ = self->priv->file;
					_tmp28_ = g_file_get_path (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Bad QuickTime atom in file %s", _tmp29_);
					_tmp31_ = _tmp30_;
					_g_free0 (_tmp29_);
					_inner_error0_ = _tmp31_;
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (sb);
					return;
				}
			}
		}
	}
	if (((guint64) 1) == self->priv->section_size) {
		guint64 _tmp32_ = 0ULL;
		_tmp32_ = quick_time_atom_read_uint64 (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return;
		}
		self->priv->section_size = _tmp32_;
	}
	_g_string_free0 (sb);
}

static void
quick_time_atom_skip (QuickTimeAtom* self,
                      guint64 skip_amount,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input;
	skip_uint64 ((GInputStream*) _tmp0_, skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

guint64
quick_time_atom_section_size_remaining (QuickTimeAtom* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	_vala_assert (self->priv->section_size >= self->priv->section_offset, "section_size >= section_offset");
	result = self->priv->section_size - self->priv->section_offset;
	return result;
}

void
quick_time_atom_next_atom (QuickTimeAtom* self,
                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	quick_time_atom_skip (self, quick_time_atom_section_size_remaining (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
}

gchar*
quick_time_atom_get_current_atom_name (QuickTimeAtom* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->section_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
quick_time_atom_is_last_atom (QuickTimeAtom* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = ((guint64) 0) == self->priv->section_size;
	return result;
}

static void
value_quick_time_atom_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_quick_time_atom_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		quick_time_atom_unref (value->data[0].v_pointer);
	}
}

static void
value_quick_time_atom_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = quick_time_atom_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_quick_time_atom_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_quick_time_atom_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QuickTimeAtom * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = quick_time_atom_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_quick_time_atom_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	QuickTimeAtom ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = quick_time_atom_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_quick_time_atom (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecQuickTimeAtom* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_ATOM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_quick_time_atom (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_quick_time_atom (GValue* value,
                           gpointer v_object)
{
	QuickTimeAtom * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		quick_time_atom_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_atom_unref (old);
	}
}

void
value_take_quick_time_atom (GValue* value,
                            gpointer v_object)
{
	QuickTimeAtom * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		quick_time_atom_unref (old);
	}
}

static void
quick_time_atom_class_init (QuickTimeAtomClass * klass,
                            gpointer klass_data)
{
	quick_time_atom_parent_class = g_type_class_peek_parent (klass);
	((QuickTimeAtomClass *) klass)->finalize = quick_time_atom_finalize;
	g_type_class_adjust_private_offset (klass, &QuickTimeAtom_private_offset);
}

static void
quick_time_atom_instance_init (QuickTimeAtom * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = quick_time_atom_get_instance_private (self);
	self->priv->file = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->section_name = _tmp0_;
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	self->priv->input = NULL;
	self->priv->parent = NULL;
	self->ref_count = 1;
}

static void
quick_time_atom_finalize (QuickTimeAtom * obj)
{
	QuickTimeAtom * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_ATOM, QuickTimeAtom);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->section_name);
	_g_object_unref0 (self->priv->input);
	_quick_time_atom_unref0 (self->priv->parent);
}

static GType
quick_time_atom_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_quick_time_atom_init, value_quick_time_atom_free_value, value_quick_time_atom_copy_value, value_quick_time_atom_peek_pointer, "p", value_quick_time_atom_collect_value, "p", value_quick_time_atom_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QuickTimeAtomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_atom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeAtom), 0, (GInstanceInitFunc) quick_time_atom_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType quick_time_atom_type_id;
	quick_time_atom_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeAtom", &g_define_type_info, &g_define_type_fundamental_info, 0);
	QuickTimeAtom_private_offset = g_type_add_instance_private (quick_time_atom_type_id, sizeof (QuickTimeAtomPrivate));
	return quick_time_atom_type_id;
}

GType
quick_time_atom_get_type (void)
{
	static volatile gsize quick_time_atom_type_id__once = 0;
	if (g_once_init_enter (&quick_time_atom_type_id__once)) {
		GType quick_time_atom_type_id;
		quick_time_atom_type_id = quick_time_atom_get_type_once ();
		g_once_init_leave (&quick_time_atom_type_id__once, quick_time_atom_type_id);
	}
	return quick_time_atom_type_id__once;
}

gpointer
quick_time_atom_ref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
quick_time_atom_unref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QUICK_TIME_ATOM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
avi_metadata_loader_get_instance_private (AVIMetadataLoader* self)
{
	return G_STRUCT_MEMBER_P (self, AVIMetadataLoader_private_offset);
}

AVIMetadataLoader*
avi_metadata_loader_construct (GType object_type,
                               GFile* file)
{
	AVIMetadataLoader* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (AVIMetadataLoader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

AVIMetadataLoader*
avi_metadata_loader_new (GFile* file)
{
	return avi_metadata_loader_construct (TYPE_AVI_METADATA_LOADER, file);
}

MetadataDateTime*
avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self)
{
	MetadataDateTime* _tmp0_;
	MetadataDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = metadata_date_time_new (avi_metadata_loader_get_creation_date_time_for_avi (self));
	result = _tmp0_;
	return result;
}

gchar*
avi_metadata_loader_get_title (AVIMetadataLoader* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}

gboolean
avi_metadata_loader_is_supported (AVIMetadataLoader* self)
{
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = avi_chunk_new (_tmp0_);
	chunk = _tmp1_;
	ret = FALSE;
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gboolean _tmp4_ = FALSE;
		AVIChunk* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp2_ = chunk;
		avi_chunk_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = chunk;
		avi_chunk_read_chunk (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = chunk;
		_tmp6_ = avi_chunk_get_current_chunk_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 ("RIFF", _tmp7_) == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_ = NULL;
			AVIChunk* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = chunk;
			_tmp11_ = avi_chunk_read_name (_tmp10_, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = g_strcmp0 ("AVI ", _tmp9_) == 0;
			_g_free0 (_tmp9_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ret = TRUE;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_debug ("VideoMetadata.vala:344: Error while testing for AVI file: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	{
		AVIChunk* _tmp15_;
		_tmp15_ = chunk;
		avi_chunk_close_file (_tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("VideoMetadata.vala:350: Error while closing AVI file: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	result = ret;
	_avi_chunk_unref0 (chunk);
	return result;
}

static gchar*
avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error)
{
	gboolean found_date = FALSE;
	gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	found_date = FALSE;
	while (TRUE) {
		guint16 tag = 0U;
		guint16 size = 0U;
		if (!(avi_chunk_section_size_remaining (chunk) > ((guint64) (sizeof (guint16) * 2)))) {
			break;
		}
		tag = avi_chunk_read_uint16 (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		size = avi_chunk_read_uint16 (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		if (AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER == tag) {
			found_date = TRUE;
			break;
		}
		avi_chunk_skip (chunk, (guint64) size, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
	}
	if (found_date) {
		GString* sb = NULL;
		GString* _tmp0_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = g_string_new ("");
		sb = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					guchar _tmp3_ = '\0';
					GString* _tmp4_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH)) {
						break;
					}
					_tmp3_ = avi_chunk_read_byte (chunk, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (sb);
						return NULL;
					}
					_tmp4_ = sb;
					g_string_append_c (_tmp4_, (gchar) _tmp3_);
				}
			}
		}
		_tmp5_ = sb;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_string_free0 (sb);
		return result;
	}
	_tmp8_ = g_strdup ("");
	result = _tmp8_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                        AVIChunk* chunk,
                                        GError** error)
{
	gint colons = 0;
	gint post_colons = 0;
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	avi_chunk_skip (chunk, (guint64) 98, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	avi_chunk_skip (chunk, (guint64) 8, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	colons = 0;
	post_colons = 0;
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		guchar _tmp2_ = '\0';
		gchar c = '\0';
		GString* _tmp6_;
		if (colons <= 4) {
			_tmp1_ = post_colons < 2;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = avi_chunk_read_byte (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return NULL;
		}
		c = (gchar) _tmp2_;
		if (4 == colons) {
			gint _tmp3_;
			_tmp3_ = post_colons;
			post_colons = _tmp3_ + 1;
		}
		if (':' == c) {
			gint _tmp4_;
			_tmp4_ = colons;
			colons = _tmp4_ + 1;
		}
		if (g_ascii_isprint (c)) {
			GString* _tmp5_;
			_tmp5_ = sb;
			g_string_append_c (_tmp5_, c);
		}
		_tmp6_ = sb;
		if (_tmp6_->len > ((gssize) AVI_METADATA_LOADER_MAX_STRD_LENGTH)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			result = _tmp7_;
			_g_string_free0 (sb);
			return result;
		}
	}
	_tmp8_ = sb;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		result = _tmp12_;
		_g_string_free0 (sb);
		return result;
	}
	_tmp13_ = sb;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = sb;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = strlen (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_substring (_tmp14_, (glong) (_tmp18_ - AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH), (glong) -1);
	result = _tmp19_;
	_g_string_free0 (sb);
	return result;
}

static gchar*
avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                  AVIChunk* chunk,
                                  GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	while (TRUE) {
		gchar* name = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp13_;
		avi_chunk_read_chunk (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp0_ = avi_chunk_get_current_chunk_name (chunk);
		name = _tmp0_;
		_tmp1_ = name;
		if (g_strcmp0 ("IDIT", _tmp1_) == 0) {
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = avi_chunk_section_to_string (chunk, &_inner_error0_);
			_tmp2_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp4_ = _tmp2_;
			_tmp2_ = NULL;
			result = _tmp4_;
			_g_free0 (_tmp2_);
			_g_free0 (name);
			return result;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = name;
			if (g_strcmp0 ("nctg", _tmp5_) == 0) {
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = avi_metadata_loader_read_nikon_nctg_tag (self, chunk, &_inner_error0_);
				_tmp6_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (name);
					return NULL;
				}
				_tmp8_ = _tmp6_;
				_tmp6_ = NULL;
				result = _tmp8_;
				_g_free0 (_tmp6_);
				_g_free0 (name);
				return result;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = name;
				if (g_strcmp0 ("strd", _tmp9_) == 0) {
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = avi_metadata_loader_read_fuji_strd_tag (self, chunk, &_inner_error0_);
					_tmp10_ = _tmp11_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (name);
						return NULL;
					}
					_tmp12_ = _tmp10_;
					_tmp10_ = NULL;
					result = _tmp12_;
					_g_free0 (_tmp10_);
					_g_free0 (name);
					return result;
				}
			}
		}
		_tmp13_ = name;
		if (g_strcmp0 ("LIST", _tmp13_) == 0) {
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _result_ = NULL;
			AVIChunk* _tmp16_;
			AVIChunk* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = avi_chunk_read_name (chunk, &_inner_error0_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp16_ = avi_chunk_get_first_child_chunk (chunk);
			_tmp17_ = _tmp16_;
			_tmp18_ = avi_metadata_loader_read_section (self, _tmp17_, &_inner_error0_);
			_tmp19_ = _tmp18_;
			_avi_chunk_unref0 (_tmp17_);
			_result_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (name);
				return NULL;
			}
			_tmp20_ = _result_;
			if (NULL != _tmp20_) {
				result = _result_;
				_g_free0 (name);
				return result;
			}
			_g_free0 (_result_);
		}
		if (avi_chunk_is_last_chunk (chunk)) {
			_g_free0 (name);
			break;
		}
		avi_chunk_next_chunk (chunk, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (name);
			return NULL;
		}
		_g_free0 (name);
	}
	result = NULL;
	return result;
}

static gint64
avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                const gchar* sdate)
{
	gint _tmp0_;
	gint _tmp1_;
	GDateTime* dt = NULL;
	guint seconds = 0U;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint min = 0;
	gint sec = 0;
	gchar weekday[4] = {0};
	gchar monthstr[4] = {0};
	gint64 tm = 0LL;
	GDateTime* _tmp20_;
	gint64 _result_ = 0LL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (sdate != NULL, 0LL);
	_tmp0_ = strlen (sdate);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = (gint64) 0;
		return result;
	}
	seconds = (guint) 0;
	if (g_ascii_isdigit (string_get (sdate, (glong) 0))) {
		gchar* tmp = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _result_ = 0;
		const gchar* _tmp4_;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_;
		GDateTime* _tmp12_;
		_tmp2_ = g_strdup (sdate);
		tmp = _tmp2_;
		_tmp3_ = tmp;
		g_strcanon (_tmp3_, "0123456789 ", ' ');
		sec = 0;
		_tmp4_ = tmp;
		_tmp11_ = sscanf (_tmp4_, "%d %d %d %d %d %d", &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
		year = _tmp5_;
		month = _tmp6_;
		day = _tmp7_;
		hour = _tmp8_;
		min = _tmp9_;
		sec = _tmp10_;
		_result_ = _tmp11_;
		if (_result_ < 5) {
			result = (gint64) 0;
			_g_free0 (tmp);
			_g_date_time_unref0 (dt);
			return result;
		}
		_tmp12_ = g_date_time_new_local (year, month, day, hour, min, (gdouble) sec);
		_g_date_time_unref0 (dt);
		dt = _tmp12_;
		seconds = (guint) ((sec + (min * 60)) + (hour * 3600));
		_g_free0 (tmp);
	} else {
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_;
		GDateTime* _tmp19_;
		_tmp18_ = sscanf (sdate, "%3s %3s %d %d:%d:%d %d", weekday, monthstr, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
		day = _tmp13_;
		hour = _tmp14_;
		min = _tmp15_;
		sec = _tmp16_;
		year = _tmp17_;
		if (7 != _tmp18_) {
			result = (gint64) 0;
			_g_date_time_unref0 (dt);
			return result;
		}
		_tmp19_ = g_date_time_new_local (year, (gint) avi_metadata_loader_month_from_string (self, (const gchar*) monthstr), day, hour, min, (gdouble) sec);
		_g_date_time_unref0 (dt);
		dt = _tmp19_;
		seconds = (guint) ((sec + (min * 60)) + (hour * 3600));
	}
	_tmp20_ = dt;
	tm = g_date_time_to_unix (_tmp20_);
	_result_ = tm + seconds;
	if (_result_ < tm) {
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = self->priv->file;
		_tmp22_ = g_file_get_path (_tmp21_);
		_tmp23_ = _tmp22_;
		g_debug ("VideoMetadata.vala:499: Overflow for timestamp in video file %s", _tmp23_);
		_g_free0 (_tmp23_);
		result = (gint64) 0;
		_g_date_time_unref0 (dt);
		return result;
	}
	result = tm;
	_g_date_time_unref0 (dt);
	return result;
}

static GDateMonth
avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                       const gchar* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	GDateMonth result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jan")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JANUARY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("feb")))) {
		switch (0) {
			default:
			{
				result = G_DATE_FEBRUARY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("mar")))) {
		switch (0) {
			default:
			{
				result = G_DATE_MARCH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("apr")))) {
		switch (0) {
			default:
			{
				result = G_DATE_APRIL;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("may")))) {
		switch (0) {
			default:
			{
				result = G_DATE_MAY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("jun")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JUNE;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("jul")))) {
		switch (0) {
			default:
			{
				result = G_DATE_JULY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("aug")))) {
		switch (0) {
			default:
			{
				result = G_DATE_AUGUST;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("sep")))) {
		switch (0) {
			default:
			{
				result = G_DATE_SEPTEMBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("oct")))) {
		switch (0) {
			default:
			{
				result = G_DATE_OCTOBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("nov")))) {
		switch (0) {
			default:
			{
				result = G_DATE_NOVEMBER;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("dec")))) {
		switch (0) {
			default:
			{
				result = G_DATE_DECEMBER;
				return result;
			}
		}
	}
	result = G_DATE_BAD_MONTH;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gint64
avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self)
{
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gint64 timestamp = 0LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->file;
	_tmp1_ = avi_chunk_new (_tmp0_);
	chunk = _tmp1_;
	timestamp = (gint64) 0;
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gchar* sdate = NULL;
		AVIChunk* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = chunk;
		avi_chunk_open_file (_tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = chunk;
		avi_chunk_nonsection_skip (_tmp3_, (guint64) 12, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = chunk;
		_tmp5_ = avi_metadata_loader_read_section (self, _tmp4_, &_inner_error0_);
		sdate = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = sdate;
		if (NULL != _tmp6_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = sdate;
			_tmp8_ = string_strip (_tmp7_);
			_tmp9_ = _tmp8_;
			timestamp = avi_metadata_loader_parse_date (self, _tmp9_);
			_g_free0 (_tmp9_);
		}
		_g_free0 (sdate);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_debug ("VideoMetadata.vala:547: Error while reading AVI file: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp12_ = -1LL;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	{
		AVIChunk* _tmp13_;
		_tmp13_ = chunk;
		avi_chunk_close_file (_tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_debug ("VideoMetadata.vala:553: Error while closing AVI file: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp16_ = -1LL;
		_avi_chunk_unref0 (chunk);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
	result = timestamp;
	_avi_chunk_unref0 (chunk);
	return result;
}

static void
value_avi_metadata_loader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_avi_metadata_loader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		avi_metadata_loader_unref (value->data[0].v_pointer);
	}
}

static void
value_avi_metadata_loader_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = avi_metadata_loader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_avi_metadata_loader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_avi_metadata_loader_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AVIMetadataLoader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = avi_metadata_loader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_avi_metadata_loader_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	AVIMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = avi_metadata_loader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_avi_metadata_loader (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecAVIMetadataLoader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_METADATA_LOADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_avi_metadata_loader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_avi_metadata_loader (GValue* value,
                               gpointer v_object)
{
	AVIMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		avi_metadata_loader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_metadata_loader_unref (old);
	}
}

void
value_take_avi_metadata_loader (GValue* value,
                                gpointer v_object)
{
	AVIMetadataLoader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_metadata_loader_unref (old);
	}
}

static void
avi_metadata_loader_class_init (AVIMetadataLoaderClass * klass,
                                gpointer klass_data)
{
	avi_metadata_loader_parent_class = g_type_class_peek_parent (klass);
	((AVIMetadataLoaderClass *) klass)->finalize = avi_metadata_loader_finalize;
	g_type_class_adjust_private_offset (klass, &AVIMetadataLoader_private_offset);
}

static void
avi_metadata_loader_instance_init (AVIMetadataLoader * self,
                                   gpointer klass)
{
	self->priv = avi_metadata_loader_get_instance_private (self);
	self->priv->file = NULL;
	self->ref_count = 1;
}

static void
avi_metadata_loader_finalize (AVIMetadataLoader * obj)
{
	AVIMetadataLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_METADATA_LOADER, AVIMetadataLoader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
}

static GType
avi_metadata_loader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_avi_metadata_loader_init, value_avi_metadata_loader_free_value, value_avi_metadata_loader_copy_value, value_avi_metadata_loader_peek_pointer, "p", value_avi_metadata_loader_collect_value, "p", value_avi_metadata_loader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AVIMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIMetadataLoader), 0, (GInstanceInitFunc) avi_metadata_loader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType avi_metadata_loader_type_id;
	avi_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AVIMetadataLoader_private_offset = g_type_add_instance_private (avi_metadata_loader_type_id, sizeof (AVIMetadataLoaderPrivate));
	return avi_metadata_loader_type_id;
}

GType
avi_metadata_loader_get_type (void)
{
	static volatile gsize avi_metadata_loader_type_id__once = 0;
	if (g_once_init_enter (&avi_metadata_loader_type_id__once)) {
		GType avi_metadata_loader_type_id;
		avi_metadata_loader_type_id = avi_metadata_loader_get_type_once ();
		g_once_init_leave (&avi_metadata_loader_type_id__once, avi_metadata_loader_type_id);
	}
	return avi_metadata_loader_type_id__once;
}

gpointer
avi_metadata_loader_ref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
avi_metadata_loader_unref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AVI_METADATA_LOADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
avi_chunk_get_instance_private (AVIChunk* self)
{
	return G_STRUCT_MEMBER_P (self, AVIChunk_private_offset);
}

AVIChunk*
avi_chunk_construct (GType object_type,
                     GFile* file)
{
	AVIChunk* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (AVIChunk*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

AVIChunk*
avi_chunk_new (GFile* file)
{
	return avi_chunk_construct (TYPE_AVI_CHUNK, file);
}

static gpointer
_avi_chunk_ref0 (gpointer self)
{
	return self ? avi_chunk_ref (self) : NULL;
}

static AVIChunk*
avi_chunk_construct_with_input_stream (GType object_type,
                                       GDataInputStream* input,
                                       AVIChunk* parent)
{
	AVIChunk* self = NULL;
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (AVIChunk*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (input);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = _avi_chunk_ref0 (parent);
	_avi_chunk_unref0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}

static AVIChunk*
avi_chunk_new_with_input_stream (GDataInputStream* input,
                                 AVIChunk* parent)
{
	return avi_chunk_construct_with_input_stream (TYPE_AVI_CHUNK, input, parent);
}

void
avi_chunk_open_file (AVIChunk* self,
                     GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	avi_chunk_close_file (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	_g_object_unref0 (self->priv->input);
	self->priv->input = _tmp3_;
	_tmp4_ = self->priv->input;
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp5_;
	_g_object_unref0 (_tmp0_);
}

void
avi_chunk_close_file (AVIChunk* self,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input;
	if (NULL != _tmp0_) {
		GDataInputStream* _tmp1_;
		_tmp1_ = self->priv->input;
		g_input_stream_close ((GInputStream*) _tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_g_object_unref0 (self->priv->input);
		self->priv->input = NULL;
	}
}

void
avi_chunk_nonsection_skip (AVIChunk* self,
                           guint64 skip_amount,
                           GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input;
	skip_uint64 ((GInputStream*) _tmp0_, skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
avi_chunk_skip (AVIChunk* self,
                guint64 skip_amount,
                GError** error)
{
	GDataInputStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	avi_chunk_advance_section_offset (self, skip_amount);
	_tmp0_ = self->priv->input;
	skip_uint64 ((GInputStream*) _tmp0_, skip_amount, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

AVIChunk*
avi_chunk_get_first_child_chunk (AVIChunk* self)
{
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
	AVIChunk* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->input;
	_tmp1_ = avi_chunk_new_with_input_stream (_tmp0_, self);
	result = _tmp1_;
	return result;
}

static void
avi_chunk_advance_section_offset (AVIChunk* self,
                                  guint64 amount)
{
	AVIChunk* _tmp0_;
	g_return_if_fail (self != NULL);
	if ((self->priv->section_offset + amount) > self->priv->section_size) {
		amount = self->priv->section_size - self->priv->section_offset;
	}
	self->priv->section_offset = self->priv->section_offset + amount;
	_tmp0_ = self->priv->parent;
	if (NULL != _tmp0_) {
		AVIChunk* _tmp1_;
		_tmp1_ = self->priv->parent;
		avi_chunk_advance_section_offset (_tmp1_, amount);
	}
}

guchar
avi_chunk_read_byte (AVIChunk* self,
                     GError** error)
{
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guchar result;
	g_return_val_if_fail (self != NULL, '\0');
	avi_chunk_advance_section_offset (self, (guint64) 1);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guchar _tmp2_ = '\0';
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = (guchar) _tmp0_;
	return result;
}

guint16
avi_chunk_read_uint16 (AVIChunk* self,
                       GError** error)
{
	guint16 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError* _inner_error0_ = NULL;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	avi_chunk_advance_section_offset (self, (guint64) 2);
	_tmp1_ = self->priv->input;
	_tmp0_ = g_data_input_stream_read_uint16 (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint16 _tmp2_ = 0U;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

void
avi_chunk_read_chunk (AVIChunk* self,
                      GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guint8 _tmp1_ = 0U;
	GDataInputStream* _tmp2_;
	GString* _tmp3_;
	guint8 _tmp4_ = 0U;
	GDataInputStream* _tmp5_;
	GString* _tmp6_;
	guint8 _tmp7_ = 0U;
	GDataInputStream* _tmp8_;
	GString* _tmp9_;
	guint8 _tmp10_ = 0U;
	GDataInputStream* _tmp11_;
	GString* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint32 _tmp16_ = 0U;
	GDataInputStream* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	_tmp2_ = self->priv->input;
	_tmp1_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp3_ = sb;
	g_string_append_c (_tmp3_, (gchar) _tmp1_);
	_tmp5_ = self->priv->input;
	_tmp4_ = g_data_input_stream_read_byte (_tmp5_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp6_ = sb;
	g_string_append_c (_tmp6_, (gchar) _tmp4_);
	_tmp8_ = self->priv->input;
	_tmp7_ = g_data_input_stream_read_byte (_tmp8_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp9_ = sb;
	g_string_append_c (_tmp9_, (gchar) _tmp7_);
	_tmp11_ = self->priv->input;
	_tmp10_ = g_data_input_stream_read_byte (_tmp11_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	_tmp12_ = sb;
	g_string_append_c (_tmp12_, (gchar) _tmp10_);
	_tmp13_ = sb;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->section_name);
	self->priv->section_name = _tmp15_;
	_tmp17_ = self->priv->input;
	_tmp16_ = g_data_input_stream_read_uint32 (_tmp17_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return;
	}
	self->priv->section_size = (guint64) _tmp16_;
	self->priv->section_offset = (guint64) 0;
	_g_string_free0 (sb);
}

gchar*
avi_chunk_read_name (AVIChunk* self,
                     GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guchar _tmp1_ = '\0';
	GString* _tmp2_;
	guchar _tmp3_ = '\0';
	GString* _tmp4_;
	guchar _tmp5_ = '\0';
	GString* _tmp6_;
	guchar _tmp7_ = '\0';
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	_tmp1_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp2_ = sb;
	g_string_append_c (_tmp2_, (gchar) _tmp1_);
	_tmp3_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp4_ = sb;
	g_string_append_c (_tmp4_, (gchar) _tmp3_);
	_tmp5_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp6_ = sb;
	g_string_append_c (_tmp6_, (gchar) _tmp5_);
	_tmp7_ = avi_chunk_read_byte (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_string_free0 (sb);
		return NULL;
	}
	_tmp8_ = sb;
	g_string_append_c (_tmp8_, (gchar) _tmp7_);
	_tmp9_ = sb;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_string_free0 (sb);
	return result;
}

void
avi_chunk_next_chunk (AVIChunk* self,
                      GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	avi_chunk_skip (self, avi_chunk_section_size_remaining (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
}

gchar*
avi_chunk_get_current_chunk_name (AVIChunk* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->section_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
avi_chunk_is_last_chunk (AVIChunk* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->section_size == ((guint64) 0);
	return result;
}

guint64
avi_chunk_section_size_remaining (AVIChunk* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	_vala_assert (self->priv->section_size >= self->priv->section_offset, "section_size >= section_offset");
	result = self->priv->section_size - self->priv->section_offset;
	return result;
}

gchar*
avi_chunk_section_to_string (AVIChunk* self,
                             GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	while (TRUE) {
		guchar _tmp1_ = '\0';
		GString* _tmp2_;
		GString* _tmp3_;
		if (!(self->priv->section_offset < self->priv->section_size)) {
			break;
		}
		_tmp1_ = avi_chunk_read_byte (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_string_free0 (sb);
			return NULL;
		}
		_tmp2_ = sb;
		g_string_append_c (_tmp2_, (gchar) _tmp1_);
		_tmp3_ = sb;
		if (_tmp3_->len > ((gssize) AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH)) {
			GString* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = sb;
			_tmp5_ = _tmp4_->str;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			_g_string_free0 (sb);
			return result;
		}
	}
	_tmp7_ = sb;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (sb);
	return result;
}

static void
value_avi_chunk_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_avi_chunk_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		avi_chunk_unref (value->data[0].v_pointer);
	}
}

static void
value_avi_chunk_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = avi_chunk_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_avi_chunk_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_avi_chunk_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AVIChunk * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = avi_chunk_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_avi_chunk_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	AVIChunk ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = avi_chunk_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_avi_chunk (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecAVIChunk* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_CHUNK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_avi_chunk (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_avi_chunk (GValue* value,
                     gpointer v_object)
{
	AVIChunk * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		avi_chunk_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_chunk_unref (old);
	}
}

void
value_take_avi_chunk (GValue* value,
                      gpointer v_object)
{
	AVIChunk * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		avi_chunk_unref (old);
	}
}

static void
avi_chunk_class_init (AVIChunkClass * klass,
                      gpointer klass_data)
{
	avi_chunk_parent_class = g_type_class_peek_parent (klass);
	((AVIChunkClass *) klass)->finalize = avi_chunk_finalize;
	g_type_class_adjust_private_offset (klass, &AVIChunk_private_offset);
}

static void
avi_chunk_instance_init (AVIChunk * self,
                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = avi_chunk_get_instance_private (self);
	self->priv->file = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->section_name = _tmp0_;
	self->priv->section_size = (guint64) 0;
	self->priv->section_offset = (guint64) 0;
	self->priv->input = NULL;
	self->priv->parent = NULL;
	self->ref_count = 1;
}

static void
avi_chunk_finalize (AVIChunk * obj)
{
	AVIChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_CHUNK, AVIChunk);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->section_name);
	_g_object_unref0 (self->priv->input);
	_avi_chunk_unref0 (self->priv->parent);
}

static GType
avi_chunk_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_avi_chunk_init, value_avi_chunk_free_value, value_avi_chunk_copy_value, value_avi_chunk_peek_pointer, "p", value_avi_chunk_collect_value, "p", value_avi_chunk_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AVIChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIChunk), 0, (GInstanceInitFunc) avi_chunk_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType avi_chunk_type_id;
	avi_chunk_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIChunk", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AVIChunk_private_offset = g_type_add_instance_private (avi_chunk_type_id, sizeof (AVIChunkPrivate));
	return avi_chunk_type_id;
}

GType
avi_chunk_get_type (void)
{
	static volatile gsize avi_chunk_type_id__once = 0;
	if (g_once_init_enter (&avi_chunk_type_id__once)) {
		GType avi_chunk_type_id;
		avi_chunk_type_id = avi_chunk_get_type_once ();
		g_once_init_leave (&avi_chunk_type_id__once, avi_chunk_type_id);
	}
	return avi_chunk_type_id__once;
}

gpointer
avi_chunk_ref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
avi_chunk_unref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AVI_CHUNK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

