/* FullScreenWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from FullScreenWindow.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FULLSCREEN_WINDOW_0_PROPERTY,
	FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY,
	FULLSCREEN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* fullscreen_window_properties[FULLSCREEN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SLIDESHOW_PAGE (slideshow_page_get_type ())
#define SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPage))
#define SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))
#define IS_SLIDESHOW_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLIDESHOW_PAGE))
#define IS_SLIDESHOW_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLIDESHOW_PAGE))
#define SLIDESHOW_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLIDESHOW_PAGE, SlideshowPageClass))

typedef struct _SlideshowPage SlideshowPage;
typedef struct _SlideshowPageClass SlideshowPageClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FullscreenWindowPrivate {
	GtkRevealer* revealer;
	GtkActionBar* toolbar;
	GtkToggleButton* pin_button;
	gint64 left_toolbar_time;
	gboolean switched_to;
	gboolean _auto_dismiss_toolbar;
};

static gint FullscreenWindow_private_offset;
static gpointer fullscreen_window_parent_class = NULL;

static void fullscreen_window_get_monitor_geometry (FullscreenWindow* self,
                                             GdkRectangle* result);
static void fullscreen_window_on_close (FullscreenWindow* self);
static void _fullscreen_window_on_close_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
VALA_EXTERN GType slideshow_page_get_type (void) G_GNUC_CONST ;
static void fullscreen_window_hide_toolbar (FullscreenWindow* self);
static void _fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar (SlideshowPage* _sender,
                                                                  gpointer self);
static void fullscreen_window_invoke_toolbar (FullscreenWindow* self);
static gboolean fullscreen_window_real_configure_event (GtkWidget* base,
                                                 GdkEventConfigure* event);
static gboolean fullscreen_window_real_key_press_event (GtkWidget* base,
                                                 GdkEventKey* event);
static void fullscreen_window_real_destroy (GtkWidget* base);
static gboolean fullscreen_window_real_delete_event (GtkWidget* base,
                                              GdkEventAny* event);
static gboolean fullscreen_window_real_motion_notify_event (GtkWidget* base,
                                                     GdkEventMotion* event);
static gboolean fullscreen_window_is_pointer_in_toolbar (FullscreenWindow* self);
static gboolean fullscreen_window_on_check_toolbar_dismissal (FullscreenWindow* self);
static gboolean _fullscreen_window_on_check_toolbar_dismissal_gsource_func (gpointer self);
static void fullscreen_window_finalize (GObject * obj);
static GType fullscreen_window_get_type_once (void);
static void _vala_fullscreen_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_fullscreen_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
fullscreen_window_get_instance_private (FullscreenWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FullscreenWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_fullscreen_window_on_close_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	fullscreen_window_on_close ((FullscreenWindow*) self);
}

static void
_fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar (SlideshowPage* _sender,
                                                             gpointer self)
{
	fullscreen_window_hide_toolbar ((FullscreenWindow*) self);
}

FullscreenWindow*
fullscreen_window_construct (GType object_type,
                             Page* page)
{
	FullscreenWindow * self = NULL;
	GtkUIManager* _tmp0_;
	GtkAccelGroup* accel_group = NULL;
	GtkUIManager* _tmp1_;
	GtkAccelGroup* _tmp2_;
	GtkAccelGroup* _tmp3_;
	GtkAccelGroup* _tmp4_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GdkScreen* _tmp8_;
	GdkRectangle monitor = {0};
	GdkRectangle _tmp9_ = {0};
	GdkRectangle _tmp10_;
	GdkRectangle _tmp11_;
	GtkToggleButton* _tmp12_;
	GtkToggleButton* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkToggleButton* _tmp16_;
	GtkToggleButton* _tmp17_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkActionBar* _tmp21_;
	GtkActionBar* _tmp22_;
	GtkActionBar* _tmp23_;
	GtkActionBar* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkActionBar* _tmp28_;
	GtkButton* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkRevealer* _tmp31_;
	GtkRevealer* _tmp32_;
	GtkRevealer* _tmp33_;
	GtkRevealer* _tmp34_;
	GtkActionBar* _tmp35_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp36_;
	GtkRevealer* _tmp37_;
	GdkRectangle _tmp38_;
	GdkRectangle _tmp39_;
	g_return_val_if_fail (page != NULL, NULL);
	self = (FullscreenWindow*) page_window_construct (object_type);
	page_window_set_current_page ((PageWindow*) self, page);
	_tmp0_ = ((PageWindow*) self)->ui;
	gtk_ui_manager_ensure_update (_tmp0_);
	_tmp1_ = ((PageWindow*) self)->ui;
	_tmp2_ = gtk_ui_manager_get_accel_group (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	accel_group = _tmp3_;
	_tmp4_ = accel_group;
	if (_tmp4_ != NULL) {
		GtkAccelGroup* _tmp5_;
		_tmp5_ = accel_group;
		gtk_window_add_accel_group ((GtkWindow*) self, _tmp5_);
	}
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_window_get_screen ((GtkWindow*) _tmp7_);
	gtk_window_set_screen ((GtkWindow*) self, _tmp8_);
	_g_object_unref0 (_tmp7_);
	fullscreen_window_get_monitor_geometry (self, &_tmp9_);
	monitor = _tmp9_;
	_tmp10_ = monitor;
	_tmp11_ = monitor;
	gtk_window_move ((GtkWindow*) self, _tmp10_.x, _tmp11_.y);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	_tmp12_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->pin_button);
	self->priv->pin_button = _tmp12_;
	_tmp13_ = self->priv->pin_button;
	_tmp14_ = (GtkImage*) gtk_image_new_from_icon_name ("view-pin-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = _tmp14_;
	gtk_button_set_image ((GtkButton*) _tmp13_, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->pin_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp16_, _ ("Pin the toolbar open"));
	_tmp17_ = self->priv->pin_button;
	g_object_bind_property_with_closures ((GObject*) _tmp17_, "active", (GObject*) self, "auto-dismiss-toolbar", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp18_ = (GtkButton*) gtk_button_new_from_icon_name ("window-restore-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp18_);
	close_button = _tmp18_;
	_tmp19_ = close_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("Leave fullscreen"));
	_tmp20_ = close_button;
	g_signal_connect_object (_tmp20_, "clicked", (GCallback) _fullscreen_window_on_close_gtk_button_clicked, self, 0);
	_tmp21_ = page_get_toolbar (page, NULL, GTK_PACK_START);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp21_;
	_tmp22_ = self->priv->toolbar;
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	_tmp23_ = self->priv->toolbar;
	g_object_set ((GtkWidget*) _tmp23_, "margin", 6, NULL);
	_tmp24_ = self->priv->toolbar;
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
	gtk_style_context_add_class (_tmp25_, "overlay-toolbar");
	if (IS_SLIDESHOW_PAGE (page)) {
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_SLIDESHOW_PAGE, SlideshowPage), "hide-toolbar", (GCallback) _fullscreen_window_hide_toolbar_slideshow_page_hide_toolbar, self, 0);
	} else {
		GtkActionBar* _tmp26_;
		GtkToggleButton* _tmp27_;
		_tmp26_ = self->priv->toolbar;
		_tmp27_ = self->priv->pin_button;
		gtk_action_bar_pack_end (_tmp26_, (GtkWidget*) _tmp27_);
	}
	page_set_cursor_hide_time (page, FULLSCREEN_WINDOW_TOOLBAR_DISMISSAL_SEC * 1000);
	page_start_cursor_hiding (page);
	_tmp28_ = self->priv->toolbar;
	_tmp29_ = close_button;
	gtk_action_bar_pack_end (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp30_;
	_tmp31_ = self->priv->revealer;
	gtk_widget_set_halign ((GtkWidget*) _tmp31_, GTK_ALIGN_CENTER);
	_tmp32_ = self->priv->revealer;
	gtk_widget_set_valign ((GtkWidget*) _tmp32_, GTK_ALIGN_END);
	_tmp33_ = self->priv->revealer;
	gtk_revealer_set_transition_type (_tmp33_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp34_ = self->priv->revealer;
	_tmp35_ = self->priv->toolbar;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp36_);
	overlay = _tmp36_;
	gtk_container_add ((GtkContainer*) overlay, (GtkWidget*) page);
	_tmp37_ = self->priv->revealer;
	gtk_overlay_add_overlay (overlay, (GtkWidget*) _tmp37_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) overlay);
	_tmp38_ = monitor;
	_tmp39_ = monitor;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp38_.width, _tmp39_.height);
	gtk_window_fullscreen ((GtkWindow*) self);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_POINTER_MOTION_MASK);
	fullscreen_window_invoke_toolbar (self);
	gtk_widget_grab_focus ((GtkWidget*) page);
	_g_object_unref0 (overlay);
	_g_object_unref0 (close_button);
	_g_object_unref0 (accel_group);
	return self;
}

FullscreenWindow*
fullscreen_window_new (Page* page)
{
	return fullscreen_window_construct (TYPE_FULLSCREEN_WINDOW, page);
}

static void
fullscreen_window_get_monitor_geometry (FullscreenWindow* self,
                                        GdkRectangle* result)
{
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkMonitor* _tmp6_;
	GdkRectangle _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = app_window_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) _tmp2_);
	_tmp4_ = gdk_display_get_monitor_at_window (_tmp0_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	monitor = _tmp6_;
	gdk_monitor_get_geometry (monitor, &_tmp7_);
	*result = _tmp7_;
	_g_object_unref0 (monitor);
	return;
}

static gboolean
fullscreen_window_real_configure_event (GtkWidget* base,
                                        GdkEventConfigure* event)
{
	FullscreenWindow * self;
	gboolean _result_ = FALSE;
	gboolean result;
	self = (FullscreenWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_result_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), event);
	if (!self->priv->switched_to) {
		Page* _tmp0_;
		Page* _tmp1_;
		_tmp0_ = page_window_get_current_page ((PageWindow*) self);
		_tmp1_ = _tmp0_;
		page_switched_to (_tmp1_);
		_g_object_unref0 (_tmp1_);
		self->priv->switched_to = TRUE;
	}
	result = _result_;
	return result;
}

static gboolean
fullscreen_window_real_key_press_event (GtkWidget* base,
                                        GdkEventKey* event)
{
	FullscreenWindow * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	self = (FullscreenWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("F11")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Escape"))))) {
		switch (0) {
			default:
			{
				fullscreen_window_on_close (self);
				result = TRUE;
				return result;
			}
		}
	}
	if (GTK_WIDGET_CLASS (fullscreen_window_parent_class)->key_press_event != NULL) {
		_tmp4_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), event);
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

static void
fullscreen_window_on_close (FullscreenWindow* self)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	fullscreen_window_hide_toolbar (self);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	app_window_end_fullscreen (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

void
fullscreen_window_close (FullscreenWindow* self)
{
	g_return_if_fail (self != NULL);
	fullscreen_window_on_close (self);
}

static void
fullscreen_window_real_destroy (GtkWidget* base)
{
	FullscreenWindow * self;
	Page* page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	self = (FullscreenWindow*) base;
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	page = _tmp0_;
	page_window_clear_current_page ((PageWindow*) self);
	_tmp1_ = page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		Page* _tmp3_;
		_tmp2_ = page;
		page_stop_cursor_hiding (_tmp2_);
		_tmp3_ = page;
		page_switching_from (_tmp3_);
	}
	GTK_WIDGET_CLASS (fullscreen_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow));
	_g_object_unref0 (page);
}

static gboolean
fullscreen_window_real_delete_event (GtkWidget* base,
                                     GdkEventAny* event)
{
	FullscreenWindow * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	gboolean result;
	self = (FullscreenWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	fullscreen_window_on_close (self);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
fullscreen_window_real_motion_notify_event (GtkWidget* base,
                                            GdkEventMotion* event)
{
	FullscreenWindow * self;
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	self = (FullscreenWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		fullscreen_window_invoke_toolbar (self);
	}
	if (GTK_WIDGET_CLASS (fullscreen_window_parent_class)->motion_notify_event != NULL) {
		_tmp3_ = GTK_WIDGET_CLASS (fullscreen_window_parent_class)->motion_notify_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE_WINDOW, PageWindow), event);
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}

static gboolean
fullscreen_window_is_pointer_in_toolbar (FullscreenWindow* self)
{
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	gint py = 0;
	GdkSeat* _tmp4_;
	GdkDevice* _tmp5_;
	gint _tmp6_ = 0;
	GtkAllocation toolbar_alloc = {0};
	GtkActionBar* _tmp7_;
	GtkAllocation _tmp8_ = {0};
	GdkRectangle screen_rect = {0};
	GdkRectangle _tmp9_ = {0};
	gint threshold = 0;
	GdkRectangle _tmp10_;
	GtkRevealer* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = seat;
	if (_tmp3_ == NULL) {
		g_debug ("FullScreenWindow.vala:175: No seat for display");
		result = FALSE;
		_g_object_unref0 (seat);
		return result;
	}
	_tmp4_ = seat;
	_tmp5_ = gdk_seat_get_pointer (_tmp4_);
	gdk_device_get_position (_tmp5_, NULL, NULL, &_tmp6_);
	py = _tmp6_;
	_tmp7_ = self->priv->toolbar;
	gtk_widget_get_allocation ((GtkWidget*) _tmp7_, &_tmp8_);
	toolbar_alloc = _tmp8_;
	fullscreen_window_get_monitor_geometry (self, &_tmp9_);
	screen_rect = _tmp9_;
	_tmp10_ = screen_rect;
	threshold = _tmp10_.height;
	_tmp11_ = self->priv->revealer;
	_tmp12_ = gtk_revealer_get_reveal_child (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GtkAllocation _tmp14_;
		_tmp14_ = toolbar_alloc;
		threshold -= _tmp14_.height;
	}
	result = py >= threshold;
	_g_object_unref0 (seat);
	return result;
}

static gboolean
_fullscreen_window_on_check_toolbar_dismissal_gsource_func (gpointer self)
{
	gboolean result;
	result = fullscreen_window_on_check_toolbar_dismissal ((FullscreenWindow*) self);
	return result;
}

static void
fullscreen_window_invoke_toolbar (FullscreenWindow* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) FULLSCREEN_WINDOW_TOOLBAR_CHECK_DISMISSAL_MSEC, _fullscreen_window_on_check_toolbar_dismissal_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
fullscreen_window_on_check_toolbar_dismissal (FullscreenWindow* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint64 now = 0LL;
	time_t _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = gtk_revealer_get_reveal_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_auto_dismiss_toolbar;
	if (!_tmp3_) {
		result = TRUE;
		return result;
	}
	if (fullscreen_window_is_pointer_in_toolbar (self)) {
		self->priv->left_toolbar_time = (gint64) 0;
		result = TRUE;
		return result;
	}
	if (self->priv->left_toolbar_time == ((gint64) 0)) {
		time_t _tmp4_;
		_tmp4_ = time (NULL);
		self->priv->left_toolbar_time = (gint64) _tmp4_;
		result = TRUE;
		return result;
	}
	_tmp5_ = time (NULL);
	now = (gint64) _tmp5_;
	_vala_assert (now >= self->priv->left_toolbar_time, "now >= left_toolbar_time");
	if ((now - self->priv->left_toolbar_time) < ((gint64) FULLSCREEN_WINDOW_TOOLBAR_DISMISSAL_SEC)) {
		result = TRUE;
		return result;
	}
	fullscreen_window_hide_toolbar (self);
	result = FALSE;
	return result;
}

static void
fullscreen_window_hide_toolbar (FullscreenWindow* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	self->priv->left_toolbar_time = (gint64) 0;
}

gboolean
fullscreen_window_get_auto_dismiss_toolbar (FullscreenWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_dismiss_toolbar;
	return result;
}

void
fullscreen_window_set_auto_dismiss_toolbar (FullscreenWindow* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = fullscreen_window_get_auto_dismiss_toolbar (self);
	if (old_value != value) {
		self->priv->_auto_dismiss_toolbar = value;
		g_object_notify_by_pspec ((GObject *) self, fullscreen_window_properties[FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY]);
	}
}

static void
fullscreen_window_class_init (FullscreenWindowClass * klass,
                              gpointer klass_data)
{
	fullscreen_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FullscreenWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) fullscreen_window_real_configure_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) fullscreen_window_real_key_press_event;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) fullscreen_window_real_destroy;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) fullscreen_window_real_delete_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) fullscreen_window_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_fullscreen_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_fullscreen_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = fullscreen_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY, fullscreen_window_properties[FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY] = g_param_spec_boolean ("auto-dismiss-toolbar", "auto-dismiss-toolbar", "auto-dismiss-toolbar", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
fullscreen_window_instance_init (FullscreenWindow * self,
                                 gpointer klass)
{
	self->priv = fullscreen_window_get_instance_private (self);
	self->priv->left_toolbar_time = (gint64) 0;
	self->priv->switched_to = FALSE;
	self->priv->_auto_dismiss_toolbar = TRUE;
}

static void
fullscreen_window_finalize (GObject * obj)
{
	FullscreenWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->pin_button);
	G_OBJECT_CLASS (fullscreen_window_parent_class)->finalize (obj);
}

static GType
fullscreen_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FullscreenWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fullscreen_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FullscreenWindow), 0, (GInstanceInitFunc) fullscreen_window_instance_init, NULL };
	GType fullscreen_window_type_id;
	fullscreen_window_type_id = g_type_register_static (TYPE_PAGE_WINDOW, "FullscreenWindow", &g_define_type_info, 0);
	FullscreenWindow_private_offset = g_type_add_instance_private (fullscreen_window_type_id, sizeof (FullscreenWindowPrivate));
	return fullscreen_window_type_id;
}

GType
fullscreen_window_get_type (void)
{
	static volatile gsize fullscreen_window_type_id__once = 0;
	if (g_once_init_enter (&fullscreen_window_type_id__once)) {
		GType fullscreen_window_type_id;
		fullscreen_window_type_id = fullscreen_window_get_type_once ();
		g_once_init_leave (&fullscreen_window_type_id__once, fullscreen_window_type_id);
	}
	return fullscreen_window_type_id__once;
}

static void
_vala_fullscreen_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	FullscreenWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	switch (property_id) {
		case FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY:
		g_value_set_boolean (value, fullscreen_window_get_auto_dismiss_toolbar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_fullscreen_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	FullscreenWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FULLSCREEN_WINDOW, FullscreenWindow);
	switch (property_id) {
		case FULLSCREEN_WINDOW_AUTO_DISMISS_TOOLBAR_PROPERTY:
		fullscreen_window_set_auto_dismiss_toolbar (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

