/* FoldersListView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FoldersListView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <camel/camel.h>
#include <gee.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#define MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE "compose_message"
#define MAIL_APPLICATION_ACTION_GROUP_PREFIX "app"
#define MAIL_APPLICATION_ACTION_PREFIX MAIL_APPLICATION_ACTION_GROUP_PREFIX "."
#define MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES "manage-signatures"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_FOLDERS_LIST_VIEW (mail_folders_list_view_get_type ())
#define MAIL_FOLDERS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView))
#define MAIL_FOLDERS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListViewClass))
#define MAIL_IS_FOLDERS_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW))
#define MAIL_IS_FOLDERS_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDERS_LIST_VIEW))
#define MAIL_FOLDERS_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListViewClass))

typedef struct _MailFoldersListView MailFoldersListView;
typedef struct _MailFoldersListViewClass MailFoldersListViewClass;
typedef struct _MailFoldersListViewPrivate MailFoldersListViewPrivate;

#define MAIL_TYPE_SOURCE_LIST (mail_source_list_get_type ())
#define MAIL_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SOURCE_LIST, MailSourceList))
#define MAIL_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SOURCE_LIST, MailSourceListClass))
#define MAIL_IS_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SOURCE_LIST))
#define MAIL_IS_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SOURCE_LIST))
#define MAIL_SOURCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SOURCE_LIST, MailSourceListClass))

typedef struct _MailSourceList MailSourceList;
typedef struct _MailSourceListClass MailSourceListClass;

#define MAIL_SOURCE_LIST_TYPE_ITEM (mail_source_list_item_get_type ())
#define MAIL_SOURCE_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItem))
#define MAIL_SOURCE_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))
#define MAIL_SOURCE_LIST_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_ITEM))
#define MAIL_SOURCE_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_ITEM, MailSourceListItemClass))

typedef struct _MailSourceListItem MailSourceListItem;
typedef struct _MailSourceListItemClass MailSourceListItemClass;

#define MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM (mail_source_list_expandable_item_get_type ())
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItem))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_IS_EXPANDABLE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM))
#define MAIL_SOURCE_LIST_EXPANDABLE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItemClass))

typedef struct _MailSourceListExpandableItem MailSourceListExpandableItem;
typedef struct _MailSourceListExpandableItemClass MailSourceListExpandableItemClass;

#define MAIL_TYPE_SESSION_SOURCE_ITEM (mail_session_source_item_get_type ())
#define MAIL_SESSION_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SESSION_SOURCE_ITEM, MailSessionSourceItem))
#define MAIL_SESSION_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SESSION_SOURCE_ITEM, MailSessionSourceItemClass))
#define MAIL_IS_SESSION_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SESSION_SOURCE_ITEM))
#define MAIL_IS_SESSION_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SESSION_SOURCE_ITEM))
#define MAIL_SESSION_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SESSION_SOURCE_ITEM, MailSessionSourceItemClass))

typedef struct _MailSessionSourceItem MailSessionSourceItem;
typedef struct _MailSessionSourceItemClass MailSessionSourceItemClass;
enum  {
	MAIL_FOLDERS_LIST_VIEW_0_PROPERTY,
	MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY,
	MAIL_FOLDERS_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* mail_folders_list_view_properties[MAIL_FOLDERS_LIST_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_BACKEND_TYPE_ACCOUNT (mail_backend_account_get_type ())
#define MAIL_BACKEND_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccount))
#define MAIL_BACKEND_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))
#define MAIL_BACKEND_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_ACCOUNT))
#define MAIL_BACKEND_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_ACCOUNT, MailBackendAccountClass))

typedef struct _MailBackendAccount MailBackendAccount;
typedef struct _MailBackendAccountClass MailBackendAccountClass;

#define MAIL_TYPE_ACCOUNT_SOURCE_ITEM (mail_account_source_item_get_type ())
#define MAIL_ACCOUNT_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItem))
#define MAIL_ACCOUNT_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItemClass))
#define MAIL_IS_ACCOUNT_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM))
#define MAIL_IS_ACCOUNT_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ACCOUNT_SOURCE_ITEM))
#define MAIL_ACCOUNT_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ACCOUNT_SOURCE_ITEM, MailAccountSourceItemClass))

typedef struct _MailAccountSourceItem MailAccountSourceItem;
typedef struct _MailAccountSourceItemClass MailAccountSourceItemClass;
typedef struct _Block43Data Block43Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAIL_TYPE_FOLDER_SOURCE_ITEM (mail_folder_source_item_get_type ())
#define MAIL_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem))
#define MAIL_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))
#define MAIL_IS_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_IS_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_FOLDER_SOURCE_ITEM))
#define MAIL_FOLDER_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItemClass))

typedef struct _MailFolderSourceItem MailFolderSourceItem;
typedef struct _MailFolderSourceItemClass MailFolderSourceItemClass;

#define MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM (mail_grouped_folder_source_item_get_type ())
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem))
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItemClass))
#define MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM))
#define MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM))
#define MAIL_GROUPED_FOLDER_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItemClass))

typedef struct _MailGroupedFolderSourceItem MailGroupedFolderSourceItem;
typedef struct _MailGroupedFolderSourceItemClass MailGroupedFolderSourceItemClass;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
enum  {
	MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL,
	MAIL_FOLDERS_LIST_VIEW_NUM_SIGNALS
};
static guint mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_NUM_SIGNALS] = {0};

struct _MailFoldersListView {
	GtkGrid parent_instance;
	MailFoldersListViewPrivate * priv;
};

struct _MailFoldersListViewClass {
	GtkGridClass parent_class;
};

struct _MailFoldersListViewPrivate {
	HdyHeaderBar* _header_bar;
	MailSourceList* source_list;
	MailSessionSourceItem* session_source_item;
};

struct _Block43Data {
	int _ref_count_;
	MailFoldersListView* self;
	MailAccountSourceItem* account_item;
	MailBackendAccount* account;
};

static gint MailFoldersListView_private_offset;
static gpointer mail_folders_list_view_parent_class = NULL;
static GSettings* mail_folders_list_view_settings;
static GSettings* mail_folders_list_view_settings = NULL;

VALA_EXTERN GType mail_folders_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFoldersListView, g_object_unref)
VALA_EXTERN GType mail_source_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceList, g_object_unref)
VALA_EXTERN GType mail_source_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListItem, g_object_unref)
VALA_EXTERN GType mail_source_list_expandable_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSourceListExpandableItem, g_object_unref)
VALA_EXTERN GType mail_session_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSessionSourceItem, g_object_unref)
VALA_EXTERN GType mail_backend_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendAccount, g_object_unref)
static void mail_folders_list_view_add_account (MailFoldersListView* self,
                                         MailBackendAccount* account);
VALA_EXTERN GType mail_account_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAccountSourceItem, g_object_unref)
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
VALA_EXTERN MailAccountSourceItem* mail_account_source_item_new (MailBackendAccount* account);
VALA_EXTERN MailAccountSourceItem* mail_account_source_item_construct (GType object_type,
                                                           MailBackendAccount* account);
static void __lambda34_ (MailFoldersListView* self,
                  MailSourceListItem* item);
VALA_EXTERN void mail_source_list_start_editing_item (MailSourceList* self,
                                          MailSourceListItem* item);
static void ___lambda34__mail_account_source_item_start_edit (MailAccountSourceItem* _sender,
                                                       MailSourceListItem* item,
                                                       gpointer self);
VALA_EXTERN MailSourceListExpandableItem* mail_source_list_get_root (MailSourceList* self);
VALA_EXTERN void mail_source_list_expandable_item_add (MailSourceListExpandableItem* self,
                                           MailSourceListItem* item);
VALA_EXTERN void mail_account_source_item_load (MailAccountSourceItem* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN void mail_account_source_item_load_finish (MailAccountSourceItem* self,
                                           GAsyncResult* _res_);
static void __lambda35_ (Block43Data* _data43_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN CamelService* mail_backend_account_get_service (MailBackendAccount* self);
static gboolean mail_folders_list_view_select_saved_folder (MailFoldersListView* self,
                                                     MailSourceListExpandableItem* item,
                                                     const gchar* selected_folder_name);
static void ___lambda35__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN GeeCollection* mail_source_list_expandable_item_get_children (MailSourceListExpandableItem* self);
VALA_EXTERN GType mail_folder_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailFolderSourceItem, g_object_unref)
VALA_EXTERN const gchar* mail_folder_source_item_get_full_name (MailFolderSourceItem* self);
VALA_EXTERN void mail_source_list_set_selected (MailSourceList* self,
                                    MailSourceListItem* value);
static CamelFolderInfo* _vala_CamelFolderInfo_copy (CamelFolderInfo* self);
static void _vala_CamelFolderInfo_free (CamelFolderInfo* self);
VALA_EXTERN MailBackendAccount* mail_folder_source_item_get_account (MailFolderSourceItem* self);
VALA_EXTERN CamelFolderInfo* mail_folder_source_item_get_folder_info (MailFolderSourceItem* self);
VALA_EXTERN GType mail_grouped_folder_source_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailGroupedFolderSourceItem, g_object_unref)
VALA_EXTERN const gchar* mail_source_list_item_get_name (MailSourceListItem* self);
VALA_EXTERN GeeMap* mail_grouped_folder_source_item_get_folder_info_per_account (MailGroupedFolderSourceItem* self);
VALA_EXTERN MailFoldersListView* mail_folders_list_view_new (void);
VALA_EXTERN MailFoldersListView* mail_folders_list_view_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* mail_folders_list_view_get_header_bar (MailFoldersListView* self);
static void mail_folders_list_view_set_header_bar (MailFoldersListView* self,
                                            HdyHeaderBar* value);
static GObject * mail_folders_list_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN MailSourceListExpandableItem* mail_source_list_expandable_item_new (const gchar* name);
VALA_EXTERN MailSourceListExpandableItem* mail_source_list_expandable_item_construct (GType object_type,
                                                                          const gchar* name);
VALA_EXTERN MailSourceList* mail_source_list_new (MailSourceListExpandableItem* root);
VALA_EXTERN MailSourceList* mail_source_list_construct (GType object_type,
                                            MailSourceListExpandableItem* root);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN MailSessionSourceItem* mail_session_source_item_new (MailBackendSession* session);
VALA_EXTERN MailSessionSourceItem* mail_session_source_item_construct (GType object_type,
                                                           MailBackendSession* session);
VALA_EXTERN GeeLinkedList* mail_backend_session_get_accounts (MailBackendSession* self);
static gboolean _mail_folders_list_view___lambda36_ (MailFoldersListView* self,
                                              MailBackendAccount* account);
static gboolean __mail_folders_list_view___lambda36__gee_forall_func (gpointer g,
                                                               gpointer self);
static void _mail_folders_list_view_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                             MailBackendAccount* account,
                                                                             gpointer self);
static void _mail_folders_list_view___lambda37_ (MailFoldersListView* self,
                                          MailSourceListItem* item);
static void __mail_folders_list_view___lambda37__mail_source_list_item_selected (MailSourceList* _sender,
                                                                          MailSourceListItem* item,
                                                                          gpointer self);
static void _mail_folders_list_view___lambda38_ (MailFoldersListView* self);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void __mail_folders_list_view___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void mail_folders_list_view_finalize (GObject * obj);
static GType mail_folders_list_view_get_type_once (void);
static void _vala_mail_folders_list_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_mail_folders_list_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
mail_folders_list_view_get_instance_private (MailFoldersListView* self)
{
	return G_STRUCT_MEMBER_P (self, MailFoldersListView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		MailFoldersListView* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->account_item);
		_g_object_unref0 (_data43_->account);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static void
__lambda34_ (MailFoldersListView* self,
             MailSourceListItem* item)
{
	MailSourceList* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->source_list;
	mail_source_list_start_editing_item (_tmp0_, item);
}

static void
___lambda34__mail_account_source_item_start_edit (MailAccountSourceItem* _sender,
                                                  MailSourceListItem* item,
                                                  gpointer self)
{
	__lambda34_ ((MailFoldersListView*) self, item);
}

static void
__lambda35_ (Block43Data* _data43_,
             GObject* obj,
             GAsyncResult* res)
{
	MailFoldersListView* self;
	gchar* selected_folder_uid = NULL;
	gchar* selected_folder_name = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	CamelService* _tmp3_;
	CamelService* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	self = _data43_->self;
	g_return_if_fail (res != NULL);
	mail_account_source_item_load_finish (_data43_->account_item, res);
	_tmp0_ = mail_folders_list_view_settings;
	g_settings_get (_tmp0_, "selected-folder", "(ss)", &_tmp1_, &_tmp2_);
	_g_free0 (selected_folder_uid);
	selected_folder_uid = _tmp1_;
	_g_free0 (selected_folder_name);
	selected_folder_name = _tmp2_;
	_tmp3_ = mail_backend_account_get_service (_data43_->account);
	_tmp4_ = _tmp3_;
	_tmp5_ = camel_service_get_uid (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = selected_folder_uid;
	if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
		const gchar* _tmp8_;
		_tmp8_ = selected_folder_name;
		mail_folders_list_view_select_saved_folder (self, (MailSourceListExpandableItem*) _data43_->account_item, _tmp8_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = selected_folder_uid;
		if (g_strcmp0 (_tmp9_, "GROUPED") == 0) {
			MailSessionSourceItem* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->priv->session_source_item;
			_tmp11_ = selected_folder_name;
			mail_folders_list_view_select_saved_folder (self, (MailSourceListExpandableItem*) _tmp10_, _tmp11_);
		}
	}
	_g_free0 (selected_folder_name);
	_g_free0 (selected_folder_uid);
}

static void
___lambda35__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda35_ (self, source_object, res);
	block43_data_unref (self);
}

static void
mail_folders_list_view_add_account (MailFoldersListView* self,
                                    MailBackendAccount* account)
{
	Block43Data* _data43_;
	MailBackendAccount* _tmp0_;
	MailAccountSourceItem* _tmp1_;
	MailSourceList* _tmp2_;
	MailSourceListExpandableItem* _tmp3_;
	MailSourceListExpandableItem* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data43_->account);
	_data43_->account = _tmp0_;
	_tmp1_ = mail_account_source_item_new (_data43_->account);
	_data43_->account_item = _tmp1_;
	g_signal_connect_object (_data43_->account_item, "start-edit", (GCallback) ___lambda34__mail_account_source_item_start_edit, self, 0);
	_tmp2_ = self->priv->source_list;
	_tmp3_ = mail_source_list_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	mail_source_list_expandable_item_add (_tmp4_, (MailSourceListItem*) _data43_->account_item);
	mail_account_source_item_load (_data43_->account_item, ___lambda35__gasync_ready_callback, block43_data_ref (_data43_));
	block43_data_unref (_data43_);
	_data43_ = NULL;
}

static CamelFolderInfo*
_vala_CamelFolderInfo_copy (CamelFolderInfo* self)
{
	return g_boxed_copy (camel_folder_info_get_type (), self);
}

static void
_vala_CamelFolderInfo_free (CamelFolderInfo* self)
{
	g_boxed_free (camel_folder_info_get_type (), self);
}

static gboolean
mail_folders_list_view_select_saved_folder (MailFoldersListView* self,
                                            MailSourceListExpandableItem* item,
                                            const gchar* selected_folder_name)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	g_return_val_if_fail (selected_folder_name != NULL, FALSE);
	{
		GeeIterator* _child_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = mail_source_list_expandable_item_get_children (item);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			MailSourceListItem* child = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			MailSourceListItem* _tmp8_;
			_tmp5_ = _child_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child = (MailSourceListItem*) _tmp7_;
			_tmp8_ = child;
			if (MAIL_IS_FOLDER_SOURCE_ITEM (_tmp8_)) {
				MailSourceListItem* _tmp9_;
				MailFolderSourceItem* folder_item = NULL;
				MailSourceListItem* _tmp10_;
				MailFolderSourceItem* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp9_ = child;
				if (mail_folders_list_view_select_saved_folder (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, MAIL_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, MailSourceListExpandableItem), selected_folder_name)) {
					result = TRUE;
					_g_object_unref0 (child);
					_g_object_unref0 (_child_it);
					return result;
				}
				_tmp10_ = child;
				folder_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
				_tmp11_ = folder_item;
				_tmp12_ = mail_folder_source_item_get_full_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, selected_folder_name) == 0) {
					MailSourceList* _tmp14_;
					MailSourceListItem* _tmp15_;
					GeeHashMap* folder_info_per_account = NULL;
					GeeHashMap* _tmp16_;
					GeeHashMap* _tmp17_;
					MailFolderSourceItem* _tmp18_;
					MailBackendAccount* _tmp19_;
					MailBackendAccount* _tmp20_;
					MailFolderSourceItem* _tmp21_;
					CamelFolderInfo* _tmp22_;
					CamelFolderInfo* _tmp23_;
					GeeHashMap* _tmp24_;
					GeeMap* _tmp25_;
					GeeMap* _tmp26_;
					GeeMap* _tmp27_;
					_tmp14_ = self->priv->source_list;
					_tmp15_ = child;
					mail_source_list_set_selected (_tmp14_, _tmp15_);
					_tmp16_ = gee_hash_map_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, camel_folder_info_get_type (), (GBoxedCopyFunc) _vala_CamelFolderInfo_copy, (GDestroyNotify) _vala_CamelFolderInfo_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					folder_info_per_account = _tmp16_;
					_tmp17_ = folder_info_per_account;
					_tmp18_ = folder_item;
					_tmp19_ = mail_folder_source_item_get_account (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = folder_item;
					_tmp22_ = mail_folder_source_item_get_folder_info (_tmp21_);
					_tmp23_ = _tmp22_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp20_, _tmp23_);
					_tmp24_ = folder_info_per_account;
					_tmp25_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = _tmp26_;
					g_signal_emit (self, mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL], 0, _tmp27_);
					_g_object_unref0 (_tmp27_);
					result = TRUE;
					_g_object_unref0 (folder_info_per_account);
					_g_object_unref0 (child);
					_g_object_unref0 (_child_it);
					return result;
				}
			} else {
				MailSourceListItem* _tmp28_;
				_tmp28_ = child;
				if (MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM (_tmp28_)) {
					MailGroupedFolderSourceItem* grouped_folder_item = NULL;
					MailSourceListItem* _tmp29_;
					MailGroupedFolderSourceItem* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					_tmp29_ = child;
					grouped_folder_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
					_tmp30_ = grouped_folder_item;
					_tmp31_ = mail_source_list_item_get_name ((MailSourceListItem*) _tmp30_);
					_tmp32_ = _tmp31_;
					if (g_strcmp0 (_tmp32_, selected_folder_name) == 0) {
						MailSourceList* _tmp33_;
						MailSourceListItem* _tmp34_;
						MailGroupedFolderSourceItem* _tmp35_;
						GeeMap* _tmp36_;
						GeeMap* _tmp37_;
						_tmp33_ = self->priv->source_list;
						_tmp34_ = child;
						mail_source_list_set_selected (_tmp33_, _tmp34_);
						_tmp35_ = grouped_folder_item;
						_tmp36_ = mail_grouped_folder_source_item_get_folder_info_per_account (_tmp35_);
						_tmp37_ = _tmp36_;
						g_signal_emit (self, mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL], 0, _tmp37_);
						_g_object_unref0 (_tmp37_);
						result = TRUE;
						_g_object_unref0 (child);
						_g_object_unref0 (_child_it);
						return result;
					}
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	result = FALSE;
	return result;
}

MailFoldersListView*
mail_folders_list_view_construct (GType object_type)
{
	MailFoldersListView * self = NULL;
	self = (MailFoldersListView*) g_object_new (object_type, NULL);
	return self;
}

MailFoldersListView*
mail_folders_list_view_new (void)
{
	return mail_folders_list_view_construct (MAIL_TYPE_FOLDERS_LIST_VIEW);
}

HdyHeaderBar*
mail_folders_list_view_get_header_bar (MailFoldersListView* self)
{
	HdyHeaderBar* result;
	HdyHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}

static void
mail_folders_list_view_set_header_bar (MailFoldersListView* self,
                                       HdyHeaderBar* value)
{
	HdyHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_folders_list_view_get_header_bar (self);
	if (old_value != value) {
		HdyHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_header_bar);
		self->priv->_header_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_folders_list_view_properties[MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY]);
	}
}

static gboolean
_mail_folders_list_view___lambda36_ (MailFoldersListView* self,
                                     MailBackendAccount* account)
{
	gboolean result;
	g_return_val_if_fail (account != NULL, FALSE);
	mail_folders_list_view_add_account (self, account);
	result = TRUE;
	_g_object_unref0 (account);
	return result;
}

static gboolean
__mail_folders_list_view___lambda36__gee_forall_func (gpointer g,
                                                      gpointer self)
{
	gboolean result;
	result = _mail_folders_list_view___lambda36_ ((MailFoldersListView*) self, (MailBackendAccount*) g);
	return result;
}

static void
_mail_folders_list_view_add_account_mail_backend_session_account_added (MailBackendSession* _sender,
                                                                        MailBackendAccount* account,
                                                                        gpointer self)
{
	mail_folders_list_view_add_account ((MailFoldersListView*) self, account);
}

static void
_mail_folders_list_view___lambda37_ (MailFoldersListView* self,
                                     MailSourceListItem* item)
{
	if (item == NULL) {
		return;
	}
	if (MAIL_IS_FOLDER_SOURCE_ITEM (item)) {
		MailFolderSourceItem* folder_item = NULL;
		GeeHashMap* folder_info_per_account = NULL;
		GeeHashMap* _tmp0_;
		GeeHashMap* _tmp1_;
		MailFolderSourceItem* _tmp2_;
		MailBackendAccount* _tmp3_;
		MailBackendAccount* _tmp4_;
		MailFolderSourceItem* _tmp5_;
		CamelFolderInfo* _tmp6_;
		CamelFolderInfo* _tmp7_;
		GeeHashMap* _tmp8_;
		GeeMap* _tmp9_;
		GeeMap* _tmp10_;
		GeeMap* _tmp11_;
		GSettings* _tmp12_;
		MailFolderSourceItem* _tmp13_;
		MailBackendAccount* _tmp14_;
		MailBackendAccount* _tmp15_;
		CamelService* _tmp16_;
		CamelService* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		MailFolderSourceItem* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		folder_item = G_TYPE_CHECK_INSTANCE_CAST (item, MAIL_TYPE_FOLDER_SOURCE_ITEM, MailFolderSourceItem);
		_tmp0_ = gee_hash_map_new (MAIL_BACKEND_TYPE_ACCOUNT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, camel_folder_info_get_type (), (GBoxedCopyFunc) _vala_CamelFolderInfo_copy, (GDestroyNotify) _vala_CamelFolderInfo_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		folder_info_per_account = _tmp0_;
		_tmp1_ = folder_info_per_account;
		_tmp2_ = folder_item;
		_tmp3_ = mail_folder_source_item_get_account (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = folder_item;
		_tmp6_ = mail_folder_source_item_get_folder_info (_tmp5_);
		_tmp7_ = _tmp6_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, _tmp4_, _tmp7_);
		_tmp8_ = folder_info_per_account;
		_tmp9_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		g_signal_emit (self, mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL], 0, _tmp11_);
		_g_object_unref0 (_tmp11_);
		_tmp12_ = mail_folders_list_view_settings;
		_tmp13_ = folder_item;
		_tmp14_ = mail_folder_source_item_get_account (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = mail_backend_account_get_service (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = camel_service_get_uid (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = folder_item;
		_tmp21_ = mail_folder_source_item_get_full_name (_tmp20_);
		_tmp22_ = _tmp21_;
		g_settings_set (_tmp12_, "selected-folder", "(ss)", _tmp19_, _tmp22_);
		_g_object_unref0 (folder_info_per_account);
	} else {
		if (MAIL_IS_GROUPED_FOLDER_SOURCE_ITEM (item)) {
			MailGroupedFolderSourceItem* grouped_folder_item = NULL;
			MailGroupedFolderSourceItem* _tmp23_;
			GeeMap* _tmp24_;
			GeeMap* _tmp25_;
			GSettings* _tmp26_;
			MailGroupedFolderSourceItem* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			grouped_folder_item = G_TYPE_CHECK_INSTANCE_CAST (item, MAIL_TYPE_GROUPED_FOLDER_SOURCE_ITEM, MailGroupedFolderSourceItem);
			_tmp23_ = grouped_folder_item;
			_tmp24_ = mail_grouped_folder_source_item_get_folder_info_per_account (_tmp23_);
			_tmp25_ = _tmp24_;
			g_signal_emit (self, mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL], 0, _tmp25_);
			_g_object_unref0 (_tmp25_);
			_tmp26_ = mail_folders_list_view_settings;
			_tmp27_ = grouped_folder_item;
			_tmp28_ = mail_source_list_item_get_name ((MailSourceListItem*) _tmp27_);
			_tmp29_ = _tmp28_;
			g_settings_set (_tmp26_, "selected-folder", "(ss)", "GROUPED", _tmp29_);
		}
	}
}

static void
__mail_folders_list_view___lambda37__mail_source_list_item_selected (MailSourceList* _sender,
                                                                     MailSourceListItem* item,
                                                                     gpointer self)
{
	_mail_folders_list_view___lambda37_ ((MailFoldersListView*) self, item);
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
_mail_folders_list_view___lambda38_ (MailFoldersListView* self)
{
	GError* _inner_error0_ = NULL;
	{
		GtkWidget* _tmp0_;
		_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), "settings://accounts/online", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GraniteMessageDialog* dialog = NULL;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GThemedIcon* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWindow* _tmp5_;
		GraniteMessageDialog* _tmp6_ = NULL;
		GraniteMessageDialog* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		GraniteMessageDialog* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("preferences-system");
		_tmp2_ = _tmp1_;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
		_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp6_ = granite_message_dialog_new (_ ("Unable to open System Settings"), _ ("Open System Settings manually or install Evolution to set up online ac" \
"counts."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp6_, (GIcon*) _tmp3_);
		_g_object_unref0 (_tmp3_);
		gtk_window_set_modal ((GtkWindow*) _tmp6_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp5_);
		_g_object_unref0 (_tmp5_);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp2_);
		dialog = _tmp7_;
		_tmp8_ = dialog;
		_tmp9_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp8_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp9_, 0);
		_tmp10_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp10_);
		_g_object_unref0 (dialog);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__mail_folders_list_view___lambda38__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_mail_folders_list_view___lambda38_ ((MailFoldersListView*) self);
}

static GObject *
mail_folders_list_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailFoldersListView * self;
	MailSourceListExpandableItem* _tmp0_;
	MailSourceListExpandableItem* _tmp1_;
	MailSourceList* _tmp2_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp3_;
	GtkApplication* _tmp4_;
	GtkButton* compose_button = NULL;
	gchar* _tmp5_;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_;
	GtkApplication* _tmp8_;
	GtkButton* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	HdyHeaderBar* _tmp17_ = NULL;
	HdyHeaderBar* _tmp18_;
	HdyHeaderBar* _tmp19_;
	GtkButton* _tmp20_;
	HdyHeaderBar* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	MailSourceList* _tmp25_;
	GraniteSwitchModelButton* load_images_menuitem = NULL;
	GraniteSwitchModelButton* _tmp26_;
	GtkModelButton* manage_signatures_menuitem = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GtkModelButton* _tmp29_ = NULL;
	GtkModelButton* account_settings_menuitem = NULL;
	gchar* _tmp30_;
	GtkModelButton* _tmp31_ = NULL;
	GtkSeparator* app_menu_separator = NULL;
	GtkSeparator* _tmp32_ = NULL;
	GtkBox* app_menu_box = NULL;
	GtkBox* _tmp33_ = NULL;
	GtkBox* _tmp34_;
	GraniteSwitchModelButton* _tmp35_;
	GtkBox* _tmp36_;
	GtkSeparator* _tmp37_;
	GtkBox* _tmp38_;
	GtkModelButton* _tmp39_;
	GtkBox* _tmp40_;
	GtkModelButton* _tmp41_;
	GtkBox* _tmp42_;
	GtkPopover* app_menu_popover = NULL;
	GtkBox* _tmp43_;
	GtkWidget* _tmp44_;
	GtkPopover* _tmp45_ = NULL;
	GtkMenuButton* app_menu = NULL;
	GtkImage* _tmp46_;
	GtkPopover* _tmp47_;
	GtkPopover* _tmp48_;
	gchar* _tmp49_;
	GtkMenuButton* _tmp50_ = NULL;
	GtkActionBar* action_bar = NULL;
	GtkActionBar* _tmp51_;
	GtkActionBar* _tmp52_;
	GtkStyleContext* _tmp53_;
	GtkActionBar* _tmp54_;
	GtkMenuButton* _tmp55_;
	GtkStyleContext* _tmp56_;
	HdyHeaderBar* _tmp57_;
	GtkScrolledWindow* _tmp58_;
	GtkActionBar* _tmp59_;
	MailBackendSession* session = NULL;
	MailBackendSession* _tmp60_;
	MailBackendSession* _tmp61_;
	MailBackendSession* _tmp62_;
	MailSessionSourceItem* _tmp63_;
	MailSourceList* _tmp64_;
	MailSourceListExpandableItem* _tmp65_;
	MailSourceListExpandableItem* _tmp66_;
	MailSessionSourceItem* _tmp67_;
	MailBackendSession* _tmp68_;
	GeeLinkedList* _tmp69_;
	GeeLinkedList* _tmp70_;
	MailBackendSession* _tmp71_;
	MailSourceList* _tmp72_;
	GSettings* settings = NULL;
	GSettings* _tmp73_;
	GSettings* _tmp74_;
	GraniteSwitchModelButton* _tmp75_;
	GtkModelButton* _tmp76_;
	parent_class = G_OBJECT_CLASS (mail_folders_list_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView);
	_tmp0_ = mail_source_list_expandable_item_new ("");
	_tmp1_ = _tmp0_;
	_tmp2_ = mail_source_list_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->source_list);
	self->priv->source_list = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = g_application_get_default ();
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp4_;
	_tmp5_ = g_strdup (MAIL_MAIN_WINDOW_ACTION_PREFIX MAIL_MAIN_WINDOW_ACTION_COMPOSE_MESSAGE);
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("mail-message-new", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp6_);
	compose_button = _tmp6_;
	_tmp7_ = compose_button;
	_tmp8_ = application_instance;
	_tmp9_ = compose_button;
	_tmp10_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = _tmp12_ = gtk_application_get_accels_for_action (_tmp8_, _tmp11_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _vala_array_length (_tmp12_);
	_tmp15_ = granite_markup_accel_tooltip (_tmp14_, (gint) _vala_array_length (_tmp12_), _ ("Compose new message"));
	_tmp16_ = _tmp15_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp7_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	mail_folders_list_view_set_header_bar (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_header_bar;
	_tmp20_ = compose_button;
	hdy_header_bar_pack_end (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_header_bar;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, GTK_STYLE_CLASS_FLAT);
	_tmp23_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp23_);
	scrolled_window = _tmp23_;
	_tmp24_ = scrolled_window;
	_tmp25_ = self->priv->source_list;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = granite_switch_model_button_new (_ ("Always Show Remote Images"));
	g_object_ref_sink (_tmp26_);
	load_images_menuitem = _tmp26_;
	_tmp27_ = g_strdup (_ ("Edit Signatures…"));
	_tmp28_ = g_strdup (MAIL_APPLICATION_ACTION_PREFIX MAIL_APPLICATION_ACTION_MANAGE_SIGNATURES);
	_tmp29_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp29_, "text", _tmp27_, NULL);
	_g_free0 (_tmp27_);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp29_, _tmp28_);
	_g_free0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	manage_signatures_menuitem = _tmp29_;
	_tmp30_ = g_strdup (_ ("Account Settings…"));
	_tmp31_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp31_, "text", _tmp30_, NULL);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	account_settings_menuitem = _tmp31_;
	_tmp32_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 3);
	g_object_ref_sink (_tmp32_);
	app_menu_separator = _tmp32_;
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp33_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp33_, 3);
	g_object_ref_sink (_tmp33_);
	app_menu_box = _tmp33_;
	_tmp34_ = app_menu_box;
	_tmp35_ = load_images_menuitem;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = app_menu_box;
	_tmp37_ = app_menu_separator;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = app_menu_box;
	_tmp39_ = manage_signatures_menuitem;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = app_menu_box;
	_tmp41_ = account_settings_menuitem;
	gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = app_menu_box;
	gtk_widget_show_all ((GtkWidget*) _tmp42_);
	_tmp43_ = app_menu_box;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_set ((GtkContainer*) _tmp45_, "child", _tmp44_, NULL);
	_g_object_unref0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	app_menu_popover = _tmp45_;
	_tmp46_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp46_);
	_tmp47_ = app_menu_popover;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	_tmp49_ = g_strdup (_ ("Menu"));
	_tmp50_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp50_, (GtkWidget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	gtk_menu_button_set_popover (_tmp50_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp50_, _tmp49_);
	_g_free0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	app_menu = _tmp50_;
	_tmp51_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp51_);
	action_bar = _tmp51_;
	_tmp52_ = action_bar;
	_tmp53_ = gtk_widget_get_style_context ((GtkWidget*) _tmp52_);
	gtk_style_context_add_class (_tmp53_, GTK_STYLE_CLASS_FLAT);
	_tmp54_ = action_bar;
	_tmp55_ = app_menu;
	gtk_action_bar_pack_end (_tmp54_, (GtkWidget*) _tmp55_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	g_object_set ((GtkWidget*) self, "width-request", 100, NULL);
	_tmp56_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp56_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp57_ = self->priv->_header_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp57_);
	_tmp58_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp58_);
	_tmp59_ = action_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
	_tmp60_ = mail_backend_session_get_default ();
	_tmp61_ = _g_object_ref0 (_tmp60_);
	session = _tmp61_;
	_tmp62_ = session;
	_tmp63_ = mail_session_source_item_new (_tmp62_);
	_g_object_unref0 (self->priv->session_source_item);
	self->priv->session_source_item = _tmp63_;
	_tmp64_ = self->priv->source_list;
	_tmp65_ = mail_source_list_get_root (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = self->priv->session_source_item;
	mail_source_list_expandable_item_add (_tmp66_, (MailSourceListItem*) _tmp67_);
	_tmp68_ = session;
	_tmp69_ = mail_backend_session_get_accounts (_tmp68_);
	_tmp70_ = _tmp69_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp70_, __mail_folders_list_view___lambda36__gee_forall_func, self);
	_g_object_unref0 (_tmp70_);
	_tmp71_ = session;
	g_signal_connect_object (_tmp71_, "account-added", (GCallback) _mail_folders_list_view_add_account_mail_backend_session_account_added, self, 0);
	_tmp72_ = self->priv->source_list;
	g_signal_connect_object (_tmp72_, "item-selected", (GCallback) __mail_folders_list_view___lambda37__mail_source_list_item_selected, self, 0);
	_tmp73_ = g_settings_new ("io.elementary.mail");
	settings = _tmp73_;
	_tmp74_ = settings;
	_tmp75_ = load_images_menuitem;
	g_settings_bind (_tmp74_, "always-load-remote-images", (GObject*) _tmp75_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp76_ = account_settings_menuitem;
	g_signal_connect_object ((GtkButton*) _tmp76_, "clicked", (GCallback) __mail_folders_list_view___lambda38__gtk_button_clicked, self, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (session);
	_g_object_unref0 (action_bar);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (app_menu_popover);
	_g_object_unref0 (app_menu_box);
	_g_object_unref0 (app_menu_separator);
	_g_object_unref0 (account_settings_menuitem);
	_g_object_unref0 (manage_signatures_menuitem);
	_g_object_unref0 (load_images_menuitem);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (compose_button);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
mail_folders_list_view_class_init (MailFoldersListViewClass * klass,
                                   gpointer klass_data)
{
	GSettings* _tmp0_;
	mail_folders_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailFoldersListView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_folders_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_folders_list_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_folders_list_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_folders_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY, mail_folders_list_view_properties[MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY] = g_param_spec_object ("header-bar", "header-bar", "header-bar", hdy_header_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_folders_list_view_signals[MAIL_FOLDERS_LIST_VIEW_FOLDER_SELECTED_SIGNAL] = g_signal_new ("folder-selected", MAIL_TYPE_FOLDERS_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MAP);
	_tmp0_ = g_settings_new ("io.elementary.mail");
	_g_object_unref0 (mail_folders_list_view_settings);
	mail_folders_list_view_settings = _tmp0_;
}

static void
mail_folders_list_view_instance_init (MailFoldersListView * self,
                                      gpointer klass)
{
	self->priv = mail_folders_list_view_get_instance_private (self);
}

static void
mail_folders_list_view_finalize (GObject * obj)
{
	MailFoldersListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->source_list);
	_g_object_unref0 (self->priv->session_source_item);
	G_OBJECT_CLASS (mail_folders_list_view_parent_class)->finalize (obj);
}

static GType
mail_folders_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailFoldersListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_folders_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailFoldersListView), 0, (GInstanceInitFunc) mail_folders_list_view_instance_init, NULL };
	GType mail_folders_list_view_type_id;
	mail_folders_list_view_type_id = g_type_register_static (gtk_grid_get_type (), "MailFoldersListView", &g_define_type_info, 0);
	MailFoldersListView_private_offset = g_type_add_instance_private (mail_folders_list_view_type_id, sizeof (MailFoldersListViewPrivate));
	return mail_folders_list_view_type_id;
}

GType
mail_folders_list_view_get_type (void)
{
	static volatile gsize mail_folders_list_view_type_id__once = 0;
	if (g_once_init_enter (&mail_folders_list_view_type_id__once)) {
		GType mail_folders_list_view_type_id;
		mail_folders_list_view_type_id = mail_folders_list_view_get_type_once ();
		g_once_init_leave (&mail_folders_list_view_type_id__once, mail_folders_list_view_type_id);
	}
	return mail_folders_list_view_type_id__once;
}

static void
_vala_mail_folders_list_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MailFoldersListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView);
	switch (property_id) {
		case MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY:
		g_value_set_object (value, mail_folders_list_view_get_header_bar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_folders_list_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MailFoldersListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_FOLDERS_LIST_VIEW, MailFoldersListView);
	switch (property_id) {
		case MAIL_FOLDERS_LIST_VIEW_HEADER_BAR_PROPERTY:
		mail_folders_list_view_set_header_bar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

