/* query.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from query.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gint __lambda5_ (GeeMapEntry* a,
                 GeeMapEntry* b);
static gint ___lambda5__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
synapse_query_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE, "SYNAPSE_QUERY_FLAGS_INCLUDE_REMOTE", "include-remote"}, {SYNAPSE_QUERY_FLAGS_UNCATEGORIZED, "SYNAPSE_QUERY_FLAGS_UNCATEGORIZED", "uncategorized"}, {SYNAPSE_QUERY_FLAGS_APPLICATIONS, "SYNAPSE_QUERY_FLAGS_APPLICATIONS", "applications"}, {SYNAPSE_QUERY_FLAGS_ACTIONS, "SYNAPSE_QUERY_FLAGS_ACTIONS", "actions"}, {SYNAPSE_QUERY_FLAGS_AUDIO, "SYNAPSE_QUERY_FLAGS_AUDIO", "audio"}, {SYNAPSE_QUERY_FLAGS_VIDEO, "SYNAPSE_QUERY_FLAGS_VIDEO", "video"}, {SYNAPSE_QUERY_FLAGS_DOCUMENTS, "SYNAPSE_QUERY_FLAGS_DOCUMENTS", "documents"}, {SYNAPSE_QUERY_FLAGS_IMAGES, "SYNAPSE_QUERY_FLAGS_IMAGES", "images"}, {SYNAPSE_QUERY_FLAGS_FILES, "SYNAPSE_QUERY_FLAGS_FILES", "files"}, {SYNAPSE_QUERY_FLAGS_PLACES, "SYNAPSE_QUERY_FLAGS_PLACES", "places"}, {SYNAPSE_QUERY_FLAGS_INTERNET, "SYNAPSE_QUERY_FLAGS_INTERNET", "internet"}, {SYNAPSE_QUERY_FLAGS_TEXT, "SYNAPSE_QUERY_FLAGS_TEXT", "text"}, {SYNAPSE_QUERY_FLAGS_CONTACTS, "SYNAPSE_QUERY_FLAGS_CONTACTS", "contacts"}, {SYNAPSE_QUERY_FLAGS_ALL, "SYNAPSE_QUERY_FLAGS_ALL", "all"}, {SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT, "SYNAPSE_QUERY_FLAGS_LOCAL_CONTENT", "local-content"}, {0, NULL, NULL}};
	GType synapse_query_flags_type_id;
	synapse_query_flags_type_id = g_flags_register_static ("SynapseQueryFlags", values);
	return synapse_query_flags_type_id;
}

GType
synapse_query_flags_get_type (void)
{
	static volatile gsize synapse_query_flags_type_id__once = 0;
	if (g_once_init_enter (&synapse_query_flags_type_id__once)) {
		GType synapse_query_flags_type_id;
		synapse_query_flags_type_id = synapse_query_flags_get_type_once ();
		g_once_init_leave (&synapse_query_flags_type_id__once, synapse_query_flags_type_id);
	}
	return synapse_query_flags_type_id__once;
}

static GType
synapse_matcher_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_MATCHER_FLAGS_NO_REVERSED, "SYNAPSE_MATCHER_FLAGS_NO_REVERSED", "no-reversed"}, {SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING, "SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING", "no-substring"}, {SYNAPSE_MATCHER_FLAGS_NO_PARTIAL, "SYNAPSE_MATCHER_FLAGS_NO_PARTIAL", "no-partial"}, {SYNAPSE_MATCHER_FLAGS_NO_FUZZY, "SYNAPSE_MATCHER_FLAGS_NO_FUZZY", "no-fuzzy"}, {0, NULL, NULL}};
	GType synapse_matcher_flags_type_id;
	synapse_matcher_flags_type_id = g_flags_register_static ("SynapseMatcherFlags", values);
	return synapse_matcher_flags_type_id;
}

GType
synapse_matcher_flags_get_type (void)
{
	static volatile gsize synapse_matcher_flags_type_id__once = 0;
	if (g_once_init_enter (&synapse_matcher_flags_type_id__once)) {
		GType synapse_matcher_flags_type_id;
		synapse_matcher_flags_type_id = synapse_matcher_flags_get_type_once ();
		g_once_init_leave (&synapse_matcher_flags_type_id__once, synapse_matcher_flags_type_id);
	}
	return synapse_matcher_flags_type_id__once;
}

void
synapse_query_init (SynapseQuery *self,
                    guint query_id,
                    const gchar* query,
                    SynapseQueryFlags flags,
                    guint num_results)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (query != NULL);
	memset (self, 0, sizeof (SynapseQuery));
	(*self).query_id = query_id;
	_tmp0_ = g_strdup (query);
	_g_free0 ((*self).query_string);
	(*self).query_string = _tmp0_;
	_tmp1_ = g_utf8_casefold (query, (gssize) -1);
	_g_free0 ((*self).query_string_folded);
	(*self).query_string_folded = _tmp1_;
	(*self).query_type = flags;
	(*self).max_results = num_results;
}

gboolean
synapse_query_is_cancelled (SynapseQuery *self)
{
	GCancellable* _tmp0_;
	gboolean result;
	_tmp0_ = (*self).cancellable;
	result = g_cancellable_is_cancelled (_tmp0_);
	return result;
}

void
synapse_query_check_cancellable (SynapseQuery *self,
                                 GError** error)
{
	GCancellable* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = (*self).cancellable;
	if (g_cancellable_is_cancelled (_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (SYNAPSE_SEARCH_ERROR, SYNAPSE_SEARCH_ERROR_SEARCH_CANCELLED, "Cancelled");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda5_ (GeeMapEntry* a,
            GeeMapEntry* b)
{
	GeeMapEntry* e1 = NULL;
	GeeMapEntry* e2 = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	e1 = G_TYPE_CHECK_INSTANCE_CAST (a, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	e2 = G_TYPE_CHECK_INSTANCE_CAST (b, GEE_MAP_TYPE_ENTRY, GeeMapEntry);
	_tmp0_ = gee_map_entry_get_value (e2);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_map_entry_get_value (e1);
	_tmp3_ = _tmp2_;
	result = ((gint) ((gintptr) _tmp1_)) - ((gint) ((gintptr) _tmp3_));
	return result;
}

static gint
___lambda5__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda5_ ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}

GeeList*
synapse_query_get_matchers_for_query (const gchar* query,
                                      SynapseMatcherFlags match_flags,
                                      GRegexCompileFlags flags)
{
	GeeHashMap* results = NULL;
	GeeHashMap* _tmp0_;
	GRegex* re = NULL;
	gchar** individual_words = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length1;
	gint individual_words_length1;
	gint _individual_words_size_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** individual_chars = NULL;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gint individual_chars_length1;
	gint _individual_chars_size_;
	gchar** escaped_chars = NULL;
	gchar** _tmp93_;
	gint escaped_chars_length1;
	gint _escaped_chars_size_;
	gchar** _tmp94_;
	gint _tmp94__length1;
	gboolean _tmp97_ = FALSE;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp111_ = FALSE;
	GeeArrayList* sorted_results = NULL;
	GeeArrayList* _tmp123_;
	GeeSet* entries = NULL;
	GeeSet* _tmp124_;
	GeeSet* _tmp125_;
	GeeSet* _tmp126_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	results = _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		_tmp2_ = g_regex_escape_string (query, -1);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("^(%s)$", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_regex_new (_tmp5_, flags, 0, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp8_;
		_tmp9_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp9_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_HIGHEST));
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GRegex* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_;
		_tmp11_ = g_regex_escape_string (query, -1);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("^(%s)", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_regex_new (_tmp14_, flags, 0, &_inner_error0_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp10_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp17_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp17_;
		_tmp18_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp18_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_EXCELLENT));
		_g_regex_unref0 (_tmp10_);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GRegex* _tmp19_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GRegex* _tmp24_;
		GRegex* _tmp25_;
		GRegex* _tmp26_;
		GRegex* _tmp27_;
		_tmp20_ = g_regex_escape_string (query, -1);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("\\b(%s)", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_regex_new (_tmp23_, flags, 0, &_inner_error0_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp19_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp26_ = _tmp19_;
		_tmp19_ = NULL;
		_g_regex_unref0 (re);
		re = _tmp26_;
		_tmp27_ = re;
		gee_abstract_map_set ((GeeAbstractMap*) results, _tmp27_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_VERY_GOOD));
		_g_regex_unref0 (_tmp19_);
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (re);
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp28_ = string_strip (query);
	_tmp29_ = _tmp28_;
	_tmp31_ = _tmp30_ = g_regex_split_simple ("\\s+", _tmp29_, 0, 0);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _vala_array_length (_tmp30_);
	_g_free0 (_tmp29_);
	individual_words = _tmp32_;
	individual_words_length1 = _tmp32__length1;
	_individual_words_size_ = individual_words_length1;
	_tmp33_ = individual_words;
	_tmp33__length1 = individual_words_length1;
	if (_tmp33__length1 >= 2) {
		gchar** escaped_words = NULL;
		gchar** _tmp34_;
		gint escaped_words_length1;
		gint _escaped_words_size_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* pattern = NULL;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp34_ = g_new0 (gchar*, 0 + 1);
		escaped_words = _tmp34_;
		escaped_words_length1 = 0;
		_escaped_words_size_ = escaped_words_length1;
		_tmp35_ = individual_words;
		_tmp35__length1 = individual_words_length1;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp35_;
			word_collection_length1 = _tmp35__length1;
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
				const gchar* word = NULL;
				word = word_collection[word_it];
				{
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp36_ = word;
					_tmp37_ = g_regex_escape_string (_tmp36_, -1);
					_vala_array_add8 (&escaped_words, &escaped_words_length1, &_escaped_words_size_, _tmp37_);
				}
			}
		}
		_tmp38_ = escaped_words;
		_tmp38__length1 = escaped_words_length1;
		_tmp39_ = _vala_g_strjoinv (").+\\b(", _tmp38_, (gint) _tmp38__length1);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf ("\\b(%s)", _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		pattern = _tmp42_;
		{
			GRegex* _tmp43_ = NULL;
			const gchar* _tmp44_;
			GRegex* _tmp45_;
			GRegex* _tmp46_;
			GRegex* _tmp47_;
			_tmp44_ = pattern;
			_tmp45_ = g_regex_new (_tmp44_, flags, 0, &_inner_error0_);
			_tmp43_ = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch3_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp46_ = _tmp43_;
			_tmp43_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp46_;
			_tmp47_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp47_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_GOOD));
			_g_regex_unref0 (_tmp43_);
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (pattern);
			escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_REVERSED) == SYNAPSE_MATCHER_FLAGS_NO_REVERSED)) {
			gchar** _tmp48_;
			gint _tmp48__length1;
			_tmp48_ = escaped_words;
			_tmp48__length1 = escaped_words_length1;
			if (_tmp48__length1 == 2) {
				gchar* reversed = NULL;
				gchar** _tmp49_;
				gint _tmp49__length1;
				const gchar* _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp49_ = escaped_words;
				_tmp49__length1 = escaped_words_length1;
				_tmp50_ = _tmp49_[1];
				_tmp51_ = escaped_words;
				_tmp51__length1 = escaped_words_length1;
				_tmp52_ = _tmp51_[0];
				_tmp53_ = g_strjoin (").+\\b(", _tmp50_, _tmp52_, NULL, NULL);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("\\b(%s)", _tmp54_);
				_tmp56_ = _tmp55_;
				_g_free0 (_tmp54_);
				reversed = _tmp56_;
				{
					GRegex* _tmp57_ = NULL;
					const gchar* _tmp58_;
					GRegex* _tmp59_;
					GRegex* _tmp60_;
					GRegex* _tmp61_;
					_tmp58_ = reversed;
					_tmp59_ = g_regex_new (_tmp58_, flags, 0, &_inner_error0_);
					_tmp57_ = _tmp59_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch4_g_regex_error;
						}
						_g_free0 (reversed);
						_g_free0 (pattern);
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
						_g_regex_unref0 (re);
						_g_object_unref0 (results);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp60_ = _tmp57_;
					_tmp57_ = NULL;
					_g_regex_unref0 (re);
					re = _tmp60_;
					_tmp61_ = re;
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp61_, (gpointer) ((gintptr) (SYNAPSE_MATCH_SCORE_GOOD - SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
					_g_regex_unref0 (_tmp57_);
				}
				goto __finally4;
				__catch4_g_regex_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally4:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (reversed);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (reversed);
			} else {
				gchar* orred = NULL;
				gchar** _tmp62_;
				gint _tmp62__length1;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* any_order = NULL;
				gchar* _tmp67_;
				_tmp62_ = escaped_words;
				_tmp62__length1 = escaped_words_length1;
				_tmp63_ = _vala_g_strjoinv (")|(?:", _tmp62_, (gint) _tmp62__length1);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf ("\\b((?:%s))", _tmp64_);
				_tmp66_ = _tmp65_;
				_g_free0 (_tmp64_);
				orred = _tmp66_;
				_tmp67_ = g_strdup ("");
				any_order = _tmp67_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp68_ = FALSE;
						_tmp68_ = TRUE;
						while (TRUE) {
							gchar** _tmp70_;
							gint _tmp70__length1;
							gboolean is_last = FALSE;
							gchar** _tmp71_;
							gint _tmp71__length1;
							const gchar* _tmp72_;
							const gchar* _tmp73_;
							gchar* _tmp74_;
							if (!_tmp68_) {
								gint _tmp69_;
								_tmp69_ = i;
								i = _tmp69_ + 1;
							}
							_tmp68_ = FALSE;
							_tmp70_ = escaped_words;
							_tmp70__length1 = escaped_words_length1;
							if (!(i < _tmp70__length1)) {
								break;
							}
							_tmp71_ = escaped_words;
							_tmp71__length1 = escaped_words_length1;
							is_last = i == (_tmp71__length1 - 1);
							_tmp72_ = any_order;
							_tmp73_ = orred;
							_tmp74_ = g_strconcat (_tmp72_, _tmp73_, NULL);
							_g_free0 (any_order);
							any_order = _tmp74_;
							if (!is_last) {
								const gchar* _tmp75_;
								gchar* _tmp76_;
								_tmp75_ = any_order;
								_tmp76_ = g_strconcat (_tmp75_, ".+", NULL);
								_g_free0 (any_order);
								any_order = _tmp76_;
							}
						}
					}
				}
				{
					GRegex* _tmp77_ = NULL;
					const gchar* _tmp78_;
					GRegex* _tmp79_;
					GRegex* _tmp80_;
					GRegex* _tmp81_;
					_tmp78_ = any_order;
					_tmp79_ = g_regex_new (_tmp78_, flags, 0, &_inner_error0_);
					_tmp77_ = _tmp79_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch5_g_regex_error;
						}
						_g_free0 (any_order);
						_g_free0 (orred);
						_g_free0 (pattern);
						escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
						individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
						_g_regex_unref0 (re);
						_g_object_unref0 (results);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp80_ = _tmp77_;
					_tmp77_ = NULL;
					_g_regex_unref0 (re);
					re = _tmp80_;
					_tmp81_ = re;
					gee_abstract_map_set ((GeeAbstractMap*) results, _tmp81_, (gpointer) ((gintptr) (SYNAPSE_MATCH_SCORE_AVERAGE + SYNAPSE_MATCH_SCORE_INCREMENT_MINOR)));
					_g_regex_unref0 (_tmp77_);
				}
				goto __finally5;
				__catch5_g_regex_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally5:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (any_order);
					_g_free0 (orred);
					_g_free0 (pattern);
					escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
					individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
					_g_regex_unref0 (re);
					_g_object_unref0 (results);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (any_order);
				_g_free0 (orred);
			}
		}
		_g_free0 (pattern);
		escaped_words = (_vala_array_free (escaped_words, escaped_words_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING) == SYNAPSE_MATCHER_FLAGS_NO_SUBSTRING)) {
		{
			GRegex* _tmp82_ = NULL;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			GRegex* _tmp87_;
			GRegex* _tmp88_;
			GRegex* _tmp89_;
			GRegex* _tmp90_;
			_tmp83_ = g_regex_escape_string (query, -1);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strdup_printf ("(%s)", _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_regex_new (_tmp86_, flags, 0, &_inner_error0_);
			_tmp88_ = _tmp87_;
			_g_free0 (_tmp86_);
			_g_free0 (_tmp84_);
			_tmp82_ = _tmp88_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp89_ = _tmp82_;
			_tmp82_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp89_;
			_tmp90_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp90_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_BELOW_AVERAGE));
			_g_regex_unref0 (_tmp82_);
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp92_ = _tmp91_ = g_regex_split_simple ("\\s*", query, 0, 0);
	individual_chars = _tmp92_;
	individual_chars_length1 = _vala_array_length (_tmp91_);
	_individual_chars_size_ = individual_chars_length1;
	_tmp93_ = g_new0 (gchar*, 0 + 1);
	escaped_chars = _tmp93_;
	escaped_chars_length1 = 0;
	_escaped_chars_size_ = escaped_chars_length1;
	_tmp94_ = individual_chars;
	_tmp94__length1 = individual_chars_length1;
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp94_;
		word_collection_length1 = _tmp94__length1;
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
			const gchar* word = NULL;
			word = word_collection[word_it];
			{
				const gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp95_ = word;
				_tmp96_ = g_regex_escape_string (_tmp95_, -1);
				_vala_array_add9 (&escaped_chars, &escaped_chars_length1, &_escaped_chars_size_, _tmp96_);
			}
		}
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_PARTIAL) == SYNAPSE_MATCHER_FLAGS_NO_PARTIAL)) {
		gchar** _tmp99_;
		gint _tmp99__length1;
		_tmp99_ = individual_words;
		_tmp99__length1 = individual_words_length1;
		_tmp98_ = _tmp99__length1 == 1;
	} else {
		_tmp98_ = FALSE;
	}
	if (_tmp98_) {
		gchar** _tmp100_;
		gint _tmp100__length1;
		_tmp100_ = individual_chars;
		_tmp100__length1 = individual_chars_length1;
		_tmp97_ = _tmp100__length1 <= 5;
	} else {
		_tmp97_ = FALSE;
	}
	if (_tmp97_) {
		gchar* pattern = NULL;
		gchar** _tmp101_;
		gint _tmp101__length1;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		_tmp101_ = escaped_chars;
		_tmp101__length1 = escaped_chars_length1;
		_tmp102_ = _vala_g_strjoinv (").+\\b(", _tmp101_, (gint) _tmp101__length1);
		_tmp103_ = _tmp102_;
		_tmp104_ = g_strdup_printf ("\\b(%s)", _tmp103_);
		_tmp105_ = _tmp104_;
		_g_free0 (_tmp103_);
		pattern = _tmp105_;
		{
			GRegex* _tmp106_ = NULL;
			const gchar* _tmp107_;
			GRegex* _tmp108_;
			GRegex* _tmp109_;
			GRegex* _tmp110_;
			_tmp107_ = pattern;
			_tmp108_ = g_regex_new (_tmp107_, flags, 0, &_inner_error0_);
			_tmp106_ = _tmp108_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp109_ = _tmp106_;
			_tmp106_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp109_;
			_tmp110_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp110_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_ABOVE_AVERAGE));
			_g_regex_unref0 (_tmp106_);
		}
		goto __finally7;
		__catch7_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	if (!((match_flags & SYNAPSE_MATCHER_FLAGS_NO_FUZZY) == SYNAPSE_MATCHER_FLAGS_NO_FUZZY)) {
		gchar** _tmp112_;
		gint _tmp112__length1;
		_tmp112_ = escaped_chars;
		_tmp112__length1 = escaped_chars_length1;
		_tmp111_ = _tmp112__length1 > 0;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		gchar* pattern = NULL;
		gchar** _tmp113_;
		gint _tmp113__length1;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		_tmp113_ = escaped_chars;
		_tmp113__length1 = escaped_chars_length1;
		_tmp114_ = _vala_g_strjoinv (").*(", _tmp113_, (gint) _tmp113__length1);
		_tmp115_ = _tmp114_;
		_tmp116_ = g_strdup_printf ("\\b(%s)", _tmp115_);
		_tmp117_ = _tmp116_;
		_g_free0 (_tmp115_);
		pattern = _tmp117_;
		{
			GRegex* _tmp118_ = NULL;
			const gchar* _tmp119_;
			GRegex* _tmp120_;
			GRegex* _tmp121_;
			GRegex* _tmp122_;
			_tmp119_ = pattern;
			_tmp120_ = g_regex_new (_tmp119_, flags, 0, &_inner_error0_);
			_tmp118_ = _tmp120_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch8_g_regex_error;
				}
				_g_free0 (pattern);
				escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
				individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
				_g_regex_unref0 (re);
				_g_object_unref0 (results);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp121_ = _tmp118_;
			_tmp118_ = NULL;
			_g_regex_unref0 (re);
			re = _tmp121_;
			_tmp122_ = re;
			gee_abstract_map_set ((GeeAbstractMap*) results, _tmp122_, (gpointer) ((gintptr) SYNAPSE_MATCH_SCORE_POOR));
			_g_regex_unref0 (_tmp118_);
		}
		goto __finally8;
		__catch8_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (pattern);
			escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
			individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
			_g_regex_unref0 (re);
			_g_object_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (pattern);
	}
	_tmp123_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sorted_results = _tmp123_;
	_tmp124_ = gee_abstract_map_get_entries ((GeeAbstractMap*) results);
	_tmp125_ = _tmp124_;
	entries = _tmp125_;
	_tmp126_ = _g_object_ref0 (entries);
	g_object_set_data_full ((GObject*) sorted_results, "entries-ref", _tmp126_, g_object_unref);
	gee_array_list_add_all (sorted_results, (GeeCollection*) entries);
	gee_list_sort ((GeeList*) sorted_results, ___lambda5__gcompare_data_func, NULL, NULL);
	result = (GeeList*) sorted_results;
	_g_object_unref0 (entries);
	escaped_chars = (_vala_array_free (escaped_chars, escaped_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_chars = (_vala_array_free (individual_chars, individual_chars_length1, (GDestroyNotify) g_free), NULL);
	individual_words = (_vala_array_free (individual_words, individual_words_length1, (GDestroyNotify) g_free), NULL);
	_g_regex_unref0 (re);
	_g_object_unref0 (results);
	return result;
}

void
synapse_query_copy (const SynapseQuery* self,
                    SynapseQuery* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	_tmp0_ = (*self).query_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).query_string);
	(*dest).query_string = _tmp1_;
	_tmp2_ = (*self).query_string_folded;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).query_string_folded);
	(*dest).query_string_folded = _tmp3_;
	_tmp4_ = (*self).cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).cancellable);
	(*dest).cancellable = _tmp5_;
	(*dest).query_type = (*self).query_type;
	(*dest).max_results = (*self).max_results;
	(*dest).query_id = (*self).query_id;
}

void
synapse_query_destroy (SynapseQuery* self)
{
	_g_free0 ((*self).query_string);
	_g_free0 ((*self).query_string_folded);
	_g_object_unref0 ((*self).cancellable);
}

SynapseQuery*
synapse_query_dup (const SynapseQuery* self)
{
	SynapseQuery* dup;
	dup = g_new0 (SynapseQuery, 1);
	synapse_query_copy (self, dup);
	return dup;
}

void
synapse_query_free (SynapseQuery* self)
{
	synapse_query_destroy (self);
	g_free (self);
}

static GType
synapse_query_get_type_once (void)
{
	GType synapse_query_type_id;
	synapse_query_type_id = g_boxed_type_register_static ("SynapseQuery", (GBoxedCopyFunc) synapse_query_dup, (GBoxedFreeFunc) synapse_query_free);
	return synapse_query_type_id;
}

GType
synapse_query_get_type (void)
{
	static volatile gsize synapse_query_type_id__once = 0;
	if (g_once_init_enter (&synapse_query_type_id__once)) {
		GType synapse_query_type_id;
		synapse_query_type_id = synapse_query_get_type_once ();
		g_once_init_leave (&synapse_query_type_id__once, synapse_query_type_id);
	}
	return synapse_query_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

