/*
 * This file is part of OpenTTD.
 * OpenTTD is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, version 2.
 * OpenTTD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with OpenTTD. If not, see <https://www.gnu.org/licenses/old-licenses/gpl-2.0>.
 */

/* THIS FILE IS AUTO-GENERATED; PLEASE DO NOT ALTER MANUALLY */

#include "../script_tile.hpp"
#include "../template/template_tile.sq.hpp"


template <> SQInteger PushClassName<ScriptTile, ScriptType::AI>(HSQUIRRELVM vm) { sq_pushstring(vm, "AITile"); return 1; }

void SQAITile_Register(Squirrel &engine)
{
	DefSQClass<ScriptTile, ScriptType::AI> SQAITile("AITile");
	SQAITile.PreRegister(engine, "AIObject");

	SQAITile.DefSQConst(engine, ScriptTile::ERR_TILE_BASE,               "ERR_TILE_BASE");
	SQAITile.DefSQConst(engine, ScriptTile::ERR_TILE_TOO_HIGH,           "ERR_TILE_TOO_HIGH");
	SQAITile.DefSQConst(engine, ScriptTile::ERR_TILE_TOO_LOW,            "ERR_TILE_TOO_LOW");
	SQAITile.DefSQConst(engine, ScriptTile::ERR_AREA_ALREADY_FLAT,       "ERR_AREA_ALREADY_FLAT");
	SQAITile.DefSQConst(engine, ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE, "ERR_EXCAVATION_WOULD_DAMAGE");
	SQAITile.DefSQConst(engine, ScriptTile::ERR_LIMIT_REACHED,           "ERR_LIMIT_REACHED");
	SQAITile.DefSQConst(engine, ScriptTile::CORNER_W,                    "CORNER_W");
	SQAITile.DefSQConst(engine, ScriptTile::CORNER_S,                    "CORNER_S");
	SQAITile.DefSQConst(engine, ScriptTile::CORNER_E,                    "CORNER_E");
	SQAITile.DefSQConst(engine, ScriptTile::CORNER_N,                    "CORNER_N");
	SQAITile.DefSQConst(engine, ScriptTile::CORNER_INVALID,              "CORNER_INVALID");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_FLAT,                  "SLOPE_FLAT");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_W,                     "SLOPE_W");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_S,                     "SLOPE_S");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_E,                     "SLOPE_E");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_N,                     "SLOPE_N");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_STEEP,                 "SLOPE_STEEP");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_NW,                    "SLOPE_NW");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_SW,                    "SLOPE_SW");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_SE,                    "SLOPE_SE");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_NE,                    "SLOPE_NE");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_EW,                    "SLOPE_EW");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_NS,                    "SLOPE_NS");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_ELEVATED,              "SLOPE_ELEVATED");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_NWS,                   "SLOPE_NWS");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_WSE,                   "SLOPE_WSE");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_SEN,                   "SLOPE_SEN");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_ENW,                   "SLOPE_ENW");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_W,               "SLOPE_STEEP_W");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_S,               "SLOPE_STEEP_S");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_E,               "SLOPE_STEEP_E");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_STEEP_N,               "SLOPE_STEEP_N");
	SQAITile.DefSQConst(engine, ScriptTile::SLOPE_INVALID,               "SLOPE_INVALID");
	SQAITile.DefSQConst(engine, ScriptTile::TRANSPORT_RAIL,              "TRANSPORT_RAIL");
	SQAITile.DefSQConst(engine, ScriptTile::TRANSPORT_ROAD,              "TRANSPORT_ROAD");
	SQAITile.DefSQConst(engine, ScriptTile::TRANSPORT_WATER,             "TRANSPORT_WATER");
	SQAITile.DefSQConst(engine, ScriptTile::TRANSPORT_AIR,               "TRANSPORT_AIR");
	SQAITile.DefSQConst(engine, ScriptTile::TRANSPORT_INVALID,           "TRANSPORT_INVALID");
	SQAITile.DefSQConst(engine, ScriptTile::BT_FOUNDATION,               "BT_FOUNDATION");
	SQAITile.DefSQConst(engine, ScriptTile::BT_TERRAFORM,                "BT_TERRAFORM");
	SQAITile.DefSQConst(engine, ScriptTile::BT_BUILD_TREES,              "BT_BUILD_TREES");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_GRASS,              "BT_CLEAR_GRASS");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_ROUGH,              "BT_CLEAR_ROUGH");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_ROCKY,              "BT_CLEAR_ROCKY");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_FIELDS,             "BT_CLEAR_FIELDS");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_HOUSE,              "BT_CLEAR_HOUSE");
	SQAITile.DefSQConst(engine, ScriptTile::BT_CLEAR_WATER,              "BT_CLEAR_WATER");
	SQAITile.DefSQConst(engine, ScriptTile::TERRAIN_NORMAL,              "TERRAIN_NORMAL");
	SQAITile.DefSQConst(engine, ScriptTile::TERRAIN_DESERT,              "TERRAIN_DESERT");
	SQAITile.DefSQConst(engine, ScriptTile::TERRAIN_RAINFOREST,          "TERRAIN_RAINFOREST");
	SQAITile.DefSQConst(engine, ScriptTile::TERRAIN_SNOW,                "TERRAIN_SNOW");

	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_AT_SEA_LEVEL,     ScriptTile::ERR_TILE_TOO_HIGH);
	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_AT_SEA_LEVEL,     ScriptTile::ERR_TILE_TOO_LOW);
	ScriptError::RegisterErrorMap(STR_ERROR_ALREADY_LEVELLED,         ScriptTile::ERR_AREA_ALREADY_FLAT);
	ScriptError::RegisterErrorMap(STR_ERROR_EXCAVATION_WOULD_DAMAGE,  ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE);
	ScriptError::RegisterErrorMap(STR_ERROR_TERRAFORM_LIMIT_REACHED,  ScriptTile::ERR_LIMIT_REACHED);
	ScriptError::RegisterErrorMap(STR_ERROR_CLEARING_LIMIT_REACHED,   ScriptTile::ERR_LIMIT_REACHED);
	ScriptError::RegisterErrorMap(STR_ERROR_TREE_PLANT_LIMIT_REACHED, ScriptTile::ERR_LIMIT_REACHED);

	ScriptError::RegisterErrorMapString(ScriptTile::ERR_TILE_TOO_HIGH,           "ERR_TILE_TOO_HIGH");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_TILE_TOO_LOW,            "ERR_TILE_TOO_LOW");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_AREA_ALREADY_FLAT,       "ERR_AREA_ALREADY_FLAT");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_EXCAVATION_WOULD_DAMAGE, "ERR_EXCAVATION_WOULD_DAMAGE");
	ScriptError::RegisterErrorMapString(ScriptTile::ERR_LIMIT_REACHED,           "ERR_LIMIT_REACHED");

	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsBuildable,                "IsBuildable",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsBuildableRectangle,       "IsBuildableRectangle",       ".iii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsSeaTile,                  "IsSeaTile",                  ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsRiverTile,                "IsRiverTile",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsWaterTile,                "IsWaterTile",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsCoastTile,                "IsCoastTile",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsStationTile,              "IsStationTile",              ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsSteepSlope,               "IsSteepSlope",               ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsHalftileSlope,            "IsHalftileSlope",            ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::HasTreeOnTile,              "HasTreeOnTile",              ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsFarmTile,                 "IsFarmTile",                 ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsRockTile,                 "IsRockTile",                 ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsRoughTile,                "IsRoughTile",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsSnowTile,                 "IsSnowTile",                 ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsDesertTile,               "IsDesertTile",               ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsHouseTile,                "IsHouseTile",                ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetTerrainType,             "GetTerrainType",             ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetSlope,                   "GetSlope",                   ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetComplementSlope,         "GetComplementSlope",         ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetMinHeight,               "GetMinHeight",               ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetMaxHeight,               "GetMaxHeight",               ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetCornerHeight,            "GetCornerHeight",            ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetOwner,                   "GetOwner",                   ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::HasTransportType,           "HasTransportType",           ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetCargoAcceptance,         "GetCargoAcceptance",         ".iiiii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetCargoProduction,         "GetCargoProduction",         ".iiiii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetDistanceManhattanToTile, "GetDistanceManhattanToTile", ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetDistanceSquareToTile,    "GetDistanceSquareToTile",    ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::RaiseTile,                  "RaiseTile",                  ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::LowerTile,                  "LowerTile",                  ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::LevelTiles,                 "LevelTiles",                 ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::DemolishTile,               "DemolishTile",               ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::PlantTree,                  "PlantTree",                  ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::PlantTreeRectangle,         "PlantTreeRectangle",         ".iii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::IsWithinTownInfluence,      "IsWithinTownInfluence",      ".ii");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetTownAuthority,           "GetTownAuthority",           ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetClosestTown,             "GetClosestTown",             ".i");
	SQAITile.DefSQStaticMethod(engine, &ScriptTile::GetBuildCost,               "GetBuildCost",               ".i");

	SQAITile.PostRegister(engine);
}
