/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"
#line 12 "DOMImplementation.bnd"

#include "utils/corestrings.h"
#line 46 "dom_implementation.c"

static void dukky_dom_implementation___init(duk_context *ctx, dom_implementation_private_t *priv)
{
}

static void dukky_dom_implementation___fini(duk_context *ctx, dom_implementation_private_t *priv)
{
}

static duk_ret_t dukky_dom_implementation___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	dom_implementation_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_dom_implementation___init(ctx, priv);
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_dom_implementation___destructor(duk_context *ctx)
{
	dom_implementation_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_dom_implementation___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_dom_implementation_createDocumentType(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 3) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 3, dukky_argc);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	if (dukky_argc > 2) {
		if (!duk_is_string(ctx, 2)) {
			duk_to_string(ctx, 2);
		}
	}
	/* Get private data for method */
	dom_implementation_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_dom_implementation_createDocument(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc == 2) {
		/* 1 optional arguments need adding */
		duk_push_null(ctx);
	} else if (dukky_argc > 3) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 3);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_string(ctx, 1)) {
			duk_to_string(ctx, 1);
		}
	}
	if (dukky_argc > 2) {
		/* unhandled type check */
	}
	/* Get private data for method */
	dom_implementation_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

static duk_ret_t dukky_dom_implementation_createHTMLDocument(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	dom_implementation_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 24 "DOMImplementation.bnd"

	duk_size_t text_len;
	const char *text = duk_safe_to_lstring(ctx, 0, &text_len);
	struct dom_document *doc = NULL, *ret = NULL;
	struct dom_document_type *doctype = NULL;
	struct dom_html_element *html = NULL, *head = NULL, *title = NULL, *body = NULL;
	struct dom_node *spare_ref = NULL;
	dom_string *text_str = NULL;
	dom_exception exc;

	exc = dom_string_create((const uint8_t*)text, text_len, &text_str);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_implementation_create_document(
		DOM_IMPLEMENTATION_HTML,
		NULL, NULL,
		NULL,
		NULL, NULL,
		&doc
		);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_implementation_create_document_type(
		"html", NULL, NULL, &doctype);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_node_append_child(doc, doctype, &spare_ref);
	if (exc != DOM_NO_ERR) goto out;
	if (spare_ref != NULL) { dom_node_unref(spare_ref); spare_ref = NULL; }

	exc = dom_document_create_element_ns(doc, corestring_dom_html_namespace,
					     corestring_dom_HTML, &html);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_document_create_element_ns(doc, corestring_dom_html_namespace,
					     corestring_dom_HEAD, &head);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_document_create_element_ns(doc, corestring_dom_html_namespace,
					     corestring_dom_TITLE, &title);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_document_create_element_ns(doc, corestring_dom_html_namespace,
					     corestring_dom_BODY, &body);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_node_set_text_content(title, text_str);
	if (exc != DOM_NO_ERR) goto out;

	exc = dom_node_append_child(head, title, &spare_ref);
	if (exc != DOM_NO_ERR) goto out;
	if (spare_ref != NULL) { dom_node_unref(spare_ref); spare_ref = NULL; }

	exc = dom_node_append_child(html, head, &spare_ref);
	if (exc != DOM_NO_ERR) goto out;
	if (spare_ref != NULL) { dom_node_unref(spare_ref); spare_ref = NULL; }

	exc = dom_node_append_child(html, body, &spare_ref);
	if (exc != DOM_NO_ERR) goto out;
	if (spare_ref != NULL) { dom_node_unref(spare_ref); spare_ref = NULL; }

	exc = dom_node_append_child(doc, html, &spare_ref);
	if (exc != DOM_NO_ERR) goto out;
	if (spare_ref != NULL) { dom_node_unref(spare_ref); spare_ref = NULL; }

	ret = doc;
	doc = NULL;

out:
	if (text_str != NULL) {
		dom_string_unref(text_str);
	}
	if (doc != NULL) {
		dom_node_unref(doc);
	}
	if (html != NULL) {
		dom_node_unref(html);
	}
	if (head != NULL) {
		dom_node_unref(head);
	}
	if (title != NULL) {
		dom_node_unref(title);
	}
	if (body != NULL) {
		dom_node_unref(body);
	}
	if (doctype != NULL) {
		dom_node_unref(doctype);
	}
	if (ret != NULL) {
		dukky_push_node(ctx, (struct dom_node *)ret);
		dom_node_unref(ret);
		return 1;
	}
	return 0; /* Coerced to undefined */
#line 290 "dom_implementation.c"
}

static duk_ret_t dukky_dom_implementation_hasFeature(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	dom_implementation_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

	return 0;
}

duk_ret_t dukky_dom_implementation___proto(duk_context *ctx, void *udata)
{
	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createDocumentType");
	duk_push_c_function(ctx, dukky_dom_implementation_createDocumentType, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createDocument");
	duk_push_c_function(ctx, dukky_dom_implementation_createDocument, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "createHTMLDocument");
	duk_push_c_function(ctx, dukky_dom_implementation_createHTMLDocument, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "hasFeature");
	duk_push_c_function(ctx, dukky_dom_implementation_hasFeature, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_dom_implementation___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_dom_implementation___constructor, 1);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


