/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mdk-dbus-screen-cast.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_connector,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        gint arg_width,
        gint arg_height,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntIntIntVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              g_marshal_value_peek_variant (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MdkDBusScreenCast
 * @title: MdkDBusScreenCast
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Mutter.ScreenCast ---- */

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_method_info_create_session_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_method_info_create_session_IN_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_method_info_create_session_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_method_info_create_session_OUT_ARG_session_path =
{
  {
    -1,
    (gchar *) "session_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_method_info_create_session_OUT_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_method_info_create_session_OUT_ARG_session_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const GDBusMethodInfo * const _mdk_dbus_screen_cast_method_info_pointers[] =
{
  &_mdk_dbus_screen_cast_method_info_create_session.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mdk_dbus_screen_cast_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mdk_dbus_screen_cast_property_info_pointers[] =
{
  &_mdk_dbus_screen_cast_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mdk_dbus_screen_cast_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast",
    (GDBusMethodInfo **) &_mdk_dbus_screen_cast_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mdk_dbus_screen_cast_property_info_pointers,
    NULL
  },
  "screen-cast",
};


/**
 * mdk_dbus_screen_cast_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mdk_dbus_screen_cast_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct;
}

/**
 * mdk_dbus_screen_cast_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MdkDBusScreenCast interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mdk_dbus_screen_cast_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
mdk_dbus_screen_cast_method_marshal_create_session (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MdkDBusScreenCast:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 */

/**
 * MdkDBusScreenCastIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #MdkDBusScreenCast::handle-create-session signal.
 * @get_version: Getter for the #MdkDBusScreenCast:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 */

typedef MdkDBusScreenCastIface MdkDBusScreenCastInterface;
G_DEFINE_INTERFACE (MdkDBusScreenCast, mdk_dbus_screen_cast, G_TYPE_OBJECT)

static void
mdk_dbus_screen_cast_default_init (MdkDBusScreenCastIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MdkDBusScreenCast::handle-create-session:
   * @object: A #MdkDBusScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_method_marshal_create_session,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * MdkDBusScreenCast:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("version", "Version", "Version", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mdk_dbus_screen_cast_get_version: (skip)
 * @object: A #MdkDBusScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
mdk_dbus_screen_cast_get_version (MdkDBusScreenCast *object)
{
  g_return_val_if_fail (MDK_DBUS_IS_SCREEN_CAST (object), 0);

  return MDK_DBUS_SCREEN_CAST_GET_IFACE (object)->get_version (object);
}

/**
 * mdk_dbus_screen_cast_set_version: (skip)
 * @object: A #MdkDBusScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mdk_dbus_screen_cast_set_version (MdkDBusScreenCast *object, gint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * mdk_dbus_screen_cast_call_create_session:
 * @proxy: A #MdkDBusScreenCastProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_call_create_session_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_call_create_session (
    MdkDBusScreenCast *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_call_create_session_finish:
 * @proxy: A #MdkDBusScreenCastProxy.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_call_create_session_finish (
    MdkDBusScreenCast *proxy,
    gchar **out_session_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_call_create_session_sync:
 * @proxy: A #MdkDBusScreenCastProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_session_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_call_create_session_sync (
    MdkDBusScreenCast *proxy,
    GVariant *arg_properties,
    gchar **out_session_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_session_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_complete_create_session:
 * @object: A #MdkDBusScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @session_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_complete_create_session (
    MdkDBusScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *session_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   session_path));
}

/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastProxy:
 *
 * The #MdkDBusScreenCastProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastProxy.
 */

struct _MdkDBusScreenCastProxyPrivate
{
  GData *qdata;
};

static void mdk_dbus_screen_cast_proxy_iface_init (MdkDBusScreenCastIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastProxy, mdk_dbus_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MdkDBusScreenCastProxy)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST, mdk_dbus_screen_cast_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastProxy, mdk_dbus_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST, mdk_dbus_screen_cast_proxy_iface_init))

#endif
static void
mdk_dbus_screen_cast_proxy_finalize (GObject *object)
{
  MdkDBusScreenCastProxy *proxy = MDK_DBUS_SCREEN_CAST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_proxy_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mdk_dbus_screen_cast_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.ScreenCast: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mdk_dbus_screen_cast_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.ScreenCast", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mdk_dbus_screen_cast_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mdk_dbus_screen_cast_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MDK_DBUS_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mdk_dbus_screen_cast_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MdkDBusScreenCastProxy *proxy = MDK_DBUS_SCREEN_CAST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gint 
mdk_dbus_screen_cast_proxy_get_version (MdkDBusScreenCast *object)
{
  MdkDBusScreenCastProxy *proxy = MDK_DBUS_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
mdk_dbus_screen_cast_proxy_init (MdkDBusScreenCastProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mdk_dbus_screen_cast_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MDK_DBUS_TYPE_SCREEN_CAST_PROXY, MdkDBusScreenCastProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mdk_dbus_screen_cast_interface_info ());
}

static void
mdk_dbus_screen_cast_proxy_class_init (MdkDBusScreenCastProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mdk_dbus_screen_cast_proxy_finalize;
  gobject_class->get_property = mdk_dbus_screen_cast_proxy_get_property;
  gobject_class->set_property = mdk_dbus_screen_cast_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mdk_dbus_screen_cast_proxy_g_signal;
  proxy_class->g_properties_changed = mdk_dbus_screen_cast_proxy_g_properties_changed;

  mdk_dbus_screen_cast_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastProxyPrivate));
#endif
}

static void
mdk_dbus_screen_cast_proxy_iface_init (MdkDBusScreenCastIface *iface)
{
  iface->get_version = mdk_dbus_screen_cast_proxy_get_version;
}

/**
 * mdk_dbus_screen_cast_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_proxy_new_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
}

/**
 * mdk_dbus_screen_cast_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_proxy_new().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCast *
mdk_dbus_screen_cast_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCast *
mdk_dbus_screen_cast_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST (ret);
  else
    return NULL;
}


/**
 * mdk_dbus_screen_cast_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mdk_dbus_screen_cast_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
}

/**
 * mdk_dbus_screen_cast_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCast *
mdk_dbus_screen_cast_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mdk_dbus_screen_cast_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCast *
mdk_dbus_screen_cast_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastSkeleton:
 *
 * The #MdkDBusScreenCastSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastSkeleton.
 */

struct _MdkDBusScreenCastSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mdk_dbus_screen_cast_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MDK_DBUS_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mdk_dbus_screen_cast_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mdk_dbus_screen_cast_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mdk_dbus_screen_cast_skeleton_vtable =
{
  _mdk_dbus_screen_cast_skeleton_handle_method_call,
  _mdk_dbus_screen_cast_skeleton_handle_get_property,
  _mdk_dbus_screen_cast_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mdk_dbus_screen_cast_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mdk_dbus_screen_cast_interface_info ();
}

static GDBusInterfaceVTable *
mdk_dbus_screen_cast_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mdk_dbus_screen_cast_skeleton_vtable;
}

static GVariant *
mdk_dbus_screen_cast_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mdk_dbus_screen_cast_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mdk_dbus_screen_cast_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mdk_dbus_screen_cast_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mdk_dbus_screen_cast_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mdk_dbus_screen_cast_emit_changed (gpointer user_data);

static void
mdk_dbus_screen_cast_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mdk_dbus_screen_cast_emit_changed (skeleton);
}

static void mdk_dbus_screen_cast_skeleton_iface_init (MdkDBusScreenCastIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSkeleton, mdk_dbus_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MdkDBusScreenCastSkeleton)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST, mdk_dbus_screen_cast_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSkeleton, mdk_dbus_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST, mdk_dbus_screen_cast_skeleton_iface_init))

#endif
static void
mdk_dbus_screen_cast_skeleton_finalize (GObject *object)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_skeleton_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mdk_dbus_screen_cast_emit_changed (gpointer user_data)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.ScreenCast",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mdk_dbus_screen_cast_schedule_emit_changed (MdkDBusScreenCastSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mdk_dbus_screen_cast_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mdk_dbus_screen_cast_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mdk_dbus_screen_cast_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mdk_dbus_screen_cast_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mdk_dbus_screen_cast_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mdk_dbus_screen_cast_skeleton_init (MdkDBusScreenCastSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mdk_dbus_screen_cast_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MDK_DBUS_TYPE_SCREEN_CAST_SKELETON, MdkDBusScreenCastSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_INT);
}

static gint 
mdk_dbus_screen_cast_skeleton_get_version (MdkDBusScreenCast *object)
{
  MdkDBusScreenCastSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mdk_dbus_screen_cast_skeleton_class_init (MdkDBusScreenCastSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mdk_dbus_screen_cast_skeleton_finalize;
  gobject_class->get_property = mdk_dbus_screen_cast_skeleton_get_property;
  gobject_class->set_property = mdk_dbus_screen_cast_skeleton_set_property;
  gobject_class->notify       = mdk_dbus_screen_cast_skeleton_notify;


  mdk_dbus_screen_cast_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mdk_dbus_screen_cast_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mdk_dbus_screen_cast_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mdk_dbus_screen_cast_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mdk_dbus_screen_cast_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastSkeletonPrivate));
#endif
}

static void
mdk_dbus_screen_cast_skeleton_iface_init (MdkDBusScreenCastIface *iface)
{
  iface->get_version = mdk_dbus_screen_cast_skeleton_get_version;
}

/**
 * mdk_dbus_screen_cast_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast.top_of_page">org.gnome.Mutter.ScreenCast</link>.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSkeleton): The skeleton object.
 */
MdkDBusScreenCast *
mdk_dbus_screen_cast_skeleton_new (void)
{
  return MDK_DBUS_SCREEN_CAST (g_object_new (MDK_DBUS_TYPE_SCREEN_CAST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast.Session
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MdkDBusScreenCastSession
 * @title: MdkDBusScreenCastSession
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast.Session D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link> D-Bus interface in C.
 */

enum
{
  MDK_DBUS__SCREEN_CAST_SESSION_CLOSED,
};

static unsigned MDK_DBUS__SCREEN_CAST_SESSION_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.Mutter.ScreenCast.Session ---- */

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_connector =
{
  {
    -1,
    (gchar *) "connector",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_connector.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_monitor_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_monitor_OUT_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_monitor_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_record_monitor =
{
  {
    -1,
    (gchar *) "RecordMonitor",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-record-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_window_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_window_IN_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_window_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_window_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_window_OUT_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_window_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_record_window =
{
  {
    -1,
    (gchar *) "RecordWindow",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_window_IN_ARG_pointers,
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_window_OUT_ARG_pointers,
    NULL
  },
  "handle-record-window",
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_x.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_y.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_width.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_height.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_area_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_area_OUT_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_area_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_record_area =
{
  {
    -1,
    (gchar *) "RecordArea",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_area_IN_ARG_pointers,
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_area_OUT_ARG_pointers,
    NULL
  },
  "handle-record-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_virtual_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_virtual_IN_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_virtual_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_session_method_info_record_virtual_OUT_ARG_stream_path =
{
  {
    -1,
    (gchar *) "stream_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_session_method_info_record_virtual_OUT_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_record_virtual_OUT_ARG_stream_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_session_method_info_record_virtual =
{
  {
    -1,
    (gchar *) "RecordVirtual",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_virtual_IN_ARG_pointers,
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_session_method_info_record_virtual_OUT_ARG_pointers,
    NULL
  },
  "handle-record-virtual",
  FALSE
};

static const GDBusMethodInfo * const _mdk_dbus_screen_cast_session_method_info_pointers[] =
{
  &_mdk_dbus_screen_cast_session_method_info_start.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_stop.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_monitor.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_window.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_area.parent_struct,
  &_mdk_dbus_screen_cast_session_method_info_record_virtual.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mdk_dbus_screen_cast_session_signal_info_closed =
{
  {
    -1,
    (gchar *) "Closed",
    NULL,
    NULL
  },
  "closed"
};

static const GDBusSignalInfo * const _mdk_dbus_screen_cast_session_signal_info_pointers[] =
{
  &_mdk_dbus_screen_cast_session_signal_info_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mdk_dbus_screen_cast_session_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast.Session",
    (GDBusMethodInfo **) &_mdk_dbus_screen_cast_session_method_info_pointers,
    (GDBusSignalInfo **) &_mdk_dbus_screen_cast_session_signal_info_pointers,
    NULL,
    NULL
  },
  "screen-cast-session",
};


/**
 * mdk_dbus_screen_cast_session_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mdk_dbus_screen_cast_session_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct;
}

/**
 * mdk_dbus_screen_cast_session_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MdkDBusScreenCastSession interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mdk_dbus_screen_cast_session_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
mdk_dbus_screen_cast_session_signal_marshal_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_record_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_record_window (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_record_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_session_method_marshal_record_virtual (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MdkDBusScreenCastSession:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 */

/**
 * MdkDBusScreenCastSessionIface:
 * @parent_iface: The parent interface.
 * @handle_record_area: Handler for the #MdkDBusScreenCastSession::handle-record-area signal.
 * @handle_record_monitor: Handler for the #MdkDBusScreenCastSession::handle-record-monitor signal.
 * @handle_record_virtual: Handler for the #MdkDBusScreenCastSession::handle-record-virtual signal.
 * @handle_record_window: Handler for the #MdkDBusScreenCastSession::handle-record-window signal.
 * @handle_start: Handler for the #MdkDBusScreenCastSession::handle-start signal.
 * @handle_stop: Handler for the #MdkDBusScreenCastSession::handle-stop signal.
 * @closed: Handler for the #MdkDBusScreenCastSession::closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 */

typedef MdkDBusScreenCastSessionIface MdkDBusScreenCastSessionInterface;
G_DEFINE_INTERFACE (MdkDBusScreenCastSession, mdk_dbus_screen_cast_session, G_TYPE_OBJECT)

static void
mdk_dbus_screen_cast_session_default_init (MdkDBusScreenCastSessionIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MdkDBusScreenCastSession::handle-start:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_start,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MdkDBusScreenCastSession::handle-stop:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MdkDBusScreenCastSession::handle-record-monitor:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_connector: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_record_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_record_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_record_monitor,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * MdkDBusScreenCastSession::handle-record-window:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_record_window() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-window",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_record_window),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_record_window,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MdkDBusScreenCastSession::handle-record-area:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_record_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_record_area),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_record_area,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_VARIANT);

  /**
   * MdkDBusScreenCastSession::handle-record-virtual:
   * @object: A #MdkDBusScreenCastSession.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_session_complete_record_virtual() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record-virtual",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, handle_record_virtual),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_session_method_marshal_record_virtual,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * MdkDBusScreenCastSession::closed:
   * @object: A #MdkDBusScreenCastSession.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Session.Closed">"Closed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  MDK_DBUS__SCREEN_CAST_SESSION_SIGNALS[MDK_DBUS__SCREEN_CAST_SESSION_CLOSED] =
    g_signal_new ("closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MdkDBusScreenCastSessionIface, closed),
      NULL,
      NULL,
      mdk_dbus_screen_cast_session_signal_marshal_closed,
      G_TYPE_NONE,
      0);

}

/**
 * mdk_dbus_screen_cast_session_emit_closed:
 * @object: A #MdkDBusScreenCastSession.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Session.Closed">"Closed"</link> D-Bus signal.
 */
void
mdk_dbus_screen_cast_session_emit_closed (
    MdkDBusScreenCastSession *object)
{
  g_signal_emit (object, MDK_DBUS__SCREEN_CAST_SESSION_SIGNALS[MDK_DBUS__SCREEN_CAST_SESSION_CLOSED], 0);
}

/**
 * mdk_dbus_screen_cast_session_call_start:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_start_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_start_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_start (
    MdkDBusScreenCastSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_start_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_start_finish (
    MdkDBusScreenCastSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_start_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_start_sync (
    MdkDBusScreenCastSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_stop:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_stop_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_stop (
    MdkDBusScreenCastSession *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_stop_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_stop_finish (
    MdkDBusScreenCastSession *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_stop_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_stop_sync (
    MdkDBusScreenCastSession *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_monitor:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_record_monitor_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_record_monitor_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_record_monitor (
    MdkDBusScreenCastSession *proxy,
    const gchar *arg_connector,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_connector,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_record_monitor_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_record_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_record_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_monitor_finish (
    MdkDBusScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_monitor_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_connector: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_record_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_monitor_sync (
    MdkDBusScreenCastSession *proxy,
    const gchar *arg_connector,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_connector,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_window:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_record_window_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_record_window_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_record_window (
    MdkDBusScreenCastSession *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordWindow",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_record_window_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_record_window().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_record_window().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_window_finish (
    MdkDBusScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_window_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_record_window() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_window_sync (
    MdkDBusScreenCastSession *proxy,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordWindow",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_area:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_record_area_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_record_area_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_record_area (
    MdkDBusScreenCastSession *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordArea",
    g_variant_new ("(iiii@a{sv})",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_record_area_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_record_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_record_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_area_finish (
    MdkDBusScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_area_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_record_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_area_sync (
    MdkDBusScreenCastSession *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordArea",
    g_variant_new ("(iiii@a{sv})",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_virtual:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_call_record_virtual_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_call_record_virtual_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_session_call_record_virtual (
    MdkDBusScreenCastSession *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RecordVirtual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_session_call_record_virtual_finish:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_call_record_virtual().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_call_record_virtual().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_virtual_finish (
    MdkDBusScreenCastSession *proxy,
    gchar **out_stream_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_call_record_virtual_sync:
 * @proxy: A #MdkDBusScreenCastSessionProxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @out_stream_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_call_record_virtual() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_session_call_record_virtual_sync (
    MdkDBusScreenCastSession *proxy,
    GVariant *arg_properties,
    gchar **out_stream_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RecordVirtual",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_stream_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_session_complete_start:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_start (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mdk_dbus_screen_cast_session_complete_stop:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_stop (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mdk_dbus_screen_cast_session_complete_record_monitor:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordMonitor">RecordMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_record_monitor (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * mdk_dbus_screen_cast_session_complete_record_window:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordWindow">RecordWindow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_record_window (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * mdk_dbus_screen_cast_session_complete_record_area:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordArea">RecordArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_record_area (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/**
 * mdk_dbus_screen_cast_session_complete_record_virtual:
 * @object: A #MdkDBusScreenCastSession.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @stream_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Session.RecordVirtual">RecordVirtual()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_session_complete_record_virtual (
    MdkDBusScreenCastSession *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *stream_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   stream_path));
}

/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastSessionProxy:
 *
 * The #MdkDBusScreenCastSessionProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastSessionProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastSessionProxy.
 */

struct _MdkDBusScreenCastSessionProxyPrivate
{
  GData *qdata;
};

static void mdk_dbus_screen_cast_session_proxy_iface_init (MdkDBusScreenCastSessionIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSessionProxy, mdk_dbus_screen_cast_session_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MdkDBusScreenCastSessionProxy)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_SESSION, mdk_dbus_screen_cast_session_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSessionProxy, mdk_dbus_screen_cast_session_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_SESSION, mdk_dbus_screen_cast_session_proxy_iface_init))

#endif
static void
mdk_dbus_screen_cast_session_proxy_finalize (GObject *object)
{
  MdkDBusScreenCastSessionProxy *proxy = MDK_DBUS_SCREEN_CAST_SESSION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_session_proxy_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_session_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
mdk_dbus_screen_cast_session_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
mdk_dbus_screen_cast_session_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MDK_DBUS_TYPE_SCREEN_CAST_SESSION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST_SESSION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mdk_dbus_screen_cast_session_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MdkDBusScreenCastSessionProxy *proxy = MDK_DBUS_SCREEN_CAST_SESSION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
mdk_dbus_screen_cast_session_proxy_init (MdkDBusScreenCastSessionProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mdk_dbus_screen_cast_session_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MDK_DBUS_TYPE_SCREEN_CAST_SESSION_PROXY, MdkDBusScreenCastSessionProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mdk_dbus_screen_cast_session_interface_info ());
}

static void
mdk_dbus_screen_cast_session_proxy_class_init (MdkDBusScreenCastSessionProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mdk_dbus_screen_cast_session_proxy_finalize;
  gobject_class->get_property = mdk_dbus_screen_cast_session_proxy_get_property;
  gobject_class->set_property = mdk_dbus_screen_cast_session_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mdk_dbus_screen_cast_session_proxy_g_signal;
  proxy_class->g_properties_changed = mdk_dbus_screen_cast_session_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastSessionProxyPrivate));
#endif
}

static void
mdk_dbus_screen_cast_session_proxy_iface_init (MdkDBusScreenCastSessionIface *iface G_GNUC_UNUSED)
{
}

/**
 * mdk_dbus_screen_cast_session_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_proxy_new_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_session_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
}

/**
 * mdk_dbus_screen_cast_session_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_proxy_new().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastSession *
mdk_dbus_screen_cast_session_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_session_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastSession *
mdk_dbus_screen_cast_session_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}


/**
 * mdk_dbus_screen_cast_session_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mdk_dbus_screen_cast_session_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_session_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_session_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_session_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_SESSION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
}

/**
 * mdk_dbus_screen_cast_session_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_session_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_session_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastSession *
mdk_dbus_screen_cast_session_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_session_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mdk_dbus_screen_cast_session_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_session_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSessionProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastSession *
mdk_dbus_screen_cast_session_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_SESSION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Session", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_SESSION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastSessionSkeleton:
 *
 * The #MdkDBusScreenCastSessionSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastSessionSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastSessionSkeleton.
 */

struct _MdkDBusScreenCastSessionSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mdk_dbus_screen_cast_session_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MDK_DBUS_TYPE_SCREEN_CAST_SESSION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST_SESSION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mdk_dbus_screen_cast_session_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mdk_dbus_screen_cast_session_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_session_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mdk_dbus_screen_cast_session_skeleton_vtable =
{
  _mdk_dbus_screen_cast_session_skeleton_handle_method_call,
  _mdk_dbus_screen_cast_session_skeleton_handle_get_property,
  _mdk_dbus_screen_cast_session_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mdk_dbus_screen_cast_session_interface_info ();
}

static GDBusInterfaceVTable *
mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mdk_dbus_screen_cast_session_skeleton_vtable;
}

static GVariant *
mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mdk_dbus_screen_cast_session_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mdk_dbus_screen_cast_session_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mdk_dbus_screen_cast_session_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mdk_dbus_screen_cast_session_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Session", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
mdk_dbus_screen_cast_session_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_mdk_dbus_screen_cast_session_on_signal_closed (
    MdkDBusScreenCastSession *object)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Session", "Closed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mdk_dbus_screen_cast_session_skeleton_iface_init (MdkDBusScreenCastSessionIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSessionSkeleton, mdk_dbus_screen_cast_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MdkDBusScreenCastSessionSkeleton)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_SESSION, mdk_dbus_screen_cast_session_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastSessionSkeleton, mdk_dbus_screen_cast_session_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_SESSION, mdk_dbus_screen_cast_session_skeleton_iface_init))

#endif
static void
mdk_dbus_screen_cast_session_skeleton_finalize (GObject *object)
{
  MdkDBusScreenCastSessionSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_SESSION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_session_skeleton_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_session_skeleton_init (MdkDBusScreenCastSessionSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mdk_dbus_screen_cast_session_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MDK_DBUS_TYPE_SCREEN_CAST_SESSION_SKELETON, MdkDBusScreenCastSessionSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
mdk_dbus_screen_cast_session_skeleton_class_init (MdkDBusScreenCastSessionSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mdk_dbus_screen_cast_session_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mdk_dbus_screen_cast_session_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mdk_dbus_screen_cast_session_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastSessionSkeletonPrivate));
#endif
}

static void
mdk_dbus_screen_cast_session_skeleton_iface_init (MdkDBusScreenCastSessionIface *iface)
{
  iface->closed = _mdk_dbus_screen_cast_session_on_signal_closed;
}

/**
 * mdk_dbus_screen_cast_session_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Session.top_of_page">org.gnome.Mutter.ScreenCast.Session</link>.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastSessionSkeleton): The skeleton object.
 */
MdkDBusScreenCastSession *
mdk_dbus_screen_cast_session_skeleton_new (void)
{
  return MDK_DBUS_SCREEN_CAST_SESSION (g_object_new (MDK_DBUS_TYPE_SCREEN_CAST_SESSION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Mutter.ScreenCast.Stream
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MdkDBusScreenCastStream
 * @title: MdkDBusScreenCastStream
 * @short_description: Generated C code for the org.gnome.Mutter.ScreenCast.Stream D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link> D-Bus interface in C.
 */

enum
{
  MDK_DBUS__SCREEN_CAST_STREAM_PIPEWIRE_STREAM_ADDED,
};

static unsigned MDK_DBUS__SCREEN_CAST_STREAM_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.gnome.Mutter.ScreenCast.Stream ---- */

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_stream_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusMethodInfo _mdk_dbus_screen_cast_stream_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const GDBusMethodInfo * const _mdk_dbus_screen_cast_stream_method_info_pointers[] =
{
  &_mdk_dbus_screen_cast_stream_method_info_start.parent_struct,
  &_mdk_dbus_screen_cast_stream_method_info_stop.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added_ARG_node_id =
{
  {
    -1,
    (gchar *) "node_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added_ARG_pointers[] =
{
  &_mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added_ARG_node_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added =
{
  {
    -1,
    (gchar *) "PipeWireStreamAdded",
    (GDBusArgInfo **) &_mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added_ARG_pointers,
    NULL
  },
  "pipewire-stream-added"
};

static const GDBusSignalInfo * const _mdk_dbus_screen_cast_stream_signal_info_pointers[] =
{
  &_mdk_dbus_screen_cast_stream_signal_info_pipewire_stream_added.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mdk_dbus_screen_cast_stream_property_info_parameters =
{
  {
    -1,
    (gchar *) "Parameters",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "parameters",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mdk_dbus_screen_cast_stream_property_info_pointers[] =
{
  &_mdk_dbus_screen_cast_stream_property_info_parameters.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mdk_dbus_screen_cast_stream_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Mutter.ScreenCast.Stream",
    (GDBusMethodInfo **) &_mdk_dbus_screen_cast_stream_method_info_pointers,
    (GDBusSignalInfo **) &_mdk_dbus_screen_cast_stream_signal_info_pointers,
    (GDBusPropertyInfo **) &_mdk_dbus_screen_cast_stream_property_info_pointers,
    NULL
  },
  "screen-cast-stream",
};


/**
 * mdk_dbus_screen_cast_stream_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mdk_dbus_screen_cast_stream_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct;
}

/**
 * mdk_dbus_screen_cast_stream_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MdkDBusScreenCastStream interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mdk_dbus_screen_cast_stream_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "parameters");
  return property_id_begin - 1;
}


inline static void
mdk_dbus_screen_cast_stream_signal_marshal_pipewire_stream_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_stream_method_marshal_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mdk_dbus_screen_cast_stream_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MdkDBusScreenCastStream:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 */

/**
 * MdkDBusScreenCastStreamIface:
 * @parent_iface: The parent interface.
 * @handle_start: Handler for the #MdkDBusScreenCastStream::handle-start signal.
 * @handle_stop: Handler for the #MdkDBusScreenCastStream::handle-stop signal.
 * @get_parameters: Getter for the #MdkDBusScreenCastStream:parameters property.
 * @pipewire_stream_added: Handler for the #MdkDBusScreenCastStream::pipewire-stream-added signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 */

typedef MdkDBusScreenCastStreamIface MdkDBusScreenCastStreamInterface;
G_DEFINE_INTERFACE (MdkDBusScreenCastStream, mdk_dbus_screen_cast_stream, G_TYPE_OBJECT)

static void
mdk_dbus_screen_cast_stream_default_init (MdkDBusScreenCastStreamIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MdkDBusScreenCastStream::handle-start:
   * @object: A #MdkDBusScreenCastStream.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_stream_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastStreamIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_stream_method_marshal_start,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MdkDBusScreenCastStream::handle-stop:
   * @object: A #MdkDBusScreenCastStream.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mdk_dbus_screen_cast_stream_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MdkDBusScreenCastStreamIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      mdk_dbus_screen_cast_stream_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * MdkDBusScreenCastStream::pipewire-stream-added:
   * @object: A #MdkDBusScreenCastStream.
   * @arg_node_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Stream.PipeWireStreamAdded">"PipeWireStreamAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  MDK_DBUS__SCREEN_CAST_STREAM_SIGNALS[MDK_DBUS__SCREEN_CAST_STREAM_PIPEWIRE_STREAM_ADDED] =
    g_signal_new ("pipewire-stream-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (MdkDBusScreenCastStreamIface, pipewire_stream_added),
      NULL,
      NULL,
      mdk_dbus_screen_cast_stream_signal_marshal_pipewire_stream_added,
      G_TYPE_NONE,
      1, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * MdkDBusScreenCastStream:parameters:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("parameters", "Parameters", "Parameters", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mdk_dbus_screen_cast_stream_get_parameters: (skip)
 * @object: A #MdkDBusScreenCastStream.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mdk_dbus_screen_cast_stream_dup_parameters() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
mdk_dbus_screen_cast_stream_get_parameters (MdkDBusScreenCastStream *object)
{
  g_return_val_if_fail (MDK_DBUS_IS_SCREEN_CAST_STREAM (object), NULL);

  return MDK_DBUS_SCREEN_CAST_STREAM_GET_IFACE (object)->get_parameters (object);
}

/**
 * mdk_dbus_screen_cast_stream_dup_parameters: (skip)
 * @object: A #MdkDBusScreenCastStream.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
mdk_dbus_screen_cast_stream_dup_parameters (MdkDBusScreenCastStream *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "parameters", &value, NULL);
  return value;
}

/**
 * mdk_dbus_screen_cast_stream_set_parameters: (skip)
 * @object: A #MdkDBusScreenCastStream.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Mutter-ScreenCast-Stream.Parameters">"Parameters"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mdk_dbus_screen_cast_stream_set_parameters (MdkDBusScreenCastStream *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "parameters", value, NULL);
}

/**
 * mdk_dbus_screen_cast_stream_emit_pipewire_stream_added:
 * @object: A #MdkDBusScreenCastStream.
 * @arg_node_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Mutter-ScreenCast-Stream.PipeWireStreamAdded">"PipeWireStreamAdded"</link> D-Bus signal.
 */
void
mdk_dbus_screen_cast_stream_emit_pipewire_stream_added (
    MdkDBusScreenCastStream *object,
    guint arg_node_id)
{
  g_signal_emit (object, MDK_DBUS__SCREEN_CAST_STREAM_SIGNALS[MDK_DBUS__SCREEN_CAST_STREAM_PIPEWIRE_STREAM_ADDED], 0, arg_node_id);
}

/**
 * mdk_dbus_screen_cast_stream_call_start:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_stream_call_start_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_stream_call_start_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_stream_call_start (
    MdkDBusScreenCastStream *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_stream_call_start_finish:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_stream_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_stream_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_stream_call_start_finish (
    MdkDBusScreenCastStream *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_stream_call_start_sync:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_stream_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_stream_call_start_sync (
    MdkDBusScreenCastStream *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_stream_call_stop:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_stream_call_stop_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_stream_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
mdk_dbus_screen_cast_stream_call_stop (
    MdkDBusScreenCastStream *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mdk_dbus_screen_cast_stream_call_stop_finish:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_stream_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mdk_dbus_screen_cast_stream_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_stream_call_stop_finish (
    MdkDBusScreenCastStream *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_stream_call_stop_sync:
 * @proxy: A #MdkDBusScreenCastStreamProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_stream_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mdk_dbus_screen_cast_stream_call_stop_sync (
    MdkDBusScreenCastStream *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mdk_dbus_screen_cast_stream_complete_start:
 * @object: A #MdkDBusScreenCastStream.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_stream_complete_start (
    MdkDBusScreenCastStream *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mdk_dbus_screen_cast_stream_complete_stop:
 * @object: A #MdkDBusScreenCastStream.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Mutter-ScreenCast-Stream.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mdk_dbus_screen_cast_stream_complete_stop (
    MdkDBusScreenCastStream *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastStreamProxy:
 *
 * The #MdkDBusScreenCastStreamProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastStreamProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastStreamProxy.
 */

struct _MdkDBusScreenCastStreamProxyPrivate
{
  GData *qdata;
};

static void mdk_dbus_screen_cast_stream_proxy_iface_init (MdkDBusScreenCastStreamIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastStreamProxy, mdk_dbus_screen_cast_stream_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MdkDBusScreenCastStreamProxy)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_STREAM, mdk_dbus_screen_cast_stream_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastStreamProxy, mdk_dbus_screen_cast_stream_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_STREAM, mdk_dbus_screen_cast_stream_proxy_iface_init))

#endif
static void
mdk_dbus_screen_cast_stream_proxy_finalize (GObject *object)
{
  MdkDBusScreenCastStreamProxy *proxy = MDK_DBUS_SCREEN_CAST_STREAM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_stream_proxy_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_stream_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_stream_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mdk_dbus_screen_cast_stream_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Mutter.ScreenCast.Stream: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mdk_dbus_screen_cast_stream_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_stream_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Mutter.ScreenCast.Stream", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mdk_dbus_screen_cast_stream_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mdk_dbus_screen_cast_stream_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MDK_DBUS_TYPE_SCREEN_CAST_STREAM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST_STREAM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mdk_dbus_screen_cast_stream_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MdkDBusScreenCastStreamProxy *proxy = MDK_DBUS_SCREEN_CAST_STREAM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
mdk_dbus_screen_cast_stream_proxy_get_parameters (MdkDBusScreenCastStream *object)
{
  MdkDBusScreenCastStreamProxy *proxy = MDK_DBUS_SCREEN_CAST_STREAM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Parameters");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
mdk_dbus_screen_cast_stream_proxy_init (MdkDBusScreenCastStreamProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mdk_dbus_screen_cast_stream_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MDK_DBUS_TYPE_SCREEN_CAST_STREAM_PROXY, MdkDBusScreenCastStreamProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mdk_dbus_screen_cast_stream_interface_info ());
}

static void
mdk_dbus_screen_cast_stream_proxy_class_init (MdkDBusScreenCastStreamProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mdk_dbus_screen_cast_stream_proxy_finalize;
  gobject_class->get_property = mdk_dbus_screen_cast_stream_proxy_get_property;
  gobject_class->set_property = mdk_dbus_screen_cast_stream_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mdk_dbus_screen_cast_stream_proxy_g_signal;
  proxy_class->g_properties_changed = mdk_dbus_screen_cast_stream_proxy_g_properties_changed;

  mdk_dbus_screen_cast_stream_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastStreamProxyPrivate));
#endif
}

static void
mdk_dbus_screen_cast_stream_proxy_iface_init (MdkDBusScreenCastStreamIface *iface)
{
  iface->get_parameters = mdk_dbus_screen_cast_stream_proxy_get_parameters;
}

/**
 * mdk_dbus_screen_cast_stream_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_stream_proxy_new_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_stream_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_stream_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_STREAM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
}

/**
 * mdk_dbus_screen_cast_stream_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_stream_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_stream_proxy_new().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastStream *
mdk_dbus_screen_cast_stream_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_stream_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_stream_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastStream *
mdk_dbus_screen_cast_stream_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_STREAM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}


/**
 * mdk_dbus_screen_cast_stream_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mdk_dbus_screen_cast_stream_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mdk_dbus_screen_cast_stream_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mdk_dbus_screen_cast_stream_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mdk_dbus_screen_cast_stream_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MDK_DBUS_TYPE_SCREEN_CAST_STREAM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
}

/**
 * mdk_dbus_screen_cast_stream_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mdk_dbus_screen_cast_stream_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mdk_dbus_screen_cast_stream_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MdkDBusScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastStream *
mdk_dbus_screen_cast_stream_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}

/**
 * mdk_dbus_screen_cast_stream_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mdk_dbus_screen_cast_stream_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mdk_dbus_screen_cast_stream_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastStreamProxy): The constructed proxy object or %NULL if @error is set.
 */
MdkDBusScreenCastStream *
mdk_dbus_screen_cast_stream_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MDK_DBUS_TYPE_SCREEN_CAST_STREAM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Mutter.ScreenCast.Stream", NULL);
  if (ret != NULL)
    return MDK_DBUS_SCREEN_CAST_STREAM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MdkDBusScreenCastStreamSkeleton:
 *
 * The #MdkDBusScreenCastStreamSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MdkDBusScreenCastStreamSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MdkDBusScreenCastStreamSkeleton.
 */

struct _MdkDBusScreenCastStreamSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mdk_dbus_screen_cast_stream_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MDK_DBUS_TYPE_SCREEN_CAST_STREAM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MDK_DBUS_TYPE_SCREEN_CAST_STREAM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mdk_dbus_screen_cast_stream_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mdk_dbus_screen_cast_stream_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mdk_dbus_screen_cast_stream_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mdk_dbus_screen_cast_stream_skeleton_vtable =
{
  _mdk_dbus_screen_cast_stream_skeleton_handle_method_call,
  _mdk_dbus_screen_cast_stream_skeleton_handle_get_property,
  _mdk_dbus_screen_cast_stream_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mdk_dbus_screen_cast_stream_interface_info ();
}

static GDBusInterfaceVTable *
mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mdk_dbus_screen_cast_stream_skeleton_vtable;
}

static GVariant *
mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mdk_dbus_screen_cast_stream_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mdk_dbus_screen_cast_stream_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mdk_dbus_screen_cast_stream_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mdk_dbus_screen_cast_stream_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Stream", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mdk_dbus_screen_cast_stream_emit_changed (gpointer user_data);

static void
mdk_dbus_screen_cast_stream_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mdk_dbus_screen_cast_stream_emit_changed (skeleton);
}

static void
_mdk_dbus_screen_cast_stream_on_signal_pipewire_stream_added (
    MdkDBusScreenCastStream *object,
    guint arg_node_id)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_node_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Mutter.ScreenCast.Stream", "PipeWireStreamAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void mdk_dbus_screen_cast_stream_skeleton_iface_init (MdkDBusScreenCastStreamIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastStreamSkeleton, mdk_dbus_screen_cast_stream_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MdkDBusScreenCastStreamSkeleton)
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_STREAM, mdk_dbus_screen_cast_stream_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MdkDBusScreenCastStreamSkeleton, mdk_dbus_screen_cast_stream_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MDK_DBUS_TYPE_SCREEN_CAST_STREAM, mdk_dbus_screen_cast_stream_skeleton_iface_init))

#endif
static void
mdk_dbus_screen_cast_stream_skeleton_finalize (GObject *object)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mdk_dbus_screen_cast_stream_skeleton_parent_class)->finalize (object);
}

static void
mdk_dbus_screen_cast_stream_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mdk_dbus_screen_cast_stream_emit_changed (gpointer user_data)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Mutter.ScreenCast.Stream",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mdk_dbus_screen_cast_stream_schedule_emit_changed (MdkDBusScreenCastStreamSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mdk_dbus_screen_cast_stream_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mdk_dbus_screen_cast_stream_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mdk_dbus_screen_cast_stream_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mdk_dbus_screen_cast_stream_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mdk_dbus_screen_cast_stream_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mdk_dbus_screen_cast_stream_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mdk_dbus_screen_cast_stream_skeleton_init (MdkDBusScreenCastStreamSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mdk_dbus_screen_cast_stream_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MDK_DBUS_TYPE_SCREEN_CAST_STREAM_SKELETON, MdkDBusScreenCastStreamSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
}

static GVariant *
mdk_dbus_screen_cast_stream_skeleton_get_parameters (MdkDBusScreenCastStream *object)
{
  MdkDBusScreenCastStreamSkeleton *skeleton = MDK_DBUS_SCREEN_CAST_STREAM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mdk_dbus_screen_cast_stream_skeleton_class_init (MdkDBusScreenCastStreamSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mdk_dbus_screen_cast_stream_skeleton_finalize;
  gobject_class->get_property = mdk_dbus_screen_cast_stream_skeleton_get_property;
  gobject_class->set_property = mdk_dbus_screen_cast_stream_skeleton_set_property;
  gobject_class->notify       = mdk_dbus_screen_cast_stream_skeleton_notify;


  mdk_dbus_screen_cast_stream_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mdk_dbus_screen_cast_stream_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mdk_dbus_screen_cast_stream_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MdkDBusScreenCastStreamSkeletonPrivate));
#endif
}

static void
mdk_dbus_screen_cast_stream_skeleton_iface_init (MdkDBusScreenCastStreamIface *iface)
{
  iface->pipewire_stream_added = _mdk_dbus_screen_cast_stream_on_signal_pipewire_stream_added;
  iface->get_parameters = mdk_dbus_screen_cast_stream_skeleton_get_parameters;
}

/**
 * mdk_dbus_screen_cast_stream_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Mutter-ScreenCast-Stream.top_of_page">org.gnome.Mutter.ScreenCast.Stream</link>.
 *
 * Returns: (transfer full) (type MdkDBusScreenCastStreamSkeleton): The skeleton object.
 */
MdkDBusScreenCastStream *
mdk_dbus_screen_cast_stream_skeleton_new (void)
{
  return MDK_DBUS_SCREEN_CAST_STREAM (g_object_new (MDK_DBUS_TYPE_SCREEN_CAST_STREAM_SKELETON, NULL));
}

