/* ExportOutliner.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportOutliner.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libxml/parser.h>
#include <float.h>
#include <math.h>
#include <handy.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_OUTLINER (export_outliner_get_type ())
#define EXPORT_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_OUTLINER, ExportOutliner))
#define EXPORT_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_OUTLINER, ExportOutlinerClass))
#define IS_EXPORT_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_OUTLINER))
#define IS_EXPORT_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_OUTLINER))
#define EXPORT_OUTLINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_OUTLINER, ExportOutlinerClass))

typedef struct _ExportOutliner ExportOutliner;
typedef struct _ExportOutlinerClass ExportOutlinerClass;
typedef struct _ExportOutlinerPrivate ExportOutlinerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;

#define TYPE_MARKDOWN_PARSER (markdown_parser_get_type ())
#define MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKDOWN_PARSER, MarkdownParser))
#define MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKDOWN_PARSER, MarkdownParserClass))
#define IS_MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKDOWN_PARSER))
#define IS_MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKDOWN_PARSER))
#define MARKDOWN_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKDOWN_PARSER, MarkdownParserClass))

typedef struct _MarkdownParser MarkdownParser;
typedef struct _MarkdownParserClass MarkdownParserClass;
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_LAYOUTS (layouts_get_type ())
#define LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUTS, Layouts))
#define LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUTS, LayoutsClass))
#define IS_LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUTS))
#define IS_LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUTS))
#define LAYOUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUTS, LayoutsClass))

typedef struct _Layouts Layouts;
typedef struct _LayoutsClass LayoutsClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_THEMES (themes_get_type ())
#define THEMES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMES, Themes))
#define THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMES, ThemesClass))
#define IS_THEMES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMES))
#define IS_THEMES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMES))
#define THEMES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMES, ThemesClass))

typedef struct _Themes Themes;
typedef struct _ThemesClass ThemesClass;

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportOutliner {
	Export parent_instance;
	ExportOutlinerPrivate * priv;
};

struct _ExportOutlinerClass {
	ExportClass parent_class;
};

static gpointer export_outliner_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_outliner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportOutliner, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportOutliner* export_outliner_new (void);
VALA_EXTERN ExportOutliner* export_outliner_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_outliner_real_export (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static gboolean export_outliner_show_tasks (ExportOutliner* self,
                                     DrawArea* da);
VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType markdown_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MarkdownParser, text_parser_unref)
VALA_EXTERN MarkdownParser* draw_area_get_markdown_parser (DrawArea* self);
VALA_EXTERN gboolean text_parser_get_enable (TextParser* self);
static xmlNode* export_outliner_export_theme (ExportOutliner* self,
                                       DrawArea* da);
static xmlNode* export_outliner_export_top_nodes (ExportOutliner* self,
                                           DrawArea* da);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN gint node_get_task_count (Node* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN gboolean theme_get_custom (Theme* self);
VALA_EXTERN const gchar* theme_get_name (Theme* self);
static xmlNode* export_outliner_export_node (ExportOutliner* self,
                                      Node* node);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN gint node_get_done_count (Node* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
static xmlNode* export_outliner_export_name (ExportOutliner* self,
                                      Node* node,
                                      CanvasText* ct);
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
static xmlNode* export_outliner_export_note (ExportOutliner* self,
                                      const gchar* note);
static xmlNode* export_outliner_export_nodes (ExportOutliner* self,
                                       Node* node);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
static gboolean export_outliner_real_import (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
VALA_EXTERN void draw_area_get_dimensions (DrawArea* self,
                               gint* width,
                               gint* height);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* draw_area_get_doc (DrawArea* self);
VALA_EXTERN gchar* document_get_label (Document* self);
VALA_EXTERN GType layouts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layouts, g_object_unref)
VALA_EXTERN Layouts* draw_area_get_layouts (DrawArea* self);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* layouts_get_default (Layouts* self);
VALA_EXTERN Node* node_new_with_name (DrawArea* da,
                          const gchar* n,
                          Layout* layout);
VALA_EXTERN Node* node_construct_with_name (GType object_type,
                                DrawArea* da,
                                const gchar* n,
                                Layout* layout);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* styles_get_global_style (Styles* self);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN void node_set_posx (Node* self,
                    gdouble value);
VALA_EXTERN void node_set_posy (Node* self,
                    gdouble value);
static void export_outliner_import_theme (ExportOutliner* self,
                                   xmlNode* n,
                                   DrawArea* da);
static void export_outliner_import_nodes (ExportOutliner* self,
                                   xmlNode* n,
                                   DrawArea* da,
                                   Node* parent);
VALA_EXTERN void draw_area_set_theme (DrawArea* self,
                          Theme* theme,
                          gboolean save);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN GType themes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Themes, g_object_unref)
VALA_EXTERN Themes* main_window_get_themes (MainWindow* self);
VALA_EXTERN Theme* themes_get_theme (Themes* self,
                         const gchar* name);
static void export_outliner_import_node (ExportOutliner* self,
                                  xmlNode* n,
                                  DrawArea* da,
                                  Node* parent);
VALA_EXTERN Node* node_new (DrawArea* da,
                Layout* layout);
VALA_EXTERN Node* node_construct (GType object_type,
                      DrawArea* da,
                      Layout* layout);
VALA_EXTERN void node_set_folded (Node* self,
                      gboolean value);
VALA_EXTERN void node_set_layout (Node* self,
                      Layout* value);
static void export_outliner_import_name (ExportOutliner* self,
                                  xmlNode* n,
                                  Node* node);
static void export_outliner_import_note (ExportOutliner* self,
                                  xmlNode* n,
                                  Node* node);
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
VALA_EXTERN gboolean node_is_leaf (Node* self);
VALA_EXTERN void node_enable_task (Node* self,
                       gboolean task);
VALA_EXTERN void node_set_task_done (Node* self,
                         gboolean done);
VALA_EXTERN void canvas_text_load (CanvasText* self,
                       xmlNode* n);
VALA_EXTERN void node_set_note (Node* self,
                    const gchar* value);
static GType export_outliner_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportOutliner*
export_outliner_construct (GType object_type)
{
	ExportOutliner* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".outliner");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportOutliner*) export_construct (object_type, "outliner", _ ("Outliner"), _tmp2_, (gint) 1, TRUE, TRUE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportOutliner*
export_outliner_new (void)
{
	return export_outliner_construct (TYPE_EXPORT_OUTLINER);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
export_outliner_real_export (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportOutliner * self;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlNode* outliner = NULL;
	xmlNode* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	MarkdownParser* _tmp4_;
	MarkdownParser* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	xmlNode* _tmp10_;
	xmlNode* _tmp11_;
	gboolean result;
	self = (ExportOutliner*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = xmlNewDoc ((xmlChar*) "1.0");
	doc = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "outliner");
	outliner = _tmp1_;
	xmlNewProp (outliner, (xmlChar*) "condensed", (xmlChar*) "false");
	_tmp2_ = bool_to_string (export_outliner_show_tasks (self, da));
	_tmp3_ = _tmp2_;
	xmlNewProp (outliner, (xmlChar*) "show-tasks", (xmlChar*) _tmp3_);
	_g_free0 (_tmp3_);
	xmlNewProp (outliner, (xmlChar*) "show-depth", (xmlChar*) "false");
	_tmp4_ = draw_area_get_markdown_parser (da);
	_tmp5_ = _tmp4_;
	_tmp6_ = text_parser_get_enable ((TextParser*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = bool_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	xmlNewProp (outliner, (xmlChar*) "markdown", (xmlChar*) _tmp9_);
	_g_free0 (_tmp9_);
	xmlNewProp (outliner, (xmlChar*) "blank-rows", (xmlChar*) "false");
	xmlNewProp (outliner, (xmlChar*) "auto-sizing", (xmlChar*) "false");
	_tmp10_ = export_outliner_export_theme (self, da);
	xmlAddChild (outliner, _tmp10_);
	_tmp11_ = export_outliner_export_top_nodes (self, da);
	xmlAddChild (outliner, _tmp11_);
	xmlDocSetRootElement (doc, outliner);
	xmlSaveFormatFile (fname, doc, 1);
	_xmlFreeDoc0 (doc);
	result = TRUE;
	return result;
}

static gboolean
export_outliner_show_tasks (ExportOutliner* self,
                            DrawArea* da)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = draw_area_get_nodes (da);
	nodes = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = nodes;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = nodes;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				_tmp6_ = node_get_task_count (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ > 0) {
					result = TRUE;
					_g_array_unref0 (nodes);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_array_unref0 (nodes);
	return result;
}

static xmlNode*
export_outliner_export_theme (ExportOutliner* self,
                              DrawArea* da)
{
	xmlNode* node = NULL;
	xmlNode* _tmp0_;
	Theme* theme = NULL;
	Theme* _tmp1_;
	const gchar* _tmp2_ = NULL;
	Theme* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	xmlNode* _tmp9_;
	xmlNode* _tmp10_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "theme");
	node = _tmp0_;
	_tmp1_ = draw_area_get_theme (da);
	theme = _tmp1_;
	_tmp3_ = theme;
	_tmp4_ = theme_get_custom (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "default";
	} else {
		Theme* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = theme;
		_tmp7_ = theme_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	}
	_tmp9_ = node;
	xmlSetProp (_tmp9_, (xmlChar*) "name", (xmlChar*) _tmp2_);
	_tmp10_ = node;
	result = _tmp10_;
	_g_object_unref0 (theme);
	return result;
}

static xmlNode*
export_outliner_export_top_nodes (ExportOutliner* self,
                                  DrawArea* da)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	GArray* nodes = NULL;
	GArray* _tmp1_;
	xmlNode* _tmp9_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "nodes");
	n = _tmp0_;
	_tmp1_ = draw_area_get_nodes (da);
	nodes = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				xmlNode* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				xmlNode* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = nodes;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = n;
				_tmp6_ = nodes;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = export_outliner_export_node (self, _tmp7_);
				xmlAddChild (_tmp5_, _tmp8_);
			}
		}
	}
	_tmp9_ = n;
	result = _tmp9_;
	_g_array_unref0 (nodes);
	return result;
}

static xmlNode*
export_outliner_export_node (ExportOutliner* self,
                             Node* node)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	xmlNode* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	xmlNode* _tmp18_;
	CanvasText* _tmp19_;
	CanvasText* _tmp20_;
	xmlNode* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	xmlNode* _tmp28_;
	xmlNode* _tmp29_;
	xmlNode* _tmp30_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "node");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = node_get_folded (node);
	_tmp3_ = _tmp2_;
	_tmp4_ = bool_to_string (!_tmp3_);
	_tmp5_ = _tmp4_;
	xmlSetProp (_tmp1_, (xmlChar*) "expanded", (xmlChar*) _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = n;
	xmlSetProp (_tmp6_, (xmlChar*) "hidenote", (xmlChar*) "true");
	_tmp7_ = node_get_task_count (node);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > 0) {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		xmlNode* _tmp17_;
		_tmp10_ = node_get_task_count (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = node_get_done_count (node);
		_tmp13_ = _tmp12_;
		if (_tmp11_ == _tmp13_) {
			_tmp9_ = "done";
		} else {
			const gchar* _tmp14_ = NULL;
			gint _tmp15_;
			gint _tmp16_;
			_tmp15_ = node_get_done_count (node);
			_tmp16_ = _tmp15_;
			if (_tmp16_ == 0) {
				_tmp14_ = "open";
			} else {
				_tmp14_ = "doing";
			}
			_tmp9_ = _tmp14_;
		}
		_tmp17_ = n;
		xmlSetProp (_tmp17_, (xmlChar*) "task", (xmlChar*) _tmp9_);
	}
	_tmp18_ = n;
	_tmp19_ = node_get_name (node);
	_tmp20_ = _tmp19_;
	_tmp21_ = export_outliner_export_name (self, node, _tmp20_);
	xmlAddChild (_tmp18_, _tmp21_);
	_tmp22_ = node_get_note (node);
	_tmp23_ = _tmp22_;
	if (g_strcmp0 (_tmp23_, "") != 0) {
		xmlNode* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		xmlNode* _tmp27_;
		_tmp24_ = n;
		_tmp25_ = node_get_note (node);
		_tmp26_ = _tmp25_;
		_tmp27_ = export_outliner_export_note (self, _tmp26_);
		xmlAddChild (_tmp24_, _tmp27_);
	}
	_tmp28_ = n;
	_tmp29_ = export_outliner_export_nodes (self, node);
	xmlAddChild (_tmp28_, _tmp29_);
	_tmp30_ = n;
	result = _tmp30_;
	return result;
}

static xmlNode*
export_outliner_export_nodes (ExportOutliner* self,
                              Node* node)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp11_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "nodes");
	n = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				gboolean _tmp5_;
				xmlNode* _tmp6_;
				GArray* _tmp7_;
				GArray* _tmp8_;
				Node* _tmp9_;
				xmlNode* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = node_children (node);
				_tmp4_ = _tmp3_;
				_tmp5_ = !(((guint) i) < _tmp4_->len);
				_g_array_unref0 (_tmp4_);
				if (_tmp5_) {
					break;
				}
				_tmp6_ = n;
				_tmp7_ = node_children (node);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_array_index (_tmp8_, Node*, (guint) i);
				_tmp10_ = export_outliner_export_node (self, _tmp9_);
				xmlAddChild (_tmp6_, _tmp10_);
				_g_array_unref0 (_tmp8_);
			}
		}
	}
	_tmp11_ = n;
	result = _tmp11_;
	return result;
}

static xmlNode*
export_outliner_export_name (ExportOutliner* self,
                             Node* node,
                             CanvasText* ct)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* t = NULL;
	xmlNode* _tmp1_;
	FormattedText* _tmp2_;
	FormattedText* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (ct != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "name");
	n = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "text");
	t = _tmp1_;
	_tmp2_ = canvas_text_get_text (ct);
	_tmp3_ = _tmp2_;
	_tmp4_ = formatted_text_get_text (_tmp3_);
	_tmp5_ = _tmp4_;
	xmlSetProp (t, (xmlChar*) "data", (xmlChar*) _tmp5_);
	xmlSetProp (t, (xmlChar*) "parse-as", (xmlChar*) "html");
	xmlAddChild (n, t);
	result = n;
	return result;
}

static xmlNode*
export_outliner_export_note (ExportOutliner* self,
                             const gchar* note)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* t = NULL;
	xmlNode* _tmp1_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (note != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "note");
	n = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "text");
	t = _tmp1_;
	xmlSetProp (t, (xmlChar*) "data", (xmlChar*) note);
	xmlSetProp (t, (xmlChar*) "parse-as", (xmlChar*) "markdown");
	xmlAddChild (n, t);
	result = n;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
export_outliner_real_import (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportOutliner * self;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlDoc* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Node* root = NULL;
	Document* _tmp4_;
	Document* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Layouts* _tmp9_;
	Layouts* _tmp10_;
	Layout* _tmp11_;
	Layout* _tmp12_;
	Node* _tmp13_;
	Node* _tmp14_;
	Node* _tmp15_;
	Styles* _tmp16_;
	Style* _tmp17_;
	Style* _tmp18_;
	Node* _tmp19_;
	Node* _tmp20_;
	GArray* _tmp21_;
	GArray* _tmp22_;
	Node* _tmp23_;
	Node* _tmp24_;
	xmlDoc* _tmp41_;
	gboolean result;
	self = (ExportOutliner*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = xmlReadFile (fname, NULL, (gint) XML_PARSE_HUGE);
	doc = _tmp0_;
	_tmp1_ = doc;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	draw_area_get_dimensions (da, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_tmp4_ = draw_area_get_doc (da);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_get_label (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = draw_area_get_layouts (da);
	_tmp10_ = _tmp9_;
	_tmp11_ = layouts_get_default (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = node_new_with_name (da, _tmp8_, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_g_free0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	root = _tmp14_;
	_tmp15_ = root;
	_tmp16_ = style_inspector_styles;
	_tmp17_ = styles_get_global_style (_tmp16_);
	_tmp18_ = _tmp17_;
	node_set_style (_tmp15_, _tmp18_);
	_style_unref0 (_tmp18_);
	_tmp19_ = root;
	node_set_posx (_tmp19_, (gdouble) ((width / 2) - 30));
	_tmp20_ = root;
	node_set_posy (_tmp20_, (gdouble) ((height / 2) - 10));
	_tmp21_ = draw_area_get_nodes (da);
	_tmp22_ = _tmp21_;
	_tmp23_ = root;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	g_array_append_val (_tmp22_, _tmp24_);
	_g_array_unref0 (_tmp22_);
	{
		xmlNode* it = NULL;
		xmlDoc* _tmp25_;
		xmlNode* _tmp26_;
		xmlNode* _tmp27_;
		_tmp25_ = doc;
		_tmp26_ = xmlDocGetRootElement (_tmp25_);
		_tmp27_ = _tmp26_->children;
		it = _tmp27_;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp31_;
				xmlNode* _tmp32_;
				if (!_tmp28_) {
					xmlNode* _tmp29_;
					xmlNode* _tmp30_;
					_tmp29_ = it;
					_tmp30_ = _tmp29_->next;
					it = _tmp30_;
				}
				_tmp28_ = FALSE;
				_tmp31_ = it;
				if (!(_tmp31_ != NULL)) {
					break;
				}
				_tmp32_ = it;
				if (_tmp32_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					GQuark _tmp37_ = 0U;
					static GQuark _tmp36_label0 = 0;
					static GQuark _tmp36_label1 = 0;
					_tmp33_ = it;
					_tmp34_ = _tmp33_->name;
					_tmp35_ = _tmp34_;
					_tmp37_ = (NULL == _tmp35_) ? 0 : g_quark_from_string (_tmp35_);
					if (_tmp37_ == ((0 != _tmp36_label0) ? _tmp36_label0 : (_tmp36_label0 = g_quark_from_static_string ("theme")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp38_;
								_tmp38_ = it;
								export_outliner_import_theme (self, _tmp38_, da);
								break;
							}
						}
					} else if (_tmp37_ == ((0 != _tmp36_label1) ? _tmp36_label1 : (_tmp36_label1 = g_quark_from_static_string ("nodes")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp39_;
								Node* _tmp40_;
								_tmp39_ = it;
								_tmp40_ = root;
								export_outliner_import_nodes (self, _tmp39_, da, _tmp40_);
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp41_ = doc;
	_xmlFreeDoc0 (_tmp41_);
	result = TRUE;
	_g_object_unref0 (root);
	return result;
}

static void
export_outliner_import_theme (ExportOutliner* self,
                              xmlNode* n,
                              DrawArea* da)
{
	gchar* m = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "name");
	m = _tmp0_;
	_tmp1_ = m;
	if (_tmp1_ != NULL) {
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
		Themes* _tmp4_;
		Themes* _tmp5_;
		const gchar* _tmp6_;
		Theme* _tmp7_;
		Theme* _tmp8_;
		_tmp2_ = draw_area_get_win (da);
		_tmp3_ = _tmp2_;
		_tmp4_ = main_window_get_themes (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = m;
		_tmp7_ = themes_get_theme (_tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		draw_area_set_theme (da, _tmp8_, FALSE);
		_g_object_unref0 (_tmp8_);
	}
	_g_free0 (m);
}

static void
export_outliner_import_nodes (ExportOutliner* self,
                              xmlNode* n,
                              DrawArea* da,
                              Node* parent)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "node") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					xmlNode* _tmp9_;
					_tmp9_ = it;
					export_outliner_import_node (self, _tmp9_, da, parent);
				}
			}
		}
	}
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
export_outliner_import_node (ExportOutliner* self,
                             xmlNode* n,
                             DrawArea* da,
                             Node* parent)
{
	Node* node = NULL;
	Node* _tmp0_;
	gchar* e = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	Node* _tmp5_;
	Layouts* _tmp6_;
	Layouts* _tmp7_;
	Layout* _tmp8_;
	Layout* _tmp9_;
	Node* _tmp10_;
	Styles* _tmp11_;
	Style* _tmp12_;
	Style* _tmp13_;
	gboolean _tmp31_ = FALSE;
	Node* _tmp32_;
	CanvasText* _tmp33_;
	CanvasText* _tmp34_;
	FormattedText* _tmp35_;
	FormattedText* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gboolean _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = node_new (da, NULL);
	node = _tmp0_;
	_tmp1_ = (gchar*) xmlGetProp (n, (xmlChar*) "expanded");
	e = _tmp1_;
	_tmp2_ = e;
	if (_tmp2_ != NULL) {
		Node* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = node;
		_tmp4_ = e;
		node_set_folded (_tmp3_, !bool_parse (_tmp4_));
	}
	_tmp5_ = node;
	_tmp6_ = draw_area_get_layouts (da);
	_tmp7_ = _tmp6_;
	_tmp8_ = layouts_get_default (_tmp7_);
	_tmp9_ = _tmp8_;
	node_set_layout (_tmp5_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = node;
	_tmp11_ = style_inspector_styles;
	_tmp12_ = styles_get_global_style (_tmp11_);
	_tmp13_ = _tmp12_;
	node_set_style (_tmp10_, _tmp13_);
	_style_unref0 (_tmp13_);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp14_;
		_tmp14_ = n->children;
		it = _tmp14_;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp18_;
				xmlNode* _tmp19_;
				if (!_tmp15_) {
					xmlNode* _tmp16_;
					xmlNode* _tmp17_;
					_tmp16_ = it;
					_tmp17_ = _tmp16_->next;
					it = _tmp17_;
				}
				_tmp15_ = FALSE;
				_tmp18_ = it;
				if (!(_tmp18_ != NULL)) {
					break;
				}
				_tmp19_ = it;
				if (_tmp19_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					GQuark _tmp24_ = 0U;
					static GQuark _tmp23_label0 = 0;
					static GQuark _tmp23_label1 = 0;
					static GQuark _tmp23_label2 = 0;
					_tmp20_ = it;
					_tmp21_ = _tmp20_->name;
					_tmp22_ = _tmp21_;
					_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
					if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string ("name")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp25_;
								Node* _tmp26_;
								_tmp25_ = it;
								_tmp26_ = node;
								export_outliner_import_name (self, _tmp25_, _tmp26_);
								break;
							}
						}
					} else if (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string ("note")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp27_;
								Node* _tmp28_;
								_tmp27_ = it;
								_tmp28_ = node;
								export_outliner_import_note (self, _tmp27_, _tmp28_);
								break;
							}
						}
					} else if (_tmp24_ == ((0 != _tmp23_label2) ? _tmp23_label2 : (_tmp23_label2 = g_quark_from_static_string ("nodes")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp29_;
								Node* _tmp30_;
								_tmp29_ = it;
								_tmp30_ = node;
								export_outliner_import_nodes (self, _tmp29_, da, _tmp30_);
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp32_ = node;
	_tmp33_ = node_get_name (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = canvas_text_get_text (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = formatted_text_get_text (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = string_strip (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strcmp0 (_tmp40_, "") != 0;
	_g_free0 (_tmp40_);
	if (_tmp41_) {
		_tmp31_ = TRUE;
	} else {
		Node* _tmp42_;
		GArray* _tmp43_;
		GArray* _tmp44_;
		_tmp42_ = node;
		_tmp43_ = node_children (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp31_ = _tmp44_->len > ((guint) 0);
		_g_array_unref0 (_tmp44_);
	}
	if (_tmp31_) {
		Node* _tmp45_;
		Theme* _tmp46_;
		Theme* _tmp47_;
		gchar* t = NULL;
		gchar* _tmp48_;
		gboolean _tmp49_ = FALSE;
		const gchar* _tmp50_;
		_tmp45_ = node;
		_tmp46_ = draw_area_get_theme (da);
		_tmp47_ = _tmp46_;
		node_attach (_tmp45_, parent, -1, _tmp47_, TRUE);
		_g_object_unref0 (_tmp47_);
		_tmp48_ = (gchar*) xmlGetProp (n, (xmlChar*) "task");
		t = _tmp48_;
		_tmp50_ = t;
		if (_tmp50_ != NULL) {
			Node* _tmp51_;
			_tmp51_ = node;
			_tmp49_ = node_is_leaf (_tmp51_);
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			Node* _tmp52_;
			Node* _tmp53_;
			const gchar* _tmp54_;
			_tmp52_ = node;
			node_enable_task (_tmp52_, TRUE);
			_tmp53_ = node;
			_tmp54_ = t;
			node_set_task_done (_tmp53_, g_strcmp0 (_tmp54_, "done") == 0);
		}
		_g_free0 (t);
	}
	_g_free0 (e);
	_g_object_unref0 (node);
}

static void
export_outliner_import_name (ExportOutliner* self,
                             xmlNode* n,
                             Node* node)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node_get_name (node);
	_tmp1_ = _tmp0_;
	canvas_text_load (_tmp1_, n);
}

static void
export_outliner_import_note (ExportOutliner* self,
                             xmlNode* n,
                             Node* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "text") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					gchar* text = NULL;
					xmlNode* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp9_ = it;
					_tmp10_ = (gchar*) xmlGetProp (_tmp9_, (xmlChar*) "data");
					text = _tmp10_;
					_tmp11_ = text;
					if (_tmp11_ != NULL) {
						const gchar* _tmp12_;
						_tmp12_ = text;
						node_set_note (node, _tmp12_);
					}
					_g_free0 (text);
				}
			}
		}
	}
}

static void
export_outliner_class_init (ExportOutlinerClass * klass,
                            gpointer klass_data)
{
	export_outliner_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_outliner_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_outliner_real_import;
}

static void
export_outliner_instance_init (ExportOutliner * self,
                               gpointer klass)
{
}

static GType
export_outliner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportOutlinerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_outliner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportOutliner), 0, (GInstanceInitFunc) export_outliner_instance_init, NULL };
	GType export_outliner_type_id;
	export_outliner_type_id = g_type_register_static (TYPE_EXPORT, "ExportOutliner", &g_define_type_info, 0);
	return export_outliner_type_id;
}

GType
export_outliner_get_type (void)
{
	static volatile gsize export_outliner_type_id__once = 0;
	if (g_once_init_enter (&export_outliner_type_id__once)) {
		GType export_outliner_type_id;
		export_outliner_type_id = export_outliner_get_type_once ();
		g_once_init_leave (&export_outliner_type_id__once, export_outliner_type_id);
	}
	return export_outliner_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

