/* CanvasText.c generated by valac 0.56.18, the Vala compiler
 * generated from CanvasText.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libxml/tree.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;
typedef struct _CanvasTextPrivate CanvasTextPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
enum  {
	CANVAS_TEXT_0_PROPERTY,
	CANVAS_TEXT_TEXT_PROPERTY,
	CANVAS_TEXT_POSX_PROPERTY,
	CANVAS_TEXT_POSY_PROPERTY,
	CANVAS_TEXT_WIDTH_PROPERTY,
	CANVAS_TEXT_HEIGHT_PROPERTY,
	CANVAS_TEXT_MAX_WIDTH_PROPERTY,
	CANVAS_TEXT_EDIT_PROPERTY,
	CANVAS_TEXT_CURSOR_PROPERTY,
	CANVAS_TEXT_SELSTART_PROPERTY,
	CANVAS_TEXT_SELEND_PROPERTY,
	CANVAS_TEXT_NUM_PROPERTIES
};
static GParamSpec* canvas_text_properties[CANVAS_TEXT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _formatted_text_unref0(var) ((var == NULL) ? NULL : (var = (formatted_text_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _pango_layout_line_unref0(var) ((var == NULL) ? NULL : (var = (pango_layout_line_unref (var), NULL)))

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _undo_tag_info_unref0(var) ((var == NULL) ? NULL : (var = (undo_tag_info_unref (var), NULL)))

#define TYPE_INSERT_TEXT (insert_text_get_type ())
typedef struct _InsertText InsertText;
#define _insert_text_free0(var) ((var == NULL) ? NULL : (var = (insert_text_free (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
enum  {
	CANVAS_TEXT_RESIZED_SIGNAL,
	CANVAS_TEXT_SELECT_MODE_SIGNAL,
	CANVAS_TEXT_CURSOR_CHANGED_SIGNAL,
	CANVAS_TEXT_NUM_SIGNALS
};
static guint canvas_text_signals[CANVAS_TEXT_NUM_SIGNALS] = {0};

struct _CanvasText {
	GObject parent_instance;
	CanvasTextPrivate * priv;
};

struct _CanvasTextClass {
	GObjectClass parent_class;
	xmlNode* (*save) (CanvasText* self, const gchar* title);
	void (*load) (CanvasText* self, xmlNode* n);
	void (*resize) (CanvasText* self, gdouble diff);
};

struct _CanvasTextPrivate {
	DrawArea* _da;
	gdouble _posx;
	gdouble _posy;
	FormattedText* _text;
	gboolean _edit;
	gint _cursor;
	gint _column;
	PangoLayout* _pango_layout;
	PangoLayout* _line_layout;
	gint _selstart;
	gint _selend;
	gint _selanchor;
	gdouble _max_width;
	gdouble _width;
	gdouble _height;
	gboolean _debug;
	gint _font_size;
};

struct _Block2Data {
	int _ref_count_;
	CanvasText* self;
	gchar* str;
};

struct _InsertText {
	gint start;
	gchar* text;
};

static gint CanvasText_private_offset;
static gpointer canvas_text_parent_class = NULL;

VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN xmlNode* canvas_text_save (CanvasText* self,
                           const gchar* title);
VALA_EXTERN void canvas_text_load (CanvasText* self,
                       xmlNode* n);
VALA_EXTERN void canvas_text_resize (CanvasText* self,
                         gdouble diff);
VALA_EXTERN CanvasText* canvas_text_new (DrawArea* da);
VALA_EXTERN CanvasText* canvas_text_construct (GType object_type,
                                   DrawArea* da);
VALA_EXTERN FormattedText* formatted_text_new (DrawArea* da);
VALA_EXTERN FormattedText* formatted_text_construct (GType object_type,
                                         DrawArea* da);
static void canvas_text_text_changed (CanvasText* self);
static void _canvas_text_text_changed_formatted_text_changed (FormattedText* _sender,
                                                       gpointer self);
static void canvas_text_initialize_font_description (CanvasText* self);
VALA_EXTERN void canvas_text_update_size (CanvasText* self,
                              gboolean call_resized);
VALA_EXTERN CanvasText* canvas_text_new_with_text (DrawArea* da,
                                       const gchar* txt);
VALA_EXTERN CanvasText* canvas_text_construct_with_text (GType object_type,
                                             DrawArea* da,
                                             const gchar* txt);
VALA_EXTERN FormattedText* formatted_text_new_with_text (DrawArea* da,
                                             const gchar* txt);
VALA_EXTERN FormattedText* formatted_text_construct_with_text (GType object_type,
                                                   DrawArea* da,
                                                   const gchar* txt);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void canvas_text_copy (CanvasText* self,
                       CanvasText* ct);
VALA_EXTERN gdouble canvas_text_get_posx (CanvasText* self);
VALA_EXTERN void canvas_text_set_posx (CanvasText* self,
                           gdouble value);
VALA_EXTERN gdouble canvas_text_get_posy (CanvasText* self);
VALA_EXTERN void canvas_text_set_posy (CanvasText* self,
                           gdouble value);
VALA_EXTERN void formatted_text_copy (FormattedText* self,
                          FormattedText* other);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN PangoFontDescription* canvas_text_get_font_fd (CanvasText* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
VALA_EXTERN void canvas_text_set_font (CanvasText* self,
                           const gchar* family,
                           gint* size,
                           gdouble zoom_factor);
VALA_EXTERN gboolean canvas_text_is_wrapped (CanvasText* self);
VALA_EXTERN gchar* canvas_text_get_wrapped_text (CanvasText* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda34_ (Block2Data* _data2_,
                  PangoLayoutLine* item);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
static void ___lambda34__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN gboolean canvas_text_is_within (CanvasText* self,
                                gdouble x,
                                gdouble y);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean canvas_text_is_within_clickable (CanvasText* self,
                                          gdouble x,
                                          gdouble y,
                                          FormatTag* tag,
                                          gchar** extra);
VALA_EXTERN gchar* formatted_text_get_extra (FormattedText* self,
                                 FormatTag tag,
                                 gint index);
VALA_EXTERN gboolean canvas_text_is_selected (CanvasText* self);
static xmlNode* canvas_text_real_save (CanvasText* self,
                                const gchar* title);
VALA_EXTERN xmlNode* formatted_text_save (FormattedText* self);
VALA_EXTERN gchar* canvas_text_xml_text (xmlNode* n);
VALA_EXTERN gchar* formatted_text_xml_text (xmlNode* n);
static void canvas_text_real_load (CanvasText* self,
                            xmlNode* n);
VALA_EXTERN void formatted_text_load (FormattedText* self,
                          xmlNode* n);
VALA_EXTERN gdouble canvas_text_get_line_height (CanvasText* self);
VALA_EXTERN gdouble utils_get_line_height (PangoLayout* layout);
VALA_EXTERN gdouble canvas_text_get_page_include_size (CanvasText* self,
                                           gint page_size);
VALA_EXTERN PangoAttrList* formatted_text_get_attributes (FormattedText* self);
VALA_EXTERN void canvas_text_update_attributes (CanvasText* self);
static void canvas_text_real_resize (CanvasText* self,
                              gdouble diff);
static void canvas_text_update_column (CanvasText* self);
VALA_EXTERN void canvas_text_set_cursor_only (CanvasText* self,
                                  gint cursor);
VALA_EXTERN void canvas_text_set_cursor_at_char (CanvasText* self,
                                     gdouble x,
                                     gdouble y,
                                     gboolean motion);
VALA_EXTERN void canvas_text_change_selection (CanvasText* self,
                                   gint* selstart,
                                   gint* selend,
                                   const gchar* msg);
VALA_EXTERN void canvas_text_set_cursor_at_word (CanvasText* self,
                                     gdouble x,
                                     gdouble y,
                                     gboolean motion);
static gint* _int_dup (gint* self);
VALA_EXTERN void canvas_text_clear_selection (CanvasText* self,
                                  const gchar* msg);
static void canvas_text_adjust_selection (CanvasText* self,
                                   gint last_cursor);
VALA_EXTERN void canvas_text_set_cursor_none (CanvasText* self);
VALA_EXTERN void canvas_text_set_cursor_all (CanvasText* self,
                                 gboolean motion);
static gint canvas_text_calc_direction (CanvasText* self,
                                 gint dir);
static void canvas_text_cursor_by_char (CanvasText* self,
                                 gint dir);
VALA_EXTERN void canvas_text_move_cursor (CanvasText* self,
                              gint dir);
VALA_EXTERN void canvas_text_selection_by_char (CanvasText* self,
                                    gint dir);
static void canvas_text_cursor_by_line (CanvasText* self,
                                 gint dir);
VALA_EXTERN void canvas_text_move_cursor_vertically (CanvasText* self,
                                         gint dir);
VALA_EXTERN void canvas_text_selection_vertically (CanvasText* self,
                                       gint dir);
static gint canvas_text_find_line_extent (CanvasText* self,
                                   gboolean start);
VALA_EXTERN void canvas_text_move_cursor_to_start_of_line (CanvasText* self);
VALA_EXTERN void canvas_text_move_cursor_to_end_of_line (CanvasText* self);
VALA_EXTERN void canvas_text_selection_to_start_of_line (CanvasText* self,
                                             gboolean home);
VALA_EXTERN void canvas_text_selection_to_end_of_line (CanvasText* self,
                                           gboolean end);
VALA_EXTERN void canvas_text_move_cursor_to_start (CanvasText* self);
VALA_EXTERN void canvas_text_move_cursor_to_end (CanvasText* self);
VALA_EXTERN void canvas_text_selection_to_start (CanvasText* self,
                                     gboolean home);
VALA_EXTERN void canvas_text_selection_to_end (CanvasText* self,
                                   gboolean end);
static gint canvas_text_find_word (CanvasText* self,
                            gint start,
                            gint dir);
VALA_EXTERN void canvas_text_move_cursor_by_word (CanvasText* self,
                                      gint dir);
VALA_EXTERN void canvas_text_selection_by_word (CanvasText* self,
                                    gint dir);
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN void canvas_text_backspace (CanvasText* self,
                            UndoTextBuffer* undo_buffer);
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN GArray* formatted_text_get_tags_in_range (FormattedText* self,
                                          gint start,
                                          gint end);
VALA_EXTERN void formatted_text_remove_text (FormattedText* self,
                                 gint index,
                                 gint chars);
VALA_EXTERN void undo_text_buffer_add_delete (UndoTextBuffer* self,
                                  gint start,
                                  const gchar* orig_text,
                                  GArray* tags,
                                  gint start_cursor);
VALA_EXTERN void canvas_text_backspace_word (CanvasText* self,
                                 UndoTextBuffer* undo_buffer);
VALA_EXTERN gint utils_find_word (const gchar* str,
                      gint cursor,
                      gboolean wordstart);
VALA_EXTERN void canvas_text_delete (CanvasText* self,
                         UndoTextBuffer* undo_buffer);
VALA_EXTERN void canvas_text_delete_range (CanvasText* self,
                               gint startpos,
                               gint endpos,
                               UndoTextBuffer* undo_buffer);
VALA_EXTERN void canvas_text_delete_word (CanvasText* self,
                              UndoTextBuffer* undo_buffer);
VALA_EXTERN gint canvas_text_get_cursor (CanvasText* self);
VALA_EXTERN void canvas_text_insert (CanvasText* self,
                         const gchar* s,
                         UndoTextBuffer* undo_buffer);
VALA_EXTERN void formatted_text_replace_text (FormattedText* self,
                                  gint index,
                                  gint chars,
                                  const gchar* str);
VALA_EXTERN void undo_text_buffer_add_replace (UndoTextBuffer* self,
                                   gint start,
                                   const gchar* orig_text,
                                   const gchar* text,
                                   GArray* tags,
                                   gint start_cursor);
VALA_EXTERN void formatted_text_insert_text (FormattedText* self,
                                 gint index,
                                 const gchar* str);
VALA_EXTERN void undo_text_buffer_add_insert (UndoTextBuffer* self,
                                  gint start,
                                  const gchar* text,
                                  gint start_cursor);
VALA_EXTERN void canvas_text_insert_at_pos (CanvasText* self,
                                gint start,
                                const gchar* s,
                                UndoTextBuffer* undo_buffer);
VALA_EXTERN void canvas_text_insert_formatted_text (CanvasText* self,
                                        FormattedText* t,
                                        UndoTextBuffer* undo_buffer);
VALA_EXTERN gint undo_tag_info_get_tag (UndoTagInfo* self);
VALA_EXTERN void formatted_text_add_tag (FormattedText* self,
                             FormatTag tag,
                             gint start,
                             gint end,
                             gboolean parsed,
                             const gchar* extra);
VALA_EXTERN gint undo_tag_info_get_start (UndoTagInfo* self);
VALA_EXTERN gint undo_tag_info_get_end (UndoTagInfo* self);
VALA_EXTERN gboolean undo_tag_info_get_parsed (UndoTagInfo* self);
VALA_EXTERN const gchar* undo_tag_info_get_extra (UndoTagInfo* self);
VALA_EXTERN GType insert_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InsertText* insert_text_dup (const InsertText* self);
VALA_EXTERN void insert_text_free (InsertText* self);
VALA_EXTERN void insert_text_copy (const InsertText* self,
                       InsertText* dest);
VALA_EXTERN void insert_text_destroy (InsertText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (InsertText, insert_text_destroy)
VALA_EXTERN void canvas_text_insert_ranges (CanvasText* self,
                                GArray* its,
                                UndoTextBuffer* undo_buffer);
VALA_EXTERN gint canvas_text_get_selstart (CanvasText* self);
VALA_EXTERN void undo_text_buffer_add_inserts (UndoTextBuffer* self,
                                   GArray* its,
                                   gint start_cursor);
VALA_EXTERN void canvas_text_replace (CanvasText* self,
                          gint start,
                          gint end,
                          const gchar* s,
                          UndoTextBuffer* undo_buffer);
VALA_EXTERN gchar* canvas_text_get_selected_text (CanvasText* self);
VALA_EXTERN void canvas_text_get_cursor_info (CanvasText* self,
                                  gint* cursor,
                                  gint* start,
                                  gint* end);
VALA_EXTERN void canvas_text_get_cursor_pos (CanvasText* self,
                                 gint* x,
                                 gint* ytop,
                                 gint* ybot);
VALA_EXTERN void canvas_text_get_char_pos (CanvasText* self,
                               gint pos,
                               gdouble* left,
                               gdouble* top,
                               gdouble* bottom,
                               gint* line);
VALA_EXTERN FormattedText* canvas_text_get_selected_formatted_text (CanvasText* self,
                                                        DrawArea* da);
VALA_EXTERN FormattedText* formatted_text_new_copy_range (DrawArea* da,
                                              FormattedText* text,
                                              gint start,
                                              gint end);
VALA_EXTERN FormattedText* formatted_text_construct_copy_range (GType object_type,
                                                    DrawArea* da,
                                                    FormattedText* text,
                                                    gint start,
                                                    gint end);
VALA_EXTERN void canvas_text_add_tag (CanvasText* self,
                          FormatTag tag,
                          const gchar* extra,
                          gboolean parsed,
                          UndoTextBuffer* undo_buffer);
VALA_EXTERN void undo_text_buffer_add_tag_add (UndoTextBuffer* self,
                                   gint start,
                                   gint end,
                                   FormatTag tag,
                                   const gchar* extra,
                                   gboolean parsed,
                                   gint cursor);
VALA_EXTERN void canvas_text_remove_tag (CanvasText* self,
                             FormatTag tag,
                             UndoTextBuffer* undo_buffer);
VALA_EXTERN void formatted_text_get_extra_parsed (FormattedText* self,
                                      FormatTag tag,
                                      gint index,
                                      gchar** extra,
                                      gboolean* parsed);
VALA_EXTERN void formatted_text_remove_tag (FormattedText* self,
                                FormatTag tag,
                                gint start,
                                gint end);
VALA_EXTERN void undo_text_buffer_add_tag_remove (UndoTextBuffer* self,
                                      gint start,
                                      gint end,
                                      FormatTag tag,
                                      const gchar* extra,
                                      gboolean parsed,
                                      gint cursor);
VALA_EXTERN void canvas_text_remove_all_tags (CanvasText* self,
                                  UndoTextBuffer* undo_buffer);
VALA_EXTERN void formatted_text_remove_all_tags (FormattedText* self,
                                     gint start,
                                     gint end);
VALA_EXTERN void undo_text_buffer_add_tag_clear (UndoTextBuffer* self,
                                     gint start,
                                     gint end,
                                     GArray* tags,
                                     gint cursor);
VALA_EXTERN void formatted_text_replace_tag (FormattedText* self,
                                 FormatTag tag,
                                 gint start,
                                 gint end,
                                 gboolean parsed,
                                 const gchar* extra);
VALA_EXTERN void formatted_text_remove_tag_all (FormattedText* self,
                                    FormatTag tag);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void canvas_text_draw (CanvasText* self,
                       cairo_t* ctx,
                       Theme* theme,
                       GdkRGBA* fg,
                       gdouble alpha,
                       gboolean copy_layout);
VALA_EXTERN PangoAttrList* formatted_text_get_attributes_from_theme (FormattedText* self,
                                                         Theme* theme);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN gboolean canvas_text_get_edit (CanvasText* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN gdouble draw_area_get_origin_x (DrawArea* self);
VALA_EXTERN gdouble draw_area_get_origin_y (DrawArea* self);
VALA_EXTERN gdouble canvas_text_get_width (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_height (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_max_width (CanvasText* self);
VALA_EXTERN void canvas_text_set_max_width (CanvasText* self,
                                gdouble value);
VALA_EXTERN void canvas_text_set_edit (CanvasText* self,
                           gboolean value);
VALA_EXTERN gint canvas_text_get_selend (CanvasText* self);
static void canvas_text_finalize (GObject * obj);
static GType canvas_text_get_type_once (void);
static void _vala_canvas_text_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_canvas_text_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
canvas_text_get_instance_private (CanvasText* self)
{
	return G_STRUCT_MEMBER_P (self, CanvasText_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_canvas_text_text_changed_formatted_text_changed (FormattedText* _sender,
                                                  gpointer self)
{
	canvas_text_text_changed ((CanvasText*) self);
}

CanvasText*
canvas_text_construct (GType object_type,
                       DrawArea* da)
{
	CanvasText * self = NULL;
	gint int_max_width = 0;
	DrawArea* _tmp0_;
	FormattedText* _tmp1_;
	FormattedText* _tmp2_;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoLayout* _tmp5_;
	PangoLayout* _tmp6_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (CanvasText*) g_object_new (object_type, NULL);
	int_max_width = (gint) self->priv->_max_width;
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = formatted_text_new (da);
	_formatted_text_unref0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = self->priv->_text;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _canvas_text_text_changed_formatted_text_changed, self, 0);
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) da, "M");
	_g_object_unref0 (self->priv->_line_layout);
	self->priv->_line_layout = _tmp3_;
	_tmp4_ = gtk_widget_create_pango_layout ((GtkWidget*) da, NULL);
	_g_object_unref0 (self->priv->_pango_layout);
	self->priv->_pango_layout = _tmp4_;
	_tmp5_ = self->priv->_pango_layout;
	pango_layout_set_wrap (_tmp5_, PANGO_WRAP_WORD_CHAR);
	_tmp6_ = self->priv->_pango_layout;
	pango_layout_set_width (_tmp6_, int_max_width * PANGO_SCALE);
	canvas_text_initialize_font_description (self);
	canvas_text_update_size (self, FALSE);
	return self;
}

CanvasText*
canvas_text_new (DrawArea* da)
{
	return canvas_text_construct (TYPE_CANVAS_TEXT, da);
}

CanvasText*
canvas_text_construct_with_text (GType object_type,
                                 DrawArea* da,
                                 const gchar* txt)
{
	CanvasText * self = NULL;
	gint int_max_width = 0;
	DrawArea* _tmp0_;
	FormattedText* _tmp1_;
	FormattedText* _tmp2_;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoLayout* _tmp5_;
	PangoLayout* _tmp6_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (txt != NULL, NULL);
	self = (CanvasText*) g_object_new (object_type, NULL);
	int_max_width = (gint) self->priv->_max_width;
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = formatted_text_new_with_text (da, txt);
	_formatted_text_unref0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = self->priv->_text;
	g_signal_connect_object (_tmp2_, "changed", (GCallback) _canvas_text_text_changed_formatted_text_changed, self, 0);
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) da, "M");
	_g_object_unref0 (self->priv->_line_layout);
	self->priv->_line_layout = _tmp3_;
	_tmp4_ = gtk_widget_create_pango_layout ((GtkWidget*) da, txt);
	_g_object_unref0 (self->priv->_pango_layout);
	self->priv->_pango_layout = _tmp4_;
	_tmp5_ = self->priv->_pango_layout;
	pango_layout_set_wrap (_tmp5_, PANGO_WRAP_WORD_CHAR);
	_tmp6_ = self->priv->_pango_layout;
	pango_layout_set_width (_tmp6_, int_max_width * PANGO_SCALE);
	canvas_text_initialize_font_description (self);
	canvas_text_update_size (self, FALSE);
	return self;
}

CanvasText*
canvas_text_new_with_text (DrawArea* da,
                           const gchar* txt)
{
	return canvas_text_construct_with_text (TYPE_CANVAS_TEXT, da, txt);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
canvas_text_initialize_font_description (CanvasText* self)
{
	PangoFontDescription* fd = NULL;
	PangoFontDescription* _tmp0_;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pango_font_description_new ();
	fd = _tmp0_;
	pango_font_description_set_size (fd, self->priv->_font_size * PANGO_SCALE);
	_tmp1_ = self->priv->_line_layout;
	pango_layout_set_font_description (_tmp1_, fd);
	_tmp2_ = self->priv->_pango_layout;
	pango_layout_set_font_description (_tmp2_, fd);
	__vala_PangoFontDescription_free0 (fd);
}

void
canvas_text_copy (CanvasText* self,
                  CanvasText* ct)
{
	gint int_max_width = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	FormattedText* _tmp4_;
	FormattedText* _tmp5_;
	FormattedText* _tmp6_;
	PangoLayout* _tmp7_;
	PangoLayout* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoLayout* _tmp11_;
	PangoFontDescription* _tmp12_;
	PangoLayout* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	int_max_width = (gint) self->priv->_max_width;
	_tmp0_ = canvas_text_get_posx (ct);
	_tmp1_ = _tmp0_;
	canvas_text_set_posx (self, _tmp1_);
	_tmp2_ = canvas_text_get_posy (ct);
	_tmp3_ = _tmp2_;
	canvas_text_set_posy (self, _tmp3_);
	self->priv->_max_width = ct->priv->_max_width;
	self->priv->_font_size = ct->priv->_font_size;
	_tmp4_ = self->priv->_text;
	_tmp5_ = canvas_text_get_text (ct);
	_tmp6_ = _tmp5_;
	formatted_text_copy (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->_line_layout;
	_tmp8_ = ct->priv->_pango_layout;
	_tmp9_ = pango_layout_get_font_description (_tmp8_);
	pango_layout_set_font_description (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->_pango_layout;
	_tmp11_ = ct->priv->_pango_layout;
	_tmp12_ = pango_layout_get_font_description (_tmp11_);
	pango_layout_set_font_description (_tmp10_, _tmp12_);
	_tmp13_ = self->priv->_pango_layout;
	pango_layout_set_width (_tmp13_, int_max_width * PANGO_SCALE);
	canvas_text_update_size (self, TRUE);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

PangoFontDescription*
canvas_text_get_font_fd (CanvasText* self)
{
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_line_layout;
	_tmp1_ = pango_layout_get_font_description (_tmp0_);
	_tmp2_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
canvas_text_set_font (CanvasText* self,
                      const gchar* family,
                      gint* size,
                      gdouble zoom_factor)
{
	PangoFontDescription* fd = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
	gint int_fsize = 0;
	PangoFontDescription* _tmp4_;
	PangoLayout* _tmp5_;
	PangoFontDescription* _tmp6_;
	PangoLayout* _tmp7_;
	PangoFontDescription* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_line_layout;
	_tmp1_ = pango_layout_get_font_description (_tmp0_);
	_tmp2_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	fd = _tmp2_;
	if (family != NULL) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = fd;
		pango_font_description_set_family (_tmp3_, family);
	}
	if (size != NULL) {
		self->priv->_font_size = *size;
	}
	int_fsize = (gint) ((self->priv->_font_size * zoom_factor) * PANGO_SCALE);
	_tmp4_ = fd;
	pango_font_description_set_size (_tmp4_, int_fsize);
	_tmp5_ = self->priv->_line_layout;
	_tmp6_ = fd;
	pango_layout_set_font_description (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_pango_layout;
	_tmp8_ = fd;
	pango_layout_set_font_description (_tmp7_, _tmp8_);
	canvas_text_update_size (self, TRUE);
	__vala_PangoFontDescription_free0 (fd);
}

gboolean
canvas_text_is_wrapped (CanvasText* self)
{
	PangoLayout* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pango_layout;
	result = pango_layout_is_wrapped (_tmp0_);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CanvasText* self;
		self = _data2_->self;
		_g_free0 (_data2_->str);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
__lambda34_ (Block2Data* _data2_,
             PangoLayoutLine* item)
{
	CanvasText* self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = _data2_->self;
	g_return_if_fail (item != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (_tmp3_, (glong) item->start_index, (glong) item->length);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_data2_->str, _tmp7_, NULL);
	_g_free0 (_data2_->str);
	_data2_->str = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}

static void
___lambda34__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda34_ (self, (PangoLayoutLine*) data);
}

gchar*
canvas_text_get_wrapped_text (CanvasText* self)
{
	Block2Data* _data2_;
	GSList* lines = NULL;
	PangoLayout* _tmp0_;
	GSList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->_pango_layout;
	_tmp1_ = pango_layout_get_lines_readonly (_tmp0_);
	lines = _tmp1_;
	_tmp2_ = g_strdup ("");
	_data2_->str = _tmp2_;
	g_slist_foreach (lines, ___lambda34__gfunc, _data2_);
	_tmp3_ = g_strdup (_data2_->str);
	result = _tmp3_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

gboolean
canvas_text_is_within (CanvasText* self,
                       gdouble x,
                       gdouble y)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = canvas_text_get_posx (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = canvas_text_get_posy (self);
	_tmp3_ = _tmp2_;
	result = utils_is_within_bounds (x, y, _tmp1_, _tmp3_, self->priv->_width, self->priv->_height);
	return result;
}

gboolean
canvas_text_is_within_clickable (CanvasText* self,
                                 gdouble x,
                                 gdouble y,
                                 FormatTag* tag,
                                 gchar** extra)
{
	FormatTag _vala_tag = 0;
	gchar* _vala_extra = NULL;
	gint adjusted_x = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gint adjusted_y = 0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint cursor = 0;
	gint trailing = 0;
	gchar* _tmp4_;
	PangoLayout* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = canvas_text_get_posx (self);
	_tmp1_ = _tmp0_;
	adjusted_x = ((gint) (x - _tmp1_)) * PANGO_SCALE;
	_tmp2_ = canvas_text_get_posy (self);
	_tmp3_ = _tmp2_;
	adjusted_y = ((gint) (y - _tmp3_)) * PANGO_SCALE;
	_vala_tag = FORMAT_TAG_URL;
	_tmp4_ = g_strdup ("");
	_g_free0 (_vala_extra);
	_vala_extra = _tmp4_;
	_tmp5_ = self->priv->_pango_layout;
	_tmp8_ = pango_layout_xy_to_index (_tmp5_, adjusted_x, adjusted_y, &_tmp6_, &_tmp7_);
	cursor = _tmp6_;
	trailing = _tmp7_;
	if (_tmp8_) {
		gint cindex = 0;
		FormattedText* _tmp9_;
		FormattedText* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		FormatTag* tags = NULL;
		FormatTag* _tmp13_;
		gint tags_length1;
		gint _tags_size_;
		FormatTag* _tmp14_;
		gint _tmp14__length1;
		_tmp9_ = canvas_text_get_text (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = formatted_text_get_text (_tmp10_);
		_tmp12_ = _tmp11_;
		cindex = g_utf8_strlen (_tmp12_, (gssize) (cursor + trailing));
		_tmp13_ = g_new0 (FormatTag, 1);
		_tmp13_[0] = FORMAT_TAG_URL;
		tags = _tmp13_;
		tags_length1 = 1;
		_tags_size_ = tags_length1;
		_tmp14_ = tags;
		_tmp14__length1 = tags_length1;
		{
			FormatTag* t_collection = NULL;
			gint t_collection_length1 = 0;
			gint _t_collection_size_ = 0;
			gint t_it = 0;
			t_collection = _tmp14_;
			t_collection_length1 = _tmp14__length1;
			for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
				FormatTag t = 0;
				t = t_collection[t_it];
				{
					gchar* e = NULL;
					FormattedText* _tmp15_;
					FormattedText* _tmp16_;
					gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp15_ = canvas_text_get_text (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = formatted_text_get_extra (_tmp16_, t, cindex);
					e = _tmp17_;
					_tmp18_ = e;
					if (_tmp18_ != NULL) {
						const gchar* _tmp19_;
						gchar* _tmp20_;
						_vala_tag = t;
						_tmp19_ = e;
						_tmp20_ = g_strdup (_tmp19_);
						_g_free0 (_vala_extra);
						_vala_extra = _tmp20_;
						result = TRUE;
						_g_free0 (e);
						tags = (g_free (tags), NULL);
						if (tag) {
							*tag = _vala_tag;
						}
						if (extra) {
							*extra = _vala_extra;
						} else {
							_g_free0 (_vala_extra);
						}
						return result;
					}
					_g_free0 (e);
				}
			}
		}
		tags = (g_free (tags), NULL);
	}
	result = FALSE;
	if (tag) {
		*tag = _vala_tag;
	}
	if (extra) {
		*extra = _vala_extra;
	} else {
		_g_free0 (_vala_extra);
	}
	return result;
}

gboolean
canvas_text_is_selected (CanvasText* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selstart != self->priv->_selend;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static xmlNode*
canvas_text_real_save (CanvasText* self,
                       const gchar* title)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FormattedText* _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* result;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) title);
	n = _tmp0_;
	_tmp1_ = double_to_string (self->priv->_max_width);
	_tmp2_ = _tmp1_;
	xmlSetProp (n, (xmlChar*) "maxwidth", (xmlChar*) _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_text;
	_tmp4_ = formatted_text_save (_tmp3_);
	xmlAddChild (n, _tmp4_);
	result = n;
	return result;
}

xmlNode*
canvas_text_save (CanvasText* self,
                  const gchar* title)
{
	CanvasTextClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CANVAS_TEXT_GET_CLASS (self);
	if (_klass_->save) {
		return _klass_->save (self, title);
	}
	return NULL;
}

gchar*
canvas_text_xml_text (xmlNode* n)
{
	gchar* _tmp11_;
	gchar* result;
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "text") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					xmlNode* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = it;
					_tmp10_ = formatted_text_xml_text (_tmp9_);
					result = _tmp10_;
					return result;
				}
			}
		}
	}
	_tmp11_ = g_strdup (_ ("No text found"));
	result = _tmp11_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
canvas_text_real_load (CanvasText* self,
                       xmlNode* n)
{
	gchar* mw = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "maxwidth");
	mw = _tmp0_;
	_tmp1_ = mw;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint int_max_width = 0;
		PangoLayout* _tmp3_;
		_tmp2_ = mw;
		self->priv->_max_width = double_parse (_tmp2_);
		int_max_width = (gint) self->priv->_max_width;
		_tmp3_ = self->priv->_pango_layout;
		pango_layout_set_width (_tmp3_, int_max_width * PANGO_SCALE);
	}
	{
		xmlNode* it = NULL;
		xmlNode* _tmp4_;
		_tmp4_ = n->children;
		it = _tmp4_;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp8_;
				gboolean _tmp9_ = FALSE;
				xmlNode* _tmp10_;
				if (!_tmp5_) {
					xmlNode* _tmp6_;
					xmlNode* _tmp7_;
					_tmp6_ = it;
					_tmp7_ = _tmp6_->next;
					it = _tmp7_;
				}
				_tmp5_ = FALSE;
				_tmp8_ = it;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp10_ = it;
				if (_tmp10_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = it;
					_tmp12_ = _tmp11_->name;
					_tmp9_ = g_strcmp0 (_tmp12_, "text") == 0;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					FormattedText* _tmp13_;
					xmlNode* _tmp14_;
					_tmp13_ = self->priv->_text;
					_tmp14_ = it;
					formatted_text_load (_tmp13_, _tmp14_);
					canvas_text_update_size (self, FALSE);
				}
			}
		}
	}
	_g_free0 (mw);
}

void
canvas_text_load (CanvasText* self,
                  xmlNode* n)
{
	CanvasTextClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CANVAS_TEXT_GET_CLASS (self);
	if (_klass_->load) {
		_klass_->load (self, n);
	}
}

gdouble
canvas_text_get_line_height (CanvasText* self)
{
	PangoLayout* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_pango_layout;
	result = utils_get_line_height (_tmp0_);
	return result;
}

gdouble
canvas_text_get_page_include_size (CanvasText* self,
                                   gint page_size)
{
	PangoRectangle ink_rect = {0};
	PangoRectangle log_rect = {0};
	gint line_count = 0;
	PangoLayout* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_pango_layout;
	line_count = pango_layout_get_line_count (_tmp0_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				PangoLayout* _tmp3_;
				PangoLayoutLine* _tmp4_;
				PangoRectangle _tmp5_ = {0};
				PangoRectangle _tmp6_ = {0};
				gint ly = 0;
				PangoRectangle _tmp7_;
				gint lh = 0;
				PangoRectangle _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < line_count)) {
					break;
				}
				_tmp3_ = self->priv->_pango_layout;
				_tmp4_ = pango_layout_get_line_readonly (_tmp3_, i);
				pango_layout_line_get_pixel_extents (_tmp4_, &_tmp5_, &_tmp6_);
				ink_rect = _tmp5_;
				log_rect = _tmp6_;
				_tmp7_ = log_rect;
				ly = (gint) _tmp7_.y;
				_tmp8_ = log_rect;
				lh = (gint) _tmp8_.height;
				if ((ly / page_size) != ((ly + lh) / page_size)) {
					result = (gdouble) ly;
					return result;
				}
			}
		}
	}
	result = self->priv->_height;
	return result;
}

static void
canvas_text_text_changed (CanvasText* self)
{
	g_return_if_fail (self != NULL);
	canvas_text_update_size (self, TRUE);
}

void
canvas_text_update_size (CanvasText* self,
                         gboolean call_resized)
{
	PangoLayout* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pango_layout;
	if (_tmp0_ != NULL) {
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		PangoLayout* _tmp5_;
		FormattedText* _tmp6_;
		PangoAttrList* _tmp7_;
		PangoAttrList* _tmp8_;
		PangoLayout* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp1_ = self->priv->_pango_layout;
		_tmp2_ = self->priv->_text;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		pango_layout_set_text (_tmp1_, _tmp4_, -1);
		_tmp5_ = self->priv->_pango_layout;
		_tmp6_ = self->priv->_text;
		_tmp7_ = formatted_text_get_attributes (_tmp6_);
		_tmp8_ = _tmp7_;
		pango_layout_set_attributes (_tmp5_, _tmp8_);
		_pango_attr_list_unref0 (_tmp8_);
		_tmp9_ = self->priv->_pango_layout;
		pango_layout_get_size (_tmp9_, &_tmp10_, &_tmp11_);
		text_width = _tmp10_;
		text_height = _tmp11_;
		self->priv->_width = (gdouble) (text_width / PANGO_SCALE);
		self->priv->_height = (gdouble) (text_height / PANGO_SCALE);
		if (call_resized) {
			g_signal_emit (self, canvas_text_signals[CANVAS_TEXT_RESIZED_SIGNAL], 0);
		}
	}
}

void
canvas_text_update_attributes (CanvasText* self)
{
	PangoLayout* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pango_layout;
	if (_tmp0_ != NULL) {
		PangoLayout* _tmp1_;
		FormattedText* _tmp2_;
		PangoAttrList* _tmp3_;
		PangoAttrList* _tmp4_;
		_tmp1_ = self->priv->_pango_layout;
		_tmp2_ = self->priv->_text;
		_tmp3_ = formatted_text_get_attributes (_tmp2_);
		_tmp4_ = _tmp3_;
		pango_layout_set_attributes (_tmp1_, _tmp4_);
		_pango_attr_list_unref0 (_tmp4_);
	}
}

static void
canvas_text_real_resize (CanvasText* self,
                         gdouble diff)
{
	gint int_max_width = 0;
	PangoLayout* _tmp0_;
	self->priv->_max_width = self->priv->_max_width + diff;
	int_max_width = (gint) self->priv->_max_width;
	_tmp0_ = self->priv->_pango_layout;
	pango_layout_set_width (_tmp0_, int_max_width * PANGO_SCALE);
	canvas_text_update_size (self, TRUE);
}

void
canvas_text_resize (CanvasText* self,
                    gdouble diff)
{
	CanvasTextClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CANVAS_TEXT_GET_CLASS (self);
	if (_klass_->resize) {
		_klass_->resize (self, diff);
	}
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static void
canvas_text_update_column (CanvasText* self)
{
	gint line = 0;
	gint cpos = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoLayout* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	cpos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_cursor);
	_tmp4_ = self->priv->_pango_layout;
	pango_layout_index_to_line_x (_tmp4_, cpos, FALSE, &_tmp5_, &_tmp6_);
	line = _tmp5_;
	self->priv->_column = _tmp6_;
}

void
canvas_text_set_cursor_only (CanvasText* self,
                             gint cursor)
{
	gint orig_cursor = 0;
	g_return_if_fail (self != NULL);
	orig_cursor = self->priv->_cursor;
	self->priv->_cursor = cursor;
	canvas_text_update_column (self);
	if (orig_cursor != self->priv->_cursor) {
		g_signal_emit (self, canvas_text_signals[CANVAS_TEXT_CURSOR_CHANGED_SIGNAL], 0);
	}
}

void
canvas_text_set_cursor_at_char (CanvasText* self,
                                gdouble x,
                                gdouble y,
                                gboolean motion)
{
	gint cursor = 0;
	gint trailing = 0;
	gint adjusted_x = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gint adjusted_y = 0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	PangoLayout* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	gint cindex = 0;
	FormattedText* _tmp16_;
	FormattedText* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_posx (self);
	_tmp1_ = _tmp0_;
	adjusted_x = ((gint) (x - _tmp1_)) * PANGO_SCALE;
	_tmp2_ = canvas_text_get_posy (self);
	_tmp3_ = _tmp2_;
	adjusted_y = ((gint) (y - _tmp3_)) * PANGO_SCALE;
	_tmp4_ = self->priv->_pango_layout;
	_tmp7_ = pango_layout_xy_to_index (_tmp4_, adjusted_x, adjusted_y, &_tmp5_, &_tmp6_);
	cursor = _tmp5_;
	trailing = _tmp6_;
	if (!_tmp7_) {
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		FormattedText* _tmp12_;
		FormattedText* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = canvas_text_get_text (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = formatted_text_get_text (_tmp13_);
		_tmp15_ = _tmp14_;
		cursor = string_index_of_nth_char (_tmp11_, (glong) g_utf8_strlen (_tmp15_, (gssize) -1));
		trailing = 0;
	}
	_tmp16_ = canvas_text_get_text (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = formatted_text_get_text (_tmp17_);
	_tmp19_ = _tmp18_;
	cindex = g_utf8_strlen (_tmp19_, (gssize) (cursor + trailing));
	if (motion) {
		if (cindex > self->priv->_selanchor) {
			canvas_text_change_selection (self, NULL, &cindex, "set_cursor_at_char A");
		} else {
			if (cindex < self->priv->_selanchor) {
				canvas_text_change_selection (self, &cindex, NULL, "set_cursor_at_char B");
			} else {
				canvas_text_change_selection (self, &cindex, &cindex, "set_cursor_at_char C");
			}
		}
	} else {
		canvas_text_change_selection (self, &cindex, &cindex, "set_cursor_at_char D");
		self->priv->_selanchor = cindex;
	}
	canvas_text_set_cursor_only (self, self->priv->_selend);
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

void
canvas_text_set_cursor_at_word (CanvasText* self,
                                gdouble x,
                                gdouble y,
                                gboolean motion)
{
	gint cursor = 0;
	gint trailing = 0;
	gint adjusted_x = 0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gint adjusted_y = 0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	PangoLayout* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_posx (self);
	_tmp1_ = _tmp0_;
	adjusted_x = ((gint) (x - _tmp1_)) * PANGO_SCALE;
	_tmp2_ = canvas_text_get_posy (self);
	_tmp3_ = _tmp2_;
	adjusted_y = ((gint) (y - _tmp3_)) * PANGO_SCALE;
	_tmp4_ = self->priv->_pango_layout;
	_tmp7_ = pango_layout_xy_to_index (_tmp4_, adjusted_x, adjusted_y, &_tmp5_, &_tmp6_);
	cursor = _tmp5_;
	trailing = _tmp6_;
	if (_tmp7_) {
		gint word_start = 0;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		gint word_end = 0;
		FormattedText* _tmp15_;
		FormattedText* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint* sstart = NULL;
		gint* send = NULL;
		gint* _tmp40_;
		gint* _tmp41_;
		cursor += trailing;
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) cursor);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_last_index_of (_tmp13_, " ", 0);
		_g_free0 (_tmp13_);
		word_start = _tmp14_;
		_tmp15_ = canvas_text_get_text (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = formatted_text_get_text (_tmp16_);
		_tmp18_ = _tmp17_;
		word_end = string_index_of (_tmp18_, " ", cursor);
		sstart = NULL;
		send = NULL;
		if (word_start == -1) {
			gint _tmp19_;
			gint* _tmp20_;
			_tmp19_ = 0;
			_tmp20_ = __int_dup0 (&_tmp19_);
			_g_free0 (sstart);
			sstart = _tmp20_;
		} else {
			gint windex = 0;
			FormattedText* _tmp21_;
			FormattedText* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp21_ = canvas_text_get_text (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = formatted_text_get_text (_tmp22_);
			_tmp24_ = _tmp23_;
			windex = g_utf8_strlen (_tmp24_, (gssize) word_start);
			if (!motion) {
				_tmp25_ = TRUE;
			} else {
				_tmp25_ = windex < self->priv->_selanchor;
			}
			if (_tmp25_) {
				gint _tmp26_;
				gint* _tmp27_;
				_tmp26_ = windex + 1;
				_tmp27_ = __int_dup0 (&_tmp26_);
				_g_free0 (sstart);
				sstart = _tmp27_;
			}
		}
		if (word_end == -1) {
			FormattedText* _tmp28_;
			FormattedText* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gint _tmp32_;
			gint* _tmp33_;
			_tmp28_ = canvas_text_get_text (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = formatted_text_get_text (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_utf8_strlen (_tmp31_, (gssize) -1);
			_tmp33_ = __int_dup0 (&_tmp32_);
			_g_free0 (send);
			send = _tmp33_;
		} else {
			gint windex = 0;
			FormattedText* _tmp34_;
			FormattedText* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gboolean _tmp38_ = FALSE;
			_tmp34_ = canvas_text_get_text (self);
			_tmp35_ = _tmp34_;
			_tmp36_ = formatted_text_get_text (_tmp35_);
			_tmp37_ = _tmp36_;
			windex = g_utf8_strlen (_tmp37_, (gssize) word_end);
			if (!motion) {
				_tmp38_ = TRUE;
			} else {
				_tmp38_ = windex > self->priv->_selanchor;
			}
			if (_tmp38_) {
				gint* _tmp39_;
				_tmp39_ = __int_dup0 (&windex);
				_g_free0 (send);
				send = _tmp39_;
			}
		}
		_tmp40_ = sstart;
		_tmp41_ = send;
		canvas_text_change_selection (self, _tmp40_, _tmp41_, "set_cursor_at_word");
		canvas_text_set_cursor_only (self, self->priv->_selend);
		_g_free0 (send);
		_g_free0 (sstart);
	}
}

void
canvas_text_clear_selection (CanvasText* self,
                             const gchar* msg)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_debug) {
		_tmp0_ = msg != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "In clear_selection, msg: %s\n", msg);
	}
	canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "clear_selection");
}

static void
canvas_text_adjust_selection (CanvasText* self,
                              gint last_cursor)
{
	g_return_if_fail (self != NULL);
	if (last_cursor == self->priv->_selstart) {
		if (self->priv->_cursor <= self->priv->_selend) {
			canvas_text_change_selection (self, &self->priv->_cursor, NULL, "adjust_selection A");
		} else {
			canvas_text_change_selection (self, NULL, &self->priv->_cursor, "adjust_selection B");
		}
	} else {
		if (self->priv->_cursor >= self->priv->_selstart) {
			canvas_text_change_selection (self, NULL, &self->priv->_cursor, "adjust_selection C");
		} else {
			canvas_text_change_selection (self, &self->priv->_cursor, NULL, "adjust_selection D");
		}
	}
}

void
canvas_text_set_cursor_none (CanvasText* self)
{
	g_return_if_fail (self != NULL);
	canvas_text_clear_selection (self, "set_cursor_none");
}

void
canvas_text_set_cursor_all (CanvasText* self,
                            gboolean motion)
{
	g_return_if_fail (self != NULL);
	if (!motion) {
		gint _tmp0_;
		FormattedText* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		_tmp0_ = 0;
		_tmp1_ = canvas_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_utf8_strlen (_tmp4_, (gssize) -1);
		canvas_text_change_selection (self, &_tmp0_, &_tmp5_, "set_cursor_all");
		self->priv->_selanchor = self->priv->_selend;
		canvas_text_set_cursor_only (self, self->priv->_selend);
	}
}

static gint
canvas_text_calc_direction (CanvasText* self,
                            gint dir)
{
	PangoDirection ldir = 0;
	PangoLayout* _tmp0_;
	FormattedText* _tmp1_;
	FormattedText* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_pango_layout;
	_tmp1_ = canvas_text_get_text (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = formatted_text_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	ldir = pango_layout_get_direction (_tmp0_, string_index_of_nth_char (_tmp4_, (glong) self->priv->_cursor));
	if (ldir == PANGO_DIRECTION_RTL) {
		_tmp5_ = 0 - dir;
	} else {
		_tmp5_ = dir;
	}
	result = _tmp5_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
canvas_text_cursor_by_char (CanvasText* self,
                            gint dir)
{
	gint last = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint cpos = 0;
	gboolean next_byte = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	last = g_utf8_strlen (_tmp3_, (gssize) -1);
	cpos = self->priv->_cursor;
	next_byte = FALSE;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			if (!_tmp4_) {
				if (!next_byte) {
					break;
				}
			}
			_tmp4_ = FALSE;
			cpos += canvas_text_calc_direction (self, dir);
			next_byte = FALSE;
			if (cpos < 0) {
				cpos = 0;
			} else {
				if (cpos > last) {
					cpos = last;
				} else {
					gunichar ch = 0U;
					FormattedText* _tmp5_;
					FormattedText* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					FormattedText* _tmp9_;
					FormattedText* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp5_ = canvas_text_get_text (self);
					_tmp6_ = _tmp5_;
					_tmp7_ = formatted_text_get_text (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = canvas_text_get_text (self);
					_tmp10_ = _tmp9_;
					_tmp11_ = formatted_text_get_text (_tmp10_);
					_tmp12_ = _tmp11_;
					ch = string_get_char (_tmp8_, (glong) string_index_of_nth_char (_tmp12_, (glong) cpos));
					next_byte = !g_unichar_isprint (ch);
				}
			}
		}
	}
	canvas_text_set_cursor_only (self, cpos);
}

void
canvas_text_move_cursor (CanvasText* self,
                         gint dir)
{
	g_return_if_fail (self != NULL);
	canvas_text_cursor_by_char (self, dir);
	canvas_text_clear_selection (self, "move_cursor");
}

void
canvas_text_selection_by_char (CanvasText* self,
                               gint dir)
{
	gint last_cursor = 0;
	g_return_if_fail (self != NULL);
	last_cursor = self->priv->_cursor;
	canvas_text_cursor_by_char (self, dir);
	canvas_text_adjust_selection (self, last_cursor);
}

static gpointer
_pango_layout_line_ref0 (gpointer self)
{
	return self ? pango_layout_line_ref (self) : NULL;
}

static void
canvas_text_cursor_by_line (CanvasText* self,
                            gint dir)
{
	gint line = 0;
	gint x = 0;
	gint cpos = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoLayout* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	cpos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_cursor);
	_tmp4_ = self->priv->_pango_layout;
	pango_layout_index_to_line_x (_tmp4_, cpos, FALSE, &_tmp5_, &_tmp6_);
	line = _tmp5_;
	x = _tmp6_;
	line += dir;
	if (line < 0) {
		canvas_text_set_cursor_only (self, 0);
	} else {
		PangoLayout* _tmp7_;
		_tmp7_ = self->priv->_pango_layout;
		if (line >= pango_layout_get_line_count (_tmp7_)) {
			FormattedText* _tmp8_;
			FormattedText* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = canvas_text_get_text (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = formatted_text_get_text (_tmp9_);
			_tmp11_ = _tmp10_;
			canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp11_, (gssize) -1));
		} else {
			gint index = 0;
			gint trailing = 0;
			PangoLayoutLine* line_layout = NULL;
			PangoLayout* _tmp12_;
			PangoLayoutLine* _tmp13_;
			PangoLayoutLine* _tmp14_;
			PangoLayoutLine* _tmp15_;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			FormattedText* _tmp18_;
			FormattedText* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp12_ = self->priv->_pango_layout;
			_tmp13_ = pango_layout_get_line (_tmp12_, line);
			_tmp14_ = _pango_layout_line_ref0 (_tmp13_);
			line_layout = _tmp14_;
			_tmp15_ = line_layout;
			pango_layout_line_x_to_index (_tmp15_, self->priv->_column, &_tmp16_, &_tmp17_);
			index = _tmp16_;
			trailing = _tmp17_;
			_tmp18_ = canvas_text_get_text (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = formatted_text_get_text (_tmp19_);
			_tmp21_ = _tmp20_;
			canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp21_, (gssize) (index + trailing)));
			_pango_layout_line_unref0 (line_layout);
		}
	}
}

void
canvas_text_move_cursor_vertically (CanvasText* self,
                                    gint dir)
{
	g_return_if_fail (self != NULL);
	canvas_text_cursor_by_line (self, dir);
	canvas_text_clear_selection (self, "move_cursor_vertically");
}

void
canvas_text_selection_vertically (CanvasText* self,
                                  gint dir)
{
	gint last_cursor = 0;
	g_return_if_fail (self != NULL);
	last_cursor = self->priv->_cursor;
	canvas_text_cursor_by_line (self, dir);
	canvas_text_adjust_selection (self, last_cursor);
}

static gint
canvas_text_find_line_extent (CanvasText* self,
                              gboolean start)
{
	gint line = 0;
	gint line2 = 0;
	gint column = 0;
	PangoLayout* _tmp0_;
	FormattedText* _tmp1_;
	FormattedText* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	PangoLayoutLine* line_layout = NULL;
	PangoLayout* _tmp7_;
	PangoLayoutLine* _tmp8_;
	PangoLayoutLine* _tmp9_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_pango_layout;
	_tmp1_ = canvas_text_get_text (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = formatted_text_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	pango_layout_index_to_line_x (_tmp0_, string_index_of_nth_char (_tmp4_, (glong) self->priv->_cursor), FALSE, &_tmp5_, &_tmp6_);
	line = _tmp5_;
	column = _tmp6_;
	_tmp7_ = self->priv->_pango_layout;
	_tmp8_ = pango_layout_get_line_readonly (_tmp7_, line);
	_tmp9_ = _pango_layout_line_ref0 (_tmp8_);
	line_layout = _tmp9_;
	if (start) {
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		PangoLayoutLine* _tmp14_;
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = line_layout;
		result = g_utf8_strlen (_tmp13_, (gssize) _tmp14_->start_index);
		_pango_layout_line_unref0 (line_layout);
		return result;
	} else {
		gint eol = 0;
		PangoLayoutLine* _tmp15_;
		PangoLayoutLine* _tmp16_;
		PangoLayout* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		FormattedText* _tmp21_;
		FormattedText* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp15_ = line_layout;
		_tmp16_ = line_layout;
		eol = _tmp15_->start_index + _tmp16_->length;
		_tmp17_ = self->priv->_pango_layout;
		pango_layout_index_to_line_x (_tmp17_, eol, FALSE, &_tmp18_, &_tmp19_);
		line2 = _tmp18_;
		column = _tmp19_;
		if (line != line2) {
			_tmp20_ = 1;
		} else {
			_tmp20_ = 0;
		}
		_tmp21_ = canvas_text_get_text (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = formatted_text_get_text (_tmp22_);
		_tmp24_ = _tmp23_;
		result = g_utf8_strlen (_tmp24_, (gssize) eol) - _tmp20_;
		_pango_layout_line_unref0 (line_layout);
		return result;
	}
}

void
canvas_text_move_cursor_to_start_of_line (CanvasText* self)
{
	g_return_if_fail (self != NULL);
	canvas_text_set_cursor_only (self, canvas_text_find_line_extent (self, TRUE));
	canvas_text_clear_selection (self, "move_cursor_to_start_of_line");
}

void
canvas_text_move_cursor_to_end_of_line (CanvasText* self)
{
	g_return_if_fail (self != NULL);
	canvas_text_set_cursor_only (self, canvas_text_find_line_extent (self, FALSE));
	canvas_text_clear_selection (self, "move_cursor_to_end_of_line");
}

void
canvas_text_selection_to_start_of_line (CanvasText* self,
                                        gboolean home)
{
	gint line_start = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	line_start = canvas_text_find_line_extent (self, TRUE);
	if (self->priv->_selstart == self->priv->_selend) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = home;
	}
	if (_tmp0_) {
		canvas_text_change_selection (self, &line_start, &self->priv->_cursor, "selection_to_line_start A");
		if (!home) {
			canvas_text_set_cursor_only (self, line_start);
		}
	} else {
		canvas_text_change_selection (self, &self->priv->_cursor, NULL, "selection_to_line_start B");
		canvas_text_set_cursor_only (self, line_start);
	}
}

void
canvas_text_selection_to_end_of_line (CanvasText* self,
                                      gboolean end)
{
	gint line_end = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	line_end = canvas_text_find_line_extent (self, FALSE);
	if (self->priv->_selstart == self->priv->_selend) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = end;
	}
	if (_tmp0_) {
		canvas_text_change_selection (self, &self->priv->_cursor, &line_end, "selection_to_end A");
		if (!end) {
			canvas_text_set_cursor_only (self, line_end);
		}
	} else {
		canvas_text_change_selection (self, NULL, &line_end, "selection_to_end B");
		canvas_text_set_cursor_only (self, line_end);
	}
}

void
canvas_text_move_cursor_to_start (CanvasText* self)
{
	g_return_if_fail (self != NULL);
	canvas_text_set_cursor_only (self, 0);
	canvas_text_clear_selection (self, "move_cursor_to_start");
}

void
canvas_text_move_cursor_to_end (CanvasText* self)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp3_, (gssize) -1));
	canvas_text_clear_selection (self, "move_cursor_to_end");
}

void
canvas_text_selection_to_start (CanvasText* self,
                                gboolean home)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_selstart == self->priv->_selend) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = home;
	}
	if (_tmp0_) {
		gint _tmp1_;
		_tmp1_ = 0;
		canvas_text_change_selection (self, &_tmp1_, &self->priv->_cursor, "selection_to_start A");
		if (!home) {
			canvas_text_set_cursor_only (self, 0);
		}
	} else {
		gint _tmp2_;
		_tmp2_ = 0;
		canvas_text_change_selection (self, &_tmp2_, NULL, "selection_to_start B");
		canvas_text_set_cursor_only (self, 0);
	}
}

void
canvas_text_selection_to_end (CanvasText* self,
                              gboolean end)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_selstart == self->priv->_selend) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = end;
	}
	if (_tmp0_) {
		FormattedText* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		_tmp1_ = canvas_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_utf8_strlen (_tmp4_, (gssize) -1);
		canvas_text_change_selection (self, &self->priv->_cursor, &_tmp5_, "selection_to_end A");
		if (!end) {
			FormattedText* _tmp6_;
			FormattedText* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp6_ = canvas_text_get_text (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = formatted_text_get_text (_tmp7_);
			_tmp9_ = _tmp8_;
			canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp9_, (gssize) -1));
		}
	} else {
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		FormattedText* _tmp15_;
		FormattedText* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_utf8_strlen (_tmp13_, (gssize) -1);
		canvas_text_change_selection (self, NULL, &_tmp14_, "selection_to_end B");
		_tmp15_ = canvas_text_get_text (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = formatted_text_get_text (_tmp16_);
		_tmp18_ = _tmp17_;
		canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp18_, (gssize) -1));
	}
}

static gint
canvas_text_find_word (CanvasText* self,
                       gint start,
                       gint dir)
{
	gboolean alnum_found = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	alnum_found = FALSE;
	if (canvas_text_calc_direction (self, dir) == 1) {
		FormattedText* _tmp14_;
		FormattedText* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		{
			gint i = 0;
			i = start;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					FormattedText* _tmp2_;
					FormattedText* _tmp3_;
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					gint index = 0;
					FormattedText* _tmp6_;
					FormattedText* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					FormattedText* _tmp10_;
					FormattedText* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = canvas_text_get_text (self);
					_tmp3_ = _tmp2_;
					_tmp4_ = formatted_text_get_text (_tmp3_);
					_tmp5_ = _tmp4_;
					if (!(i < g_utf8_strlen (_tmp5_, (gssize) -1))) {
						break;
					}
					_tmp6_ = canvas_text_get_text (self);
					_tmp7_ = _tmp6_;
					_tmp8_ = formatted_text_get_text (_tmp7_);
					_tmp9_ = _tmp8_;
					index = string_index_of_nth_char (_tmp9_, (glong) i);
					_tmp10_ = canvas_text_get_text (self);
					_tmp11_ = _tmp10_;
					_tmp12_ = formatted_text_get_text (_tmp11_);
					_tmp13_ = _tmp12_;
					if (g_unichar_isalnum (string_get_char (_tmp13_, (glong) index))) {
						alnum_found = TRUE;
					} else {
						if (alnum_found) {
							result = i;
							return result;
						}
					}
				}
			}
		}
		_tmp14_ = canvas_text_get_text (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = formatted_text_get_text (_tmp15_);
		_tmp17_ = _tmp16_;
		result = g_utf8_strlen (_tmp17_, (gssize) -1);
		return result;
	} else {
		{
			gint i = 0;
			i = start - 1;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint index = 0;
					FormattedText* _tmp20_;
					FormattedText* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					FormattedText* _tmp24_;
					FormattedText* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ - 1;
					}
					_tmp18_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp20_ = canvas_text_get_text (self);
					_tmp21_ = _tmp20_;
					_tmp22_ = formatted_text_get_text (_tmp21_);
					_tmp23_ = _tmp22_;
					index = string_index_of_nth_char (_tmp23_, (glong) i);
					_tmp24_ = canvas_text_get_text (self);
					_tmp25_ = _tmp24_;
					_tmp26_ = formatted_text_get_text (_tmp25_);
					_tmp27_ = _tmp26_;
					if (g_unichar_isalnum (string_get_char (_tmp27_, (glong) index))) {
						alnum_found = TRUE;
					} else {
						if (alnum_found) {
							result = i + 1;
							return result;
						}
					}
				}
			}
		}
		result = 0;
		return result;
	}
}

void
canvas_text_move_cursor_by_word (CanvasText* self,
                                 gint dir)
{
	g_return_if_fail (self != NULL);
	canvas_text_set_cursor_only (self, canvas_text_find_word (self, self->priv->_cursor, dir));
	canvas_text_clear_selection (self, "move_cursor_by_word");
}

void
canvas_text_selection_by_word (CanvasText* self,
                               gint dir)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_cursor == self->priv->_selstart) {
		canvas_text_set_cursor_only (self, canvas_text_find_word (self, self->priv->_cursor, dir));
		if (self->priv->_cursor <= self->priv->_selend) {
			canvas_text_change_selection (self, &self->priv->_cursor, NULL, "selection_by_word A");
		} else {
			canvas_text_change_selection (self, &self->priv->_selend, &self->priv->_cursor, "selection_by_word B");
		}
	} else {
		canvas_text_set_cursor_only (self, canvas_text_find_word (self, self->priv->_cursor, dir));
		if (self->priv->_cursor >= self->priv->_selstart) {
			canvas_text_change_selection (self, NULL, &self->priv->_cursor, "selection_by_word C");
		} else {
			canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_selstart, "selection_by_word D");
		}
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
canvas_text_backspace (CanvasText* self,
                       UndoTextBuffer* undo_buffer)
{
	gint cur = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	cur = self->priv->_cursor;
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint epos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* str = NULL;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GArray* tags = NULL;
		FormattedText* _tmp13_;
		FormattedText* _tmp14_;
		GArray* _tmp15_;
		FormattedText* _tmp16_;
		FormattedText* _tmp17_;
		const gchar* _tmp18_;
		GArray* _tmp19_;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		spos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		epos = string_index_of_nth_char (_tmp7_, (glong) self->priv->_selend);
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_slice (_tmp11_, (glong) spos, (glong) epos);
		str = _tmp12_;
		_tmp13_ = canvas_text_get_text (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = formatted_text_get_tags_in_range (_tmp14_, spos, epos);
		tags = _tmp15_;
		canvas_text_set_cursor_only (self, self->priv->_selstart);
		canvas_text_change_selection (self, NULL, &self->priv->_selstart, "backspace");
		_tmp16_ = canvas_text_get_text (self);
		_tmp17_ = _tmp16_;
		formatted_text_remove_text (_tmp17_, spos, epos - spos);
		_tmp18_ = str;
		_tmp19_ = tags;
		undo_text_buffer_add_delete (undo_buffer, spos, _tmp18_, _tmp19_, cur);
		_g_array_unref0 (tags);
		_g_free0 (str);
	} else {
		if (self->priv->_cursor > 0) {
			gint spos = 0;
			FormattedText* _tmp20_;
			FormattedText* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gint epos = 0;
			FormattedText* _tmp24_;
			FormattedText* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* str = NULL;
			FormattedText* _tmp28_;
			FormattedText* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			GArray* tags = NULL;
			FormattedText* _tmp33_;
			FormattedText* _tmp34_;
			GArray* _tmp35_;
			FormattedText* _tmp36_;
			FormattedText* _tmp37_;
			const gchar* _tmp38_;
			GArray* _tmp39_;
			_tmp20_ = canvas_text_get_text (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = formatted_text_get_text (_tmp21_);
			_tmp23_ = _tmp22_;
			spos = string_index_of_nth_char (_tmp23_, (glong) (self->priv->_cursor - 1));
			_tmp24_ = canvas_text_get_text (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = formatted_text_get_text (_tmp25_);
			_tmp27_ = _tmp26_;
			epos = string_index_of_nth_char (_tmp27_, (glong) self->priv->_cursor);
			_tmp28_ = canvas_text_get_text (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = formatted_text_get_text (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = string_slice (_tmp31_, (glong) spos, (glong) epos);
			str = _tmp32_;
			_tmp33_ = canvas_text_get_text (self);
			_tmp34_ = _tmp33_;
			_tmp35_ = formatted_text_get_tags_in_range (_tmp34_, spos, epos);
			tags = _tmp35_;
			canvas_text_set_cursor_only (self, self->priv->_cursor - 1);
			_tmp36_ = canvas_text_get_text (self);
			_tmp37_ = _tmp36_;
			formatted_text_remove_text (_tmp37_, spos, epos - spos);
			_tmp38_ = str;
			_tmp39_ = tags;
			undo_text_buffer_add_delete (undo_buffer, spos, _tmp38_, _tmp39_, cur);
			_g_array_unref0 (tags);
			_g_free0 (str);
		}
	}
}

void
canvas_text_backspace_word (CanvasText* self,
                            UndoTextBuffer* undo_buffer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	if (self->priv->_cursor > 0) {
		gint cur = 0;
		gint epos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint wpos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_ = 0;
		gint spos = 0;
		FormattedText* _tmp13_;
		FormattedText* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* str = NULL;
		FormattedText* _tmp17_;
		FormattedText* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		GArray* tags = NULL;
		FormattedText* _tmp22_;
		FormattedText* _tmp23_;
		GArray* _tmp24_;
		FormattedText* _tmp25_;
		FormattedText* _tmp26_;
		const gchar* _tmp27_;
		GArray* _tmp28_;
		cur = self->priv->_cursor;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		epos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_cursor);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		wpos = utils_find_word (_tmp7_, self->priv->_cursor, TRUE);
		if (wpos == -1) {
			_tmp8_ = 0;
		} else {
			FormattedText* _tmp9_;
			FormattedText* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp9_ = canvas_text_get_text (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = formatted_text_get_text (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = g_utf8_strlen (_tmp12_, (gssize) wpos);
		}
		wpos = _tmp8_;
		_tmp13_ = canvas_text_get_text (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = formatted_text_get_text (_tmp14_);
		_tmp16_ = _tmp15_;
		spos = string_index_of_nth_char (_tmp16_, (glong) wpos);
		_tmp17_ = canvas_text_get_text (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = formatted_text_get_text (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_slice (_tmp20_, (glong) spos, (glong) epos);
		str = _tmp21_;
		_tmp22_ = canvas_text_get_text (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = formatted_text_get_tags_in_range (_tmp23_, spos, epos);
		tags = _tmp24_;
		canvas_text_set_cursor_only (self, spos);
		_tmp25_ = canvas_text_get_text (self);
		_tmp26_ = _tmp25_;
		formatted_text_remove_text (_tmp26_, spos, epos - spos);
		_tmp27_ = str;
		_tmp28_ = tags;
		undo_text_buffer_add_delete (undo_buffer, spos, _tmp27_, _tmp28_, cur);
		if (self->priv->_selstart < wpos) {
			canvas_text_change_selection (self, NULL, &wpos, "backspace_word1");
		} else {
			if (self->priv->_selend > cur) {
				gint _tmp29_;
				_tmp29_ = self->priv->_selend - (cur - wpos);
				canvas_text_change_selection (self, &wpos, &_tmp29_, "backspace_word2");
			} else {
				canvas_text_change_selection (self, &wpos, &wpos, "backspace_word3");
			}
		}
		_g_array_unref0 (tags);
		_g_free0 (str);
	}
}

void
canvas_text_delete (CanvasText* self,
                    UndoTextBuffer* undo_buffer)
{
	gint cur = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	cur = self->priv->_cursor;
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint epos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* str = NULL;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GArray* tags = NULL;
		FormattedText* _tmp13_;
		FormattedText* _tmp14_;
		GArray* _tmp15_;
		FormattedText* _tmp16_;
		FormattedText* _tmp17_;
		const gchar* _tmp18_;
		GArray* _tmp19_;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		spos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		epos = string_index_of_nth_char (_tmp7_, (glong) self->priv->_selend);
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_slice (_tmp11_, (glong) spos, (glong) epos);
		str = _tmp12_;
		_tmp13_ = canvas_text_get_text (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = formatted_text_get_tags_in_range (_tmp14_, spos, epos);
		tags = _tmp15_;
		canvas_text_set_cursor_only (self, self->priv->_selstart);
		canvas_text_change_selection (self, NULL, &self->priv->_selstart, "delete");
		_tmp16_ = canvas_text_get_text (self);
		_tmp17_ = _tmp16_;
		formatted_text_remove_text (_tmp17_, spos, epos - spos);
		_tmp18_ = str;
		_tmp19_ = tags;
		undo_text_buffer_add_delete (undo_buffer, spos, _tmp18_, _tmp19_, cur);
		_g_array_unref0 (tags);
		_g_free0 (str);
	} else {
		FormattedText* _tmp20_;
		FormattedText* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = canvas_text_get_text (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = formatted_text_get_text (_tmp21_);
		_tmp23_ = _tmp22_;
		if (self->priv->_cursor < g_utf8_strlen (_tmp23_, (gssize) -1)) {
			gint spos = 0;
			FormattedText* _tmp24_;
			FormattedText* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gint epos = 0;
			FormattedText* _tmp28_;
			FormattedText* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* str = NULL;
			FormattedText* _tmp32_;
			FormattedText* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			GArray* tags = NULL;
			FormattedText* _tmp37_;
			FormattedText* _tmp38_;
			GArray* _tmp39_;
			FormattedText* _tmp40_;
			FormattedText* _tmp41_;
			const gchar* _tmp42_;
			GArray* _tmp43_;
			_tmp24_ = canvas_text_get_text (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = formatted_text_get_text (_tmp25_);
			_tmp27_ = _tmp26_;
			spos = string_index_of_nth_char (_tmp27_, (glong) self->priv->_cursor);
			_tmp28_ = canvas_text_get_text (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = formatted_text_get_text (_tmp29_);
			_tmp31_ = _tmp30_;
			epos = string_index_of_nth_char (_tmp31_, (glong) (self->priv->_cursor + 1));
			_tmp32_ = canvas_text_get_text (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = formatted_text_get_text (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = string_slice (_tmp35_, (glong) spos, (glong) epos);
			str = _tmp36_;
			_tmp37_ = canvas_text_get_text (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = formatted_text_get_tags_in_range (_tmp38_, spos, epos);
			tags = _tmp39_;
			_tmp40_ = canvas_text_get_text (self);
			_tmp41_ = _tmp40_;
			formatted_text_remove_text (_tmp41_, spos, epos - spos);
			_tmp42_ = str;
			_tmp43_ = tags;
			undo_text_buffer_add_delete (undo_buffer, spos, _tmp42_, _tmp43_, cur);
			_g_array_unref0 (tags);
			_g_free0 (str);
		}
	}
}

void
canvas_text_delete_range (CanvasText* self,
                          gint startpos,
                          gint endpos,
                          UndoTextBuffer* undo_buffer)
{
	gint cur = 0;
	gint spos = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint epos = 0;
	FormattedText* _tmp4_;
	FormattedText* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* str = NULL;
	FormattedText* _tmp8_;
	FormattedText* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GArray* tags = NULL;
	FormattedText* _tmp13_;
	FormattedText* _tmp14_;
	GArray* _tmp15_;
	FormattedText* _tmp16_;
	FormattedText* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	cur = self->priv->_cursor;
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	spos = string_index_of_nth_char (_tmp3_, (glong) startpos);
	_tmp4_ = canvas_text_get_text (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = formatted_text_get_text (_tmp5_);
	_tmp7_ = _tmp6_;
	epos = string_index_of_nth_char (_tmp7_, (glong) endpos);
	_tmp8_ = canvas_text_get_text (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = formatted_text_get_text (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp11_, (glong) spos, (glong) epos);
	str = _tmp12_;
	_tmp13_ = canvas_text_get_text (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = formatted_text_get_tags_in_range (_tmp14_, spos, epos);
	tags = _tmp15_;
	canvas_text_set_cursor_only (self, startpos);
	_tmp16_ = canvas_text_get_text (self);
	_tmp17_ = _tmp16_;
	formatted_text_remove_text (_tmp17_, spos, epos - spos);
	undo_text_buffer_add_delete (undo_buffer, spos, str, tags, cur);
	_g_array_unref0 (tags);
	_g_free0 (str);
}

void
canvas_text_delete_word (CanvasText* self,
                         UndoTextBuffer* undo_buffer)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (self->priv->_cursor < _tmp5_) {
		gint spos = 0;
		FormattedText* _tmp6_;
		FormattedText* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint wpos = 0;
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_ = 0;
		gint epos = 0;
		FormattedText* _tmp25_;
		FormattedText* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* str = NULL;
		FormattedText* _tmp29_;
		FormattedText* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		GArray* tags = NULL;
		FormattedText* _tmp34_;
		FormattedText* _tmp35_;
		GArray* _tmp36_;
		FormattedText* _tmp37_;
		FormattedText* _tmp38_;
		const gchar* _tmp39_;
		GArray* _tmp40_;
		_tmp6_ = canvas_text_get_text (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = formatted_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		spos = string_index_of_nth_char (_tmp9_, (glong) self->priv->_cursor);
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = canvas_text_get_cursor (self);
		_tmp15_ = _tmp14_;
		wpos = utils_find_word (_tmp13_, _tmp15_, FALSE);
		if (wpos == -1) {
			FormattedText* _tmp17_;
			FormattedText* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = canvas_text_get_text (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = formatted_text_get_text (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp16_ = g_utf8_strlen (_tmp20_, (gssize) -1);
		} else {
			FormattedText* _tmp21_;
			FormattedText* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp21_ = canvas_text_get_text (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = formatted_text_get_text (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp16_ = g_utf8_strlen (_tmp24_, (gssize) wpos);
		}
		wpos = _tmp16_;
		_tmp25_ = canvas_text_get_text (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = formatted_text_get_text (_tmp26_);
		_tmp28_ = _tmp27_;
		epos = string_index_of_nth_char (_tmp28_, (glong) wpos);
		_tmp29_ = canvas_text_get_text (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = formatted_text_get_text (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = string_slice (_tmp32_, (glong) spos, (glong) epos);
		str = _tmp33_;
		_tmp34_ = canvas_text_get_text (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = formatted_text_get_tags_in_range (_tmp35_, spos, epos);
		tags = _tmp36_;
		_tmp37_ = canvas_text_get_text (self);
		_tmp38_ = _tmp37_;
		formatted_text_remove_text (_tmp38_, spos, epos - spos);
		_tmp39_ = str;
		_tmp40_ = tags;
		undo_text_buffer_add_delete (undo_buffer, spos, _tmp39_, _tmp40_, self->priv->_cursor);
		if (self->priv->_selstart < self->priv->_cursor) {
			canvas_text_change_selection (self, NULL, &self->priv->_cursor, "delete_word1");
		} else {
			if (self->priv->_selend > wpos) {
				gint _tmp41_;
				_tmp41_ = self->priv->_selend - (wpos - self->priv->_cursor);
				canvas_text_change_selection (self, &self->priv->_cursor, &_tmp41_, "delete_word2");
			} else {
				canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "delete_word3");
			}
		}
		_g_array_unref0 (tags);
		_g_free0 (str);
	}
}

void
canvas_text_insert (CanvasText* self,
                    const gchar* s,
                    UndoTextBuffer* undo_buffer)
{
	gint slen = 0;
	gint cur = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (undo_buffer != NULL);
	slen = g_utf8_strlen (s, (gssize) -1);
	cur = self->priv->_cursor;
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint epos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* str = NULL;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		GArray* tags = NULL;
		FormattedText* _tmp13_;
		FormattedText* _tmp14_;
		GArray* _tmp15_;
		FormattedText* _tmp16_;
		FormattedText* _tmp17_;
		const gchar* _tmp18_;
		GArray* _tmp19_;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		spos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		epos = string_index_of_nth_char (_tmp7_, (glong) self->priv->_selend);
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_slice (_tmp11_, (glong) spos, (glong) epos);
		str = _tmp12_;
		_tmp13_ = canvas_text_get_text (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = formatted_text_get_tags_in_range (_tmp14_, spos, epos);
		tags = _tmp15_;
		_tmp16_ = canvas_text_get_text (self);
		_tmp17_ = _tmp16_;
		formatted_text_replace_text (_tmp17_, spos, epos - spos, s);
		canvas_text_set_cursor_only (self, self->priv->_selstart + slen);
		canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "insert A");
		_tmp18_ = str;
		_tmp19_ = tags;
		undo_text_buffer_add_replace (undo_buffer, spos, _tmp18_, s, _tmp19_, cur);
		_g_array_unref0 (tags);
		_g_free0 (str);
	} else {
		gint cpos = 0;
		FormattedText* _tmp20_;
		FormattedText* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		FormattedText* _tmp24_;
		FormattedText* _tmp25_;
		_tmp20_ = canvas_text_get_text (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = formatted_text_get_text (_tmp21_);
		_tmp23_ = _tmp22_;
		cpos = string_index_of_nth_char (_tmp23_, (glong) self->priv->_cursor);
		_tmp24_ = canvas_text_get_text (self);
		_tmp25_ = _tmp24_;
		formatted_text_insert_text (_tmp25_, cpos, s);
		canvas_text_set_cursor_only (self, self->priv->_cursor + slen);
		canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "insert B");
		undo_text_buffer_add_insert (undo_buffer, cpos, s, cur);
	}
}

void
canvas_text_insert_at_pos (CanvasText* self,
                           gint start,
                           const gchar* s,
                           UndoTextBuffer* undo_buffer)
{
	gint slen = 0;
	gint cur = 0;
	gint spos = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FormattedText* _tmp4_;
	FormattedText* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (undo_buffer != NULL);
	slen = g_utf8_strlen (s, (gssize) -1);
	cur = self->priv->_cursor;
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	spos = string_index_of_nth_char (_tmp3_, (glong) start);
	_tmp4_ = canvas_text_get_text (self);
	_tmp5_ = _tmp4_;
	formatted_text_insert_text (_tmp5_, spos, s);
	_tmp6_ = canvas_text_get_cursor (self);
	_tmp7_ = _tmp6_;
	if (start <= _tmp7_) {
		canvas_text_set_cursor_only (self, self->priv->_cursor + slen);
	}
	canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "insert_at_pos");
	undo_text_buffer_add_insert (undo_buffer, spos, s, cur);
}

static gpointer
_undo_tag_info_ref0 (gpointer self)
{
	return self ? undo_tag_info_ref (self) : NULL;
}

void
canvas_text_insert_formatted_text (CanvasText* self,
                                   FormattedText* t,
                                   UndoTextBuffer* undo_buffer)
{
	gint slen = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GArray* ttags = NULL;
	GArray* _tmp2_;
	gint cur = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = formatted_text_get_text (t);
	_tmp1_ = _tmp0_;
	slen = g_utf8_strlen (_tmp1_, (gssize) -1);
	_tmp2_ = formatted_text_get_tags_in_range (t, 0, slen);
	ttags = _tmp2_;
	cur = self->priv->_cursor;
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp3_;
		FormattedText* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint epos = 0;
		FormattedText* _tmp7_;
		FormattedText* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* str = NULL;
		FormattedText* _tmp11_;
		FormattedText* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GArray* tags = NULL;
		FormattedText* _tmp16_;
		FormattedText* _tmp17_;
		GArray* _tmp18_;
		FormattedText* _tmp19_;
		FormattedText* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		GArray* _tmp49_;
		_tmp3_ = canvas_text_get_text (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = formatted_text_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		spos = string_index_of_nth_char (_tmp6_, (glong) self->priv->_selstart);
		_tmp7_ = canvas_text_get_text (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = formatted_text_get_text (_tmp8_);
		_tmp10_ = _tmp9_;
		epos = string_index_of_nth_char (_tmp10_, (glong) self->priv->_selend);
		_tmp11_ = canvas_text_get_text (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = formatted_text_get_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_slice (_tmp14_, (glong) spos, (glong) epos);
		str = _tmp15_;
		_tmp16_ = canvas_text_get_text (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = formatted_text_get_tags_in_range (_tmp17_, spos, epos);
		tags = _tmp18_;
		_tmp19_ = canvas_text_get_text (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = formatted_text_get_text (t);
		_tmp22_ = _tmp21_;
		formatted_text_replace_text (_tmp20_, spos, epos - spos, _tmp22_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp23_ = FALSE;
				_tmp23_ = TRUE;
				while (TRUE) {
					GArray* _tmp25_;
					UndoTagInfo* ttag = NULL;
					GArray* _tmp26_;
					UndoTagInfo* _tmp27_;
					UndoTagInfo* _tmp28_;
					FormatTag ftag = 0;
					UndoTagInfo* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					FormattedText* _tmp32_;
					FormattedText* _tmp33_;
					UndoTagInfo* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					UndoTagInfo* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					UndoTagInfo* _tmp40_;
					gboolean _tmp41_;
					gboolean _tmp42_;
					UndoTagInfo* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					if (!_tmp23_) {
						gint _tmp24_;
						_tmp24_ = i;
						i = _tmp24_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp25_ = ttags;
					if (!(((guint) i) < _tmp25_->len)) {
						break;
					}
					_tmp26_ = ttags;
					_tmp27_ = g_array_index (_tmp26_, UndoTagInfo*, (guint) i);
					_tmp28_ = _undo_tag_info_ref0 (_tmp27_);
					ttag = _tmp28_;
					_tmp29_ = ttag;
					_tmp30_ = undo_tag_info_get_tag (_tmp29_);
					_tmp31_ = _tmp30_;
					ftag = (FormatTag) _tmp31_;
					_tmp32_ = canvas_text_get_text (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = ttag;
					_tmp35_ = undo_tag_info_get_start (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = ttag;
					_tmp38_ = undo_tag_info_get_end (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = ttag;
					_tmp41_ = undo_tag_info_get_parsed (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = ttag;
					_tmp44_ = undo_tag_info_get_extra (_tmp43_);
					_tmp45_ = _tmp44_;
					formatted_text_add_tag (_tmp33_, ftag, _tmp36_ + spos, _tmp39_ + spos, _tmp42_, _tmp45_);
					_undo_tag_info_unref0 (ttag);
				}
			}
		}
		canvas_text_set_cursor_only (self, self->priv->_selstart + slen);
		canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "insert_formatted_text A");
		_tmp46_ = str;
		_tmp47_ = formatted_text_get_text (t);
		_tmp48_ = _tmp47_;
		_tmp49_ = tags;
		undo_text_buffer_add_replace (undo_buffer, spos, _tmp46_, _tmp48_, _tmp49_, cur);
		_g_array_unref0 (tags);
		_g_free0 (str);
	} else {
		gint cpos = 0;
		FormattedText* _tmp50_;
		FormattedText* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		FormattedText* _tmp54_;
		FormattedText* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp81_;
		const gchar* _tmp82_;
		_tmp50_ = canvas_text_get_text (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = formatted_text_get_text (_tmp51_);
		_tmp53_ = _tmp52_;
		cpos = string_index_of_nth_char (_tmp53_, (glong) self->priv->_cursor);
		_tmp54_ = canvas_text_get_text (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = formatted_text_get_text (t);
		_tmp57_ = _tmp56_;
		formatted_text_insert_text (_tmp55_, cpos, _tmp57_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp58_ = FALSE;
				_tmp58_ = TRUE;
				while (TRUE) {
					GArray* _tmp60_;
					UndoTagInfo* ttag = NULL;
					GArray* _tmp61_;
					UndoTagInfo* _tmp62_;
					UndoTagInfo* _tmp63_;
					FormatTag ftag = 0;
					UndoTagInfo* _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					FormattedText* _tmp67_;
					FormattedText* _tmp68_;
					UndoTagInfo* _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					UndoTagInfo* _tmp72_;
					gint _tmp73_;
					gint _tmp74_;
					UndoTagInfo* _tmp75_;
					gboolean _tmp76_;
					gboolean _tmp77_;
					UndoTagInfo* _tmp78_;
					const gchar* _tmp79_;
					const gchar* _tmp80_;
					if (!_tmp58_) {
						gint _tmp59_;
						_tmp59_ = i;
						i = _tmp59_ + 1;
					}
					_tmp58_ = FALSE;
					_tmp60_ = ttags;
					if (!(((guint) i) < _tmp60_->len)) {
						break;
					}
					_tmp61_ = ttags;
					_tmp62_ = g_array_index (_tmp61_, UndoTagInfo*, (guint) i);
					_tmp63_ = _undo_tag_info_ref0 (_tmp62_);
					ttag = _tmp63_;
					_tmp64_ = ttag;
					_tmp65_ = undo_tag_info_get_tag (_tmp64_);
					_tmp66_ = _tmp65_;
					ftag = (FormatTag) _tmp66_;
					_tmp67_ = canvas_text_get_text (self);
					_tmp68_ = _tmp67_;
					_tmp69_ = ttag;
					_tmp70_ = undo_tag_info_get_start (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = ttag;
					_tmp73_ = undo_tag_info_get_end (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = ttag;
					_tmp76_ = undo_tag_info_get_parsed (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = ttag;
					_tmp79_ = undo_tag_info_get_extra (_tmp78_);
					_tmp80_ = _tmp79_;
					formatted_text_add_tag (_tmp68_, ftag, _tmp71_ + cpos, _tmp74_ + cpos, _tmp77_, _tmp80_);
					_undo_tag_info_unref0 (ttag);
				}
			}
		}
		canvas_text_set_cursor_only (self, self->priv->_cursor + slen);
		canvas_text_change_selection (self, &self->priv->_cursor, &self->priv->_cursor, "insert_formatted_text A");
		_tmp81_ = formatted_text_get_text (t);
		_tmp82_ = _tmp81_;
		undo_text_buffer_add_insert (undo_buffer, cpos, _tmp82_, cur);
	}
	_g_array_unref0 (ttags);
}

static gpointer
_insert_text_dup0 (gpointer self)
{
	return self ? insert_text_dup (self) : NULL;
}

void
canvas_text_insert_ranges (CanvasText* self,
                           GArray* its,
                           UndoTextBuffer* undo_buffer)
{
	gint cur = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (its != NULL);
	g_return_if_fail (undo_buffer != NULL);
	cur = self->priv->_cursor;
	{
		gint i = 0;
		i = (gint) (its->len - 1);
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				InsertText* it = NULL;
				InsertText* _tmp2_;
				gint slen = 0;
				InsertText* _tmp3_;
				const gchar* _tmp4_;
				FormattedText* _tmp5_;
				FormattedText* _tmp6_;
				InsertText* _tmp7_;
				InsertText* _tmp8_;
				const gchar* _tmp9_;
				InsertText* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				InsertText* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ - 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp2_ = _insert_text_dup0 (g_array_index (its, InsertText*, (guint) i));
				it = _tmp2_;
				_tmp3_ = it;
				_tmp4_ = (*_tmp3_).text;
				slen = g_utf8_strlen (_tmp4_, (gssize) -1);
				_tmp5_ = canvas_text_get_text (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = it;
				_tmp8_ = it;
				_tmp9_ = (*_tmp8_).text;
				formatted_text_insert_text (_tmp6_, (*_tmp7_).start, _tmp9_);
				_tmp10_ = it;
				_tmp11_ = canvas_text_get_cursor (self);
				_tmp12_ = _tmp11_;
				if ((*_tmp10_).start < _tmp12_) {
					canvas_text_set_cursor_only (self, self->priv->_cursor + slen);
				}
				_tmp13_ = it;
				_tmp14_ = canvas_text_get_selstart (self);
				_tmp15_ = _tmp14_;
				if ((*_tmp13_).start < _tmp15_) {
					gint _tmp16_;
					gint _tmp17_;
					_tmp16_ = self->priv->_selstart + slen;
					_tmp17_ = self->priv->_selend + slen;
					canvas_text_change_selection (self, &_tmp16_, &_tmp17_, "insert");
				}
				_insert_text_free0 (it);
			}
		}
	}
	undo_text_buffer_add_inserts (undo_buffer, its, cur);
}

void
canvas_text_replace (CanvasText* self,
                     gint start,
                     gint end,
                     const gchar* s,
                     UndoTextBuffer* undo_buffer)
{
	gint slen = 0;
	gint cur = 0;
	gchar* str = NULL;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GArray* tags = NULL;
	FormattedText* _tmp5_;
	FormattedText* _tmp6_;
	GArray* _tmp7_;
	FormattedText* _tmp8_;
	FormattedText* _tmp9_;
	FormattedText* _tmp10_;
	FormattedText* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (undo_buffer != NULL);
	slen = g_utf8_strlen (s, (gssize) -1);
	cur = self->priv->_cursor;
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (_tmp3_, (glong) start, (glong) end);
	str = _tmp4_;
	_tmp5_ = canvas_text_get_text (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = formatted_text_get_tags_in_range (_tmp6_, start, end);
	tags = _tmp7_;
	_tmp8_ = canvas_text_get_text (self);
	_tmp9_ = _tmp8_;
	formatted_text_replace_text (_tmp9_, start, end - start, s);
	_tmp10_ = canvas_text_get_text (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = formatted_text_get_text (_tmp11_);
	_tmp13_ = _tmp12_;
	canvas_text_set_cursor_only (self, g_utf8_strlen (_tmp13_, (gssize) start) + slen);
	canvas_text_change_selection (self, NULL, &self->priv->_selstart, "replace");
	undo_text_buffer_add_replace (undo_buffer, start, str, s, tags, cur);
	_g_array_unref0 (tags);
	_g_free0 (str);
}

gchar*
canvas_text_get_selected_text (CanvasText* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint epos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		spos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		epos = string_index_of_nth_char (_tmp7_, (glong) self->priv->_selend);
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_slice (_tmp11_, (glong) spos, (glong) epos);
		result = _tmp12_;
		return result;
	}
	result = NULL;
	return result;
}

void
canvas_text_get_cursor_info (CanvasText* self,
                             gint* cursor,
                             gint* start,
                             gint* end)
{
	gint _vala_cursor = 0;
	gint _vala_start = 0;
	gint _vala_end = 0;
	g_return_if_fail (self != NULL);
	_vala_cursor = self->priv->_cursor;
	_vala_start = self->priv->_selstart;
	_vala_end = self->priv->_selend;
	if (cursor) {
		*cursor = _vala_cursor;
	}
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
}

void
canvas_text_get_cursor_pos (CanvasText* self,
                            gint* x,
                            gint* ytop,
                            gint* ybot)
{
	gint _vala_x = 0;
	gint _vala_ytop = 0;
	gint _vala_ybot = 0;
	gint index = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoRectangle rect = {0};
	PangoLayout* _tmp4_;
	PangoRectangle _tmp5_ = {0};
	gdouble _tmp6_;
	gdouble _tmp7_;
	PangoRectangle _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	PangoRectangle _tmp11_;
	PangoRectangle _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	index = string_index_of_nth_char (_tmp3_, (glong) self->priv->_cursor);
	_tmp4_ = self->priv->_pango_layout;
	pango_layout_index_to_pos (_tmp4_, index, &_tmp5_);
	rect = _tmp5_;
	_tmp6_ = canvas_text_get_posx (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = rect;
	_vala_x = (gint) (_tmp7_ + (_tmp8_.x / PANGO_SCALE));
	_tmp9_ = canvas_text_get_posy (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = rect;
	_vala_ytop = (gint) (_tmp10_ + (_tmp11_.y / PANGO_SCALE));
	_tmp12_ = rect;
	_vala_ybot = _vala_ytop + ((gint) (_tmp12_.height / PANGO_SCALE));
	if (x) {
		*x = _vala_x;
	}
	if (ytop) {
		*ytop = _vala_ytop;
	}
	if (ybot) {
		*ybot = _vala_ybot;
	}
}

void
canvas_text_get_char_pos (CanvasText* self,
                          gint pos,
                          gdouble* left,
                          gdouble* top,
                          gdouble* bottom,
                          gint* line)
{
	gdouble _vala_left = 0.0;
	gdouble _vala_top = 0.0;
	gdouble _vala_bottom = 0.0;
	gint _vala_line = 0;
	gint index = 0;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoRectangle rect = {0};
	PangoLayout* _tmp4_;
	PangoRectangle _tmp5_ = {0};
	gdouble _tmp6_;
	gdouble _tmp7_;
	PangoRectangle _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	PangoRectangle _tmp11_;
	PangoRectangle _tmp12_;
	gint x_pos = 0;
	PangoLayout* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	index = string_index_of_nth_char (_tmp3_, (glong) pos);
	_tmp4_ = self->priv->_pango_layout;
	pango_layout_index_to_pos (_tmp4_, index, &_tmp5_);
	rect = _tmp5_;
	_tmp6_ = canvas_text_get_posx (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = rect;
	_vala_left = _tmp7_ + (_tmp8_.x / PANGO_SCALE);
	_tmp9_ = canvas_text_get_posy (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = rect;
	_vala_top = _tmp10_ + (_tmp11_.y / PANGO_SCALE);
	_tmp12_ = rect;
	_vala_bottom = _vala_top + (_tmp12_.height / PANGO_SCALE);
	_tmp13_ = self->priv->_pango_layout;
	pango_layout_index_to_line_x (_tmp13_, index, FALSE, &_tmp14_, &_tmp15_);
	_vala_line = _tmp14_;
	x_pos = _tmp15_;
	if (left) {
		*left = _vala_left;
	}
	if (top) {
		*top = _vala_top;
	}
	if (bottom) {
		*bottom = _vala_bottom;
	}
	if (line) {
		*line = _vala_line;
	}
}

FormattedText*
canvas_text_get_selected_formatted_text (CanvasText* self,
                                         DrawArea* da)
{
	FormattedText* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	if (self->priv->_selstart != self->priv->_selend) {
		gint spos = 0;
		FormattedText* _tmp0_;
		FormattedText* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint epos = 0;
		FormattedText* _tmp4_;
		FormattedText* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		FormattedText* _tmp10_;
		_tmp0_ = canvas_text_get_text (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = formatted_text_get_text (_tmp1_);
		_tmp3_ = _tmp2_;
		spos = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
		_tmp4_ = canvas_text_get_text (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = formatted_text_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		epos = string_index_of_nth_char (_tmp7_, (glong) self->priv->_selend);
		_tmp8_ = canvas_text_get_text (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_new_copy_range (da, _tmp9_, spos, epos);
		result = _tmp10_;
		return result;
	}
	result = NULL;
	return result;
}

void
canvas_text_add_tag (CanvasText* self,
                     FormatTag tag,
                     const gchar* extra,
                     gboolean parsed,
                     UndoTextBuffer* undo_buffer)
{
	gint _tmp0_ = 0;
	gint spos = 0;
	gint _tmp5_ = 0;
	gint epos = 0;
	FormattedText* _tmp16_;
	FormattedText* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = canvas_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_index_of_nth_char (_tmp4_, (glong) self->priv->_selstart);
	} else {
		_tmp0_ = 0;
	}
	spos = _tmp0_;
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp6_;
		FormattedText* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = canvas_text_get_text (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = formatted_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = string_index_of_nth_char (_tmp9_, (glong) self->priv->_selend);
	} else {
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp5_ = _tmp15_;
	}
	epos = _tmp5_;
	_tmp16_ = canvas_text_get_text (self);
	_tmp17_ = _tmp16_;
	formatted_text_add_tag (_tmp17_, tag, spos, epos, parsed, extra);
	undo_text_buffer_add_tag_add (undo_buffer, spos, epos, tag, extra, parsed, self->priv->_cursor);
}

void
canvas_text_remove_tag (CanvasText* self,
                        FormatTag tag,
                        UndoTextBuffer* undo_buffer)
{
	gchar* extra = NULL;
	gboolean parsed = FALSE;
	gint _tmp0_ = 0;
	gint spos = 0;
	gint _tmp5_ = 0;
	gint epos = 0;
	FormattedText* _tmp16_;
	FormattedText* _tmp17_;
	gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	FormattedText* _tmp20_;
	FormattedText* _tmp21_;
	const gchar* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	extra = NULL;
	parsed = FALSE;
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = canvas_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_index_of_nth_char (_tmp4_, (glong) self->priv->_selstart);
	} else {
		_tmp0_ = 0;
	}
	spos = _tmp0_;
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp6_;
		FormattedText* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = canvas_text_get_text (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = formatted_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = string_index_of_nth_char (_tmp9_, (glong) self->priv->_selend);
	} else {
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp5_ = _tmp15_;
	}
	epos = _tmp5_;
	_tmp16_ = canvas_text_get_text (self);
	_tmp17_ = _tmp16_;
	formatted_text_get_extra_parsed (_tmp17_, tag, spos, &_tmp18_, &_tmp19_);
	_g_free0 (extra);
	extra = _tmp18_;
	parsed = _tmp19_;
	_tmp20_ = canvas_text_get_text (self);
	_tmp21_ = _tmp20_;
	formatted_text_remove_tag (_tmp21_, tag, spos, epos);
	_tmp22_ = extra;
	undo_text_buffer_add_tag_remove (undo_buffer, spos, epos, tag, _tmp22_, parsed, self->priv->_cursor);
	_g_free0 (extra);
}

void
canvas_text_remove_all_tags (CanvasText* self,
                             UndoTextBuffer* undo_buffer)
{
	gint _tmp0_ = 0;
	gint spos = 0;
	gint _tmp5_ = 0;
	gint epos = 0;
	GArray* tags = NULL;
	FormattedText* _tmp16_;
	FormattedText* _tmp17_;
	GArray* _tmp18_;
	FormattedText* _tmp19_;
	FormattedText* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (undo_buffer != NULL);
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp1_;
		FormattedText* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = canvas_text_get_text (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = formatted_text_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_index_of_nth_char (_tmp4_, (glong) self->priv->_selstart);
	} else {
		_tmp0_ = 0;
	}
	spos = _tmp0_;
	if (canvas_text_is_selected (self)) {
		FormattedText* _tmp6_;
		FormattedText* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = canvas_text_get_text (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = formatted_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = string_index_of_nth_char (_tmp9_, (glong) self->priv->_selend);
	} else {
		FormattedText* _tmp10_;
		FormattedText* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp10_ = canvas_text_get_text (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = formatted_text_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp5_ = _tmp15_;
	}
	epos = _tmp5_;
	_tmp16_ = canvas_text_get_text (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = formatted_text_get_tags_in_range (_tmp17_, spos, epos);
	tags = _tmp18_;
	_tmp19_ = canvas_text_get_text (self);
	_tmp20_ = _tmp19_;
	formatted_text_remove_all_tags (_tmp20_, spos, epos);
	undo_text_buffer_add_tag_clear (undo_buffer, spos, epos, tags, self->priv->_cursor);
	_g_array_unref0 (tags);
}

void
canvas_text_change_selection (CanvasText* self,
                              gint* selstart,
                              gint* selend,
                              const gchar* msg)
{
	gboolean _tmp0_ = FALSE;
	gboolean old_selected = FALSE;
	gint* _tmp2_ = NULL;
	gint* _tmp3_;
	gint* _tmp5_;
	gint* _tmp6_;
	gint* _tmp7_ = NULL;
	gint* _tmp8_;
	gint* _tmp10_;
	gint* _tmp11_;
	gboolean new_selected = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_debug) {
		_tmp0_ = msg != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "In change_selection, msg: %s\n", msg);
	}
	old_selected = self->priv->_selstart != self->priv->_selend;
	_tmp3_ = __int_dup0 (selstart);
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		gint* _tmp4_;
		_tmp4_ = __int_dup0 (&self->priv->_selstart);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = _tmp2_;
	_tmp2_ = NULL;
	_tmp6_ = _tmp5_;
	self->priv->_selstart = *_tmp6_;
	_g_free0 (_tmp6_);
	_tmp8_ = __int_dup0 (selend);
	_tmp7_ = _tmp8_;
	if (_tmp7_ == NULL) {
		gint* _tmp9_;
		_tmp9_ = __int_dup0 (&self->priv->_selend);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = _tmp7_;
	_tmp7_ = NULL;
	_tmp11_ = _tmp10_;
	self->priv->_selend = *_tmp11_;
	_g_free0 (_tmp11_);
	new_selected = self->priv->_selstart != self->priv->_selend;
	if (new_selected) {
		FormattedText* _tmp12_;
		FormattedText* _tmp13_;
		FormattedText* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		FormattedText* _tmp17_;
		FormattedText* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		_tmp12_ = self->priv->_text;
		_tmp13_ = canvas_text_get_text (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = formatted_text_get_text (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = canvas_text_get_text (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = formatted_text_get_text (_tmp18_);
		_tmp20_ = _tmp19_;
		formatted_text_replace_tag (_tmp12_, FORMAT_TAG_SELECT, string_index_of_nth_char (_tmp16_, (glong) self->priv->_selstart), string_index_of_nth_char (_tmp20_, (glong) self->priv->_selend), FALSE, NULL);
	} else {
		if (old_selected) {
			FormattedText* _tmp21_;
			_tmp21_ = self->priv->_text;
			formatted_text_remove_tag_all (_tmp21_, FORMAT_TAG_SELECT);
		}
	}
	if (old_selected) {
		_tmp22_ = !new_selected;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		g_signal_emit (self, canvas_text_signals[CANVAS_TEXT_SELECT_MODE_SIGNAL], 0, FALSE);
	} else {
		gboolean _tmp23_ = FALSE;
		if (!old_selected) {
			_tmp23_ = new_selected;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			g_signal_emit (self, canvas_text_signals[CANVAS_TEXT_SELECT_MODE_SIGNAL], 0, TRUE);
		}
	}
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
canvas_text_draw (CanvasText* self,
                  cairo_t* ctx,
                  Theme* theme,
                  GdkRGBA* fg,
                  gdouble alpha,
                  gboolean copy_layout)
{
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	PangoRectangle ink_rect = {0};
	PangoRectangle log_rect = {0};
	PangoLayout* _tmp25_;
	PangoRectangle _tmp26_ = {0};
	PangoRectangle _tmp27_ = {0};
	gdouble _tmp28_;
	gdouble _tmp29_;
	PangoRectangle _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	GdkRGBA _tmp33_;
	PangoLayout* _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_;
	gboolean _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	g_return_if_fail (fg != NULL);
	_tmp0_ = self->priv->_pango_layout;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	layout = _tmp1_;
	if (copy_layout) {
		PangoLayout* _tmp2_;
		PangoLayout* _tmp3_;
		PangoLayout* _tmp4_;
		FormattedText* _tmp5_;
		PangoAttrList* _tmp6_;
		PangoAttrList* _tmp7_;
		_tmp2_ = self->priv->_pango_layout;
		_tmp3_ = pango_layout_copy (_tmp2_);
		_g_object_unref0 (layout);
		layout = _tmp3_;
		_tmp4_ = layout;
		_tmp5_ = self->priv->_text;
		_tmp6_ = formatted_text_get_attributes_from_theme (_tmp5_, theme);
		_tmp7_ = _tmp6_;
		pango_layout_set_attributes (_tmp4_, _tmp7_);
		_pango_attr_list_unref0 (_tmp7_);
	}
	if (alpha < 1.0) {
		PangoLayout* _tmp8_;
		PangoLayout* _tmp9_;
		PangoAttrList* attrs = NULL;
		PangoLayout* _tmp10_;
		PangoAttrList* _tmp11_;
		PangoAttrList* _tmp12_;
		guint16 alpha_val = 0U;
		PangoAttribute* alpha_attr = NULL;
		PangoAttribute* _tmp13_;
		PangoAttribute* _tmp14_;
		PangoAttribute* _tmp15_;
		FormattedText* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		PangoAttrList* _tmp21_;
		PangoAttribute* _tmp22_;
		PangoLayout* _tmp23_;
		PangoAttrList* _tmp24_;
		_tmp8_ = self->priv->_pango_layout;
		_tmp9_ = pango_layout_copy (_tmp8_);
		_g_object_unref0 (layout);
		layout = _tmp9_;
		_tmp10_ = layout;
		_tmp11_ = pango_layout_get_attributes (_tmp10_);
		_tmp12_ = _pango_attr_list_ref0 (_tmp11_);
		attrs = _tmp12_;
		alpha_val = (guint16) (65536 * alpha);
		_tmp13_ = pango_attr_foreground_alpha_new (alpha_val);
		alpha_attr = _tmp13_;
		_tmp14_ = alpha_attr;
		_tmp14_->start_index = (guint) 0;
		_tmp15_ = alpha_attr;
		_tmp16_ = self->priv->_text;
		_tmp17_ = formatted_text_get_text (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp15_->end_index = (guint) _tmp20_;
		_tmp21_ = attrs;
		_tmp22_ = alpha_attr;
		alpha_attr = NULL;
		pango_attr_list_change (_tmp21_, _tmp22_);
		_tmp23_ = layout;
		_tmp24_ = attrs;
		pango_layout_set_attributes (_tmp23_, _tmp24_);
		_pango_attribute_destroy0 (alpha_attr);
		_pango_attr_list_unref0 (attrs);
	}
	_tmp25_ = layout;
	pango_layout_get_extents (_tmp25_, &_tmp26_, &_tmp27_);
	ink_rect = _tmp26_;
	log_rect = _tmp27_;
	_tmp28_ = canvas_text_get_posx (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = log_rect;
	_tmp31_ = canvas_text_get_posy (self);
	_tmp32_ = _tmp31_;
	cairo_move_to (ctx, _tmp29_ - (_tmp30_.x / PANGO_SCALE), _tmp32_);
	_tmp33_ = *fg;
	utils_set_context_color_with_alpha (ctx, &_tmp33_, alpha);
	_tmp34_ = layout;
	pango_cairo_show_layout (ctx, _tmp34_);
	cairo_new_path (ctx);
	_tmp36_ = canvas_text_get_edit (self);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		_tmp35_ = !copy_layout;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		gint cpos = 0;
		FormattedText* _tmp38_;
		FormattedText* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		PangoRectangle rect = {0};
		PangoLayout* _tmp42_;
		PangoRectangle _tmp43_ = {0};
		GdkRGBA* _tmp44_;
		GdkRGBA* _tmp45_;
		GdkRGBA _tmp46_;
		gdouble ix = 0.0;
		gdouble iy = 0.0;
		gdouble _tmp47_;
		gdouble _tmp48_;
		PangoRectangle _tmp49_;
		PangoRectangle _tmp50_;
		gdouble _tmp51_;
		gdouble _tmp52_;
		PangoRectangle _tmp53_;
		PangoRectangle _tmp54_;
		_tmp38_ = canvas_text_get_text (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = formatted_text_get_text (_tmp39_);
		_tmp41_ = _tmp40_;
		cpos = string_index_of_nth_char (_tmp41_, (glong) self->priv->_cursor);
		_tmp42_ = layout;
		pango_layout_index_to_pos (_tmp42_, cpos, &_tmp43_);
		rect = _tmp43_;
		_tmp44_ = theme_get_color (theme, "text_cursor");
		_tmp45_ = _tmp44_;
		_tmp46_ = *_tmp45_;
		utils_set_context_color_with_alpha (ctx, &_tmp46_, alpha);
		__vala_GdkRGBA_free0 (_tmp45_);
		_tmp47_ = canvas_text_get_posx (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = rect;
		_tmp50_ = log_rect;
		ix = ((_tmp48_ + (_tmp49_.x / PANGO_SCALE)) - 1) - (_tmp50_.x / PANGO_SCALE);
		_tmp51_ = canvas_text_get_posy (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = rect;
		iy = _tmp52_ + (_tmp53_.y / PANGO_SCALE);
		_tmp54_ = rect;
		cairo_rectangle (ctx, ix, iy, (gdouble) 1, (gdouble) (_tmp54_.height / PANGO_SCALE));
		cairo_fill (ctx);
	}
	_g_object_unref0 (layout);
}

FormattedText*
canvas_text_get_text (CanvasText* self)
{
	FormattedText* result;
	FormattedText* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

gdouble
canvas_text_get_posx (CanvasText* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_posx + _tmp2_;
	return result;
}

void
canvas_text_set_posx (CanvasText* self,
                      gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_x (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_posx = value - _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, canvas_text_properties[CANVAS_TEXT_POSX_PROPERTY]);
}

gdouble
canvas_text_get_posy (CanvasText* self)
{
	gdouble result;
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->_posy + _tmp2_;
	return result;
}

void
canvas_text_set_posy (CanvasText* self,
                      gdouble value)
{
	DrawArea* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_origin_y (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->_posy = value - _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, canvas_text_properties[CANVAS_TEXT_POSY_PROPERTY]);
}

gdouble
canvas_text_get_width (CanvasText* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_width;
	return result;
}

gdouble
canvas_text_get_height (CanvasText* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_height;
	return result;
}

gdouble
canvas_text_get_max_width (CanvasText* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_max_width;
	return result;
}

void
canvas_text_set_max_width (CanvasText* self,
                           gdouble value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_max_width != value) {
		gint int_value = 0;
		PangoLayout* _tmp0_;
		int_value = (gint) value;
		self->priv->_max_width = value;
		_tmp0_ = self->priv->_pango_layout;
		pango_layout_set_width (_tmp0_, int_value * PANGO_SCALE);
		canvas_text_update_size (self, TRUE);
	}
	g_object_notify_by_pspec ((GObject *) self, canvas_text_properties[CANVAS_TEXT_MAX_WIDTH_PROPERTY]);
}

gboolean
canvas_text_get_edit (CanvasText* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_edit;
	return result;
}

void
canvas_text_set_edit (CanvasText* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_edit != value) {
		self->priv->_edit = value;
		if (!self->priv->_edit) {
			canvas_text_clear_selection (self, "edit");
		}
		canvas_text_update_size (self, TRUE);
	}
	g_object_notify_by_pspec ((GObject *) self, canvas_text_properties[CANVAS_TEXT_EDIT_PROPERTY]);
}

gint
canvas_text_get_cursor (CanvasText* self)
{
	gint result;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	result = string_index_of_nth_char (_tmp3_, (glong) self->priv->_cursor);
	return result;
}

gint
canvas_text_get_selstart (CanvasText* self)
{
	gint result;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	result = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selstart);
	return result;
}

gint
canvas_text_get_selend (CanvasText* self)
{
	gint result;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = canvas_text_get_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = formatted_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	result = string_index_of_nth_char (_tmp3_, (glong) self->priv->_selend);
	return result;
}

static void
canvas_text_class_init (CanvasTextClass * klass,
                        gpointer klass_data)
{
	canvas_text_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CanvasText_private_offset);
	((CanvasTextClass *) klass)->save = (xmlNode* (*) (CanvasText*, const gchar*)) canvas_text_real_save;
	((CanvasTextClass *) klass)->load = (void (*) (CanvasText*, xmlNode*)) canvas_text_real_load;
	((CanvasTextClass *) klass)->resize = (void (*) (CanvasText*, gdouble)) canvas_text_real_resize;
	G_OBJECT_CLASS (klass)->get_property = _vala_canvas_text_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_canvas_text_set_property;
	G_OBJECT_CLASS (klass)->finalize = canvas_text_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_TEXT_PROPERTY, canvas_text_properties[CANVAS_TEXT_TEXT_PROPERTY] = param_spec_formatted_text ("text", "text", "text", TYPE_FORMATTED_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_POSX_PROPERTY, canvas_text_properties[CANVAS_TEXT_POSX_PROPERTY] = g_param_spec_double ("posx", "posx", "posx", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_POSY_PROPERTY, canvas_text_properties[CANVAS_TEXT_POSY_PROPERTY] = g_param_spec_double ("posy", "posy", "posy", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_WIDTH_PROPERTY, canvas_text_properties[CANVAS_TEXT_WIDTH_PROPERTY] = g_param_spec_double ("width", "width", "width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_HEIGHT_PROPERTY, canvas_text_properties[CANVAS_TEXT_HEIGHT_PROPERTY] = g_param_spec_double ("height", "height", "height", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_MAX_WIDTH_PROPERTY, canvas_text_properties[CANVAS_TEXT_MAX_WIDTH_PROPERTY] = g_param_spec_double ("max-width", "max-width", "max-width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_EDIT_PROPERTY, canvas_text_properties[CANVAS_TEXT_EDIT_PROPERTY] = g_param_spec_boolean ("edit", "edit", "edit", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_CURSOR_PROPERTY, canvas_text_properties[CANVAS_TEXT_CURSOR_PROPERTY] = g_param_spec_int ("cursor", "cursor", "cursor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_SELSTART_PROPERTY, canvas_text_properties[CANVAS_TEXT_SELSTART_PROPERTY] = g_param_spec_int ("selstart", "selstart", "selstart", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CANVAS_TEXT_SELEND_PROPERTY, canvas_text_properties[CANVAS_TEXT_SELEND_PROPERTY] = g_param_spec_int ("selend", "selend", "selend", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	canvas_text_signals[CANVAS_TEXT_RESIZED_SIGNAL] = g_signal_new ("resized", TYPE_CANVAS_TEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	canvas_text_signals[CANVAS_TEXT_SELECT_MODE_SIGNAL] = g_signal_new ("select-mode", TYPE_CANVAS_TEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	canvas_text_signals[CANVAS_TEXT_CURSOR_CHANGED_SIGNAL] = g_signal_new ("cursor-changed", TYPE_CANVAS_TEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
canvas_text_instance_init (CanvasText * self,
                           gpointer klass)
{
	self->priv = canvas_text_get_instance_private (self);
	self->priv->_posx = 0.0;
	self->priv->_posy = 0.0;
	self->priv->_edit = FALSE;
	self->priv->_cursor = 0;
	self->priv->_column = 0;
	self->priv->_pango_layout = NULL;
	self->priv->_line_layout = NULL;
	self->priv->_selstart = 0;
	self->priv->_selend = 0;
	self->priv->_selanchor = 0;
	self->priv->_max_width = (gdouble) 200;
	self->priv->_width = (gdouble) 0;
	self->priv->_height = (gdouble) 0;
	self->priv->_debug = FALSE;
	self->priv->_font_size = 12;
}

static void
canvas_text_finalize (GObject * obj)
{
	CanvasText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANVAS_TEXT, CanvasText);
	_g_object_unref0 (self->priv->_da);
	_formatted_text_unref0 (self->priv->_text);
	_g_object_unref0 (self->priv->_pango_layout);
	_g_object_unref0 (self->priv->_line_layout);
	G_OBJECT_CLASS (canvas_text_parent_class)->finalize (obj);
}

static GType
canvas_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CanvasTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) canvas_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CanvasText), 0, (GInstanceInitFunc) canvas_text_instance_init, NULL };
	GType canvas_text_type_id;
	canvas_text_type_id = g_type_register_static (G_TYPE_OBJECT, "CanvasText", &g_define_type_info, 0);
	CanvasText_private_offset = g_type_add_instance_private (canvas_text_type_id, sizeof (CanvasTextPrivate));
	return canvas_text_type_id;
}

GType
canvas_text_get_type (void)
{
	static volatile gsize canvas_text_type_id__once = 0;
	if (g_once_init_enter (&canvas_text_type_id__once)) {
		GType canvas_text_type_id;
		canvas_text_type_id = canvas_text_get_type_once ();
		g_once_init_leave (&canvas_text_type_id__once, canvas_text_type_id);
	}
	return canvas_text_type_id__once;
}

static void
_vala_canvas_text_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	CanvasText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CANVAS_TEXT, CanvasText);
	switch (property_id) {
		case CANVAS_TEXT_TEXT_PROPERTY:
		value_set_formatted_text (value, canvas_text_get_text (self));
		break;
		case CANVAS_TEXT_POSX_PROPERTY:
		g_value_set_double (value, canvas_text_get_posx (self));
		break;
		case CANVAS_TEXT_POSY_PROPERTY:
		g_value_set_double (value, canvas_text_get_posy (self));
		break;
		case CANVAS_TEXT_WIDTH_PROPERTY:
		g_value_set_double (value, canvas_text_get_width (self));
		break;
		case CANVAS_TEXT_HEIGHT_PROPERTY:
		g_value_set_double (value, canvas_text_get_height (self));
		break;
		case CANVAS_TEXT_MAX_WIDTH_PROPERTY:
		g_value_set_double (value, canvas_text_get_max_width (self));
		break;
		case CANVAS_TEXT_EDIT_PROPERTY:
		g_value_set_boolean (value, canvas_text_get_edit (self));
		break;
		case CANVAS_TEXT_CURSOR_PROPERTY:
		g_value_set_int (value, canvas_text_get_cursor (self));
		break;
		case CANVAS_TEXT_SELSTART_PROPERTY:
		g_value_set_int (value, canvas_text_get_selstart (self));
		break;
		case CANVAS_TEXT_SELEND_PROPERTY:
		g_value_set_int (value, canvas_text_get_selend (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_canvas_text_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	CanvasText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CANVAS_TEXT, CanvasText);
	switch (property_id) {
		case CANVAS_TEXT_POSX_PROPERTY:
		canvas_text_set_posx (self, g_value_get_double (value));
		break;
		case CANVAS_TEXT_POSY_PROPERTY:
		canvas_text_set_posy (self, g_value_get_double (value));
		break;
		case CANVAS_TEXT_MAX_WIDTH_PROPERTY:
		canvas_text_set_max_width (self, g_value_get_double (value));
		break;
		case CANVAS_TEXT_EDIT_PROPERTY:
		canvas_text_set_edit (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

