/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "tracker-dbus-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_DOUBLE_INT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringDoubleIntFunc)
       (void *data1,
        const gchar *arg_status,
        gdouble arg_progress,
        gint arg_remaining_time,
        void *data2);
  _GDbusCodegenMarshalVoid_StringDoubleIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringDoubleIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_double (param_values + 2),
            g_marshal_value_peek_int (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringStringFunc)
       (void *data1,
        const gchar *arg_mount_uri,
        const gchar *arg_object_path,
        void *data2);
  _GDbusCodegenMarshalVoid_StringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_application,
        const gchar *arg_reason,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_cookie,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Tracker3.Miner
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:TrackerDBusMiner
 * @title: TrackerDBusMiner
 * @short_description: Generated C code for the org.freedesktop.Tracker3.Miner D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link> D-Bus interface in C.
 */

enum
{
  TRACKER_DBUS__MINER_STARTED,
  TRACKER_DBUS__MINER_STOPPED,
  TRACKER_DBUS__MINER_PAUSED,
  TRACKER_DBUS__MINER_RESUMED,
  TRACKER_DBUS__MINER_PROGRESS,
  TRACKER_DBUS__MINER_ENDPOINT_ADDED,
  TRACKER_DBUS__MINER_ENDPOINT_REMOVED,
};

static unsigned TRACKER_DBUS__MINER_SIGNALS[7] = { 0 };

/* ---- Introspection data for org.freedesktop.Tracker3.Miner ---- */

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    NULL,
    NULL,
    NULL
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_get_status_OUT_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_get_status_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_get_status_OUT_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_get_status =
{
  {
    -1,
    (gchar *) "GetStatus",
    NULL,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_get_status_OUT_ARG_pointers,
    NULL
  },
  "handle-get-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_get_progress_OUT_ARG_progress =
{
  {
    -1,
    (gchar *) "progress",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_get_progress_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_get_progress_OUT_ARG_progress.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_get_progress =
{
  {
    -1,
    (gchar *) "GetProgress",
    NULL,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_get_progress_OUT_ARG_pointers,
    NULL
  },
  "handle-get-progress",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_get_remaining_time_OUT_ARG_remaining_time =
{
  {
    -1,
    (gchar *) "remaining_time",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_get_remaining_time_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_get_remaining_time_OUT_ARG_remaining_time.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_get_remaining_time =
{
  {
    -1,
    (gchar *) "GetRemainingTime",
    NULL,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_get_remaining_time_OUT_ARG_pointers,
    NULL
  },
  "handle-get-remaining-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pause_applications =
{
  {
    -1,
    (gchar *) "pause_applications",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pause_reasons =
{
  {
    -1,
    (gchar *) "pause_reasons",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pause_applications.parent_struct,
  &_tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pause_reasons.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_get_pause_details =
{
  {
    -1,
    (gchar *) "GetPauseDetails",
    NULL,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_get_pause_details_OUT_ARG_pointers,
    NULL
  },
  "handle-get-pause-details",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_IN_ARG_application =
{
  {
    -1,
    (gchar *) "application",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_pause_IN_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_pause_IN_ARG_application.parent_struct,
  &_tracker_dbus_miner_method_info_pause_IN_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_OUT_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_pause_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_pause_OUT_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_pause_IN_ARG_pointers,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_pause_OUT_ARG_pointers,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_for_process_IN_ARG_application =
{
  {
    -1,
    (gchar *) "application",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_for_process_IN_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_pause_for_process_IN_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_pause_for_process_IN_ARG_application.parent_struct,
  &_tracker_dbus_miner_method_info_pause_for_process_IN_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_pause_for_process_OUT_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_pause_for_process_OUT_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_pause_for_process_OUT_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_pause_for_process =
{
  {
    -1,
    (gchar *) "PauseForProcess",
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_pause_for_process_IN_ARG_pointers,
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_pause_for_process_OUT_ARG_pointers,
    NULL
  },
  "handle-pause-for-process",
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_method_info_resume_IN_ARG_cookie =
{
  {
    -1,
    (gchar *) "cookie",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_method_info_resume_IN_ARG_pointers[] =
{
  &_tracker_dbus_miner_method_info_resume_IN_ARG_cookie.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _tracker_dbus_miner_method_info_resume =
{
  {
    -1,
    (gchar *) "Resume",
    (GDBusArgInfo **) &_tracker_dbus_miner_method_info_resume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-resume",
  FALSE
};

static const GDBusMethodInfo * const _tracker_dbus_miner_method_info_pointers[] =
{
  &_tracker_dbus_miner_method_info_start.parent_struct,
  &_tracker_dbus_miner_method_info_get_status.parent_struct,
  &_tracker_dbus_miner_method_info_get_progress.parent_struct,
  &_tracker_dbus_miner_method_info_get_remaining_time.parent_struct,
  &_tracker_dbus_miner_method_info_get_pause_details.parent_struct,
  &_tracker_dbus_miner_method_info_pause.parent_struct,
  &_tracker_dbus_miner_method_info_pause_for_process.parent_struct,
  &_tracker_dbus_miner_method_info_resume.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_started =
{
  {
    -1,
    (gchar *) "Started",
    NULL,
    NULL
  },
  "started"
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_stopped =
{
  {
    -1,
    (gchar *) "Stopped",
    NULL,
    NULL
  },
  "stopped"
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_paused =
{
  {
    -1,
    (gchar *) "Paused",
    NULL,
    NULL
  },
  "paused"
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_resumed =
{
  {
    -1,
    (gchar *) "Resumed",
    NULL,
    NULL
  },
  "resumed"
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_progress_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_progress_ARG_progress =
{
  {
    -1,
    (gchar *) "progress",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_progress_ARG_remaining_time =
{
  {
    -1,
    (gchar *) "remaining_time",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_signal_info_progress_ARG_pointers[] =
{
  &_tracker_dbus_miner_signal_info_progress_ARG_status.parent_struct,
  &_tracker_dbus_miner_signal_info_progress_ARG_progress.parent_struct,
  &_tracker_dbus_miner_signal_info_progress_ARG_remaining_time.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_progress =
{
  {
    -1,
    (gchar *) "Progress",
    (GDBusArgInfo **) &_tracker_dbus_miner_signal_info_progress_ARG_pointers,
    NULL
  },
  "progress"
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_endpoint_added_ARG_mount_uri =
{
  {
    -1,
    (gchar *) "mount_uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_endpoint_added_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_signal_info_endpoint_added_ARG_pointers[] =
{
  &_tracker_dbus_miner_signal_info_endpoint_added_ARG_mount_uri.parent_struct,
  &_tracker_dbus_miner_signal_info_endpoint_added_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_endpoint_added =
{
  {
    -1,
    (gchar *) "EndpointAdded",
    (GDBusArgInfo **) &_tracker_dbus_miner_signal_info_endpoint_added_ARG_pointers,
    NULL
  },
  "endpoint-added"
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_endpoint_removed_ARG_mount_uri =
{
  {
    -1,
    (gchar *) "mount_uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _tracker_dbus_miner_signal_info_endpoint_removed_ARG_object_path =
{
  {
    -1,
    (gchar *) "object_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _tracker_dbus_miner_signal_info_endpoint_removed_ARG_pointers[] =
{
  &_tracker_dbus_miner_signal_info_endpoint_removed_ARG_mount_uri.parent_struct,
  &_tracker_dbus_miner_signal_info_endpoint_removed_ARG_object_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _tracker_dbus_miner_signal_info_endpoint_removed =
{
  {
    -1,
    (gchar *) "EndpointRemoved",
    (GDBusArgInfo **) &_tracker_dbus_miner_signal_info_endpoint_removed_ARG_pointers,
    NULL
  },
  "endpoint-removed"
};

static const GDBusSignalInfo * const _tracker_dbus_miner_signal_info_pointers[] =
{
  &_tracker_dbus_miner_signal_info_started.parent_struct,
  &_tracker_dbus_miner_signal_info_stopped.parent_struct,
  &_tracker_dbus_miner_signal_info_paused.parent_struct,
  &_tracker_dbus_miner_signal_info_resumed.parent_struct,
  &_tracker_dbus_miner_signal_info_progress.parent_struct,
  &_tracker_dbus_miner_signal_info_endpoint_added.parent_struct,
  &_tracker_dbus_miner_signal_info_endpoint_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _tracker_dbus_miner_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Tracker3.Miner",
    (GDBusMethodInfo **) &_tracker_dbus_miner_method_info_pointers,
    (GDBusSignalInfo **) &_tracker_dbus_miner_signal_info_pointers,
    NULL,
    NULL
  },
  "miner",
};


/**
 * tracker_dbus_miner_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
tracker_dbus_miner_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct;
}

/**
 * tracker_dbus_miner_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #TrackerDBusMiner interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
tracker_dbus_miner_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
tracker_dbus_miner_signal_marshal_started (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_stopped (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_paused (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_resumed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VOID (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_progress (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_DOUBLE_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_endpoint_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_signal_marshal_endpoint_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_start (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_get_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_get_progress (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_get_remaining_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_get_pause_details (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_pause_for_process (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
tracker_dbus_miner_method_marshal_resume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * TrackerDBusMiner:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link>.
 */

/**
 * TrackerDBusMinerIface:
 * @parent_iface: The parent interface.
 * @handle_get_pause_details: Handler for the #TrackerDBusMiner::handle-get-pause-details signal.
 * @handle_get_progress: Handler for the #TrackerDBusMiner::handle-get-progress signal.
 * @handle_get_remaining_time: Handler for the #TrackerDBusMiner::handle-get-remaining-time signal.
 * @handle_get_status: Handler for the #TrackerDBusMiner::handle-get-status signal.
 * @handle_pause: Handler for the #TrackerDBusMiner::handle-pause signal.
 * @handle_pause_for_process: Handler for the #TrackerDBusMiner::handle-pause-for-process signal.
 * @handle_resume: Handler for the #TrackerDBusMiner::handle-resume signal.
 * @handle_start: Handler for the #TrackerDBusMiner::handle-start signal.
 * @endpoint_added: Handler for the #TrackerDBusMiner::endpoint-added signal.
 * @endpoint_removed: Handler for the #TrackerDBusMiner::endpoint-removed signal.
 * @paused: Handler for the #TrackerDBusMiner::paused signal.
 * @progress: Handler for the #TrackerDBusMiner::progress signal.
 * @resumed: Handler for the #TrackerDBusMiner::resumed signal.
 * @started: Handler for the #TrackerDBusMiner::started signal.
 * @stopped: Handler for the #TrackerDBusMiner::stopped signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link>.
 */

typedef TrackerDBusMinerIface TrackerDBusMinerInterface;
G_DEFINE_INTERFACE (TrackerDBusMiner, tracker_dbus_miner, G_TYPE_OBJECT)

static void
tracker_dbus_miner_default_init (TrackerDBusMinerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * TrackerDBusMiner::handle-start:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_start,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * TrackerDBusMiner::handle-get-status:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetStatus">GetStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_get_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_get_status),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_get_status,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * TrackerDBusMiner::handle-get-progress:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetProgress">GetProgress()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_get_progress() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-progress",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_get_progress),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_get_progress,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * TrackerDBusMiner::handle-get-remaining-time:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetRemainingTime">GetRemainingTime()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_get_remaining_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-remaining-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_get_remaining_time),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_get_remaining_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * TrackerDBusMiner::handle-get-pause-details:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetPauseDetails">GetPauseDetails()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_get_pause_details() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-pause-details",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_get_pause_details),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_get_pause_details,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * TrackerDBusMiner::handle-pause:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_application: Argument passed by remote caller.
   * @arg_reason: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_pause,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * TrackerDBusMiner::handle-pause-for-process:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_application: Argument passed by remote caller.
   * @arg_reason: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.PauseForProcess">PauseForProcess()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_pause_for_process() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause-for-process",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_pause_for_process),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_pause_for_process,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * TrackerDBusMiner::handle-resume:
   * @object: A #TrackerDBusMiner.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_cookie: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Resume">Resume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call tracker_dbus_miner_complete_resume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-resume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (TrackerDBusMinerIface, handle_resume),
    g_signal_accumulator_true_handled,
    NULL,
      tracker_dbus_miner_method_marshal_resume,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /* GObject signals for received D-Bus signals: */
  /**
   * TrackerDBusMiner::started:
   * @object: A #TrackerDBusMiner.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Started">"Started"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_STARTED] =
    g_signal_new ("started",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, started),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_started,
      G_TYPE_NONE,
      0);

  /**
   * TrackerDBusMiner::stopped:
   * @object: A #TrackerDBusMiner.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Stopped">"Stopped"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_STOPPED] =
    g_signal_new ("stopped",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, stopped),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_stopped,
      G_TYPE_NONE,
      0);

  /**
   * TrackerDBusMiner::paused:
   * @object: A #TrackerDBusMiner.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Paused">"Paused"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_PAUSED] =
    g_signal_new ("paused",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, paused),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_paused,
      G_TYPE_NONE,
      0);

  /**
   * TrackerDBusMiner::resumed:
   * @object: A #TrackerDBusMiner.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Resumed">"Resumed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_RESUMED] =
    g_signal_new ("resumed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, resumed),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_resumed,
      G_TYPE_NONE,
      0);

  /**
   * TrackerDBusMiner::progress:
   * @object: A #TrackerDBusMiner.
   * @arg_status: Argument.
   * @arg_progress: Argument.
   * @arg_remaining_time: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Progress">"Progress"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_PROGRESS] =
    g_signal_new ("progress",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, progress),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_progress,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_INT);

  /**
   * TrackerDBusMiner::endpoint-added:
   * @object: A #TrackerDBusMiner.
   * @arg_mount_uri: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.EndpointAdded">"EndpointAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_ENDPOINT_ADDED] =
    g_signal_new ("endpoint-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, endpoint_added),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_endpoint_added,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * TrackerDBusMiner::endpoint-removed:
   * @object: A #TrackerDBusMiner.
   * @arg_mount_uri: Argument.
   * @arg_object_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.EndpointRemoved">"EndpointRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_ENDPOINT_REMOVED] =
    g_signal_new ("endpoint-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (TrackerDBusMinerIface, endpoint_removed),
      NULL,
      NULL,
      tracker_dbus_miner_signal_marshal_endpoint_removed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * tracker_dbus_miner_emit_started:
 * @object: A #TrackerDBusMiner.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Started">"Started"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_started (
    TrackerDBusMiner *object)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_STARTED], 0);
}

/**
 * tracker_dbus_miner_emit_stopped:
 * @object: A #TrackerDBusMiner.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Stopped">"Stopped"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_stopped (
    TrackerDBusMiner *object)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_STOPPED], 0);
}

/**
 * tracker_dbus_miner_emit_paused:
 * @object: A #TrackerDBusMiner.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Paused">"Paused"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_paused (
    TrackerDBusMiner *object)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_PAUSED], 0);
}

/**
 * tracker_dbus_miner_emit_resumed:
 * @object: A #TrackerDBusMiner.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Resumed">"Resumed"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_resumed (
    TrackerDBusMiner *object)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_RESUMED], 0);
}

/**
 * tracker_dbus_miner_emit_progress:
 * @object: A #TrackerDBusMiner.
 * @arg_status: Argument to pass with the signal.
 * @arg_progress: Argument to pass with the signal.
 * @arg_remaining_time: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.Progress">"Progress"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_progress (
    TrackerDBusMiner *object,
    const gchar *arg_status,
    gdouble arg_progress,
    gint arg_remaining_time)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_PROGRESS], 0, arg_status, arg_progress, arg_remaining_time);
}

/**
 * tracker_dbus_miner_emit_endpoint_added:
 * @object: A #TrackerDBusMiner.
 * @arg_mount_uri: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.EndpointAdded">"EndpointAdded"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_endpoint_added (
    TrackerDBusMiner *object,
    const gchar *arg_mount_uri,
    const gchar *arg_object_path)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_ENDPOINT_ADDED], 0, arg_mount_uri, arg_object_path);
}

/**
 * tracker_dbus_miner_emit_endpoint_removed:
 * @object: A #TrackerDBusMiner.
 * @arg_mount_uri: Argument to pass with the signal.
 * @arg_object_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Tracker3-Miner.EndpointRemoved">"EndpointRemoved"</link> D-Bus signal.
 */
void
tracker_dbus_miner_emit_endpoint_removed (
    TrackerDBusMiner *object,
    const gchar *arg_mount_uri,
    const gchar *arg_object_path)
{
  g_signal_emit (object, TRACKER_DBUS__MINER_SIGNALS[TRACKER_DBUS__MINER_ENDPOINT_REMOVED], 0, arg_mount_uri, arg_object_path);
}

/**
 * tracker_dbus_miner_call_start:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_start_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_start_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_start (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_start_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_start_finish (
    TrackerDBusMiner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_start_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_start_sync (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_status:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetStatus">GetStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_get_status_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_get_status_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_get_status (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_get_status_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_get_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_get_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_status_finish (
    TrackerDBusMiner *proxy,
    gchar ** out_status,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_status_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetStatus">GetStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_get_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_status_sync (
    TrackerDBusMiner *proxy,
    gchar ** out_status,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_progress:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetProgress">GetProgress()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_get_progress_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_get_progress_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_get_progress (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProgress",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_get_progress_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_progress: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_get_progress().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_get_progress().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_progress_finish (
    TrackerDBusMiner *proxy,
    gdouble* out_progress,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_progress);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_progress_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_progress: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetProgress">GetProgress()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_get_progress() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_progress_sync (
    TrackerDBusMiner *proxy,
    gdouble* out_progress,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProgress",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_progress);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_remaining_time:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetRemainingTime">GetRemainingTime()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_get_remaining_time_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_get_remaining_time_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_get_remaining_time (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetRemainingTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_get_remaining_time_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_remaining_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_get_remaining_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_get_remaining_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_remaining_time_finish (
    TrackerDBusMiner *proxy,
    gint* out_remaining_time,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_remaining_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_remaining_time_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_remaining_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetRemainingTime">GetRemainingTime()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_get_remaining_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_remaining_time_sync (
    TrackerDBusMiner *proxy,
    gint* out_remaining_time,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetRemainingTime",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_remaining_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_pause_details:
 * @proxy: A #TrackerDBusMinerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetPauseDetails">GetPauseDetails()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_get_pause_details_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_get_pause_details_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_get_pause_details (
    TrackerDBusMiner *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPauseDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_get_pause_details_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_pause_applications: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_pause_reasons: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_get_pause_details().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_get_pause_details().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_pause_details_finish (
    TrackerDBusMiner *proxy,
    gchar *** out_pause_applications,
    gchar *** out_pause_reasons,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as^as)",
                 out_pause_applications,
                 out_pause_reasons);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_get_pause_details_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_pause_applications: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_pause_reasons: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetPauseDetails">GetPauseDetails()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_get_pause_details() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_get_pause_details_sync (
    TrackerDBusMiner *proxy,
    gchar *** out_pause_applications,
    gchar *** out_pause_reasons,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPauseDetails",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as^as)",
                 out_pause_applications,
                 out_pause_reasons);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_pause:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_application: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_pause_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_pause (
    TrackerDBusMiner *proxy,
    const gchar *arg_application,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("(ss)",
                   arg_application,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_pause_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_pause_finish (
    TrackerDBusMiner *proxy,
    gint* out_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_pause_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_application: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_pause_sync (
    TrackerDBusMiner *proxy,
    const gchar *arg_application,
    const gchar *arg_reason,
    gint* out_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("(ss)",
                   arg_application,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_pause_for_process:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_application: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.PauseForProcess">PauseForProcess()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_pause_for_process_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_pause_for_process_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_pause_for_process (
    TrackerDBusMiner *proxy,
    const gchar *arg_application,
    const gchar *arg_reason,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PauseForProcess",
    g_variant_new ("(ss)",
                   arg_application,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_pause_for_process_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_pause_for_process().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_pause_for_process().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_pause_for_process_finish (
    TrackerDBusMiner *proxy,
    gint* out_cookie,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_pause_for_process_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_application: Argument to pass with the method invocation.
 * @arg_reason: Argument to pass with the method invocation.
 * @out_cookie: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.PauseForProcess">PauseForProcess()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_pause_for_process() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_pause_for_process_sync (
    TrackerDBusMiner *proxy,
    const gchar *arg_application,
    const gchar *arg_reason,
    gint* out_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PauseForProcess",
    g_variant_new ("(ss)",
                   arg_application,
                   arg_reason),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_cookie);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_resume:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Resume">Resume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_call_resume_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_call_resume_sync() for the synchronous, blocking version of this method.
 */
void
tracker_dbus_miner_call_resume (
    TrackerDBusMiner *proxy,
    gint arg_cookie,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Resume",
    g_variant_new ("(i)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * tracker_dbus_miner_call_resume_finish:
 * @proxy: A #TrackerDBusMinerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_call_resume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with tracker_dbus_miner_call_resume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_resume_finish (
    TrackerDBusMiner *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_call_resume_sync:
 * @proxy: A #TrackerDBusMinerProxy.
 * @arg_cookie: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Resume">Resume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_call_resume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
tracker_dbus_miner_call_resume_sync (
    TrackerDBusMiner *proxy,
    gint arg_cookie,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Resume",
    g_variant_new ("(i)",
                   arg_cookie),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * tracker_dbus_miner_complete_start:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_start (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * tracker_dbus_miner_complete_get_status:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @status: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetStatus">GetStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_get_status (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *status)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   status));
}

/**
 * tracker_dbus_miner_complete_get_progress:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @progress: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetProgress">GetProgress()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_get_progress (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gdouble progress)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(d)",
                   progress));
}

/**
 * tracker_dbus_miner_complete_get_remaining_time:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @remaining_time: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetRemainingTime">GetRemainingTime()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_get_remaining_time (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint remaining_time)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   remaining_time));
}

/**
 * tracker_dbus_miner_complete_get_pause_details:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pause_applications: Parameter to return.
 * @pause_reasons: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.GetPauseDetails">GetPauseDetails()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_get_pause_details (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *pause_applications,
    const gchar *const *pause_reasons)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as^as)",
                   pause_applications,
                   pause_reasons));
}

/**
 * tracker_dbus_miner_complete_pause:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_pause (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   cookie));
}

/**
 * tracker_dbus_miner_complete_pause_for_process:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @cookie: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.PauseForProcess">PauseForProcess()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_pause_for_process (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint cookie)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   cookie));
}

/**
 * tracker_dbus_miner_complete_resume:
 * @object: A #TrackerDBusMiner.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Tracker3-Miner.Resume">Resume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
tracker_dbus_miner_complete_resume (
    TrackerDBusMiner *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * TrackerDBusMinerProxy:
 *
 * The #TrackerDBusMinerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TrackerDBusMinerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TrackerDBusMinerProxy.
 */

struct _TrackerDBusMinerProxyPrivate
{
  GData *qdata;
};

static void tracker_dbus_miner_proxy_iface_init (TrackerDBusMinerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TrackerDBusMinerProxy, tracker_dbus_miner_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (TrackerDBusMinerProxy)
                         G_IMPLEMENT_INTERFACE (TRACKER_DBUS_TYPE_MINER, tracker_dbus_miner_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TrackerDBusMinerProxy, tracker_dbus_miner_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TRACKER_DBUS_TYPE_MINER, tracker_dbus_miner_proxy_iface_init))

#endif
static void
tracker_dbus_miner_proxy_finalize (GObject *object)
{
  TrackerDBusMinerProxy *proxy = TRACKER_DBUS_MINER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (tracker_dbus_miner_proxy_parent_class)->finalize (object);
}

static void
tracker_dbus_miner_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
tracker_dbus_miner_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
tracker_dbus_miner_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TRACKER_DBUS_TYPE_MINER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TRACKER_DBUS_TYPE_MINER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
tracker_dbus_miner_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  TrackerDBusMinerProxy *proxy = TRACKER_DBUS_MINER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
tracker_dbus_miner_proxy_init (TrackerDBusMinerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = tracker_dbus_miner_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TRACKER_DBUS_TYPE_MINER_PROXY, TrackerDBusMinerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), tracker_dbus_miner_interface_info ());
}

static void
tracker_dbus_miner_proxy_class_init (TrackerDBusMinerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = tracker_dbus_miner_proxy_finalize;
  gobject_class->get_property = tracker_dbus_miner_proxy_get_property;
  gobject_class->set_property = tracker_dbus_miner_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = tracker_dbus_miner_proxy_g_signal;
  proxy_class->g_properties_changed = tracker_dbus_miner_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TrackerDBusMinerProxyPrivate));
#endif
}

static void
tracker_dbus_miner_proxy_iface_init (TrackerDBusMinerIface *iface G_GNUC_UNUSED)
{
}

/**
 * tracker_dbus_miner_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_proxy_new_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
tracker_dbus_miner_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TRACKER_DBUS_TYPE_MINER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Tracker3.Miner", NULL);
}

/**
 * tracker_dbus_miner_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with tracker_dbus_miner_proxy_new().
 *
 * Returns: (transfer full) (type TrackerDBusMinerProxy): The constructed proxy object or %NULL if @error is set.
 */
TrackerDBusMiner *
tracker_dbus_miner_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TRACKER_DBUS_MINER (ret);
  else
    return NULL;
}

/**
 * tracker_dbus_miner_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TrackerDBusMinerProxy): The constructed proxy object or %NULL if @error is set.
 */
TrackerDBusMiner *
tracker_dbus_miner_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TRACKER_DBUS_TYPE_MINER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Tracker3.Miner", NULL);
  if (ret != NULL)
    return TRACKER_DBUS_MINER (ret);
  else
    return NULL;
}


/**
 * tracker_dbus_miner_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like tracker_dbus_miner_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call tracker_dbus_miner_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See tracker_dbus_miner_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
tracker_dbus_miner_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TRACKER_DBUS_TYPE_MINER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Tracker3.Miner", NULL);
}

/**
 * tracker_dbus_miner_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to tracker_dbus_miner_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with tracker_dbus_miner_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type TrackerDBusMinerProxy): The constructed proxy object or %NULL if @error is set.
 */
TrackerDBusMiner *
tracker_dbus_miner_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return TRACKER_DBUS_MINER (ret);
  else
    return NULL;
}

/**
 * tracker_dbus_miner_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like tracker_dbus_miner_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See tracker_dbus_miner_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type TrackerDBusMinerProxy): The constructed proxy object or %NULL if @error is set.
 */
TrackerDBusMiner *
tracker_dbus_miner_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TRACKER_DBUS_TYPE_MINER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Tracker3.Miner", NULL);
  if (ret != NULL)
    return TRACKER_DBUS_MINER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * TrackerDBusMinerSkeleton:
 *
 * The #TrackerDBusMinerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * TrackerDBusMinerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #TrackerDBusMinerSkeleton.
 */

struct _TrackerDBusMinerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_tracker_dbus_miner_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TRACKER_DBUS_TYPE_MINER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TRACKER_DBUS_TYPE_MINER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_tracker_dbus_miner_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_tracker_dbus_miner_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_tracker_dbus_miner_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _tracker_dbus_miner_skeleton_vtable =
{
  _tracker_dbus_miner_skeleton_handle_method_call,
  _tracker_dbus_miner_skeleton_handle_get_property,
  _tracker_dbus_miner_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
tracker_dbus_miner_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return tracker_dbus_miner_interface_info ();
}

static GDBusInterfaceVTable *
tracker_dbus_miner_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_tracker_dbus_miner_skeleton_vtable;
}

static GVariant *
tracker_dbus_miner_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_tracker_dbus_miner_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _tracker_dbus_miner_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _tracker_dbus_miner_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _tracker_dbus_miner_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
tracker_dbus_miner_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_tracker_dbus_miner_on_signal_started (
    TrackerDBusMiner *object)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "Started",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_stopped (
    TrackerDBusMiner *object)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "Stopped",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_paused (
    TrackerDBusMiner *object)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "Paused",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_resumed (
    TrackerDBusMiner *object)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "Resumed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_progress (
    TrackerDBusMiner *object,
    const gchar *arg_status,
    gdouble arg_progress,
    gint arg_remaining_time)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sdi)",
                   arg_status,
                   arg_progress,
                   arg_remaining_time));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "Progress",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_endpoint_added (
    TrackerDBusMiner *object,
    const gchar *arg_mount_uri,
    const gchar *arg_object_path)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_mount_uri,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "EndpointAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_tracker_dbus_miner_on_signal_endpoint_removed (
    TrackerDBusMiner *object,
    const gchar *arg_mount_uri,
    const gchar *arg_object_path)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(so)",
                   arg_mount_uri,
                   arg_object_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Tracker3.Miner", "EndpointRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void tracker_dbus_miner_skeleton_iface_init (TrackerDBusMinerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (TrackerDBusMinerSkeleton, tracker_dbus_miner_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (TrackerDBusMinerSkeleton)
                         G_IMPLEMENT_INTERFACE (TRACKER_DBUS_TYPE_MINER, tracker_dbus_miner_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (TrackerDBusMinerSkeleton, tracker_dbus_miner_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TRACKER_DBUS_TYPE_MINER, tracker_dbus_miner_skeleton_iface_init))

#endif
static void
tracker_dbus_miner_skeleton_finalize (GObject *object)
{
  TrackerDBusMinerSkeleton *skeleton = TRACKER_DBUS_MINER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  /* coverity[missing_lock : SUPPRESS] */
  g_clear_pointer (&skeleton->priv->changed_properties_idle_source, g_source_destroy);
#else
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
skeleton->priv->changed_properties_idle_source = NULL;
#endif
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (tracker_dbus_miner_skeleton_parent_class)->finalize (object);
}

static void
tracker_dbus_miner_skeleton_init (TrackerDBusMinerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = tracker_dbus_miner_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TRACKER_DBUS_TYPE_MINER_SKELETON, TrackerDBusMinerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
tracker_dbus_miner_skeleton_class_init (TrackerDBusMinerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = tracker_dbus_miner_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = tracker_dbus_miner_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = tracker_dbus_miner_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = tracker_dbus_miner_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = tracker_dbus_miner_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (TrackerDBusMinerSkeletonPrivate));
#endif
}

static void
tracker_dbus_miner_skeleton_iface_init (TrackerDBusMinerIface *iface)
{
  iface->started = _tracker_dbus_miner_on_signal_started;
  iface->stopped = _tracker_dbus_miner_on_signal_stopped;
  iface->paused = _tracker_dbus_miner_on_signal_paused;
  iface->resumed = _tracker_dbus_miner_on_signal_resumed;
  iface->progress = _tracker_dbus_miner_on_signal_progress;
  iface->endpoint_added = _tracker_dbus_miner_on_signal_endpoint_added;
  iface->endpoint_removed = _tracker_dbus_miner_on_signal_endpoint_removed;
}

/**
 * tracker_dbus_miner_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Tracker3-Miner.top_of_page">org.freedesktop.Tracker3.Miner</link>.
 *
 * Returns: (transfer full) (type TrackerDBusMinerSkeleton): The skeleton object.
 */
TrackerDBusMiner *
tracker_dbus_miner_skeleton_new (void)
{
  return TRACKER_DBUS_MINER (g_object_new (TRACKER_DBUS_TYPE_MINER_SKELETON, NULL));
}

