/*
 * Copyright © 2024 Igalia S.L.
 * SPDX-License-Identifier: MIT
 */

#pragma once

#include <stdint.h>

typedef struct
{
   uint32_t chipID;
   uint32_t chipVersion;
   uint32_t productID;
   uint32_t ecoID;
   uint32_t customerID;
   uint32_t patchVersion;
   const char * productName;
   uint32_t formalRelease;
   uint32_t TempRegisters;
   uint32_t ThreadCount;
   uint32_t NumShaderCores;
   uint32_t InstructionCount;
   uint32_t NumberOfConstants;
   uint32_t CoreCount;
   uint32_t LocalStorageSize;
   uint32_t LocalStorageSize_1;
   uint32_t LocalStorageSize_2;
   uint32_t L1CacheSize;
   uint32_t L1CacheSize_1;
   uint32_t L1CacheSize_2;
   uint32_t InstructionMemorySize;
   uint32_t ShaderPCLength;
   uint32_t USC_MAX_PAGES;
   uint32_t USC_MAX_PAGES_1;
   uint32_t USC_MAX_PAGES_2;
   uint32_t NumPixelPipes;
   uint32_t USC_CACHE_CONTROLLERS;
   uint32_t USC_CACHE_CONTROLLERS_1;
   uint32_t USC_CACHE_CONTROLLERS_2;
   uint32_t USC_BANKS;
   uint32_t USC_BANKS_1;
   uint32_t USC_BANKS_2;
   uint32_t Streams;
   uint32_t VaryingCount;
   uint32_t VertexOutputBufferSize;
   uint32_t BufferSize;
   uint32_t VertexCacheSize;
   uint32_t NumResolvePipes;
   uint32_t RESULT_WINDOW_MAX_SIZE;
   uint32_t ClusterAliveMask;
   uint32_t G2D_DEC400_MINOR;
   uint32_t PS_INSTRUCTION_COUNT;
   uint32_t NNMadPerCore;
   uint32_t NNCoreCount;
   uint32_t NN_ACTIVE_CORE_COUNT;
   uint32_t NNCoreCount_INT8;
   uint32_t NNCoreCount_INT16;
   uint32_t NNCoreCount_FLOAT16;
   uint32_t NNCoreCount_BFLOAT;
   uint32_t NNInputBufferDepth;
   uint32_t NNAccumBufferDepth;
   uint32_t TPEngine_PwlLUTCount;
   uint32_t TPEngine_PwlLUTSize;
   uint32_t VIP_SRAM_SIZE;
   uint32_t TPEngine_CoreCount;
   uint32_t AXI_SRAM_SIZE;
   uint32_t NN_INIMAGE_OFFSET_BITS;
   uint32_t TP_REORDER_INIMAGE_SIZE;
   uint32_t TPLite_CoreCount;
   uint32_t NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE;
   uint32_t NNFP16_XYDP_X;
   uint32_t NNFP16_XYDP_Y;
   uint32_t NNFP16_ZDP;
   uint32_t NN_LANES_PER_OUT_CYCLE;
   uint32_t MAX_OT_NUMBER;
   uint32_t PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE;
   uint32_t EQUIVALENT_VIP_SRAM_WIDTH_INBYTE;
   uint32_t TP_ZRL_BITS;
   uint32_t NN_ZRL_BITS;
   uint32_t LATENCY_HIDING_AT_FULL_AXI_BW;
   uint32_t AXI_BUS_WIDTH;
   uint32_t NN_KERNEL_X_SIZE;
   uint32_t NN_KERNEL_Y_SIZE;
   uint32_t NN_FC_KERNEL_Y_SIZE;
   uint32_t NN_KERNEL_Z_SIZE;
   uint32_t NN_X_OFFSET;
   uint32_t NN_Y_OFFSET;
   uint32_t DDR_KERNEL_BURST_SIZE;
   uint32_t OUTIMAGE_X_STRIDE_BITS;
   uint32_t OUTIMAGE_Y_STRIDE_BITS;
   uint32_t INIMAGE_X_STRIDE_BITS;
   uint32_t IMIMAGE_Y_STRIDE_BITS;
   uint32_t OUTIMAGE_X_SIZE_BITS;
   uint32_t OUTIMAGE_Y_SIZE_BITS;
   uint32_t OUTIMAGE_Z_SIZE_BITS;
   uint32_t INIMAGE_X_SIZE_BITS;
   uint32_t INIMAGE_Y_SIZE_BITS;
   uint32_t MAX_TILE_X_SIZE;
   uint32_t NN_CLUSTER_NUM_FOR_POWER_CONTROL;
   uint32_t NN_IN_LINES_PER_CYCLE;
   uint32_t VIP_CLUSTER_COUNT;
   uint32_t NN_MP_INTER_CONNECT_RING_COUNT;
   uint32_t REG_FastClear:1;
   uint32_t REG_SpecialAntiAliasing:1;
   uint32_t REG_Pipe3D:1;
   uint32_t REG_DXTTextureCompression:1;
   uint32_t REG_DebugMode:1;
   uint32_t REG_ZCompression:1;
   uint32_t REG_YUV420Filter:1;
   uint32_t REG_MSAA:1;
   uint32_t REG_DC:1;
   uint32_t REG_Pipe2D:1;
   uint32_t REG_ETC1TextureCompression:1;
   uint32_t REG_FastScaler:1;
   uint32_t REG_HighDynamicRange:1;
   uint32_t REG_YUV420Tiler:1;
   uint32_t REG_ModuleCG:1;
   uint32_t REG_MinArea:1;
   uint32_t REG_NoEZ:1;
   uint32_t REG_No422Texture:1;
   uint32_t REG_BufferInterleaving:1;
   uint32_t REG_ByteWrite2D:1;
   uint32_t REG_NoScaler:1;
   uint32_t REG_YUY2Averaging:1;
   uint32_t REG_HalfPECache:1;
   uint32_t REG_HalfTXCache:1;
   uint32_t REG_YUY2RenderTarget:1;
   uint32_t REG_Mem32BitSupport:1;
   uint32_t REG_PipeVG:1;
   uint32_t REG_VGTS:1;
   uint32_t REG_FE20:1;
   uint32_t REG_ByteWrite3D:1;
   uint32_t REG_RsYuvTarget:1;
   uint32_t REG_FE20BitIndex:1;
   uint32_t REG_FlipY:1;
   uint32_t REG_DualReturnBus:1;
   uint32_t REG_EndiannessConfig:1;
   uint32_t REG_Texture8K:1;
   uint32_t REG_CorrectTextureConverter:1;
   uint32_t REG_SpecialMsaaLod:1;
   uint32_t REG_FastClearFlush:1;
   uint32_t REG_2DPE20:1;
   uint32_t REG_CorrectAutoDisable:1;
   uint32_t REG_Render8K:1;
   uint32_t REG_TileStatus2Bits:1;
   uint32_t REG_SeparateTileStatusWhenInterleaved:1;
   uint32_t REG_SuperTiled32x32:1;
   uint32_t REG_VG20:1;
   uint32_t REG_TSExtendedCommands:1;
   uint32_t REG_CompressionFifoFixed:1;
   uint32_t REG_ExtraShaderInstructions0:1;
   uint32_t REG_VGFilter:1;
   uint32_t REG_VG21:1;
   uint32_t REG_ShaderGetsW:1;
   uint32_t REG_ExtraShaderInstructions1:1;
   uint32_t REG_DefaultReg0:1;
   uint32_t REG_MC20:1;
   uint32_t REG_ShaderMSAASideband:1;
   uint32_t REG_BugFixes0:1;
   uint32_t REG_VAA:1;
   uint32_t REG_BypassInMSAA:1;
   uint32_t REG_HierarchicalZ:1;
   uint32_t REG_NewTexture:1;
   uint32_t REG_A8TargetSupport:1;
   uint32_t REG_CorrectStencil:1;
   uint32_t REG_EnhanceVR:1;
   uint32_t REG_RSUVSwizzle:1;
   uint32_t REG_V2Compression:1;
   uint32_t REG_VGDoubleBuffer:1;
   uint32_t REG_BugFixes1:1;
   uint32_t REG_BugFixes2:1;
   uint32_t REG_TextureStride:1;
   uint32_t REG_BugFixes3:1;
   uint32_t REG_CorrectAutoDisable1:1;
   uint32_t REG_AutoRestartTS:1;
   uint32_t REG_BugFixes4:1;
   uint32_t REG_L2Windowing:1;
   uint32_t REG_HalfFloatPipe:1;
   uint32_t REG_PixelDither:1;
   uint32_t REG_TwoStencilReference:1;
   uint32_t REG_ExtendedPixelFormat:1;
   uint32_t REG_CorrectMinMaxDepth:1;
   uint32_t REG_DitherAndFilterPlusAlpha2D:1;
   uint32_t REG_BugFixes5:1;
   uint32_t REG_New2D:1;
   uint32_t REG_NewFloatingPointArithmetic:1;
   uint32_t REG_TextureHorizontalAlignmentSelect:1;
   uint32_t REG_NonPowerOfTwo:1;
   uint32_t REG_LinearTextureSupport:1;
   uint32_t REG_Halti0:1;
   uint32_t REG_CorrectOverflowVG:1;
   uint32_t REG_NegativeLogFix:1;
   uint32_t REG_ResolveOffset:1;
   uint32_t REG_OkToGateAxiClock:1;
   uint32_t REG_MMU:1;
   uint32_t REG_WideLine:1;
   uint32_t REG_BugFixes6:1;
   uint32_t REG_FcFlushStall:1;
   uint32_t REG_LineLoop:1;
   uint32_t REG_LogicOp:1;
   uint32_t REG_SeamlessCubeMap:1;
   uint32_t REG_SuperTiledTexture:1;
   uint32_t REG_LinearPE:1;
   uint32_t REG_RectPrimitive:1;
   uint32_t REG_Composition:1;
   uint32_t REG_CorrectAutoDisableCountWidth:1;
   uint32_t REG_PESwizzle:1;
   uint32_t REG_EndEvent:1;
   uint32_t REG_S1S8:1;
   uint32_t REG_Halti1:1;
   uint32_t REG_RGB888:1;
   uint32_t REG_TX_YUVAssembler:1;
   uint32_t REG_DynamicFrequencyScaling:1;
   uint32_t REG_TXFilter:1;
   uint32_t REG_FullDirectFB:1;
   uint32_t REG_OnePass2DFilter:1;
   uint32_t REG_ThreadWalkerInPS:1;
   uint32_t REG_TileFiller:1;
   uint32_t REG_YUVStandard:1;
   uint32_t REG_MultiSourceBlt:1;
   uint32_t REG_YUVConversion:1;
   uint32_t REG_FlushFixed2D:1;
   uint32_t REG_Interleaver:1;
   uint32_t REG_MixedStreams:1;
   uint32_t REG_L2CacheFor2D420:1;
   uint32_t REG_BugFixes7:1;
   uint32_t REG_NoIndexPattern:1;
   uint32_t REG_TextureTileStatus:1;
   uint32_t REG_DecompressZ16:1;
   uint32_t REG_BugFixes8:1;
   uint32_t REG_DERotationStallFix:1;
   uint32_t REG_OclOnly:1;
   uint32_t REG_NewFeatures0:1;
   uint32_t REG_InstructionCache:1;
   uint32_t REG_GeometryShader:1;
   uint32_t REG_TexCompressionSupertiled:1;
   uint32_t REG_Generics:1;
   uint32_t REG_BugFixes9:1;
   uint32_t REG_FastMSAA:1;
   uint32_t REG_WClip:1;
   uint32_t REG_BugFixes10:1;
   uint32_t REG_UnifiedSamplers:1;
   uint32_t REG_BugFixes11:1;
   uint32_t REG_PerformanceCounters:1;
   uint32_t REG_ExtraShaderInstructions2:1;
   uint32_t REG_BugFixes12:1;
   uint32_t REG_BugFixes13:1;
   uint32_t REG_DEEnhancements1:1;
   uint32_t REG_ACE:1;
   uint32_t REG_TXEnhancements1:1;
   uint32_t REG_SHEnhancements1:1;
   uint32_t REG_SHEnhancements2:1;
   uint32_t REG_PEEnhancements1:1;
   uint32_t REG_DEEnhancements2:1;
   uint32_t REG_BugFixes14:1;
   uint32_t REG_PowerOptimizations0:1;
   uint32_t REG_NewHZ:1;
   uint32_t REG_BugFixes15:1;
   uint32_t REG_DEEnhancements3:1;
   uint32_t REG_SHEnhancements3:1;
   uint32_t REG_SHEnhancements4:1;
   uint32_t REG_TXEnhancements2:1;
   uint32_t REG_FEEnhancements1:1;
   uint32_t REG_PEEnhancements2:1;
   uint32_t REG_PAEnhancements1:1;
   uint32_t REG_DENoGamma:1;
   uint32_t REG_PAEnhancements2:1;
   uint32_t REG_DEEnhancements4:1;
   uint32_t REG_PEEnhancements3:1;
   uint32_t REG_HIEnhancements1:1;
   uint32_t REG_TXEnhancements3:1;
   uint32_t REG_SHEnhancements5:1;
   uint32_t REG_FEEnhancements2:1;
   uint32_t REG_BugFixes16:1;
   uint32_t REG_DEEnhancements5:1;
   uint32_t REG_TXEnhancements4:1;
   uint32_t REG_PEEnhancements4:1;
   uint32_t REG_MCEnhancements1:1;
   uint32_t REG_Halti2:1;
   uint32_t REG_DEMirrorRotate:1;
   uint32_t REG_SmallMSAA:1;
   uint32_t REG_BugFixes17:1;
   uint32_t REG_Rasterizer2:1;
   uint32_t REG_DualPipeOPF:1;
   uint32_t REG_MultiSrcV2:1;
   uint32_t REG_CSCV2:1;
   uint32_t REG_PAEnhancements3:1;
   uint32_t REG_BugFixes18:1;
   uint32_t REG_Compression2D:1;
   uint32_t REG_Probe:1;
   uint32_t REG_MediumPrecision:1;
   uint32_t REG_DESupertile:1;
   uint32_t REG_BugFixes19:1;
   uint32_t REG_SHEnhancements6:1;
   uint32_t REG_SHEnhancements7:1;
   uint32_t REG_BugFixes20:1;
   uint32_t REG_DEAddress40:1;
   uint32_t REG_MiniMMUFix:1;
   uint32_t REG_EEZ:1;
   uint32_t REG_BugFixes21:1;
   uint32_t REG_ExtraVgCaps:1;
   uint32_t REG_MultiSrcV15:1;
   uint32_t REG_BugFixes22:1;
   uint32_t REG_Halti3:1;
   uint32_t REG_TessellationShaders:1;
   uint32_t REG_OPF9Tap:1;
   uint32_t REG_MultiSrcV2StrQuad:1;
   uint32_t REG_SeperateSRCAndDstCache:1;
   uint32_t REG_Halti4:1;
   uint32_t REG_RAWriteDepth:1;
   uint32_t REG_AndroidOnly:1;
   uint32_t REG_HasChipProductReg:1;
   uint32_t REG_TXSupportDEC:1;
   uint32_t REG_S8MSAACompression:1;
   uint32_t REG_BugFixesIn544:1;
   uint32_t REG_L2CacheRemove:1;
   uint32_t REG_FEAllowRndVtxCnt:1;
   uint32_t REG_CubeMapFL28:1;
   uint32_t REG_TX6bitFrac:1;
   uint32_t REG_FEAllowStallPrefetchEng:1;
   uint32_t REG_ThirdPartyCompression:1;
   uint32_t REG_RSS8:1;
   uint32_t REG_MSAACoherencyCheck:1;
   uint32_t REG_Halti5:1;
   uint32_t REG_Evis:1;
   uint32_t REG_BltEngine:1;
   uint32_t REG_BugFixes23:1;
   uint32_t REG_BugFixes24:1;
   uint32_t REG_DEC:1;
   uint32_t REG_VSTileNV12:1;
   uint32_t REG_VSTileNV12_10BIT:1;
   uint32_t REG_DisableVIP:1;
   uint32_t RenderTarget8:1;
   uint32_t TxLodFlowCorrection:1;
   uint32_t FaceLod:1;
   uint32_t MultiCoreSemaphoreStallV2:1;
   uint32_t VMSAA:1;
   uint32_t ChipEnableLink:1;
   uint32_t MULTI_SRC_BLT_1_5_ENHANCEMENT:1;
   uint32_t MULTI_SRC_BLT_BILINEAR_FILTER:1;
   uint32_t RA_HZEZ_CLOCK_CONTROL:1;
   uint32_t CACHE128B256BPERLINE:1;
   uint32_t V4Compression:1;
   uint32_t DE2D_MAJOR_SUPER_TILE:1;
   uint32_t PE2D_MAJOR_SUPER_TILE:1;
   uint32_t PE_32BPC_COLORMASK_FIX:1;
   uint32_t ALPHA_BLENDING_OPT:1;
   uint32_t NEW_GPIPE:1;
   uint32_t PIPELINE_32_ATTRIBUTES:1;
   uint32_t MSAA_SHADING:1;
   uint32_t NO_ANISTRO_FILTER:1;
   uint32_t NO_ASTC:1;
   uint32_t NO_DXT:1;
   uint32_t HWTFB:1;
   uint32_t RA_DEPTH_WRITE_MSAA1X_FIX:1;
   uint32_t EZHZ_CLOCKGATE_FIX:1;
   uint32_t SH_SNAP2PAGE_FIX:1;
   uint32_t SH_HALFDEPENDENCY_FIX:1;
   uint32_t USC_MCFILL_FIX:1;
   uint32_t TPG_TCPERF_FIX:1;
   uint32_t USC_MDFIFO_OVERFLOW_FIX:1;
   uint32_t SH_TEXLD_BARRIER_IN_CS_FIX:1;
   uint32_t RS_NEW_BASEADDR:1;
   uint32_t PE_8bpp_DUALPIPE_FIX:1;
   uint32_t SH_ADVANCED_INSTR:1;
   uint32_t SH_FLAT_INTERPOLATION_DUAL16_FIX:1;
   uint32_t USC_CONTINUOUS_FLUS_FIX:1;
   uint32_t SH_SUPPORT_V4:1;
   uint32_t SH_SUPPORT_ALPHA_KILL:1;
   uint32_t PE_NO_ALPHA_TEST:1;
   uint32_t TX_LOD_NEAREST_SELECT:1;
   uint32_t SH_FIX_LDEXP:1;
   uint32_t SUPPORT_MOVAI:1;
   uint32_t SH_SNAP2PAGE_MAXPAGES_FIX:1;
   uint32_t PE_RGBA16I_FIX:1;
   uint32_t BLT_8bpp_256TILE_FC_FIX:1;
   uint32_t PE_64bit_FENCE_FIX:1;
   uint32_t USC_FULL_CACHE_FIX:1;
   uint32_t TX_YUV_ASSEMBLER_10BIT:1;
   uint32_t FE_32bit_INDEX_FIX:1;
   uint32_t BLT_64bpp_MASKED_CLEAR_FIX:1;
   uint32_t SECURITY:1;
   uint32_t ROBUSTNESS:1;
   uint32_t USC_ATOMIC_FIX:1;
   uint32_t SH_PSO_MSAA1x_FIX:1;
   uint32_t USC_VX_PERF_FIX:1;
   uint32_t USC_GOS_ADDR_FIX:1;
   uint32_t TX_8bit_UVFrac:1;
   uint32_t TX_DESC_CACHE_CLOCKGATE_FIX:1;
   uint32_t RSBLT_MSAA_DECOMPRESSION:1;
   uint32_t TX_INTEGER_COORDINATE:1;
   uint32_t DRAWID:1;
   uint32_t PSIO_SAMPLEMASK_IN_R0ZW_FIX:1;
   uint32_t TX_INTEGER_COORDINATE_V2:1;
   uint32_t MULTI_CORE_BLOCK_SET_CONFIG:1;
   uint32_t SNAPPAGE_CMD:1;
   uint32_t SH_NO_INDEX_CONST_ON_A0:1;
   uint32_t SH_NO_ONECONST_LIMIT:1;
   uint32_t SH_IMG_LDST_ON_TEMP:1;
   uint32_t COMPUTE_ONLY:1;
   uint32_t SH_IMG_LDST_CLAMP:1;
   uint32_t SH_ICACHE_ALLOC_COUNT_FIX:1;
   uint32_t SH_ICACHE_PREFETCH:1;
   uint32_t PE2D_SEPARATE_CACHE:1;
   uint32_t PE_MSAA_OQ_FIX:1;
   uint32_t PSIO_MSAA_CL_FIX:1;
   uint32_t USC_DEFER_FILL_FIX:1;
   uint32_t SH_CLOCK_GATE_FIX:1;
   uint32_t FE_NEED_DUMMYDRAW:1;
   uint32_t PE2D_LINEAR_YUV420_OUTPUT:1;
   uint32_t PE2D_LINEAR_YUV420_10BIT:1;
   uint32_t MULTI_CLUSTER:1;
   uint32_t SH_MULTI_WG_PACK:1;
   uint32_t SH_DUAL16_SAMPLEMASK_ZW:1;
   uint32_t TPG_TRIVIAL_MODE_FIX:1;
   uint32_t TX_ASTC_MULTISLICE_FIX:1;
   uint32_t FE_ROBUST_FIX:1;
   uint32_t SH_GPIPE_ACCESS_FULLTEMPS:1;
   uint32_t PSIO_INTERLOCK:1;
   uint32_t PA_WIDELINE_FIX:1;
   uint32_t WIDELINE_HELPER_FIX:1;
   uint32_t G2D_3rd_PARTY_COMPRESSION_1_1:1;
   uint32_t TX_FLUSH_L1CACHE:1;
   uint32_t PE_DITHER_FIX2:1;
   uint32_t SH_TEXLD_U_FIX:1;
   uint32_t MC_FCCACHE_BYTEMASK:1;
   uint32_t SH_MULTI_WG_PACK_FIX:1;
   uint32_t PE_ADVANCE_BLEND_PART0:1;
   uint32_t FE_PATCHLIST_FETCH_FIX:1;
   uint32_t RA_CG_FIX:1;
   uint32_t DEC400:1;
   uint32_t LS_SUPPORT_PERCOMP_DEPENDENCY:1;
   uint32_t MULTI_CORE_BLOCK_SET_CONFIG2:1;
   uint32_t PE_VMSAA_COVERAGE_CACHE_FIX:1;
   uint32_t SECURITY_AHB:1;
   uint32_t MULTICORE_SEMAPHORESTALL_V3:1;
   uint32_t SMALLBATCH:1;
   uint32_t SH_CMPLX:1;
   uint32_t SH_IDIV0_SWZL_EHS:1;
   uint32_t TX_LERP_LESS_BIT:1;
   uint32_t SH_GM_ENDIAN:1;
   uint32_t SH_GM_USC_UNALLOC:1;
   uint32_t SH_END_OF_BB:1;
   uint32_t TX_BORDER_CLAMP_FIX:1;
   uint32_t SH_IMG_LD_LASTPIXEL_FIX:1;
   uint32_t ASYNC_BLT:1;
   uint32_t ASYNC_FE_FENCE_FIX:1;
   uint32_t PSCS_THROTTLE:1;
   uint32_t SEPARATE_LS:1;
   uint32_t WIDELINE_TRIANGLE_EMU:1;
   uint32_t FENCE_32BIT:1;
   uint32_t FENCE_64BIT:1;
   uint32_t PE_DEPTH_ONLY_OQFIX:1;
   uint32_t TX_SEAMLESS_CUBE:1;
   uint32_t TX_SNORM_SUPPORT:1;
   uint32_t SH_SCATTER_GATHER:1;
   uint32_t HWMANAGED_LS:1;
   uint32_t SH_IMAGE_ENABLE_FIX:1;
   uint32_t MSAA_FRAGMENT_OPERATION:1;
   uint32_t PE_TILE_CACHE_FLUSH_FIX:1;
   uint32_t BLT_YUV_OUTPUT:1;
   uint32_t SH_IO_CG_FIX:1;
   uint32_t PE_SWIZZLE:1;
   uint32_t SH_ROBUSTNESS_FIX:1;
   uint32_t USC_ATOMIC_FIX2:1;
   uint32_t PE_A8B8G8R8:1;
   uint32_t MULTIVIEW_RENDER:1;
   uint32_t FE_DRAW_DIRECT:1;
   uint32_t TX_VKBORDER_MODE:1;
   uint32_t TX_UNNORMALIZED_COORD:1;
   uint32_t PA_LINECLIP_FIX:1;
   uint32_t TX_8bit_UVFrac_ROUNDING_FIX:1;
   uint32_t MP_ARCH:1;
   uint32_t TX_NO_FIXED_FILTER:1;
   uint32_t SHARE_Z:1;
   uint32_t DE_2D_FAST_CLEAR:1;
   uint32_t DE_TILESTATUS_ROTATION_FIX:1;
   uint32_t TX_CLEAR_PENDING_FIX:1;
   uint32_t HI1_L2_CACHE:1;
   uint32_t USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX:1;
   uint32_t FORMAT_10BIT_CROSS_4K:1;
   uint32_t FORMAT_P010LSB_I010:1;
   uint32_t ENDIAN_CONTROL:1;
   uint32_t G2D_RGB_PLANAR:1;
   uint32_t G2D_DEC400EX:1;
   uint32_t G2D_NO_YUV420_SOURCE:1;
   uint32_t G2D_YUV420_101010:1;
   uint32_t SH_VX2_FLOATING_MAD_FIX:1;
   uint32_t TS_FC_VULKAN_SUPPORT:1;
   uint32_t MSAA_FLOAT_64BIT:1;
   uint32_t INDIRECT_COMPUTE_ZERODIM_FIX:1;
   uint32_t Q_CHANNEL_SUPPORT:1;
   uint32_t MMU_PAGE_DESCRIPTOR:1;
   uint32_t YUV_LINEAR_TO_TILE_ROTATE:1;
   uint32_t VEC2_IMULIMAD32_SUPPORT:1;
   uint32_t VEC4_IMULIMAD32_SUPPORT:1;
   uint32_t VEC2_IDIVIMOD16_SUPPORT:1;
   uint32_t DST_TEX_I2F_F2I_INST_DEPRECATE:1;
   uint32_t ALU_FP16_INSTRUCTIONS:1;
   uint32_t DUAL16_14BIT_PC_SUPPORT:1;
   uint32_t LDST_CONV_4ROUNDING_MODES:1;
   uint32_t FULL_PACK_MODE_SUPPORT:1;
   uint32_t DEPTH_FLOAT32_SUPPORT:1;
   uint32_t GPU_INSPECTOR_COUNTERS:1;
   uint32_t FP32_TO_FP16_CONV_FIX:1;
   uint32_t IMGLD_COMP_COUNT_FIX:1;
   uint32_t IMGLD_WIDTH_LT16_FIX:1;
   uint32_t TX_FILTER_ROUND_FIX:1;
   uint32_t SH_FP32_FMA_SUPPORT:1;
   uint32_t TX_ETC2_COMPRESSION:1;
   uint32_t VG_TS_CULLING:1;
   uint32_t VG_FP25:1;
   uint32_t VG_AYUV_INPUT_OUTPUT:1;
   uint32_t VG_DOUBLE_IMAGE:1;
   uint32_t VG_RECTANGLE_STRIPE_MODE:1;
   uint32_t VG_MMU:1;
   uint32_t VG_IM_FILTER:1;
   uint32_t VG_IM_YUV_PACKET:1;
   uint32_t VG_IM_YUV_PLANAR:1;
   uint32_t VG_PE_YUV_PACKET:1;
   uint32_t VG_COLOR_PRECISION_8_BIT:1;
   uint32_t VG_RESOLVE_ENGINE:1;
   uint32_t VG_PE_COLOR_KEY:1;
   uint32_t VG_IM_INDEX_FORMAT:1;
   uint32_t VG_RESOLUTION_8K:1;
   uint32_t VG_IMAGE_16K:1;
   uint32_t VG_FORMAT_ARGB2222:1;
   uint32_t G2D_DEC400:1;
   uint32_t DC_OVERLAY_SCALING:1;
   uint32_t DC_SOURCE_ROTATION:1;
   uint32_t DC_TILED:1;
   uint32_t DC_YUV_L1:1;
   uint32_t DC_D30_OUTPUT:1;
   uint32_t DC_MMU:1;
   uint32_t DC_COMPRESSION:1;
   uint32_t DC_QOS:1;
   uint32_t VIP_HW_FINAL_RELEASE:1;
   uint32_t NN_SINGLEPORT_ACCUMBUFFER:1;
   uint32_t NN_STRIDE_SUPPORT:1;
   uint32_t SWTILING_PHASE1:1;
   uint32_t SWTILING_PHASE2:1;
   uint32_t TP_SIMPLE_INT16:1;
   uint32_t TP_REAL_INT16:1;
   uint32_t TP_ROI_POOLING:1;
   uint32_t TP_MAX_POOLING_STRIDE1:1;
   uint32_t TP_LRN:1;
   uint32_t TP_REORDER:1;
   uint32_t TF_QUANTIZATION:1;
   uint32_t NN_NONZERO_BORDER:1;
   uint32_t NN_MIRROR_BORDER:1;
   uint32_t AI_GPU:1;
   uint32_t EVIS_NO_ABSDIFF:1;
   uint32_t EVIS_NO_BITREPLACE:1;
   uint32_t EVIS_NO_BOXFILTER:1;
   uint32_t EVIS_NO_CORDIAC:1;
   uint32_t EVIS_NO_DP32:1;
   uint32_t EVIS_NO_FILTER:1;
   uint32_t EVIS_NO_IADD:1;
   uint32_t EVIS_NO_SELECTADD:1;
   uint32_t EVIS_LERP_7OUTPUT:1;
   uint32_t EVIS_ACCSQ_8OUTPUT:1;
   uint32_t EVIS_VX2:1;
   uint32_t TP_ENGINE:1;
   uint32_t VIP_V7:1;
   uint32_t TP_TENSOR_ADD_MUL:1;
   uint32_t NN_DEPTHWISE_INT16XINT8:1;
   uint32_t NN_DEPTHWISE_8BIT_VIP_V7:1;
   uint32_t TP_SOFTMAX:1;
   uint32_t NN_23BITS_POST_MULTIPLIER_VIP_V7:1;
   uint32_t TP_23BITS_POST_MULTIPLIER_VIP_V7:1;
   uint32_t CONV_INT16X8BIT_VIP_V7:1;
   uint32_t NN_REMOVE_POOLING:1;
   uint32_t NN_40BIT_BIAS:1;
   uint32_t TP_REMOVE_USC:1;
   uint32_t NN_ZDP6:1;
   uint32_t NN_XYDP9:1;
   uint32_t NN_FIRST_PIXEL_POOLING:1;
   uint32_t NN_ZDP3:1;
   uint32_t NN_XYDP6:1;
   uint32_t SWTILING_PHASE3:1;
   uint32_t MCFE:1;
   uint32_t USC_STAY_LRU:1;
   uint32_t COEF_COMPRESSION_ENHANCEMENT:1;
   uint32_t TP_COEF_COMPRESSION_ENHANCEMENT:1;
   uint32_t NN_COEF_DECOMPRESS_PERF2X:1;
   uint32_t TP_SMALLBATCH_PHASE1:1;
   uint32_t OCB_COUNTER:1;
   uint32_t SCALER:1;
   uint32_t SCALER_4K:1;
   uint32_t INPUT_4BIT:1;
   uint32_t NN_NO_Z_LOCATION_OFFSET:1;
   uint32_t OCB_REMAP_PHYSICAL_ADDRESS:1;
   uint32_t NN_SLOW_OUTPUT:1;
   uint32_t NO_NARROW_POST_PROCESS_PIPE:1;
   uint32_t TP_NN_PROBE:1;
   uint32_t NN_DEPTHWISE_SUPPORT:1;
   uint32_t NN_XYDP0:1;
   uint32_t NN_WRITE_WITHOUT_USC:1;
   uint32_t NN_HW_LIMITATION_NATIVE_KER_1x2_2x1:1;
   uint32_t NN_SMALLBATCH_PHASE1:1;
   uint32_t NN_SLICE_PADDING_TO_64BYTE_ALIGN:1;
   uint32_t NN_DW_1x1_CONV_MERGE:1;
   uint32_t TP_BFLOAT16:1;
   uint32_t TP_23BITS_POST_MULTIPLIER:1;
   uint32_t NN_TRANSPOSE:1;
   uint32_t NN_ZDP_TRANSPOSE_CH9_ONLY:1;
   uint32_t USE_SINGLE_PORT_VIPSRAM:1;
   uint32_t NN_LEAKY_RELU:1;
   uint32_t NN_PRELU:1;
   uint32_t NN_PER_CHANNEL_QUANT:1;
   uint32_t NN_PER_CHANNEL_QUANT_ASYM:1;
   uint32_t NN_ASYMMETRIC_INT8:1;
   uint32_t NN_FLOAT_POST_MULT:1;
   uint32_t PRELU_LEAKLY_RELU_CLAMP:1;
   uint32_t TPLITE_BFLOAT16:1;
   uint32_t PREPROCESS_IMG_BUF_640BYTE_LIMIT:1;
   uint32_t NN_POST_OUT_SUPPORT_FP16:1;
   uint32_t NN_POST_OUT_SUPPORT_BF16:1;
   uint32_t NN_POST_OUT_SUPPORT_FP32:1;
   uint32_t TP_KERNEL_1BYTE_ALGIN:1;
   uint32_t BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE:1;
   uint32_t NN_COMPRESSION_BYPASSS:1;
   uint32_t TP_3_USC:1;
   uint32_t BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE:1;
   uint32_t NN_NATIVE_STRIDE_TWO:1;
   uint32_t NN_TENSOR_ADD:1;
   uint32_t NN_FLOAT32_IO:1;
   uint32_t TP_FLOAT32_IO:1;
   uint32_t NN_SMALL_BATCH_PHASE2:1;
   uint32_t TILE_ACCESS_CAPABILITY:1;
   uint32_t FAST_DP3_PREPROCESSOR:1;
   uint32_t DEPTHWISE_SUPPORT_16BIT_FORMAT:1;
   uint32_t NN_SUPPORT_ALU:1;
   uint32_t NN_ENHANCED_MAX_POOLING:1;
   uint32_t NN_TRANSPOSE_PHASE2:1;
   uint32_t NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD:1;
   uint32_t NN_CONV_CORE_BYPASS:1;
   uint32_t NN_TENSOR_ADD_RELU:1;
   uint32_t TPLITE_SUPPORT_TP_DATA_TRANSPOSE:1;
   uint32_t NN_SUPPORT_CONV_1D:1;
   uint32_t USE_VIPSRAM_FOR_KERNEL_STREAMING:1;
   uint32_t NN_SUPPORT_DUMMY_TILE:1;
   uint32_t NN_SUPPORT_KERNEL_1BYTE_ALIGN:1;
   uint32_t NN_1x1_NON_POOLING_PACKING:1;
   uint32_t NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING:1;
   uint32_t NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2:1;
   uint32_t TP_REMOVE_FC:1;
   uint32_t VIP_REMOVE_MMU:1;
   uint32_t NN_MP_INTER_CONNECT_RING:1;
   uint32_t NN_SUPPORT_BATCH:1;
   uint32_t NN_2D_AVERAGE_OUTPUT:1;
   uint32_t NN_JOB_CANCELATION:1;
   uint32_t NN_DISTRIBUTED_VIPSRAM:1;
   uint32_t NN_FC_ENHANCEMENT:1;
   uint32_t VIP_DEC400:1;
   uint32_t NN_PER3DTILE_BUBBLE_FIX:1;
   uint32_t NN_CACHELINE_MODE_PERF_FIX:1;
   uint32_t NN_CONV1x1_PERF_FIX:1;
   uint32_t TP_REORDER_FIX:1;
   uint32_t NN_CONVOUT_FIFO_DEPTH_FIX:1;
   uint32_t NN_ZXDP3_KERNEL_READ_CONFLICT_FIX:1;
   uint32_t NN_ZDP3_NO_COMPRESS_FIX:1;
   uint32_t NN_ASYNC_COPY_PERF_FIX:1;
   uint32_t HI_REORDER_FIX:1;
   uint32_t INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX:1;
   uint32_t TP_REORDER_LAYER_SUSPEND_FIX:1;
   uint32_t NN_ASYNC_COPY_MERGE_FIX:1;
   uint32_t USC_INVALIDATE_CACHE_LINE_FIX:1;
   uint32_t NN_REQ_SLOWARBITRATION_FIX:1;
   uint32_t IMAGE_PARTIAL_CACHE_FIX:1;
   uint32_t FULLCACHE_KERNELHEAD_FIX:1;
   uint32_t NN_ZDP_INIMAGE_SIZE_FIX:1;
   uint32_t IDLE_BEFORE_FLUSH_COMPLETE_FIX:1;
   uint32_t NO_FLUSH_USC_FIX:1;
   uint32_t SMALL_BATCH_FLOPS_RESET_FIX:1;
   uint32_t SMALL_BATCH_DISBLE_FIX:1;
   uint32_t OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX:1;
   uint32_t IMAGE_NOT_PACKED_IN_SRAM_FIX:1;
   uint32_t COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX:1;
   uint32_t USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX:1;
   uint32_t LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX:1;
   uint32_t KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX:1;
   uint32_t USC_BOTTLENECK_FIX:1;
   uint32_t KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX:1;
   uint32_t NN_TILE_NUM_BIGGER_THAN_1024_FIX:1;
   uint32_t KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX:1;
   uint32_t NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX:1;
   uint32_t TP_REORDER_INTILE_X_SIZE_512_FIX:1;
   uint32_t IMG_POP_PIPELINE_PAUSE_FIX:1;
   uint32_t FULLCACHE_KERNEL_INTERLEAVE_FIX:1;
   uint32_t V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX:1;
   uint32_t V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX:1;
   uint32_t DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX:1;
   uint32_t DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX:1;
   uint32_t TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX:1;
   uint32_t EVIS2_FLOP_RESET_FIX:1;
   uint32_t OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX:1;
   uint32_t USC_ASYNC_CP_RTN_FLOP_RESET_FIX:1;
   uint32_t IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX:1;
   uint32_t NEGATIVE_POST_SHIFT_FIX:1;
   uint32_t INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX:1;
   uint32_t IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX:1;
   uint32_t BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX:1;
   uint32_t INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX:1;
   uint32_t TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX:1;
   uint32_t NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX:1;
   uint32_t NN_IN_TILE_DATA_IS_ALL_PAD_FIX:1;
   uint32_t NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX:1;
   uint32_t CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX:1;
   uint32_t TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX:1;
   uint32_t NN_KERNEL_1x1_NO_PAD_FIX:1;
   uint32_t NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX:1;
   uint32_t TP_NOT_FULL_USE_CACHE_LINE_FIX:1;
   uint32_t SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX:1;
   uint32_t BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX:1;
   uint32_t TP_ASSYM_INT8_FIX:1;
   uint32_t NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX:1;
   uint32_t NN_2ND_IMG_BASE_ADDR_FIX:1;
   uint32_t NN_TP_SYSTEM_FIX:1;
   uint32_t NN_INTILE_YSIZE_128_LIMIT_FIX:1;
   uint32_t SH_CLOCK_GATOR_IDLE_CONDITON_FIX:1;
   uint32_t NN_BURST_COLLECTER_LAST_FLAG_FIX:1;
   uint32_t NN_2ND_IMG_SMALL_3D_TILE_FIX:1;
   uint32_t NN_TILE_YSIZE_127_LIMITATION_FIX:1;
   uint32_t NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX:1;
   uint32_t NN_VIPSRAM_DOUBLE_BUFFER_FIX:1;
   uint32_t NN_JD_DIRECT_MODE_FIX:1;
   uint32_t NN_KERNEL_DIRECT_WRONG_PUSH_FIX:1;
   uint32_t HI_DEFAULT_ENABLE_REORDER_FIX:1;
   uint32_t V83_INTILESIZE_1X1_10BITS_FIX:1;
   uint32_t NN_INTERLEVE8:1;
   uint32_t NN_FP16_ALU:1;
   uint32_t NN_INT16_ALU:1;
   uint32_t NN_INT8_SCALE:1;
   uint32_t NN_POWER_ISOLATION:1;
   uint32_t ZRL_7BIT:1;
   uint32_t NN_SMALLBATCH:1;
   uint32_t TP_SMALLBATCH:1;
   uint32_t ZRL_8BIT:1;
   uint32_t DDR_BURST_LEN_256B:1;
   uint32_t XY_OFFSET_LIMITATION_FIX:1;
   uint32_t NN_NONZERO_MIRROR_BORDER:1;
   uint32_t IMAGE_PARTIAL_CACHE:1;
   uint32_t VIRTUAL_ADDRESS_BITS;
   uint32_t PHYSICAL_ADDRESS_BITS;
   uint32_t G2D_TILING_MINOR;
   uint32_t PS_INPUT_COMPONENTS;
   uint32_t AIGM_MAX_SIZE;
   uint32_t NNCoreCount_UINT16;
   uint32_t VIP_SRAM_SIZE_ARRAY[9];
   uint32_t LUT_ACT_LANES;
   uint32_t MIN_AXI_BURST_SIZE;
   uint32_t OUTIMAGE_SLICE_BITS;
   uint32_t INIMAGE_SLICE_BITS;
   uint32_t NN_SMALL_ACCUM_BITS;
   uint32_t NN_COEF_DECOMPRESS_PERF_X;
   uint32_t SP_VECTOR_DEPTH;
   uint32_t VIPSRAM_CLK_DOMAIN_RATIO_PERCENT;
   uint32_t VIP_VERSION;
   uint32_t NN_COMMAND_BUFFER_SIZE;
   uint32_t DECOMP_VZ_GROUP_BITS;
   uint32_t NN_LOOP1_DP_NUMBER;
   uint32_t AXIFE:1;
   uint32_t PE_64BPP_LINEAR_FORMAT:1;
   uint32_t HIGHP_VEC2:1;
   uint32_t MMU_PD_42_BIT_ADDRESS:1;
   uint32_t BLT_ROBUSTNESS_FIX:1;
   uint32_t BLT_OUT_OF_BOUND_FIX:1;
   uint32_t TFB_PERF_FIX:1;
   uint32_t SH_SUPERSCALAR_ARCH:1;
   uint32_t PA_ZEROAREA_LINE_FIX:1;
   uint32_t RS_TILER_YUV420_FIX:1;
   uint32_t ATTR_IN_GLOBAL_MEMORY:1;
   uint32_t SIMPLIFIED_CHECKERBOARD:1;
   uint32_t ADDR_REMAP:1;
   uint32_t ADDR_40BIT_OVERFLOW_FIX:1;
   uint32_t CLIP_DISTANCE_SUPPORT:1;
   uint32_t SEPARATED_TEXTURE_SAMPLER:1;
   uint32_t TS_INFO_IN_TX_DESCRIPTOR:1;
   uint32_t PER_STAGE_LOCAL_STORAGE:1;
   uint32_t DX11_FORMAT_SUPPORT:1;
   uint32_t OCCLUSION_SAMPLE_COUNTER:1;
   uint32_t FRONT_FACE_UINT:1;
   uint32_t DYNAMIC_TEXTURE_INDEXING:1;
   uint32_t D3D11_SUPPORT:1;
   uint32_t MMU_40BIT_VA_FIX:1;
   uint32_t MMU_40BIT_VA_GRAPHICS:1;
   uint32_t ONE_OUTPUT_COMPOENT_FOR_MFU:1;
   uint32_t SH_64BIT_VA_ENHANCEMENT:1;
   uint32_t DX11_SH_RCP_SQRT_PRECISSION:1;
   uint32_t TILED_RESOURCE:1;
   uint32_t SH_FP64:1;
   uint32_t SH_SM6:1;
   uint32_t VGPU:1;
   uint32_t DEC_NANO:1;
   uint32_t SH_64BIT_ROBUST_CHECK:1;
   uint32_t G2D_RGB_PLANAR_SOURCE:1;
   uint32_t G2D_FC_IN_DEC400EX:1;
   uint32_t G2D_MultiSrcBlt_Pipe:1;
   uint32_t G2D_Stretch_MultiSrc_Pipe:1;
   uint32_t G2D_Normalization:1;
   uint32_t G2D_Normalization_Quantization:1;
   uint32_t G2D_FRAME_DONE_INTR:1;
   uint32_t G2D_MASK_AND_COLORKEY:1;
   uint32_t G2D_Histogram:1;
   uint32_t G2D_Brightness_Saturation:1;
   uint32_t NN_ZDP9:1;
   uint32_t HW_V83:1;
   uint32_t NN_CMD_SUPPORT_SLICE:1;
   uint32_t NN_RD_IMG_NEED_EXTRA_SPACE:1;
   uint32_t VIP_INDIV_CLK_NN:1;
   uint32_t VIP_EXPORT_CLK_DIV2:1;
   uint32_t NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE:1;
   uint32_t VIP_SUPPORT_DEC:1;
   uint32_t NN_SUPPORT_MULTI_AXI_ID:1;
   uint32_t NN_POST_OUT_SUPPORT_INT32:1;
   uint32_t NN_4BIT_PHASE1:1;
   uint32_t NN_POST_MULT_SUPPORT_FP_CONV:1;
   uint32_t NN_SUPPORT_16_8_QUANTIZATION:1;
   uint32_t SPECIAL_8BIT_SIGN_ABS_CONV:1;
   uint32_t NN_SUPPORT_CONFIGURABLE_FASTXDP3:1;
   uint32_t NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING:1;
   uint32_t SUPPORT_DECONVNxN_S_LESS_THAN_16:1;
   uint32_t NN_PICOCORE_DEPTHWISE:1;
   uint32_t VIP_SUPPORT_TENSOR_TRANSFER:1;
   uint32_t NN_SUPPORT_CMD_LOOP:1;
   uint32_t VIP_SUPPORT_X_FRAME_COMPRESSION:1;
   uint32_t NN_SMALL_ACCUM:1;
   uint32_t NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM:1;
   uint32_t POST_MULTIPLIER_LOW_POWER_MODE:1;
   uint32_t NN_SUPPORT_EFUSE:1;
   uint32_t NN_SUPPORT_STREAMPROCESSOR:1;
   uint32_t NN_SUPPORT_GEMM_PHASE1:1;
   uint32_t NN_SUPPORT_CLAMP_BORDER_MODE:1;
   uint32_t NN_ELEMENTWISE_BROADCAST_STRIDE_X_0:1;
   uint32_t NN_2ND_IMAGE_DATA_TYPE:1;
   uint32_t FP_INIMAGE_POST_SCALE:1;
   uint32_t NN_INT16_TENSOR_ADD:1;
   uint32_t NN_TENSOR_ADD_DOUBLE_PIPELINE:1;
   uint32_t TENSOR_DMA:1;
   uint32_t NN_SPLIT_X_AMONG_CLUSTER:1;
   uint32_t NN_SUPPORT_ZDP_LOOP6:1;
   uint32_t NN_FP8_PHASE1:1;
   uint32_t NN_SUPPORT_FUSA:1;
   uint32_t NN_OUTPUT_OVERFLOW_MODE:1;
   uint32_t NN_DEPTHWISE_ENHANCEMENT:1;
   uint32_t NN_CONV_1X1_ENHANCEMENT:1;
   uint32_t SUPPORT_DYNAMIC_SHAPE:1;
   uint32_t SUPPORT_BATCH_ALIGNMENT:1;
   uint32_t NN_SUPPORT_GEMM_PHASE2:1;
   uint32_t SRAM_PARITY:1;
   uint32_t NNCMD_AXIID_OFFSET:1;
   uint32_t TC_SHADER_TRIGGER_NN:1;
   uint32_t TC_PROBE_COUNTER:1;
   uint32_t NN_TILE_BRICK_MODE:1;
   uint32_t NN_4BIT_COEF_PACKED_MODE:1;
   uint32_t NN_BF16_I4_I8_QUANTIZATION:1;
   uint32_t NN_HIGH_PERF_DECODE_SPLIT_STAGE:1;
   uint32_t NN_POST_PROCESSOR_FL32:1;
   uint32_t NN_HIGH_PERF_DECODER:1;
   uint32_t NN_GROUP_QUANT_PHASE1:1;
   uint32_t SH_CONFORMANCE_BRUTEFORCE_FIX:1;
   uint32_t V83_CONVERTER_FOR_NEG_0_FIX:1;
   uint32_t V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX:1;
   uint32_t FASTXDP3_ONLY_IN_DEPTHWISE_FIX:1;
   uint32_t US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX:1;
   uint32_t USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX:1;
   uint32_t DEPTHWISE_FLOAT_FIX:1;
   uint32_t TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX:1;
   uint32_t NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX:1;
   uint32_t CLOCK_DIV2_FREQ_CHANGE_FIX:1;
   uint32_t SMALL_TILE_TENSOR_ADD_FIX:1;
   uint32_t DECOMPRESSOR_DEPTHWISE_FLOAT_FIX:1;
   uint32_t TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX:1;
   uint32_t V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX:1;
   uint32_t V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX:1;
   uint32_t V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX:1;
   uint32_t USC_RW_SAME_CACHELINE_UPDATE_FIX:1;
   uint32_t NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX:1;
   uint32_t CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX:1;
   uint32_t KERNEL_XSIZE_YSIZE_NUM_FIX:1;
   uint32_t IMGRD_ROW_NUMBER_FIX:1;
   uint32_t NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX:1;
   uint32_t NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX:1;
   uint32_t NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX:1;
   uint32_t WRSPLIT_NOT_SUPPORT_PROBE_FIX:1;
   uint32_t TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX:1;
   uint32_t TP_SPECIAL_LIST_PARSER_FIX:1;
   uint32_t DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX:1;
   uint32_t DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX:1;
   uint32_t TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX:1;
   uint32_t SECONDIMG_TILE_SIDEBANFIFO_FIX:1;
   uint32_t TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX:1;
   uint32_t WRITE_STRIDE2_DUMMY_FIX:1;
   uint32_t TRSP2_WORDSIZE_BIGGER_FIX:1;
   uint32_t BURSTCOLLECTOR_ADDR_UPDATE_FIX:1;
   uint32_t TRSB2_SMALL_BATCH_UPDATE_FIX:1;
   uint32_t NN_NT_SMALLBATCH_TRNSFER_INIT_FIX:1;
   uint32_t IMGRD_FIRST_ROW_SMALL_SLICE_FIX:1;
   uint32_t KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX:1;
   uint32_t MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX:1;
   uint32_t MULTI_AXI_ID_IMG_KERNEL_SAME_FIX:1;
   uint32_t TRSP2_CONV_SMALLBATCH_FIX:1;
   uint32_t DEPTHTOSPACE_SAME_XY_FIX:1;
   uint32_t VZ_GROUP_START_Z_OVERFLOW_FIX:1;
   uint32_t V82_STREAMMODE_VIPSRAM_ADDRESS_FIX:1;
   uint32_t GEMM_NO_SUPPORT_SMALLBATCH_FIX:1;
   uint32_t SBP1_KHEAD_CMDSIZE_FIX:1;
   uint32_t PERF_BURSTCOLLECTOR_MAXSIZE_FIX:1;
   uint32_t PERF_KERNEL_DESCRIPTOR_SOURCE_FIX:1;
   uint32_t SP_NOIN_IMGRD_DUMMY_FIX:1;
   uint32_t NN_4BIT_PERF_EVEN_TILEXSIZE_FIX:1;
   uint32_t STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX:1;
   uint32_t MULTI_ID_DIRECTMODE_CHANGE_FIX:1;
   uint32_t PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX:1;
   uint32_t FIRST_SECOND_IMG_SAME_ID_FIX:1;
   uint32_t TILESIZE_LIMITATION_CORE_BYPASS_FIX:1;
   uint32_t SH_BARRIER_EXECUTION_FIX:1;
   uint32_t FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX:1;
   uint32_t GPU_AXI_BUS_WIDTH;
   uint32_t NumDPPUsPerCluster;
   uint32_t NN_ZRL_VALID_ZERO_NUMBER;
   uint32_t NN_KERNEL_FIFO_IN_WIDTH;
   uint32_t SH_INSTR_DENORM_SUPPORT:1;
   uint32_t SH_GA_SUPPORT:1;
   uint32_t NN_SH_IN_PARALLEL:1;
   uint32_t NN_ASYNC_DMA:1;
   uint32_t NN_STRIDE2_FAST_XDP3:1;
   uint32_t NN_2V4_STRUCTURED_SPARSITY:1;
   uint32_t NN_SP_ENHANCEMENT:1;
   uint32_t NN_SUPPORT_SEPARATE_STREAMBUF_ADDR:1;
   uint32_t NN_TF32_MAC:1;
   uint32_t NN_SP_FP28_PRECISION:1;
   uint32_t NN_VIPSRAM_SHARE_AMONG_CLUSTERS:1;
   uint32_t NN_SUPPORT_UNIQUE_ID:1;
   uint32_t NN_FAST_VIPSRAM:1;
   uint32_t NN_MOVE_DECOMPRESSOR_OUT_OF_CORE:1;
   uint32_t NN_SPLITKZ_REDUCE_SUM:1;
   uint32_t NN_SUPPORT_FFD:1;
   uint32_t NN_SUPPORT_FP8_DOUBLE_MAC:1;
   uint32_t NN_SUPPORT_DENORM:1;
   uint32_t NN_SUPPORT_POST_OP_FUSE:1;
   uint32_t T3D_SYNC_DMA:1;
   uint32_t NN_GENERIC_DMA:1;
   uint32_t NN_DOUBLE_CONV_OUT:1;
   uint32_t CMD_LOOP_STATE_LOAD_SAVE:1;
   uint32_t DYNAMIC_ACTIVATION_SCALE:1;
   uint32_t FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX:1;
   uint32_t FIX_MATRIX_A_TRSP1_CHNUM_FIX:1;
   uint32_t FIX_4BIT_SBP2_BLOCKCTRL2_FIX:1;
   uint32_t B2B_RETRUN_NN_CMD_DONE_FIX:1;
   uint32_t MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX:1;
   uint32_t TRSP2_SPECIAL_WORDSIZE_FIX:1;
   uint32_t FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX:1;
   uint32_t NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX:1;
   uint32_t MULTIAXIID_TBUF_STALL_READY_FIX:1;
   uint32_t V940_TILESIZE_1024N_FIX:1;
} gcsFEATURE_DATABASE;

static gcsFEATURE_DATABASE gChipInfo[] = {
   {
      0x9000, /* chipID */
      0x8302, /* chipVersion */
      0x5090009, /* productID */
      0x8000000, /* ecoID */
      0xe8, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x9, /* NNInputBufferDepth */
      0x20, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x100000, /* VIP_SRAM_SIZE */
      0x1, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x5, /* NN_INIMAGE_OFFSET_BITS */
      0x200, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x8, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x20, /* NN_LANES_PER_OUT_CYCLE */
      0x40, /* MAX_OT_NUMBER */
      0x80, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x20, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x8, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xf, /* NN_KERNEL_X_SIZE */
      0xf, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0x1f, /* NN_X_OFFSET */
      0x1f, /* NN_Y_OFFSET */
      0x100, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x10, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x80, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x3, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x1, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x1, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x1, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x1, /* COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* NN_COEF_DECOMPRESS_PERF2X */
      0x1, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x1, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x1, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x1, /* TP_NN_PROBE */
      0x1, /* NN_DEPTHWISE_SUPPORT */
      0x1, /* NN_XYDP0 */
      0x1, /* NN_WRITE_WITHOUT_USC */
      0x1, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x1, /* NN_SMALLBATCH_PHASE1 */
      0x1, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x1, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x1, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x1, /* USE_SINGLE_PORT_VIPSRAM */
      0x1, /* NN_LEAKY_RELU */
      0x1, /* NN_PRELU */
      0x1, /* NN_PER_CHANNEL_QUANT */
      0x1, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x1, /* NN_ASYMMETRIC_INT8 */
      0x1, /* NN_FLOAT_POST_MULT */
      0x1, /* PRELU_LEAKLY_RELU_CLAMP */
      0x1, /* TPLITE_BFLOAT16 */
      0x1, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x1, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x1, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x1, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x1, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x1, /* NN_NATIVE_STRIDE_TWO */
      0x1, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x1, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x1, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x1, /* NN_SUPPORT_CONV_1D */
      0x1, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x1, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x1, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x1, /* NN_PER3DTILE_BUBBLE_FIX */
      0x1, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x1, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x1, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x1, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x1, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x1, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x1, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x1, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x1, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x1, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x1, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x1, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x1, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x1, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x1, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x1, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x1, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x1, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x1, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x1, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x1, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x1, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x1, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x1, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x1, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x1, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x1, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x1, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x1, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x1, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x8000, /* chipID */
      0x7004, /* chipVersion */
      0x45080009, /* productID */
      0x0, /* ecoID */
      0x7d, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0xc, /* NNInputBufferDepth */
      0x40, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x80000, /* VIP_SRAM_SIZE */
      0x4, /* TPEngine_CoreCount */
      0x100000, /* AXI_SRAM_SIZE */
      0x3, /* NN_INIMAGE_OFFSET_BITS */
      0x180, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x8, /* NN_LANES_PER_OUT_CYCLE */
      0x20, /* MAX_OT_NUMBER */
      0x20, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x10, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x5, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xb, /* NN_KERNEL_X_SIZE */
      0xb, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0x7, /* NN_X_OFFSET */
      0x7, /* NN_Y_OFFSET */
      0x40, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x1, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x1, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x1, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x1, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x1, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x1, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x1, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x1, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x8000, /* chipID */
      0x7004, /* chipVersion */
      0x45080009, /* productID */
      0x1, /* ecoID */
      0x7d, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0xc, /* NNInputBufferDepth */
      0x40, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x80000, /* VIP_SRAM_SIZE */
      0x4, /* TPEngine_CoreCount */
      0x100000, /* AXI_SRAM_SIZE */
      0x3, /* NN_INIMAGE_OFFSET_BITS */
      0x180, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x8, /* NN_LANES_PER_OUT_CYCLE */
      0x20, /* MAX_OT_NUMBER */
      0x20, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x10, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x5, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xb, /* NN_KERNEL_X_SIZE */
      0xb, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0x7, /* NN_X_OFFSET */
      0x7, /* NN_Y_OFFSET */
      0x40, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x1, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x1, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x1, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x1, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x1, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x1, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x1, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x1, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x8000, /* chipID */
      0x7120, /* chipVersion */
      0x45080009, /* productID */
      0x0, /* ecoID */
      0x88, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0xc, /* NNInputBufferDepth */
      0x40, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x80000, /* VIP_SRAM_SIZE */
      0x4, /* TPEngine_CoreCount */
      0x100000, /* AXI_SRAM_SIZE */
      0x4, /* NN_INIMAGE_OFFSET_BITS */
      0x180, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x8, /* NN_LANES_PER_OUT_CYCLE */
      0x20, /* MAX_OT_NUMBER */
      0x20, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x10, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x5, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xb, /* NN_KERNEL_X_SIZE */
      0xb, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0xf, /* NN_X_OFFSET */
      0xf, /* NN_Y_OFFSET */
      0x40, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x1, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x1, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x1, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x1, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x1, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x1, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x1, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x9000, /* chipID */
      0x8101, /* chipVersion */
      0x5090009, /* productID */
      0x4000000, /* ecoID */
      0xb9, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x1, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x4, /* NNCoreCount */
      0x4, /* NN_ACTIVE_CORE_COUNT */
      0x4, /* NNCoreCount_INT8 */
      0x4, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x9, /* NNInputBufferDepth */
      0x20, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x80000, /* VIP_SRAM_SIZE */
      0x1, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x5, /* NN_INIMAGE_OFFSET_BITS */
      0x200, /* TP_REORDER_INIMAGE_SIZE */
      0x7, /* TPLite_CoreCount */
      0x8, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x10, /* NN_LANES_PER_OUT_CYCLE */
      0x40, /* MAX_OT_NUMBER */
      0x40, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x10, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x8, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xf, /* NN_KERNEL_X_SIZE */
      0xf, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0x1f, /* NN_X_OFFSET */
      0x1f, /* NN_Y_OFFSET */
      0x100, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x10, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x3, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x1, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x1, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x1, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x1, /* COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* NN_COEF_DECOMPRESS_PERF2X */
      0x1, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x1, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x1, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x1, /* TP_NN_PROBE */
      0x1, /* NN_DEPTHWISE_SUPPORT */
      0x1, /* NN_XYDP0 */
      0x1, /* NN_WRITE_WITHOUT_USC */
      0x1, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x1, /* NN_SMALLBATCH_PHASE1 */
      0x1, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x1, /* NN_TRANSPOSE */
      0x1, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x1, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x1, /* NN_PER3DTILE_BUBBLE_FIX */
      0x1, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x1, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x1, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x1, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x1, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x1, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x1, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x1, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x1, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x1, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x1, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x1, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x1, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x1, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x1, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x1, /* ZRL_8BIT */
      0x1, /* DDR_BURST_LEN_256B */
      0x1, /* XY_OFFSET_LIMITATION_FIX */
      0x1, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x9000, /* chipID */
      0x8102, /* chipVersion */
      0x5090009, /* productID */
      0x8000000, /* ecoID */
      0xbe, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x1, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x9, /* NNInputBufferDepth */
      0x20, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x100000, /* VIP_SRAM_SIZE */
      0x3, /* TPEngine_CoreCount */
      0x3e000, /* AXI_SRAM_SIZE */
      0x5, /* NN_INIMAGE_OFFSET_BITS */
      0x200, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x8, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x10, /* NN_LANES_PER_OUT_CYCLE */
      0x40, /* MAX_OT_NUMBER */
      0x40, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x10, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x8, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xf, /* NN_KERNEL_X_SIZE */
      0xf, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0x1f, /* NN_X_OFFSET */
      0x1f, /* NN_Y_OFFSET */
      0x100, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x10, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x3, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x1, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x1, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x1, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x1, /* COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* NN_COEF_DECOMPRESS_PERF2X */
      0x1, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x1, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x1, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x1, /* TP_NN_PROBE */
      0x1, /* NN_DEPTHWISE_SUPPORT */
      0x1, /* NN_XYDP0 */
      0x1, /* NN_WRITE_WITHOUT_USC */
      0x1, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x1, /* NN_SMALLBATCH_PHASE1 */
      0x1, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x1, /* NN_TRANSPOSE */
      0x1, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x1, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x1, /* NN_PER3DTILE_BUBBLE_FIX */
      0x1, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x1, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x1, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x1, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x1, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x1, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x1, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x1, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x1, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x1, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x1, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x1, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x1, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x1, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x1, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x1, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x1, /* ZRL_8BIT */
      0x1, /* DDR_BURST_LEN_256B */
      0x1, /* XY_OFFSET_LIMITATION_FIX */
      0x1, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x8000, /* chipID */
      0x7131, /* chipVersion */
      0x5000009, /* productID */
      0x8000000, /* ecoID */
      0xa1, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x8, /* NNCoreCount */
      0x8, /* NN_ACTIVE_CORE_COUNT */
      0x8, /* NNCoreCount_INT8 */
      0x8, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0xc, /* NNInputBufferDepth */
      0x40, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x100000, /* VIP_SRAM_SIZE */
      0x6, /* TPEngine_CoreCount */
      0x43f000, /* AXI_SRAM_SIZE */
      0x4, /* NN_INIMAGE_OFFSET_BITS */
      0x180, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x8, /* NN_LANES_PER_OUT_CYCLE */
      0x20, /* MAX_OT_NUMBER */
      0x40, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x20, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x8, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xb, /* NN_KERNEL_X_SIZE */
      0xb, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0xf, /* NN_X_OFFSET */
      0xf, /* NN_Y_OFFSET */
      0x40, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x1, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x1, /* NN_XYDP6 */
      0x1, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x1, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x1, /* NN_COEF_DECOMPRESS_PERF2X */
      0x1, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x1, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x1, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x1, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x1, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x1, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x1, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x1, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x1, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x1, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x1, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x1, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x1, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x1, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x1, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x1, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x8000, /* chipID */
      0x7131, /* chipVersion */
      0x8000001, /* productID */
      0x2000000, /* ecoID */
      0x99, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x2, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x2, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x0, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x40, /* NNMadPerCore */
      0x2, /* NNCoreCount */
      0x2, /* NN_ACTIVE_CORE_COUNT */
      0x2, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x6, /* NNInputBufferDepth */
      0x40, /* NNAccumBufferDepth */
      0x400, /* TPEngine_PwlLUTCount */
      0x10, /* TPEngine_PwlLUTSize */
      0x80000, /* VIP_SRAM_SIZE */
      0x1, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x4, /* NN_INIMAGE_OFFSET_BITS */
      0x180, /* TP_REORDER_INIMAGE_SIZE */
      0x7, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x1, /* NNFP16_XYDP_X */
      0x1, /* NNFP16_XYDP_Y */
      0x1, /* NNFP16_ZDP */
      0x8, /* NN_LANES_PER_OUT_CYCLE */
      0x20, /* MAX_OT_NUMBER */
      0x40, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x20, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x8, /* TP_ZRL_BITS */
      0x8, /* NN_ZRL_BITS */
      0x80, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x10, /* AXI_BUS_WIDTH */
      0xb, /* NN_KERNEL_X_SIZE */
      0xb, /* NN_KERNEL_Y_SIZE */
      0xf, /* NN_FC_KERNEL_Y_SIZE */
      0xfffff, /* NN_KERNEL_Z_SIZE */
      0xf, /* NN_X_OFFSET */
      0xf, /* NN_Y_OFFSET */
      0x40, /* DDR_KERNEL_BURST_SIZE */
      0x10, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x10, /* INIMAGE_X_STRIDE_BITS */
      0x10, /* IMIMAGE_Y_STRIDE_BITS */
      0xd, /* OUTIMAGE_X_SIZE_BITS */
      0xd, /* OUTIMAGE_Y_SIZE_BITS */
      0xe, /* OUTIMAGE_Z_SIZE_BITS */
      0xd, /* INIMAGE_X_SIZE_BITS */
      0xd, /* INIMAGE_Y_SIZE_BITS */
      0x40, /* MAX_TILE_X_SIZE */
      0x1, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x1, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x1, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x1, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x1, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x1, /* VIP_HW_FINAL_RELEASE */
      0x1, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x1, /* NN_STRIDE_SUPPORT */
      0x1, /* SWTILING_PHASE1 */
      0x1, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x1, /* TP_REAL_INT16 */
      0x1, /* TP_ROI_POOLING */
      0x1, /* TP_MAX_POOLING_STRIDE1 */
      0x1, /* TP_LRN */
      0x1, /* TP_REORDER */
      0x1, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x1, /* TP_ENGINE */
      0x1, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x1, /* NN_FIRST_PIXEL_POOLING */
      0x1, /* NN_ZDP3 */
      0x1, /* NN_XYDP6 */
      0x1, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x1, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x1, /* TP_SMALLBATCH_PHASE1 */
      0x1, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x1, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x1, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x1, /* NN_CONV1x1_PERF_FIX */
      0x1, /* TP_REORDER_FIX */
      0x1, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x1, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x1, /* NN_ASYNC_COPY_PERF_FIX */
      0x1, /* HI_REORDER_FIX */
      0x1, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x1, /* NN_ASYNC_COPY_MERGE_FIX */
      0x1, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x1, /* NO_FLUSH_USC_FIX */
      0x1, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x1, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x1, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x1, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x1, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x1, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x1, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x1, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x1, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x1, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x1, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x1, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x1, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x1, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x1, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x1, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x1, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x1, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x0, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x0, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x1, /* TP_ASSYM_INT8_FIX */
      0x1, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x1, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x1, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x1, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x1, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x1, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x1, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x1, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x1, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x1, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x1, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x1, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x1, /* NN_INT8_SCALE */
      0x1, /* NN_POWER_ISOLATION */
      0x1, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x1, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x0, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x0, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x320, /* chipID */
      0x5007, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x400, /* ThreadCount */
      0x4, /* NumShaderCores */
      0x100, /* InstructionCount */
      0x100, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x8, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x1, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x1, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x0, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x0, /* REG_ResolveOffset */
      0x0, /* REG_OkToGateAxiClock */
      0x0, /* REG_MMU */
      0x0, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x0, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x0, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x0, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x0, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x0, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x0, /* REG_DecompressZ16 */
      0x0, /* REG_BugFixes8 */
      0x0, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x0, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x320, /* chipID */
      0x5303, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x1, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x1, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x1, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x1, /* REG_MultiSourceBlt */
      0x1, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x1, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x1, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x320, /* chipID */
      0x5341, /* chipVersion */
      0x3202, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x1, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x1, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x1, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x1, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x1, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x1, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x1, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x355, /* chipID */
      0x1215, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x1, /* REG_Mem32BitSupport */
      0x1, /* REG_PipeVG */
      0x1, /* REG_VGTS */
      0x1, /* REG_FE20 */
      0x0, /* REG_ByteWrite3D */
      0x0, /* REG_RsYuvTarget */
      0x0, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x0, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x0, /* REG_Render8K */
      0x0, /* REG_TileStatus2Bits */
      0x0, /* REG_SeparateTileStatusWhenInterleaved */
      0x0, /* REG_SuperTiled32x32 */
      0x1, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x0, /* REG_CompressionFifoFixed */
      0x0, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x1, /* REG_VG21 */
      0x0, /* REG_ShaderGetsW */
      0x0, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x0, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x0, /* REG_CorrectStencil */
      0x0, /* REG_EnhanceVR */
      0x0, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x1, /* REG_VGDoubleBuffer */
      0x0, /* REG_BugFixes1 */
      0x0, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x0, /* REG_BugFixes3 */
      0x0, /* REG_CorrectAutoDisable1 */
      0x1, /* REG_AutoRestartTS */
      0x0, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x0, /* REG_PixelDither */
      0x0, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x0, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x0, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x0, /* REG_NewFloatingPointArithmetic */
      0x0, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x0, /* REG_NegativeLogFix */
      0x0, /* REG_ResolveOffset */
      0x0, /* REG_OkToGateAxiClock */
      0x0, /* REG_MMU */
      0x0, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x0, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x0, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x0, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x0, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x0, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x0, /* REG_DecompressZ16 */
      0x0, /* REG_BugFixes8 */
      0x0, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x0, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x400, /* chipID */
      0x4645, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x4, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x80, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0x240, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x4, /* Streams */
      0x8, /* VaryingCount */
      0x80, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x0, /* REG_FastScaler */
      0x0, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x1, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x1, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x0, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x1, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x0, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x0, /* REG_BugFixes3 */
      0x0, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x0, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x0, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x0, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x1, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x520, /* chipID */
      0x5341, /* chipVersion */
      0x5202, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x1, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x1, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x1, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x1, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x1, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x1, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x1, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x520, /* chipID */
      0x5341, /* chipVersion */
      0x5202, /* productID */
      0x0, /* ecoID */
      0x204, /* customerID */
      0x3, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x1, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x0, /* REG_FastClear */
      0x1, /* REG_SpecialAntiAliasing */
      0x0, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x1, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x1, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x1, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x1, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x1, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x1, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x1, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x1, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x1, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x1, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x1, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x1, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x1, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x1, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x600, /* chipID */
      0x4653, /* chipVersion */
      0x70005, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x1, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x4, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x0, /* REG_FastScaler */
      0x0, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x1, /* REG_MinArea */
      0x1, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x1, /* REG_HalfPECache */
      0x1, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x0, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x1, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x0, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x0, /* REG_BugFixes3 */
      0x0, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x0, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x1, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x0, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x1, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x600, /* chipID */
      0x4653, /* chipVersion */
      0x70005, /* productID */
      0x0, /* ecoID */
      0x102, /* customerID */
      0x5, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x100, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x4, /* Streams */
      0x8, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x0, /* REG_FastScaler */
      0x0, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x1, /* REG_MinArea */
      0x1, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x1, /* REG_HalfPECache */
      0x1, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x0, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x1, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x0, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x0, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x1, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x0, /* REG_BugFixes3 */
      0x0, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x0, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x0, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x0, /* REG_NonPowerOfTwo */
      0x0, /* REG_LinearTextureSupport */
      0x0, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x1, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x0, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x880, /* chipID */
      0x5106, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x100, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x100, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x0, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x0, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0xb, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x8, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x0, /* REG_FastScaler */
      0x0, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x1, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x0, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x0, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x0, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x0, /* REG_DecompressZ16 */
      0x0, /* REG_BugFixes8 */
      0x0, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x0, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x2000, /* chipID */
      0x5108, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x400, /* ThreadCount */
      0x4, /* NumShaderCores */
      0x200, /* InstructionCount */
      0xa8, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x1, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x4, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x0, /* InstructionMemorySize */
      0x0, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0xb, /* VaryingCount */
      0x200, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x0, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x1, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x0, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x0, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x0, /* REG_BugFixes6 */
      0x0, /* REG_FcFlushStall */
      0x0, /* REG_LineLoop */
      0x0, /* REG_LogicOp */
      0x0, /* REG_SeamlessCubeMap */
      0x0, /* REG_SuperTiledTexture */
      0x0, /* REG_LinearPE */
      0x0, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x0, /* REG_CorrectAutoDisableCountWidth */
      0x0, /* REG_PESwizzle */
      0x0, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x0, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x0, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x0, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x0, /* REG_ThreadWalkerInPS */
      0x0, /* REG_TileFiller */
      0x0, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x0, /* REG_FlushFixed2D */
      0x0, /* REG_Interleaver */
      0x0, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x0, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x0, /* REG_TextureTileStatus */
      0x0, /* REG_DecompressZ16 */
      0x0, /* REG_BugFixes8 */
      0x0, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x0, /* REG_NewFeatures0 */
      0x0, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x0, /* REG_TexCompressionSupertiled */
      0x0, /* REG_Generics */
      0x0, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x0, /* REG_BugFixes10 */
      0x0, /* REG_UnifiedSamplers */
      0x0, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x0, /* REG_ExtraShaderInstructions2 */
      0x0, /* REG_BugFixes12 */
      0x0, /* REG_BugFixes13 */
      0x0, /* REG_DEEnhancements1 */
      0x0, /* REG_ACE */
      0x0, /* REG_TXEnhancements1 */
      0x0, /* REG_SHEnhancements1 */
      0x0, /* REG_SHEnhancements2 */
      0x0, /* REG_PEEnhancements1 */
      0x0, /* REG_DEEnhancements2 */
      0x0, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x0, /* REG_NewHZ */
      0x0, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x0, /* REG_SHEnhancements3 */
      0x0, /* REG_SHEnhancements4 */
      0x0, /* REG_TXEnhancements2 */
      0x0, /* REG_FEEnhancements1 */
      0x0, /* REG_PEEnhancements2 */
      0x0, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x0, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x0, /* REG_TXEnhancements3 */
      0x0, /* REG_SHEnhancements5 */
      0x0, /* REG_FEEnhancements2 */
      0x0, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x0, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x0, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x0, /* REG_SmallMSAA */
      0x0, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x0, /* REG_PAEnhancements3 */
      0x0, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x0, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x0, /* REG_SHEnhancements6 */
      0x0, /* REG_SHEnhancements7 */
      0x0, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x0, /* REG_EEZ */
      0x0, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x0, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x0, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x0, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x2000, /* chipID */
      0xffff5450, /* chipVersion */
      0x0, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x8, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x400, /* ThreadCount */
      0x4, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x1, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x4, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x0, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x0, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x0, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x0, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x0, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x0, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x0, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x0, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x0, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x0, /* REG_TX6bitFrac */
      0x0, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x0, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x0, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x0, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x0, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x0, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x0, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x1, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x0, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x3000, /* chipID */
      0x5514, /* chipVersion */
      0x70002, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x400, /* ThreadCount */
      0x4, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x1, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x4, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x0, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x0, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x0, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x0, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x0, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x0, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x0, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x1, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x0, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x0, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x0, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x0, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x1, /* TX_INTEGER_COORDINATE */
      0x0, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x0, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x0, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x0, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x1, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x1, /* FENCE_32BIT */
      0x0, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6008, /* chipVersion */
      0x70008, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x7, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x800, /* ThreadCount */
      0x8, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x40, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x40, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x40, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x1f, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x1, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x1, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x1, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x1, /* PIPELINE_32_ATTRIBUTES */
      0x1, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x1, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x0, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x0, /* PE_8bpp_DUALPIPE_FIX */
      0x1, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x0, /* USC_ATOMIC_FIX */
      0x0, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x0, /* USC_DEFER_FILL_FIX */
      0x0, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x0, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x1, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6009, /* chipVersion */
      0x70008, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x9, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x800, /* ThreadCount */
      0x8, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x40, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x40, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x40, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x1f, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x1, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x1, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x1, /* REG_BltEngine */
      0x1, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x1, /* PIPELINE_32_ATTRIBUTES */
      0x1, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x1, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x1, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x1, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x1, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6009, /* chipVersion */
      0x70008, /* productID */
      0x1, /* ecoID */
      0x0, /* customerID */
      0x9, /* patchVersion */
      "", /* productName */
      0x1, /* formalRelease */
      0x40, /* TempRegisters */
      0x800, /* ThreadCount */
      0x8, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x40, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x40, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x40, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x2, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x1f, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x2, /* NumResolvePipes */
      0x100, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x1, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x1, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x1, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x1, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x1, /* REG_BltEngine */
      0x1, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x0, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x0, /* PE_32BPC_COLORMASK_FIX */
      0x0, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x1, /* PIPELINE_32_ATTRIBUTES */
      0x1, /* MSAA_SHADING */
      0x0, /* NO_ANISTRO_FILTER */
      0x0, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x1, /* HWTFB */
      0x0, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x0, /* EZHZ_CLOCKGATE_FIX */
      0x0, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x0, /* USC_MCFILL_FIX */
      0x0, /* TPG_TCPERF_FIX */
      0x0, /* USC_MDFIFO_OVERFLOW_FIX */
      0x0, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x1, /* SH_ADVANCED_INSTR */
      0x0, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x0, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x0, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x0, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x0, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x0, /* PE_RGBA16I_FIX */
      0x0, /* BLT_8bpp_256TILE_FC_FIX */
      0x0, /* PE_64bit_FENCE_FIX */
      0x0, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x0, /* FE_32bit_INDEX_FIX */
      0x0, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x0, /* SECURITY */
      0x0, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x0, /* USC_GOS_ADDR_FIX */
      0x0, /* TX_8bit_UVFrac */
      0x0, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x0, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x0, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x1, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x0, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x0, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x1, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x1, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6202, /* chipVersion */
      0x70003, /* productID */
      0x0, /* ecoID */
      0x0, /* customerID */
      0x0, /* patchVersion */
      "", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x200, /* ThreadCount */
      0x2, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x10, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x10, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x10, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x8, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x10, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x1, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x1, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x1, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x1, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x1, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x1, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x0, /* SH_NO_INDEX_CONST_ON_A0 */
      0x0, /* SH_NO_ONECONST_LIMIT */
      0x0, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x0, /* SH_MULTI_WG_PACK */
      0x0, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x0, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x0, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x0, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x0, /* SH_TEXLD_U_FIX */
      0x0, /* MC_FCCACHE_BYTEMASK */
      0x0, /* SH_MULTI_WG_PACK_FIX */
      0x0, /* PE_ADVANCE_BLEND_PART0 */
      0x0, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x0, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x0, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x0, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x1, /* PE_DEPTH_ONLY_OQFIX */
      0x0, /* TX_SEAMLESS_CUBE */
      0x0, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x0, /* PE_TILE_CACHE_FLUSH_FIX */
      0x0, /* BLT_YUV_OUTPUT */
      0x0, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x0, /* SH_ROBUSTNESS_FIX */
      0x0, /* USC_ATOMIC_FIX2 */
      0x0, /* PE_A8B8G8R8 */
      0x0, /* MULTIVIEW_RENDER */
      0x0, /* FE_DRAW_DIRECT */
      0x0, /* TX_VKBORDER_MODE */
      0x0, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x0, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x0, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6205, /* chipVersion */
      0x70007, /* productID */
      0x0, /* ecoID */
      0x12, /* customerID */
      0x0, /* patchVersion */
      "GCNANOULTRA31", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x200, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x8, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x8, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x8, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x10, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x0, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x1, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x1, /* SH_MULTI_WG_PACK */
      0x1, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x1, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x1, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x1, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x1, /* SH_TEXLD_U_FIX */
      0x1, /* MC_FCCACHE_BYTEMASK */
      0x1, /* SH_MULTI_WG_PACK_FIX */
      0x1, /* PE_ADVANCE_BLEND_PART0 */
      0x1, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x1, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x1, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x1, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x1, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x1, /* PE_TILE_CACHE_FLUSH_FIX */
      0x1, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x1, /* SH_ROBUSTNESS_FIX */
      0x1, /* USC_ATOMIC_FIX2 */
      0x1, /* PE_A8B8G8R8 */
      0x1, /* MULTIVIEW_RENDER */
      0x1, /* FE_DRAW_DIRECT */
      0x1, /* TX_VKBORDER_MODE */
      0x1, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x1, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x1, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x1, /* EVIS_NO_ABSDIFF */
      0x1, /* EVIS_NO_BITREPLACE */
      0x1, /* EVIS_NO_BOXFILTER */
      0x1, /* EVIS_NO_CORDIAC */
      0x1, /* EVIS_NO_DP32 */
      0x1, /* EVIS_NO_FILTER */
      0x1, /* EVIS_NO_IADD */
      0x1, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x0, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
      0x0, /* VIP_REMOVE_MMU */
      0x0, /* NN_MP_INTER_CONNECT_RING */
      0x0, /* NN_SUPPORT_BATCH */
      0x0, /* NN_2D_AVERAGE_OUTPUT */
      0x0, /* NN_JOB_CANCELATION */
      0x0, /* NN_DISTRIBUTED_VIPSRAM */
      0x0, /* NN_FC_ENHANCEMENT */
      0x0, /* VIP_DEC400 */
      0x0, /* NN_PER3DTILE_BUBBLE_FIX */
      0x0, /* NN_CACHELINE_MODE_PERF_FIX */
      0x0, /* NN_CONV1x1_PERF_FIX */
      0x0, /* TP_REORDER_FIX */
      0x0, /* NN_CONVOUT_FIFO_DEPTH_FIX */
      0x0, /* NN_ZXDP3_KERNEL_READ_CONFLICT_FIX */
      0x0, /* NN_ZDP3_NO_COMPRESS_FIX */
      0x0, /* NN_ASYNC_COPY_PERF_FIX */
      0x0, /* HI_REORDER_FIX */
      0x0, /* INCORRECT_WR_REQ_TO_USC_BETWEEN_REORDER_AND_NORMAL_LAYER_FIX */
      0x0, /* TP_REORDER_LAYER_SUSPEND_FIX */
      0x0, /* NN_ASYNC_COPY_MERGE_FIX */
      0x0, /* USC_INVALIDATE_CACHE_LINE_FIX */
      0x0, /* NN_REQ_SLOWARBITRATION_FIX */
      0x0, /* IMAGE_PARTIAL_CACHE_FIX */
      0x0, /* FULLCACHE_KERNELHEAD_FIX */
      0x0, /* NN_ZDP_INIMAGE_SIZE_FIX */
      0x0, /* IDLE_BEFORE_FLUSH_COMPLETE_FIX */
      0x0, /* NO_FLUSH_USC_FIX */
      0x0, /* SMALL_BATCH_FLOPS_RESET_FIX */
      0x0, /* SMALL_BATCH_DISBLE_FIX */
      0x0, /* OUTPUT_CONVERT_UINT8_INT8_TO_UINT16_INT16_FIX */
      0x0, /* IMAGE_NOT_PACKED_IN_SRAM_FIX */
      0x0, /* COEF_DELTA_CORD_OVERFLOW_ZRL_8BIT_FIX */
      0x0, /* USC_INDIVIDUAL_PORT_WRT_EARLY_EVICT_DATA_CORRUPT_FIX */
      0x0, /* LOW_EFFICIENCY_OF_ID_WRITE_IMGBUF_FIX */
      0x0, /* KERNEL_VIP_SRAM_READ_BW_LIMITATION_FIX */
      0x0, /* USC_BOTTLENECK_FIX */
      0x0, /* KERNEL_PER_CORE_LESS_THAN_THIRD_COEF_BUFF_DEPTH_FIX */
      0x0, /* NN_TILE_NUM_BIGGER_THAN_1024_FIX */
      0x0, /* KERNEL_SIZE_WASTE_IN_PARTIAL_MODE_FIX */
      0x0, /* NN_COMMAND_KERNEL_REQUEST_CONFICT_FIX */
      0x0, /* TP_REORDER_INTILE_X_SIZE_512_FIX */
      0x0, /* IMG_POP_PIPELINE_PAUSE_FIX */
      0x0, /* FULLCACHE_KERNEL_INTERLEAVE_FIX */
      0x0, /* V8_SINGLE_PORT_ACCUMULATION_BUFFER_RW_CONFICT_ZERO_SKIP_PERF_FIX */
      0x0, /* V8_ACCUMLATION_READ_OUT_HAS_BUBBLES_PERF_FIX */
      0x0, /* DEPTHWISE_NEIGHBOR_IMG_DATA_TRANSFER_NOT_EFFICIENT_FIX */
      0x0, /* DR_JD_DIFF_CONDITION_FOR_CACHELINE_MODE_PRE_FIX */
      0x0, /* TP_ACCESS_VIPSRAM_OT_IS_ONE_FIX */
      0x0, /* EVIS2_FLOP_RESET_FIX */
      0x0, /* OUTIMAGE_X_BITWIDTH_LIMIT_FOR_NN_TRANSPOSE_FIX */
      0x0, /* USC_ASYNC_CP_RTN_FLOP_RESET_FIX */
      0x0, /* IMG_ADDR_NOT_WRAP_IF_OVER_OCB_ADDR_FIX */
      0x0, /* NEGATIVE_POST_SHIFT_FIX */
      0x0, /* INIMAGE_2DTILE_NOT_LESS_160PIXEL_FIX */
      0x0, /* IMG_CAHCE_MODE_MUST_0_IN_IMG_DIRECT_MODE_FIX */
      0x0, /* BURST_COLLECT_DUMMY_DATA_WASTE_CYCLES_FIX */
      0x0, /* INIMG_NOT_64BYTE_ALIGN_CACHELINE_MODE_FIX */
      0x0, /* TP_FC_FLOAT_LAST_PIXEL_NEGATIVE_0_FIX */
      0x0, /* NN_WASTE_COEF_READ_WRITE_BANDWIDTH_128BYTE_VIPSRAM_IN_FULL_PATIAL_CACHE_MODE_FIX */
      0x0, /* NN_IN_TILE_DATA_IS_ALL_PAD_FIX */
      0x0, /* NN_TP_INSTR_COMPLETE_IN_SAME_CYCLE_WITH_WAIT_EVENT_FIX */
      0x0, /* CORE_IMAGE_TRANSER_NOT_EFFICIENT_BETWEEN_PARTITION_FIX */
      0x0, /* TP_FC_KERNEL_STREAM_MUST_LESS_THAN_OR_EQUAL_TO_64BYTE_WHEN_1BYTE_ALGINE_FIX */
      0x0, /* NN_KERNEL_1x1_NO_PAD_FIX */
      0x0, /* NN_DEPTHWISE_AFTER_16BIT_LAYER_LIMIT_FIX */
      0x0, /* TP_NOT_FULL_USE_CACHE_LINE_FIX */
      0x1, /* SH_MOVAI_MOVAR_UNUSED_COMPONENTS_WRITE_DIRTY_DATA_FIX */
      0x1, /* BURST_COLLECT_CONSUMES_MC_DATA_WIDTH_PER_CYCLE_FIX */
      0x0, /* TP_ASSYM_INT8_FIX */
      0x0, /* NN_PAD_SLICE_ERROR_WHEN_TRANSPSE_FIX */
      0x0, /* NN_2ND_IMG_BASE_ADDR_FIX */
      0x0, /* NN_TP_SYSTEM_FIX */
      0x0, /* NN_INTILE_YSIZE_128_LIMIT_FIX */
      0x0, /* SH_CLOCK_GATOR_IDLE_CONDITON_FIX */
      0x0, /* NN_BURST_COLLECTER_LAST_FLAG_FIX */
      0x0, /* NN_2ND_IMG_SMALL_3D_TILE_FIX */
      0x0, /* NN_TILE_YSIZE_127_LIMITATION_FIX */
      0x0, /* NN_CONV_1D_16BIT_FORMAT_INTILE_SIZE_LIMITATION_FIX */
      0x0, /* NN_VIPSRAM_DOUBLE_BUFFER_FIX */
      0x0, /* NN_JD_DIRECT_MODE_FIX */
      0x0, /* NN_KERNEL_DIRECT_WRONG_PUSH_FIX */
      0x0, /* HI_DEFAULT_ENABLE_REORDER_FIX */
      0x0, /* V83_INTILESIZE_1X1_10BITS_FIX */
      0x0, /* NN_INTERLEVE8 */
      0x0, /* NN_FP16_ALU */
      0x0, /* NN_INT16_ALU */
      0x0, /* NN_INT8_SCALE */
      0x0, /* NN_POWER_ISOLATION */
      0x0, /* ZRL_7BIT */
      0x0, /* NN_SMALLBATCH */
      0x0, /* TP_SMALLBATCH */
      0x0, /* ZRL_8BIT */
      0x0, /* DDR_BURST_LEN_256B */
      0x0, /* XY_OFFSET_LIMITATION_FIX */
      0x0, /* NN_NONZERO_MIRROR_BORDER */
      0x0, /* IMAGE_PARTIAL_CACHE */
      0x20, /* VIRTUAL_ADDRESS_BITS */
      0x0, /* PHYSICAL_ADDRESS_BITS */
      0x0, /* G2D_TILING_MINOR */
      0x0, /* PS_INPUT_COMPONENTS */
      0x0, /* AIGM_MAX_SIZE */
      0x0, /* NNCoreCount_UINT16 */
      {0, 0, 0, 0, 0, 0, 0, 0, 0}, /* VIP_SRAM_SIZE_ARRAY */
      0x0, /* LUT_ACT_LANES */
      0x0, /* MIN_AXI_BURST_SIZE */
      0x0, /* OUTIMAGE_SLICE_BITS */
      0x0, /* INIMAGE_SLICE_BITS */
      0x0, /* NN_SMALL_ACCUM_BITS */
      0x0, /* NN_COEF_DECOMPRESS_PERF_X */
      0x0, /* SP_VECTOR_DEPTH */
      0x0, /* VIPSRAM_CLK_DOMAIN_RATIO_PERCENT */
      0x0, /* VIP_VERSION */
      0x0, /* NN_COMMAND_BUFFER_SIZE */
      0x0, /* DECOMP_VZ_GROUP_BITS */
      0x0, /* NN_LOOP1_DP_NUMBER */
      0x0, /* AXIFE */
      0x0, /* PE_64BPP_LINEAR_FORMAT */
      0x0, /* HIGHP_VEC2 */
      0x0, /* MMU_PD_42_BIT_ADDRESS */
      0x0, /* BLT_ROBUSTNESS_FIX */
      0x0, /* BLT_OUT_OF_BOUND_FIX */
      0x0, /* TFB_PERF_FIX */
      0x0, /* SH_SUPERSCALAR_ARCH */
      0x0, /* PA_ZEROAREA_LINE_FIX */
      0x0, /* RS_TILER_YUV420_FIX */
      0x0, /* ATTR_IN_GLOBAL_MEMORY */
      0x0, /* SIMPLIFIED_CHECKERBOARD */
      0x0, /* ADDR_REMAP */
      0x0, /* ADDR_40BIT_OVERFLOW_FIX */
      0x0, /* CLIP_DISTANCE_SUPPORT */
      0x0, /* SEPARATED_TEXTURE_SAMPLER */
      0x0, /* TS_INFO_IN_TX_DESCRIPTOR */
      0x0, /* PER_STAGE_LOCAL_STORAGE */
      0x0, /* DX11_FORMAT_SUPPORT */
      0x0, /* OCCLUSION_SAMPLE_COUNTER */
      0x0, /* FRONT_FACE_UINT */
      0x0, /* DYNAMIC_TEXTURE_INDEXING */
      0x0, /* D3D11_SUPPORT */
      0x0, /* MMU_40BIT_VA_FIX */
      0x0, /* MMU_40BIT_VA_GRAPHICS */
      0x0, /* ONE_OUTPUT_COMPOENT_FOR_MFU */
      0x0, /* SH_64BIT_VA_ENHANCEMENT */
      0x0, /* DX11_SH_RCP_SQRT_PRECISSION */
      0x0, /* TILED_RESOURCE */
      0x0, /* SH_FP64 */
      0x0, /* SH_SM6 */
      0x0, /* VGPU */
      0x0, /* DEC_NANO */
      0x0, /* SH_64BIT_ROBUST_CHECK */
      0x0, /* G2D_RGB_PLANAR_SOURCE */
      0x0, /* G2D_FC_IN_DEC400EX */
      0x0, /* G2D_MultiSrcBlt_Pipe */
      0x0, /* G2D_Stretch_MultiSrc_Pipe */
      0x0, /* G2D_Normalization */
      0x0, /* G2D_Normalization_Quantization */
      0x0, /* G2D_FRAME_DONE_INTR */
      0x0, /* G2D_MASK_AND_COLORKEY */
      0x0, /* G2D_Histogram */
      0x0, /* G2D_Brightness_Saturation */
      0x0, /* NN_ZDP9 */
      0x0, /* HW_V83 */
      0x0, /* NN_CMD_SUPPORT_SLICE */
      0x0, /* NN_RD_IMG_NEED_EXTRA_SPACE */
      0x0, /* VIP_INDIV_CLK_NN */
      0x0, /* VIP_EXPORT_CLK_DIV2 */
      0x0, /* NN_SUPPORT_INLINE_NWHC_AND_MATRIX_TRANSPOSE */
      0x0, /* VIP_SUPPORT_DEC */
      0x0, /* NN_SUPPORT_MULTI_AXI_ID */
      0x0, /* NN_POST_OUT_SUPPORT_INT32 */
      0x0, /* NN_4BIT_PHASE1 */
      0x0, /* NN_POST_MULT_SUPPORT_FP_CONV */
      0x0, /* NN_SUPPORT_16_8_QUANTIZATION */
      0x0, /* SPECIAL_8BIT_SIGN_ABS_CONV */
      0x0, /* NN_SUPPORT_CONFIGURABLE_FASTXDP3 */
      0x0, /* NN_USE_CORE_SHARING_IMGBUF_AND_SEQ_NO_ZEROSKIPPING */
      0x0, /* SUPPORT_DECONVNxN_S_LESS_THAN_16 */
      0x0, /* NN_PICOCORE_DEPTHWISE */
      0x0, /* VIP_SUPPORT_TENSOR_TRANSFER */
      0x0, /* NN_SUPPORT_CMD_LOOP */
      0x0, /* VIP_SUPPORT_X_FRAME_COMPRESSION */
      0x0, /* NN_SMALL_ACCUM */
      0x0, /* NN_SINGLE_POSTMULT_FIELDS_IN_BITSTREAM */
      0x0, /* POST_MULTIPLIER_LOW_POWER_MODE */
      0x0, /* NN_SUPPORT_EFUSE */
      0x0, /* NN_SUPPORT_STREAMPROCESSOR */
      0x0, /* NN_SUPPORT_GEMM_PHASE1 */
      0x0, /* NN_SUPPORT_CLAMP_BORDER_MODE */
      0x0, /* NN_ELEMENTWISE_BROADCAST_STRIDE_X_0 */
      0x0, /* NN_2ND_IMAGE_DATA_TYPE */
      0x0, /* FP_INIMAGE_POST_SCALE */
      0x0, /* NN_INT16_TENSOR_ADD */
      0x0, /* NN_TENSOR_ADD_DOUBLE_PIPELINE */
      0x0, /* TENSOR_DMA */
      0x0, /* NN_SPLIT_X_AMONG_CLUSTER */
      0x0, /* NN_SUPPORT_ZDP_LOOP6 */
      0x0, /* NN_FP8_PHASE1 */
      0x0, /* NN_SUPPORT_FUSA */
      0x0, /* NN_OUTPUT_OVERFLOW_MODE */
      0x0, /* NN_DEPTHWISE_ENHANCEMENT */
      0x0, /* NN_CONV_1X1_ENHANCEMENT */
      0x0, /* SUPPORT_DYNAMIC_SHAPE */
      0x0, /* SUPPORT_BATCH_ALIGNMENT */
      0x0, /* NN_SUPPORT_GEMM_PHASE2 */
      0x0, /* SRAM_PARITY */
      0x0, /* NNCMD_AXIID_OFFSET */
      0x0, /* TC_SHADER_TRIGGER_NN */
      0x0, /* TC_PROBE_COUNTER */
      0x0, /* NN_TILE_BRICK_MODE */
      0x0, /* NN_4BIT_COEF_PACKED_MODE */
      0x0, /* NN_BF16_I4_I8_QUANTIZATION */
      0x0, /* NN_HIGH_PERF_DECODE_SPLIT_STAGE */
      0x0, /* NN_POST_PROCESSOR_FL32 */
      0x0, /* NN_HIGH_PERF_DECODER */
      0x0, /* NN_GROUP_QUANT_PHASE1 */
      0x0, /* SH_CONFORMANCE_BRUTEFORCE_FIX */
      0x0, /* V83_CONVERTER_FOR_NEG_0_FIX */
      0x0, /* V8_DIRECT_MODE_START_ADDR_BIAS_FOR_NEGATIVE_OFFSET_FIX */
      0x0, /* FASTXDP3_ONLY_IN_DEPTHWISE_FIX */
      0x0, /* US_SRAM_READ_INTF_FIFO_OVERFLOW_FIX */
      0x0, /* USC_PAUSE_TP_WR_REQ_MORE_THAN_256_CYCLES_FIX */
      0x0, /* DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* NN_CIRCULAR_BUF_WRAP_ADDRESS_OVERFLOW_FIX */
      0x0, /* CLOCK_DIV2_FREQ_CHANGE_FIX */
      0x0, /* SMALL_TILE_TENSOR_ADD_FIX */
      0x0, /* DECOMPRESSOR_DEPTHWISE_FLOAT_FIX */
      0x0, /* TP_CIRCULAR_BUF_WRAP_ADDRESS_LESS_FIX */
      0x0, /* V83_NUMOFPENDINGTILES_FOR_2NDIMAGE_FIX */
      0x0, /* V83_1ST_CACHE_MODE_VIPSRAM_RD_UPDATE_FIX */
      0x0, /* V83_1ST_KERNEL_STREAM_BUFFER_UPDATE_FIX */
      0x0, /* USC_RW_SAME_CACHELINE_UPDATE_FIX */
      0x0, /* NN_KERNEL_MSS_SBP2_DIRECT_STEAM_STEAM_FIX */
      0x0, /* CORE_NUM_OF_KID_FOR_MULTI_LAYER_FIX */
      0x0, /* KERNEL_XSIZE_YSIZE_NUM_FIX */
      0x0, /* IMGRD_ROW_NUMBER_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE1_FIX */
      0x0, /* NN_1ST_AND_2ND_INIMAGE_RAISE_VIPSRAM_RD_UPDATE_AT_SAME_TIME_PHASE2_FIX */
      0x0, /* WRSPLIT_NOT_SUPPORT_PROBE_FIX */
      0x0, /* TRSP2_NOT_SUPPORT_VIPSRAM_IN_XSTRIDE_IT_FETCH_XSIZE_FIX */
      0x0, /* TP_SPECIAL_LIST_PARSER_FIX */
      0x0, /* DECOMPRESSOR_TREATS_TOTAL_CORES_AS_ACTIVE_CORES_FIX */
      0x0, /* DIRECT_INIMAGE_XSTIDE_LE_13BIT_FIX */
      0x0, /* TILEXSIZE_LESS_THAN_1_4_AXIBUS_FIX */
      0x0, /* SECONDIMG_TILE_SIDEBANFIFO_FIX */
      0x0, /* TRSPB2_ENDADDR_EQUAL_SRAMEND_FIX */
      0x0, /* WRITE_STRIDE2_DUMMY_FIX */
      0x0, /* TRSP2_WORDSIZE_BIGGER_FIX */
      0x0, /* BURSTCOLLECTOR_ADDR_UPDATE_FIX */
      0x0, /* TRSB2_SMALL_BATCH_UPDATE_FIX */
      0x0, /* NN_NT_SMALLBATCH_TRNSFER_INIT_FIX */
      0x0, /* IMGRD_FIRST_ROW_SMALL_SLICE_FIX */
      0x0, /* KERNEL_WR_RD_LUTLOAD_DIRECTMODE_ADDR_FIX */
      0x0, /* MULTI_AXI_ID_KERNEL_FULLCACHE_PERF_FIX */
      0x0, /* MULTI_AXI_ID_IMG_KERNEL_SAME_FIX */
      0x0, /* TRSP2_CONV_SMALLBATCH_FIX */
      0x0, /* DEPTHTOSPACE_SAME_XY_FIX */
      0x0, /* VZ_GROUP_START_Z_OVERFLOW_FIX */
      0x0, /* V82_STREAMMODE_VIPSRAM_ADDRESS_FIX */
      0x0, /* GEMM_NO_SUPPORT_SMALLBATCH_FIX */
      0x0, /* SBP1_KHEAD_CMDSIZE_FIX */
      0x0, /* PERF_BURSTCOLLECTOR_MAXSIZE_FIX */
      0x0, /* PERF_KERNEL_DESCRIPTOR_SOURCE_FIX */
      0x0, /* SP_NOIN_IMGRD_DUMMY_FIX */
      0x0, /* NN_4BIT_PERF_EVEN_TILEXSIZE_FIX */
      0x0, /* STREAMMODE_ONE_NNCMD_ONE_2DTILE_FIX */
      0x0, /* MULTI_ID_DIRECTMODE_CHANGE_FIX */
      0x0, /* PERF_4BITS_DONT_SUPPORT_TRSP1_2_FIX */
      0x0, /* FIRST_SECOND_IMG_SAME_ID_FIX */
      0x0, /* TILESIZE_LIMITATION_CORE_BYPASS_FIX */
      0x1, /* SH_BARRIER_EXECUTION_FIX */
      0x0, /* FIX_11PK_NO_POOLING_NEWIMGRD_ADDR_FIX */
      0x0, /* GPU_AXI_BUS_WIDTH */
      0x0, /* NumDPPUsPerCluster */
      0x0, /* NN_ZRL_VALID_ZERO_NUMBER */
      0x0, /* NN_KERNEL_FIFO_IN_WIDTH */
      0x0, /* SH_INSTR_DENORM_SUPPORT */
      0x0, /* SH_GA_SUPPORT */
      0x0, /* NN_SH_IN_PARALLEL */
      0x0, /* NN_ASYNC_DMA */
      0x0, /* NN_STRIDE2_FAST_XDP3 */
      0x0, /* NN_2V4_STRUCTURED_SPARSITY */
      0x0, /* NN_SP_ENHANCEMENT */
      0x0, /* NN_SUPPORT_SEPARATE_STREAMBUF_ADDR */
      0x0, /* NN_TF32_MAC */
      0x0, /* NN_SP_FP28_PRECISION */
      0x0, /* NN_VIPSRAM_SHARE_AMONG_CLUSTERS */
      0x0, /* NN_SUPPORT_UNIQUE_ID */
      0x0, /* NN_FAST_VIPSRAM */
      0x0, /* NN_MOVE_DECOMPRESSOR_OUT_OF_CORE */
      0x0, /* NN_SPLITKZ_REDUCE_SUM */
      0x0, /* NN_SUPPORT_FFD */
      0x0, /* NN_SUPPORT_FP8_DOUBLE_MAC */
      0x0, /* NN_SUPPORT_DENORM */
      0x0, /* NN_SUPPORT_POST_OP_FUSE */
      0x0, /* T3D_SYNC_DMA */
      0x0, /* NN_GENERIC_DMA */
      0x0, /* NN_DOUBLE_CONV_OUT */
      0x0, /* CMD_LOOP_STATE_LOAD_SAVE */
      0x0, /* DYNAMIC_ACTIVATION_SCALE */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FIX */
      0x0, /* FIX_MATRIX_A_TRSP1_CHNUM_FIX */
      0x0, /* FIX_4BIT_SBP2_BLOCKCTRL2_FIX */
      0x0, /* B2B_RETRUN_NN_CMD_DONE_FIX */
      0x0, /* MULTI_AXI_ID_VLW_3D_TILE_INFO_FIX */
      0x0, /* TRSP2_SPECIAL_WORDSIZE_FIX */
      0x0, /* FIX_PRE_CORE_LOTS_ZEROSKIP_KERNEL_FURTHER_FIX */
      0x0, /* NN_2ND_IMAGE_TILE_LIMIT_1024B_FIX */
      0x0, /* MULTIAXIID_TBUF_STALL_READY_FIX */
      0x0, /* V940_TILESIZE_1024N_FIX */
   },
   {
      0x7000, /* chipID */
      0x6205, /* chipVersion */
      0x70007, /* productID */
      0x1, /* ecoID */
      0x12, /* customerID */
      0x0, /* patchVersion */
      "GCNANOULTRA31", /* productName */
      0x0, /* formalRelease */
      0x40, /* TempRegisters */
      0x200, /* ThreadCount */
      0x1, /* NumShaderCores */
      0x200, /* InstructionCount */
      0x140, /* NumberOfConstants */
      0x1, /* CoreCount */
      0x8, /* LocalStorageSize */
      0x0, /* LocalStorageSize_1 */
      0x0, /* LocalStorageSize_2 */
      0x8, /* L1CacheSize */
      0x0, /* L1CacheSize_1 */
      0x0, /* L1CacheSize_2 */
      0x200, /* InstructionMemorySize */
      0x14, /* ShaderPCLength */
      0x8, /* USC_MAX_PAGES */
      0x0, /* USC_MAX_PAGES_1 */
      0x0, /* USC_MAX_PAGES_2 */
      0x1, /* NumPixelPipes */
      0x0, /* USC_CACHE_CONTROLLERS */
      0x0, /* USC_CACHE_CONTROLLERS_1 */
      0x0, /* USC_CACHE_CONTROLLERS_2 */
      0x0, /* USC_BANKS */
      0x0, /* USC_BANKS_1 */
      0x0, /* USC_BANKS_2 */
      0x10, /* Streams */
      0x10, /* VaryingCount */
      0x400, /* VertexOutputBufferSize */
      0x0, /* BufferSize */
      0x10, /* VertexCacheSize */
      0x1, /* NumResolvePipes */
      0x10, /* RESULT_WINDOW_MAX_SIZE */
      0x0, /* ClusterAliveMask */
      0x0, /* G2D_DEC400_MINOR */
      0x0, /* PS_INSTRUCTION_COUNT */
      0x0, /* NNMadPerCore */
      0x0, /* NNCoreCount */
      0x0, /* NN_ACTIVE_CORE_COUNT */
      0x0, /* NNCoreCount_INT8 */
      0x0, /* NNCoreCount_INT16 */
      0x0, /* NNCoreCount_FLOAT16 */
      0x0, /* NNCoreCount_BFLOAT */
      0x0, /* NNInputBufferDepth */
      0x0, /* NNAccumBufferDepth */
      0x0, /* TPEngine_PwlLUTCount */
      0x0, /* TPEngine_PwlLUTSize */
      0x0, /* VIP_SRAM_SIZE */
      0x0, /* TPEngine_CoreCount */
      0x0, /* AXI_SRAM_SIZE */
      0x0, /* NN_INIMAGE_OFFSET_BITS */
      0x0, /* TP_REORDER_INIMAGE_SIZE */
      0x0, /* TPLite_CoreCount */
      0x0, /* NN_PREPROCESSOR_MAX_SEGMENT_PER_CYCLE */
      0x0, /* NNFP16_XYDP_X */
      0x0, /* NNFP16_XYDP_Y */
      0x0, /* NNFP16_ZDP */
      0x0, /* NN_LANES_PER_OUT_CYCLE */
      0x0, /* MAX_OT_NUMBER */
      0x0, /* PHYSICAL_VIP_SRAM_WIDTH_IN_BYTE */
      0x0, /* EQUIVALENT_VIP_SRAM_WIDTH_INBYTE */
      0x0, /* TP_ZRL_BITS */
      0x0, /* NN_ZRL_BITS */
      0x0, /* LATENCY_HIDING_AT_FULL_AXI_BW */
      0x0, /* AXI_BUS_WIDTH */
      0x0, /* NN_KERNEL_X_SIZE */
      0x0, /* NN_KERNEL_Y_SIZE */
      0x0, /* NN_FC_KERNEL_Y_SIZE */
      0x0, /* NN_KERNEL_Z_SIZE */
      0x0, /* NN_X_OFFSET */
      0x0, /* NN_Y_OFFSET */
      0x0, /* DDR_KERNEL_BURST_SIZE */
      0x0, /* OUTIMAGE_X_STRIDE_BITS */
      0x0, /* OUTIMAGE_Y_STRIDE_BITS */
      0x0, /* INIMAGE_X_STRIDE_BITS */
      0x0, /* IMIMAGE_Y_STRIDE_BITS */
      0x0, /* OUTIMAGE_X_SIZE_BITS */
      0x0, /* OUTIMAGE_Y_SIZE_BITS */
      0x0, /* OUTIMAGE_Z_SIZE_BITS */
      0x0, /* INIMAGE_X_SIZE_BITS */
      0x0, /* INIMAGE_Y_SIZE_BITS */
      0x0, /* MAX_TILE_X_SIZE */
      0x0, /* NN_CLUSTER_NUM_FOR_POWER_CONTROL */
      0x0, /* NN_IN_LINES_PER_CYCLE */
      0x0, /* VIP_CLUSTER_COUNT */
      0x0, /* NN_MP_INTER_CONNECT_RING_COUNT */
      0x1, /* REG_FastClear */
      0x0, /* REG_SpecialAntiAliasing */
      0x1, /* REG_Pipe3D */
      0x1, /* REG_DXTTextureCompression */
      0x0, /* REG_DebugMode */
      0x0, /* REG_ZCompression */
      0x0, /* REG_YUV420Filter */
      0x1, /* REG_MSAA */
      0x0, /* REG_DC */
      0x0, /* REG_Pipe2D */
      0x1, /* REG_ETC1TextureCompression */
      0x1, /* REG_FastScaler */
      0x1, /* REG_HighDynamicRange */
      0x1, /* REG_YUV420Tiler */
      0x1, /* REG_ModuleCG */
      0x0, /* REG_MinArea */
      0x0, /* REG_NoEZ */
      0x0, /* REG_No422Texture */
      0x0, /* REG_BufferInterleaving */
      0x1, /* REG_ByteWrite2D */
      0x0, /* REG_NoScaler */
      0x1, /* REG_YUY2Averaging */
      0x0, /* REG_HalfPECache */
      0x0, /* REG_HalfTXCache */
      0x0, /* REG_YUY2RenderTarget */
      0x0, /* REG_Mem32BitSupport */
      0x0, /* REG_PipeVG */
      0x0, /* REG_VGTS */
      0x0, /* REG_FE20 */
      0x1, /* REG_ByteWrite3D */
      0x1, /* REG_RsYuvTarget */
      0x1, /* REG_FE20BitIndex */
      0x1, /* REG_FlipY */
      0x1, /* REG_DualReturnBus */
      0x1, /* REG_EndiannessConfig */
      0x1, /* REG_Texture8K */
      0x1, /* REG_CorrectTextureConverter */
      0x1, /* REG_SpecialMsaaLod */
      0x1, /* REG_FastClearFlush */
      0x1, /* REG_2DPE20 */
      0x0, /* REG_CorrectAutoDisable */
      0x1, /* REG_Render8K */
      0x1, /* REG_TileStatus2Bits */
      0x1, /* REG_SeparateTileStatusWhenInterleaved */
      0x1, /* REG_SuperTiled32x32 */
      0x0, /* REG_VG20 */
      0x0, /* REG_TSExtendedCommands */
      0x1, /* REG_CompressionFifoFixed */
      0x1, /* REG_ExtraShaderInstructions0 */
      0x0, /* REG_VGFilter */
      0x0, /* REG_VG21 */
      0x1, /* REG_ShaderGetsW */
      0x1, /* REG_ExtraShaderInstructions1 */
      0x1, /* REG_DefaultReg0 */
      0x1, /* REG_MC20 */
      0x0, /* REG_ShaderMSAASideband */
      0x1, /* REG_BugFixes0 */
      0x0, /* REG_VAA */
      0x0, /* REG_BypassInMSAA */
      0x0, /* REG_HierarchicalZ */
      0x0, /* REG_NewTexture */
      0x0, /* REG_A8TargetSupport */
      0x1, /* REG_CorrectStencil */
      0x1, /* REG_EnhanceVR */
      0x1, /* REG_RSUVSwizzle */
      0x0, /* REG_V2Compression */
      0x0, /* REG_VGDoubleBuffer */
      0x1, /* REG_BugFixes1 */
      0x1, /* REG_BugFixes2 */
      0x0, /* REG_TextureStride */
      0x1, /* REG_BugFixes3 */
      0x1, /* REG_CorrectAutoDisable1 */
      0x0, /* REG_AutoRestartTS */
      0x1, /* REG_BugFixes4 */
      0x0, /* REG_L2Windowing */
      0x1, /* REG_HalfFloatPipe */
      0x1, /* REG_PixelDither */
      0x1, /* REG_TwoStencilReference */
      0x1, /* REG_ExtendedPixelFormat */
      0x1, /* REG_CorrectMinMaxDepth */
      0x1, /* REG_DitherAndFilterPlusAlpha2D */
      0x1, /* REG_BugFixes5 */
      0x0, /* REG_New2D */
      0x1, /* REG_NewFloatingPointArithmetic */
      0x1, /* REG_TextureHorizontalAlignmentSelect */
      0x1, /* REG_NonPowerOfTwo */
      0x1, /* REG_LinearTextureSupport */
      0x1, /* REG_Halti0 */
      0x0, /* REG_CorrectOverflowVG */
      0x1, /* REG_NegativeLogFix */
      0x1, /* REG_ResolveOffset */
      0x1, /* REG_OkToGateAxiClock */
      0x1, /* REG_MMU */
      0x1, /* REG_WideLine */
      0x1, /* REG_BugFixes6 */
      0x1, /* REG_FcFlushStall */
      0x1, /* REG_LineLoop */
      0x1, /* REG_LogicOp */
      0x1, /* REG_SeamlessCubeMap */
      0x1, /* REG_SuperTiledTexture */
      0x1, /* REG_LinearPE */
      0x1, /* REG_RectPrimitive */
      0x0, /* REG_Composition */
      0x1, /* REG_CorrectAutoDisableCountWidth */
      0x1, /* REG_PESwizzle */
      0x1, /* REG_EndEvent */
      0x1, /* REG_S1S8 */
      0x1, /* REG_Halti1 */
      0x0, /* REG_RGB888 */
      0x0, /* REG_TX_YUVAssembler */
      0x1, /* REG_DynamicFrequencyScaling */
      0x0, /* REG_TXFilter */
      0x1, /* REG_FullDirectFB */
      0x0, /* REG_OnePass2DFilter */
      0x1, /* REG_ThreadWalkerInPS */
      0x1, /* REG_TileFiller */
      0x1, /* REG_YUVStandard */
      0x0, /* REG_MultiSourceBlt */
      0x0, /* REG_YUVConversion */
      0x1, /* REG_FlushFixed2D */
      0x1, /* REG_Interleaver */
      0x1, /* REG_MixedStreams */
      0x0, /* REG_L2CacheFor2D420 */
      0x1, /* REG_BugFixes7 */
      0x0, /* REG_NoIndexPattern */
      0x1, /* REG_TextureTileStatus */
      0x1, /* REG_DecompressZ16 */
      0x1, /* REG_BugFixes8 */
      0x1, /* REG_DERotationStallFix */
      0x0, /* REG_OclOnly */
      0x1, /* REG_NewFeatures0 */
      0x1, /* REG_InstructionCache */
      0x0, /* REG_GeometryShader */
      0x1, /* REG_TexCompressionSupertiled */
      0x1, /* REG_Generics */
      0x1, /* REG_BugFixes9 */
      0x0, /* REG_FastMSAA */
      0x0, /* REG_WClip */
      0x1, /* REG_BugFixes10 */
      0x1, /* REG_UnifiedSamplers */
      0x1, /* REG_BugFixes11 */
      0x1, /* REG_PerformanceCounters */
      0x1, /* REG_ExtraShaderInstructions2 */
      0x1, /* REG_BugFixes12 */
      0x1, /* REG_BugFixes13 */
      0x1, /* REG_DEEnhancements1 */
      0x1, /* REG_ACE */
      0x1, /* REG_TXEnhancements1 */
      0x1, /* REG_SHEnhancements1 */
      0x1, /* REG_SHEnhancements2 */
      0x1, /* REG_PEEnhancements1 */
      0x1, /* REG_DEEnhancements2 */
      0x1, /* REG_BugFixes14 */
      0x0, /* REG_PowerOptimizations0 */
      0x1, /* REG_NewHZ */
      0x1, /* REG_BugFixes15 */
      0x0, /* REG_DEEnhancements3 */
      0x1, /* REG_SHEnhancements3 */
      0x1, /* REG_SHEnhancements4 */
      0x1, /* REG_TXEnhancements2 */
      0x1, /* REG_FEEnhancements1 */
      0x1, /* REG_PEEnhancements2 */
      0x1, /* REG_PAEnhancements1 */
      0x0, /* REG_DENoGamma */
      0x0, /* REG_PAEnhancements2 */
      0x0, /* REG_DEEnhancements4 */
      0x1, /* REG_PEEnhancements3 */
      0x1, /* REG_HIEnhancements1 */
      0x1, /* REG_TXEnhancements3 */
      0x1, /* REG_SHEnhancements5 */
      0x1, /* REG_FEEnhancements2 */
      0x1, /* REG_BugFixes16 */
      0x0, /* REG_DEEnhancements5 */
      0x1, /* REG_TXEnhancements4 */
      0x0, /* REG_PEEnhancements4 */
      0x1, /* REG_MCEnhancements1 */
      0x1, /* REG_Halti2 */
      0x0, /* REG_DEMirrorRotate */
      0x1, /* REG_SmallMSAA */
      0x1, /* REG_BugFixes17 */
      0x0, /* REG_Rasterizer2 */
      0x0, /* REG_DualPipeOPF */
      0x0, /* REG_MultiSrcV2 */
      0x0, /* REG_CSCV2 */
      0x1, /* REG_PAEnhancements3 */
      0x1, /* REG_BugFixes18 */
      0x0, /* REG_Compression2D */
      0x1, /* REG_Probe */
      0x1, /* REG_MediumPrecision */
      0x0, /* REG_DESupertile */
      0x1, /* REG_BugFixes19 */
      0x1, /* REG_SHEnhancements6 */
      0x1, /* REG_SHEnhancements7 */
      0x1, /* REG_BugFixes20 */
      0x0, /* REG_DEAddress40 */
      0x0, /* REG_MiniMMUFix */
      0x1, /* REG_EEZ */
      0x1, /* REG_BugFixes21 */
      0x0, /* REG_ExtraVgCaps */
      0x0, /* REG_MultiSrcV15 */
      0x1, /* REG_BugFixes22 */
      0x1, /* REG_Halti3 */
      0x0, /* REG_TessellationShaders */
      0x0, /* REG_OPF9Tap */
      0x0, /* REG_MultiSrcV2StrQuad */
      0x0, /* REG_SeperateSRCAndDstCache */
      0x1, /* REG_Halti4 */
      0x1, /* REG_RAWriteDepth */
      0x0, /* REG_AndroidOnly */
      0x1, /* REG_HasChipProductReg */
      0x0, /* REG_TXSupportDEC */
      0x1, /* REG_S8MSAACompression */
      0x1, /* REG_BugFixesIn544 */
      0x0, /* REG_L2CacheRemove */
      0x1, /* REG_FEAllowRndVtxCnt */
      0x0, /* REG_CubeMapFL28 */
      0x1, /* REG_TX6bitFrac */
      0x1, /* REG_FEAllowStallPrefetchEng */
      0x0, /* REG_ThirdPartyCompression */
      0x1, /* REG_RSS8 */
      0x1, /* REG_MSAACoherencyCheck */
      0x1, /* REG_Halti5 */
      0x1, /* REG_Evis */
      0x0, /* REG_BltEngine */
      0x0, /* REG_BugFixes23 */
      0x0, /* REG_BugFixes24 */
      0x0, /* REG_DEC */
      0x0, /* REG_VSTileNV12 */
      0x0, /* REG_VSTileNV12_10BIT */
      0x0, /* REG_DisableVIP */
      0x0, /* RenderTarget8 */
      0x0, /* TxLodFlowCorrection */
      0x0, /* FaceLod */
      0x0, /* MultiCoreSemaphoreStallV2 */
      0x0, /* VMSAA */
      0x0, /* ChipEnableLink */
      0x0, /* MULTI_SRC_BLT_1_5_ENHANCEMENT */
      0x0, /* MULTI_SRC_BLT_BILINEAR_FILTER */
      0x1, /* RA_HZEZ_CLOCK_CONTROL */
      0x1, /* CACHE128B256BPERLINE */
      0x0, /* V4Compression */
      0x0, /* DE2D_MAJOR_SUPER_TILE */
      0x0, /* PE2D_MAJOR_SUPER_TILE */
      0x1, /* PE_32BPC_COLORMASK_FIX */
      0x1, /* ALPHA_BLENDING_OPT */
      0x1, /* NEW_GPIPE */
      0x0, /* PIPELINE_32_ATTRIBUTES */
      0x0, /* MSAA_SHADING */
      0x1, /* NO_ANISTRO_FILTER */
      0x1, /* NO_ASTC */
      0x0, /* NO_DXT */
      0x0, /* HWTFB */
      0x1, /* RA_DEPTH_WRITE_MSAA1X_FIX */
      0x1, /* EZHZ_CLOCKGATE_FIX */
      0x1, /* SH_SNAP2PAGE_FIX */
      0x1, /* SH_HALFDEPENDENCY_FIX */
      0x1, /* USC_MCFILL_FIX */
      0x1, /* TPG_TCPERF_FIX */
      0x1, /* USC_MDFIFO_OVERFLOW_FIX */
      0x1, /* SH_TEXLD_BARRIER_IN_CS_FIX */
      0x1, /* RS_NEW_BASEADDR */
      0x1, /* PE_8bpp_DUALPIPE_FIX */
      0x0, /* SH_ADVANCED_INSTR */
      0x1, /* SH_FLAT_INTERPOLATION_DUAL16_FIX */
      0x1, /* USC_CONTINUOUS_FLUS_FIX */
      0x0, /* SH_SUPPORT_V4 */
      0x0, /* SH_SUPPORT_ALPHA_KILL */
      0x1, /* PE_NO_ALPHA_TEST */
      0x0, /* TX_LOD_NEAREST_SELECT */
      0x1, /* SH_FIX_LDEXP */
      0x1, /* SUPPORT_MOVAI */
      0x1, /* SH_SNAP2PAGE_MAXPAGES_FIX */
      0x1, /* PE_RGBA16I_FIX */
      0x1, /* BLT_8bpp_256TILE_FC_FIX */
      0x1, /* PE_64bit_FENCE_FIX */
      0x1, /* USC_FULL_CACHE_FIX */
      0x0, /* TX_YUV_ASSEMBLER_10BIT */
      0x1, /* FE_32bit_INDEX_FIX */
      0x1, /* BLT_64bpp_MASKED_CLEAR_FIX */
      0x1, /* SECURITY */
      0x1, /* ROBUSTNESS */
      0x1, /* USC_ATOMIC_FIX */
      0x1, /* SH_PSO_MSAA1x_FIX */
      0x1, /* USC_VX_PERF_FIX */
      0x1, /* USC_GOS_ADDR_FIX */
      0x1, /* TX_8bit_UVFrac */
      0x1, /* TX_DESC_CACHE_CLOCKGATE_FIX */
      0x1, /* RSBLT_MSAA_DECOMPRESSION */
      0x0, /* TX_INTEGER_COORDINATE */
      0x1, /* DRAWID */
      0x1, /* PSIO_SAMPLEMASK_IN_R0ZW_FIX */
      0x1, /* TX_INTEGER_COORDINATE_V2 */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG */
      0x1, /* SNAPPAGE_CMD */
      0x1, /* SH_NO_INDEX_CONST_ON_A0 */
      0x1, /* SH_NO_ONECONST_LIMIT */
      0x1, /* SH_IMG_LDST_ON_TEMP */
      0x0, /* COMPUTE_ONLY */
      0x1, /* SH_IMG_LDST_CLAMP */
      0x1, /* SH_ICACHE_ALLOC_COUNT_FIX */
      0x1, /* SH_ICACHE_PREFETCH */
      0x0, /* PE2D_SEPARATE_CACHE */
      0x1, /* PE_MSAA_OQ_FIX */
      0x1, /* PSIO_MSAA_CL_FIX */
      0x1, /* USC_DEFER_FILL_FIX */
      0x1, /* SH_CLOCK_GATE_FIX */
      0x0, /* FE_NEED_DUMMYDRAW */
      0x0, /* PE2D_LINEAR_YUV420_OUTPUT */
      0x0, /* PE2D_LINEAR_YUV420_10BIT */
      0x0, /* MULTI_CLUSTER */
      0x1, /* SH_MULTI_WG_PACK */
      0x1, /* SH_DUAL16_SAMPLEMASK_ZW */
      0x1, /* TPG_TRIVIAL_MODE_FIX */
      0x0, /* TX_ASTC_MULTISLICE_FIX */
      0x0, /* FE_ROBUST_FIX */
      0x1, /* SH_GPIPE_ACCESS_FULLTEMPS */
      0x0, /* PSIO_INTERLOCK */
      0x1, /* PA_WIDELINE_FIX */
      0x0, /* WIDELINE_HELPER_FIX */
      0x0, /* G2D_3rd_PARTY_COMPRESSION_1_1 */
      0x1, /* TX_FLUSH_L1CACHE */
      0x1, /* PE_DITHER_FIX2 */
      0x1, /* SH_TEXLD_U_FIX */
      0x1, /* MC_FCCACHE_BYTEMASK */
      0x1, /* SH_MULTI_WG_PACK_FIX */
      0x1, /* PE_ADVANCE_BLEND_PART0 */
      0x1, /* FE_PATCHLIST_FETCH_FIX */
      0x1, /* RA_CG_FIX */
      0x0, /* DEC400 */
      0x0, /* LS_SUPPORT_PERCOMP_DEPENDENCY */
      0x0, /* MULTI_CORE_BLOCK_SET_CONFIG2 */
      0x0, /* PE_VMSAA_COVERAGE_CACHE_FIX */
      0x1, /* SECURITY_AHB */
      0x0, /* MULTICORE_SEMAPHORESTALL_V3 */
      0x0, /* SMALLBATCH */
      0x0, /* SH_CMPLX */
      0x0, /* SH_IDIV0_SWZL_EHS */
      0x0, /* TX_LERP_LESS_BIT */
      0x0, /* SH_GM_ENDIAN */
      0x0, /* SH_GM_USC_UNALLOC */
      0x0, /* SH_END_OF_BB */
      0x1, /* TX_BORDER_CLAMP_FIX */
      0x0, /* SH_IMG_LD_LASTPIXEL_FIX */
      0x0, /* ASYNC_BLT */
      0x1, /* ASYNC_FE_FENCE_FIX */
      0x0, /* PSCS_THROTTLE */
      0x0, /* SEPARATE_LS */
      0x1, /* WIDELINE_TRIANGLE_EMU */
      0x0, /* FENCE_32BIT */
      0x1, /* FENCE_64BIT */
      0x1, /* PE_DEPTH_ONLY_OQFIX */
      0x1, /* TX_SEAMLESS_CUBE */
      0x1, /* TX_SNORM_SUPPORT */
      0x0, /* SH_SCATTER_GATHER */
      0x0, /* HWMANAGED_LS */
      0x0, /* SH_IMAGE_ENABLE_FIX */
      0x1, /* MSAA_FRAGMENT_OPERATION */
      0x1, /* PE_TILE_CACHE_FLUSH_FIX */
      0x1, /* BLT_YUV_OUTPUT */
      0x1, /* SH_IO_CG_FIX */
      0x0, /* PE_SWIZZLE */
      0x1, /* SH_ROBUSTNESS_FIX */
      0x1, /* USC_ATOMIC_FIX2 */
      0x1, /* PE_A8B8G8R8 */
      0x1, /* MULTIVIEW_RENDER */
      0x1, /* FE_DRAW_DIRECT */
      0x1, /* TX_VKBORDER_MODE */
      0x1, /* TX_UNNORMALIZED_COORD */
      0x0, /* PA_LINECLIP_FIX */
      0x1, /* TX_8bit_UVFrac_ROUNDING_FIX */
      0x0, /* MP_ARCH */
      0x1, /* TX_NO_FIXED_FILTER */
      0x0, /* SHARE_Z */
      0x0, /* DE_2D_FAST_CLEAR */
      0x0, /* DE_TILESTATUS_ROTATION_FIX */
      0x0, /* TX_CLEAR_PENDING_FIX */
      0x0, /* HI1_L2_CACHE */
      0x0, /* USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX */
      0x0, /* FORMAT_10BIT_CROSS_4K */
      0x0, /* FORMAT_P010LSB_I010 */
      0x0, /* ENDIAN_CONTROL */
      0x0, /* G2D_RGB_PLANAR */
      0x0, /* G2D_DEC400EX */
      0x0, /* G2D_NO_YUV420_SOURCE */
      0x0, /* G2D_YUV420_101010 */
      0x0, /* SH_VX2_FLOATING_MAD_FIX */
      0x0, /* TS_FC_VULKAN_SUPPORT */
      0x0, /* MSAA_FLOAT_64BIT */
      0x0, /* INDIRECT_COMPUTE_ZERODIM_FIX */
      0x0, /* Q_CHANNEL_SUPPORT */
      0x0, /* MMU_PAGE_DESCRIPTOR */
      0x0, /* YUV_LINEAR_TO_TILE_ROTATE */
      0x0, /* VEC2_IMULIMAD32_SUPPORT */
      0x0, /* VEC4_IMULIMAD32_SUPPORT */
      0x0, /* VEC2_IDIVIMOD16_SUPPORT */
      0x0, /* DST_TEX_I2F_F2I_INST_DEPRECATE */
      0x0, /* ALU_FP16_INSTRUCTIONS */
      0x0, /* DUAL16_14BIT_PC_SUPPORT */
      0x0, /* LDST_CONV_4ROUNDING_MODES */
      0x0, /* FULL_PACK_MODE_SUPPORT */
      0x0, /* DEPTH_FLOAT32_SUPPORT */
      0x0, /* GPU_INSPECTOR_COUNTERS */
      0x0, /* FP32_TO_FP16_CONV_FIX */
      0x0, /* IMGLD_COMP_COUNT_FIX */
      0x0, /* IMGLD_WIDTH_LT16_FIX */
      0x0, /* TX_FILTER_ROUND_FIX */
      0x0, /* SH_FP32_FMA_SUPPORT */
      0x0, /* TX_ETC2_COMPRESSION */
      0x0, /* VG_TS_CULLING */
      0x0, /* VG_FP25 */
      0x0, /* VG_AYUV_INPUT_OUTPUT */
      0x0, /* VG_DOUBLE_IMAGE */
      0x0, /* VG_RECTANGLE_STRIPE_MODE */
      0x0, /* VG_MMU */
      0x0, /* VG_IM_FILTER */
      0x0, /* VG_IM_YUV_PACKET */
      0x0, /* VG_IM_YUV_PLANAR */
      0x0, /* VG_PE_YUV_PACKET */
      0x0, /* VG_COLOR_PRECISION_8_BIT */
      0x0, /* VG_RESOLVE_ENGINE */
      0x0, /* VG_PE_COLOR_KEY */
      0x0, /* VG_IM_INDEX_FORMAT */
      0x0, /* VG_RESOLUTION_8K */
      0x0, /* VG_IMAGE_16K */
      0x0, /* VG_FORMAT_ARGB2222 */
      0x0, /* G2D_DEC400 */
      0x0, /* DC_OVERLAY_SCALING */
      0x0, /* DC_SOURCE_ROTATION */
      0x0, /* DC_TILED */
      0x0, /* DC_YUV_L1 */
      0x0, /* DC_D30_OUTPUT */
      0x0, /* DC_MMU */
      0x0, /* DC_COMPRESSION */
      0x0, /* DC_QOS */
      0x0, /* VIP_HW_FINAL_RELEASE */
      0x0, /* NN_SINGLEPORT_ACCUMBUFFER */
      0x0, /* NN_STRIDE_SUPPORT */
      0x0, /* SWTILING_PHASE1 */
      0x0, /* SWTILING_PHASE2 */
      0x0, /* TP_SIMPLE_INT16 */
      0x0, /* TP_REAL_INT16 */
      0x0, /* TP_ROI_POOLING */
      0x0, /* TP_MAX_POOLING_STRIDE1 */
      0x0, /* TP_LRN */
      0x0, /* TP_REORDER */
      0x0, /* TF_QUANTIZATION */
      0x0, /* NN_NONZERO_BORDER */
      0x0, /* NN_MIRROR_BORDER */
      0x0, /* AI_GPU */
      0x0, /* EVIS_NO_ABSDIFF */
      0x0, /* EVIS_NO_BITREPLACE */
      0x0, /* EVIS_NO_BOXFILTER */
      0x0, /* EVIS_NO_CORDIAC */
      0x0, /* EVIS_NO_DP32 */
      0x0, /* EVIS_NO_FILTER */
      0x0, /* EVIS_NO_IADD */
      0x0, /* EVIS_NO_SELECTADD */
      0x0, /* EVIS_LERP_7OUTPUT */
      0x0, /* EVIS_ACCSQ_8OUTPUT */
      0x1, /* EVIS_VX2 */
      0x0, /* TP_ENGINE */
      0x0, /* VIP_V7 */
      0x0, /* TP_TENSOR_ADD_MUL */
      0x0, /* NN_DEPTHWISE_INT16XINT8 */
      0x0, /* NN_DEPTHWISE_8BIT_VIP_V7 */
      0x0, /* TP_SOFTMAX */
      0x0, /* NN_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* TP_23BITS_POST_MULTIPLIER_VIP_V7 */
      0x0, /* CONV_INT16X8BIT_VIP_V7 */
      0x0, /* NN_REMOVE_POOLING */
      0x0, /* NN_40BIT_BIAS */
      0x0, /* TP_REMOVE_USC */
      0x0, /* NN_ZDP6 */
      0x0, /* NN_XYDP9 */
      0x0, /* NN_FIRST_PIXEL_POOLING */
      0x0, /* NN_ZDP3 */
      0x0, /* NN_XYDP6 */
      0x0, /* SWTILING_PHASE3 */
      0x0, /* MCFE */
      0x0, /* USC_STAY_LRU */
      0x0, /* COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* TP_COEF_COMPRESSION_ENHANCEMENT */
      0x0, /* NN_COEF_DECOMPRESS_PERF2X */
      0x0, /* TP_SMALLBATCH_PHASE1 */
      0x0, /* OCB_COUNTER */
      0x0, /* SCALER */
      0x0, /* SCALER_4K */
      0x0, /* INPUT_4BIT */
      0x0, /* NN_NO_Z_LOCATION_OFFSET */
      0x0, /* OCB_REMAP_PHYSICAL_ADDRESS */
      0x0, /* NN_SLOW_OUTPUT */
      0x0, /* NO_NARROW_POST_PROCESS_PIPE */
      0x0, /* TP_NN_PROBE */
      0x0, /* NN_DEPTHWISE_SUPPORT */
      0x0, /* NN_XYDP0 */
      0x0, /* NN_WRITE_WITHOUT_USC */
      0x0, /* NN_HW_LIMITATION_NATIVE_KER_1x2_2x1 */
      0x0, /* NN_SMALLBATCH_PHASE1 */
      0x0, /* NN_SLICE_PADDING_TO_64BYTE_ALIGN */
      0x0, /* NN_DW_1x1_CONV_MERGE */
      0x0, /* TP_BFLOAT16 */
      0x0, /* TP_23BITS_POST_MULTIPLIER */
      0x0, /* NN_TRANSPOSE */
      0x0, /* NN_ZDP_TRANSPOSE_CH9_ONLY */
      0x0, /* USE_SINGLE_PORT_VIPSRAM */
      0x0, /* NN_LEAKY_RELU */
      0x0, /* NN_PRELU */
      0x0, /* NN_PER_CHANNEL_QUANT */
      0x0, /* NN_PER_CHANNEL_QUANT_ASYM */
      0x0, /* NN_ASYMMETRIC_INT8 */
      0x0, /* NN_FLOAT_POST_MULT */
      0x0, /* PRELU_LEAKLY_RELU_CLAMP */
      0x0, /* TPLITE_BFLOAT16 */
      0x0, /* PREPROCESS_IMG_BUF_640BYTE_LIMIT */
      0x0, /* NN_POST_OUT_SUPPORT_FP16 */
      0x0, /* NN_POST_OUT_SUPPORT_BF16 */
      0x0, /* NN_POST_OUT_SUPPORT_FP32 */
      0x0, /* TP_KERNEL_1BYTE_ALGIN */
      0x0, /* BFLOAT_COEF_COMPRESSION_ZERO_COEFBIT14_INVERSE */
      0x0, /* NN_COMPRESSION_BYPASSS */
      0x0, /* TP_3_USC */
      0x0, /* BFP_COEF_AUTO_PAD_INCOMPLETE_ZERO_IN_KZ_PLANE */
      0x0, /* NN_NATIVE_STRIDE_TWO */
      0x0, /* NN_TENSOR_ADD */
      0x0, /* NN_FLOAT32_IO */
      0x0, /* TP_FLOAT32_IO */
      0x0, /* NN_SMALL_BATCH_PHASE2 */
      0x0, /* TILE_ACCESS_CAPABILITY */
      0x0, /* FAST_DP3_PREPROCESSOR */
      0x0, /* DEPTHWISE_SUPPORT_16BIT_FORMAT */
      0x0, /* NN_SUPPORT_ALU */
      0x0, /* NN_ENHANCED_MAX_POOLING */
      0x0, /* NN_TRANSPOSE_PHASE2 */
      0x0, /* NN_TENSOR_ADD_FIELD_MOVE_TO_EXT_CMD */
      0x0, /* NN_CONV_CORE_BYPASS */
      0x0, /* NN_TENSOR_ADD_RELU */
      0x0, /* TPLITE_SUPPORT_TP_DATA_TRANSPOSE */
      0x0, /* NN_SUPPORT_CONV_1D */
      0x0, /* USE_VIPSRAM_FOR_KERNEL_STREAMING */
      0x0, /* NN_SUPPORT_DUMMY_TILE */
      0x0, /* NN_SUPPORT_KERNEL_1BYTE_ALIGN */
      0x0, /* NN_1x1_NON_POOLING_PACKING */
      0x0, /* NN_SUPPORT_BOTH_CONV_NATIVE_STRIDE2_AND_POOLING */
      0x0, /* NN_SUPPORT_CONV1x1_AND_NATIVE_CONV_STRIDE2 */
      0x0, /* TP_REMOVE_FC */
   