// This file was generated by qtwaylandscanner
// source file is plasma-window-management.xml

#ifndef QT_WAYLAND_SERVER_PLASMA_WINDOW_MANAGEMENT
#define QT_WAYLAND_SERVER_PLASMA_WINDOW_MANAGEMENT

#include "wayland-server-core.h"
#include "wayland-plasma-window-management-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  org_kde_plasma_window_management
    {
    public:
        org_kde_plasma_window_management(struct ::wl_client *client, int id, int version);
        org_kde_plasma_window_management(struct ::wl_display *display, int version);
        org_kde_plasma_window_management(struct ::wl_resource *resource);
        org_kde_plasma_window_management();

        virtual ~org_kde_plasma_window_management();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_window_management_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_window_management *org_kde_plasma_window_management_object;
            org_kde_plasma_window_management *object() { return org_kde_plasma_window_management_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum state {
            state_active = 0x1,
            state_minimized = 0x2,
            state_maximized = 0x4,
            state_fullscreen = 0x8,
            state_keep_above = 0x10,
            state_keep_below = 0x20,
            state_on_all_desktops = 0x40,
            state_demands_attention = 0x80,
            state_closeable = 0x100,
            state_minimizable = 0x200,
            state_maximizable = 0x400,
            state_fullscreenable = 0x800,
            state_skiptaskbar = 0x1000,
            state_shadeable = 0x2000,
            state_shaded = 0x4000,
            state_movable = 0x8000,
            state_resizable = 0x10000,
            state_virtual_desktop_changeable = 0x20000,
            state_skipswitcher = 0x40000,
            state_no_border = 0x80000,
            state_can_set_no_border = 0x100000,
            state_exclude_from_capture = 0x200000,
        };

        enum show_desktop {
            show_desktop_disabled = 0,
            show_desktop_enabled = 1,
        };

        void send_show_desktop_changed(uint32_t state);
        void send_show_desktop_changed(struct ::wl_resource *resource, uint32_t state);
        void send_window(uint32_t id);
        void send_window(struct ::wl_resource *resource, uint32_t id);
        void send_stacking_order_changed(const QByteArray &ids);
        void send_stacking_order_changed(struct ::wl_resource *resource, const QByteArray &ids);
        void send_stacking_order_uuid_changed(const QString &uuids);
        void send_stacking_order_uuid_changed(struct ::wl_resource *resource, const QString &uuids);
        void send_window_with_uuid(uint32_t id, const QString &uuid);
        void send_window_with_uuid(struct ::wl_resource *resource, uint32_t id, const QString &uuid);
        void send_stacking_order_changed_2();
        void send_stacking_order_changed_2(struct ::wl_resource *resource);

    protected:
        virtual Resource *org_kde_plasma_window_management_allocate();

        virtual void org_kde_plasma_window_management_destroy_global();

        virtual void org_kde_plasma_window_management_bind_resource(Resource *resource);
        virtual void org_kde_plasma_window_management_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_window_management_show_desktop(Resource *resource, uint32_t state);
        virtual void org_kde_plasma_window_management_get_window(Resource *resource, uint32_t id, uint32_t internal_window_id);
        virtual void org_kde_plasma_window_management_get_window_by_uuid(Resource *resource, uint32_t id, const QString &internal_window_uuid);
        virtual void org_kde_plasma_window_management_get_stacking_order(Resource *resource, uint32_t stacking_order);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_window_management_interface m_org_kde_plasma_window_management_interface;

        static void handle_show_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t state);
        static void handle_get_window(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            uint32_t internal_window_id);
        static void handle_get_window_by_uuid(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            const char *internal_window_uuid);
        static void handle_get_stacking_order(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t stacking_order);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_window_management *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_window
    {
    public:
        org_kde_plasma_window(struct ::wl_client *client, int id, int version);
        org_kde_plasma_window(struct ::wl_display *display, int version);
        org_kde_plasma_window(struct ::wl_resource *resource);
        org_kde_plasma_window();

        virtual ~org_kde_plasma_window();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_window_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_window *org_kde_plasma_window_object;
            org_kde_plasma_window *object() { return org_kde_plasma_window_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_title_changed(const QString &title);
        void send_title_changed(struct ::wl_resource *resource, const QString &title);
        void send_app_id_changed(const QString &app_id);
        void send_app_id_changed(struct ::wl_resource *resource, const QString &app_id);
        void send_state_changed(uint32_t flags);
        void send_state_changed(struct ::wl_resource *resource, uint32_t flags);
        void send_virtual_desktop_changed(int32_t number);
        void send_virtual_desktop_changed(struct ::wl_resource *resource, int32_t number);
        void send_themed_icon_name_changed(const QString &name);
        void send_themed_icon_name_changed(struct ::wl_resource *resource, const QString &name);
        void send_unmapped();
        void send_unmapped(struct ::wl_resource *resource);
        void send_initial_state();
        void send_initial_state(struct ::wl_resource *resource);
        void send_parent_window(struct ::wl_resource *parent);
        void send_parent_window(struct ::wl_resource *resource, struct ::wl_resource *parent);
        void send_geometry(int32_t x, int32_t y, uint32_t width, uint32_t height);
        void send_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, uint32_t width, uint32_t height);
        void send_icon_changed();
        void send_icon_changed(struct ::wl_resource *resource);
        void send_pid_changed(uint32_t pid);
        void send_pid_changed(struct ::wl_resource *resource, uint32_t pid);
        void send_virtual_desktop_entered(const QString &id);
        void send_virtual_desktop_entered(struct ::wl_resource *resource, const QString &id);
        void send_virtual_desktop_left(const QString &is);
        void send_virtual_desktop_left(struct ::wl_resource *resource, const QString &is);
        void send_application_menu(const QString &service_name, const QString &object_path);
        void send_application_menu(struct ::wl_resource *resource, const QString &service_name, const QString &object_path);
        void send_activity_entered(const QString &id);
        void send_activity_entered(struct ::wl_resource *resource, const QString &id);
        void send_activity_left(const QString &id);
        void send_activity_left(struct ::wl_resource *resource, const QString &id);
        void send_resource_name_changed(const QString &resource_name);
        void send_resource_name_changed(struct ::wl_resource *resource, const QString &resource_name);
        void send_client_geometry(int32_t x, int32_t y, uint32_t width, uint32_t height);
        void send_client_geometry(struct ::wl_resource *resource, int32_t x, int32_t y, uint32_t width, uint32_t height);

    protected:
        virtual Resource *org_kde_plasma_window_allocate();

        virtual void org_kde_plasma_window_destroy_global();

        virtual void org_kde_plasma_window_bind_resource(Resource *resource);
        virtual void org_kde_plasma_window_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_window_set_state(Resource *resource, uint32_t flags, uint32_t state);
        virtual void org_kde_plasma_window_set_virtual_desktop(Resource *resource, uint32_t number);
        virtual void org_kde_plasma_window_set_minimized_geometry(Resource *resource, struct ::wl_resource *panel, uint32_t x, uint32_t y, uint32_t width, uint32_t height);
        virtual void org_kde_plasma_window_unset_minimized_geometry(Resource *resource, struct ::wl_resource *panel);
        virtual void org_kde_plasma_window_close(Resource *resource);
        virtual void org_kde_plasma_window_request_move(Resource *resource);
        virtual void org_kde_plasma_window_request_resize(Resource *resource);
        virtual void org_kde_plasma_window_destroy(Resource *resource);
        virtual void org_kde_plasma_window_get_icon(Resource *resource, int32_t fd);
        virtual void org_kde_plasma_window_request_enter_virtual_desktop(Resource *resource, const QString &id);
        virtual void org_kde_plasma_window_request_enter_new_virtual_desktop(Resource *resource);
        virtual void org_kde_plasma_window_request_leave_virtual_desktop(Resource *resource, const QString &id);
        virtual void org_kde_plasma_window_request_enter_activity(Resource *resource, const QString &id);
        virtual void org_kde_plasma_window_request_leave_activity(Resource *resource, const QString &id);
        virtual void org_kde_plasma_window_send_to_output(Resource *resource, struct ::wl_resource *output);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_window_interface m_org_kde_plasma_window_interface;

        static void handle_set_state(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t flags,
            uint32_t state);
        static void handle_set_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t number);
        static void handle_set_minimized_geometry(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *panel,
            uint32_t x,
            uint32_t y,
            uint32_t width,
            uint32_t height);
        static void handle_unset_minimized_geometry(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *panel);
        static void handle_close(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_request_move(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_request_resize(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_icon(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t fd);
        static void handle_request_enter_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *id);
        static void handle_request_enter_new_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_request_leave_virtual_desktop(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *id);
        static void handle_request_enter_activity(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *id);
        static void handle_request_leave_activity(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *id);
        static void handle_send_to_output(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *output);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_window *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_activation_feedback
    {
    public:
        org_kde_plasma_activation_feedback(struct ::wl_client *client, int id, int version);
        org_kde_plasma_activation_feedback(struct ::wl_display *display, int version);
        org_kde_plasma_activation_feedback(struct ::wl_resource *resource);
        org_kde_plasma_activation_feedback();

        virtual ~org_kde_plasma_activation_feedback();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_activation_feedback_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_activation_feedback *org_kde_plasma_activation_feedback_object;
            org_kde_plasma_activation_feedback *object() { return org_kde_plasma_activation_feedback_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_activation(struct ::wl_resource *id);
        void send_activation(struct ::wl_resource *resource, struct ::wl_resource *id);

    protected:
        virtual Resource *org_kde_plasma_activation_feedback_allocate();

        virtual void org_kde_plasma_activation_feedback_destroy_global();

        virtual void org_kde_plasma_activation_feedback_bind_resource(Resource *resource);
        virtual void org_kde_plasma_activation_feedback_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_activation_feedback_destroy(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_activation_feedback_interface m_org_kde_plasma_activation_feedback_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_activation_feedback *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_activation
    {
    public:
        org_kde_plasma_activation(struct ::wl_client *client, int id, int version);
        org_kde_plasma_activation(struct ::wl_display *display, int version);
        org_kde_plasma_activation(struct ::wl_resource *resource);
        org_kde_plasma_activation();

        virtual ~org_kde_plasma_activation();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_activation_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_activation *org_kde_plasma_activation_object;
            org_kde_plasma_activation *object() { return org_kde_plasma_activation_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_app_id(const QString &app_id);
        void send_app_id(struct ::wl_resource *resource, const QString &app_id);
        void send_finished();
        void send_finished(struct ::wl_resource *resource);

    protected:
        virtual Resource *org_kde_plasma_activation_allocate();

        virtual void org_kde_plasma_activation_destroy_global();

        virtual void org_kde_plasma_activation_bind_resource(Resource *resource);
        virtual void org_kde_plasma_activation_destroy_resource(Resource *resource);

        virtual void org_kde_plasma_activation_destroy(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::org_kde_plasma_activation_interface m_org_kde_plasma_activation_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_activation *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  org_kde_plasma_stacking_order
    {
    public:
        org_kde_plasma_stacking_order(struct ::wl_client *client, int id, int version);
        org_kde_plasma_stacking_order(struct ::wl_display *display, int version);
        org_kde_plasma_stacking_order(struct ::wl_resource *resource);
        org_kde_plasma_stacking_order();

        virtual ~org_kde_plasma_stacking_order();

        class Resource
        {
        public:
            Resource() : org_kde_plasma_stacking_order_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            org_kde_plasma_stacking_order *org_kde_plasma_stacking_order_object;
            org_kde_plasma_stacking_order *object() { return org_kde_plasma_stacking_order_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_window(const QString &uuid);
        void send_window(struct ::wl_resource *resource, const QString &uuid);
        void send_done();
        void send_done(struct ::wl_resource *resource);

    protected:
        virtual Resource *org_kde_plasma_stacking_order_allocate();

        virtual void org_kde_plasma_stacking_order_destroy_global();

        virtual void org_kde_plasma_stacking_order_bind_resource(Resource *resource);
        virtual void org_kde_plasma_stacking_order_destroy_resource(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            org_kde_plasma_stacking_order *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
