
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmessagedialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "kpixmapregionselectordialog_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kguiitem.h>
#include <kmessagedialog.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMessageDialog_Type = nullptr;
static PyTypeObject *Sbk_KMessageDialog_TypeF(void)
{
    return _Sbk_KMessageDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMessageDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMessageDialogWrapper::KMessageDialogWrapper(::KMessageDialog::Type type, const ::QString & text, ::QWidget * parent) : KMessageDialog(type, text, parent)
{
}

KMessageDialogWrapper::KMessageDialogWrapper(::KMessageDialog::Type type, const ::QString & text, ::WId parent_id) : KMessageDialog(type, text, parent_id)
{
}

void KMessageDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMessageDialog", funcName, gil, pyOverride, signal);
}

void KMessageDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

int KMessageDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMessageDialog", funcName, gil, pyOverride, signal);
}

void KMessageDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KPixmapRegionSelectorDialogWrapper::sbk_o_done("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

bool KMessageDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KMessageDialog", funcName, gil, pyOverride, event);
}

bool KMessageDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMessageDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KMessageDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KPixmapRegionSelectorDialogWrapper::sbk_o_exec("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

bool KMessageDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMessageDialog", funcName, gil, pyOverride, next);
}

void KMessageDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

bool KMessageDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMessageDialog", funcName, gil, pyOverride);
}

int KMessageDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMessageDialog", funcName, gil, pyOverride, painter);
}

void KMessageDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

::QVariant KMessageDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

int KMessageDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KMessageDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

bool KMessageDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMessageDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KMessageDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMessageDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KMessageDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KMessageDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMessageDialog", funcName, gil, pyOverride, offset);
}

void KMessageDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMessageDialog", funcName, gil, pyOverride, arg__1);
}

void KMessageDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMessageDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KMessageDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::KMessageDialog::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

::QSize KMessageDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMessageDialog", funcName, gil, pyOverride);
}

void KMessageDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

void KMessageDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMessageDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMessageDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KMessageDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMessageDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMessageDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMessageDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMessageDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMessageDialogWrapper *>(this));
    }
    return KMessageDialog::qt_metacast(_clname);
}

KMessageDialogWrapper::~KMessageDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMessageDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMessageDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMessageDialog >()))
        return -1;

    KMessageDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KMessageDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMessageDialog::KMessageDialog(KMessageDialog::Type,QString,QWidget*=)
    // 1: KMessageDialog::KMessageDialog(KMessageDialog::Type,QString,WId)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_Type_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // KMessageDialog(KMessageDialog::Type,QString,QWidget*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtGuiTypeConverters[SBK_WId_IDX], (pyArgs[2])))) {
            overloadId = 1; // KMessageDialog(KMessageDialog::Type,QString,WId)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
            overloadId = 0; // KMessageDialog(KMessageDialog::Type,QString,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KMessageDialog(KMessageDialog::Type type, const QString &text, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
                }
            }
            ::KMessageDialog::Type cppArg0 = static_cast< ::KMessageDialog::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QWidget *cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMessageDialog(KMessageDialog::Type,QString,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMessageDialogWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMessageDialogWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 1: // KMessageDialog(KMessageDialog::Type type, const QString &text, WId parent_id)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
            }
            ::KMessageDialog::Type cppArg0 = static_cast< ::KMessageDialog::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::WId cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KMessageDialog(KMessageDialog::Type,QString,WId)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KMessageDialogWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KMessageDialogWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMessageDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMessageDialogFunc_beep(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:beep", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMessageDialog::beep(KMessageDialog::Type,const QString&=,QWidget*=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_Type_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // beep(KMessageDialog::Type,QString,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // beep(KMessageDialog::Type,QString,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2])))) {
                overloadId = 0; // beep(KMessageDialog::Type,QString,QWidget*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"text", 1}, {"dialog", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "beep", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
            }
        }
        ::KMessageDialog::Type cppArg0 = static_cast< ::KMessageDialog::Type>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // beep(KMessageDialog::Type,QString,QWidget*)
            ::KMessageDialog::beep(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_isDontAskAgainChecked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDontAskAgainChecked()const
        bool cppResult = const_cast<const ::KMessageDialog *>(cppSelf)->isDontAskAgainChecked();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageDialogFunc_isNotifyEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNotifyEnabled()const
        bool cppResult = const_cast<const ::KMessageDialog *>(cppSelf)->isNotifyEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMessageDialogFunc_setButtons(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setButtons", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMessageDialog::setButtons(KGuiItem,KGuiItem,KGuiItem)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setButtons(KGuiItem,KGuiItem,KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setButtons", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KGuiItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::KGuiItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::KGuiItem *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setButtons(KGuiItem,KGuiItem,KGuiItem)
            cppSelf->setButtons(*cppArg0, *cppArg1, *cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setCaption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setCaption(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setCaption(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCaption", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCaption(QString)
            cppSelf->setCaption(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setDetails(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setDetails(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDetails(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDetails", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDetails(QString)
            cppSelf->setDetails(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setDontAskAgainChecked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setDontAskAgainChecked(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDontAskAgainChecked(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDontAskAgainChecked", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDontAskAgainChecked(bool)
            cppSelf->setDontAskAgainChecked(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setDontAskAgainText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setDontAskAgainText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDontAskAgainText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDontAskAgainText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDontAskAgainText(QString)
            cppSelf->setDontAskAgainText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setListWidgetItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setListWidgetItems(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // setListWidgetItems(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setListWidgetItems", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setListWidgetItems(QStringList)
            cppSelf->setListWidgetItems(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setNotifyEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setNotifyEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setNotifyEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setNotifyEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setNotifyEnabled(bool)
            cppSelf->setNotifyEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_setOpenExternalLinks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KMessageDialog::setOpenExternalLinks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOpenExternalLinks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOpenExternalLinks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOpenExternalLinks(bool)
            cppSelf->setOpenExternalLinks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KMessageDialogFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KMessageDialog::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KMessageDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KMessageDialog_EnumFlagInfo[] = {
    "ButtonType:IntEnum",
    "Type:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMessageDialog_methods[] = {
    {"beep", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_beep), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"isDontAskAgainChecked", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_isDontAskAgainChecked), METH_NOARGS, nullptr},
    {"isNotifyEnabled", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_isNotifyEnabled), METH_NOARGS, nullptr},
    {"setButtons", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setButtons), METH_VARARGS, nullptr},
    {"setCaption", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setCaption), METH_O, nullptr},
    {"setDetails", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setDetails), METH_O, nullptr},
    {"setDontAskAgainChecked", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setDontAskAgainChecked), METH_O, nullptr},
    {"setDontAskAgainText", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setDontAskAgainText), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setIcon), METH_O, nullptr},
    {"setListWidgetItems", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setListWidgetItems), METH_O, nullptr},
    {"setNotifyEnabled", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setNotifyEnabled), METH_O, nullptr},
    {"setOpenExternalLinks", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_setOpenExternalLinks), METH_O, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_KMessageDialogFunc_showEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMessageDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMessageDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMessageDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMessageDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMessageDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMessageDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMessageDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMessageDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMessageDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMessageDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMessageDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMessageDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMessageDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMessageDialog_spec = {
    "1:KWidgetsAddons.KMessageDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMessageDialog_slots
};

} //extern "C"

static void *Sbk_KMessageDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMessageDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMessageDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMessageDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KMessageDialog_ButtonType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageDialog::ButtonType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageDialog::ButtonType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageDialog_ButtonType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_ButtonType_IDX])))
        return Enum_PythonToCpp_KMessageDialog_ButtonType;
    return {};
}

static PyObject *KMessageDialog_ButtonType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageDialog::ButtonType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageDialog::ButtonType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KMessageDialog_Type(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMessageDialog::Type>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMessageDialog::Type *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMessageDialog_Type_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_Type_IDX])))
        return Enum_PythonToCpp_KMessageDialog_Type;
    return {};
}

static PyObject *KMessageDialog_Type_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMessageDialog::Type>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMessageDialog::Type *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMessageDialog_PythonToCpp_KMessageDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMessageDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMessageDialog_PythonToCpp_KMessageDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMessageDialog_TypeF()))
        return KMessageDialog_PythonToCpp_KMessageDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMessageDialog_PTR_CppToPython_KMessageDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMessageDialog *>(const_cast<void *>(cppIn)), Sbk_KMessageDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMessageDialog_SignatureStrings[] = {
    "1:KWidgetsAddons.KMessageDialog(self,type:KWidgetsAddons.KMessageDialog.Type,text:QString,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:KWidgetsAddons.KMessageDialog(self,type:KWidgetsAddons.KMessageDialog.Type,text:QString,parent_id:WId)",
    "KWidgetsAddons.KMessageDialog.beep(type:KWidgetsAddons.KMessageDialog.Type,text:QString=QString(),dialog:PySide6.QtWidgets.QWidget=nullptr)",
    "KWidgetsAddons.KMessageDialog.isDontAskAgainChecked(self)->bool",
    "KWidgetsAddons.KMessageDialog.isNotifyEnabled(self)->bool",
    "KWidgetsAddons.KMessageDialog.setButtons(self,primaryAction:KWidgetsAddons.KGuiItem,secondaryAction:KWidgetsAddons.KGuiItem,cancelAction:KWidgetsAddons.KGuiItem)",
    "KWidgetsAddons.KMessageDialog.setCaption(self,caption:QString)",
    "KWidgetsAddons.KMessageDialog.setDetails(self,details:QString)",
    "KWidgetsAddons.KMessageDialog.setDontAskAgainChecked(self,isChecked:bool)",
    "KWidgetsAddons.KMessageDialog.setDontAskAgainText(self,dontAskAgainText:QString)",
    "KWidgetsAddons.KMessageDialog.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KMessageDialog.setListWidgetItems(self,strlist:QStringList)",
    "KWidgetsAddons.KMessageDialog.setNotifyEnabled(self,enable:bool)",
    "KWidgetsAddons.KMessageDialog.setOpenExternalLinks(self,isAllowed:bool)",
    "KWidgetsAddons.KMessageDialog.showEvent(self,event:PySide6.QtGui.QShowEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t KMessageDialog_SignatureByteSize = 372;
static constexpr uint8_t KMessageDialog_SignatureBytes[372] = {
    0x78, 0xda, 0xb5, 0x54, 0x4d, 0x6b, 0xc2, 0x40, 0x10, 0xbd, 0xfb, 0x2b, 0x7a, 0x34, 0xb0, 0x0d,
    0xed, 0xa5, 0x87, 0x80, 0x85, 0x54, 0xa5, 0x88, 0xb6, 0x35, 0x68, 0xe9, 0xa1, 0x94, 0xb2, 0x66,
    0xc7, 0x38, 0xb8, 0xee, 0x2e, 0xd9, 0xf1, 0x23, 0xff, 0xbe, 0x1b, 0x93, 0x50, 0xaa, 0x34, 0x26,
    0x85, 0x9e, 0xb2, 0x33, 0x79, 0x6f, 0xe6, 0xed, 0x9b, 0x61, 0x6f, 0x83, 0xf1, 0x1b, 0x8a, 0x04,
    0xc8, 0x86, 0x42, 0x68, 0x65, 0xfd, 0xf1, 0x13, 0x58, 0xcb, 0x13, 0x18, 0x20, 0x97, 0x3a, 0xe9,
    0x5a, 0x90, 0x4b, 0x46, 0x99, 0x81, 0x7a, 0x9c, 0x3f, 0x77, 0x10, 0x46, 0x70, 0xa0, 0x20, 0x9a,
    0x51, 0x8a, 0x2a, 0x61, 0x86, 0xa7, 0xa0, 0x28, 0x98, 0x66, 0x33, 0x14, 0x70, 0xe7, 0x47, 0x54,
    0xf2, 0xfd, 0xa8, 0x38, 0xf4, 0xd4, 0x56, 0x4a, 0x43, 0xa9, 0xd7, 0xb9, 0xf9, 0x67, 0x0d, 0x9f,
    0x28, 0x82, 0xb7, 0x91, 0xf0, 0x3a, 0xf5, 0xf4, 0x05, 0x80, 0xe9, 0xfe, 0xa5, 0x4d, 0xaf, 0xfc,
    0x76, 0x3d, 0x26, 0x8e, 0x90, 0x26, 0x97, 0xae, 0xef, 0x81, 0x76, 0xa0, 0x15, 0x85, 0x76, 0x1d,
    0x26, 0x1c, 0x55, 0x7f, 0x05, 0xf1, 0x1a, 0xc4, 0xd1, 0x08, 0xef, 0xfa, 0x7e, 0xa1, 0xb5, 0xbc,
    0xc8, 0x7f, 0xd6, 0x84, 0xcb, 0x6c, 0xa8, 0xf8, 0x42, 0xb6, 0x62, 0x5a, 0xa0, 0x87, 0x2d, 0x91,
    0xfb, 0x53, 0xf8, 0x6e, 0x52, 0xdc, 0xf0, 0x34, 0x0b, 0x63, 0x42, 0xad, 0xce, 0x9c, 0x79, 0xdc,
    0xe2, 0x88, 0x60, 0xc3, 0x2c, 0xc4, 0x5a, 0x89, 0xcb, 0xb8, 0x98, 0xab, 0x18, 0x64, 0x3d, 0xc8,
    0xbb, 0xac, 0xb0, 0xcf, 0x4d, 0x5e, 0xa1, 0x50, 0x18, 0x17, 0x41, 0x35, 0x8d, 0x06, 0xf4, 0x01,
    0x10, 0x47, 0x59, 0x5e, 0x50, 0x14, 0x41, 0x1b, 0xfa, 0x2f, 0xa3, 0x61, 0x68, 0xcb, 0x30, 0xc8,
    0x8d, 0x6e, 0x59, 0x69, 0xee, 0x36, 0xaa, 0x54, 0x74, 0x92, 0x6d, 0x21, 0x6d, 0x14, 0x57, 0xae,
    0xa0, 0x3b, 0x05, 0x6e, 0x9b, 0x1d, 0xcf, 0x7f, 0x55, 0xce, 0x9f, 0xf7, 0xef, 0xa5, 0x74, 0x46,
    0xfb, 0x51, 0x0e, 0x65, 0x57, 0x27, 0xc9, 0x29, 0x1e, 0x36, 0xdc, 0x7c, 0x34, 0xe8, 0x34, 0x41,
    0x5b, 0x2e, 0x77, 0x3e, 0xb3, 0xd2, 0x4b, 0x4b, 0xa9, 0x74, 0xf9, 0x4a, 0x70, 0x8e, 0x69, 0x50,
    0xea, 0x7c, 0x55, 0x19, 0x1c, 0x83, 0xa6, 0x36, 0xbe, 0x18, 0x50, 0xc3, 0x03, 0x41, 0xaa, 0xb8,
    0x9c, 0xa0, 0x5a, 0xdb, 0x6a, 0x1c, 0xa1, 0x94, 0x7a, 0xdf, 0x74, 0x1c, 0x2b, 0xbd, 0x1f, 0xee,
    0xdc, 0x73, 0x51, 0x2a, 0xd8, 0xfd, 0x7c, 0xbd, 0x8e, 0xf6, 0xcc, 0x2a, 0x8c, 0xd7, 0xf9, 0x02,
    0x54, 0xf3, 0xef, 0x42
};
#endif

PyTypeObject *init_KMessageDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KMessageDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))));

    _Sbk_KMessageDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMessageDialog",
        "KMessageDialog*",
        &Sbk_KMessageDialog_spec,
        &Shiboken::callCppDestructor< KMessageDialog >,
        Sbk_KMessageDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KMessageDialog_Type; // references _Sbk_KMessageDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMessageDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMessageDialog_SignatureBytes, KMessageDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMessageDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMessageDialog_PythonToCpp_KMessageDialog_PTR,
        is_KMessageDialog_PythonToCpp_KMessageDialog_PTR_Convertible,
        KMessageDialog_PTR_CppToPython_KMessageDialog);

    Shiboken::Conversions::registerConverterName(converter, "KMessageDialog");
    Shiboken::Conversions::registerConverterName(converter, "KMessageDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KMessageDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMessageDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMessageDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMessageDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMessageDialog_TypeF(), &Sbk_KMessageDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMessageDialog_TypeF(), &Sbk_KMessageDialog_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KMessageDialog_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ButtonType'.
    const char *ButtonType_Initializer[] = {
        "Ok",
        "Cancel",
        "PrimaryAction",
        "SecondaryAction",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ButtonType_InitializerValues[] = {
        uint8_t(KMessageDialog::ButtonType::Ok),             //  0x01  1
        uint8_t(KMessageDialog::ButtonType::Cancel),         //  0x02  2
        uint8_t(KMessageDialog::ButtonType::PrimaryAction),  //  0x03  3
        uint8_t(KMessageDialog::ButtonType::SecondaryAction) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageDialog_TypeF(),
        "1:KWidgetsAddons.KMessageDialog.ButtonType",
        ButtonType_Initializer, ButtonType_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_ButtonType_IDX].type = EType;
    // Register converter for enum 'KMessageDialog::ButtonType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageDialog_ButtonType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageDialog_ButtonType,
            is_Enum_PythonToCpp_KMessageDialog_ButtonType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageDialog::ButtonType");
        Shiboken::Conversions::registerConverterAlias(converter, "ButtonType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ButtonType' enum.

    // Initialization of enum 'Type'.
    const char *Type_Initializer[] = {
        "QuestionTwoActions",
        "QuestionTwoActionsCancel",
        "WarningTwoActions",
        "WarningTwoActionsCancel",
        "WarningContinueCancel",
        "Information",
        "Error",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Type_InitializerValues[] = {
        uint8_t(KMessageDialog::Type::QuestionTwoActions),       //  0x01  1
        uint8_t(KMessageDialog::Type::QuestionTwoActionsCancel), //  0x02  2
        uint8_t(KMessageDialog::Type::WarningTwoActions),        //  0x03  3
        uint8_t(KMessageDialog::Type::WarningTwoActionsCancel),  //  0x04  4
        uint8_t(KMessageDialog::Type::WarningContinueCancel),    //  0x05  5
        uint8_t(KMessageDialog::Type::Information),              //  0x06  6
        uint8_t(KMessageDialog::Type::Error)                     //  0x08  8
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMessageDialog_TypeF(),
        "1:KWidgetsAddons.KMessageDialog.Type",
        Type_Initializer, Type_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_Type_IDX].type = EType;
    // Register converter for enum 'KMessageDialog::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMessageDialog_Type_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMessageDialog_Type,
            is_Enum_PythonToCpp_KMessageDialog_Type_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMessageDialog::Type");
        Shiboken::Conversions::registerConverterAlias(converter, "Type");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::KMessageDialog::ButtonType >("KMessageDialog::ButtonType");
    qRegisterMetaType< ::KMessageDialog::Type >("KMessageDialog::Type");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMessageDialog::staticMetaObject, sizeof(KMessageDialogWrapper));

    return pyType;
}
