/* Generated by wayland-scanner 1.24.0 */

#ifndef PLASMA_WINDOW_MANAGEMENT_SERVER_PROTOCOL_H
#define PLASMA_WINDOW_MANAGEMENT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_plasma_window_management The plasma_window_management protocol
 * @section page_ifaces_plasma_window_management Interfaces
 * - @subpage page_iface_org_kde_plasma_window_management - application windows management
 * - @subpage page_iface_org_kde_plasma_window - interface to control application windows
 * - @subpage page_iface_org_kde_plasma_activation_feedback - activation feedback
 * - @subpage page_iface_org_kde_plasma_activation - 
 * - @subpage page_iface_org_kde_plasma_stacking_order - helper object for sending the stacking order
 * @section page_copyright_plasma_window_management Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2013-2014 Pier Luigi Fiorini
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_plasma_activation;
struct org_kde_plasma_activation_feedback;
struct org_kde_plasma_stacking_order;
struct org_kde_plasma_window;
struct org_kde_plasma_window_management;
struct wl_output;
struct wl_surface;

#ifndef ORG_KDE_PLASMA_WINDOW_MANAGEMENT_INTERFACE
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_INTERFACE
/**
 * @page page_iface_org_kde_plasma_window_management org_kde_plasma_window_management
 * @section page_iface_org_kde_plasma_window_management_desc Description
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_org_kde_plasma_window_management_api API
 * See @ref iface_org_kde_plasma_window_management.
 */
/**
 * @defgroup iface_org_kde_plasma_window_management The org_kde_plasma_window_management interface
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface org_kde_plasma_window_management_interface;
#endif
#ifndef ORG_KDE_PLASMA_WINDOW_INTERFACE
#define ORG_KDE_PLASMA_WINDOW_INTERFACE
/**
 * @page page_iface_org_kde_plasma_window org_kde_plasma_window
 * @section page_iface_org_kde_plasma_window_desc Description
 *
 * Manages and control an application window.
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_org_kde_plasma_window_api API
 * See @ref iface_org_kde_plasma_window.
 */
/**
 * @defgroup iface_org_kde_plasma_window The org_kde_plasma_window interface
 *
 * Manages and control an application window.
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface org_kde_plasma_window_interface;
#endif
#ifndef ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_INTERFACE
#define ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_INTERFACE
/**
 * @page page_iface_org_kde_plasma_activation_feedback org_kde_plasma_activation_feedback
 * @section page_iface_org_kde_plasma_activation_feedback_desc Description
 *
 * The activation manager interface provides a way to get notified
 * when an application is about to be activated.
 * @section page_iface_org_kde_plasma_activation_feedback_api API
 * See @ref iface_org_kde_plasma_activation_feedback.
 */
/**
 * @defgroup iface_org_kde_plasma_activation_feedback The org_kde_plasma_activation_feedback interface
 *
 * The activation manager interface provides a way to get notified
 * when an application is about to be activated.
 */
extern const struct wl_interface org_kde_plasma_activation_feedback_interface;
#endif
#ifndef ORG_KDE_PLASMA_ACTIVATION_INTERFACE
#define ORG_KDE_PLASMA_ACTIVATION_INTERFACE
/**
 * @page page_iface_org_kde_plasma_activation org_kde_plasma_activation
 * @section page_iface_org_kde_plasma_activation_api API
 * See @ref iface_org_kde_plasma_activation.
 */
/**
 * @defgroup iface_org_kde_plasma_activation The org_kde_plasma_activation interface
 */
extern const struct wl_interface org_kde_plasma_activation_interface;
#endif
#ifndef ORG_KDE_PLASMA_STACKING_ORDER_INTERFACE
#define ORG_KDE_PLASMA_STACKING_ORDER_INTERFACE
/**
 * @page page_iface_org_kde_plasma_stacking_order org_kde_plasma_stacking_order
 * @section page_iface_org_kde_plasma_stacking_order_desc Description
 *
 * When this object is created, the compositor sends a window event for
 * each window in the stacking order, and afterwards sends the done event
 * and destroys this object.
 * @section page_iface_org_kde_plasma_stacking_order_api API
 * See @ref iface_org_kde_plasma_stacking_order.
 */
/**
 * @defgroup iface_org_kde_plasma_stacking_order The org_kde_plasma_stacking_order interface
 *
 * When this object is created, the compositor sends a window event for
 * each window in the stacking order, and afterwards sends the done event
 * and destroys this object.
 */
extern const struct wl_interface org_kde_plasma_stacking_order_interface;
#endif

#ifndef ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM
enum org_kde_plasma_window_management_state {
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ACTIVE = 0x1,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MINIMIZED = 0x2,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MAXIMIZED = 0x4,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_FULLSCREEN = 0x8,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_KEEP_ABOVE = 0x10,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_KEEP_BELOW = 0x20,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ON_ALL_DESKTOPS = 0x40,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_DEMANDS_ATTENTION = 0x80,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_CLOSEABLE = 0x100,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MINIMIZABLE = 0x200,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MAXIMIZABLE = 0x400,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_FULLSCREENABLE = 0x800,
	/**
	 * @since 2
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPTASKBAR = 0x1000,
	/**
	 * @since 3
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADEABLE = 0x2000,
	/**
	 * @since 3
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADED = 0x4000,
	/**
	 * @since 3
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MOVABLE = 0x8000,
	/**
	 * @since 3
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_RESIZABLE = 0x10000,
	/**
	 * @since 3
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_VIRTUAL_DESKTOP_CHANGEABLE = 0x20000,
	/**
	 * @since 9
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPSWITCHER = 0x40000,
	/**
	 * @since 19
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_NO_BORDER = 0x80000,
	/**
	 * @since 19
	 */
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_CAN_SET_NO_BORDER = 0x100000,
};
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPTASKBAR_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADEABLE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADED_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MOVABLE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_RESIZABLE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_VIRTUAL_DESKTOP_CHANGEABLE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPSWITCHER_SINCE_VERSION 9
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_NO_BORDER_SINCE_VERSION 19
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_CAN_SET_NO_BORDER_SINCE_VERSION 19
#endif /* ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM */

#ifndef ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM_IS_VALID
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_plasma_window_management
 * Validate a org_kde_plasma_window_management state value.
 *
 * @return true on success, false on error.
 * @ref org_kde_plasma_window_management_state
 */
static inline bool
org_kde_plasma_window_management_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ACTIVE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MINIMIZED:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MAXIMIZED:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_FULLSCREEN:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_KEEP_ABOVE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_KEEP_BELOW:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ON_ALL_DESKTOPS:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_DEMANDS_ATTENTION:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_CLOSEABLE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MINIMIZABLE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MAXIMIZABLE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_FULLSCREENABLE:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPTASKBAR:
		return version >= 2;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADEABLE:
		return version >= 3;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SHADED:
		return version >= 3;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_MOVABLE:
		return version >= 3;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_RESIZABLE:
		return version >= 3;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_VIRTUAL_DESKTOP_CHANGEABLE:
		return version >= 3;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_SKIPSWITCHER:
		return version >= 9;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_NO_BORDER:
		return version >= 19;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_CAN_SET_NO_BORDER:
		return version >= 19;
	default:
		return false;
	}
}
#endif /* ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STATE_ENUM_IS_VALID */

#ifndef ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM
enum org_kde_plasma_window_management_show_desktop {
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_DISABLED = 0,
	ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENABLED = 1,
};
#endif /* ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM */

#ifndef ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM_IS_VALID
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_plasma_window_management
 * Validate a org_kde_plasma_window_management show_desktop value.
 *
 * @return true on success, false on error.
 * @ref org_kde_plasma_window_management_show_desktop
 */
static inline bool
org_kde_plasma_window_management_show_desktop_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_DISABLED:
		return version >= 1;
	case ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENABLED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_ENUM_IS_VALID */

/**
 * @ingroup iface_org_kde_plasma_window_management
 * @struct org_kde_plasma_window_management_interface
 */
struct org_kde_plasma_window_management_interface {
	/**
	 * show/hide the desktop
	 *
	 * Tell the compositor to show/hide the desktop.
	 * @param state requested state
	 */
	void (*show_desktop)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t state);
	/**
	 * deprecated
	 *
	 * Deprecated: use get_window_by_uuid
	 * @param internal_window_id The internal window id of the window to create
	 */
	void (*get_window)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t id,
			   uint32_t internal_window_id);
	/**
	 * @param internal_window_uuid The internal window uuiid of the window to create
	 * @since 12
	 */
	void (*get_window_by_uuid)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id,
				   const char *internal_window_uuid);
	/**
	 * get the stacking order
	 *
	 * 
	 * @since 17
	 */
	void (*get_stacking_order)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t stacking_order);
};

#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_CHANGED 0
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW 1
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED 2
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_UUID_CHANGED 3
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW_WITH_UUID 4
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED_2 5

/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED_SINCE_VERSION 11
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_UUID_CHANGED_SINCE_VERSION 12
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW_WITH_UUID_SINCE_VERSION 13
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED_2_SINCE_VERSION 17

/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_GET_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_GET_WINDOW_BY_UUID_SINCE_VERSION 12
/**
 * @ingroup iface_org_kde_plasma_window_management
 */
#define ORG_KDE_PLASMA_WINDOW_MANAGEMENT_GET_STACKING_ORDER_SINCE_VERSION 17

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an show_desktop_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param state new state
 */
static inline void
org_kde_plasma_window_management_send_show_desktop_changed(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_SHOW_DESKTOP_CHANGED, state);
}

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an window event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id Deprecated: internal window Id
 */
static inline void
org_kde_plasma_window_management_send_window(struct wl_resource *resource_, uint32_t id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW, id);
}

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an stacking_order_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param ids internal windows id array
 */
static inline void
org_kde_plasma_window_management_send_stacking_order_changed(struct wl_resource *resource_, struct wl_array *ids)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED, ids);
}

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an stacking_order_uuid_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuids internal windows id ;-separated
 */
static inline void
org_kde_plasma_window_management_send_stacking_order_uuid_changed(struct wl_resource *resource_, const char *uuids)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_UUID_CHANGED, uuids);
}

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an window_with_uuid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id Deprecated: internal window Id
 * @param uuid internal window uuid
 */
static inline void
org_kde_plasma_window_management_send_window_with_uuid(struct wl_resource *resource_, uint32_t id, const char *uuid)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_WINDOW_WITH_UUID, id, uuid);
}

/**
 * @ingroup iface_org_kde_plasma_window_management
 * Sends an stacking_order_changed_2 event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_management_send_stacking_order_changed_2(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_MANAGEMENT_STACKING_ORDER_CHANGED_2);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * @struct org_kde_plasma_window_interface
 */
struct org_kde_plasma_window_interface {
	/**
	 * set window state
	 *
	 * Set window state.
	 *
	 * Values for state argument are described by
	 * org_kde_plasma_window_management.state and can be used together
	 * in a bitfield. The flags bitfield describes which flags are
	 * supposed to be set, the state bitfield the value for the set
	 * flags
	 * @param flags bitfield of set state flags
	 * @param state bitfield of state flags
	 */
	void (*set_state)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t flags,
			  uint32_t state);
	/**
	 * map window on a virtual desktop
	 *
	 * Deprecated: use enter_virtual_desktop Maps the window to a
	 * different virtual desktop.
	 *
	 * To show the window on all virtual desktops, call the
	 * org_kde_plasma_window.set_state request and specify a
	 * on_all_desktops state in the bitfield.
	 * @param number zero based virtual desktop number
	 */
	void (*set_virtual_desktop)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t number);
	/**
	 * set the geometry for a taskbar entry
	 *
	 * Sets the geometry of the taskbar entry for this window. The
	 * geometry is relative to a panel in particular.
	 */
	void (*set_minimized_geometry)(struct wl_client *client,
				       struct wl_resource *resource,
				       struct wl_resource *panel,
				       uint32_t x,
				       uint32_t y,
				       uint32_t width,
				       uint32_t height);
	/**
	 * set the geometry for a taskbar entry
	 *
	 * Remove the task geometry information for a particular panel.
	 */
	void (*unset_minimized_geometry)(struct wl_client *client,
					 struct wl_resource *resource,
					 struct wl_resource *panel);
	/**
	 * close window
	 *
	 * Close this window.
	 */
	void (*close)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * request move
	 *
	 * Request an interactive move for this window.
	 * @since 3
	 */
	void (*request_move)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * request resize
	 *
	 * Request an interactive resize for this window.
	 * @since 3
	 */
	void (*request_resize)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * remove resource for the org_kde_plasma_window
	 *
	 * Removes the resource bound for this org_kde_plasma_window.
	 * @since 4
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Requests to get the window icon
	 *
	 * The compositor will write the window icon into the provided
	 * file descriptor. The data is a serialized QIcon with
	 * QDataStream.
	 * @param fd file descriptor for the icon
	 * @since 7
	 */
	void (*get_icon)(struct wl_client *client,
			 struct wl_resource *resource,
			 int32_t fd);
	/**
	 * map window on a virtual desktop
	 *
	 * Make the window enter a virtual desktop. A window can enter
	 * more than one virtual desktop. if the id is empty or invalid, no
	 * action will be performed.
	 * @param id desktop id
	 * @since 8
	 */
	void (*request_enter_virtual_desktop)(struct wl_client *client,
					      struct wl_resource *resource,
					      const char *id);
	/**
	 * map window on a virtual desktop
	 *
	 * RFC: do this with an empty id to
	 * request_enter_virtual_desktop? Make the window enter a new
	 * virtual desktop. If the server consents the request, it will
	 * create a new virtual desktop and assign the window to it.
	 * @since 8
	 */
	void (*request_enter_new_virtual_desktop)(struct wl_client *client,
						  struct wl_resource *resource);
	/**
	 * remove a window from a virtual desktop
	 *
	 * Make the window exit a virtual desktop. If it exits all
	 * desktops it will be considered on all of them.
	 * @param id desktop id
	 * @since 8
	 */
	void (*request_leave_virtual_desktop)(struct wl_client *client,
					      struct wl_resource *resource,
					      const char *id);
	/**
	 * map window on an activity
	 *
	 * Make the window enter an activity. A window can enter more
	 * activity. If the id is empty or invalid, no action will be
	 * performed.
	 * @param id activity id
	 * @since 14
	 */
	void (*request_enter_activity)(struct wl_client *client,
				       struct wl_resource *resource,
				       const char *id);
	/**
	 * remove a window from an activity
	 *
	 * Make the window exit a an activity. If it exits all activities
	 * it will be considered on all of them.
	 * @param id activity id
	 * @since 14
	 */
	void (*request_leave_activity)(struct wl_client *client,
				       struct wl_resource *resource,
				       const char *id);
	/**
	 * send window to specified output
	 *
	 * Requests this window to be displayed in a specific output.
	 * @since 15
	 */
	void (*send_to_output)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *output);
};

#define ORG_KDE_PLASMA_WINDOW_TITLE_CHANGED 0
#define ORG_KDE_PLASMA_WINDOW_APP_ID_CHANGED 1
#define ORG_KDE_PLASMA_WINDOW_STATE_CHANGED 2
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_CHANGED 3
#define ORG_KDE_PLASMA_WINDOW_THEMED_ICON_NAME_CHANGED 4
#define ORG_KDE_PLASMA_WINDOW_UNMAPPED 5
#define ORG_KDE_PLASMA_WINDOW_INITIAL_STATE 6
#define ORG_KDE_PLASMA_WINDOW_PARENT_WINDOW 7
#define ORG_KDE_PLASMA_WINDOW_GEOMETRY 8
#define ORG_KDE_PLASMA_WINDOW_ICON_CHANGED 9
#define ORG_KDE_PLASMA_WINDOW_PID_CHANGED 10
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_ENTERED 11
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_LEFT 12
#define ORG_KDE_PLASMA_WINDOW_APPLICATION_MENU 13
#define ORG_KDE_PLASMA_WINDOW_ACTIVITY_ENTERED 14
#define ORG_KDE_PLASMA_WINDOW_ACTIVITY_LEFT 15
#define ORG_KDE_PLASMA_WINDOW_RESOURCE_NAME_CHANGED 16
#define ORG_KDE_PLASMA_WINDOW_CLIENT_GEOMETRY 17

/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_TITLE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_APP_ID_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_STATE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_THEMED_ICON_NAME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_UNMAPPED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_INITIAL_STATE_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_PARENT_WINDOW_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_GEOMETRY_SINCE_VERSION 6
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_ICON_CHANGED_SINCE_VERSION 7
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_PID_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_ENTERED_SINCE_VERSION 8
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_LEFT_SINCE_VERSION 8
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_APPLICATION_MENU_SINCE_VERSION 10
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_ACTIVITY_ENTERED_SINCE_VERSION 14
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_ACTIVITY_LEFT_SINCE_VERSION 14
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_RESOURCE_NAME_CHANGED_SINCE_VERSION 16
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_CLIENT_GEOMETRY_SINCE_VERSION 18

/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_SET_VIRTUAL_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_SET_MINIMIZED_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_UNSET_MINIMIZED_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_MOVE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_RESIZE_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_DESTROY_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_GET_ICON_SINCE_VERSION 7
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_ENTER_VIRTUAL_DESKTOP_SINCE_VERSION 8
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_ENTER_NEW_VIRTUAL_DESKTOP_SINCE_VERSION 8
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_LEAVE_VIRTUAL_DESKTOP_SINCE_VERSION 8
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_ENTER_ACTIVITY_SINCE_VERSION 14
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_REQUEST_LEAVE_ACTIVITY_SINCE_VERSION 14
/**
 * @ingroup iface_org_kde_plasma_window
 */
#define ORG_KDE_PLASMA_WINDOW_SEND_TO_OUTPUT_SINCE_VERSION 15

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an title_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param title window title
 */
static inline void
org_kde_plasma_window_send_title_changed(struct wl_resource *resource_, const char *title)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_TITLE_CHANGED, title);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an app_id_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_send_app_id_changed(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_APP_ID_CHANGED, app_id);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an state_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags bitfield of state flags
 */
static inline void
org_kde_plasma_window_send_state_changed(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_STATE_CHANGED, flags);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an virtual_desktop_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param number zero based virtual desktop number
 */
static inline void
org_kde_plasma_window_send_virtual_desktop_changed(struct wl_resource *resource_, int32_t number)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_CHANGED, number);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an themed_icon_name_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name the new themed icon name
 */
static inline void
org_kde_plasma_window_send_themed_icon_name_changed(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_THEMED_ICON_NAME_CHANGED, name);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an unmapped event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_send_unmapped(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_UNMAPPED);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an initial_state event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_send_initial_state(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_INITIAL_STATE);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an parent_window event to the client owning the resource.
 * @param resource_ The client's resource
 * @param parent The parent window
 */
static inline void
org_kde_plasma_window_send_parent_window(struct wl_resource *resource_, struct wl_resource *parent)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_PARENT_WINDOW, parent);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x position of the org_kde_plasma_window
 * @param y y position of the org_kde_plasma_window
 * @param width width of the org_kde_plasma_window
 * @param height height of the org_kde_plasma_window
 */
static inline void
org_kde_plasma_window_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, uint32_t width, uint32_t height)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_GEOMETRY, x, y, width, height);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an icon_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_send_icon_changed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_ICON_CHANGED);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an pid_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param pid process id
 */
static inline void
org_kde_plasma_window_send_pid_changed(struct wl_resource *resource_, uint32_t pid)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_PID_CHANGED, pid);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an virtual_desktop_entered event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id desktop id
 */
static inline void
org_kde_plasma_window_send_virtual_desktop_entered(struct wl_resource *resource_, const char *id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_ENTERED, id);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an virtual_desktop_left event to the client owning the resource.
 * @param resource_ The client's resource
 * @param is desktop id
 */
static inline void
org_kde_plasma_window_send_virtual_desktop_left(struct wl_resource *resource_, const char *is)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_VIRTUAL_DESKTOP_LEFT, is);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an application_menu event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_window_send_application_menu(struct wl_resource *resource_, const char *service_name, const char *object_path)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_APPLICATION_MENU, service_name, object_path);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an activity_entered event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id activity id
 */
static inline void
org_kde_plasma_window_send_activity_entered(struct wl_resource *resource_, const char *id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_ACTIVITY_ENTERED, id);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an activity_left event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id activity id
 */
static inline void
org_kde_plasma_window_send_activity_left(struct wl_resource *resource_, const char *id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_ACTIVITY_LEFT, id);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an resource_name_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param resource_name resource name
 */
static inline void
org_kde_plasma_window_send_resource_name_changed(struct wl_resource *resource_, const char *resource_name)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_RESOURCE_NAME_CHANGED, resource_name);
}

/**
 * @ingroup iface_org_kde_plasma_window
 * Sends an client_geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x position of the org_kde_plasma_window
 * @param y y position of the org_kde_plasma_window
 * @param width width of the org_kde_plasma_window
 * @param height height of the org_kde_plasma_window
 */
static inline void
org_kde_plasma_window_send_client_geometry(struct wl_resource *resource_, int32_t x, int32_t y, uint32_t width, uint32_t height)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_WINDOW_CLIENT_GEOMETRY, x, y, width, height);
}

/**
 * @ingroup iface_org_kde_plasma_activation_feedback
 * @struct org_kde_plasma_activation_feedback_interface
 */
struct org_kde_plasma_activation_feedback_interface {
	/**
	 * destroy the activation manager object
	 *
	 * Destroy the activation manager object. The activation objects
	 * introduced by this manager object will be unaffected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_ACTIVATION 0

/**
 * @ingroup iface_org_kde_plasma_activation_feedback
 */
#define ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_ACTIVATION_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_activation_feedback
 */
#define ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_activation_feedback
 * Sends an activation event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_activation_feedback_send_activation(struct wl_resource *resource_, struct wl_resource *id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_ACTIVATION_FEEDBACK_ACTIVATION, id);
}

/**
 * @ingroup iface_org_kde_plasma_activation
 * @struct org_kde_plasma_activation_interface
 */
struct org_kde_plasma_activation_interface {
	/**
	 * destroy the org_kde_plasma_activation object
	 *
	 * Notify the compositor that the org_kde_plasma_activation
	 * object will no longer be used.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ORG_KDE_PLASMA_ACTIVATION_APP_ID 0
#define ORG_KDE_PLASMA_ACTIVATION_FINISHED 1

/**
 * @ingroup iface_org_kde_plasma_activation
 */
#define ORG_KDE_PLASMA_ACTIVATION_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_activation
 */
#define ORG_KDE_PLASMA_ACTIVATION_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_activation
 */
#define ORG_KDE_PLASMA_ACTIVATION_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_plasma_activation
 * Sends an app_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param app_id application id, as described in xdg_activation_v1
 */
static inline void
org_kde_plasma_activation_send_app_id(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_ACTIVATION_APP_ID, app_id);
}

/**
 * @ingroup iface_org_kde_plasma_activation
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_activation_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_ACTIVATION_FINISHED);
}

#define ORG_KDE_PLASMA_STACKING_ORDER_WINDOW 0
#define ORG_KDE_PLASMA_STACKING_ORDER_DONE 1

/**
 * @ingroup iface_org_kde_plasma_stacking_order
 */
#define ORG_KDE_PLASMA_STACKING_ORDER_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_stacking_order
 */
#define ORG_KDE_PLASMA_STACKING_ORDER_DONE_SINCE_VERSION 1


/**
 * @ingroup iface_org_kde_plasma_stacking_order
 * Sends an window event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuid window uuid
 */
static inline void
org_kde_plasma_stacking_order_send_window(struct wl_resource *resource_, const char *uuid)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_STACKING_ORDER_WINDOW, uuid);
}

/**
 * @ingroup iface_org_kde_plasma_stacking_order
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_stacking_order_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_STACKING_ORDER_DONE);
}

#ifdef  __cplusplus
}
#endif

#endif
