/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// PodCertificateProjectionApplyConfiguration represents a declarative configuration of the PodCertificateProjection type for use
// with apply.
//
// PodCertificateProjection provides a private key and X.509 certificate in the
// pod filesystem.
type PodCertificateProjectionApplyConfiguration struct {
	// Kubelet's generated CSRs will be addressed to this signer.
	SignerName *string `json:"signerName,omitempty"`
	// The type of keypair Kubelet will generate for the pod.
	//
	// Valid values are "RSA3072", "RSA4096", "ECDSAP256", "ECDSAP384",
	// "ECDSAP521", and "ED25519".
	KeyType *string `json:"keyType,omitempty"`
	// maxExpirationSeconds is the maximum lifetime permitted for the
	// certificate.
	//
	// Kubelet copies this value verbatim into the PodCertificateRequests it
	// generates for this projection.
	//
	// If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver
	// will reject values shorter than 3600 (1 hour).  The maximum allowable
	// value is 7862400 (91 days).
	//
	// The signer implementation is then free to issue a certificate with any
	// lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600
	// seconds (1 hour).  This constraint is enforced by kube-apiserver.
	// `kubernetes.io` signers will never issue certificates with a lifetime
	// longer than 24 hours.
	MaxExpirationSeconds *int32 `json:"maxExpirationSeconds,omitempty"`
	// Write the credential bundle at this path in the projected volume.
	//
	// The credential bundle is a single file that contains multiple PEM blocks.
	// The first PEM block is a PRIVATE KEY block, containing a PKCS#8 private
	// key.
	//
	// The remaining blocks are CERTIFICATE blocks, containing the issued
	// certificate chain from the signer (leaf and any intermediates).
	//
	// Using credentialBundlePath lets your Pod's application code make a single
	// atomic read that retrieves a consistent key and certificate chain.  If you
	// project them to separate files, your application code will need to
	// additionally check that the leaf certificate was issued to the key.
	CredentialBundlePath *string `json:"credentialBundlePath,omitempty"`
	// Write the key at this path in the projected volume.
	//
	// Most applications should use credentialBundlePath.  When using keyPath
	// and certificateChainPath, your application needs to check that the key
	// and leaf certificate are consistent, because it is possible to read the
	// files mid-rotation.
	KeyPath *string `json:"keyPath,omitempty"`
	// Write the certificate chain at this path in the projected volume.
	//
	// Most applications should use credentialBundlePath.  When using keyPath
	// and certificateChainPath, your application needs to check that the key
	// and leaf certificate are consistent, because it is possible to read the
	// files mid-rotation.
	CertificateChainPath *string `json:"certificateChainPath,omitempty"`
	// userAnnotations allow pod authors to pass additional information to
	// the signer implementation.  Kubernetes does not restrict or validate this
	// metadata in any way.
	//
	// These values are copied verbatim into the `spec.unverifiedUserAnnotations` field of
	// the PodCertificateRequest objects that Kubelet creates.
	//
	// Entries are subject to the same validation as object metadata annotations,
	// with the addition that all keys must be domain-prefixed. No restrictions
	// are placed on values, except an overall size limitation on the entire field.
	//
	// Signers should document the keys and values they support. Signers should
	// deny requests that contain keys they do not recognize.
	UserAnnotations map[string]string `json:"userAnnotations,omitempty"`
}

// PodCertificateProjectionApplyConfiguration constructs a declarative configuration of the PodCertificateProjection type for use with
// apply.
func PodCertificateProjection() *PodCertificateProjectionApplyConfiguration {
	return &PodCertificateProjectionApplyConfiguration{}
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithSignerName(value string) *PodCertificateProjectionApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithKeyType sets the KeyType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeyType field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithKeyType(value string) *PodCertificateProjectionApplyConfiguration {
	b.KeyType = &value
	return b
}

// WithMaxExpirationSeconds sets the MaxExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxExpirationSeconds field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithMaxExpirationSeconds(value int32) *PodCertificateProjectionApplyConfiguration {
	b.MaxExpirationSeconds = &value
	return b
}

// WithCredentialBundlePath sets the CredentialBundlePath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CredentialBundlePath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithCredentialBundlePath(value string) *PodCertificateProjectionApplyConfiguration {
	b.CredentialBundlePath = &value
	return b
}

// WithKeyPath sets the KeyPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the KeyPath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithKeyPath(value string) *PodCertificateProjectionApplyConfiguration {
	b.KeyPath = &value
	return b
}

// WithCertificateChainPath sets the CertificateChainPath field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CertificateChainPath field is set to the value of the last call.
func (b *PodCertificateProjectionApplyConfiguration) WithCertificateChainPath(value string) *PodCertificateProjectionApplyConfiguration {
	b.CertificateChainPath = &value
	return b
}

// WithUserAnnotations puts the entries into the UserAnnotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the UserAnnotations field,
// overwriting an existing map entries in UserAnnotations field with the same key.
func (b *PodCertificateProjectionApplyConfiguration) WithUserAnnotations(entries map[string]string) *PodCertificateProjectionApplyConfiguration {
	if b.UserAnnotations == nil && len(entries) > 0 {
		b.UserAnnotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.UserAnnotations[k] = v
	}
	return b
}
