//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/cache/file_system_http_cache/v3/file_system_http_cache.proto

package file_system_http_cachev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on FileSystemHttpCacheConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *FileSystemHttpCacheConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FileSystemHttpCacheConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FileSystemHttpCacheConfigMultiError, or nil if none found.
func (m *FileSystemHttpCacheConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *FileSystemHttpCacheConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetManagerConfig() == nil {
		err := FileSystemHttpCacheConfigValidationError{
			field:  "ManagerConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetManagerConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "ManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "ManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetManagerConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "ManagerConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetCachePath()) < 1 {
		err := FileSystemHttpCacheConfigValidationError{
			field:  "CachePath",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMaxCacheSizeBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxCacheSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxCacheSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxCacheSizeBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "MaxCacheSizeBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxIndividualCacheEntrySizeBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxIndividualCacheEntrySizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxIndividualCacheEntrySizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxIndividualCacheEntrySizeBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "MaxIndividualCacheEntrySizeBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxCacheEntryCount()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxCacheEntryCount",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxCacheEntryCount",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxCacheEntryCount()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "MaxCacheEntryCount",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CacheSubdivisions

	// no validation rules for EvictFraction

	if all {
		switch v := interface{}(m.GetMaxEvictionPeriod()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MaxEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxEvictionPeriod()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "MaxEvictionPeriod",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMinEvictionPeriod()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MinEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheConfigValidationError{
					field:  "MinEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMinEvictionPeriod()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheConfigValidationError{
				field:  "MinEvictionPeriod",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CreateCachePath

	if len(errors) > 0 {
		return FileSystemHttpCacheConfigMultiError(errors)
	}

	return nil
}

// FileSystemHttpCacheConfigMultiError is an error wrapping multiple validation
// errors returned by FileSystemHttpCacheConfig.ValidateAll() if the
// designated constraints aren't met.
type FileSystemHttpCacheConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FileSystemHttpCacheConfigMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FileSystemHttpCacheConfigMultiError) AllErrors() []error { return m }

// FileSystemHttpCacheConfigValidationError is the validation error returned by
// FileSystemHttpCacheConfig.Validate if the designated constraints aren't met.
type FileSystemHttpCacheConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FileSystemHttpCacheConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FileSystemHttpCacheConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FileSystemHttpCacheConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FileSystemHttpCacheConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FileSystemHttpCacheConfigValidationError) ErrorName() string {
	return "FileSystemHttpCacheConfigValidationError"
}

// Error satisfies the builtin error interface
func (e FileSystemHttpCacheConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFileSystemHttpCacheConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FileSystemHttpCacheConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FileSystemHttpCacheConfigValidationError{}
