/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// CheckError struct for CheckError
type CheckError struct {
	InputError    *ErrorCode         `json:"input_error,omitempty" yaml:"input_error,omitempty"`
	InternalError *InternalErrorCode `json:"internal_error,omitempty" yaml:"internal_error,omitempty"`
	Message       *string            `json:"message,omitempty" yaml:"message,omitempty"`
}

// NewCheckError instantiates a new CheckError object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCheckError() *CheckError {
	this := CheckError{}
	var inputError = ERRORCODE_NO_ERROR
	this.InputError = &inputError
	var internalError = INTERNALERRORCODE_NO_INTERNAL_ERROR
	this.InternalError = &internalError
	return &this
}

// NewCheckErrorWithDefaults instantiates a new CheckError object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCheckErrorWithDefaults() *CheckError {
	this := CheckError{}
	var inputError = ERRORCODE_NO_ERROR
	this.InputError = &inputError
	var internalError = INTERNALERRORCODE_NO_INTERNAL_ERROR
	this.InternalError = &internalError
	return &this
}

// GetInputError returns the InputError field value if set, zero value otherwise.
func (o *CheckError) GetInputError() ErrorCode {
	if o == nil || o.InputError == nil {
		var ret ErrorCode
		return ret
	}
	return *o.InputError
}

// GetInputErrorOk returns a tuple with the InputError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CheckError) GetInputErrorOk() (*ErrorCode, bool) {
	if o == nil || o.InputError == nil {
		return nil, false
	}
	return o.InputError, true
}

// HasInputError returns a boolean if a field has been set.
func (o *CheckError) HasInputError() bool {
	if o != nil && o.InputError != nil {
		return true
	}

	return false
}

// SetInputError gets a reference to the given ErrorCode and assigns it to the InputError field.
func (o *CheckError) SetInputError(v ErrorCode) {
	o.InputError = &v
}

// GetInternalError returns the InternalError field value if set, zero value otherwise.
func (o *CheckError) GetInternalError() InternalErrorCode {
	if o == nil || o.InternalError == nil {
		var ret InternalErrorCode
		return ret
	}
	return *o.InternalError
}

// GetInternalErrorOk returns a tuple with the InternalError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CheckError) GetInternalErrorOk() (*InternalErrorCode, bool) {
	if o == nil || o.InternalError == nil {
		return nil, false
	}
	return o.InternalError, true
}

// HasInternalError returns a boolean if a field has been set.
func (o *CheckError) HasInternalError() bool {
	if o != nil && o.InternalError != nil {
		return true
	}

	return false
}

// SetInternalError gets a reference to the given InternalErrorCode and assigns it to the InternalError field.
func (o *CheckError) SetInternalError(v InternalErrorCode) {
	o.InternalError = &v
}

// GetMessage returns the Message field value if set, zero value otherwise.
func (o *CheckError) GetMessage() string {
	if o == nil || o.Message == nil {
		var ret string
		return ret
	}
	return *o.Message
}

// GetMessageOk returns a tuple with the Message field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CheckError) GetMessageOk() (*string, bool) {
	if o == nil || o.Message == nil {
		return nil, false
	}
	return o.Message, true
}

// HasMessage returns a boolean if a field has been set.
func (o *CheckError) HasMessage() bool {
	if o != nil && o.Message != nil {
		return true
	}

	return false
}

// SetMessage gets a reference to the given string and assigns it to the Message field.
func (o *CheckError) SetMessage(v string) {
	o.Message = &v
}

func (o CheckError) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.InputError != nil {
		toSerialize["input_error"] = o.InputError
	}
	if o.InternalError != nil {
		toSerialize["internal_error"] = o.InternalError
	}
	if o.Message != nil {
		toSerialize["message"] = o.Message
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableCheckError struct {
	value *CheckError
	isSet bool
}

func (v NullableCheckError) Get() *CheckError {
	return v.value
}

func (v *NullableCheckError) Set(val *CheckError) {
	v.value = val
	v.isSet = true
}

func (v NullableCheckError) IsSet() bool {
	return v.isSet
}

func (v *NullableCheckError) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCheckError(val *CheckError) *NullableCheckError {
	return &NullableCheckError{value: val, isSet: true}
}

func (v NullableCheckError) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCheckError) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
