module Main (main) where

import Control.Monad (when, void)
import Graphics.Vty
import System.IO

main :: IO ()
main = do
    flushInput stdin
    vty <- mkVty defaultConfig
    shutdown vty

flushInput :: Handle -> IO ()
flushInput h = do
    mode <- hGetBuffering h
    hSetBuffering h NoBuffering
    whileM $ consume h
    hSetBuffering h mode

whileM :: (Monad m) => m Bool -> m ()
whileM act = do
    continue <- act
    when continue $ whileM act

consume :: Handle -> IO Bool
consume h = do
    ava <- hReady h
    when ava $ void $ hGetChar h
    pure ava
