{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoScriptIter@ is used to iterate through a string
-- and identify ranges in different scripts.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.ScriptIter
    ( 

-- * Exported types
    ScriptIter(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [free]("GI.Pango.Structs.ScriptIter#g:method:free"), [next]("GI.Pango.Structs.ScriptIter#g:method:next").
-- 
-- ==== Getters
-- [getRange]("GI.Pango.Structs.ScriptIter#g:method:getRange").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveScriptIterMethod                 ,
#endif

-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    ScriptIterFreeMethodInfo                ,
#endif
    scriptIterFree                          ,


-- ** getRange #method:getRange#

#if defined(ENABLE_OVERLOADING)
    ScriptIterGetRangeMethodInfo            ,
#endif
    scriptIterGetRange                      ,


-- ** new #method:new#

    scriptIterNew                           ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    ScriptIterNextMethodInfo                ,
#endif
    scriptIterNext                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype ScriptIter = ScriptIter (SP.ManagedPtr ScriptIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype ScriptIter where
    toManagedPtr (ScriptIter p) = p

foreign import ccall "pango_script_iter_get_type" c_pango_script_iter_get_type :: 
    IO GType

type instance O.ParentTypes ScriptIter = '[]
instance O.HasParentTypes ScriptIter

instance B.Types.TypedObject ScriptIter where
    glibType = c_pango_script_iter_get_type

instance B.Types.GBoxed ScriptIter

-- | Convert t'ScriptIter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ScriptIter) where
    gvalueGType_ = c_pango_script_iter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ScriptIter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ScriptIter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ScriptIter ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ScriptIter
type instance O.AttributeList ScriptIter = ScriptIterAttributeList
type ScriptIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ScriptIter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "length of @text, or -1 if @text is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "ScriptIter" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_script_iter_new" pango_script_iter_new :: 
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- length : TBasicType TInt
    IO (Ptr ScriptIter)

-- | Create a new @PangoScriptIter@, used to break a string of
-- Unicode text into runs by Unicode script.
-- 
-- No copy is made of /@text@/, so the caller needs to make
-- sure it remains valid until the iterator is freed with
-- 'GI.Pango.Structs.ScriptIter.scriptIterFree'.
-- 
-- /Since: 1.4/
scriptIterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@text@/: a UTF-8 string
    -> Int32
    -- ^ /@length@/: length of /@text@/, or -1 if /@text@/ is nul-terminated
    -> m ScriptIter
    -- ^ __Returns:__ the new script iterator, initialized
    --  to point at the first range in the text, which should be
    --  freed with 'GI.Pango.Structs.ScriptIter.scriptIterFree'. If the string is
    --  empty, it will point at an empty range.
scriptIterNew text length_ = liftIO $ do
    text' <- textToCString text
    result <- pango_script_iter_new text' length_
    checkUnexpectedReturnNULL "scriptIterNew" result
    result' <- (wrapBoxed ScriptIter) result
    freeMem text'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ScriptIter::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "ScriptIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoScriptIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_script_iter_free" pango_script_iter_free :: 
    Ptr ScriptIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "ScriptIter"})
    IO ()

-- | Frees a @PangoScriptIter@.
-- 
-- /Since: 1.4/
scriptIterFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScriptIter
    -- ^ /@iter@/: a @PangoScriptIter@
    -> m ()
scriptIterFree iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    pango_script_iter_free iter'
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
data ScriptIterFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ScriptIterFreeMethodInfo ScriptIter signature where
    overloadedMethod = scriptIterFree

instance O.OverloadedMethodInfo ScriptIterFreeMethodInfo ScriptIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.ScriptIter.scriptIterFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-ScriptIter.html#v:scriptIterFree"
        })


#endif

-- method ScriptIter::get_range
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "ScriptIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoScriptIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store start\n  position of the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store end position\n  of the range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "script"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "Script" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store script for range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_script_iter_get_range" pango_script_iter_get_range :: 
    Ptr ScriptIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "ScriptIter"})
    Ptr CString ->                          -- start : TBasicType TUTF8
    Ptr CString ->                          -- end : TBasicType TUTF8
    Ptr CInt ->                             -- script : TInterface (Name {namespace = "Pango", name = "Script"})
    IO ()

-- | Gets information about the range to which /@iter@/ currently points.
-- 
-- The range is the set of locations p where *start \<= p \< *end.
-- (That is, it doesn\'t include the character stored at *end)
-- 
-- Note that while the type of the /@script@/ argument is declared
-- as @PangoScript@, as of Pango 1.18, this function simply returns
-- @GUnicodeScript@ values. Callers must be prepared to handle unknown
-- values.
-- 
-- /Since: 1.4/
scriptIterGetRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScriptIter
    -- ^ /@iter@/: a @PangoScriptIter@
    -> m ((T.Text, T.Text, Pango.Enums.Script))
scriptIterGetRange iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    start <- callocMem :: IO (Ptr CString)
    end <- callocMem :: IO (Ptr CString)
    script <- allocMem :: IO (Ptr CInt)
    pango_script_iter_get_range iter' start end script
    start' <- peek start
    start'' <- cstringToText start'
    end' <- peek end
    end'' <- cstringToText end'
    script' <- peek script
    let script'' = (toEnum . fromIntegral) script'
    touchManagedPtr iter
    freeMem start
    freeMem end
    freeMem script
    return (start'', end'', script'')

#if defined(ENABLE_OVERLOADING)
data ScriptIterGetRangeMethodInfo
instance (signature ~ (m ((T.Text, T.Text, Pango.Enums.Script))), MonadIO m) => O.OverloadedMethod ScriptIterGetRangeMethodInfo ScriptIter signature where
    overloadedMethod = scriptIterGetRange

instance O.OverloadedMethodInfo ScriptIterGetRangeMethodInfo ScriptIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.ScriptIter.scriptIterGetRange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-ScriptIter.html#v:scriptIterGetRange"
        })


#endif

-- method ScriptIter::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "ScriptIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoScriptIter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "pango_script_iter_next" pango_script_iter_next :: 
    Ptr ScriptIter ->                       -- iter : TInterface (Name {namespace = "Pango", name = "ScriptIter"})
    IO CInt

-- | Advances a @PangoScriptIter@ to the next range.
-- 
-- If /@iter@/ is already at the end, it is left unchanged
-- and 'P.False' is returned.
-- 
-- /Since: 1.4/
scriptIterNext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ScriptIter
    -- ^ /@iter@/: a @PangoScriptIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ was successfully advanced
scriptIterNext iter = liftIO $ do
    iter' <- unsafeManagedPtrGetPtr iter
    result <- pango_script_iter_next iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data ScriptIterNextMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod ScriptIterNextMethodInfo ScriptIter signature where
    overloadedMethod = scriptIterNext

instance O.OverloadedMethodInfo ScriptIterNextMethodInfo ScriptIter where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.ScriptIter.scriptIterNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-ScriptIter.html#v:scriptIterNext"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveScriptIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScriptIterMethod "free" o = ScriptIterFreeMethodInfo
    ResolveScriptIterMethod "next" o = ScriptIterNextMethodInfo
    ResolveScriptIterMethod "getRange" o = ScriptIterGetRangeMethodInfo
    ResolveScriptIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScriptIterMethod t ScriptIter, O.OverloadedMethod info ScriptIter p) => OL.IsLabel t (ScriptIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScriptIterMethod t ScriptIter, O.OverloadedMethod info ScriptIter p, R.HasField t ScriptIter p) => R.HasField t ScriptIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScriptIterMethod t ScriptIter, O.OverloadedMethodInfo info ScriptIter) => OL.IsLabel t (O.MethodProxy info ScriptIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


