{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node masking one child node with another.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.MaskNode
    ( 

-- * Exported types
    MaskNode(..)                            ,
    IsMaskNode                              ,
    toMaskNode                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getMask]("GI.Gsk.Objects.MaskNode#g:method:getMask"), [getMaskMode]("GI.Gsk.Objects.MaskNode#g:method:getMaskMode"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getSource]("GI.Gsk.Objects.MaskNode#g:method:getSource").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveMaskNodeMethod                   ,
#endif

-- ** getMask #method:getMask#

#if defined(ENABLE_OVERLOADING)
    MaskNodeGetMaskMethodInfo               ,
#endif
    maskNodeGetMask                         ,


-- ** getMaskMode #method:getMaskMode#

#if defined(ENABLE_OVERLOADING)
    MaskNodeGetMaskModeMethodInfo           ,
#endif
    maskNodeGetMaskMode                     ,


-- ** getSource #method:getSource#

#if defined(ENABLE_OVERLOADING)
    MaskNodeGetSourceMethodInfo             ,
#endif
    maskNodeGetSource                       ,


-- ** new #method:new#

    maskNodeNew                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype MaskNode = MaskNode (SP.ManagedPtr MaskNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype MaskNode where
    toManagedPtr (MaskNode p) = p

foreign import ccall "gsk_mask_node_get_type"
    c_gsk_mask_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject MaskNode where
    glibType = c_gsk_mask_node_get_type

-- | Type class for types which can be safely cast to t'MaskNode', for instance with `toMaskNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf MaskNode o) => IsMaskNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf MaskNode o) => IsMaskNode o

instance O.HasParentTypes MaskNode
type instance O.ParentTypes MaskNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'MaskNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toMaskNode :: (MIO.MonadIO m, IsMaskNode o) => o -> m MaskNode
toMaskNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo MaskNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveMaskNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMaskNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveMaskNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveMaskNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveMaskNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveMaskNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveMaskNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveMaskNodeMethod "getMask" o = MaskNodeGetMaskMethodInfo
    ResolveMaskNodeMethod "getMaskMode" o = MaskNodeGetMaskModeMethodInfo
    ResolveMaskNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveMaskNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveMaskNodeMethod "getSource" o = MaskNodeGetSourceMethodInfo
    ResolveMaskNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMaskNodeMethod t MaskNode, O.OverloadedMethod info MaskNode p) => OL.IsLabel t (MaskNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMaskNodeMethod t MaskNode, O.OverloadedMethod info MaskNode p, R.HasField t MaskNode p) => R.HasField t MaskNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMaskNodeMethod t MaskNode, O.OverloadedMethodInfo info MaskNode) => OL.IsLabel t (O.MethodProxy info MaskNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr MaskNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method MaskNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The source node to be drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to be used as mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask_mode"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "MaskMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The mask mode to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "MaskNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_mask_node_new" gsk_mask_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- source : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.RenderNode.RenderNode ->        -- mask : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    CUInt ->                                -- mask_mode : TInterface (Name {namespace = "Gsk", name = "MaskMode"})
    IO (Ptr MaskNode)

-- | Creates a @GskRenderNode@ that will mask a given node by another.
-- 
-- The /@maskMode@/ determines how the \'mask values\' are derived from
-- the colors of the /@mask@/. Applying the mask consists of multiplying
-- the \'mask value\' with the alpha of the source.
-- 
-- /Since: 4.10/
maskNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a, Gsk.RenderNode.IsRenderNode b) =>
    a
    -- ^ /@source@/: The source node to be drawn
    -> b
    -- ^ /@mask@/: The node to be used as mask
    -> Gsk.Enums.MaskMode
    -- ^ /@maskMode@/: The mask mode to use
    -> m MaskNode
    -- ^ __Returns:__ A new @GskRenderNode@
maskNodeNew source mask maskMode = liftIO $ do
    source' <- unsafeManagedPtrCastPtr source
    mask' <- unsafeManagedPtrCastPtr mask
    let maskMode' = (fromIntegral . fromEnum) maskMode
    result <- gsk_mask_node_new source' mask' maskMode'
    checkUnexpectedReturnNULL "maskNodeNew" result
    result' <- (wrapPtr MaskNode) result
    touchManagedPtr source
    touchManagedPtr mask
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MaskNode::get_mask
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "MaskNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mask `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_mask_node_get_mask" gsk_mask_node_get_mask :: 
    Ptr MaskNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "MaskNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the mask @GskRenderNode@ child of the /@node@/.
-- 
-- /Since: 4.10/
maskNodeGetMask ::
    (B.CallStack.HasCallStack, MonadIO m, IsMaskNode a) =>
    a
    -- ^ /@node@/: a mask @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the mask child node
maskNodeGetMask node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_mask_node_get_mask node'
    checkUnexpectedReturnNULL "maskNodeGetMask" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data MaskNodeGetMaskMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsMaskNode a) => O.OverloadedMethod MaskNodeGetMaskMethodInfo a signature where
    overloadedMethod = maskNodeGetMask

instance O.OverloadedMethodInfo MaskNodeGetMaskMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.MaskNode.maskNodeGetMask",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-MaskNode.html#v:maskNodeGetMask"
        })


#endif

-- method MaskNode::get_mask_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "MaskNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a blending `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "MaskMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_mask_node_get_mask_mode" gsk_mask_node_get_mask_mode :: 
    Ptr MaskNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "MaskNode"})
    IO CUInt

-- | Retrieves the mask mode used by /@node@/.
-- 
-- /Since: 4.10/
maskNodeGetMaskMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsMaskNode a) =>
    a
    -- ^ /@node@/: a blending @GskRenderNode@
    -> m Gsk.Enums.MaskMode
    -- ^ __Returns:__ the mask mode
maskNodeGetMaskMode node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_mask_node_get_mask_mode node'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data MaskNodeGetMaskModeMethodInfo
instance (signature ~ (m Gsk.Enums.MaskMode), MonadIO m, IsMaskNode a) => O.OverloadedMethod MaskNodeGetMaskModeMethodInfo a signature where
    overloadedMethod = maskNodeGetMaskMode

instance O.OverloadedMethodInfo MaskNodeGetMaskModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.MaskNode.maskNodeGetMaskMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-MaskNode.html#v:maskNodeGetMaskMode"
        })


#endif

-- method MaskNode::get_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "MaskNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mask `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_mask_node_get_source" gsk_mask_node_get_source :: 
    Ptr MaskNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "MaskNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the source @GskRenderNode@ child of the /@node@/.
-- 
-- /Since: 4.10/
maskNodeGetSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsMaskNode a) =>
    a
    -- ^ /@node@/: a mask @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the source child node
maskNodeGetSource node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_mask_node_get_source node'
    checkUnexpectedReturnNULL "maskNodeGetSource" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data MaskNodeGetSourceMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsMaskNode a) => O.OverloadedMethod MaskNodeGetSourceMethodInfo a signature where
    overloadedMethod = maskNodeGetSource

instance O.OverloadedMethodInfo MaskNodeGetSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.MaskNode.maskNodeGetSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-MaskNode.html#v:maskNodeGetSource"
        })


#endif


