{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Objects.FrameClock.FrameClock' tells the application when to update and repaint a
-- window. This may be synced to the vertical refresh rate of the
-- monitor, for example. Even when the frame clock uses a simple timer
-- rather than a hardware-based vertical sync, the frame clock helps
-- because it ensures everything paints at the same time (reducing the
-- total number of frames). The frame clock can also automatically
-- stop painting when it knows the frames will not be visible, or
-- scale back animation framerates.
-- 
-- t'GI.Gdk.Objects.FrameClock.FrameClock' is designed to be compatible with an OpenGL-based
-- implementation or with mozRequestAnimationFrame in Firefox,
-- for example.
-- 
-- A frame clock is idle until someone requests a frame with
-- 'GI.Gdk.Objects.FrameClock.frameClockRequestPhase'. At some later point that makes
-- sense for the synchronization being implemented, the clock will
-- process a frame and emit signals for each phase that has been
-- requested. (See the signals of the t'GI.Gdk.Objects.FrameClock.FrameClock' class for
-- documentation of the phases. 'GI.Gdk.Flags.FrameClockPhaseUpdate' and the
-- [FrameClock::update]("GI.Gdk.Objects.FrameClock#g:signal:update") signal are most interesting for application
-- writers, and are used to update the animations, using the frame time
-- given by 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime'.
-- 
-- The frame time is reported in microseconds and generally in the same
-- timescale as 'GI.GLib.Functions.getMonotonicTime', however, it is not the same
-- as 'GI.GLib.Functions.getMonotonicTime'. The frame time does not advance during
-- the time a frame is being painted, and outside of a frame, an attempt
-- is made so that all calls to 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime' that
-- are called at a “similar” time get the same value. This means that
-- if different animations are timed by looking at the difference in
-- time between an initial value from 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime'
-- and the value inside the [FrameClock::update]("GI.Gdk.Objects.FrameClock#g:signal:update") signal of the clock,
-- they will stay exactly synchronized.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.FrameClock
    ( 

-- * Exported types
    FrameClock(..)                          ,
    IsFrameClock                            ,
    toFrameClock                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beginUpdating]("GI.Gdk.Objects.FrameClock#g:method:beginUpdating"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [endUpdating]("GI.Gdk.Objects.FrameClock#g:method:endUpdating"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [requestPhase]("GI.Gdk.Objects.FrameClock#g:method:requestPhase"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCurrentTimings]("GI.Gdk.Objects.FrameClock#g:method:getCurrentTimings"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFrameCounter]("GI.Gdk.Objects.FrameClock#g:method:getFrameCounter"), [getFrameTime]("GI.Gdk.Objects.FrameClock#g:method:getFrameTime"), [getHistoryStart]("GI.Gdk.Objects.FrameClock#g:method:getHistoryStart"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRefreshInfo]("GI.Gdk.Objects.FrameClock#g:method:getRefreshInfo"), [getTimings]("GI.Gdk.Objects.FrameClock#g:method:getTimings").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFrameClockMethod                 ,
#endif

-- ** beginUpdating #method:beginUpdating#

#if defined(ENABLE_OVERLOADING)
    FrameClockBeginUpdatingMethodInfo       ,
#endif
    frameClockBeginUpdating                 ,


-- ** endUpdating #method:endUpdating#

#if defined(ENABLE_OVERLOADING)
    FrameClockEndUpdatingMethodInfo         ,
#endif
    frameClockEndUpdating                   ,


-- ** getCurrentTimings #method:getCurrentTimings#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetCurrentTimingsMethodInfo   ,
#endif
    frameClockGetCurrentTimings             ,


-- ** getFrameCounter #method:getFrameCounter#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetFrameCounterMethodInfo     ,
#endif
    frameClockGetFrameCounter               ,


-- ** getFrameTime #method:getFrameTime#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetFrameTimeMethodInfo        ,
#endif
    frameClockGetFrameTime                  ,


-- ** getHistoryStart #method:getHistoryStart#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetHistoryStartMethodInfo     ,
#endif
    frameClockGetHistoryStart               ,


-- ** getRefreshInfo #method:getRefreshInfo#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetRefreshInfoMethodInfo      ,
#endif
    frameClockGetRefreshInfo                ,


-- ** getTimings #method:getTimings#

#if defined(ENABLE_OVERLOADING)
    FrameClockGetTimingsMethodInfo          ,
#endif
    frameClockGetTimings                    ,


-- ** requestPhase #method:requestPhase#

#if defined(ENABLE_OVERLOADING)
    FrameClockRequestPhaseMethodInfo        ,
#endif
    frameClockRequestPhase                  ,




 -- * Signals


-- ** afterPaint #signal:afterPaint#

    FrameClockAfterPaintCallback            ,
#if defined(ENABLE_OVERLOADING)
    FrameClockAfterPaintSignalInfo          ,
#endif
    afterFrameClockAfterPaint               ,
    onFrameClockAfterPaint                  ,


-- ** beforePaint #signal:beforePaint#

    FrameClockBeforePaintCallback           ,
#if defined(ENABLE_OVERLOADING)
    FrameClockBeforePaintSignalInfo         ,
#endif
    afterFrameClockBeforePaint              ,
    onFrameClockBeforePaint                 ,


-- ** flushEvents #signal:flushEvents#

    FrameClockFlushEventsCallback           ,
#if defined(ENABLE_OVERLOADING)
    FrameClockFlushEventsSignalInfo         ,
#endif
    afterFrameClockFlushEvents              ,
    onFrameClockFlushEvents                 ,


-- ** layout #signal:layout#

    FrameClockLayoutCallback                ,
#if defined(ENABLE_OVERLOADING)
    FrameClockLayoutSignalInfo              ,
#endif
    afterFrameClockLayout                   ,
    onFrameClockLayout                      ,


-- ** paint #signal:paint#

    FrameClockPaintCallback                 ,
#if defined(ENABLE_OVERLOADING)
    FrameClockPaintSignalInfo               ,
#endif
    afterFrameClockPaint                    ,
    onFrameClockPaint                       ,


-- ** resumeEvents #signal:resumeEvents#

    FrameClockResumeEventsCallback          ,
#if defined(ENABLE_OVERLOADING)
    FrameClockResumeEventsSignalInfo        ,
#endif
    afterFrameClockResumeEvents             ,
    onFrameClockResumeEvents                ,


-- ** update #signal:update#

    FrameClockUpdateCallback                ,
#if defined(ENABLE_OVERLOADING)
    FrameClockUpdateSignalInfo              ,
#endif
    afterFrameClockUpdate                   ,
    onFrameClockUpdate                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings

#endif

-- | Memory-managed wrapper type.
newtype FrameClock = FrameClock (SP.ManagedPtr FrameClock)
    deriving (Eq)

instance SP.ManagedPtrNewtype FrameClock where
    toManagedPtr (FrameClock p) = p

foreign import ccall "gdk_frame_clock_get_type"
    c_gdk_frame_clock_get_type :: IO B.Types.GType

instance B.Types.TypedObject FrameClock where
    glibType = c_gdk_frame_clock_get_type

instance B.Types.GObject FrameClock

-- | Type class for types which can be safely cast to t'FrameClock', for instance with `toFrameClock`.
class (SP.GObject o, O.IsDescendantOf FrameClock o) => IsFrameClock o
instance (SP.GObject o, O.IsDescendantOf FrameClock o) => IsFrameClock o

instance O.HasParentTypes FrameClock
type instance O.ParentTypes FrameClock = '[GObject.Object.Object]

-- | Cast to t'FrameClock', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFrameClock :: (MIO.MonadIO m, IsFrameClock o) => o -> m FrameClock
toFrameClock = MIO.liftIO . B.ManagedPtr.unsafeCastTo FrameClock

-- | Convert t'FrameClock' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FrameClock) where
    gvalueGType_ = c_gdk_frame_clock_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FrameClock)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FrameClock)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FrameClock ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFrameClockMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFrameClockMethod "beginUpdating" o = FrameClockBeginUpdatingMethodInfo
    ResolveFrameClockMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFrameClockMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFrameClockMethod "endUpdating" o = FrameClockEndUpdatingMethodInfo
    ResolveFrameClockMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFrameClockMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFrameClockMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFrameClockMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFrameClockMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFrameClockMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFrameClockMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFrameClockMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFrameClockMethod "requestPhase" o = FrameClockRequestPhaseMethodInfo
    ResolveFrameClockMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFrameClockMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFrameClockMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFrameClockMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFrameClockMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFrameClockMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFrameClockMethod "getCurrentTimings" o = FrameClockGetCurrentTimingsMethodInfo
    ResolveFrameClockMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFrameClockMethod "getFrameCounter" o = FrameClockGetFrameCounterMethodInfo
    ResolveFrameClockMethod "getFrameTime" o = FrameClockGetFrameTimeMethodInfo
    ResolveFrameClockMethod "getHistoryStart" o = FrameClockGetHistoryStartMethodInfo
    ResolveFrameClockMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFrameClockMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFrameClockMethod "getRefreshInfo" o = FrameClockGetRefreshInfoMethodInfo
    ResolveFrameClockMethod "getTimings" o = FrameClockGetTimingsMethodInfo
    ResolveFrameClockMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFrameClockMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFrameClockMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFrameClockMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFrameClockMethod t FrameClock, O.OverloadedMethod info FrameClock p) => OL.IsLabel t (FrameClock -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFrameClockMethod t FrameClock, O.OverloadedMethod info FrameClock p, R.HasField t FrameClock p) => R.HasField t FrameClock p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFrameClockMethod t FrameClock, O.OverloadedMethodInfo info FrameClock) => OL.IsLabel t (O.MethodProxy info FrameClock) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FrameClock::after-paint
-- | This signal ends processing of the frame. Applications
-- should generally not handle this signal.
type FrameClockAfterPaintCallback =
    IO ()

type C_FrameClockAfterPaintCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockAfterPaintCallback`.
foreign import ccall "wrapper"
    mk_FrameClockAfterPaintCallback :: C_FrameClockAfterPaintCallback -> IO (FunPtr C_FrameClockAfterPaintCallback)

wrap_FrameClockAfterPaintCallback :: 
    GObject a => (a -> FrameClockAfterPaintCallback) ->
    C_FrameClockAfterPaintCallback
wrap_FrameClockAfterPaintCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [afterPaint](#signal:afterPaint) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #afterPaint callback
-- @
-- 
-- 
onFrameClockAfterPaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockAfterPaintCallback) -> m SignalHandlerId
onFrameClockAfterPaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockAfterPaintCallback wrapped
    wrapped'' <- mk_FrameClockAfterPaintCallback wrapped'
    connectSignalFunPtr obj "after-paint" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [afterPaint](#signal:afterPaint) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #afterPaint callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockAfterPaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockAfterPaintCallback) -> m SignalHandlerId
afterFrameClockAfterPaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockAfterPaintCallback wrapped
    wrapped'' <- mk_FrameClockAfterPaintCallback wrapped'
    connectSignalFunPtr obj "after-paint" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockAfterPaintSignalInfo
instance SignalInfo FrameClockAfterPaintSignalInfo where
    type HaskellCallbackType FrameClockAfterPaintSignalInfo = FrameClockAfterPaintCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockAfterPaintCallback cb
        cb'' <- mk_FrameClockAfterPaintCallback cb'
        connectSignalFunPtr obj "after-paint" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::after-paint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:afterPaint"})

#endif

-- signal FrameClock::before-paint
-- | This signal begins processing of the frame. Applications
-- should generally not handle this signal.
type FrameClockBeforePaintCallback =
    IO ()

type C_FrameClockBeforePaintCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockBeforePaintCallback`.
foreign import ccall "wrapper"
    mk_FrameClockBeforePaintCallback :: C_FrameClockBeforePaintCallback -> IO (FunPtr C_FrameClockBeforePaintCallback)

wrap_FrameClockBeforePaintCallback :: 
    GObject a => (a -> FrameClockBeforePaintCallback) ->
    C_FrameClockBeforePaintCallback
wrap_FrameClockBeforePaintCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [beforePaint](#signal:beforePaint) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #beforePaint callback
-- @
-- 
-- 
onFrameClockBeforePaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockBeforePaintCallback) -> m SignalHandlerId
onFrameClockBeforePaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockBeforePaintCallback wrapped
    wrapped'' <- mk_FrameClockBeforePaintCallback wrapped'
    connectSignalFunPtr obj "before-paint" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [beforePaint](#signal:beforePaint) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #beforePaint callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockBeforePaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockBeforePaintCallback) -> m SignalHandlerId
afterFrameClockBeforePaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockBeforePaintCallback wrapped
    wrapped'' <- mk_FrameClockBeforePaintCallback wrapped'
    connectSignalFunPtr obj "before-paint" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockBeforePaintSignalInfo
instance SignalInfo FrameClockBeforePaintSignalInfo where
    type HaskellCallbackType FrameClockBeforePaintSignalInfo = FrameClockBeforePaintCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockBeforePaintCallback cb
        cb'' <- mk_FrameClockBeforePaintCallback cb'
        connectSignalFunPtr obj "before-paint" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::before-paint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:beforePaint"})

#endif

-- signal FrameClock::flush-events
-- | This signal is used to flush pending motion events that
-- are being batched up and compressed together. Applications
-- should not handle this signal.
type FrameClockFlushEventsCallback =
    IO ()

type C_FrameClockFlushEventsCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockFlushEventsCallback`.
foreign import ccall "wrapper"
    mk_FrameClockFlushEventsCallback :: C_FrameClockFlushEventsCallback -> IO (FunPtr C_FrameClockFlushEventsCallback)

wrap_FrameClockFlushEventsCallback :: 
    GObject a => (a -> FrameClockFlushEventsCallback) ->
    C_FrameClockFlushEventsCallback
wrap_FrameClockFlushEventsCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [flushEvents](#signal:flushEvents) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #flushEvents callback
-- @
-- 
-- 
onFrameClockFlushEvents :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockFlushEventsCallback) -> m SignalHandlerId
onFrameClockFlushEvents obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockFlushEventsCallback wrapped
    wrapped'' <- mk_FrameClockFlushEventsCallback wrapped'
    connectSignalFunPtr obj "flush-events" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [flushEvents](#signal:flushEvents) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #flushEvents callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockFlushEvents :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockFlushEventsCallback) -> m SignalHandlerId
afterFrameClockFlushEvents obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockFlushEventsCallback wrapped
    wrapped'' <- mk_FrameClockFlushEventsCallback wrapped'
    connectSignalFunPtr obj "flush-events" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockFlushEventsSignalInfo
instance SignalInfo FrameClockFlushEventsSignalInfo where
    type HaskellCallbackType FrameClockFlushEventsSignalInfo = FrameClockFlushEventsCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockFlushEventsCallback cb
        cb'' <- mk_FrameClockFlushEventsCallback cb'
        connectSignalFunPtr obj "flush-events" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::flush-events"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:flushEvents"})

#endif

-- signal FrameClock::layout
-- | This signal is emitted as the second step of toolkit and
-- application processing of the frame. Any work to update
-- sizes and positions of application elements should be
-- performed. GTK+ normally handles this internally.
type FrameClockLayoutCallback =
    IO ()

type C_FrameClockLayoutCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockLayoutCallback`.
foreign import ccall "wrapper"
    mk_FrameClockLayoutCallback :: C_FrameClockLayoutCallback -> IO (FunPtr C_FrameClockLayoutCallback)

wrap_FrameClockLayoutCallback :: 
    GObject a => (a -> FrameClockLayoutCallback) ->
    C_FrameClockLayoutCallback
wrap_FrameClockLayoutCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [layout](#signal:layout) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #layout callback
-- @
-- 
-- 
onFrameClockLayout :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockLayoutCallback) -> m SignalHandlerId
onFrameClockLayout obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockLayoutCallback wrapped
    wrapped'' <- mk_FrameClockLayoutCallback wrapped'
    connectSignalFunPtr obj "layout" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [layout](#signal:layout) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #layout callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockLayout :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockLayoutCallback) -> m SignalHandlerId
afterFrameClockLayout obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockLayoutCallback wrapped
    wrapped'' <- mk_FrameClockLayoutCallback wrapped'
    connectSignalFunPtr obj "layout" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockLayoutSignalInfo
instance SignalInfo FrameClockLayoutSignalInfo where
    type HaskellCallbackType FrameClockLayoutSignalInfo = FrameClockLayoutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockLayoutCallback cb
        cb'' <- mk_FrameClockLayoutCallback cb'
        connectSignalFunPtr obj "layout" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::layout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:layout"})

#endif

-- signal FrameClock::paint
-- | This signal is emitted as the third step of toolkit and
-- application processing of the frame. The frame is
-- repainted. GDK normally handles this internally and
-- produces expose events, which are turned into GTK+
-- @/GtkWidget::draw/@ signals.
type FrameClockPaintCallback =
    IO ()

type C_FrameClockPaintCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockPaintCallback`.
foreign import ccall "wrapper"
    mk_FrameClockPaintCallback :: C_FrameClockPaintCallback -> IO (FunPtr C_FrameClockPaintCallback)

wrap_FrameClockPaintCallback :: 
    GObject a => (a -> FrameClockPaintCallback) ->
    C_FrameClockPaintCallback
wrap_FrameClockPaintCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [paint](#signal:paint) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #paint callback
-- @
-- 
-- 
onFrameClockPaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockPaintCallback) -> m SignalHandlerId
onFrameClockPaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockPaintCallback wrapped
    wrapped'' <- mk_FrameClockPaintCallback wrapped'
    connectSignalFunPtr obj "paint" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [paint](#signal:paint) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #paint callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockPaint :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockPaintCallback) -> m SignalHandlerId
afterFrameClockPaint obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockPaintCallback wrapped
    wrapped'' <- mk_FrameClockPaintCallback wrapped'
    connectSignalFunPtr obj "paint" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockPaintSignalInfo
instance SignalInfo FrameClockPaintSignalInfo where
    type HaskellCallbackType FrameClockPaintSignalInfo = FrameClockPaintCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockPaintCallback cb
        cb'' <- mk_FrameClockPaintCallback cb'
        connectSignalFunPtr obj "paint" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::paint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:paint"})

#endif

-- signal FrameClock::resume-events
-- | This signal is emitted after processing of the frame is
-- finished, and is handled internally by GTK+ to resume normal
-- event processing. Applications should not handle this signal.
type FrameClockResumeEventsCallback =
    IO ()

type C_FrameClockResumeEventsCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockResumeEventsCallback`.
foreign import ccall "wrapper"
    mk_FrameClockResumeEventsCallback :: C_FrameClockResumeEventsCallback -> IO (FunPtr C_FrameClockResumeEventsCallback)

wrap_FrameClockResumeEventsCallback :: 
    GObject a => (a -> FrameClockResumeEventsCallback) ->
    C_FrameClockResumeEventsCallback
wrap_FrameClockResumeEventsCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [resumeEvents](#signal:resumeEvents) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #resumeEvents callback
-- @
-- 
-- 
onFrameClockResumeEvents :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockResumeEventsCallback) -> m SignalHandlerId
onFrameClockResumeEvents obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockResumeEventsCallback wrapped
    wrapped'' <- mk_FrameClockResumeEventsCallback wrapped'
    connectSignalFunPtr obj "resume-events" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [resumeEvents](#signal:resumeEvents) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #resumeEvents callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockResumeEvents :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockResumeEventsCallback) -> m SignalHandlerId
afterFrameClockResumeEvents obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockResumeEventsCallback wrapped
    wrapped'' <- mk_FrameClockResumeEventsCallback wrapped'
    connectSignalFunPtr obj "resume-events" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockResumeEventsSignalInfo
instance SignalInfo FrameClockResumeEventsSignalInfo where
    type HaskellCallbackType FrameClockResumeEventsSignalInfo = FrameClockResumeEventsCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockResumeEventsCallback cb
        cb'' <- mk_FrameClockResumeEventsCallback cb'
        connectSignalFunPtr obj "resume-events" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::resume-events"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:resumeEvents"})

#endif

-- signal FrameClock::update
-- | This signal is emitted as the first step of toolkit and
-- application processing of the frame. Animations should
-- be updated using 'GI.Gdk.Objects.FrameClock.frameClockGetFrameTime'.
-- Applications can connect directly to this signal, or
-- use @/gtk_widget_add_tick_callback()/@ as a more convenient
-- interface.
type FrameClockUpdateCallback =
    IO ()

type C_FrameClockUpdateCallback =
    Ptr FrameClock ->                       -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FrameClockUpdateCallback`.
foreign import ccall "wrapper"
    mk_FrameClockUpdateCallback :: C_FrameClockUpdateCallback -> IO (FunPtr C_FrameClockUpdateCallback)

wrap_FrameClockUpdateCallback :: 
    GObject a => (a -> FrameClockUpdateCallback) ->
    C_FrameClockUpdateCallback
wrap_FrameClockUpdateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [update](#signal:update) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' frameClock #update callback
-- @
-- 
-- 
onFrameClockUpdate :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockUpdateCallback) -> m SignalHandlerId
onFrameClockUpdate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockUpdateCallback wrapped
    wrapped'' <- mk_FrameClockUpdateCallback wrapped'
    connectSignalFunPtr obj "update" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [update](#signal:update) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' frameClock #update callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFrameClockUpdate :: (IsFrameClock a, MonadIO m) => a -> ((?self :: a) => FrameClockUpdateCallback) -> m SignalHandlerId
afterFrameClockUpdate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FrameClockUpdateCallback wrapped
    wrapped'' <- mk_FrameClockUpdateCallback wrapped'
    connectSignalFunPtr obj "update" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FrameClockUpdateSignalInfo
instance SignalInfo FrameClockUpdateSignalInfo where
    type HaskellCallbackType FrameClockUpdateSignalInfo = FrameClockUpdateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FrameClockUpdateCallback cb
        cb'' <- mk_FrameClockUpdateCallback cb'
        connectSignalFunPtr obj "update" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock::update"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#g:signal:update"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FrameClock
type instance O.AttributeList FrameClock = FrameClockAttributeList
type FrameClockAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FrameClock = FrameClockSignalList
type FrameClockSignalList = ('[ '("afterPaint", FrameClockAfterPaintSignalInfo), '("beforePaint", FrameClockBeforePaintSignalInfo), '("flushEvents", FrameClockFlushEventsSignalInfo), '("layout", FrameClockLayoutSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("paint", FrameClockPaintSignalInfo), '("resumeEvents", FrameClockResumeEventsSignalInfo), '("update", FrameClockUpdateSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FrameClock::begin_updating
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_begin_updating" gdk_frame_clock_begin_updating :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO ()

-- | Starts updates for an animation. Until a matching call to
-- 'GI.Gdk.Objects.FrameClock.frameClockEndUpdating' is made, the frame clock will continually
-- request a new frame with the 'GI.Gdk.Flags.FrameClockPhaseUpdate' phase.
-- This function may be called multiple times and frames will be
-- requested until 'GI.Gdk.Objects.FrameClock.frameClockEndUpdating' is called the same
-- number of times.
-- 
-- /Since: 3.8/
frameClockBeginUpdating ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m ()
frameClockBeginUpdating frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    gdk_frame_clock_begin_updating frameClock'
    touchManagedPtr frameClock
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameClockBeginUpdatingMethodInfo
instance (signature ~ (m ()), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockBeginUpdatingMethodInfo a signature where
    overloadedMethod = frameClockBeginUpdating

instance O.OverloadedMethodInfo FrameClockBeginUpdatingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockBeginUpdating",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockBeginUpdating"
        })


#endif

-- method FrameClock::end_updating
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_end_updating" gdk_frame_clock_end_updating :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO ()

-- | Stops updates for an animation. See the documentation for
-- 'GI.Gdk.Objects.FrameClock.frameClockBeginUpdating'.
-- 
-- /Since: 3.8/
frameClockEndUpdating ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m ()
frameClockEndUpdating frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    gdk_frame_clock_end_updating frameClock'
    touchManagedPtr frameClock
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameClockEndUpdatingMethodInfo
instance (signature ~ (m ()), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockEndUpdatingMethodInfo a signature where
    overloadedMethod = frameClockEndUpdating

instance O.OverloadedMethodInfo FrameClockEndUpdatingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockEndUpdating",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockEndUpdating"
        })


#endif

-- method FrameClock::get_current_timings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "FrameTimings" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_current_timings" gdk_frame_clock_get_current_timings :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO (Ptr Gdk.FrameTimings.FrameTimings)

-- | Gets the frame timings for the current frame.
-- 
-- /Since: 3.8/
frameClockGetCurrentTimings ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m (Maybe Gdk.FrameTimings.FrameTimings)
    -- ^ __Returns:__ the t'GI.Gdk.Structs.FrameTimings.FrameTimings' for the
    --  frame currently being processed, or even no frame is being
    --  processed, for the previous frame. Before any frames have been
    --  processed, returns 'P.Nothing'.
frameClockGetCurrentTimings frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- gdk_frame_clock_get_current_timings frameClock'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Gdk.FrameTimings.FrameTimings) result'
        return result''
    touchManagedPtr frameClock
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FrameClockGetCurrentTimingsMethodInfo
instance (signature ~ (m (Maybe Gdk.FrameTimings.FrameTimings)), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetCurrentTimingsMethodInfo a signature where
    overloadedMethod = frameClockGetCurrentTimings

instance O.OverloadedMethodInfo FrameClockGetCurrentTimingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetCurrentTimings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetCurrentTimings"
        })


#endif

-- method FrameClock::get_frame_counter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_frame_counter" gdk_frame_clock_get_frame_counter :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO Int64

-- | A t'GI.Gdk.Objects.FrameClock.FrameClock' maintains a 64-bit counter that increments for
-- each frame drawn.
-- 
-- /Since: 3.8/
frameClockGetFrameCounter ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m Int64
    -- ^ __Returns:__ inside frame processing, the value of the frame counter
    --  for the current frame. Outside of frame processing, the frame
    --   counter for the last frame.
frameClockGetFrameCounter frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- gdk_frame_clock_get_frame_counter frameClock'
    touchManagedPtr frameClock
    return result

#if defined(ENABLE_OVERLOADING)
data FrameClockGetFrameCounterMethodInfo
instance (signature ~ (m Int64), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetFrameCounterMethodInfo a signature where
    overloadedMethod = frameClockGetFrameCounter

instance O.OverloadedMethodInfo FrameClockGetFrameCounterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetFrameCounter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetFrameCounter"
        })


#endif

-- method FrameClock::get_frame_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_frame_time" gdk_frame_clock_get_frame_time :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO Int64

-- | Gets the time that should currently be used for animations.  Inside
-- the processing of a frame, it’s the time used to compute the
-- animation position of everything in a frame. Outside of a frame, it\'s
-- the time of the conceptual “previous frame,” which may be either
-- the actual previous frame time, or if that’s too old, an updated
-- time.
-- 
-- /Since: 3.8/
frameClockGetFrameTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m Int64
    -- ^ __Returns:__ a timestamp in microseconds, in the timescale of
    --  of 'GI.GLib.Functions.getMonotonicTime'.
frameClockGetFrameTime frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- gdk_frame_clock_get_frame_time frameClock'
    touchManagedPtr frameClock
    return result

#if defined(ENABLE_OVERLOADING)
data FrameClockGetFrameTimeMethodInfo
instance (signature ~ (m Int64), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetFrameTimeMethodInfo a signature where
    overloadedMethod = frameClockGetFrameTime

instance O.OverloadedMethodInfo FrameClockGetFrameTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetFrameTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetFrameTime"
        })


#endif

-- method FrameClock::get_history_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_history_start" gdk_frame_clock_get_history_start :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    IO Int64

-- | t'GI.Gdk.Objects.FrameClock.FrameClock' internally keeps a history of t'GI.Gdk.Structs.FrameTimings.FrameTimings'
-- objects for recent frames that can be retrieved with
-- 'GI.Gdk.Objects.FrameClock.frameClockGetTimings'. The set of stored frames
-- is the set from the counter values given by
-- 'GI.Gdk.Objects.FrameClock.frameClockGetHistoryStart' and
-- 'GI.Gdk.Objects.FrameClock.frameClockGetFrameCounter', inclusive.
-- 
-- /Since: 3.8/
frameClockGetHistoryStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> m Int64
    -- ^ __Returns:__ the frame counter value for the oldest frame
    --  that is available in the internal frame history of the
    --  t'GI.Gdk.Objects.FrameClock.FrameClock'.
frameClockGetHistoryStart frameClock = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- gdk_frame_clock_get_history_start frameClock'
    touchManagedPtr frameClock
    return result

#if defined(ENABLE_OVERLOADING)
data FrameClockGetHistoryStartMethodInfo
instance (signature ~ (m Int64), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetHistoryStartMethodInfo a signature where
    overloadedMethod = frameClockGetHistoryStart

instance O.OverloadedMethodInfo FrameClockGetHistoryStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetHistoryStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetHistoryStart"
        })


#endif

-- method FrameClock::get_refresh_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "base_time"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "base time for determining a presentaton time"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "refresh_interval_return"
--           , argType = TBasicType TInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to store the\ndetermined refresh interval, or %NULL. A default refresh interval of\n1/60th of a second will be stored if no history is present."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "presentation_time_return"
--           , argType = TBasicType TInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to store the next\n candidate presentation time after the given base time.\n 0 will be will be stored if no history is present."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_refresh_info" gdk_frame_clock_get_refresh_info :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    Int64 ->                                -- base_time : TBasicType TInt64
    Ptr Int64 ->                            -- refresh_interval_return : TBasicType TInt64
    Ptr Int64 ->                            -- presentation_time_return : TBasicType TInt64
    IO ()

-- | Using the frame history stored in the frame clock, finds the last
-- known presentation time and refresh interval, and assuming that
-- presentation times are separated by the refresh interval,
-- predicts a presentation time that is a multiple of the refresh
-- interval after the last presentation time, and later than /@baseTime@/.
-- 
-- /Since: 3.8/
frameClockGetRefreshInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> Int64
    -- ^ /@baseTime@/: base time for determining a presentaton time
    -> m ((Int64, Int64))
frameClockGetRefreshInfo frameClock baseTime = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    refreshIntervalReturn <- allocMem :: IO (Ptr Int64)
    presentationTimeReturn <- allocMem :: IO (Ptr Int64)
    gdk_frame_clock_get_refresh_info frameClock' baseTime refreshIntervalReturn presentationTimeReturn
    refreshIntervalReturn' <- peek refreshIntervalReturn
    presentationTimeReturn' <- peek presentationTimeReturn
    touchManagedPtr frameClock
    freeMem refreshIntervalReturn
    freeMem presentationTimeReturn
    return (refreshIntervalReturn', presentationTimeReturn')

#if defined(ENABLE_OVERLOADING)
data FrameClockGetRefreshInfoMethodInfo
instance (signature ~ (Int64 -> m ((Int64, Int64))), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetRefreshInfoMethodInfo a signature where
    overloadedMethod = frameClockGetRefreshInfo

instance O.OverloadedMethodInfo FrameClockGetRefreshInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetRefreshInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetRefreshInfo"
        })


#endif

-- method FrameClock::get_timings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "frame_counter"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the frame counter value identifying the frame to\n be received."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "FrameTimings" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_get_timings" gdk_frame_clock_get_timings :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    Int64 ->                                -- frame_counter : TBasicType TInt64
    IO (Ptr Gdk.FrameTimings.FrameTimings)

-- | Retrieves a t'GI.Gdk.Structs.FrameTimings.FrameTimings' object holding timing information
-- for the current frame or a recent frame. The t'GI.Gdk.Structs.FrameTimings.FrameTimings'
-- object may not yet be complete: see 'GI.Gdk.Structs.FrameTimings.frameTimingsGetComplete'.
-- 
-- /Since: 3.8/
frameClockGetTimings ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> Int64
    -- ^ /@frameCounter@/: the frame counter value identifying the frame to
    --  be received.
    -> m (Maybe Gdk.FrameTimings.FrameTimings)
    -- ^ __Returns:__ the t'GI.Gdk.Structs.FrameTimings.FrameTimings' object for
    --  the specified frame, or 'P.Nothing' if it is not available. See
    --  'GI.Gdk.Objects.FrameClock.frameClockGetHistoryStart'.
frameClockGetTimings frameClock frameCounter = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    result <- gdk_frame_clock_get_timings frameClock' frameCounter
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Gdk.FrameTimings.FrameTimings) result'
        return result''
    touchManagedPtr frameClock
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FrameClockGetTimingsMethodInfo
instance (signature ~ (Int64 -> m (Maybe Gdk.FrameTimings.FrameTimings)), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockGetTimingsMethodInfo a signature where
    overloadedMethod = frameClockGetTimings

instance O.OverloadedMethodInfo FrameClockGetTimingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockGetTimings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockGetTimings"
        })


#endif

-- method FrameClock::request_phase
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "frame_clock"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClock" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkFrameClock" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "phase"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "FrameClockPhase" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the phase that is requested"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_frame_clock_request_phase" gdk_frame_clock_request_phase :: 
    Ptr FrameClock ->                       -- frame_clock : TInterface (Name {namespace = "Gdk", name = "FrameClock"})
    CUInt ->                                -- phase : TInterface (Name {namespace = "Gdk", name = "FrameClockPhase"})
    IO ()

-- | Asks the frame clock to run a particular phase. The signal
-- corresponding the requested phase will be emitted the next
-- time the frame clock processes. Multiple calls to
-- 'GI.Gdk.Objects.FrameClock.frameClockRequestPhase' will be combined together
-- and only one frame processed. If you are displaying animated
-- content and want to continually request the
-- 'GI.Gdk.Flags.FrameClockPhaseUpdate' phase for a period of time,
-- you should use 'GI.Gdk.Objects.FrameClock.frameClockBeginUpdating' instead, since
-- this allows GTK+ to adjust system parameters to get maximally
-- smooth animations.
-- 
-- /Since: 3.8/
frameClockRequestPhase ::
    (B.CallStack.HasCallStack, MonadIO m, IsFrameClock a) =>
    a
    -- ^ /@frameClock@/: a t'GI.Gdk.Objects.FrameClock.FrameClock'
    -> [Gdk.Flags.FrameClockPhase]
    -- ^ /@phase@/: the phase that is requested
    -> m ()
frameClockRequestPhase frameClock phase = liftIO $ do
    frameClock' <- unsafeManagedPtrCastPtr frameClock
    let phase' = gflagsToWord phase
    gdk_frame_clock_request_phase frameClock' phase'
    touchManagedPtr frameClock
    return ()

#if defined(ENABLE_OVERLOADING)
data FrameClockRequestPhaseMethodInfo
instance (signature ~ ([Gdk.Flags.FrameClockPhase] -> m ()), MonadIO m, IsFrameClock a) => O.OverloadedMethod FrameClockRequestPhaseMethodInfo a signature where
    overloadedMethod = frameClockRequestPhase

instance O.OverloadedMethodInfo FrameClockRequestPhaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.FrameClock.frameClockRequestPhase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-FrameClock.html#v:frameClockRequestPhase"
        })


#endif


