/* Settings.c generated by valac 0.56.17, the Vala compiler
 * generated from Settings.vala, do not modify */

/*
 * Copyright 2011-2013 Robert Dyer
 * Copyright 2011-2013 Rico Tzschichholz <ricotz@ubuntu.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_SERVICES_SETTINGS_0_PROPERTY,
	GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY,
	GRANITE_SERVICES_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* granite_services_settings_properties[GRANITE_SERVICES_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	GRANITE_SERVICES_SETTINGS_CHANGED_SIGNAL,
	GRANITE_SERVICES_SETTINGS_NUM_SIGNALS
};
static guint granite_services_settings_signals[GRANITE_SERVICES_SETTINGS_NUM_SIGNALS] = {0};

struct _GraniteServicesSettingsPrivate {
	gboolean saving_key;
	GSettings* _schema;
};

static gint GraniteServicesSettings_private_offset;
static gpointer granite_services_settings_parent_class = NULL;

static GType granite_services_settings_serializable_get_type_once (void);
static void granite_services_settings_stop_monitor (GraniteServicesSettings* self);
static void granite_services_settings_load_key (GraniteServicesSettings* self,
                                         const gchar* key);
static void _granite_services_settings_load_key_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self);
static void granite_services_settings_start_monitor (GraniteServicesSettings* self);
static void granite_services_settings_handle_notify (GraniteServicesSettings* self,
                                              GObject* sender,
                                              GParamSpec* property);
static void _granite_services_settings_handle_notify_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void granite_services_settings_call_verify (GraniteServicesSettings* self,
                                            const gchar* key);
static void granite_services_settings_save_key (GraniteServicesSettings* self,
                                         const gchar* key);
static void granite_services_settings_handle_verify_notify (GraniteServicesSettings* self,
                                                     GObject* sender,
                                                     GParamSpec* property);
static void _granite_services_settings_handle_verify_notify_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void granite_services_settings_real_verify (GraniteServicesSettings* self,
                                            const gchar* key);
static GObject * granite_services_settings_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void granite_services_settings_finalize (GObject * obj);
static GType granite_services_settings_get_type_once (void);
static void _vala_granite_services_settings_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_granite_services_settings_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

/**
         * Serializes the object into a string representation.
         *
         * @return the string representation of the object
         */
gchar*
granite_services_settings_serializable_settings_serialize (GraniteServicesSettingsSerializable* self)
{
	GraniteServicesSettingsSerializableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_SERVICES_SETTINGS_SERIALIZABLE_GET_INTERFACE (self);
	if (_iface_->settings_serialize) {
		return _iface_->settings_serialize (self);
	}
	return NULL;
}

/**
         * Un-serializes the object from a string representation.
         *
         * @param s the string representation of the object
         */
void
granite_services_settings_serializable_settings_deserialize (GraniteServicesSettingsSerializable* self,
                                                             const gchar* s)
{
	GraniteServicesSettingsSerializableIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_SERVICES_SETTINGS_SERIALIZABLE_GET_INTERFACE (self);
	if (_iface_->settings_deserialize) {
		_iface_->settings_deserialize (self, s);
	}
}

static void
granite_services_settings_serializable_default_init (GraniteServicesSettingsSerializableIface * iface,
                                                     gpointer iface_data)
{
}

/**
     * This interface is used by objects that need to be serialized in a Settings.
     * The object must have a string representation and provide these methods to
     * translate between the string and object representations.
     */
static GType
granite_services_settings_serializable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesSettingsSerializableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_settings_serializable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_services_settings_serializable_type_id;
	granite_services_settings_serializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteServicesSettingsSerializable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_services_settings_serializable_type_id, G_TYPE_OBJECT);
	return granite_services_settings_serializable_type_id;
}

GType
granite_services_settings_serializable_get_type (void)
{
	static volatile gsize granite_services_settings_serializable_type_id__once = 0;
	if (g_once_init_enter (&granite_services_settings_serializable_type_id__once)) {
		GType granite_services_settings_serializable_type_id;
		granite_services_settings_serializable_type_id = granite_services_settings_serializable_get_type_once ();
		g_once_init_leave (&granite_services_settings_serializable_type_id__once, granite_services_settings_serializable_type_id);
	}
	return granite_services_settings_serializable_type_id__once;
}

static inline gpointer
granite_services_settings_get_instance_private (GraniteServicesSettings* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteServicesSettings_private_offset);
}

GSettings*
granite_services_settings_get_schema (GraniteServicesSettings* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_schema;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_services_settings_set_schema (GraniteServicesSettings* self,
                                      GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_services_settings_get_schema (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_schema);
		self->priv->_schema = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_services_settings_properties[GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY]);
	}
}

/**
         * Creates a new {@link Granite.Services.Settings} object for the supplied schema.
         *
         * @param schema the name of the schema to interact with
         */
GraniteServicesSettings*
granite_services_settings_construct (GType object_type,
                                     const gchar* schema)
{
	GraniteServicesSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	_tmp0_ = g_settings_new (schema);
	_tmp1_ = _tmp0_;
	self = (GraniteServicesSettings*) g_object_new (object_type, "schema", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
         * Creates a new {@link Granite.Services.Settings} object for the supplied schema and {@link GLib.SettingsBackend}.
         *
         * @param schema the name of the schema to interact with
         * @param backend the desired backend to use
         */
GraniteServicesSettings*
granite_services_settings_construct_with_backend (GType object_type,
                                                  const gchar* schema,
                                                  GSettingsBackend* backend)
{
	GraniteServicesSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = g_settings_new_with_backend (schema, backend);
	_tmp1_ = _tmp0_;
	self = (GraniteServicesSettings*) g_object_new (object_type, "schema", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
         * Creates a new {@link Granite.Services.Settings} object for the supplied schema, {@link GLib.SettingsBackend}, and path.
         *
         *
         * @param schema the name of the schema to interact with
         * @param backend the desired backend to use
         * @param path the path to use
         */
GraniteServicesSettings*
granite_services_settings_construct_with_backend_and_path (GType object_type,
                                                           const gchar* schema,
                                                           GSettingsBackend* backend,
                                                           const gchar* path)
{
	GraniteServicesSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (backend != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_settings_new_with_backend_and_path (schema, backend, path);
	_tmp1_ = _tmp0_;
	self = (GraniteServicesSettings*) g_object_new (object_type, "schema", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
         * Creates a new {@link Granite.Services.Settings} object for the supplied schema, and path.
         *
         * You only need to do this if you want to directly create a settings object with a schema that
         * doesn't have a specified path of its own. That's quite rare.
         *
         * It is a programmer error to call this function for a schema that has an explicitly specified path.
         *
         * @param schema the name of the schema to interact with
         * @param path the path to use
         */
GraniteServicesSettings*
granite_services_settings_construct_with_path (GType object_type,
                                               const gchar* schema,
                                               const gchar* path)
{
	GraniteServicesSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_settings_new_with_path (schema, path);
	_tmp1_ = _tmp0_;
	self = (GraniteServicesSettings*) g_object_new (object_type, "schema", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

static void
_granite_services_settings_load_key_g_settings_changed (GSettings* _sender,
                                                        const gchar* key,
                                                        gpointer self)
{
	granite_services_settings_load_key ((GraniteServicesSettings*) self, key);
}

static void
granite_services_settings_stop_monitor (GraniteServicesSettings* self)
{
	GSettings* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_schema;
	g_signal_parse_name ("changed", g_settings_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _granite_services_settings_load_key_g_settings_changed, self);
}

static void
granite_services_settings_start_monitor (GraniteServicesSettings* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_schema;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _granite_services_settings_load_key_g_settings_changed, self, 0);
}

static void
_granite_services_settings_handle_notify_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	granite_services_settings_handle_notify ((GraniteServicesSettings*) self, _sender, pspec);
}

static void
granite_services_settings_handle_notify (GraniteServicesSettings* self,
                                         GObject* sender,
                                         GParamSpec* property)
{
	guint _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _granite_services_settings_handle_notify_g_object_notify, self);
	_tmp1_ = property->name;
	granite_services_settings_call_verify (self, _tmp1_);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_notify_g_object_notify, self, 0);
	_tmp2_ = property->name;
	granite_services_settings_save_key (self, _tmp2_);
}

static void
granite_services_settings_handle_verify_notify (GraniteServicesSettings* self,
                                                GObject* sender,
                                                GParamSpec* property)
{
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	_tmp0_ = property->name;
	_tmp1_ = self->priv->_schema;
	g_object_get (_tmp1_, "schema-id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_warning ("Settings.vala:185: Key '%s' failed verification in schema '%s', changi" \
"ng value", _tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
_granite_services_settings_handle_verify_notify_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	granite_services_settings_handle_verify_notify ((GraniteServicesSettings*) self, _sender, pspec);
}

static void
granite_services_settings_call_verify (GraniteServicesSettings* self,
                                       const gchar* key)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_verify_notify_g_object_notify, self, 0);
	granite_services_settings_verify (self, key);
	g_signal_emit (self, granite_services_settings_signals[GRANITE_SERVICES_SETTINGS_CHANGED_SIGNAL], g_quark_from_string (key));
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _granite_services_settings_handle_verify_notify_g_object_notify, self);
}

/**
         * Verify the given key, changing the property if necessary. Refer to the example given for the class.
         *
         * @param key the key in question
         */
static void
granite_services_settings_real_verify (GraniteServicesSettings* self,
                                       const gchar* key)
{
	g_return_if_fail (key != NULL);
}

void
granite_services_settings_verify (GraniteServicesSettings* self,
                                  const gchar* key)
{
	GraniteServicesSettingsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GRANITE_SERVICES_SETTINGS_GET_CLASS (self);
	if (_klass_->verify) {
		_klass_->verify (self, key);
	}
}

static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}

static void
granite_services_settings_load_key (GraniteServicesSettings* self,
                                    const gchar* key)
{
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp0_;
	GParamSpec* prop = NULL;
	GObjectClass* _tmp1_;
	GParamSpec* _tmp2_;
	GParamSpec* _tmp3_;
	GParamSpec* _tmp4_;
	guint _tmp5_;
	GType type = 0UL;
	GParamSpec* _tmp6_;
	GValue val = {0};
	GValue _tmp7_ = {0};
	GParamSpec* _tmp8_;
	const gchar* _tmp9_;
	GParamSpec* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "schema") == 0) {
		return;
	}
	_tmp0_ = g_type_class_ref (G_TYPE_FROM_INSTANCE ((GObject*) self));
	obj_class = (GObjectClass*) _tmp0_;
	_tmp1_ = obj_class;
	_tmp2_ = g_object_class_find_property (_tmp1_, key);
	_tmp3_ = _g_param_spec_ref0 (_tmp2_);
	prop = _tmp3_;
	_tmp4_ = prop;
	if (_tmp4_ == NULL) {
		_g_param_spec_unref0 (prop);
		_g_type_class_unref0 (obj_class);
		return;
	}
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _granite_services_settings_handle_notify_g_object_notify, self);
	_tmp6_ = prop;
	type = _tmp6_->value_type;
	g_value_init (&_tmp7_, type);
	val = _tmp7_;
	_tmp8_ = prop;
	_tmp9_ = _tmp8_->name;
	g_object_get_property ((GObject*) self, _tmp9_, &val);
	_tmp10_ = prop;
	if (G_VALUE_TYPE (&val) == _tmp10_->value_type) {
		if (type == G_TYPE_INT) {
			GParamSpec* _tmp11_;
			const gchar* _tmp12_;
			GSettings* _tmp13_;
			GValue _tmp14_ = {0};
			_tmp11_ = prop;
			_tmp12_ = _tmp11_->name;
			_tmp13_ = self->priv->_schema;
			g_value_init (&_tmp14_, G_TYPE_INT);
			g_value_set_int (&_tmp14_, g_settings_get_int (_tmp13_, key));
			g_object_set_property ((GObject*) self, _tmp12_, &_tmp14_);
			G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		} else {
			if (type == G_TYPE_UINT) {
				GParamSpec* _tmp15_;
				const gchar* _tmp16_;
				GSettings* _tmp17_;
				GValue _tmp18_ = {0};
				_tmp15_ = prop;
				_tmp16_ = _tmp15_->name;
				_tmp17_ = self->priv->_schema;
				g_value_init (&_tmp18_, G_TYPE_UINT);
				g_value_set_uint (&_tmp18_, g_settings_get_uint (_tmp17_, key));
				g_object_set_property ((GObject*) self, _tmp16_, &_tmp18_);
				G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
			} else {
				if (type == G_TYPE_DOUBLE) {
					GParamSpec* _tmp19_;
					const gchar* _tmp20_;
					GSettings* _tmp21_;
					GValue _tmp22_ = {0};
					_tmp19_ = prop;
					_tmp20_ = _tmp19_->name;
					_tmp21_ = self->priv->_schema;
					g_value_init (&_tmp22_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp22_, g_settings_get_double (_tmp21_, key));
					g_object_set_property ((GObject*) self, _tmp20_, &_tmp22_);
					G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
				} else {
					if (type == G_TYPE_STRING) {
						GParamSpec* _tmp23_;
						const gchar* _tmp24_;
						GSettings* _tmp25_;
						gchar* _tmp26_;
						GValue _tmp27_ = {0};
						_tmp23_ = prop;
						_tmp24_ = _tmp23_->name;
						_tmp25_ = self->priv->_schema;
						_tmp26_ = g_settings_get_string (_tmp25_, key);
						g_value_init (&_tmp27_, G_TYPE_STRING);
						g_value_take_string (&_tmp27_, _tmp26_);
						g_object_set_property ((GObject*) self, _tmp24_, &_tmp27_);
						G_IS_VALUE (&_tmp27_) ? (g_value_unset (&_tmp27_), NULL) : NULL;
					} else {
						if (type == G_TYPE_STRV) {
							GParamSpec* _tmp28_;
							const gchar* _tmp29_;
							GSettings* _tmp30_;
							gchar** _tmp31_;
							gchar** _tmp32_;
							GValue _tmp33_ = {0};
							_tmp28_ = prop;
							_tmp29_ = _tmp28_->name;
							_tmp30_ = self->priv->_schema;
							_tmp32_ = _tmp31_ = g_settings_get_strv (_tmp30_, key);
							g_value_init (&_tmp33_, G_TYPE_STRV);
							g_value_take_boxed (&_tmp33_, _tmp32_);
							g_object_set_property ((GObject*) self, _tmp29_, &_tmp33_);
							G_IS_VALUE (&_tmp33_) ? (g_value_unset (&_tmp33_), NULL) : NULL;
						} else {
							if (type == G_TYPE_BOOLEAN) {
								GParamSpec* _tmp34_;
								const gchar* _tmp35_;
								GSettings* _tmp36_;
								GValue _tmp37_ = {0};
								_tmp34_ = prop;
								_tmp35_ = _tmp34_->name;
								_tmp36_ = self->priv->_schema;
								g_value_init (&_tmp37_, G_TYPE_BOOLEAN);
								g_value_set_boolean (&_tmp37_, g_settings_get_boolean (_tmp36_, key));
								g_object_set_property ((GObject*) self, _tmp35_, &_tmp37_);
								G_IS_VALUE (&_tmp37_) ? (g_value_unset (&_tmp37_), NULL) : NULL;
							} else {
								if (type == G_TYPE_INT64) {
									GParamSpec* _tmp38_;
									const gchar* _tmp39_;
									GSettings* _tmp40_;
									GVariant* _tmp41_;
									GVariant* _tmp42_;
									GValue _tmp43_ = {0};
									_tmp38_ = prop;
									_tmp39_ = _tmp38_->name;
									_tmp40_ = self->priv->_schema;
									_tmp41_ = g_settings_get_value (_tmp40_, key);
									_tmp42_ = _tmp41_;
									g_value_init (&_tmp43_, G_TYPE_INT64);
									g_value_set_int64 (&_tmp43_, g_variant_get_int64 (_tmp42_));
									g_object_set_property ((GObject*) self, _tmp39_, &_tmp43_);
									G_IS_VALUE (&_tmp43_) ? (g_value_unset (&_tmp43_), NULL) : NULL;
									_g_variant_unref0 (_tmp42_);
								} else {
									if (type == G_TYPE_UINT64) {
										GParamSpec* _tmp44_;
										const gchar* _tmp45_;
										GSettings* _tmp46_;
										GVariant* _tmp47_;
										GVariant* _tmp48_;
										GValue _tmp49_ = {0};
										_tmp44_ = prop;
										_tmp45_ = _tmp44_->name;
										_tmp46_ = self->priv->_schema;
										_tmp47_ = g_settings_get_value (_tmp46_, key);
										_tmp48_ = _tmp47_;
										g_value_init (&_tmp49_, G_TYPE_UINT64);
										g_value_set_uint64 (&_tmp49_, g_variant_get_uint64 (_tmp48_));
										g_object_set_property ((GObject*) self, _tmp45_, &_tmp49_);
										G_IS_VALUE (&_tmp49_) ? (g_value_unset (&_tmp49_), NULL) : NULL;
										_g_variant_unref0 (_tmp48_);
									} else {
										if (G_TYPE_IS_ENUM (type)) {
											GParamSpec* _tmp50_;
											const gchar* _tmp51_;
											GSettings* _tmp52_;
											GValue _tmp53_ = {0};
											_tmp50_ = prop;
											_tmp51_ = _tmp50_->name;
											_tmp52_ = self->priv->_schema;
											g_value_init (&_tmp53_, G_TYPE_INT);
											g_value_set_int (&_tmp53_, g_settings_get_enum (_tmp52_, key));
											g_object_set_property ((GObject*) self, _tmp51_, &_tmp53_);
											G_IS_VALUE (&_tmp53_) ? (g_value_unset (&_tmp53_), NULL) : NULL;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (g_type_is_a (type, GRANITE_SERVICES_TYPE_SETTINGS_SERIALIZABLE)) {
			GObject* _tmp54_;
			GSettings* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			g_object_get_property ((GObject*) self, key, &val);
			_tmp54_ = g_value_get_object (&val);
			_tmp55_ = self->priv->_schema;
			_tmp56_ = g_settings_get_string (_tmp55_, key);
			_tmp57_ = _tmp56_;
			granite_services_settings_serializable_settings_deserialize (GRANITE_SERVICES_IS_SETTINGS_SERIALIZABLE (_tmp54_) ? ((GraniteServicesSettingsSerializable*) _tmp54_) : NULL, _tmp57_);
			_g_free0 (_tmp57_);
			g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_notify_g_object_notify, self, 0);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_param_spec_unref0 (prop);
			_g_type_class_unref0 (obj_class);
			return;
		} else {
			const gchar* _tmp58_;
			GSettings* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp58_ = g_type_name (type);
			_tmp59_ = self->priv->_schema;
			g_object_get (_tmp59_, "schema-id", &_tmp60_, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_;
			g_debug ("Settings.vala:251: Unsupported settings type '%s' for key '%s' in sche" \
"ma '%s'", _tmp58_, key, _tmp62_);
			_g_free0 (_tmp62_);
			g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_notify_g_object_notify, self, 0);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_param_spec_unref0 (prop);
			_g_type_class_unref0 (obj_class);
			return;
		}
	}
	granite_services_settings_call_verify (self, key);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_notify_g_object_notify, self, 0);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	_g_param_spec_unref0 (prop);
	_g_type_class_unref0 (obj_class);
}

static void
granite_services_settings_save_key (GraniteServicesSettings* self,
                                    const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp1_;
	GParamSpec* prop = NULL;
	GObjectClass* _tmp2_;
	GParamSpec* _tmp3_;
	GParamSpec* _tmp4_;
	GParamSpec* _tmp5_;
	gboolean success = FALSE;
	guint _tmp6_;
	GType type = 0UL;
	GParamSpec* _tmp7_;
	GValue val = {0};
	GValue _tmp8_ = {0};
	GParamSpec* _tmp9_;
	const gchar* _tmp10_;
	GParamSpec* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "schema") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->saving_key;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_type_class_ref (G_TYPE_FROM_INSTANCE ((GObject*) self));
	obj_class = (GObjectClass*) _tmp1_;
	_tmp2_ = obj_class;
	_tmp3_ = g_object_class_find_property (_tmp2_, key);
	_tmp4_ = _g_param_spec_ref0 (_tmp3_);
	prop = _tmp4_;
	_tmp5_ = prop;
	if (_tmp5_ == NULL) {
		_g_param_spec_unref0 (prop);
		_g_type_class_unref0 (obj_class);
		return;
	}
	success = TRUE;
	self->priv->saving_key = TRUE;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _granite_services_settings_handle_notify_g_object_notify, self);
	_tmp7_ = prop;
	type = _tmp7_->value_type;
	g_value_init (&_tmp8_, type);
	val = _tmp8_;
	_tmp9_ = prop;
	_tmp10_ = _tmp9_->name;
	g_object_get_property ((GObject*) self, _tmp10_, &val);
	_tmp11_ = prop;
	if (G_VALUE_TYPE (&val) == _tmp11_->value_type) {
		if (type == G_TYPE_INT) {
			GSettings* _tmp12_;
			_tmp12_ = self->priv->_schema;
			if (g_value_get_int (&val) != g_settings_get_int (_tmp12_, key)) {
				GSettings* _tmp13_;
				_tmp13_ = self->priv->_schema;
				success = g_settings_set_int (_tmp13_, key, g_value_get_int (&val));
			}
		} else {
			if (type == G_TYPE_UINT) {
				GSettings* _tmp14_;
				_tmp14_ = self->priv->_schema;
				if (g_value_get_uint (&val) != g_settings_get_uint (_tmp14_, key)) {
					GSettings* _tmp15_;
					_tmp15_ = self->priv->_schema;
					success = g_settings_set_uint (_tmp15_, key, g_value_get_uint (&val));
				}
			} else {
				if (type == G_TYPE_INT64) {
					GSettings* _tmp16_;
					GVariant* _tmp17_;
					GVariant* _tmp18_;
					gboolean _tmp19_;
					_tmp16_ = self->priv->_schema;
					_tmp17_ = g_settings_get_value (_tmp16_, key);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_value_get_int64 (&val) != g_variant_get_int64 (_tmp18_);
					_g_variant_unref0 (_tmp18_);
					if (_tmp19_) {
						GSettings* _tmp20_;
						GVariant* _tmp21_;
						GVariant* _tmp22_;
						_tmp20_ = self->priv->_schema;
						_tmp21_ = g_variant_new_int64 (g_value_get_int64 (&val));
						g_variant_ref_sink (_tmp21_);
						_tmp22_ = _tmp21_;
						success = g_settings_set_value (_tmp20_, key, _tmp22_);
						_g_variant_unref0 (_tmp22_);
					}
				} else {
					if (type == G_TYPE_UINT64) {
						GSettings* _tmp23_;
						GVariant* _tmp24_;
						GVariant* _tmp25_;
						gboolean _tmp26_;
						_tmp23_ = self->priv->_schema;
						_tmp24_ = g_settings_get_value (_tmp23_, key);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_value_get_uint64 (&val) != g_variant_get_uint64 (_tmp25_);
						_g_variant_unref0 (_tmp25_);
						if (_tmp26_) {
							GSettings* _tmp27_;
							GVariant* _tmp28_;
							GVariant* _tmp29_;
							_tmp27_ = self->priv->_schema;
							_tmp28_ = g_variant_new_uint64 (g_value_get_uint64 (&val));
							g_variant_ref_sink (_tmp28_);
							_tmp29_ = _tmp28_;
							success = g_settings_set_value (_tmp27_, key, _tmp29_);
							_g_variant_unref0 (_tmp29_);
						}
					} else {
						if (type == G_TYPE_DOUBLE) {
							GSettings* _tmp30_;
							_tmp30_ = self->priv->_schema;
							if (g_value_get_double (&val) != g_settings_get_double (_tmp30_, key)) {
								GSettings* _tmp31_;
								_tmp31_ = self->priv->_schema;
								success = g_settings_set_double (_tmp31_, key, g_value_get_double (&val));
							}
						} else {
							if (type == G_TYPE_STRING) {
								const gchar* _tmp32_;
								GSettings* _tmp33_;
								gchar* _tmp34_;
								gchar* _tmp35_;
								gboolean _tmp36_;
								_tmp32_ = g_value_get_string (&val);
								_tmp33_ = self->priv->_schema;
								_tmp34_ = g_settings_get_string (_tmp33_, key);
								_tmp35_ = _tmp34_;
								_tmp36_ = g_strcmp0 (_tmp32_, _tmp35_) != 0;
								_g_free0 (_tmp35_);
								if (_tmp36_) {
									GSettings* _tmp37_;
									const gchar* _tmp38_;
									_tmp37_ = self->priv->_schema;
									_tmp38_ = g_value_get_string (&val);
									success = g_settings_set_string (_tmp37_, key, _tmp38_);
								}
							} else {
								if (type == G_TYPE_STRV) {
									gchar** strings = NULL;
									gint strings_length1;
									gint _strings_size_;
									gchar** _tmp39_;
									gint _tmp39__length1;
									GSettings* _tmp40_;
									gchar** _tmp41_;
									gchar** _tmp42_;
									gchar** _tmp43_;
									gint _tmp43__length1;
									gboolean _tmp44_;
									strings = NULL;
									strings_length1 = 0;
									_strings_size_ = strings_length1;
									g_object_get ((GObject*) self, key, &strings, NULL);
									_tmp39_ = strings;
									_tmp39__length1 = strings_length1;
									_tmp40_ = self->priv->_schema;
									_tmp42_ = _tmp41_ = g_settings_get_strv (_tmp40_, key);
									_tmp43_ = _tmp42_;
									_tmp43__length1 = _vala_array_length (_tmp41_);
									_tmp44_ = _tmp39_ != _tmp43_;
									_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
									if (_tmp44_) {
										GSettings* _tmp45_;
										gchar** _tmp46_;
										gint _tmp46__length1;
										_tmp45_ = self->priv->_schema;
										_tmp46_ = strings;
										_tmp46__length1 = strings_length1;
										success = g_settings_set_strv (_tmp45_, key, _tmp46_);
									}
									strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
								} else {
									if (type == G_TYPE_BOOLEAN) {
										GSettings* _tmp47_;
										_tmp47_ = self->priv->_schema;
										if (g_value_get_boolean (&val) != g_settings_get_boolean (_tmp47_, key)) {
											GSettings* _tmp48_;
											_tmp48_ = self->priv->_schema;
											success = g_settings_set_boolean (_tmp48_, key, g_value_get_boolean (&val));
										}
									} else {
										if (G_TYPE_IS_ENUM (type)) {
											GSettings* _tmp49_;
											_tmp49_ = self->priv->_schema;
											if (g_value_get_enum (&val) != g_settings_get_enum (_tmp49_, key)) {
												GSettings* _tmp50_;
												_tmp50_ = self->priv->_schema;
												success = g_settings_set_enum (_tmp50_, key, g_value_get_enum (&val));
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (g_type_is_a (type, GRANITE_SERVICES_TYPE_SETTINGS_SERIALIZABLE)) {
			GSettings* _tmp51_;
			GObject* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp51_ = self->priv->_schema;
			_tmp52_ = g_value_get_object (&val);
			_tmp53_ = granite_services_settings_serializable_settings_serialize (GRANITE_SERVICES_IS_SETTINGS_SERIALIZABLE (_tmp52_) ? ((GraniteServicesSettingsSerializable*) _tmp52_) : NULL);
			_tmp54_ = _tmp53_;
			success = g_settings_set_string (_tmp51_, key, _tmp54_);
			_g_free0 (_tmp54_);
		} else {
			const gchar* _tmp55_;
			GSettings* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp55_ = g_type_name (type);
			_tmp56_ = self->priv->_schema;
			g_object_get (_tmp56_, "schema-id", &_tmp57_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = _tmp58_;
			g_debug ("Settings.vala:331: Unsupported settings type '%s' for key '%s' in sche" \
"ma '%s'", _tmp55_, key, _tmp59_);
			_g_free0 (_tmp59_);
		}
	}
	if (!success) {
		g_warning ("Settings.vala:340: Key '%s' could not be written to.", key);
	}
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _granite_services_settings_handle_notify_g_object_notify, self, 0);
	self->priv->saving_key = FALSE;
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	_g_param_spec_unref0 (prop);
	_g_type_class_unref0 (obj_class);
}

static GObject *
granite_services_settings_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteServicesSettings * self;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GObjectClass* obj_class = NULL;
	GTypeClass* _tmp4_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp5_;
	guint _tmp6_ = 0;
	GParamSpec** _tmp7_;
	gint properties_length1;
	gint _properties_size_;
	GParamSpec** _tmp8_;
	gint _tmp8__length1;
	parent_class = G_OBJECT_CLASS (granite_services_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_SETTINGS, GraniteServicesSettings);
	_tmp0_ = self->priv->_schema;
	g_object_get (_tmp0_, "schema-id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_debug ("Settings.vala:150: Loading settings from schema '%s'", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_type_class_ref (G_TYPE_FROM_INSTANCE ((GObject*) self));
	obj_class = (GObjectClass*) _tmp4_;
	_tmp5_ = obj_class;
	_tmp7_ = g_object_class_list_properties (_tmp5_, &_tmp6_);
	properties = _tmp7_;
	properties_length1 = _tmp6_;
	_properties_size_ = properties_length1;
	_tmp8_ = properties;
	_tmp8__length1 = properties_length1;
	{
		GParamSpec** prop_collection = NULL;
		gint prop_collection_length1 = 0;
		gint _prop_collection_size_ = 0;
		gint prop_it = 0;
		prop_collection = _tmp8_;
		prop_collection_length1 = _tmp8__length1;
		for (prop_it = 0; prop_it < prop_collection_length1; prop_it = prop_it + 1) {
			GParamSpec* prop = NULL;
			prop = prop_collection[prop_it];
			{
				GParamSpec* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = prop;
				_tmp10_ = _tmp9_->name;
				granite_services_settings_load_key (self, _tmp10_);
			}
		}
	}
	granite_services_settings_start_monitor (self);
	properties = (g_free (properties), NULL);
	_g_type_class_unref0 (obj_class);
	return obj;
}

static void
granite_services_settings_class_init (GraniteServicesSettingsClass * klass,
                                      gpointer klass_data)
{
	granite_services_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteServicesSettings_private_offset);
	((GraniteServicesSettingsClass *) klass)->verify = (void (*) (GraniteServicesSettings*, const gchar*)) granite_services_settings_real_verify;
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_services_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_services_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_services_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_services_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY, granite_services_settings_properties[GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY] = g_param_spec_object ("schema", "schema", "schema", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * This signal is to be used in place of the standard {@link GLib.Object.notify} signal.
	         *
	         * This signal ''only'' emits after a property's value was verified.
	         *
	         * Note that in the case where a property was set to an invalid value,
	         * (and thus, sanitized to a valid value), the {@link GLib.Object.notify} signal will emit
	         * twice: once with the invalid value and once with the sanitized value.
	         */
	granite_services_settings_signals[GRANITE_SERVICES_SETTINGS_CHANGED_SIGNAL] = g_signal_new ("changed", GRANITE_SERVICES_TYPE_SETTINGS, G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED | G_SIGNAL_NO_RECURSE | G_SIGNAL_ACTION | G_SIGNAL_NO_HOOKS, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_services_settings_instance_init (GraniteServicesSettings * self,
                                         gpointer klass)
{
	self->priv = granite_services_settings_get_instance_private (self);
}

static void
granite_services_settings_finalize (GObject * obj)
{
	GraniteServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_SERVICES_TYPE_SETTINGS, GraniteServicesSettings);
	granite_services_settings_stop_monitor (self);
	_g_object_unref0 (self->priv->_schema);
	G_OBJECT_CLASS (granite_services_settings_parent_class)->finalize (obj);
}

/**
     * Class for interacting with an internal {@link GLib.Settings} using native Vala properties.
     * Clients of this class should not connect to the {@link GLib.Object.notify} signal.
     * Instead, they should connect to the {@link Granite.Services.Settings.changed} signal.
     *
     * For example, if a developer wanted to interact with desktop.Wallpaper's (http:/www.launchpad.net/pantheon-wallpaper) schema,
     * this is what his/her subclass might look like:
     *
     * {{{
     *    public class WallpaperSettings : Granite.Services.Settings {
     *
     *        public PictureMode picture_mode { get; set; }
     *
     *        public string picture_path { get; set; }
     *
     *        public string background_color { get; set; }
     *
     *        public WallpaperSettings () {
     *            base ("desktop.Wallpaper");
     *        }
     *
     *        protected override void verify (string key) {
     *
     *            switch (key) {
     *
     *                case "background-color":
     *                    Gdk.Color bg;
     *                    if (!Gdk.Color.parse (background_color, out bg))
     *                        background_color = "#000000";
     *                    break;
     *            }
     *        }
     *
     *    }
     * }}}
     *
     * Keep in mind that the developer must define his/her enums to match the schema's.
     *
     * The following is a simplified explanation of how this library works:
*
     *  1. Any subclass looks at all properties it contains, and loads their initial values from the keys they represent.
     *     Because Vala properties are stored as GLib properties, the string representation of a property replaces underscores with
     *     hyphens (i.e. property_name becomes "property-name"). This is how this library knows which keys to load from. If the key
     *     does not exist, it will result in a fatal error.
     *  1. When a property of the subclass changes, the library will first verify the data before emitting a changed signal. If necessary,
     *     the library will change the value of the property while verifying.
     *     This is why developers should only act upon emissions of the changed () signal and never the native {@link GLib.Object.notify} signal.
     *  1. When the corresponding key of one of the properties of the subclass changes, it will also verify the data and change it, if necessary,
     *     before loading it into as the corresponding property's value.
     */
static GType
granite_services_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteServicesSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_services_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteServicesSettings), 0, (GInstanceInitFunc) granite_services_settings_instance_init, NULL };
	GType granite_services_settings_type_id;
	granite_services_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteServicesSettings", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GraniteServicesSettings_private_offset = g_type_add_instance_private (granite_services_settings_type_id, sizeof (GraniteServicesSettingsPrivate));
	return granite_services_settings_type_id;
}

GType
granite_services_settings_get_type (void)
{
	static volatile gsize granite_services_settings_type_id__once = 0;
	if (g_once_init_enter (&granite_services_settings_type_id__once)) {
		GType granite_services_settings_type_id;
		granite_services_settings_type_id = granite_services_settings_get_type_once ();
		g_once_init_leave (&granite_services_settings_type_id__once, granite_services_settings_type_id);
	}
	return granite_services_settings_type_id__once;
}

static void
_vala_granite_services_settings_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GraniteServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_SETTINGS, GraniteServicesSettings);
	switch (property_id) {
		case GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY:
		g_value_set_object (value, granite_services_settings_get_schema (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_services_settings_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GraniteServicesSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_SERVICES_TYPE_SETTINGS, GraniteServicesSettings);
	switch (property_id) {
		case GRANITE_SERVICES_SETTINGS_SCHEMA_PROPERTY:
		granite_services_settings_set_schema (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

