/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_protocol_parser_b = R"doc(Block that synchronizes to a header based on a header format object class. Designed to accept hard bits and produce PDUs with packed bytes (pmt::u8vector).

A packet synchronizer block. This block takes in hard bits (unpacked bytes; 1's and 0's as the LSB) and finds the access code as a sync word to find the start of a frame.


The block uses a format object derived from a header_format_base class.


Once the frame is detected (usually through the use of an access code), the block uses the format object's parser function to decode the remaining header. Generally, as in the default header case, the header will contain the length of the frame's payload. That and anything else in the header will generally go into the PDU's meta-data dictionary.


The block will output a PDU that contains frame's header info in the meta-data portion of the PDU and the payload itself. The payload is packed hard bits as taken from the input stream.

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when reading the header.)doc";


static const char* __doc_gr_digital_protocol_parser_b_protocol_parser_b = R"doc()doc";


static const char* __doc_gr_digital_protocol_parser_b_make = R"doc(Block that synchronizes to a header based on a header format object class. Designed to accept hard bits and produce PDUs with packed bytes (pmt::u8vector).

A packet synchronizer block. This block takes in hard bits (unpacked bytes; 1's and 0's as the LSB) and finds the access code as a sync word to find the start of a frame.


The block uses a format object derived from a header_format_base class.


Once the frame is detected (usually through the use of an access code), the block uses the format object's parser function to decode the remaining header. Generally, as in the default header case, the header will contain the length of the frame's payload. That and anything else in the header will generally go into the PDU's meta-data dictionary.


The block will output a PDU that contains frame's header info in the meta-data portion of the PDU and the payload itself. The payload is packed hard bits as taken from the input stream.

Constructor Specific Documentation:

Make a packet header block using a given .

Args:
    format : The format object to use when reading the header.)doc";
