/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_probe_rate = R"doc(throughput measurement

Constructor Specific Documentation:

Make a throughput measurement block.

If the name is empty, the \"name\" field in the emitted dictionaries is omitted.

Args:
    itemsize : size of each stream item
    update_rate_ms : minimum update time in milliseconds
    alpha : gain for running average filter
    name : name for this probe (used in generated dictionaries))doc";


static const char* __doc_gr_blocks_probe_rate_probe_rate_0 = R"doc()doc";


static const char* __doc_gr_blocks_probe_rate_probe_rate_1 = R"doc()doc";


static const char* __doc_gr_blocks_probe_rate_make = R"doc(throughput measurement

Constructor Specific Documentation:

Make a throughput measurement block.

If the name is empty, the \"name\" field in the emitted dictionaries is omitted.

Args:
    itemsize : size of each stream item
    update_rate_ms : minimum update time in milliseconds
    alpha : gain for running average filter
    name : name for this probe (used in generated dictionaries))doc";


static const char* __doc_gr_blocks_probe_rate_set_alpha = R"doc(Set the decay of the exponential rate average.)doc";


static const char* __doc_gr_blocks_probe_rate_set_name = R"doc(Set the name of this probe Used in the emitted dictionaries if not empty.)doc";


static const char* __doc_gr_blocks_probe_rate_rate = R"doc()doc";


static const char* __doc_gr_blocks_probe_rate_start = R"doc(Called to enable drivers, etc for i/o devices.

This allows a block to enable an associated driver to begin transferring data just before we start to execute the scheduler. The end result is that this reduces latency in the pipeline when dealing with audio devices, usrps, etc.)doc";


static const char* __doc_gr_blocks_probe_rate_stop = R"doc(Called to disable drivers, etc for i/o devices.)doc";
