/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(0)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(rfnoc_siggen.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(1922e286fceb59c26560c6e094e8ef18)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/uhd/rfnoc_siggen.h>
// pydoc.h is automatically generated in the build directory
#include <rfnoc_siggen_pydoc.h>

void bind_rfnoc_siggen(py::module& m)
{

    using rfnoc_siggen = ::gr::uhd::rfnoc_siggen;


    py::class_<rfnoc_siggen,
               gr::uhd::rfnoc_block,
               gr::block,
               gr::basic_block,
               std::shared_ptr<rfnoc_siggen>>
        siggen_class(m, "rfnoc_siggen", D(rfnoc_siggen));


    siggen_class.def(py::init(&rfnoc_siggen::make),
                     py::arg("graph"),
                     py::arg("block_args"),
                     py::arg("device_select"),
                     py::arg("instance"),
                     D(rfnoc_siggen, make));


    siggen_class.def("set_amplitude",
                     &rfnoc_siggen::set_amplitude,
                     py::arg("amplitude"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_amplitude));


    siggen_class.def("get_amplitude",
                     &rfnoc_siggen::get_amplitude,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_amplitude));


    siggen_class.def("set_constant",
                     &rfnoc_siggen::set_constant,
                     py::arg("constant"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_constant));


    siggen_class.def("get_constant",
                     &rfnoc_siggen::get_constant,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_constant));


    siggen_class.def("set_enable",
                     &rfnoc_siggen::set_enable,
                     py::arg("enable"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_enable));


    siggen_class.def("get_enable",
                     &rfnoc_siggen::get_enable,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_enable));


    siggen_class.def("set_sine_frequency",
                     &rfnoc_siggen::set_sine_frequency,
                     py::arg("frequency"),
                     py::arg("sample_rate"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_sine_frequency));


    siggen_class.def("set_sine_phase_increment",
                     &rfnoc_siggen::set_sine_phase_increment,
                     py::arg("phase_inc"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_sine_phase_increment));


    siggen_class.def("get_sine_phase_increment",
                     &rfnoc_siggen::get_sine_phase_increment,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_sine_phase_increment));


    siggen_class.def("set_waveform",
                     py::overload_cast<const rfnoc_siggen::siggen_waveform, const size_t>(
                         &rfnoc_siggen::set_waveform),
                     py::arg("type"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_waveform));


    siggen_class.def(
        "set_waveform",
        py::overload_cast<const std::string&, const size_t>(&rfnoc_siggen::set_waveform),
        py::arg("type"),
        py::arg("chan") = 0,
        D(rfnoc_siggen, set_waveform));


    siggen_class.def("get_waveform_string",
                     &rfnoc_siggen::get_waveform_string,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_waveform_string));


    siggen_class.def("get_waveform",
                     &rfnoc_siggen::get_waveform,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_waveform));


    siggen_class.def("set_samples_per_packet",
                     &rfnoc_siggen::set_samples_per_packet,
                     py::arg("spp"),
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, set_samples_per_packet));


    siggen_class.def("get_samples_per_packet",
                     &rfnoc_siggen::get_samples_per_packet,
                     py::arg("chan") = 0,
                     D(rfnoc_siggen, get_samples_per_packet));


    py::enum_<rfnoc_siggen::siggen_waveform>(siggen_class, "siggen_waveform")
        .value("CONSTANT", rfnoc_siggen::siggen_waveform::CONSTANT)
        .value("SINE_WAVE", rfnoc_siggen::siggen_waveform::SINE_WAVE)
        .value("NOISE", rfnoc_siggen::siggen_waveform::NOISE);
}
