/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_pfb_decimator_ccf = R"doc(Polyphase filterbank bandpass decimator with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and performs integer down- sampling (decimation) with a polyphase filterbank. The first input is the integer specifying how much to decimate by. The second input is a vector (Python list) of floating-point taps of the prototype filter. The third input specifies the channel to extract. By default, the zeroth channel is used, which is the baseband channel (first Nyquist zone).


The  parameter specifies which channel to use since this class is capable of bandpass decimation. Given a complex input stream at a sampling rate of  and a decimation rate of , the input frequency domain is split into  channels that represent the Nyquist zones. Using the polyphase filterbank, we can select any one of these channels to decimate.


The output signal will be the basebanded and decimated signal from that channel. This concept is very similar to the PFB channelizer (see gr::filter::pfb_channelizer_ccf) where only a single channel is extracted at a time.


The filter's taps should be based on the sampling rate before decimation.


For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





The PFB decimator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


The theory behind this block can be found in Chapter 6 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank decimator.

Args:
    decim : (unsigned integer) Specifies the decimation rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank.
    channel : (unsigned integer) Selects the channel to return [default=0].
    use_fft_rotator : (bool) Rotate channels using FFT method instead of exp(phi). For larger values of , the FFT method will perform better. Generally, this value of  is small (~5), but could be architecture-specific (Default: true).
    use_fft_filters : (bool) Use FFT filters (fast convolution) instead of FIR filters. FFT filters perform better for larger numbers of taps but is architecture-specific (Default: true).)doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_pfb_decimator_ccf_0 = R"doc()doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_pfb_decimator_ccf_1 = R"doc()doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_make = R"doc(Polyphase filterbank bandpass decimator with gr_complex input, gr_complex output and float taps.

This block takes in a signal stream and performs integer down- sampling (decimation) with a polyphase filterbank. The first input is the integer specifying how much to decimate by. The second input is a vector (Python list) of floating-point taps of the prototype filter. The third input specifies the channel to extract. By default, the zeroth channel is used, which is the baseband channel (first Nyquist zone).


The  parameter specifies which channel to use since this class is capable of bandpass decimation. Given a complex input stream at a sampling rate of  and a decimation rate of , the input frequency domain is split into  channels that represent the Nyquist zones. Using the polyphase filterbank, we can select any one of these channels to decimate.


The output signal will be the basebanded and decimated signal from that channel. This concept is very similar to the PFB channelizer (see gr::filter::pfb_channelizer_ccf) where only a single channel is extracted at a time.


The filter's taps should be based on the sampling rate before decimation.


For example, using the GNU Radio's firdes utility to building filters, we build a low-pass filter with a sampling rate of , a 3-dB bandwidth of  and a transition bandwidth of . We can also specify the out-of-band attenuation to use, , and the filter window function (a Blackman-harris window in this case). The first input is the gain of the filter, which we specify here as unity.





The PFB decimator code takes the taps generated above and builds a set of filters. The set contains  filters and each filter contains ceil(taps.size()/decim) taps. Each tap from the filter prototype is sequentially inserted into the next filter. When all of the input taps are used, the remaining filters in the filterbank are filled out with 0's to make sure each filter has the same number of taps.


The theory behind this block can be found in Chapter 6 of the following book:

Constructor Specific Documentation:

Build the polyphase filterbank decimator.

Args:
    decim : (unsigned integer) Specifies the decimation rate to use
    taps : (vector/list of floats) The prototype filter to populate the filterbank.
    channel : (unsigned integer) Selects the channel to return [default=0].
    use_fft_rotator : (bool) Rotate channels using FFT method instead of exp(phi). For larger values of , the FFT method will perform better. Generally, this value of  is small (~5), but could be architecture-specific (Default: true).
    use_fft_filters : (bool) Use FFT filters (fast convolution) instead of FIR filters. FFT filters perform better for larger numbers of taps but is architecture-specific (Default: true).)doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_set_taps = R"doc(Resets the filterbank's filter taps with the new prototype filter)doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_taps = R"doc(Return a vector<vector<>> of the filterbank taps)doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_print_taps = R"doc(Print all of the filterbank taps to screen.)doc";


static const char* __doc_gr_filter_pfb_decimator_ccf_set_channel = R"doc()doc";
