/* theme-neoretro.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from theme-neoretro.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define NEO_RETRO_THEME_HALF_PI G_PI_2
#define PUZZLE_VIEW_gap_factor 0.5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ThemePrivate ThemePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;

#define TYPE_NEO_RETRO_THEME (neo_retro_theme_get_type ())
#define NEO_RETRO_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEO_RETRO_THEME, NeoRetroTheme))
#define NEO_RETRO_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEO_RETRO_THEME, NeoRetroThemeClass))
#define IS_NEO_RETRO_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEO_RETRO_THEME))
#define IS_NEO_RETRO_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEO_RETRO_THEME))
#define NEO_RETRO_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEO_RETRO_THEME, NeoRetroThemeClass))

typedef struct _NeoRetroTheme NeoRetroTheme;
typedef struct _NeoRetroThemeClass NeoRetroThemeClass;
typedef struct _NeoRetroThemePrivate NeoRetroThemePrivate;
enum  {
	NEO_RETRO_THEME_0_PROPERTY,
	NEO_RETRO_THEME_NUM_PROPERTIES
};
static GParamSpec* neo_retro_theme_properties[NEO_RETRO_THEME_NUM_PROPERTIES];
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _TilePrivate TilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
};

struct _ThemeClass {
	GObjectClass parent_class;
	void (*configure) (Theme* self, guint size);
	void (*draw_arrow) (Theme* self, cairo_t* context);
	void (*draw_socket) (Theme* self, cairo_t* context);
	void (*draw_highlight) (Theme* self, cairo_t* context, gboolean has_tile);
	void (*draw_paused_tile) (Theme* self, cairo_t* context);
	void (*draw_tile) (Theme* self, cairo_t* context, Tile* tile, gboolean highlight);
	void (*set_animation_level) (Theme* self, guint8 animation_level);
};

struct _NeoRetroTheme {
	Theme parent_instance;
	NeoRetroThemePrivate * priv;
};

struct _NeoRetroThemeClass {
	ThemeClass parent_class;
};

struct _NeoRetroThemePrivate {
	cairo_pattern_t* tile_colors_h[10];
	cairo_pattern_t* tile_colors_v[10];
	cairo_pattern_t* tile_highlights_h[10];
	cairo_pattern_t* tile_highlights_v[10];
	cairo_pattern_t* text_colors[10];
	cairo_pattern_t* black_text_color;
	cairo_pattern_t* white_text_color;
	cairo_pattern_t* paused_color_h;
	cairo_pattern_t* paused_color_v;
	guint size;
	guint8 animation_level;
	gdouble arrow_half_h;
	gdouble neg_arrow_half_h;
	gdouble arrow_w;
	gdouble arrow_x;
	gdouble arrow_clip_x;
	gdouble arrow_clip_y;
	gdouble arrow_clip_w;
	gdouble arrow_clip_h;
	gdouble arrow_border_opacity;
	gdouble arrow_fill_opacity;
	guint socket_margin;
	gint socket_size;
	cairo_pattern_t* socket_pattern;
	cairo_matrix_t matrix;
	cairo_pattern_t* highlight_tile_pattern;
	guint tile_margin;
	gint tile_size;
	gdouble half_tile_size;
	gdouble font_size;
	gdouble north_number_y;
	gdouble south_number_y;
	gdouble east_number_x;
	gdouble west_number_x;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	guint8 north;
	guint8 west;
	guint8 east;
	guint8 south;
};

struct _TileClass {
	GObjectClass parent_class;
};

static gint NeoRetroTheme_private_offset;
static gpointer neo_retro_theme_parent_class = NULL;

VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType neo_retro_theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NeoRetroTheme, g_object_unref)
VALA_EXTERN void theme_configure (Theme* self,
                      guint size);
VALA_EXTERN void theme_set_animation_level (Theme* self,
                                guint8 animation_level);
VALA_EXTERN void theme_draw_arrow (Theme* self,
                       cairo_t* context);
VALA_EXTERN void theme_draw_socket (Theme* self,
                        cairo_t* context);
VALA_EXTERN void theme_draw_highlight (Theme* self,
                           cairo_t* context,
                           gboolean has_tile);
VALA_EXTERN void theme_draw_paused_tile (Theme* self,
                             cairo_t* context);
VALA_EXTERN void theme_draw_tile (Theme* self,
                      cairo_t* context,
                      Tile* tile,
                      gboolean highlight);
static void neo_retro_theme_make_color_pattern (NeoRetroTheme* self,
                                         guint position,
                                         const gchar* color,
                                         gboolean white_text);
static cairo_pattern_t* neo_retro_theme_make_dir_color_pattern (const gchar* color,
                                                         gboolean vertical,
                                                         gdouble color_factor);
static gdouble neo_retro_theme_hex_value (gchar c);
static void neo_retro_theme_real_configure (Theme* base,
                                     guint new_size);
static void neo_retro_theme_init_socket_pattern (NeoRetroTheme* self);
static void neo_retro_theme_real_set_animation_level (Theme* base,
                                               guint8 new_animation_level);
static void neo_retro_theme_real_draw_arrow (Theme* base,
                                      cairo_t* context);
static void neo_retro_theme_real_draw_socket (Theme* base,
                                       cairo_t* context);
static void neo_retro_theme_rounded_square (cairo_t* context,
                                     gdouble x,
                                     gdouble y,
                                     gint size,
                                     gdouble radius_percent);
static void neo_retro_theme_real_draw_highlight (Theme* base,
                                          cairo_t* context,
                                          gboolean has_tile);
static void neo_retro_theme_real_draw_paused_tile (Theme* base,
                                            cairo_t* context);
static void neo_retro_theme_draw_tile_background (NeoRetroTheme* self,
                                           cairo_t* context,
                                           cairo_pattern_t* north_color,
                                           cairo_pattern_t* east_color,
                                           cairo_pattern_t* south_color,
                                           cairo_pattern_t* west_color);
static void neo_retro_theme_real_draw_tile (Theme* base,
                                     cairo_t* context,
                                     Tile* tile,
                                     gboolean highlight);
static void neo_retro_theme_draw_number (cairo_t* context,
                                  cairo_pattern_t* text_color,
                                  gdouble x,
                                  gdouble y,
                                  guint8 number);
VALA_EXTERN NeoRetroTheme* neo_retro_theme_new (void);
VALA_EXTERN NeoRetroTheme* neo_retro_theme_construct (GType object_type);
VALA_EXTERN Theme* theme_construct (GType object_type);
static GObject * neo_retro_theme_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void neo_retro_theme_finalize (GObject * obj);
static GType neo_retro_theme_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
neo_retro_theme_get_instance_private (NeoRetroTheme* self)
{
	return G_STRUCT_MEMBER_P (self, NeoRetroTheme_private_offset);
}

static void
neo_retro_theme_make_color_pattern (NeoRetroTheme* self,
                                    guint position,
                                    const gchar* color,
                                    gboolean white_text)
{
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = neo_retro_theme_make_dir_color_pattern (color, FALSE, 1.0);
	_cairo_pattern_destroy0 (self->priv->tile_colors_h[position]);
	self->priv->tile_colors_h[position] = _tmp0_;
	_tmp1_ = neo_retro_theme_make_dir_color_pattern (color, TRUE, 1.0);
	_cairo_pattern_destroy0 (self->priv->tile_colors_v[position]);
	self->priv->tile_colors_v[position] = _tmp1_;
	_tmp2_ = neo_retro_theme_make_dir_color_pattern (color, FALSE, 1.4);
	_cairo_pattern_destroy0 (self->priv->tile_highlights_h[position]);
	self->priv->tile_highlights_h[position] = _tmp2_;
	_tmp3_ = neo_retro_theme_make_dir_color_pattern (color, TRUE, 1.4);
	_cairo_pattern_destroy0 (self->priv->tile_highlights_v[position]);
	self->priv->tile_highlights_v[position] = _tmp3_;
	if (white_text) {
		cairo_pattern_t* _tmp4_;
		_tmp4_ = self->priv->white_text_color;
		self->priv->text_colors[position] = _tmp4_;
	} else {
		cairo_pattern_t* _tmp5_;
		_tmp5_ = self->priv->black_text_color;
		self->priv->text_colors[position] = _tmp5_;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static cairo_pattern_t*
neo_retro_theme_make_dir_color_pattern (const gchar* color,
                                        gboolean vertical,
                                        gdouble color_factor)
{
	gdouble r0 = 0.0;
	gdouble g0 = 0.0;
	gdouble b0 = 0.0;
	gdouble r1 = 0.0;
	gdouble g1 = 0.0;
	gdouble b1 = 0.0;
	gdouble r2 = 0.0;
	gdouble g2 = 0.0;
	gdouble b2 = 0.0;
	gdouble r5 = 0.0;
	gdouble g5 = 0.0;
	gdouble b5 = 0.0;
	cairo_pattern_t* pattern = NULL;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* result;
	g_return_val_if_fail (color != NULL, NULL);
	r0 = (((neo_retro_theme_hex_value (string_get (color, (glong) 0)) * 16) + neo_retro_theme_hex_value (string_get (color, (glong) 1))) / 255.0) * color_factor;
	g0 = (((neo_retro_theme_hex_value (string_get (color, (glong) 2)) * 16) + neo_retro_theme_hex_value (string_get (color, (glong) 3))) / 255.0) * color_factor;
	b0 = (((neo_retro_theme_hex_value (string_get (color, (glong) 4)) * 16) + neo_retro_theme_hex_value (string_get (color, (glong) 5))) / 255.0) * color_factor;
	r1 = MIN (r0 + 0.10, 1.0);
	g1 = MIN (g0 + 0.10, 1.0);
	b1 = MIN (b0 + 0.10, 1.0);
	r2 = MIN (r0 + 0.25, 1.0);
	g2 = MIN (g0 + 0.25, 1.0);
	b2 = MIN (b0 + 0.25, 1.0);
	r5 = MIN (r0 + 0.15, 1.0);
	g5 = MIN (g0 + 0.15, 1.0);
	b5 = MIN (b0 + 0.15, 1.0);
	if (vertical) {
		cairo_pattern_t* _tmp0_;
		_tmp0_ = cairo_pattern_create_linear (0.0, 0.0, 1.0, 0.0);
		_cairo_pattern_destroy0 (pattern);
		pattern = _tmp0_;
	} else {
		cairo_pattern_t* _tmp1_;
		_tmp1_ = cairo_pattern_create_linear (0.0, 0.0, 0.0, 1.0);
		_cairo_pattern_destroy0 (pattern);
		pattern = _tmp1_;
	}
	_tmp2_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp2_, 0.00, r2, g2, b2, 1.0);
	_tmp3_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp3_, 0.08, r1, g1, b1, 1.0);
	_tmp4_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp4_, 0.50, r5, g5, b5, 1.0);
	_tmp5_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp5_, 0.92, r1, g1, b1, 1.0);
	_tmp6_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp6_, 1.00, r0, g0, b0, 1.0);
	result = pattern;
	return result;
}

static gdouble
neo_retro_theme_hex_value (gchar c)
{
	gboolean _tmp0_ = FALSE;
	gdouble result;
	if (c >= '0') {
		_tmp0_ = c <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gdouble) (c - '0');
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (c >= 'a') {
			_tmp1_ = c <= 'f';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = (gdouble) ((c - 'a') + 10);
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (c >= 'A') {
				_tmp2_ = c <= 'F';
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = (gdouble) ((c - 'A') + 10);
				return result;
			} else {
				result = 0.0;
				return result;
			}
		}
	}
}

static void
neo_retro_theme_real_configure (Theme* base,
                                guint new_size)
{
	NeoRetroTheme * self;
	gboolean _tmp0_ = FALSE;
	gdouble highlight_radius = 0.0;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	self = (NeoRetroTheme*) base;
	if (self->priv->size != ((guint) 0)) {
		_tmp0_ = self->priv->size == new_size;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->arrow_half_h = new_size * 0.5;
	self->priv->neg_arrow_half_h = -self->priv->arrow_half_h;
	self->priv->arrow_w = (new_size * PUZZLE_VIEW_gap_factor) * 0.5;
	self->priv->arrow_x = ((new_size * PUZZLE_VIEW_gap_factor) - self->priv->arrow_w) * 0.5;
	self->priv->arrow_clip_x = -self->priv->arrow_x;
	self->priv->arrow_clip_y = (gdouble) (-new_size);
	self->priv->arrow_clip_w = (2.0 * self->priv->arrow_x) + self->priv->arrow_w;
	self->priv->arrow_clip_h = 2.0 * new_size;
	cairo_matrix_init_identity (&self->priv->matrix);
	cairo_matrix_scale (&self->priv->matrix, 1.0 / new_size, 1.0 / new_size);
	self->priv->socket_margin = MIN ((guint) (new_size * 0.05), (guint) 2);
	self->priv->socket_size = ((gint) new_size) - (((gint) self->priv->socket_margin) * 2);
	neo_retro_theme_init_socket_pattern (self);
	self->priv->half_tile_size = new_size * 0.5;
	highlight_radius = new_size * 0.45;
	_tmp1_ = cairo_pattern_create_radial (self->priv->half_tile_size, self->priv->half_tile_size, 0.0, self->priv->half_tile_size, self->priv->half_tile_size, highlight_radius);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	self->priv->highlight_tile_pattern = _tmp1_;
	_tmp2_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp2_, 0.0, 1.0, 1.0, 1.0, 1.0);
	_tmp3_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp3_, 0.2, 1.0, 1.0, 1.0, 0.8);
	_tmp4_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp4_, 0.3, 1.0, 1.0, 1.0, 0.5);
	_tmp5_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp5_, 0.4, 1.0, 1.0, 1.0, 0.2);
	_tmp6_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp6_, 0.5, 1.0, 1.0, 1.0, 0.1);
	_tmp7_ = self->priv->highlight_tile_pattern;
	cairo_pattern_add_color_stop_rgba (_tmp7_, 1.0, 1.0, 1.0, 1.0, 0.0);
	self->priv->tile_margin = MIN ((guint) (new_size * 0.05), (guint) 2) - 1;
	self->priv->tile_size = ((gint) new_size) - (((gint) self->priv->tile_margin) * 2);
	self->priv->font_size = (new_size * 4.0) / 19.0;
	self->priv->north_number_y = (new_size * 4.0) / 18.0;
	self->priv->south_number_y = (new_size * 14.0) / 18.0;
	self->priv->east_number_x = (new_size * 15.0) / 19.0;
	self->priv->west_number_x = (new_size * 4.0) / 19.0;
	self->priv->size = new_size;
}

static void
neo_retro_theme_real_set_animation_level (Theme* base,
                                          guint8 new_animation_level)
{
	NeoRetroTheme * self;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	self = (NeoRetroTheme*) base;
	self->priv->animation_level = new_animation_level;
	if (((gint) self->priv->animation_level) == 0) {
		_tmp0_ = 0.3;
	} else {
		_tmp0_ = (0.3 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0;
	}
	self->priv->arrow_border_opacity = _tmp0_;
	if (((gint) self->priv->animation_level) == 0) {
		_tmp1_ = 0.1;
	} else {
		_tmp1_ = (0.1 * (16.0 - ((gdouble) self->priv->animation_level))) / 16.0;
	}
	self->priv->arrow_fill_opacity = _tmp1_;
	neo_retro_theme_init_socket_pattern (self);
}

static void
neo_retro_theme_init_socket_pattern (NeoRetroTheme* self)
{
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	cairo_pattern_t* _tmp9_;
	cairo_pattern_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	cairo_matrix_t _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = cairo_pattern_create_mesh ();
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	self->priv->socket_pattern = _tmp0_;
	_tmp1_ = self->priv->socket_pattern;
	cairo_mesh_pattern_begin_patch (_tmp1_);
	_tmp2_ = self->priv->socket_pattern;
	cairo_mesh_pattern_move_to (_tmp2_, 0.0, 0.0);
	_tmp3_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp3_, 1.0, 0.0);
	_tmp4_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp4_, 1.0, 1.0);
	_tmp5_ = self->priv->socket_pattern;
	cairo_mesh_pattern_line_to (_tmp5_, 0.0, 1.0);
	_tmp6_ = self->priv->socket_pattern;
	cairo_mesh_pattern_set_corner_color_rgba (_tmp6_, (guint) 0, 0.3, 0.3, 0.3, self->priv->arrow_border_opacity);
	_tmp7_ = self->priv->socket_pattern;
	cairo_mesh_pattern_set_corner_color_rgba (_tmp7_, (guint) 1, 0.4, 0.4, 0.4, self->priv->arrow_border_opacity);
	_tmp8_ = self->priv->socket_pattern;
	cairo_mesh_pattern_set_corner_color_rgba (_tmp8_, (guint) 2, 0.7, 0.7, 0.7, self->priv->arrow_border_opacity);
	_tmp9_ = self->priv->socket_pattern;
	cairo_mesh_pattern_set_corner_color_rgba (_tmp9_, (guint) 3, 0.6, 0.6, 0.6, self->priv->arrow_border_opacity);
	_tmp10_ = self->priv->socket_pattern;
	cairo_mesh_pattern_end_patch (_tmp10_);
	_tmp11_ = self->priv->socket_pattern;
	_tmp12_ = self->priv->matrix;
	cairo_pattern_set_matrix (_tmp11_, &_tmp12_);
}

static void
neo_retro_theme_real_draw_arrow (Theme* base,
                                 cairo_t* context)
{
	NeoRetroTheme * self;
	self = (NeoRetroTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_translate (context, self->priv->arrow_x, 0.0);
	cairo_rectangle (context, self->priv->arrow_clip_x, self->priv->arrow_clip_y, self->priv->arrow_clip_w, self->priv->arrow_clip_h);
	cairo_move_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_curve_to (context, 0.0, 10.0, 0.0, -10.0, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_clip (context);
	cairo_move_to (context, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_line_to (context, 0.0, 0.0);
	cairo_line_to (context, self->priv->arrow_w, self->priv->neg_arrow_half_h);
	cairo_curve_to (context, 0.0, 10.0, 0.0, -10.0, self->priv->arrow_w, self->priv->arrow_half_h);
	cairo_set_line_join (context, CAIRO_LINE_JOIN_ROUND);
	cairo_set_line_cap (context, CAIRO_LINE_CAP_ROUND);
	cairo_set_line_width (context, 14.0);
	cairo_set_source_rgba (context, 0.4, 0.4, 0.4, self->priv->arrow_border_opacity);
	cairo_stroke_preserve (context);
	cairo_set_line_width (context, 12.0);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, self->priv->arrow_fill_opacity);
	cairo_stroke_preserve (context);
	cairo_reset_clip (context);
	cairo_clip (context);
	cairo_set_source_rgba (context, 0.4, 0.4, 0.4, self->priv->arrow_border_opacity);
	cairo_fill_preserve (context);
	cairo_set_source_rgba (context, 1.0, 1.0, 1.0, self->priv->arrow_fill_opacity);
	cairo_fill (context);
}

static void
neo_retro_theme_real_draw_socket (Theme* base,
                                  cairo_t* context)
{
	NeoRetroTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (NeoRetroTheme*) base;
	g_return_if_fail (context != NULL);
	cairo_save (context);
	_tmp0_ = self->priv->socket_pattern;
	cairo_set_source (context, _tmp0_);
	neo_retro_theme_rounded_square (context, (gdouble) self->priv->socket_margin, (gdouble) self->priv->socket_margin, self->priv->socket_size, (gdouble) 8);
	cairo_fill_preserve (context);
	cairo_set_line_width (context, 1.0);
	cairo_set_source_rgba (context, 0.4, 0.4, 0.4, self->priv->arrow_border_opacity);
	cairo_stroke (context);
	cairo_restore (context);
}

static void
neo_retro_theme_real_draw_highlight (Theme* base,
                                     cairo_t* context,
                                     gboolean has_tile)
{
	NeoRetroTheme * self;
	cairo_pattern_t* _tmp0_;
	self = (NeoRetroTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->highlight_tile_pattern;
	cairo_set_source (context, _tmp0_);
	cairo_rectangle (context, 0.0, 0.0, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_fill (context);
}

static void
neo_retro_theme_real_draw_paused_tile (Theme* base,
                                       cairo_t* context)
{
	NeoRetroTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	cairo_pattern_t* _tmp2_;
	cairo_pattern_t* _tmp3_;
	self = (NeoRetroTheme*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->paused_color_h;
	_tmp1_ = self->priv->paused_color_v;
	_tmp2_ = self->priv->paused_color_h;
	_tmp3_ = self->priv->paused_color_v;
	neo_retro_theme_draw_tile_background (self, context, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}

static void
neo_retro_theme_real_draw_tile (Theme* base,
                                cairo_t* context,
                                Tile* tile,
                                gboolean highlight)
{
	NeoRetroTheme * self;
	cairo_pattern_t* _tmp24_;
	cairo_pattern_t* _tmp25_;
	cairo_pattern_t* _tmp26_;
	cairo_pattern_t* _tmp27_;
	self = (NeoRetroTheme*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (tile != NULL);
	if (highlight) {
		cairo_pattern_t* _tmp0_;
		cairo_matrix_t _tmp1_;
		cairo_pattern_t* _tmp2_;
		cairo_matrix_t _tmp3_;
		cairo_pattern_t* _tmp4_;
		cairo_matrix_t _tmp5_;
		cairo_pattern_t* _tmp6_;
		cairo_matrix_t _tmp7_;
		cairo_pattern_t* _tmp8_;
		cairo_pattern_t* _tmp9_;
		cairo_pattern_t* _tmp10_;
		cairo_pattern_t* _tmp11_;
		_tmp0_ = self->priv->tile_highlights_h[tile->north];
		_tmp1_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp0_, &_tmp1_);
		_tmp2_ = self->priv->tile_highlights_h[tile->south];
		_tmp3_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp2_, &_tmp3_);
		_tmp4_ = self->priv->tile_highlights_v[tile->east];
		_tmp5_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp4_, &_tmp5_);
		_tmp6_ = self->priv->tile_highlights_v[tile->west];
		_tmp7_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp6_, &_tmp7_);
		_tmp8_ = self->priv->tile_highlights_h[tile->north];
		_tmp9_ = self->priv->tile_highlights_v[tile->east];
		_tmp10_ = self->priv->tile_highlights_h[tile->south];
		_tmp11_ = self->priv->tile_highlights_v[tile->west];
		neo_retro_theme_draw_tile_background (self, context, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
	} else {
		cairo_pattern_t* _tmp12_;
		cairo_matrix_t _tmp13_;
		cairo_pattern_t* _tmp14_;
		cairo_matrix_t _tmp15_;
		cairo_pattern_t* _tmp16_;
		cairo_matrix_t _tmp17_;
		cairo_pattern_t* _tmp18_;
		cairo_matrix_t _tmp19_;
		cairo_pattern_t* _tmp20_;
		cairo_pattern_t* _tmp21_;
		cairo_pattern_t* _tmp22_;
		cairo_pattern_t* _tmp23_;
		_tmp12_ = self->priv->tile_colors_h[tile->north];
		_tmp13_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp12_, &_tmp13_);
		_tmp14_ = self->priv->tile_colors_h[tile->south];
		_tmp15_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp14_, &_tmp15_);
		_tmp16_ = self->priv->tile_colors_v[tile->east];
		_tmp17_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp16_, &_tmp17_);
		_tmp18_ = self->priv->tile_colors_v[tile->west];
		_tmp19_ = self->priv->matrix;
		cairo_pattern_set_matrix (_tmp18_, &_tmp19_);
		_tmp20_ = self->priv->tile_colors_h[tile->north];
		_tmp21_ = self->priv->tile_colors_v[tile->east];
		_tmp22_ = self->priv->tile_colors_h[tile->south];
		_tmp23_ = self->priv->tile_colors_v[tile->west];
		neo_retro_theme_draw_tile_background (self, context, _tmp20_, _tmp21_, _tmp22_, _tmp23_);
	}
	cairo_select_font_face (context, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (context, self->priv->font_size);
	_tmp24_ = self->priv->text_colors[tile->north];
	neo_retro_theme_draw_number (context, _tmp24_, self->priv->half_tile_size, self->priv->north_number_y, tile->north);
	_tmp25_ = self->priv->text_colors[tile->south];
	neo_retro_theme_draw_number (context, _tmp25_, self->priv->half_tile_size, self->priv->south_number_y, tile->south);
	_tmp26_ = self->priv->text_colors[tile->east];
	neo_retro_theme_draw_number (context, _tmp26_, self->priv->east_number_x, self->priv->half_tile_size, tile->east);
	_tmp27_ = self->priv->text_colors[tile->west];
	neo_retro_theme_draw_number (context, _tmp27_, self->priv->west_number_x, self->priv->half_tile_size, tile->west);
}

static void
neo_retro_theme_draw_tile_background (NeoRetroTheme* self,
                                      cairo_t* context,
                                      cairo_pattern_t* north_color,
                                      cairo_pattern_t* east_color,
                                      cairo_pattern_t* south_color,
                                      cairo_pattern_t* west_color)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (north_color != NULL);
	g_return_if_fail (east_color != NULL);
	g_return_if_fail (south_color != NULL);
	g_return_if_fail (west_color != NULL);
	cairo_save (context);
	neo_retro_theme_rounded_square (context, (gdouble) self->priv->tile_margin, (gdouble) self->priv->tile_margin, self->priv->tile_size, (gdouble) 8);
	cairo_clip_preserve (context);
	cairo_save (context);
	cairo_set_source (context, north_color);
	cairo_fill (context);
	cairo_restore (context);
	cairo_save (context);
	cairo_rectangle (context, 0.0, self->priv->half_tile_size, (gdouble) self->priv->size, self->priv->half_tile_size);
	cairo_set_source (context, south_color);
	cairo_fill (context);
	cairo_restore (context);
	cairo_save (context);
	cairo_move_to (context, (gdouble) self->priv->size, 0.0);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source (context, east_color);
	cairo_fill (context);
	cairo_restore (context);
	cairo_save (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, self->priv->half_tile_size, self->priv->half_tile_size);
	cairo_close_path (context);
	cairo_set_source (context, west_color);
	cairo_fill (context);
	cairo_restore (context);
	cairo_reset_clip (context);
	cairo_set_line_width (context, 1.5);
	neo_retro_theme_rounded_square (context, (gdouble) self->priv->tile_margin, (gdouble) self->priv->tile_margin, self->priv->tile_size, (gdouble) 8);
	cairo_set_source_rgba (context, 0.4, 0.4, 0.4, 0.4);
	cairo_stroke_preserve (context);
	cairo_clip (context);
	cairo_move_to (context, 0.0, 0.0);
	cairo_line_to (context, (gdouble) self->priv->size, (gdouble) self->priv->size);
	cairo_move_to (context, 0.0, (gdouble) self->priv->size);
	cairo_line_to (context, (gdouble) self->priv->size, 0.0);
	cairo_stroke (context);
	cairo_restore (context);
}

static void
neo_retro_theme_draw_number (cairo_t* context,
                             cairo_pattern_t* text_color,
                             gdouble x,
                             gdouble y,
                             guint8 number)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (text_color != NULL);
	cairo_set_source (context, text_color);
	_tmp0_ = g_strdup_printf ("%hu", (gushort) number);
	text = _tmp0_;
	cairo_text_extents (context, text, &_tmp1_);
	extents = _tmp1_;
	_tmp2_ = extents;
	_tmp3_ = extents;
	cairo_move_to (context, x - (_tmp2_.width / 2.0), y + (_tmp3_.height / 2.0));
	cairo_show_text (context, text);
	_g_free0 (text);
}

static void
neo_retro_theme_rounded_square (cairo_t* context,
                                gdouble x,
                                gdouble y,
                                gint size,
                                gdouble radius_percent)
{
	gdouble radius_arc = 0.0;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	g_return_if_fail (context != NULL);
	if (radius_percent <= 0.0) {
		g_assert_not_reached ();
	}
	if (radius_percent > 50.0) {
		radius_percent = 50.0;
	}
	radius_arc = (radius_percent * size) / 100.0;
	x1 = x + radius_arc;
	y1 = y + radius_arc;
	x2 = (x + size) - radius_arc;
	y2 = (y + size) - radius_arc;
	cairo_move_to (context, x, y1);
	cairo_arc (context, x1, y1, radius_arc, G_PI, -NEO_RETRO_THEME_HALF_PI);
	cairo_arc (context, x2, y1, radius_arc, -NEO_RETRO_THEME_HALF_PI, 0.0);
	cairo_arc (context, x2, y2, radius_arc, 0.0, NEO_RETRO_THEME_HALF_PI);
	cairo_arc (context, x1, y2, radius_arc, NEO_RETRO_THEME_HALF_PI, G_PI);
	cairo_close_path (context);
}

NeoRetroTheme*
neo_retro_theme_construct (GType object_type)
{
	NeoRetroTheme * self = NULL;
	self = (NeoRetroTheme*) theme_construct (object_type);
	return self;
}

NeoRetroTheme*
neo_retro_theme_new (void)
{
	return neo_retro_theme_construct (TYPE_NEO_RETRO_THEME);
}

static GObject *
neo_retro_theme_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NeoRetroTheme * self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	parent_class = G_OBJECT_CLASS (neo_retro_theme_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEO_RETRO_THEME, NeoRetroTheme);
	neo_retro_theme_make_color_pattern (self, (guint) 0, "000000", TRUE);
	neo_retro_theme_make_color_pattern (self, (guint) 1, "850023", TRUE);
	neo_retro_theme_make_color_pattern (self, (guint) 2, "e26e1e", FALSE);
	neo_retro_theme_make_color_pattern (self, (guint) 3, "cccc24", FALSE);
	neo_retro_theme_make_color_pattern (self, (guint) 4, "00c656", FALSE);
	neo_retro_theme_make_color_pattern (self, (guint) 5, "005c59", TRUE);
	neo_retro_theme_make_color_pattern (self, (guint) 6, "008de0", FALSE);
	neo_retro_theme_make_color_pattern (self, (guint) 7, "001d87", TRUE);
	neo_retro_theme_make_color_pattern (self, (guint) 8, "a021a6", TRUE);
	neo_retro_theme_make_color_pattern (self, (guint) 9, "e2e2e2", FALSE);
	_tmp0_ = neo_retro_theme_make_dir_color_pattern ("CCCCCC", FALSE, 1.0);
	_cairo_pattern_destroy0 (self->priv->paused_color_h);
	self->priv->paused_color_h = _tmp0_;
	_tmp1_ = neo_retro_theme_make_dir_color_pattern ("CCCCCC", TRUE, 1.0);
	_cairo_pattern_destroy0 (self->priv->paused_color_v);
	self->priv->paused_color_v = _tmp1_;
	return obj;
}

static void
neo_retro_theme_class_init (NeoRetroThemeClass * klass,
                            gpointer klass_data)
{
	neo_retro_theme_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NeoRetroTheme_private_offset);
	((ThemeClass *) klass)->configure = (void (*) (Theme*, guint)) neo_retro_theme_real_configure;
	((ThemeClass *) klass)->set_animation_level = (void (*) (Theme*, guint8)) neo_retro_theme_real_set_animation_level;
	((ThemeClass *) klass)->draw_arrow = (void (*) (Theme*, cairo_t*)) neo_retro_theme_real_draw_arrow;
	((ThemeClass *) klass)->draw_socket = (void (*) (Theme*, cairo_t*)) neo_retro_theme_real_draw_socket;
	((ThemeClass *) klass)->draw_highlight = (void (*) (Theme*, cairo_t*, gboolean)) neo_retro_theme_real_draw_highlight;
	((ThemeClass *) klass)->draw_paused_tile = (void (*) (Theme*, cairo_t*)) neo_retro_theme_real_draw_paused_tile;
	((ThemeClass *) klass)->draw_tile = (void (*) (Theme*, cairo_t*, Tile*, gboolean)) neo_retro_theme_real_draw_tile;
	G_OBJECT_CLASS (klass)->constructor = neo_retro_theme_constructor;
	G_OBJECT_CLASS (klass)->finalize = neo_retro_theme_finalize;
}

static void
neo_retro_theme_instance_init (NeoRetroTheme * self,
                               gpointer klass)
{
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	self->priv = neo_retro_theme_get_instance_private (self);
	_tmp0_ = cairo_pattern_create_rgb (0.0, 0.0, 0.0);
	self->priv->black_text_color = _tmp0_;
	_tmp1_ = cairo_pattern_create_rgb (1.0, 1.0, 1.0);
	self->priv->white_text_color = _tmp1_;
	self->priv->size = (guint) 0;
	self->priv->animation_level = (guint8) 0;
}

static void
neo_retro_theme_finalize (GObject * obj)
{
	NeoRetroTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEO_RETRO_THEME, NeoRetroTheme);
	_vala_array_destroy (self->priv->tile_colors_h, 10, (GDestroyNotify) cairo_pattern_destroy);
	_vala_array_destroy (self->priv->tile_colors_v, 10, (GDestroyNotify) cairo_pattern_destroy);
	_vala_array_destroy (self->priv->tile_highlights_h, 10, (GDestroyNotify) cairo_pattern_destroy);
	_vala_array_destroy (self->priv->tile_highlights_v, 10, (GDestroyNotify) cairo_pattern_destroy);
	_cairo_pattern_destroy0 (self->priv->black_text_color);
	_cairo_pattern_destroy0 (self->priv->white_text_color);
	_cairo_pattern_destroy0 (self->priv->paused_color_h);
	_cairo_pattern_destroy0 (self->priv->paused_color_v);
	_cairo_pattern_destroy0 (self->priv->socket_pattern);
	_cairo_pattern_destroy0 (self->priv->highlight_tile_pattern);
	G_OBJECT_CLASS (neo_retro_theme_parent_class)->finalize (obj);
}

static GType
neo_retro_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NeoRetroThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) neo_retro_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NeoRetroTheme), 0, (GInstanceInitFunc) neo_retro_theme_instance_init, NULL };
	GType neo_retro_theme_type_id;
	neo_retro_theme_type_id = g_type_register_static (TYPE_THEME, "NeoRetroTheme", &g_define_type_info, 0);
	NeoRetroTheme_private_offset = g_type_add_instance_private (neo_retro_theme_type_id, sizeof (NeoRetroThemePrivate));
	return neo_retro_theme_type_id;
}

GType
neo_retro_theme_get_type (void)
{
	static volatile gsize neo_retro_theme_type_id__once = 0;
	if (g_once_init_enter (&neo_retro_theme_type_id__once)) {
		GType neo_retro_theme_type_id;
		neo_retro_theme_type_id = neo_retro_theme_get_type_once ();
		g_once_init_leave (&neo_retro_theme_type_id__once, neo_retro_theme_type_id);
	}
	return neo_retro_theme_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

